package ejmf.toolkit.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

/**
* MixFile reads a MIX file generated by a ejmf.example.mixer.SimpleMixer
* session.
*/

public class MixFile {
    private StreamTokenizer     st;
    private  FileReader         fr;

	/**	
	* Create a MixFile instance from a File.
	* @param file A java.io.File representing a MIX file.
	*/
    public MixFile(String name) throws NullPointerException {
	openFile(new File(name));
    }
	
	/**	
	* Create a MixFile instance from a File.
	* @param file A java.io.File representing a MIX file.
	*/
    public MixFile(File file) {
	openFile(file);
    }

	// openFile does the real work of opening the MIX file.
	// It is a helper for use by both constructors.
	
    private void openFile(File file) {
        try {
            st = new StreamTokenizer(           
                fr = new FileReader(file));
            st.eolIsSignificant(true);
            st.parseNumbers();
            st.whitespaceChars(' ', ' ');
            st.whitespaceChars('\t', '\t');
            char filesep = System.getProperty("file.separator").charAt(0);
            st.wordChars(filesep, filesep);
	    st.wordChars('/', '/');
            st.wordChars(':', ':');
            st.wordChars('_', '_');
        } catch (Exception e) {
            e.printStackTrace();
        }
     }

	/** 	
	* Read data from a MIX file.
	* <p>	
	* @return MixFileData a vector of MixTrackData elements
	* @exception IOException is thrown if there is an error
  	* in the data.
	*/
     public MixFileData read() throws IOException {
        String line;
        String mediaFileName = null;
        double times[] = { 0.0, 0.0 };

        MixFileData  v = new MixFileData();
        int token;
        int tokencnt;
        int linecnt = 0;

        while ((token = st.nextToken()) != StreamTokenizer.TT_EOF) {
            tokencnt = 0;
            while (token != StreamTokenizer.TT_EOL) {
                 switch (token) {
                     case StreamTokenizer.TT_WORD:
                         if (tokencnt != 0) {
                             throw new IOException("Read error at line " + linecnt);
                         }
                         mediaFileName = st.sval;
                          break;
                     case StreamTokenizer.TT_NUMBER:
                         if (tokencnt < 1) {
                             throw new IOException("Read error at line " + linecnt);
                         }
                         times[tokencnt - 1] = st.nval;
                         break;
                  }
                  tokencnt++;

                  token = st.nextToken();
            }
            v.addTrackData(new MixTrackData(mediaFileName, times[0], times[1]));
            linecnt++;
        }
        fr.close();
        return v;
    } 
}
