-- Test ambDim: 2, dim: 2, nvert: 4
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0,1},{0,0,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,0,-1},{1,0,-1,0}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1},{0,3},{1,2},{2,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 0, nvert: 1
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{3},{4}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0},{0}};
linealitydesired = matrix {{1,0},{0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 4, dim: 4, nvert: 11
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,0,1,0},{0,0,1,1,0,0,1,1,0,0,1},{1,1,1,1,0,0,0,0,0,0,0},{0,0,0,0,1,1,1,1,0,0,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,0,-1,0,0,-1,0},{0,0,1,-1,0,-1,0,0},{1,0,0,1,0,0,0,-1},{0,0,0,1,1,0,0,-1}};
linealitydesired = map(QQ^4, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2,4,7},{2,4,6,7},{1,4,5,7},{3,4,5,6,7},{0,1,2,7},{0,2,6,7},{0,1,5,7},{0,3,5,6,7},{0,1,2,4},{0,2,3,4,6},{0,1,3,4,5}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 5, dim: 4, nvert: 11
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,0,1,0},{0,0,1,1,0,0,1,1,0,0,1},{1,1,1,1,0,0,0,0,0,0,0},{0,0,0,0,1,1,1,1,0,0,0},{0,0,0,0,0,0,0,0,1,1,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,0,-1,0,0,-1,0},{0,0,1,-1,0,-1,0,0},{1,0,0,1,0,0,0,-1},{0,0,0,1,1,0,0,-1},{0,0,0,0,0,0,0,0}};
linealitydesired = matrix {{0},{0},{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2,4,7},{2,4,6,7},{1,4,5,7},{3,4,5,6,7},{0,1,2,7},{0,2,6,7},{0,1,5,7},{0,3,5,6,7},{0,1,2,4},{0,2,3,4,6},{0,1,3,4,5}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 5, dim: 5, nvert: 7
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0,1,1,1,3},{0,0,1,1,0,0,4},{1,1,1,1,0,0,0},{0,0,0,0,1,0,0},{0,0,0,0,0,1,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,0,-1,0,0,0,0},{0,1,0,-1,0,0,0},{3,4,-2,-3,0,0,-1},{2,4,-2,-4,0,1,-1},{2,4,-2,-4,1,0,-1}};
linealitydesired = map(QQ^5, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1,4,5,6},{1,2,4,5,6},{0,3,4,5,6},{2,3,4,5,6},{0,1,2,3,4,6},{0,1,2,3,5,6},{0,1,2,3,4,5}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0},{0,0,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,0},{-1,0,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2},{0,2},{0,1}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 5, dim: 4, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0,1,1,3},{0,0,1,1,0,4},{1,1,1,1,0,0},{0,0,0,0,1,0},{0,0,0,0,0,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,0,-1,0,0,0},{0,1,0,-1,0,0},{3,4,-2,-3,0,-1},{2,4,-2,-4,1,-1},{0,0,0,0,0,0}};
linealitydesired = matrix {{0},{0},{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1,4,5},{1,2,4,5},{0,3,4,5},{2,3,4,5},{0,1,2,3,5},{0,1,2,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 0, nvert: 1
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1},{0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0},{0}};
linealitydesired = matrix {{1,0},{0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,1/2},{0,0,11/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,0,1},{-1/11,1,-1/11}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2},{0,1},{0,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 4, dim: 4, nvert: 8
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{3/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2},{1/2,1/2,3/2,-1/2,1/2,1/2,1/2,1/2},{1/2,1/2,1/2,1/2,3/2,-1/2,1/2,1/2},{1/2,1/2,1/2,1/2,1/2,1/2,3/2,-1/2}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1},{-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1},{-1,-1,1,1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1},{1,-1,1,-1,1,-1,-1,1,-1,1,-1,1,-1,1,-1,1}};
linealitydesired = map(QQ^4, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{8,9,10,11,12,13,14,15},{0,1,2,3,4,5,6,7},{0,1,2,3,12,13,14,15},{4,5,6,7,8,9,10,11},{0,1,6,7,10,11,14,15},{2,3,4,5,8,9,12,13},{1,3,5,6,8,10,12,14},{0,2,4,7,9,11,13,15}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 4
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{3/2,-1/2,1/2,1/2},{1/2,1/2,3/2,-1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,1,-1,-1},{1,-1,-1,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{2,3},{0,1},{1,2},{0,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 1, nvert: 1
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1},{2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = matrix {{0},{1}};
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = map(QQ^2, QQ^0, 0);
linealitydesired = matrix {{1},{0}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,0,1,3/2,5/2,5/2},{0,1/2,5/2,5/2,0,1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,1,0,-1,-1},{1,0,-1/2,-1,-1/2,0}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1},{1,2},{2,3},{3,4},{0,5},{4,5}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 5
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{5/3,-1/3,-1,1,1/3},{1/3,-5/3,1,-1,5/3}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,1,-1,-1},{2,-2,1/4,-1,1/2}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{3,4},{0,2},{1,2},{0,4},{1,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 1, dim: 1, nvert: 2
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,15}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1}};
linealitydesired = map(QQ^1, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1},{0}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: -1, nvert: 0
-- Checking normal_fan + several booleans
TEST ///
verticesP = map(QQ^2, QQ^0, 0);
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = map(QQ^2, QQ^0, 0);
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 1, nvert: 1
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0},{0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = matrix {{1},{1}};
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = map(QQ^2, QQ^0, 0);
linealitydesired = matrix {{-1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 2, dim: -1, nvert: 0
-- Checking normal_fan + several booleans
TEST ///
verticesP = map(QQ^2, QQ^0, 0);
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = map(QQ^2, QQ^0, 0);
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 3, nvert: 10
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{3330883453830711/4503599627370496,853624150927223/2251799813685248,-2356553346050111/18014398509481984,8539723551892617/9007199254740992,-851543628576541/1125899906842624,5316837853882195/9007199254740992,-6538305985494021/9007199254740992,-1749267935005635/4503599627370496,7424579411304029/9007199254740992,-6887392800778413/18014398509481984},{-2298030817950255/18014398509481984,7698990389472477/9007199254740992,5054138723166979/9007199254740992,-4611252879029533/72057594037927936,7431314160210763/36028797018963968,3306083656494553/4503599627370496,-5119504026856145/9007199254740992,3819013085252451/4503599627370496,4143898238679627/9007199254740992,-5765394822723937/9007199254740992},{-5952332624486941/9007199254740992,-1596589986555531/4503599627370496,-7361860108925987/9007199254740992,-1402721951416725/4503599627370496,-1397989901669917/2251799813685248,3023262654016433/9007199254740992,-6977355308041419/18014398509481984,3248144300909891/9007199254740992,-1486048987021867/4503599627370496,-6002567455236229/9007199254740992}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,-1,-1,-1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1},{-44579928701577317537651253200841/51894724291563534050210877879505,-15701373045711447922845966302445/15404771123625084781539131855594,-3501125185278422965270696549633/3122821338739084840792883286866,-55228066624563312478254429271949/6621599294598900589652414097938,120142383507582197243199728437381/8084188145793725279203688369944,-111341809240055664571911808586659/76972177657674540200232550278541,7297571300091599151751392189772/29609553812244423504592728106921,57582004016524483838099502969478/151189885071826254692495399928433,-3307137770655639630104724597440/53700167453247199213158679994849,-116803526287883759434174588839635/34580975135927942243574654312938,13850085013344855522773355887391/6818528060217462587852947510909,480466100874886052369285336969936/115034162003927310112709182839181,213433847422687136167242464209620/58557609979467276556731753822023,63412859354020491413375816259867/28996934811782641661107752550115,-2680744756838196321854157910496/10937629307262539547157488890951,-25570123189749367929383738810624/119597613426197722851154758944867},{184914068801775237924440155455677/103789448583127068100421755759010,26933806422179042513723576438601/15404771123625084781539131855594,2404747912716946201299872316723/21859749371173593885550183008062,-7629217969444610664921388076327/6621599294598900589652414097938,-115580771581373778595914316892651/4042094072896862639601844184972,175792615486297400307821108914777/307888710630698160800930201114164,214868202830604470995803376144337/59219107624488847009185456213842,171320946886386780877737144372595/151189885071826254692495399928433,-197644795365060385047253064036618/590701841985719191344745479943339,36007901243263107943040099596727/34580975135927942243574654312938,197756724530638510637354434024943/13637056120434925175705895021818,-656167539362841137132305487638448/115034162003927310112709182839181,-126921990990208440938039562800373/58557609979467276556731753822023,46126130931291503571272729738481/231975478494261133288862020400920,-19191218393050429781956323408550/76563405150837776830102422236657,76024553602469420731877843786411/119597613426197722851154758944867}};
linealitydesired = map(QQ^3, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,10,13,15},{1,2,3,9},{0,1,5,6,9,10},{11,12,13,14,15},{5,6,7,8},{2,3,4,11,14},{4,7,8,11,12},{3,4,5,8,9},{0,1,2,14,15},{6,7,10,12,13}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 3, nvert: 19
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{3/32,7/64,3/4,-3/16,-5/32,-3/4,-1/4,1/64,-7/8,-1,5/8,5/32,-3/4,3/64,-7/32,-3/8,3/8,-1,-1/32},{5/8,5/8,3/8,-1/2,1,1/2,-3/32,-1/4,7/256,-1/4,-3/4,-7/128,5/8,-3/8,-7/128,-7/8,5/8,3/16,1},{-3/4,-3/4,-5/8,-3/4,1/4,1/4,1,1,-1/2,-3/16,3/8,-1,7/256,7/8,1,-3/8,3/4,5/64,5/16}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,-1,-1,-1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,0,1,-1,-1,-1,-1,-1,-1},{37/344,29/8,604/449,11/7,239/56,-1,-232/327,88/249,-1330/597,-35528/30447,0,-19/16,-19/16,-4/5,704/1013,-544/3447,-228/373,-9056/17109,-16/53,408/979,452/365,144/199,-40/27,217/148,17/10,-145/24,-1,-740/417,-6/5,-143/64,-37/32,-170/151,82/109,-13/115},{-365/344,-31/8,917/898,15/14,-229/112,87/32,475/218,1331/664,216/199,216/199,-1,-2437/1536,-2/3,-13/10,1030/1013,896/3447,-128/373,6208/17109,-48/53,-672/979,-58/73,487/398,-2,-547/592,-29/20,2,3/8,-681/278,-451/80,21/32,-1/16,3471/1208,629/872,-29/115}};
linealitydesired = map(QQ^3, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{5,6,8,9,26},{5,25,26,29,31},{29,30,31,32,33},{2,3,7,21},{8,11,12,22,25,26},{11,12,13,16,18},{10,13,18,19,20,23,24},{0,1,10,24,28},{6,7,9,14,15,17,21},{14,15,19,20},{0,1,2,3,4,32,33},{2,5,6,7,31,32},{8,9,12,16,17},{1,4,23,24},{10,11,13,22,27,28},{3,4,14,20,21,23},{0,27,28,30,33},{15,16,17,18,19},{22,25,27,29,30}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 5
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1,1,0,-1,-1},{0,1,1,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,1,0,-1},{2,-1,0,-1,0}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,4},{3,4},{1,3},{0,2},{1,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 5
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1,1,0,-1,-1},{0,1,1,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,1,0,-1},{2,-1,0,-1,0}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,4},{3,4},{1,3},{0,2},{1,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 4
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1,1,0,-1},{0,1,1,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,-1,-1,0},{-1/2,2,0,-1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2},{2,3},{0,3},{0,1}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{3,5/3,1},{3,1,5/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,1},{2/3,-4,4/9}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1},{0,2},{1,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 3, nvert: 8
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992},{-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992},{-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,0,0,0,-1},{0,0,1,0,-1,0},{1,0,0,-1,0,0}};
linealitydesired = map(QQ^3, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,2,5},{0,1,2},{0,4,5},{0,1,4},{2,3,5},{1,2,3},{3,4,5},{1,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,1,0,-1,-1},{1,1,0,-1,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,0,1,1,0,-1},{1,1,0,-1,-1,0}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{3,4},{4,5},{0,5},{0,1},{1,2},{2,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 4, dim: 4, nvert: 24
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1,-1,0,1,0,0,1,1,0,1,0,-1,-1,0,0,1,0,0,-1,0,-1,0,0,-1},{0,0,0,-1,0,0,0,-1,0,0,-1,0,0,-1,0,-1,0,-1,1,1,1,1,1,1},{-1,1,1,0,0,0,0,0,1,-1,1,1,0,0,-1,-1,-1,0,0,0,1,-1,0,0},{-1,1,-1,-1,-1,1,-1,0,0,0,0,0,1,0,0,0,1,1,1,-1,0,0,0,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,-1,-1,0,-1,1,1,0,0,1,1,1,1,-1,0,1,1,1,0,-1,-1,-1,-1,-1},{0,-1,0,1,0,1,0,0,0,1,0,1/2,0,-1,-1,1,1,0,0,-1,0,-1/2,-1,0},{1,0,0,0,-1,1,0,-1,0,0,0,1/2,1,-1,0,0,1,1,0,-1,-1,-1/2,0,0},{0,-1,-1,0,-1,0,1,0,-1,0,0,1/2,0,-1,0,1,1,1,1,0,0,-1/2,0,0}};
linealitydesired = map(QQ^4, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,16,17,18,22,23},{4,7,8,9,10,13},{6,7,15,18,19,20},{3,15,16,18,20,23},{6,11,15,16,17,18},{1,2,4,8,13,21},{18,19,20,21,22,23},{2,3,4,20,21,23},{4,7,13,19,20,21},{0,1,2,21,22,23},{3,4,7,9,15,20},{6,7,9,10,11,15},{5,8,9,10,11,12},{3,5,9,11,15,16},{0,5,11,12,16,17},{0,2,3,5,16,23},{0,1,2,5,8,12},{2,3,4,5,8,9},{1,8,10,12,13,14},{6,14,17,18,19,22},{6,7,10,13,14,19},{0,1,12,14,17,22},{1,13,14,19,21,22},{6,10,11,12,14,17}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 6, dim: 5, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,-1,1,-1,-1,1},{-21/211,-231/232,1281/5,-1176/1171,210,105/1276},{-20/211,121/1160,22,-121/1171,-22,25/319},{1176/1055,-105/116,21,-1281/1171,-21,105/116},{1/211,-211/232,232,-1276/1171,1171/5,-5/1276},{0,0,0,0,0,0}};
linealitydesired = matrix {{1},{1},{1},{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,4,5},{0,1,2,3,5},{0,1,2,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 4, dim: 3, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,0,0,1,1,1},{1,1,1,0,0,0},{1,1,2,1,1,2},{1,2,1,1,2,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,-1,0,0},{0,0,0,0,0},{1,0,0,0,-1},{0,0,0,1,-1}};
linealitydesired = matrix {{1},{1},{0},{0}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1,3},{0,1,4},{1,3,4},{0,2,3},{0,2,4},{2,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 5, dim: 4, nvert: 10
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,0,0,1,1,0,0,0,1,1},{0,0,1,0,1,0,1,1,0,0},{0,1,1,0,0,1,0,0,0,1},{1,1,0,0,0,0,0,1,1,0},{1,0,0,1,0,1,1,0,0,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,0,1,1,0,0,-1,0,0,-1},{1,0,0,1,0,-1,0,0,0,-1},{0,-1,0,1,0,0,0,1,0,-1},{0,0,0,1,-1,0,0,0,1,-1},{0,0,0,0,0,0,0,0,0,0}};
linealitydesired = matrix {{1},{1},{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,2,3,4,7},{0,1,2,4,9},{1,2,5,8,9},{0,3,6,7,8},{5,6,7,8,9},{0,1,2,3,8},{2,3,5,7,8},{2,4,5,7,9},{0,4,6,7,9},{0,1,6,8,9}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 4
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,-1,0},{1,0,0,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,1,-1,-1},{1,-1,-1,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2},{2,3},{0,1},{0,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 6, dim: 5, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,-1,1,-1,-1,1},{-21/211,-231/232,1281/5,-1176/1171,210,105/1276},{-20/211,121/1160,22,-121/1171,-22,25/319},{1176/1055,-105/116,21,-1281/1171,-21,105/116},{1/211,-211/232,232,-1276/1171,1171/5,-5/1276},{0,0,0,0,0,0}};
linealitydesired = matrix {{1},{1},{1},{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2,3,4,5},{0,1,3,4,5},{0,2,3,4,5},{0,1,2,4,5},{0,1,2,3,5},{0,1,2,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,0,1},{0,1,0},{1,0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,0},{-1,0,1},{0,0,0}};
linealitydesired = matrix {{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2},{0,1},{0,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 4
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{-1,0,0,1},{0,-1,1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,1,-1,-1},{1,-1,-1,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1},{0,3},{1,2},{2,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,0,1},{0,1,0},{1,0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1,0},{-1,0,1},{0,0,0}};
linealitydesired = matrix {{1},{1},{1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1,2},{0,1},{0,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 0, nvert: 1
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1/2},{1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0},{0}};
linealitydesired = matrix {{1,0},{0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 4
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0},{0,0,1}};
raysP = matrix {{1},{1}};
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,1,-1,0},{0,-1,1,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,3},{2,3},{0,1},{1,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(not isPure computed)
assert(not isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{2,1,-1,-2,-1,1},{0,1,1,0,-1,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,1,0,-1,-1},{-1,1,-1,1,1,-1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{4,5},{0,5},{0,2},{1,2},{1,3},{3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,-2,-1},{0,0,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,0,1},{1,-1,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1},{1,2},{0,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 6
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{2,1,-1,-2,-1,1},{0,1,1,0,-1,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,1,0,-1,-1},{-1,1,-1,1,1,-1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{4,5},{0,5},{0,2},{1,2},{1,3},{3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,-1,-2},{0,1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,0,1},{-1,1,-1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1},{0,2},{1,2}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 1, nvert: 2
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1},{0,0},{0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1},{0,0},{0,0}};
linealitydesired = matrix {{0,0},{1,0},{0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1},{0}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 1, nvert: 2
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1},{0,0},{0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1},{0,0},{0,0}};
linealitydesired = matrix {{0,0},{1,0},{0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1},{0}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 3, nvert: 5
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,1,0,1,0},{1,0,0,1,0},{0,0,1,1,2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,0,1,1,-1,-1},{1,1,0,-2,1/2,-1},{1,0,0,-1,-1/2,1}};
linealitydesired = map(QQ^3, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,2,3,5},{0,1,4,5},{0,1,2},{3,4,5},{1,2,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 1, dim: 1, nvert: 2
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1}};
raysP = matrix {{1}};
linealityP = map(QQ^1, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1}};
linealitydesired = map(QQ^1, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 4, dim: 4, nvert: 5
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{2,3/2},{3,2},{4,5/2},{5,3}};
raysP = matrix {{1,-1,0},{3/2,2,0},{2,9/2,1},{3,-7/2,-1}};
linealityP = matrix {{1},{-1},{2},{-2}};
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,-1,1,0,1},{-1,-13/15,1,1,1},{1,1/2,-1/2,0,-3/7},{1,13/30,-1/2,-1/2,-3/7}};
linealitydesired = map(QQ^4, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{2,3,4},{0,1,3,4}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 2, dim: 2, nvert: 3
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0},{0}};
raysP = matrix {{0,1},{1,1}};
linealityP = map(QQ^2, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,-1},{0,1}};
linealitydesired = map(QQ^2, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 1, dim: 1, nvert: 2
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{0,2}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,1}};
linealitydesired = map(QQ^1, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{1},{0}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 4, dim: 4, nvert: 8
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{-1,0,0,0,0,0,0,1},{0,1,-1,0,0,0,0,0},{0,0,0,1,-1,0,0,0},{0,0,0,0,0,1,-1,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1},{-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1},{-1,-1,1,1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1},{1,-1,1,-1,1,-1,-1,1,-1,1,-1,1,-1,1,-1,1}};
linealitydesired = map(QQ^4, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1,2,3,4,5,6,7},{0,1,2,3,12,13,14,15},{4,5,6,7,8,9,10,11},{0,1,6,7,10,11,14,15},{2,3,4,5,8,9,12,13},{1,3,5,6,8,10,12,14},{0,2,4,7,9,11,13,15},{8,9,10,11,12,13,14,15}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 3, nvert: 5
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{55},{1250},{2800}};
raysP = matrix {{-1,0,1,0},{0,-1,0,1},{-80,0,140,5000}};
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,-1,-1,-1},{0,-125/2,-250/7,0},{1/80,1/80,1/140,1/140}};
linealitydesired = map(QQ^3, QQ^0, 0);
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1,2,3}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(not isSimplicial computed)
assert(not isComplete computed)
///

-- Test ambDim: 7, dim: 4, nvert: 16
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-5/2,-1,-1,1/2,-2,-1/2,-1/2,1,-1,1/2,1/2,2,-1/2,1,1,5/2},{-5/4,1/4,1/4,7/4,-5/4,1/4,1/4,7/4,-1/4,5/4,5/4,11/4,-1/4,5/4,5/4,11/4},{-1,-1,1/2,1/2,-1/2,-1/2,1,1,-1/2,-1/2,1,1,0,0,3/2,3/2}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0,1,0,0,0,0,0,-1},{0,0,1,0,0,0,-1,0},{0,0,0,1,0,-1,0,0},{1,0,0,0,-1,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}};
linealitydesired = matrix {{-3/4,-15/44,603/2192},{-3/4,-15/44,-1041/2192},{-1/4,3/22,-433/2192},{-3/4,-1/11,-31/2192},{1,-6/11,-115/548},{0,1,-43/274},{0,0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{0,1,2,3},{0,2,3,7},{0,1,3,6},{0,3,6,7},{0,1,2,5},{0,2,5,7},{0,1,5,6},{0,5,6,7},{1,2,3,4},{2,3,4,7},{1,3,4,6},{3,4,6,7},{1,2,4,5},{2,4,5,7},{1,4,5,6},{4,5,6,7}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 3, dim: 0, nvert: 1
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{1},{2},{3}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{0},{0},{0}};
linealitydesired = matrix {{1,0,0},{0,1,0},{0,0,1}};
raysdesired = promote(raysdesired, QQ);
linealitydesired = promote(linealitydesired, QQ);
maxConesdesired = {{}};
desired = fan (raysdesired ,linealitydesired ,maxConesdesired);
computed = normalFan P;
assert(computed == desired)
assert(isPolytopal computed)
assert(not isSmooth computed)
assert(isPure computed)
assert(isSimplicial computed)
assert(isComplete computed)
///

-- Test ambDim: 5, dim: 5, nvert: 74
-- Checking normal_fan + several booleans
TEST ///
verticesP = matrix {{6730902641522717314961998953235/104776506286137515566857289990144,-390280997608381835232697072991/1864397174641101581339368357888,-28661454104902942433939732686875/599213099946195397458372881022976,-15406128800245753276724909349157/30099827352902650724266352312320,-1348940276325668500074957593851/2697085334304636491828689895424,-75141446950690149587759747394937/165616557448512116164343317397504,-4127179246096640907403890265885/41904101308994666459112740487168,2163445037703968508482316572317/8272174879337969639020747030528,-450191691851794455064904918875/9911153521006773458158718287872,2279981434851121779512083749439/17676604320812387688659128680448,-27824252277803128204504832190717/58693645000177121121239226646528,432519296535220584799240474927507/1077260866563456139894848957186048,3765428054130167415452303705125/222125502036585245242532474912768,-10521689461745455177822871802093/85753133669755553209037369638912,-1615106097963036509945373835895/10989631586614384549803648352256,-153859104600774931051039606447/20406035371046271441470712971264,4095357961966490213093023541807/10600428188431546152758393438208,-37556954633350929381541664662061/120997085920833975034182430097408,296286671065291413809687610328321/1053538385342145802784220758671360,-10037572016285418472076457697283/34633413130182945354295273324544,997853003413383634343654437239/28057515132355876009082573815808,1582119868326493885513507218639/8407088162979660786601711108096,-81569316783071114122199918965583/121058810132428827263998000889856,1120789335983075619818326397155/4134944818141064063042084405248,7914014844818656873551204740075/22266590606652141677541010178048,25236149475136229335454327319069/79666744713521896378976557858816,34436819126181817978168993557249/82379817115275568750484537737216,1075237021510564600709996702909/17773044687234827937178204504064,-23175127494363607504616048277949/210988502108587902922675355385856,-262546879473029603707919740754503/1622551957453061927871757233946624,-19280515772323983437962092252821/35728275856999840664389622431744,-218131885003462022022715316659/469355616747114736836851793920,-32956926220711635100663405748243/449227965645187879958530102394880,-995867185257037157829295479027/13278017017308155570887822671872,-34890800420277220429041632861991/74325346191872223061463382622208,4881578075620478161802803758307/43604575931687752643748567187456,-20580810229325881370831876823683/230674452417758719947424114147328,-18559593442819017269644306113629/108009397080680772287604176453632,88458460007120463175689674713969/220978085925343540969004637093888,-37800542459003165953439084708129/195948843722016143991203635920896,758858976223275895833211232655/2363840771607767955197225074688,66614867809015005947115586555/1881417544855809094232601264128,9691421936173397280519865426369/48606240382070450486122702176256,-234129344117733669655521557354443/488479183229913383369921964015616,572772271277166369007899321289/4213292614681816007099019165696,-17725253852189936798796711715609/73625179114097004834733902790656,-2467413306791997788510344280955/8988565927180644761690706018304,-85229655145351274060232228811983/280192885126197765903285898706944,-628404180535349928731333609701/3709936664406618205468571467776,-642280552501046512786290404317/6459758645495573539114734059520,-327315657767793243998783766913/3134175500792059494205132636160,3323722793616802310017784382157/8990617413053070246706828804096,1407830498052662806322035048261/2881077377630623370955825610752,35711980245977968636464561209/10093496863672162882410132799488,-1803712978445146309490912595779/48179111502188368715192056414208,-4272000456244429145286834506875/6149444231630612191866909622272,-1899152396436366206979095160857/14913336393539997612264159969280,-79885633539449837090851846233/323468803175407180235067621376,-167630647380197786990945515144791/657217633371141849077965278674944,-749163246137013580167389662235/1658390490567448669885812441088,-5658485928621560047787578053135/20374235221048913858078802182144,21899128469814271135939613863441/45568617888980620247557090574336,8995083771771060735599094535787/24917620553257582720908074680320,-4659018797769907867302859829157/45788183250861295204600509366272,6182761421693475070225869587551/60832267043382222623616446496768,-95181007750031517664768387896297/141956724170309861478622472175616,-2532845396902464879676112717701/9542449889035840280145808064512,-3617307262047392943548475040639/70268006390052649658190697332736,-74121539530598398873606680775621/192839276433825988720292456824832,-49879226967660407713626026523023/584973119586817781864237061111808,-49522201761274099182019521066591/78952935354379874649010377588736,-14421542476081339814983748532481/53054540356761081813775547367424,667312808131112830515958873725/1695014187846971091419750465536,-551749439197412304463264245357805/2671042971747034365646309863456768},{7965064963571047990661974269879/13097063285767189445857161248768,2229088198582871639444364821867/29830354794257625301429893726208,-1151744064633648628088591931673/2340676171664825771321769066496,2145096958654462396472974670829/6019965470580530144853270462464,-10525723290363199551782593673797/86306730697748367738518076653568,-31881212010323691645997977395683/82808278724256058082171658698752,20882301837660656381405878009049/83808202617989332918225480974336,-3247489166253543566073686098855/6204131159503477229265560272896,-48189951258451377090286032216733/2537255301377734005288631881695232,193422173033721230934552429571343/2262605353063985624148368471097344,1664452692166777604995330538197/3668352812511070070077451665408,-349178708316418480086063324531239/1077260866563456139894848957186048,-4137667214039165408457690077963/13882843877286577827658279682048,36628341422630448695173972988305/171506267339511106418074739277824,-104270031989255405946445474888353/703336421543320611187433494544384,-4287408942114899427190338576911/81624141484185085765882851885056,1044531660056480550698210323335/10158743680580231729726793711616,122870349026601083185477506377683/241994171841667950068364860194816,-3064238193395914605517733535229/13169229816776822534802759483392,7121989971065341008516212447887/25975059847637209015721454993408,1607187210814660852458271891653/28057515132355876009082573815808,5974129575653224600489116374775/33628352651918643146406844432384,-27576546548265815473564379749289/242117620264857654527996001779712,10895075389827495465482092520049/33079558545128512504336675241984,29490743568262358155021760113843/66799771819956425032623030534144,22882169707515382444261727501521/79666744713521896378976557858816,-1027137756604630684155139079641/20594954278818892187621134434304,-33787938972684823589097355832555/284368714995757246994851272065024,709700154888250295073392607591/52747125527146975730668838846464,-228753373493680613220504777671/1584523395950255788937262923776,-11609384448259671752805283511119/44660344821249800830487028039680,4951449166715010318244791285653/9011627841544602947267554443264,-5749845985147907118554383737101/14038373926412121248704065699840,-607520463481970650216388406289/3319504254327038892721955667968,1583274583421674849338627977345/5308953299419444504390241615872,-31391449607091359924774996275781/54505719914609690804685708984320,-11555679008077558368969397222637/57668613104439679986856028536832,-2608701412841068154625078007003/6750587317542548267975261028352,1481586222944295658850823100921/55244521481335885242251159273472,-3007045330251727214901715433149/48987210930504035997800908980224,-108240639898642410653474213424931/378214523457242872831556011950080,2075036137626593180757888594613/7525670179423236376930405056512,-5061705390633347433157125601825/48606240382070450486122702176256,-4515290081362007265787106032939/15264974475934793230310061375488,248186171944610231946489491591/1296397727594404925261236666368,382747169834834998861276615505/18406294778524251208683475697664,-479593785294655215245696025383417/2301072877358245058992820740685824,5135289724553075263003159276727/70048221281549441475821474676736,-13279245757276656800060650422041/35244398311862872951951428943872,30325921334999442226877079934151/103356138327929176625835744952320,-107839038677592866986291244713069/401174464101383615258256977428480,8878203957537922206357026747511/35962469652212280986827315216384,674059909643007544673679137861/5762154755261246741911651221504,6669803676586111336491149098487/40373987454688651529640531197952,-13773573518448295337824773687363/192716446008753474860768225656832,-231463636747097253361586597425/12298888463261224383733819244544,52000938440254358608783646009/5592501147577499104599059988480,-23562677087222900245816100187885/66877175056515434513600230719488,-21660451933343641272278053192615/82152204171392731134745659834368,94148550224331818453108899944373/424547965585266859490767984918528,79665672352385144871400198763971/325987763536782621729260834914304,-4046169211321087859962148351051/22784308944490310123778545287168,-4718857893936659579984888877001/24917620553257582720908074680320,-40123600378327465056037029412677/366305466006890361636804074930176,3966006532539263535186966481861/15208066760845555655904111624192,-61744958048349796754460953041/8872295260644366342413904510976,1462184541536367936666149952673/4771224944517920140072904032256,-517523027417861842895135851573499/2248576204481684789062102314647552,29230891278611954387812151423/48209819108456497180073114206208,-5879415085666183789715223121129/9140204993544027841628704079872,-820259240608481307307693487755/19738233838594968662252594397184,3928915770255929627217575343551/53054540356761081813775547367424,-191861865212527600876268409985853/1735694528355298397613824476708864,534768793649473304007534010009/869480134032237749233824825344},{-3342652359699167139022539790471/13097063285767189445857161248768,-1534665979565667194785895009701/3728794349282203162678736715776,8333638905581478487649145193153/37450818746637212341148305063936,227099350507606258171259080649/1881239209556415670266647019520,-2549189918856456235279214270633/21576682674437091934629519163392,-3391055148694122261161421520801/165616557448512116164343317397504,4126594342041522852890080789749/13968033769664888819704246829056,-25553532659770934830940661851423/99266098552055635668248964366336,5611796467550617950615919653593/13214871361342364610878291050496,9117296580989591680997009490247/17676604320812387688659128680448,-1436234466833322011675678050943/7336705625022140140154903330816,6702309251531395125465372072179/16832201040054002185857014956032,-1191375422275600760421122131231/6941421938643288913829139841024,-3714838494133717175410872105647/10719141708719444151129671204864,3601528570793678479734188322871/10989631586614384549803648352256,4124308810249996578507623462813/5101508842761567860367678242816,-8276048895725174667756567107057/15238115520870347594590190567424,7835751045453304933163940987397/15124635740104246879272803762176,8779360110100023196809004789615/26338459633553645069605518966784,-271312425918379852558854083675/811720620238662781741295468544,-654489203874942421078944987163/7014378783088969002270643453952,173707664538688098341627228479/4203544081489830393300855554048,40011078672628179149395582213523/121058810132428827263998000889856,6476870628947590114352801910269/16539779272564256252168337620992,16348225413394055150040310271585/66799771819956425032623030534144,1412423539468898929430913210631/19916686178380474094744139464704,-15560074540843728627741726644121/41189908557637784375242268868608,11413196293167785450985319588221/35546089374469655874356409008128,-311185536419451160233993844703/1198798307435158539333382701056,-183154853190352416769378505685/3169046791900511577874525847552,9527964545234817714684521427921/89320689642499601660974056079360,1579767994401995619705563030509/120155037887261372630234059243520,-58983201425072442429570396645023/112306991411296969989632525598720,7546869778526812900451591245475/53112068069232622283551290687488,-10854321791226946298691499424689/74325346191872223061463382622208,-627983529694430921828919399057/6813214989326211350585713623040,-3601608239468940029746861235859/7208576638054959998357003567104,53825733865033525595133408767513/108009397080680772287604176453632,-363638222449790908339937182019/1649090193472712992306004754432,-2772896998307541263493490388279/12246802732626008999450227245056,78704501027233941700112017267317/236384077160776795519722507468800,-4441638733411078661282566836787/7525670179423236376930405056512,-1753983517695115260870924084057/4418749125642768226011154743296,-1983015490753760259194503607515/30529948951869586460620122750976,29795778558961735941298899667/2808861743121210671399346110464,-821730522190183876889418301579/1150393423657765700542717231104,43622254775655200789644696661961/71908527417445158093525648146432,-2229190949124792244296451655047/35024110640774720737910737338368,75585774919127201135954373455/1958022128436826275108412719104,-99741781664673517904615660281/1291951729099114707822946811904,6483423107591433836871080431083/12536702003168237976820530544640,-108826859649811573355633862181/2247654353263267561676707201024,-3708115436847593006902357490845/23048619021044986967646604886016,3870532237408438547643378079637/20186993727344325764820265598976,23458458620045304127588238297139/48179111502188368715192056414208,-88963458112695015782697589019/878492033090087455980987088896,-3871980035763002169953081979227/11185002295154998209198119976960,-1112963538455023576784955779837/66877175056515434513600230719488,12936122378001387600986836735115/20538051042848182783686414958592,-13388686370365297202034685008483/106136991396316714872691996229632,687461546063083194339580772613/1273389701315557116129925136384,-25805768785268132047843931364717/182274471555922480990228362297344,3035961123884614377973000809937/33223494071010110294544099573760,16833355465486492538105681170713/183152733003445180818402037465088,-1964970727894378894803910954259/5069355586948518551968037208064,-711541546661849495453097131897/8872295260644366342413904510976,2753469344034912002988429924169/14313674833553760420218712096768,163965830150859070435754838739267/281072025560210598632762789330944,-851477847073082923708235893731/24104909554228248590036557103104,8631081558121231969359032165547/73121639948352222733029632638976,12855502019727594208123394296261/78952935354379874649010377588736,46112584465630507570974453164301/212218161427044327255102189469696,12901935126394094592232124130935/27120227005551537462716007448576,-3082081120485313123433067687901/10433761608386852990805897904128},{-12308668566877594927456986443287/52388253143068757783428644995072,12092521140967957947599219546835/29830354794257625301429893726208,-14083213712596794813343921883225/37450818746637212341148305063936,92003761259524493894298939875499/481597237646442411588261636997120,7679610560756775980194537637027/43153365348874183869259038326784,340123136112772266489599412873/20702069681064014520542914674688,-579058088656906051659917785793/2619006331812166653694546280448,1252597485851790063258510952783/3102065579751738614632780136448,1341426339432260279014904680505/19822307042013546916317436575744,1659762896389895632197456817775/70706417283249550754636514721792,4478680683340412049888900924293/117387290000354242242478453293056,-65818921124676081288586434901577/718173911042304093263232638124032,-17504752861222139751849206810273/55531375509146311310633118728192,14649609555556855783947125895503/85753133669755553209037369638912,5568244772200243418893459174713/21979263173228769099607296704512,4200029788309206216566429766083/163248282968370171531765703770112,958594560982315267324351401251/15238115520870347594590190567424,5866249943065863810320309015959/120997085920833975034182430097408,-184317331904959610807944722893841/2107076770684291605568441517342720,30493121432348587108320401197039/207800478781097672125771639947264,1916735419076947913376569417777/3507189391544484501135321726976,3027698756661366163018180830937/8407088162979660786601711108096,-7011527632143303094731617535407/60529405066214413631999000444928,-10482756091357278639441333963869/33079558545128512504336675241984,-965159233335537536425991905875/5566647651663035419385252544512,13376309246470951690545806114677/39833372356760948189488278929408,4564343773297586122039171452141/10297477139409446093810567217152,-15793527673123056144393926185453/71092178748939311748712818016256,-8221354054328067582757245587123/13186781381786743932667209711616,-2437813634252807701634925328085/12676187167602046311498103390208,-5140406134677040923539796454051/22330172410624900415243514019840,2458042923071639438442846292825/12015503788726137263023405924352,-3789094791399207327344993018767/14038373926412121248704065699840,6257144472287756017976805089781/13278017017308155570887822671872,-25783464512443489029188959979481/297301384767488892245853530488832,-3577775900968243460824476776259/13626429978652422701171427246080,-3225170165795349114600139599791/14417153276109919996714007134208,-6432237948330146725059274949787/27002349270170193071901044113408,-21980387199943016908202571578563/55244521481335885242251159273472,-1312598781402932334774240231143/24493605465252017998900454490112,771757724628389191007802759489/2954800964509709943996531343360,9252093020603125071725395118413/30102680717692945507721620226048,-3421517553588920851685218338275/6075780047758806310765337772032,-8036692178797023757605686441179/15264974475934793230310061375488,-1408547819020415528245761608033/8426585229363632014198038331392,-2888163320153565192792228189619/12270863185682834139122317131776,23666511371301369207549433700949/71908527417445158093525648146432,-17078200532190162108467175815925/70048221281549441475821474676736,-241158834857542647841603800665/8811099577965718237987857235968,1756547047062910353758907256195/5167806916396458831291787247616,3779762897251443412558726104807/25073404006336475953641061089280,2643594180021758600993361882637/4495308706526535123353414402048,7610427779577871392135493157/53353284770937469832515289088,-2356843676264837408634841390545/3364498954557387627470044266496,-2177432058634588749259083610997/24089555751094184357596028207104,-4665103526396426826200607265355/12298888463261224383733819244544,3201280806535036264196416067891/6391429882945713262398925701120,-161410608806950031197631073443/33438587528257717256800115359744,-141494208217268747366687361844545/1314435266742283698155930557349888,6021384781784930924475174971111/13267123924539589359086499528704,-1655063961840823909702848247403/20374235221048913858078802182144,8988879397989892264729788732879/22784308944490310123778545287168,17744240311776549859226518620683/49835241106515165441816149360640,3438262254087837165761280257337/5723522906357661900575063670784,15612377421943600808208043925621/60832267043382222623616446496768,-3256399937752352010456499227899/70978362085154930739311236087808,15792262983678394082376576142625/57254699334215041680874848387072,3811510477950869497280327681637/17567001597513162414547674333184,-50068557148236607658434945148185/96419638216912994360146228412416,-13800659133274797838172586886319/73121639948352222733029632638976,-621573735873454894736962112211/19738233838594968662252594397184,6030553951047768716924652303703/13263635089190270453443886841856,1105281663047271165454543376475/13560113502775768731358003724288,-4674699382006748209107495645715/41735046433547411963223591616512},{-327090633368046710171817382863/6548531642883594722928580624384,-1928047323478650571023557651423/7457588698564406325357473431552,-38234825510460434284189486821189/149803274986548849364593220255744,54747255947442246721669274435367/240798618823221205794130818498560,-216360402801461882898321272223/899028444768212163942896631808,4566015640403201130497595752895/20702069681064014520542914674688,-13909016036490644168562640661/25182753190501602439370637312,3141853344303619397229010260155/12408262319006954458531120545792,-18124542204482580065490405959935/39644614084027093832634873151488,-14618519850078241260678126794613/35353208641624775377318257360896,1482277437748954265127115941285/7336705625022140140154903330816,5565741942240903048049263617465/16832201040054002185857014956032,-19316195528464694586189049558627/55531375509146311310633118728192,13226066968572548015649946813/24033950019550323208810921984,-422274162265081296426255910799/1569947369516340649971949764608,-10482044688123605201385002249193/40812070742092542882941425942528,79009004507382614075163551839/5079371840290115864863396855808,-16351177517542272701364681898109/241994171841667950068364860194816,7726833739981561283835420578501/16461537270971028168503449354240,-9577766025658476406273604205847/34633413130182945354295273324544,3806812011997473757560783794885/14028757566177938004541286907904,-29412767781422284820792927730351/67256705303837286292813688864768,453393697925145878680721718811/15132351266553603407999750111232,11084083906989750041877375683/2362825610366322321738333945856,625915513667224567086643593015/2783323825831517709692626272256,9276379344889143309582885882551/19916686178380474094744139464704,73619022840303847331269059147/1287184642426180761726320902144,-55436741810449693628088929205/85447330227090518928741367808,17918628642906192932714862944827/52747125527146975730668838846464,-125315512742708073340229170281/198065424493781973617157865472,-6829019627452042968832442503237/44660344821249800830487028039680,27820155563622905575970201135261/360465113661784117890702177730560,15402786769052944015222277137987/112306991411296969989632525598720,-3009941685238754566062742757929/26556034034616311141775645343744,8441472729460510318066805448919/18581336547968055765365845655552,-16813803054441753609274960402473/54505719914609690804685708984320,19037085525017915915875680386053/57668613104439679986856028536832,627836482731444500857295588945/6750587317542548267975261028352,2335964884941219689184684227051/55244521481335885242251159273472,-26448241258577331568840314535005/48987210930504035997800908980224,-8863733085185177392277640807817/59096019290194198879930626867200,10918244757363458004678526681627/60205361435385891015443240452096,-397534564754024870790283002653/24303120191035225243061351088128,-39405774445668880447962453644741/122119795807478345842480491003904,3798321395834457122561332312559/6319938922022724010648528748544,-1025485779675473928142144807117/18406294778524251208683475697664,-295767610448657779564284015499/17977131854361289523381412036608,37253938373714922339479386493781/70048221281549441475821474676736,-1310013180864663971210484602345/5874066385310478825325238157312,1485082796732771939007534744163/2583903458198229415645893623808,-636137699796072280092797278787/6268351001584118988410265272320,26243836625394543169050790180455/143849878608849123947309260865536,-9672532141615173430492521223657/23048619021044986967646604886016,-1041222262092852620536555515131/10093496863672162882410132799488,9474362114689639953516487011965/24089555751094184357596028207104,-9870434576839988586954657496459/49195553853044897534935276978176,2615880358783174991751526209/6172738573485098349447086080,20777384628099139059579445752377/66877175056515434513600230719488,8171789141744145496993783981963/20538051042848182783686414958592,16147102055873167428354725952079/53068495698158357436345998114816,-1466999801344784960215450971011/20374235221048913858078802182144,1838616233596830228992213630619/22784308944490310123778545287168,-3049329233826455655772343254479/33223494071010110294544099573760,713752394277660764529756261667/45788183250861295204600509366272,1086316353360918510614733210983/2534677793474259275984018604032,-7961259621682300617364187955299/35489181042577465369655618043904,885863592338455966172965004989/2385612472258960070036452016128,285107274827231882339149210485/4391750399378290603636918583296,-13095012353813071510715969444249/48209819108456497180073114206208,10514190166624570382995689741163/146243279896704445466059265277952,6685455902168210414679764080331/19738233838594968662252594397184,510783025398787368764031926989/3315908772297567613360971710464,-7206245859511174300594948413631/108480908022206149850864029794304,-4782249048013131528346721170603/13911682144515803987741197205504}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
verticesP = promote(verticesP, QQ);
raysP = promote(raysP, QQ);
linealityP = promote(linealityP, QQ);
P = convexHull(verticesP,raysP,linealityP);
raysdesired = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,1,-1,-1,-1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,-1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,-1,-1,-1,1,-1,-1,-1,-1,-1,-1,-1,1,-1,-1,-1,-1,1,-1,-1,-1,-1,-1,-1,-1,1,1,-1,1,-1,-1,-1,1,1,1,-1,1,1,1,1,1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,-1,-1,-1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,1,1,1,-1,-1,-1,1,1,1,-1,1,-1,-1,-1,1,1,1,1,-1,1,1,1,1,1,1,-1,1,1,1,1,-1,-1,1,-1,-1,1,-1,-1,-1,-1,1,-1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,-1,-1,-1,-1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1},{87895433469963268234129924985414434386853285691913145958704582928849304847905011237855619625663605882214387176816384415524031340228485769251/762173017218125494559443003060956130033960979271945436580285488319580546189671455565433113101766752068836394475903370524262861988270401562112,5755308015690165098556341442614388437393942347707811162877912250601321173305719233955984636611542297889060615924979116176274228478824869707/52569191805033203197018782409894891349133849114279138730186599680768280269626920682310630199861945361835400668727543524845748036508106059712,-211220119453143906605316440984254098477889504072380708289132398531865706408390822076181451257169995811771117109144018506773224754386382966699/991372666371880981130280810066216112484656818782329025191322973621160292992811746561486343993624793507702694268214993030397227672509576687264,890043095105425856270580791754893810669182151665899433327752456143196051328229821248639340409051735661042036833495972303886845371285274529670/1343452152598916679007774471037722437179047399835508707808728288534551328972891141616610287216983366589271186273956581261478183219539289689947,19280375902724365154837895417099416213764956278251029040419071807607916087042356649179314832344936503310781961419665004452495769630797673263/28518523150245032711577490661675225014146314442772719597431974421710783646029293232406465957443357037151215856322597903362066749844733282643,448857549753941380702448299999704619377011740428466823526573021412845223913983654173486702572499089841806271835760993583452601555433376768842/499300928557199164242030975800660350359018448980879251695598680500384659575681902525786919086455597564492294350445307552668374725120098363287,202600001575004448582894685380906759303312417441282648925614874627911157914873794512648881494358638571164927094595108094262638992393734303284/162484713279943965693217235890603872484262899071804458454027025279565512387697038237717546682802868683607788374159465773099479122949826126865,2803530668226748291185807071750556333973551266708283194591242319819664277830518448754148888706742629129499190086743991833772008446305287216128/4234907939976858267164364737662844486843021264301493258955111470464378387915597916573659956211106275123310303759580692924292703314892400782769,-3175275362177494353455418509131354031753330054381471356832238741953539211257045344567451350982012216434630856378095164952989368955730939852239/13678133526390011373643571527243329239781945455687492462098120036046383392998119736983114785215360127078289462926793357354218680609492695260444,-756337347813986671372899969942592928303117145434169545065985748414658784505900574010411283774696090795033062488109274530289441405790939441239/5027090221758993992993726244466118181807331367438271199017281290118083204144555411938557539385568006644787216394541741970811092044348002907692,3634077730060354788151340438810005890299441566021760618320814268721117888282474492977689563854143923139433943035270861867815072563074538078799/6624319098148169728486987394090540423341248588550062286898282696305204313591501042245448457279849366493356201497792046644638778915431590319768,22488623455239498964634561250775135623964750181059998270466152046880117948886388289787996166562478198424536530817179519746022169247839120695425/61947409266988367706940583109256946977269564013853663882525258456070275306380299346012380108572662295225042477731339196906129067910703865171921,1855575684628627973780046836231985269761427519030907601280533672254046568117359966005927703293697354650054388136430882717534189825181739396077/23492477760381795283431368533586110043337492428611443679512396906316321840705778448681978943939603889536516653304827264747896386127578938172316,40453957388561920305477529409306333106588101482660197589591666139493240400279321849503905305325842706755314283690638353062497141578081597970261/70804513287868896841806005373303775129352474010058489733760785924553373249193086734817491376119585370845978241850665504112904980769914691994264,16423216483695081487529545080388471271411847271075820758262081091171218792215939706732509539889118162607695098567878961776557458825010520229243/91954810542927178959477412029622837025377310040103370710261485561050814678896585779597951200932265268140505390908041126643508706469038102164728,-11452190571173920639397659626471890822511504601265137051198328557026807193407736922514546362726659950739920441302356994823003978769214696480405/86178147473408440165863300690811984402371271564966257088252072059674953183137145971222574430536823321589752469963307967527636065719281870960422,-13412906647785732539526853535569649911707849134014336329821150355678964313015122649155151453513388483129351834670898382225176249022776195877075/158936636464161854640268779248469143206192680356267870632783433158486584423030033829505763536164237124074268787488330363873429249554427132573068,-946074187108350899240901817626565066263670261064788485519579178366939163840031717179544067982740555080469361458970344096418674043330554467512928/7098429957929935535358029798253342714162733953979245353015671395481333042994726090236587661250901769358367197374200226029833931544488035316964139,1780070804644788958658019628953129681367082334628353201145431616019959794319544949066185260061239510727044674669577590157918817945045273084927576/2337967303944368034369893084378245233965562714175095123775989274977882342371438357772173566935866582541106559173329270649617032501967081606193681,94320305284260440550326778586254418976909356369672120663304871749504920849771808967558668591370229263926404882378914780935152907962283341031808/335887043615910985377780469573984162017193941445639414540090365696258853512437272786602588540373430344640378185175934194447439476235837292968115,1485953867163977022058709644012692977376829320225377099501682218779192665973268142375930880159835127447769979028047667417576803940824338048936832/2499399215304518112254614970881207317953314405217128226944035950888198940165163038636229087888784911709082265777771803607027237643983323966583231,829445814743541319576727120132856738940948833795716700850898947325236364067567957779631103739147104673289675822741870877811744574251588711077/9522121730531002670130574101606239681658123653964538034098466257006632281898117223099181972482269523689669316442178461148984453420083451324580,5132034487578052019646872180909684745791766013362220176201467550302073992400256034764424807781263383211941728030294329037066776458495959060119/33478718847070222856773030417003751432909310347842263608059273689224382569269799640987316022403764631531986459647056001249623946090905353733974,2541970399878229925829546008785237202824326551041152012729606745862837629942184971242396123788618990900487117202781903881832727967579666629002/17608948054502074545816225129462752751890984715980038856909492677276884697024405877977121179698639632847151748627931305671610667717094296154565,10856053654224980901912001353611578422150096710697717584099188106884885526257190506223122979168606480162409092357497215709508785103212610233/87359409117828130294296477984365297535122521532389814590508563349591384576427291276686481471065239541977621602679042912597865498307563861440,555276805314310581649355930600149597095979054046362753679194528414006488921694362416248098993594646949642544338027809711616868511082157198592/643927176330282282906853147365938823373720613249482198008310418664334553515570133928310068318856867020226917260586525738252909199601817810745,7254536608291517198491636739908194013742711115841418401815766914904602462898732812192183624966791496424704291321049377829672217688281387601152/8157216135986461000023542974093573373916660861882648584408071359725913906438401729374671631354886420956905510290604658648590322805831167974407,48988859161675121713379652913829789970938504936884379209279758908384931528590671716944589731661805031625408867727223265675641901807755204864/52769022303790058234718348565988018958986266130020715839155415150835577344372468686647870925841123738709703158420657337073593086212280077543,-1062327181050042664590540009606909187203251432748267650880665182815635111147047213378912824827010600873667688984705608576086476283159389272673/17380350614490166062210899085637641017166591787329851384067315359294018575230322021277597527031969235952269846062199640451397383428679064841271,4237541599668415517994690038662905138922102185334739078708466563144141930536599592093859815146910127119212156090834640657445730448121671700005/22998100842242539518732123755997033357155001955346942341090888405815161819317932304981115010447454412333370147710678013622106328300674869932649,701005577035922145658637871473454346869098172645622901290580134676092800496412787920651664085103695093768504384279447006310788078672593496369/3382728944426837427641742771931536842697286554832818448193555028452078562910105314792315751376289421124934265298763213616338670559187204609849,22421153460912764049259995100491039709322268699710777510626704542703070185138253039708905264867473212854615840060719886486968805346866415967360/68573862228088365515856191761976748357806929243760512640892711782083558336926689642791934655546521924329942582504352224029525523576402989019391,1630844000004996022707023435165767501989268662907168382443346479175139646697982483567426489041890979789126154516554897819789007097805343128320/4175120277652422616349514524941856745685488813029754782910664272420080004518739633040540578283395216620285502529509713742803498884588375516269,23040528602698794176726581170311005354269040656804538628006241372144832276752381879716488250779849854517600525315159979742217150908124582492921/31861699021245568312335036837916542544746478771105144975750899657016272646298057030169611285908000050532332723184898880329480952413651576721804,61330173251545268069920454682888442952012292348248967929161582935059692881074592212332311765376777386920721082907266358764767568395732108504496/104248574036737708072171938996897434597966829668509169773951308111246965849312130869836291564814692019536293330264954723562203871074356957886579,4385282428666736156384698210197896644417708048985602371247822971412167963679478768072187202084530222297076566146868911703447467443375398726071/53513026902078565013578975511494854313254351571141904416113904719983173345574994053157023519637857875641424469179320676358153541794853544387156,2250987955805298076314950427726442489678312665541236087497175725041142749191622743043449759405367291695189750167273796414054403452996952394713/13210908703668021049951195825704129343701416874708700910913876846604878996672561109405291951622364787768181929282167065866916832290483763821993,9731141975288618709440149212784625388404148441996437469169091790847225237102025896896965800857346359710802716207644663143146618210256306884728/29232818692250274663992738101699622344049321856124077006408059621775306128513424137906965364651834958076179058872713070844412847661151281164675,-4242601116636338954066736994531289146844729161498764451789180376040341509868692269711235177624115311606705483383878928464923090791829739398396/44704021559592115190491896006044939839895626324505439754356178453809959746369027090641645339495343633131183776897221119202356253683969723916353,-32903611558551634172215504678745749092749551401320101695053075260279574750463304488366717438154492265796882547021968567016265475914926431357/397294985291123729719228218875775266657145060817681956552073759710882040781010650668026150592680728708919474050048660709668400415029831171451,-3275463113250432744423709040240587873900387390287045669123728166796872876500999124294321113162725127987592864053233090892733037084448994801436/32993318393628161849051221382680569207578147359725073876363055606307926865361169575935834676528131466842570259459018451138962390951622897541393,590957501118483663576460050583032271622793176515778800392595819131578970437272247951469308820828822516839182942004208185598672396319070356868/2326416304231355514498047392617791564633670367064862039758812216772377154122876053142451433898944234456072177951600352795318549045157710939257,-1437505763167579123346192515143198298636111678836034802874650049087969289628717450980848507531220506716371614213001794737262442560246696719619/14723167889735304246783077221762656018578299214600549190168697599617922170656849418519203071826007544149219123614179112643940412627183061656163,73180842357363716573062824958649223479484623541278472350800317503997647156678985813988284198196179070931048861356955337927073284283393344325/231241596732867479430998405918230997389749824144847565919077031537005583727163815863009720948581198166288858282613556876669893386339544243633,4143661568942169531927599869695718826941236302857094600607778684144760938988229378576399130160391343859367673124097948685151172654577231141668/8390568232172214491324910277022361716852931201000213148890613245427998672569112710860475736010430126319934474081152203445058004959437131618221,1660907054504671748004140678268231389207371709413229397984575125193853891332868582748358420256670519981764807246713808672648231946689052369465/3105289391536659613864272269782135008746456586495606627045543794281504094471503542456426400307353299378943749191490328902977793149935212793909,1407468146904103776802713975629264480766717635832245219970531423506126000499099259731649833717384330772440982649720418632948870155683310279843/2617069372475053779142494624756434155590256000927286451078885256192637598588775441288556502153677606826764474649883681933175308541249059746796,36716228648591662644931450280668477097553315122337143518164938735324490089495673273166562040500528577795794754215319157401041531394449157423728/60936056959026033461059760034469190966287691086893187036026045823806564516480923020561483410625430132168245952991093269816005153459537144347705,-47034073806854094990800147506492436301976332568089630989660451910282167548914138734428563437966161930303269938109597387753449366350056644531/192419135722059605870863193957126061495696769926808261581770816105349764682809984561011228583760874741151854578280744054906380732487449147116,-272642977051710864368504539609023495386914574523438960216483159057134753898288738659444789296322446306234372880453472933461795070657447861526/1409168313992133016171805275246110494378398070682210067114299235587844889339056005507505541488599562344978635414352233045917710579985559398293,3865246633993103454957447985974994231609220732955184001839915634446596100197595974100564757365127535544767848522839773571141733486993373356272/9623315661813732661132399391473993509216556191527634142151213375194005945068216848989368860537978489146797926911089382551280721344413063522621,41549599321806038248207961049640598975263914621376550981933096332080186503238546772229686212514953461806371170218272476718349530566169134721472/48632454378820144643890882398288938500833950004194969131498880071363467345374567560528135899204460163300436634135302882391962634136706839842237,-207394768924047923907118790044942327728546287238141242712013890308651165096533140324432827379460455029620411640460478526646845744199714799156384/1374087140217073429962153320380218715261806701036593809955441246266588439519795451188664257439431235809565847498754080051199301055246998492073039,18627276248470101533401399170756953680466858169311556637378660668234098799252868744607107998910569360489386937090208180066718408595464831596624/49396106479013760619872160861680012595121155495809942514885494495218658169910517504420065577112245760828584940892000761152204805950362273848721,602127552244024823447173393963043517442764760976158897665452608671222931226822481739293462828573984674546337006140204710568974745822605330275296/4029124768502246430870903410738518009840517816972986026489837744518631453953369234010680090977789047823674011868727926043429956342659090972824263,-263409239265222836003355944784135882444442127614357836460559017519399579043782165632198724870385648230441231824117232202070915108293926063198568/488665203331399114309628242747368596853407454392953685940549782437539239010526982139139662173242973512745519248380931476790036634391606555534317,-36010875578280713706188627714790111387758858529830607813869062364022353484088943030721203559263291838822824010973897819299488131797683048971192/96258971789799378706620455211789574844972465382147614085560820893777389445253724424826158621963504182464200215582970955089748956578881460408463,4880489926640755240475632632560859886464800907422376203561417326589669148570786656563095122405860141945309891081712884884954121772042497789808/5425395396362901630210565585515430409149926036879079973230777503005936336050415662280299953390328410145901394885547275286791983770834762716337,2195389561001277981755996488169511124192812345676263828129659765692136341553985665130014287575697971368287762455053508677130457583681051142538940/1772674914456007872442942993634922073473183433161666321466987835141425243016234930235517404542983477390629897211322107965996266327994610906040587,486467471652536088216822474317385792743220863905269379015496114510372807942379729855935848247242711237802264424797662875919339377893250977039560/454551393339753943081798492455930258191249739580623780952527586143861875547032222399752981188320122199857966630369453879156723695730367500947313,-183679320366911128697117780040580529162901065458371381035095684792730562112941581046483547858749436233435616581945494707769506351351632265500008/963417593696416610485504379835575862619684248699765591147058562697478497328853260222156835465485188082396755940978972728159448789510977892006253,36227027869468554377693440083373510073621995427006623677922788497797527494031195288874539561262608038317905461077253395455497942814661357219560/135776896443297688562476641237506318575979935747262972206088946208133591176597071492914618461986695431505608158200756737812570852203751131151883,138243763084935043328987685142499973215203449496760458607783052129187162195699188036600113022292229993508352468682156889059446799914087336034308/152735353255649170898115890651787096616207531908779634306279586319895099008217264442511608798301823017179773871937166636069525776931663634070549,14998099339371877519554565109691407035498975648756743331876508303222733832667189351674605675823149845046938963085138134637289879328645919005036/29274301345931801194247472103016772513042969356967210227219630930389018567786902899114193727646296728168845535504413482136080898495076842310253,1987956390031396074403850504330140710089389234714055719617972421778567100901124367052201311345218876724781654679084192967948241871697556987056/6560243420386735745875341687280954162952915127720153786047069409549817986403650414409353939057445943187886359225515824290867574576211744102051,357240349019049098836882327012630541284908522815824076114140956515940580990246201901964178231672625027116658085449717648393012724864605670404595/167229250362436415788713047528235863653120672787640540279199235764646859709644637492100557753335444562132119488142112349788140582743548056425336,13923616402040739008257983059442841308671745173781118753888049191949454129243617865552537249553567685043327913911560830943434200475749680155879/12787565925930333209867389749230463674702985063089356926568617561799409897173318711055634021018013962328770254186076606847324191178738411445400,8976639066446659717541021053578064419235461766367161952735288556398100200349072458044765892756710254326755942212855783434038982838057038183719/13101809818757972642941804088226456142253030763288191312544310192519289078619984963262315428371599731316821576322126923571577557549585680834018,6231583642728688065196454599992494392362759143290061789518111629828313017252601680297685494540173223354214601566071433839938072269512774244616/37623040919338828885224492120368949821666404004276121573240624436296787578199601602109723625758409652981537787240523897072765771568705392631977,2591610819393990424069502653218799398715763766228342107777970783481617310698531766385388180657551480752721742492867902600846603307628934580523520/3215078369693142403836601762322679894499900320094908347714555062862805956613813617700922529043486039356868849742013270761527089338033600267699141,2348062761357787645719294025802287543751106725590321947716817581399241038480608666920912946839356408891228068594767385610747011898102566943868080/2471297312797322425907286452168412440770850317364035939506106352706753825066665383023545184383356589580830028648341641360834530491625783105294747,171281378864051346597985292352262423424697224978739222869259988277710232756236194104028841950560821848520427745299580404486293136865744966767200/125075051813803994691319891436525563090857012840651861964982795065378530615457681509829564299010498232761160723534840731555924005173320863195963,-26654946034861748620332946074349598710660846650992228131752696451904268940489220538384818092135741495177745377019371195266233622824742820515528/38682144300428907872237688048284800293724968865669368566954245884398906444857991205562923854876701680017696521949372302871891225398970537458231,-45246928813870361095996942972808479198937458222619140149134727877193199821286150467318606345270445231020867072655849608694509222572373319542716/64962504017537856489173202245559062656341505053426091383826429237955930135112264483553249183160677049089885879289329496534104561728836182786225,-2313520266512147275060576375573639111610911730443805256363760267109128401185182572860237517011614265036675882060085030770823570249864607494592/3829339702743153288522529419972053696206093742234902021837647712747837701227708673107838491063113253507169614593510065823165545352882459331619,-6679320943445502698276688934251265450764322832075221458442147770175936538255559082734832547486989838050425088354629725324745863932073337944896/11552859869920799705906740971636365400900944526052409226615551265055937602068048303816325479987393673120996585049122602773350891259115982588083,-278400199391450761669069122182666523403031196656035206463297270443368129406965897159047194790852089501184599438253019806085372839237760965912/1706069634964987279899328274109048418470194605354343328987181087770745569296777880730132213823760183629496936046720049113482199047072599706579,-42609362850134728167095121023589617767844681443099877045088549109874882285349569385939328941892238575798556439051558115998051330993322752247/347347218666540117569026141659219810349062869183087687866579574172537930784060188147904557806358441746162659523322386868347688915687199243660,-2507795376500701134975321657544401224719426819225144757131074286261677954486525402861140404705506231183030409368549461103056906993632282641584/3893079236405138422076914625057088466939759285948633377615350950848381394531874354832678725098557279035096131095085940255501055447736366260851,-31291667834976047095335507766051247265786888956888672156815557161508304313772929738966634776980279948330888307716994694373131607445550665485328/49505275562501263522635086713964404766499832300600897790689566259975737711429734544818055514520302485943091102897508967360666344177870172005919,-93077336587446754686878793239408979297482488503632311271641152286110641866383308535785307529709364918883756015115596804528235700081787521466/813737592867482282541981383851034298820904152914163147693213102568212167587038614332633590287358608057496640595191098547451579890948871155771,2182496787104300759089122327251408530700528050632679691486431894662426536829299384865494347432933018623276917416553777230386884000575283842303980/1112202000708725030995383762821475559927939711600068687443007538101067399271902439219145558692871168328073632082898264293408907683692661767911239,5532936175449616780627135331869741368552032644097590522921066969669966182559601495637036325631783010991566162410249581537619660391172910841170772/1213842023072313566172207963253544432990874674120596798977861644083710029502909979342656838848181878142244070719698142137074905301931115527786697,3037617685156687137752268160403140137921191609511227191971924163333840526271652921323395504473235564478942314914461983012703770853280533658963372/789323388657875740165452605554384587869090298997334268363316110899147255285966494092757967714512419010948438115583715837795747325769200187545855,1677040679940045557935043201664232266378018015163880227267895392131566004020034417481194052140985076774500269942195875548022152134523951193090410/599085100259234551311765841164609490226997768430984984054344612310273142676159236160387735655048085157964435438502278794275395622043318541085129,214986444454438709766859420593693571767274568803811600791660312081920509427826574115986086249475934359382417352072100233852214570333621694989305/68289795482350467367915948858098452367897765394818962938736714005243441727825231337435573079372454549904220454708436030413666487176454301636404,1406690732644833705325871894123655880101600167424988228357520575826973530032063192794060673545731226062292052039043375543818314514440355362690728/236888262733926949726052207672477396873861070517565992831544953898420231352669384906293437238226869948535198359014236072987081871772943366223509,1635078113749943582822249372854466358217575301750945549582703765677855423492964456038558452493740888310322508661426154865273345714655488806666164/386378351212455962680246177300535804935311473921500875846923203456582371943727540702775669795990219714828491468011284602166164119040628075783327,79316543186199850101900210421502723231304228646307407316009253605220959716135919122289564121089849051122020380528841413020035841543578984679136/17561755853409903074649009245612193477902390222275402495570029193558881699962516893701527380683467468340377370169462799010800822169878118258489,-7777444659531077346578080118831153043022214317998166290386897021609738214259675582248977651536028990337931605505404686398600181119096643225552/14269416970059733975224700669041195163036894330346063882142194573521864456234747762513383612739796246514731365137196876693992203789642968463289,-847701623016607682142891347640578398783102747977921484663667083663894801944875704932464381861609346781101922455691569406514336389684715684272/1472568810494361720804805751780217971012407697516076423002442113610370513754932268688559643584427397570662635923056880940841480640413397084063,10191184948184268322987938281652094345194710175013393955865867312035118408556880936473345504777235115123226080962299044418291558062774162232900/17229755720664574570719128681885259282393993715852572556935455043770220731341149333176540183369433531108194383895330506345631572125793432416081,-218347897167586269517132182662517690695152418483313022221210497937381770144261260172800850791617012001053410671156787219593515688722000990853040/601830168862194073185893455144899807351385545727501033865914049899540720275429386661080678599806944793050862506091820397309586195849430225383633,107297286724925558553291307320661680804394575506354731234355151955472555154568009195663903480389869085156152662824967385307136185985681356936920/50557503885558718810211066386688511987423812710772571038872772688968281813245743637706036521632313749335763096103608112636331926829932145246911,-1023643096604984555473143504377780828093351785098641805568380602387881368711877976035313679854726861018504906815957805606281763119816518471664/3854500976700764318667584532197169618223106800592291256174356586427525323011623313759389150231356884366814789938355612863059120349904469683969,55436743536835947562316059985272026219582548552963301919555899387025021116600607010126584582405766068678033846466894656816761422759407078284848/21147507908710755079707333527054756016859404433585338293410236556911185614211220577260577077574579571675364586843242243814743242353813227148527,10263844009460112503423322912437299196750197192146535157770020445699549099173788378607500605879363090202604034315528033342096616200271770743596/13550559431430238650872848988983282993196749351441997658230699269892657187801139709290817794896987613267263705456620546190894169822045841051781,17731311399484905406876321547379699444682310853914097422680943073501729264861564821105605181260797037992882111700203959479594259008410087600812/23959172792297302718042538514699265257559407275039186863763321341457629754408024534178677056901716879571047148874368863970292804110507397214961,107294970753086327932177654788778643819124032687607543968516703422677571047397253159756826552428806816172706126089072630730804740534407828544392/7787486218465488869918654018779231984180144000254570935929036619386535133909269145259074621212689584734698933093344141254036973054402712934073,730873897085043410021426310961507091899329043306818470012546468111687953944987661700888812247629049292262058167489018275787094459037879653135296/291518365024289121990583659711457621063627535591788438950481115300204316003139671648507339806403400408826310221644974339019269989356218774521499,89726367718107787933948757942975134454434899430611112834733888509604796850387749428606961277516893487520197046193343783258454685221872674057572/103780860749152062818500663534820371042474156171199320581354303868997796720605310995658550577931932051033117363054167122014092015186847423976141,4322286068259150005521086805572230992207550818264046418557626157389323452449345096283863374922220851776031308659524517470916836464175460760688/3852447635380702054268506285317218336842480783151912336788518334734485901208717267945074997391754752651775217698179338609247758120765653889197,22302191278261478694461534812495572268459379686091312923212854569367150888686496278919646599480182222921078518717942641964865889739953777322376/3639332072536688524251946896742940256581480062845391815670462514538501729374983642994334357911801463094880431178644200640643275495852099998969,688959801519629503242821459623167176408570930522241035011619730868625305329861124703001423327358564055383296455157641838288315707176562658553816/139636200618454892049121748639260692263406381907136204136542941836571696306935422037659524097060945911851487212856918600341581516370263544759247,9904950937376753876803480984474849748333063828178025945554985214616371091299651240683011487230109970520757852411583659034156363021541735603180/3316299498590704200241728740702945590366355272176854392289647951659797252634927469895730592294646210645507160452767293761410317261440221575917,23366739174001340875629985681420099007391338915350431077985390562831220312879640370941973401076379350989428964838816585482317339589468840256431/8871709776604947147676858311638534575996402803493573474464407844528602654540375268714971854842291907943499230185823692133445855203261207009707,2374917735922636917388692997943480247586940353621903058648904773414765371729337897330300352978148325027827744955954314659234508585040920529488/883360901756920925955489333645216810283959852439834029300269190553166480189571627684220832178754023283824156871924438037378745538868760584365,12111234308524756907529915781565187652611166365545934991677556655358835804620948064083695530448872826833064753217493339487695568743725234265254/8246224653744107002048169694448246652053664533396017873993315302740726234774693469793193579954462296643520649339016133252286651915882104552803,97725943078825811320499469252656689563261452663797032019874066358951248772942274330088256576070194345979782018978750865158412153957825302111153/54400936455802208364678205823704083560650262026171717121747385305521041806113207609343948455224892578980554105910907570848274117268740096793696,31995215699827222816039368656539410545072124634146577004964684786743051708592540664592076509454817882135898226881605989030249226170078156217081/22067396344220126614427107694321099729863974102451824694697557680288358952540076748577763119418540377087551639136927969917066501826619039225600,1166900742809208892335531359793240049996195053456930825147082224083000918934186659974078912831128228026273541823750006769462328730741374187129/653052123315396157542857675320764064721219477875898488956673836903369660573665017502429233003715321160310977573640250787037320308482406380890,3935223724741331566183489128752000379881275845294855363016427498758394001171325494250513514602397025338715993078605705666324065842113916907528648/464372289720569584714789429674115418910841311661084427222861886982398503065109783302505479261280641516304471065240458288073932419364095222575353,7269907145214962565350567806402627491709220011310988724107723535281474372745113092112841199643526320250564324868712300848627716424025110071998/4934565425870382029596379450297293790384618276944579607666191088728984133682538869114765197569074679314759811225377622621847112840279728030425,5583843983076214445846102518957787124763175197285252625838978820029873094412863107322418580348688388398635361984184724640521792491147540087913/3636183036625464773508287746634002983964791231015926169708938533080938864637993562590786527661148930446823967730203497060992241806107628713066,11917132084019872862428616288660878586441087582205447405223783080019489589697007589714383894051389483048987264332735477125949434108695310558999/12996761799198298375322244646520438625818217853783597851327606536839352574468107074695194967150026911815705038230252012226096228130962736543175,6341788183052209936320616244736958244112436992406281365159078976295784447836743098904398184815237446253431592128586208779161475552632243538384/9265137173579710281923017007599243024875788897274332847735543382375036017359022025673569506745121879570403585180285944333094490980783066023615,1688537522295865616850053877515758545500522726102885322988799865205433909777000787229134391794757433877386606928561421684781128412905937590448/7963398124698684241252364694394951543704867963621644064453955809494084551476890630043377667031819241377679620963554583303156496811852725966073,-91211104251365739953935845189094383226385090138369526698680772094601376469731716869452176277396770127230214870063221771355105757593083381593888/109077838690589961788519153009302186393590123116147580025015186706224160736657920230308480754342949370171919155571173381316388114450772691438639,-12129116926299710541820576075340801115979223987240385676055671333225727869224263416228040694450765650235300206635826877859297993892925460316544/13637692825768925046409924353609620314034460834763875290420167917853574128314848178840901073512106619475998684312990425775171116258901412738967,-73960234644351444801024520741177467185604128409400320108794076440479308534023426552574531343437572920328195186802273336341494721339927923812608/262831181202952128632441937200145810194724931740040052619833946014179296426255597017262444249988450204644507566922623349355378355051697305423141,-7867440833864140982643928718969093839759336823460422283118062957368906205085149845319547953385386872092581769283271961155082802592710536132992/18305634187741138616874142178830350560330807317682700005707430836824401697049797628104427512097493339275375136033784877281538671831389704816709,113667739965150961422315355248587325564141648572560690676669736162490024073087342024696767479124440528559230473146796237517951787502191367008/1140717180311719181386760335925735220486488503833674865682462981225137492133195483918446721830079560065563514161429445217151643579241233588657,-59261497365709768072294058788954479246318299361587564409208083933738262970677183042158148356140777953559470669800485342009466763854201122407328/273077850014099585662988531716485541168943249351012429831137102531451827498728929609838720350769053541193974519900899841254809465195742053202119,-1436105159842005640844933486536736304818681340184770957228648870073030814287871789524687092861597493255121375028787339406155477605112436727168/6551324055504242383413607697974047553400835223855536415616868142268203864241069611606219679179533504624937671906849592518975749522277699716591,-2643040418395327902596076335579806932524244497307140152133088879670844829208856516920961629486978575558016746094625552126442564632459625047424/3602096133505325599757108604720598653965625746159133709904673870123669981730161846576170122132642440406805399993820575548808559428192498213731,17783010562224032680436070145813472953401024131947420675847068842543495433741223726142762491846517912859990777497119901206044918413301097810760/17050275941486146331903134351095794882401682961684376203990378013984528073547588710937899580879491818311241884225060934141508505909435035278769,42801471994916956437315862004045953775893077260897900239806200995333944177454136727523518625763396728673821793008323156555737992967567688104440/37106048210574294844875198045982315873526065226384380334132820553637005676829304357830567054549842575453964775395809100995302761535650533896689,1357715817841564841052822961047206529087601140496257918905348895799027944007975802385186094454222515478293533018539572018472357674521568309368/3873127371459753181300423888876176498998087089319062137961770929960863979838456568705263948019607978924048005409319498897832491759934133776055,-1664352205662752078201901486684396037999398392716533425224208060279106846145753933319761724767258333996235356752719671301625334998967531621248/18304594556468900655881500476054775241956422112468133751010858414990749505107286719451334395539818964977256804214834591926322581961451132932639,10699687669379994996960703705620361804381342675631918509275287342438014936279420448672216980043917251253633549308125146127267158932864619090688/23356260232643387583814747141912597114598116705616651938775326484568628040926249878646593344232843098063475364761792151103581287974635355152273,317640232060705880950527129419478004553774329823489882773974382701121779146702226641542774263944364690060061534736407266004403534709905110398/177998441714009666326596579188876725881489511677097365704605904711978468436963551430333421531500960826667062927640617864722776700975431683529,-3029910476546673575433297322629197728175989063923757943340487632510973305600796092846666107664733635068367983103782615787393774138344409397250/2407362916571330418252461838258675555899202372378979606040899782398492925530017236727667957018663189615504866827546450981340315591407140189509,-83564920937758305923151103433027278592932053822058943570681318106243393746321146315884379801617276601435239592228798112373322142127838565056224/67500020241270206667827226849054202014119047983526789344614159027557409136441447509402533856497094136844086860194421802332566556693507206763701,-72742722598734497977445832380546227327701089835549099066653678912911126390840885452827656654943542359958249011020632764685654027730771075811872/49671630982215244142591016982456269616123301752358770768293581169071354639277387467734365022451854884905822990842656489258136028826494484290973,-20631787423661158747725203191567940048086429185286010804005617457570126721540277279842548068002882726752063806905545027357430812361897754166353/10421592638415417197727410387231372110695500978185955056259685859489557714157305286266160873558777412351327727842623958238694805141939878149824,-630158457314077912663278218343589112768006080939988894327316561827528402870610422325547078351830057506243159557471890240750703482622645633977771/281271528565740004197091881605784185232029497013890081004718663578090761601152231370428936410825619957317467092321909567469026277147998244425184,-109972619745416923874933440270658807289937613610997107389649015696136750894574282305767504077757941814029793598128061428626597747576722358300549/42149616418943658589954917642763889139364504563489366371999179740591726044313250054171500695247690879052040311860012341660896894676872304919504,-2000426026770236765604544010139798337152992856254017262401119187939046916503968850435124504625839416153170553151078470899447089207191194419555/428495362601720519473020212279361667283906272722299230207916040889968610140232280724437077325129384781230320953265363486640571338293138208119,-4111856107634957270054442133348740987686391104504447467853957842124175660429984266574853231382888694967171580918879049701438947481298157763605/896868792754830344053398213390166527968537082197850359321624852017391676143242777063596477046194708929561056549382509172655347487451992835066,-72095141054129858431786159498675889382591420459089382011753946468949362690213700973471807278658075648584534105278102918998906603939349636782953/16110963373420360633633927101759870845942103161189798027014634079979434881842820347104669949750648130545024947784378135953937693365832951523455,-3786503662658332275928223051906688776440869277167907270479017203193789637781367917721336177267980227876629588606703754163686588808174558723262/583315343463468346251439154032738781729366076626300772913000718722269991478593486803995928449738619703334122348109553159173868378372514559437,2360398548285130597098950822999902785718878794604546599907979158346640308972572850030272736865884394197908209013584752953549918329612366174080/2265909639673245592876458300611473847896077403574213121743718404197968178992692629259199417808218274887690407589786577542964834536034776056771,-23572715043711233711980351432493009325662832067617576540756127305463289110243929635451636829793972032732061205118919034208840045874708494390528/234299403894804370937121726037468340670176748362784944859471922454518889725132222228224624300314626284727319345260249532076978337983424591601207,660448861176830035923897953399750554829094297287529807969256656645466929783682098360597768231075660118413294143732297954286070868155847522688/6141302417993900719328078688587085628012916920277738238270103187471299772906950412311974114693901375324103413512487645588808863451911364646929,3457802037765769714923152682884966263718123906838472527308141437462484850469815326024484432940937398610042662164666357176197002624769643758848/3394131462916557090710949897382991198775938878183878159412483197620149960148856184616155687204734457106132788110930000445936706150591663246255,-722350650609980806600389372763094252680581877269935655335100637993556168548419988225622730304743223856291689274413199089438533859001466562432/7617644558644676225666074541547101364742751247645670208185712995611923853004554350582021949811650438898110883568911361433584734770292915152315,-5812118172019038763242051717499806307851828487474942147791522439316994326554678512633259428911703170762278045858728832751253842574807979437440/36699682880770892078183506379087099297701089164901896385297331998832523091037966649991453151634760766357331304564016618494830409728452836789523,6461968215592431559266933225951729342723199934383458199001985269182465938634345426148094062266926814481496416756120507454393001216761687712000/5818519086256404971552509452589712097133776544596017389206717266513772812951952632148299371020756776861821739133378476529738673569792588799103,-90479396713566559212027530491288517622509281007250776567248748736382951391966962163556096454520242079777190765406629612816758269242106877350272/173811246554619480568960412225937393336714227535441454109079484262644271613362929942310611289938866814001190849955901889605320345826323957985753,25890379394063236216160009241870411294063918050459182633152802754955431112022260672431654994999220578479026495662677816707621923454678426753/515961660885533598891899313977197341611006066896284418324050286975790988587927970266109678792399799962533459741102886362438156950396091682182,1792155428159415425035595134920951017793486703236172630380888080969537990674096730869386923436064869731538616067580259878758846020081667355/1517517158769736671322417692782097181522806625914242314361718098105024192170753365405820840783205708202929630802472775526407327753882019457,26880529009893094431505777428762791330947661293634709772089066149866652157578894013451379265836705317595136136604155445217385097914344037787664/15542689946665469694270942598400151224489523491172431710907540958727019330823092035348995117657927285873163601502207512807813909752089424643857,19173783669511871279260196049109473165681934374501267734636668586065061487511859539089537114185859954074493433384741649769525544346981935039560/13409852101483985355995977549465285170422983542757782732325690760953578636731987161690117626817301492582234040783108563326146930112425541017557,-20780532005764684874906112201505771555858843059556754321119130368329504600918956974978291409033365544037378580398956389038011685922111449405846/9290209962108012235663871043454542726336361017548040967572679717301059340330101080192601759147781408244649806605282116722341143091472890349935,-282214432996439893802323895473052913116017514676481024759696682428969373229147712615002342223616900488432293623492882641895580432774038911347/49294323277473916068096376254789718644147499539788197128419665608393965692324647034070542519411292896979576412306036917246600494350145662176,-21412714136907300264677299301636437370269618261286983635353937715110635068636307940955336133684789588313092556973932008373731284067114678532/26661457606440671833546573951445889507566957256874267665174235308123413606525826032388832538952843778131602895962188614138297100340503884631,74719425802381184508890110792108660687491831418876481865969225053251026866109019907486928422753941555019972125760716197995730067207931028/78239818377572609354324330203073550108439734050321906259783201019705915772846871089702403291464452693554043013297515883249801606710674911,1793537644977436615260854330248914493666926401685897109793674902156696226637607948749951758264010473956804160674050904314031166645437855576/887494625312507896950859780629697215715685147217133987557584575480163031855024024201323479004900104100703922907750303618626060033618036199,240675513037331826162953450044558023611293968121758222600860278322526598573248906572734034256089311535286708961234085295135101091240815251352/52685642891257730836399071182945503224513587342685870683414397432448675112289137620786033449310441875721118506606060988474849758600123516591,1952401011396842705059916660619029856997000158843914197017555831339689742909343415682830737213143918577687932328778754372005870803142116147/807551817007571805678633878919088038895589998502741413350818420352233431944657057754682246722119324894609633369364159038950009701501777586,-5462136157799516987401257770465244938622319081291743054071994472357727861451307966862116243011163582208589804272314925964707305959301001819026/97086368045238900838813337219295441795410494004831411772322231175994494828127325061940430166082762999567483019897924270976361769205844609125,-1222357372351241469796971591878171001987401633079858520486111306884763356374987425675521303274205760408291977208377861281733948996024344939328/30711891941687681711981947056012834451477549050773388063644024750965282621723861757636307260717639638488494530450075533208798457546123975479,-657181815376964499319968015220695926946787090445598262348755107062778922695515278275014134175772446971453526014084803234683107356800839922496/123838656364777004299730215678671348992057814558259628231177730804204384947751420680531423266127538950635331676709162312484604798450149092647,-19963492286380224011784851541721148356358718149408890872415921657761193527275853374444764809887187190373374306624601661547382552945262774198208/228807701220394122717118900646793593241426302224923738451422507463537694072959031636205179058072560164564831956117922746368928299530458460111,-4238874906476578648911299892823237890384852496278039461173852725063394000319917613994646103136473428298565939093600339344793883383580950983080/332743079949254254459110637990804098769770308163242944882496682764470003358003614117229975298326354110443165108189459449061343588238269728249,-68368604936351709092279473391671439333206751294965134351009141903042097279408717746896703294204213071250657089432915092799043388193921637309632/1112400680796060158764704321574998507014641553948605792590450036338659883578231553422220916661059436561172670266750910864609349891981571423745,-745391298280169248887172839331346139132638498480068734525885123939240301984003197555649250769441277949978467299014022695420039632089211884320/138063299609204232263883026768479812228052730891570295291850939170986695910182190465930201579522850564594649825182706070889925698350185639197,-28428409813183695735229260324448346606185195055339907412093637949027637189566269149002540259915319368242111266000522602382032517157617291265824/2776741146112394898686654637009760368062925195841633821257548882382004868979671315961350711538194852497797796902158939374944299464510381794213,-289665897942603530563694815339545323678081726262984271942952293821352096315642973565681599226398194277396263346606131105338532415754074814464/106917406642657897868391369935982320935551227406957489982787421586743085718455800863666817515835128053972199211476119491450129817090136672103,-1703888466076572367969102069500385761963203441951451635487002507934712005957324743908138335143411865744823286213375241725394430119589664788096/343424347558280674143253699771693605601420070752249794814232658801981009033355140442898741498505380947211803908352256474567626838376899384067,-1099875064978386121994393705136575982116037710076701567586146107682864982737521667191776732885487537744957676690676599792635273887075610869643/327862544776643080167540018389049138202896702656045886183752470720012892990705091475043278710399265420526040825600438910747279093164842500546,-167973183577528804758043195062295847497539568300631478140284691034685508682095563160592381937985047923757819714805743991854444930384614601136/50964344032090449122596317470788687019561519263952449594386919424774315714127115597474243707631680944449273148961408151480707796138266747319,-3488494721464351550288297187557730164803823659750084697404410295916324305651177882413164593470180170830567735900001841826711295775288081188696/1276175972425627350965439509687445943430935799206072875525016876102322760913872014293652922122055327147057959460819323039327173256069531354843,-6813584273175320277699561307017607102572364622311674930915715597765030218568938622143814760397459946336636790393948006168771396828787301544/5694092639068320865862936391655364367905534623318396802631036545582647963193962924949888799002813503443070528010471046934395671455960545291,15215435292599382325402820625149621193864328622842282555587943708107329655388461249683502147228528027870742749996481581630855080855011456223/2962935811441440619891401215146154110413813352851032193803569816451847521763514301394520621558659082492195776107824239614681526992987332899,-42383520191592755723375846941008784910933063010652798187466535882386958364522954400324940742805656806165595537952193759951791666810757110716/8408780730773052847771384706570294611675048881053019774732932633088497037649302554756823063300147433781762114745338643004930564406342875633,-206411783773269075571743974053679801103926411276745755586909076287352668819853290087533351770939242610600722271272322740209075721110086006298/32701817707239355874131514923909723183770399253820671840611422969437725734470050554753233849284903414103757145484867163640705944514568041519,-31703615689456931221574238109607878569351475043338985909896271467056070531205326538381787584663384098961423660875017153400561933172387834917918/4552094779184476842489223170267672317670508628241094722015733332082950644015963125058225249736828479474831277481753999125303440765964361676079,-90694506837197462544419629791984333575256354447907514467058280592566530566200258447019857886923624438541999307249999636509060845804092599663117/12465425789714622330718503330990034349537896851094205769055953993034892743927745108055677656974553431887383125319726778101204177899772402368384,-207997361547714348003932223355617170633364600037474828678380593887969965223003969291245806038976994385135890795716341829401276719279064013272543/45438488998191131927240427836643124213765476727113036576130994345324133392684517808372557604880827803284671303505460219455570276786963106233136,-153475575596853325255807072618182240209147306554837780851900840481981379527105691408015176797795652897780708197377145193036769108959949803936180/51355179674368847784776508756045849907026942959443691189582134151410712480164299160595906505951809460638646434829709839007427352954193908812027,-103686478665096840233449617568696934029243671632630873583855740863262708113870315658324201164776760370505651362212972709290498205501764946319139/12400554182635155791081502974299337794024411791873128252680075524691576061960875708894897800679643505042030957429956552081785521719255300599008,-22434188533129729944443925133951790479899097499087578084300907102931258785382609325148635769651896186381177646861754374613096452869105684611984/13776699698415774191204517184692197722804372189243075780822473769176357017071571783302958259404722559004792868629401478851648943202613134333091,111654015636819318171064523727572448896078729496939972594684435718546849463279676966074704924763478073450310582800032352372915768442658096042/42076110250123310145213874601119358853267501114984383874344271639039765731275608413463822147554683047153554869932680181308254528283099287049,-4947310102040512559872483078501545138521951103409305122248383220748750617757453365902986523995506944037478718551876398843109193023308467303720/2163660671806953483760727351104805856146894916856567014013365300448141304777064815509103541636489957277693991657183568843309720667267121428741,-398231035417848331977290036312329532296555045067794533227586498435404932377232144350818888240417761219678473592719874188177986557080659124059809/33302025243876509174161925836347406632315143840734240939304720043319138506000522489717727879751306317871151180107772410397388141524382849557248,-2922071417086067240439753120676148529309976259881199264888537915238165342014871527326561199897028249139014523167967281332254742972299995573025/882149560368883912890650038758183085386631122579582538769841088820548804272646667721659342627267473052126454849150218978307094049428037192064,-47850423923229644564105403776143241737736532347800857491974426974103254434856900985302745468027677903778762396595888304844742157754245435585348/6472646946167899677656603095622603602168029734864328697166073163914946953686572827963730521396569623296434640540789739465068927316465094462155,-274065140733530897351927223256513232187850204652732450315707668895262187355037068459337670821373985805282811941667503205163260508812202965651808/9639529764876602515157339905215122640681760639525302962187255813538400035791531070129382727139459634523482712804991313079617170665272743409975,-12673070016630966536099533524150250611834485126929926732840213323803007762560498833815461127831497190215074860311138833656544866510440108122560/2914303882679868419242236722718907232919335393394188131947008831938776882271757217031325940656103750106469546841725115712309173685967006823603,-375159244791782100895973897917887354545160135852785545961286874154022133234968757742868871165868265857955794778123686040486630778129924648753593/32704446440134894552162659921291831640618096924394139975845397681097939911820096745775123755871832836539435230757394818986779102889052659884416,-620412999566760988103228553948240473508718189261302549226250331704202108283940351100714009804481884439527902042075962759040855993298744463448/281966151208827480269932326744752415547208293995736710938086902738982035667718864596324322513964268301154145717790690266898844698147269150197,-2109846385428229574365306941545773337576863718906517103909588843786644733767362365964585044939804182802105548860288737545115520177214473698/1375136786272788461205869527996183542036407597383651386284208069336474969621064781909253487885123766888651437787710734391762621106507981261,-82468395615300414532025547683603332951254575406434082680400086811572719173456483617132132484175473841545077205026176536310745733923508417768/93937644431575545647113811340896406345756440374346216399769919619422947225472343485474729280819934686312991218743463521315983751024321931765,-1087206044338337422009592972726755902209773186855051171987056989780072250003185000802004935488009272602948045383368790391700006102896916654/1039701258304079398411907990883889252306235244772966055458789461120154379364782808856492737957719782877035264175141129572692477769233570111,-1437291487780829255574368908018326526489815250939943314398430785184013021619525333055254308465537528729832841418189508636320892464112806374862/631001362372166469248612312271739021335281801616146648242409607781489904655957900690324817027027341060799020542100245237721572996280832511281,-1018718248064840326146820617761093246747232347678510100422025864686063031199903372170913293981465102794960523767324981930186532078049182798272/863710298510529042406340324825919903484082015977300192264310580815954800817860176895176917783412816484572236418222440280595597408123172186323,-146308111907569930969844984721683731628324773338525974510644502724521714738237804688589690435420456389697328339326393707123196813216762885241/52681732041217933643792538475145978958491302278352735189357887418274691981032997004138293366784478687636023275909339842462341540041122654788,-1683876538747326574496986775565159148429451536930450395971398148690845988723560389718034173481591325513948945936071953329320266300395358636292/189906653277104968198553608275098154837758533398953235669140132120531040516975059117152304318135943831317396372890051610166624802033280231029,-261142293988159537609898058035626120696745817251125675471187288641879041462261171033665820059120999788710044384286950823857881342827042655044/225704818916195762007674345279257476219675532311511824484796821793234238844325407971110860980354591374960636547101025007539203530019592096109,-34441038415664834576047271794495474126530958841760084107203240565548344571293587826460072403114084775223749733080663330656557049884719270550608/21033786404997494205318500940315775565742199431625291715264632540857288522811464552177449592425566992895002838839644624207923040566811068987975,-97290749840875544176615803398112975201518265062681965058477573768630184947655184502258715670024034840222718625892895509971600579419258963793/26025636833375127688562800529286118887596251582827851266438076332560969036507074355692108477906754084260965899682904988944100834930901795484,-36581098823428929264773595486772474658920343090729974796522090408721692834164806131723989024664220607462211483595699872698636308873596007393/14920792072438231711933517204237456806738882469665565343814696918836170650373297403166888629945514064534000419659659176627851638631192886738,-14577775205128675778168126092900732994136894147574586530471014347343371798396491366911440636964284464486666072344919055833524028745527537437472/737510672099579671572515244764608535999470528337060026550649546046964270542180883514335994020584209207195867206334799246110266652390419591071,-1211197914625974266494563305214163239434348424521835654845209884965992224189805683728570526294835924177724353894037687586019660594901797153202/134078894999223184755276874227799102584292863534563106199259294534815775574576422655991461425723853735743465847366260988107801826895139865451,-196512445326003074339569141440153054126049087282023380405844022273218262596761447067139211108164011422069123696388573974019142933673700266084/8853695310906317110292414879248615984065688392397094528701168778088296559555675773320881902769792658130166809889718863942843765357219628395,-6313035524348866653085124578932013708597567474444484069286069086317042365615897686706726522478045719326501588284628150338613951686560684448768/438270768413188118587551878050810070032113579900923803959397310871446080694636513337983867998145988647438488903610740410156987382977842067315,-37422018057028506058569006424758804487666902796434086429744498612116358261039586942454319916106102723672440383700386049543847380915291691124/668696740332193134773470949755481965553457210033301086291717266197326696236076345283193717003672687354506186442201503936765662039463948327,-1083078450398676121139439327790224746346423476038344803350947017033289194897437691334160727313004543054661977119995863025917365136315472894192/16068556820204490086748094609623042976713408875432002083303664751305182077426909544663955445461605829510889427013408536912449201530160218691,-65552599097238223850754080436013574332611124363019770470941043509042128371647285813818296803067197176910277093495773426852006746571688093344/7947612398014547383329401438039499731887385257776602445085546258302292073204667610984098453245703545692362532591096906135130086407385703873,-207784605088722908495734613569101503947711460980376052304491260569123323101515884356249546888078242657410959911314801184344653881148169870512/10332945072102827903887475475096074673295631603635189932776668875745075385246621317904026156414990116475770443689857582662100565065118875965,-20092561754423107578630561908203506499009776607566392701041118093483616767648006307856771253531485507220229234735482530270120988707932099120188/10614262405351745894765881003889835423258464016077662692497630610061593918373846535978682403778921426532800574494291071882816188651861979094871,-21604571052617342512675885967785944693558042738695994656075869415697318187398783914895365964918348255815022076206942918467872661928139530199296/15836069533997721377847690951664153500598828130491308299319735090426277516553846314541988900872753944574881866434670175599110710131228479976169,-294359078080578862372242366054263300727251797297292393390629226558358988450343828193237279410291886417452504829494976637317045745729940188546/317607593185518773947845274651700627812163682347127673330380981336828729137452026376410199682990891461079659957973083915435283179833354078525,-4623336401443027151430609930847303575282000427255809363067090925041906832449612886812399273424200697507130208602066447513698819065517762062/8051198134321079099974300179507964099446830104010948807615004833478222387152467552508316950329536786425734686755138720116667250796868486823,-856393666451970430076693996665149779501998608909497592793919886349591537999958617824850391310419870970585725764524497166856345846855788547258/1097638851360386387320310662618216086991863389635574297870867385250120309579927620380667620508743385983109774588127288378871013916227865769019,-57526844643450927407431380519351495657766118558388082100343564379414371119946347352978701869442026800817355442908276861926516699073976932338/28269928695672478847043862183024139273242212583459783382890709177649833685878154313653935833091964023631892679494244272828157018169990985209,-21849596121523126247425971118871122377128342535288233162280598721406595609206028624441167915712467925776713338589575702931217296665764812313920/11809606923585102006108555700193484696681833288665075812058049287068270053390144861319951972387464292017128784435249502220769555719164059801727,-2335687430998100222780579064659190029082022114871451768129294248129424945999479769378891717620261556133858727879666625608324103986436357895232/1267199718596307935215117445433001733958256208158658008632797311259409719105570050893878094472104095639644463058663289361169896632249039807711,-8290269769121331390450368841539936778831562684549119964959469109016750198501933701961727962636591669359394544179686881553711744616259117378801/4221349769623939250473732954339857094786544348244987172770312245838263489318381550666232490981221030136282808936908650713253884057956794801296,-4586106177068720760936826708672742890649322741138520950120411871093321895623830427343692686554630545765145110201110250906220583895680299216449/1836272747253764000119367508896111980366528395574894440174256912637954495305448635671645647918686341983396607496450204901557161491738103225624,-214039036926481206570409198656243098207124253738978919507391235781045112197889462232839668086329182937393744651581935573525004601906445443037/6574672077149611157580905768780803529850147921959111840171850775235995556782706893738231029851899566805680709159429189729068104785721575138,-446290273326595290770693587216242131869771145973551932363514938663366919895490835719288188473324774726006349151579907554611516396242289982798/124361222108020482774963838991065804941353667433136449658791145352129071353230430951545549761290266774603230500336580422711787873673002369857,-26564148773962462304459943916566918570232943936835837316484836241466097896801160807724208774634149104264622739392712700681726195943585162860417/10960314506725305533485166073915615569953195923397293742674101928088158578586559230160211803750935027839283020255031715264617731019797250438745,-10776743964958896886012550552334007174169443302153000113807128898296166699403098854175534466548454449971133936976892964829431322123641809962928/1012247467158620035441415418353771806647448294730802016386732993749602474360443888364205506353226101042546355697505350493975065544755132129389,-14973469757039926668618380517693433898984982206468678594087263235505519065832746056064386601686483572526755056765255494398252854050832316949660/5069579902571923735512588368596540834587309791965691646571011482254508469001491872623636735954934944893988693841263483605443443898780668071303,-154370406469058028558541520527063294319500009346753589170278013517417296657206614757375988346699632176429247945978676029079471382905253809594503/80987153602111675598114451010879975403593358033688394705989588117027449221346677523835696815397490066048153807149401586091517809215597138243136,-68350314496557065834126957307683357852320781176169959629195786400350708482174697237141240241321112044646222822221820554770182361586972232376160/36941603665136113910643841935934658603665012688617019278271853135277278149447570232728294962396271977713085970929266430184195414150774889888811,-1962634009612075006309151996381671014195576796916880423771826414543846123528410003063285390670375642426804363009132877070411553453978182788882/652098969721742260715740579604058820922290864333186367344934171864816440715365502882591982982689395629325252710533957775485604967086303964781,-2222946115272268517528969719699981712709033151819964242467386789836798117255089812194036523802954871826963355272445553764733825999382246608919/283540348677543490292119327809274383121978977483791619328278646135147906662952312757400734010985404827159397423941186085203739094373392710359,-536176590547059474224756793698047946637394574151311614199672707257039890075358759493300802079313812662802658791847867504317794628554570171071/106755207195443454352957987232306017450061967719896237581185268416368248760870152879707972668395548351290049235659988697572135704571482862144,-599518094070836608927160588764289979298766301101535585225640940948513791958880525649024497362793708765543890826959633086454644703697815396127/2867316695415662938852395583563293951478614675675409046568365319442947410034922190840360602781162554041669588196700716982494368738985408284,-657398711943153985063525455296484390225115263487003326976923912317562847255511555303592137662748978570165936002012115832147019929809490153864/99644340945338954078522855563944670016200284922927886886073222058699983325284315456494104468000747588662256135965241773346804536610921467513,-14566382264657804496064527886654315215708627760041962834908888552247137375850792027021758964607580958289670253188187431404146329870029874440792/1862588446125032641902154449785948948980366200191817112096766624658744083474644804982676241102864387716701131344221131138020620526019021389859,-66427867394871705144549051748466903800026059494753184717097725899551258505090400804250806510899974044024155514404956268728195035209616549357237/9960453366824978655896826451811156860207781967168506187174346203809606108187426851258634943138311362186044837281686807928535354261529607113028,-55211764328616968671118618398296856985389188359015938512394779421937525824495863665256960996915795139840319915567351727784810720830559489436016/2546706658883938920260371387135305401019131567951541754981111917914408019160754208775175559614413020028332750969689991899533511499309976573247,-3546413184772542308464554243843444698421130647872744801456445725581719436448628654672381814223398850334159949153778143098204371102222683891862/613213588379178751092587237656138430105936780162389177866076854012021398116154707694602831298224578243488535115590216065706544520257088245315,-8811415055181736522387558587819362368117812406384889500042668909914267674183063637928796735927074215538883353378277326130429367937467398855771/2127265827027423979635017950639561691472929853387671430638936512910076441619099244482743425994538544458821102493726027532249246761724292737631,1316309940381917541690041035619276115727598355919180543017741330520511947452702951206591765117129270377629886476613765853423438807109332670926/1646087261766914994112053129375701055307114255537104774077568678518631514570528724476238696576134515502213982497042646384853505790272244718927,1571060995380750088965974288033805144716113789311483483345345604080330129561895661114332403281731871552629905100414614445456328490855404884962/430547204031677809338231651452831827313801204333814459982631206669811724295737785629675609668690743602817538377939132069620608851505583767789,394742364819191989032839586059044853335817686378874503773519548689518508921640138648724510619688707952918910950691696035448486894397602541569040/204548269685288050892614179526567758857838919432556091853955313232377680974818234787457141102563672018540848291550558804208825464318145152580751,-527111712388827578063360202595515570703870343080319568910504874819041233712099908970867692755182981020419310575106592883712835506072092932066/559361205405473499109451988084499870415934133530523121972059822798530808156734932840911982168772810546623407462680107018292833725867859277003,-923120328548317941111556897396765469402734296090870512926480181036913057203317973417763856858577443439186181695135615953732966332452873146754/719010498091351346175251096300639616379749090502215295013398186501139916391629206696317407593723786471160824435751496518252821580932315317671,-43864903662197799272656210333138092205621833640836757936506276023094132979191630664439351702188817142433205870980182829772594906122911406012/826768132611563900172175082088986264575497636229933146482169429150935092572508833701197841209805754378834440288770044290150660817023214509,33692521133755926161925534343554813142227058546717278882259697270412538295807340631821207178717705851382710429165553723598330989830229121528/75603555735677041498359932405163424033735605053271926430012540313577702899719403308318437592896609983904575656310382444028858236958579713001,1910934970124453624008844084719016765522294986690437380119085663026406876194801586467685879842870874867910923574239864120464499576920767407204/288872267134479027866985296019019743240803659514308700203500742956498324001323349033555526577890450069026441530135809114929579121841070347243,2453890367716660105899759106059939708503201966747193739348080198786981095716593688833922408665286897018926503716598887958866197741654820547/4307765033099818012146025463372046582810267171468998488112643046696551176250190914833560701127397566058032505653159846185766625076063552555,-29503178187319450970614147265919503913214986870450127607779715592427142292642909033220752257640372896258522053585585216986581537005319126251497/16441086846981442169038194984584401883259855034971147640783354636665833909064697931785970875845526415488435322732422178739169254814180418856641,-113564057336801144176919243206464674107703422612030151133199676702986826348613282913569424573427182047059786650242093041051893362668360344857/32373763564002188636570970711294251157873037743441923165455313937793701560848422637242182459152969116884784459229261685177316657851461883006,3127021856040912822407267477641724553885725235982853355701764589467164032497563415623563246627832914826754910142408479101554049510327176664/9316047705260071463249805151821010112332530106336567330374502730572852378593659573836347529737742100951222185791811151831462669743942457421,2246215670769198207717662087022810742924205066224286475290160231144003196495666700029643811467863392952324262350759336216068123107148558568/6511784333095150623914098957329803731490041511065471703027614982383208091930218860919830601806250500876615935588712325886568751924344536011,2971818039624948948731712474253430780051229499866077578522908262684227705955662144678024295256188925943395410506234540579304057617372305228/1039471319013403012887492285699777455636201383667892057652611489245054296756338368888975668909266910515876410725487602288779173661424656931,42081265548485466107263751934681121460102554317431015522734123793198936068304856472641292774806714720027445291931303182303636955953092084672/21932875549471277414777579974837541909439710531928422538833398332161739076035583781880470890289846655098635193518975122663303425183804354471,17034581792358698790634436532983216286926830885555170862597730033502147517385001607982626889093226915300831004616504453872506271685617583323840/3231223613210954795972786819746626950767604460364409117906379035693543101692419253517772578314602593650078472993331918793118245208544358130979,895658766566635947886504295155904219394447045154429341062329699216814271524589386141671918812770926831744627287147494955273281424685799573016/366868241046812859143446534283513513509478238590792790388037333235508289086644998898817338708827061304922836895419654725716964317148606132521,47489745341449531322123798732663272096846491342469942752534477887897655233457772630277438482099491298163989312530116815686314896237782639/213309503879568969022461387188514726068390968011474616857950612772507561381383013795103845034249429634433110490549598099313779957630344313,-4189500586921919229200228252789387019104360903655924575575673237878429785689018917975338651915721181894975324420350568278338127128956126996/4260703708774455880526244117937853890690218583957765574829125779560668508041487895551251502024242467605839934115113239393694204456129287643,-25263964296306017561942105149502402144902542394120246665500119505571520248690784926877037220952582890632856884635353947400544670082868399468/244433852760018287972424768685601715861544045123156683130720765771199126104359160938258972760873807849637521591315023304020056749974819749,-299880846478676106332125243294429505056104648402418712480353701734419289752016436550290758577031114902503421284805707574083444398067929330408/2466033954905447665380463591518463457002455690090563074294324708533761484698247915232797002086051701326193154511204978601900767128336878359,-10561358751020147756777501370564004663697498601609970285459784467857684772427597705764675780386140361306501563883433396903382870091838487840696/883613809145846494089882823507740517916961167173816833361671211122119445565000524315073066253741857691779043809568592585176248305775701376141,802955823547399968604819135660623146188477161332842953752549824177776022617769024186799526122516015816619665812403208371871846535496096595964/103702794207012537045873214231335829617693249959556442351408647381074096406031530406053411843269275651610201145873294155949090856963425158733,99363182041339318333797413139349318269192836076053758563185244176785772319542117203911383922306882002941864622223491941911400067778298396448/4947308212813691557214412804449728480038501309885078814725627365612754378975348097586505552803553510407427872604864488630718007348630266069,-259157959817416014728837824685319563482583843367528022945853503856554438751419907233380087273354653686540442008718581498364724892130620891984/4576762905889819925464628192756787679728993591290646286053088424727442480440443306982465007861796596760471087896203630040142591294864501951,-712106604801408661397843001501895328821399505964382013887811960082055524436036483455099896554660140326938988453208916211543598649705252835392/292444207488246373647849181291660081254980302886934029170857362885676282899348860258775317778386155056100567757250576311138808638686862496719,-384933726636226069772302185956646797312883343579735577771433034313917630434480928430311952702917468817246986879953407776895928094321018375083136/280933913714803636479247111201691158249841613036126918090088416036288087242386945536744850769693911976710702223101262886331949229261989837593521,-477315057305131002606193378113360838568036218959082595093214917778067895514150928559932282434508886746075683275330462786852949531316302085169028/163499272960999630476453856336368546130528792894446424476446519575838176999802228408716960546934493845003088587498560655638228795715949909433285,-97483744999111254706391978024972378499082352054238116918059199796650788050701396501026271660633394172185688040956515051921780494623721897474240/14938258852254253934974058508175661690823938773802434382744405587438801042577229872465188497012140494841119781133332399865181867044875854631577,-437059379624164383588058323502966441497449995409713400613183156076194023312441961613835141298776866446604370372965836858485971991838849997760/251466836471966061501331179758945452731655423197577504152241942619844325757731203945762930761544911827612676274733159893613141776678051143813,-52507430370734163280264297474172968069928258187556294803376670064527461541818651713717992681668096399787461384354850418902694972811699083512064/22711451942361541131790605428299638982504349928138465227115376149048695973829531785510133154262148714754985588501545851255700762812203440936321,-1335609106159485738492443445381704379176098793219387796696211674942348494186657224858156510425133172223316751584381280920014118922433555953952/1542378086466228799555342896617943276600374816494216264419120363920863440029487155049813551175682397039694300469915201568156284394411076465869,-178691397822837285803031522168292006948256369993206555010582418407166127660868883918091838475555811739175776448055470087585910630114624629296/184005197404564635309908901425218002602162224189895278205724431488240417786029161365963662815163615994019403599817483444094390133778082468353,-270726977729351419511503668101629154650928692180281809845664526602521437583243006920203775823979496699005540507970104970156818003500830248173/11448731627858411494752283131026959227703700555532142569699459008563920801473549447237257957581091054404873904081966353236188364481905818304,-2820916333347298056790263550677222126357595131035692591500540670641102371567412888196439415029581245409290058825743423626434809851055182585801/189213168258352052040318253477922245146372114639586192236438688922443424864286675314220360885289360404187303364684125046932106934008381758496,-70950227936424627978300168088900214713219834908347208071549347047500763000760520745185851839447369792205314045483485852075922880656316778183/9420791858131460068754706136792448414687357279048952307302499550662688292907764014606457298083070985601258853647349053739977878819500556768,-11761633345570465359589094354412800210390867979314571681185416762864688338526334745594255070076288198985753970887454626876555841274646542949/846938993396150658485895621526265395489115267447142030709880278121800621731355644048770331277339514278261616534387645815506745292751477064,-4555416696921883607384788973267197733584987948303431156030334396027399464457135343418006060111237700840853772169565915955242649114531626565563/1250093810958126053653459845747442279164072256503541448323615664087823630841597755560582443679737455174891238528251292280710846393537007497319,172756272517540249545031601667420742901498971498654035148591415132825762759067229662625311307196050976962874972246088480581052676164393273321/167555238329276295800757665587958274036595763499603794283033504459444614718640102068276686303752659110792794629510395141439304758057019337110,5030327335223147422543767713055379719058744010006497884348101766498767148866694425228850008338269093623309562244197103148449489156721365616243/5079139775303668189182589252365721871162225973796657164220662270185381892232263615434362470078125476135010422124926699475426329591651984162816,188655478185755852593946494536583502114659862511048855985142263623106496082996240954389138913455891105506294824751688147827421221170455254435/124920491000612369105512864108121880364474860007430375393987390212408871388078410426040962810898205062003324822637980978157675870998720126768,501837682471576955968830899986014553433924428527377632469961456799629759750281375922868748417596499646049758198374950883000863437353907543179/61264789134812564917110090901745734867127543212586937624565946207136766995459514395309419206743511266046462288019946717458585312943240044038,743917568274241154086159652578155129691109210098564716329158282230454619523352183443360835978506239577479084212553067878518589866388827925453/6752542670246775200058078802971067747410743225876802700816770380783127203254508698089149968280839170305075168591773595026608095175436980734,25512624548952652479909769070204434056497277198865646486348638098203703035250095873158510600798986679885018984063400067200201936341166744701/16954963503184226677088584484425594919093535946217346673650450292407645428915193206039911123264558743717289132819392108553580856997347229362,57074779085496814731891808180369151916364096074475950907619092467761218126763928431585287299556150693448682243026496288578193251754011057253/2978204932468872542182842213441062607087983153641024485877362627942533471704342564065672873916180119660364353692150431382815636841712369386,35315701592016457998201981536349805289359014683691302409633116007601082007349316126206416749511286112502166301694251321191771155017097653711/1455058069908094085285317198139421587792698374573466910795795685607853906450136882100606485228126393000078002046086665621627481634332122024,593365168427102193565637099917089461833120607516016617808517997331314308212562669963694175396821710055673968475595870751384279218037744301193/15495435531045358626324260191989307805439108303869790299863692294114841740676223105813537883442900104025387145608716912435127273910107525950,2170836592330884992334922938310921700177717528702652213226087636294390130913591976196728646300925885161131963305831962940530977578002704617741/100511763843035647204924217746227313014334285707123918692914040581258552770790864326607736278783681291069483732132401620059565184211802527342,21951658828247856881773024980936628701715115611717027581950383728957646972584340536553463889601026022658339004092329010995381391970561606327/3543423808864738490564733402960651934559311192105341871315586576129530750872693875884547707621758077008455036484668362353795944916049402389,6957998045672946586143027720704133876174093486234627490573940531341440468812930021830384639871491785106403916299484382005982613160499497567211/1112902399746341340652917700945209446991763812683078967686043620804211076392852821585549365731336531160716565619268145850559632608914459836288,-941789288630205650528458589440434142269801137294536759190601428251741766533188983026163573359924057216473141825375064068777641186085754764157/190973767170286055217417435068515634114443674061369571369298323647287283793401744536050170148564782447342416362857090035988407632874935553908,-9881904984615317293565749957347976575101540971745402690120286180773660390428154565367211686062023278321893486360782498660574315595089310074291/2089541611493643897560803714769329594627868930290572767876801985103399447728072871508350852964030201994893913055448329108486717230730817356352,7071341124579230495307851439085753212712216676440990243447826816988506562764998447830996673054071220354939767692097455059098409700517148681/8120512947907250173570216304296706458163131025244655533986888883440672043087305896977855880251055229447954848002208827738429702245911517670,-1993813486635114724473789902515231942359551633720036173417260439076906706509811478437580034724132501529935423243079260135699460564257457476473/781981859635830013851694302417679420008548231649576140014251122454590128789054723284452310757876437394961384646953852383459840225247299885088,-1051103737867919747608428375147270672016321823497341016354239156377166379893984223336468195129428850009661836274906644395699466234107634882861/1169055987639317468502477927225155935881989007744045879150688902201975274854338588765981027478023778545698655363130942614385840860050844156416,356869981099405002926406433738430005396244023152128324150219666452123410999171709309633707619903370844165207274195456005598201411811825203753/1201196475362188991580846558388438841118032714289791517393243326938978287493556120472579480451475048013861512744121321728271331094259440377008,-832973090403332252554687813125177379508538450308388872410195612471239269770209753035042777630930087985779034302052897897504405186596310060225/390966030462041770646585807289198406659685823345715483562531197856660176307736530634891992464672703649146981461609325752431390090187148880056,347772623108704644342921298266438268091385325973066365716728684873155755580889298906293499993245241746628667265375599898335510714492962524341/281380296502818350673816325417259231337388097215653442933458204903100779015976714126409239042574630159452043118452353661933888943659049394010,-61012449663732757831346748534830585896055100583521865909827397956787279870205571510377738385902309413629018465019918931138416063289085167720/29902697275123712705968849879836622895522042923282141035101946046120767546325567050945331777353201163118381441771207577433880733815256756169,-6818233922877543720767557614700305978959995750128439007510125938872451064243393988776919436643769274059410315480573205550835240966618629990/7904946254332849720336247789014355246837049127701874062590439504452460235406940895849157116801458577257392277827497160961760644181607296999,-274244338632116725286552002693374383752985358448882227687105618312577119031237807208159494519993274002599669350746737053557607673941440374057/80538605725059753696710468359407128381977676853263277160505323169209763144793136124792491732623745251430291791280012985465616224324822801656,-52700113644891683587594293475584599500856110264908231176874756565999063289810710365030898030949846672408207359125528591016540358548297487250/22617817294728569576485694275893646600392257976063914278384513996057152464531344376836913394058510063761633493659077401511949291245164796137,-223210206932896089408777476129600721258401039862449089398020052870412437945568670647382982844379140347498932549769225822194582831876383306719/284369958353411816617348170763251535084097551398262303203756718158234784131821111472192565153162802615443484044879097652465724985262286891006,-768416753856451496188186702225974625910484508077549969644306872376641720789182365118761195480357571333451600524555234103385970346062706510929/49774127202114735170262283806358968901848837386569106125113991055565769476414063546908897797953477536653728995453651802834464746535953351648,-11045530099328563304355867859326895742785315836475184647455962635790267739988359295352199036486227734346008549158094053672675944365275008330445/1672767863389452668526216290453635056427004761112147927916007826057177553980640464319394177878018227402546985942599266090370150680386052802432,-91495748922329899801245510862508817139336335167683761444704139605252355766943411977784700124900980110266502597076181797774603063407046572205/23635511100107166494955548651431953393867755621415080115347201291664009821318318236487648848024841568692360212036439184823299791610749383552,-141439588364683917844129375642201350461281285497094009755129738807642526952988193741886357880253241423631571181654543529476576760304555040686/60888209431732215471518093195198002112160529610216627554094758576130278871451373228798356808265119232688699919061012356405416309653773353225,-32128108313143210911405554353243314648416868665905644607225561613329496991055409168232317197596561952375656118062904127128485387194371735432/6171386986669145785877043626350466985938484081838510491358072902142392470332727662887752137338354338222838107502868580135069731627017794681,-46416797454607948959032835430117363672425845450582595829587295381028840872078978047719299693907734842762932837319956788480260319563196346336/104689677029804319554250145510927779657888706036825097813373675205875812994925654996671300871955878701017951730714957790621475121764206332699,-3328832311569930371900167474607706831897997826326178908937634234495971200897375175732901367068566338901574837983737965475309358342608541464809/113160817941882096689157475447887727290029980813826805816774632475385896242751959562055505748411047243133731624499694985236496622459017289101,-84551631545585828177687831591148803719532298230192006692300584251211473465275204612511933669469978514877280953907539717430462085804202515897/2685723392439678390790195875887800110205536912978771817299619755944688980502130953634039248665743219842580202205871361611915812013008631451,-130192430687582775175219117296755998192398794387849168592720266126630535764768187916719469616615265676610947672463462647680133944246940198139/41133711919608983579443554838362909620932474565535846175384918893017797344949997900569119314560742436206253193353859130454560673791698398984,-1019735259171107959430311982428419832418117853363720498617829008333155321230976716307320215585346753909652734500737037009140805181473642000447/378091308347592986767783165815256727224932151850842269419843693706382700223579345182477160556654265238056899113006649541883308153299534822716,-1864446429433150372995891869620084936712263643150292157516131253339289421998182492280695569391400667968396361682603524530583754611643701764619/803254446708555673006580091778980088416002329311535939113585511036051084442279042544564548247770815280095326984844753382854118259312575311556,-7243811414232707913807314339006958198619185280043089623969373722641252722512077108379447223268022984867721430810646928643863014999625803230157/2984394896034137645095542635472407559060796875261563128976974694398201094419405124024674749286610966238623682094295470236015479239042305030124,-6390986833119097887967805733972491705921862698572924229521388763966285164282695854991742601965878053682017832231333683723639707297182289511851/2980452175247454212396729203586134976106524936702775608310597152606230418878239918408930021796682270871337772104727449361578376769004960319668,-5278331703536750467195353682750861544021735435592546699819804477938591631339121953843010345688081508365567089312736685482142697939565310868040/561216593099092631572988554992881769964629715771971622836825031036315607149021831944952564349649370283458089727045263401019441638455056953741,-35481069318478938490472660109432226808929129448617439659224959754750356194769893049593593505881887500803747117936285320397195889619963173912/156081454999529880675553281864954474546952358796802071988943762853421795809891393574882003227227259252663804091051134286750994213723690119,-17299564598857393851464763271919118753200697835928841350888008293082756019622069520633987377934705119930679005223797526897308227021398693784517/7668141462730279335999633433802224016620309038143603277607971915545088101224159408689357345685451970687402534308195716413733771589181687691312,-408402700014702346393070712603260726039283578661759993640240735199814818103375205417911788109432455697368475616337761707332933289647710862314/80183088302054804301475709703667966851094845040781572148010923623581518092153451640543867757512083605553265690345977306182540915044459234613,-195030262946999920265850885989813754850691706236451375700809869290801329402999896303217018379892420127489365405615294284019283379016916394078/115477548943083019848467781644311012111710894326286679990278086494381511397168478987683570044551254074685195917192399419271297618449001990691,-292292654457236036434708735494540056628135294061904191234875311196923060633736078964136137736132935488392946654739418973303298930042048555334/263681401549729693365461065435042287268589238701185260897331155935746691506823932592147622801914400541705393160350443742575324306724931929343,43752029423436642226546671268097070141461280627771761348763311869963166988495637025830555654706072004410686075783191921556023693741581067484/3401257741632475577135301383945161184158412663552420204305850715801341894638643923769353222553318949418317473637286949214697388877546192065,-183022857473262319044616031510097403764939897929422393994487753307321240373582117632114161090441430264911703056660434751024404872445462343148/55927884778438800486566143513775262980375533474865242554518291430725274625478686602809638786085336946884300335197226050769209279444580079019,-25653279824360757322074014789215111218492184285059357882081726316113536300976958520780039307184169363526080401018206958796070753129959565842/20096415774880147738615293368740101060071849651754579651437429780274822702001720678103079522971078426508710908220339298162341941133248224859,153039875171290439935149219251524776459349454581986622126318947847159916899268681828634699434524770395112742064445890372733225134487190970177/121579815975658400846646344689905040649584147373309534776290332620623359765372929338429305268137292731567052462514728906025745264581152692970,1546754028512941160772455058332994158698981840785732995406310129595022621585900160642804053309720120324090685953802923799326138662375562910709/507922469091435940083977662085698343831536687242247479178838315184327880250340287482039704234358015256337787032346231657375148341830396925712,2965231499483626809595047199936648335303025049551571809708306344386453514051102701507738003142192240429238603200665454960216814824649195926548/259206153481629876409874934948724280757204232193374428261196899699901518430965703011674037843361295761360981857882208997806434950454160085875,10679563384164398143895191794257621489317165335147936267880993155358819474108871465491546893618476932576292802810194228880963207810077409130651/4709578982167401110040208175022103439086080445946949385228631909371553512787545767569146857991710949295643760144963459909083360110802332609035,7120217171569676381333773357808809969866575286018341771810960429087085339010617953456585063453854780708478458623900529818406437840433150009913/2639966973720940745891441964029036903876064805687626452516850059160187813061007451393508645923444824728819527488083445205520510734682019401702,3935544905204854786130020652277692207279621145310063958482001995301390911880311386037093943625658313156005910928422912870207106803826892558687/364938707773382864345467605997164124044878713112189153494651686338489095919609401430644156256815584551999624096787043681381594831621613995090,174275613542961768029778742445346138631925201032867564885436257313303106024898672746330931160031626512053174099770685615678095834752559739137/76578693568538313632344269582925872319457333190243291813892928815148617630634757049102206725043921313248352486128118920763476489827495957763,2233972010636352212097222770103337793920889131811127797655600467021067833700652397249306442316869436216670704503496982954316407122489267951367/1177198900668435577149814657470154467332178608589506045189394926605161290723837400694996792697648732044183910113239883126302046448198790880380,130577050252692658481309470783881378523741055460810288607752164026924855870999902813525306037241464881184355754096974845068505173901781853727/7918303411198316407362252612480807673556681391790159690226933700104119925349802178762958932694463548075675586198877046804673075031189818560,130562885457421845312595586602186316977901364492674491079461586188800080945502858240882872777090360549377607842419594061973855955302533175683/47947045442958646631814412804532739447914446262664625926546638100729971979728900008744883705132750921198541593134302874066465093647364682138,436674099047393953409810501602923752352281438137458091363934985200919448859157334939131985883882996941985664769053946578920900585975695388176/17566475232775552421139801695605824885846330217025194430981556805897465006536813552272421762999512487790742342364551713512086399720831630807,34898793087822431506408992573139563897374984879737960316884696965691943595744147737760266212456946633569289268213383747113611995841737276389/10919081748712364838591786855712463674245409584989828693298596456877777670468972040047338088660735254856508683447969345419531717305437817488,1213293709812656691652598533771463002475273467913552149665128434921515183676176686660839289363587432866481760369522717652117696140295935109725/707325777411829154098987355734890281377709909632910287723805083911645562976580097474703782656234411743390415541839940985396748706325183324304,258377836089559151410678125010105153388290302142351986511008520877489986175043481011903301401529461302270958300115782105280190927393021984912/135205938118379859613369507479318478867818545848135288110414327916781903561484576489781979842092316900483522521229085703423056328382642264759,690812783060804022270303988701699473724320820873493141626393659488423817773271162186238524157158718727916378748294082711800057871424021222667/388193989502727589446901408841876411785848346073287395721827888580741782390963163264145173145271924480325855204604116285627658685392328456754,46760023049033633571209329157725024487674085327852811614746870554258361680391703452542793625408717092696592541289973423693717873039079612609/26455126381698158801393029494150802520832940703867573091500726828113900941822320778052356723466468222910485607380448115082228181969772796238,37409912659365829381955799693608451271982253665233456209320041579940395768706355723610523396531407062858527804268285018745009583152740118149/21770373565098317293613804887442013148966172772531789487493698926196097423799423432245647170952478780204260844958868605965011901697488689318,443122370511515648128562343899776040897482636825856197418846402396025172285990091914848890181190339239341098807314485003186616946093212834223/247863051472490185955604379274936059785540996804754039152672383150311876399264183434839595358201614700963006833690679005312012643359549095530,861010676002883264211142762672502300202552087854434145142137895363691985473731621841746365592846849714517434718250012826204157960446868266661/509019001456672209967209957958387084972582709452485480582937987228148860358610490932936524644279886191645278123229593667056602837712701662298,92588133563940580955226393505915655330087443392998294928416414856921029216230122603770454691373542276913408115629897432914504484776655747557/49054669804380279249512555399085636214409596337463847200100966728404286910718531269242742925667816317267891783312871130153433691723659117434,939062665206739586503407759774925568463788508120934299169103170339984241386096410548730260824726121847962820326103873613226229374142486619975/534802824881664117761337715745557858523680938309182575642059511174347318341999224359640898265164055700504925232669030258165797320708010227922,521201191442350729477287200418055245897313117183028917666997633475605750834575535305066478089831894362113017516325349197194520755413278483647/315964781993470226792548874582632366535255269549224045469553945575634407440129156070833319928807955507933069491861346498773242888212737168696,170827716109040464824718205142174069107230054015118381917896594880961670637561002336699378051621027425484392383477330279168415780035660208683/103585311529316976743661231953942120484719809313364407691312325887523377635748841581293071709915183041671987597867913620919052987500944965104,153881921117848752229337003989031627258693970992345775808284171801693039090119541440982781630465656625850365400186028279665394544769677620901/91577232777612514436922238706897278995153990141355015056354260689519675204411609344237759446500830277799061070504651278620694567859157713818,85069845680938862126581746705597907380797920438774189601947885330849569096272535807560815732128391183812028676653123704663685517746659549723/35729484899632161284981979323611350331215157188455360985428064714793368826545585520818582810834325548528574155904457293064367928732510339616,2900330666083144867678228829661604204181508405545621217341145395209530280252904713105501843594012675286682306912803200629480059380102929344293/1711257989678698167610659667453401617166863944392795106932020553002669050230096803268688063513360642664604113974083850062206189905502209113724,5365143521593075649046554042218778494149157438289866191977995890643175367431334267792377704942972936334419249534423890564129624478123800992872/1970923926036831765007748275091865181227025754884308380403087658012434469597443000380155267245891242681761570346065699255204620947102020325699,33372460893402256087285216822487994090430577387462962652260961994462670913594852570505315482019617393991577513459724077292733462587659516264/12582459557492480717989179859348876088997746617556172238250584582769257158497359001613827339195439157946667703993157373406094859465465558035,5052684113159077100564361505768157249456237035388747424225027939114195102632554135192948305547646155727976746733316603461690105037253103118183/1310521158104161060822868102036753614828107065433132704321949396809620969162598369910377342701117860511124846432350552641862549193572095229776,3913575517811025855734597156676802718415785198490114045880370912915558294895594107164702553478268926059224282832741826526234844688898091877951/1469983250742044992128707674422281219242193827943464919893759689544392332281554185232186949462841464570298263038875045847331842574670427578870,76759317846581213275349463748211925833203553666235830926668758561081779957718114864243949425661599994650073924565305698498177211188852687584/29881054571389093060780369227210424274255275719849896658713987440219720512378756036514695765580408247956248652745535489169489348862959540489,383074198710514302505193691796386567093694583980464664421547902006887835228584385565173567941846395177678517427610965358786334438080726906317/159445067056050088630580812058354647571679239604630703233532305397534029174867464453232740295539879823393604883826402394989546237879078100578,354048810380969427594389072226392959644642722228516059828676880059502728279742116853787249729538300262861604063398719898514888197596305409097/206665239692813146177319089992804422940047003907539771945990955872018150800354788462120695417081053851030942613339438986532656367487716579148,309719749971249254395880646738605867724633712726874669297443234365257789494018586286767891946401470008345123375398378883377609116747714265311/183174798332322637833300233450068678506739382159613193983465819564072057274253248435595004501618812819897959323106416648383231878924282570348,102395805751639925587351681401080832148563651597641006210302489650733837962826023895877747009563257848069132003236041349249135793436865463521/60752542619227315936992670648995245725973455593798078341444408003025132931819723025446949655316398814841709638796948800387140459041195127478,-499545481037147951972430247579433428304722686399805774317711373682094715200330015495871573943088893945566129249389280590905696467642504031313/94517905848028376838835460629595012898815286611288396288647866693936273546753718442326245791412080668363339055140508864978470538328923380222,-994104148124163282450634113492074976660959523166633861328676913662712159291305063360297369288910693034225465741628008799764183697835279543952/30357698140663126003817437387331575117640828755403164423452842244298806280137402263362800529750799234117345020783293898503949156834946252399,-207526643026629617311479656784501760073184740414145079840192521191994587067913793204454101620064253671635473988685576831882375743715477872732615/21781926743301588843956343761435041212397073039315610195218297403603793544244483382573072591624253599434265313742842926639526560479243402639232,-59697044899266360447791110212225372826021320922438178869526947375212074878930625825953708625011456144402961707696291140122769793327534462966/17157043263895333453817775432814329731470391515422481756740498727810573778341374140683817917321507062418299675125107109173684245869347867411,-5712344682289490574037398689309793963267245741990436293009381024986408961884257957835045431797558133589270820600651717008520910656648720021493/1926384865427328044389409664252323867468160865484350862526608472926721986403596182823525318476845899989994718396055801725141390185874916623488,-41169349014046534285679616030567098819159793037168563407045958886580808216833187815836020978777145636532794223171586943974719211193471822352641/27295293178287579855319156603680073810373074639869371399289981005110418360639348140738791635461995692866894694495621177861995866466602740176064,-2157032349176147238338820724501829084049637576472756059533918934315090667179304604923451338572550913556797596033713692671629136973661419498217/1254701202185742714903666466003602395906282083186549117946474953415235949167200944969550728337419668889056884673479809638862799025397685226320,-106517063837977466417887199094855406838959889282467435012080795446364473976588218846336493899283300476485937638891414847953871861941331702219809/60080000275412634500189965848739788961689106608301574187919211894440291872164090274322523536586172756139821018648453397341726185756530070433536,-1167560665070319346682865127470149489256402827682158696826357959306169445648569068376503075053980612451349513097492762343506945054120402030252/648788569216819935549553400108130032565871135408700363041920178702948535371584102914533729241587703777309686414684898871644523572715743537461,-3071263858249695257758489691193435809759659173980510230392666358605386080769519948063238099915857381289743999556284568335142366476963552477175/629836602841995925071334836092997738664360975895370801774097374131363330959629179607675060406140661146192206427448194958712875453451005687154,-365760455459757749603571317225304787965447965732103900135955609611323421760267416003686168017588129074505994283418974943375419589652392301449/20649296292555391108713356586121011627582065784459380868816383988254018755136373303826494169948607929063611111763580878552833574809071130333,-5528003882818630410777014493640217110607411942624049977850737883483430774817880591991759736635380542446978640169649156717931987836164851844068/359675590205501724882489980419286727130502277501906227639456925509963181801925036866973238317455385563372974032880710137571638698818714868631,-1186009544527731782890583057467770831174350805615319862016693487508944220126949867989472068215638336694669547909388174478221645601015367903925/761707038705531113899692516673662258301252326516243776863546267355540732524158968284037165252430883280283662488991693482244356792734564953536,-4420798241062911486830090155451751546136473921844150616485295500448665580355614879699326873578999106640982317758249622223686780658349206096951/2834361050149672581620969982530601627357938182247596838033937832962379347610108153166351976525785313401407420326444355819981862013256987979008,-168325285509025437042425107920892209549070755870914463113661195256887895874462295317391051601213584142026649661058492942240739226178945026543/49087218665684036809476406565227173621471310154418684611146816393760223504809826281474537147338088179377159846875538292278378599766242885559,-499395200354136824890418510227309885603819885465879060022194439259046029095779436669028347227513438976127951744593339125629854571154629011201885/226873830259852906671892853883506101350703299838151627082197527921503387853018060007766565109165370287386632008131775852966761087004929697184448,-2197709545288861898194964402029971199166669493419278357455631981712596695696310944649951147332734154440086193361035384900882133592199122466193/742239544357532089490360991714071661479844077576117367969314334580915630267788453142082744733472300344615033936031482749037689863859647403797,11285525731139821349692807808281889296377923138981656355656209657435157534841474353949726781371730075183625324558877471065368476004911606560/5570112473928007904153245861021435741692436075483217094190089131674960747008431634482110773158751947742653891606677100285176120051053200271,73368395600595678564785186703690877718038747696172538755847765352612341551601453223452949681839533167343688641146205089326870176021229606752/34205330958702868424231027480447142396440976449954280032140293760691690606573046982739406000963017097374204054397068560027749043360530376001,214883699437916641261653611109861470637121922679417919342538641701392318099209292966615534539138287809365760319498057992022368323690520856788/25926927521372402652899240149264081304593792259654838153038638883108392648108827265647493784259669650717908045977837748855764597022154422053,893249876623896393914428516405479209241283010032311115949225284454298799617292295075930247138160546541352927881686975553984694979767366036/677710083548648091855075408635256504166125494339719373840368379353234925332777533459729006338697200301698994991561437125855707448972660821,15249024135067881725817799743923878088786351601640647581404583317247720427270314757368412489482118484920662368830551268965450758292016390876/37921386645605151942404875669314035697989159408008337108273374158145551973423089023451408057847875387865850119150943591327407920669055907893,9073648404043687545282732148210996098835951440640985797201651504884190494014706124593634728252039941853576788864324979435077624902230177696/21532615724102409210852349567110384071306364384964436111826361723022395449866494277890792849966659846439582008105356878990708851624623997577,-7878404480011571020642333171236751358098997969636368822532937765727111552829634541950071200956157964798067570670708608305380441332236965480336/52859336211494686830971446920125157398754149554816566376892711995469415985733950541017521130074162614495466612016497440600611791940360244421849,155884708165832355682167868247936047064646319369810358100848239391538845320742554291333344536008437390643308518692403943414694446402167633424/2397365886990677939758445511029662093541485480883910199119164107742889326829354183114936256943809076190831907192565893631150137118922322812163,-6137145807673774807913922493846631784522764142775307884699954469927853691814105319767406156171905334089512721709469127845729387254074666014096/46042709317561406447189263075635934470683513261594027070358659264706408535622036213539943150475438616738642251932382727018245535134658628150823,92131018584764557926127997153433643506556055954788402315362813110943627685249362930702435284672431645764830265021616557110281735647633099536/982832052948427509870414441253989467207426745271089646104246698875904295826151514670050124029839269244724014254127811629969053602369004868927,-16281677041975803573748066939226274738369245651935461218683253746261096717646027689096582445687343156764461427596181163961714603261841065749824/133228514373621738224792916716731154834209700946863416118852813562939796792400494685417787559072303808330844720814397846597366430379005023375993,-2268052863263620575638709485389142763772696200783767739737542602559582832687316328338844455904421055954065471923809874440079836698062368571816/7278345203190068789196849460329597131961326230938833559940273226243731316968282487920383219367517803304846780087480774225066605006444378974973,-50271412661493916874353852057141778750215762857754964276602966344789013457954072232410735303949345968882193759009584694640556581128772016021/352314672659866765326433804871702348237806096447498614830526694263549583074286688106910510543953429097296844722406341750511149892322291728679,77337541275433830470498870348065038853336114264586085128455376593313765195541114004302349505516927712137830604454836408226114784431047624272128/6233294102505206301394172796139780965144437895805670528368851054906598104439205521775515976508183276512527171397836998889852841023795351140587,55080784979234365142663323482495728281107838250761508508838080309568570881314453177097622728741900243019055527630325002900606592791214294324928/43437824128349037977879844304354268528999528636387970923427673155781991024767407989465164679174728877939138981546682154276653194959789855263701,40769033255933016415197021873514596214986830873756178763865138290574707861555339032215592708069424742779524885098031808315996965024362284894208/3980434185262638194000474002719304689211326105978785832475958986638959931534330017088949207893797158146408468683302582743995062105632920910939,5659659233444135776922446408523669078466708307820634083604089977900031167473336416518817098969703340293514631410578940814774110236900312194320/122032792754996294780034447792892172732311150189211208179174952462227108223842035133484063845636531804589388415865876832398587904394579855807,9016162191995257641032190858548377941359908751219735639087784082785335164531153795924150317838285010896906596972922415984540121150453907165736/8368387444160524150558539284941823630429594401617123049852166985982380109206615354273142339556715304806277429257073359651645061027623420394963,83195263262625622198432977401117910590148828985943612581855293603642197057366257102539490688415745100161542413514409287537810304077261014975264/71397961102207354360596193481293996394778380647929199670149455566326414395799308619199092634000746540788350557742496921126516734216721150758703,4941585549415772540359484128924196213913848006322402032938171818774361698138043280060374111735170287013756920752499426814875224848627900625244/4293057086887179700330316333650809535803348690727018440337519614818280945855244440037501114581339852848317873884358721575248218421082669561513,277125513256466275584995388924970813740374018758303838845486584214932203226950710752233016257173912815246742338024402193164088209926022797344/236856708253622351149292872997139739224659363800702933311299702165681056708542254298339816315779952676286016764559680505083068501846178444463,5150943572385493200495259353112607746099829837107296063664098849854364876404896887183503220782158987507771054812510864467560103801007882444416/570097923813556358813807335631817495631216457372630551940735347878717651994387732814876655808441275142302871277984175597491957789155661465313,17675796661605223564961882214213029363417634234693223112548156516721064411949898964856426533294597877859042440439730821832737038876288727994624/2517001692494869683157364248923569434483891843570013368425463676243775875271322594212528216812776569320819318230219049386400884759615722450751,76164560740306142660784743441017249921644704857261596790859224373436476984469192981180799680540417006442404584510654089952843123253278491438496/75988363023244815583398457661417392667995909704655961215589591637010608765707388448197935970618502909864172213751553811831475420323069580640071,-26042259651973773861173494047989431800892894831562535923517134817777611881943081184033307847841116548734894717504024183445179520938060787364156/96938065962162996550969503125462017585634132378390791680219112024354973203992917044748710853465445260854470090254782711675125945563366284616673,-488950317668209508707576560572778885210958164241998042207295121732347278602540883758258250443405256017134044990199967976569742841446938796435712/3143231779135632266363188215310436207704510383989861561521061322605312097601139316869344966104320223064153076972273238489223268889873787697569935,-17323906698245691274087283563781032375447066315037461578746404653562817757208819746858196367492135513183584824228662053627138387856209898117/62629952173648756635680903238206455721576633609710429423837256159005154693921246203194670429191958269215535101151892307433494050549472916331,-31794031278871235785071296522478208988972746331383119462703156771921995877583746258618943913665877320745862386571677180365052669795517544033/59513752152076986336866146793243374347234422791030972198082208825890145461186136709626611683509070462001629339804460144581731001553806761976,482241144626258609009895013869850585095769067262704170772586180915642223622294767566672890583018827322372633371611946105515901836456084112239/744366502344526907716146476710291537242379061934087408616176899090621857225485960785198864029501903469464021931332317257791617680262919877056,-250430847240612987981048305053475150942428428185924790363577256771625394759750296262507518280813713838169426677514774729802465794774443774637/868029463299596161973657506210990632880150561308495594485268747388172197134044129953729890944817268271230054153447356076030572474148906216283,1594358513887100061771018361357570753999777934239717851975058842002798424467869318986267370283355740912855989896317165566024832039367592860653/3455814918881632253022006229015749270675241555479030353671854904145692518434307610713394490865284993260015787638319379063831364876689430084541,1403617738359272506454031250680482577247943375553421630648609643351657160957777602507825536907820906753658359230121203065976323193239831770137184/90407723505933996199877893065451612655840355315146303639044194280703044763854479031060571642211944450477782236087536754595264923721354034740277,12133115004696718175916502135834992862712982776840814573906185688045134512353752629227723881694763020810941829917914339501362780133855688676304/5017259321741376316683573790966381024011110236010568033251563845685087369281575760277877237326947853660501017846504068905730516438183408841995,141939868144855591705751728417472504695936251928532945185392560294472340730558752413876316442767398672209875803248275642577603397226037858665/105724897502888470793970676196272563081942165010206821800382892712550793679100346904263013576582778232084899885936887771128829169218124168256,56625238225233475438557292158861195662816625753463614112689267193492434212157451712391071980237733224683887850607948739356657356282120907072/199928462687911630950395667413418188066270243630853023694025410418747972234643538012634062418428997201956272934440431990909622757359943045127,334613526078515326005610870397016668507077246015895798074818336907736399799421689243200603982248392464124308246334138175604336299477644766720/854254612688005411413183945985270792643875218394218727789815082160932671336671733263962173445167743832854840186015173782798251278645137613031,1035900635905583494469772519815977060229271343066347426726907716685661349616334820908156098816979017155812478154430480523991169286200063260304/421480479123742809104546962414601528996747882485726946211284318075754246631220857735955472526032184164535610257217099089034897021536709115263,-49881521305712438931659658259151029426439310134936629908350834050723297433964640023546295313674733987342982932613319760930599657176547663102/560293473447986112674489180418474124756922364481137137365085814079631815101776291934195575299221767539564986778542829883576604227680173105577,-371475465801901296398565876768107199030599654425383751636878688718755232526480935011412562467337690901493287567698063503426267277584062466626/654869703996949118543317493412373196232426032967288099576442358310316770437123158761133089179173242282854709146137335310578408152399397091379,887683986988917849240422069180168461400585109311665779207374405778417486010236443801223193413146811371242086742868969287043998047034516991829/3266256142954098684738105596893084899952698561963194018436005984308411866767170565699034876389480551540318399340123397485312283547655490424036,164218891207888339330328516036871211024161980346213735735249467223131729297108848429074730037716472770380565683892687769433012149554549647121/443984853880171281675259219916677898290618757840523826712158479293925193650246445326269332794906590055980851259191916090812475116988406318836,87193870259220619076712115699716276248747467173383759334783041525649936548932880544675933953792981567211327498118281679672118921464013341173/151564377510257784512480921290622401098927900498434036582745299463491225451807583167357067202446170419146008622840464432162504618604304004874,653069269930309040915194917806930446857247452306429499153048881602414938769762140346833609241283954452845973417523048340979411472343597838695/1207309293534025956711683001520847603404008987378038004104883581498177281332787656883728520503252934059343263667747264521229244979958609993612,407963553615455159654561716575069384697294727652323152759765553183037517255109839204716763013821467573779186420440107044643065623039370179049/916127887849195411980809264025100374793766931625685164720812562289762726717072977309756116709562279288851172747863443857806972539689038167124,275945119947796000768523590467047389358379467260008745608125911608540546144948902698057011776630392347277789711493535293646773079579736346080/334686305547907893974960822122154958737403005021550990374501612470156074902381945816556371283527983425166001514947449213292085167974555630077,145557355482398314517564329225900823007609457052992239655908922843991906780579353535967362695774825828382176517927754254418985792821258457681/554043738804361401175605812043586309108110024892625385531475581793119694402915061216649470582548496559396127794790755679166206307939020112893,2803558530672063677128323903571222650063452964216698367387999039633741617626122037683373211298858491302608431757048477641576282889891789888704/4922298853755594953916161366071634508447290492448519708062936398471843433334257016078045264365855683065274959405232632132955244922397549503197,3321286213219950522606947873039270928708043519957872031135777226475972254116815529076148580457972305011777499859370095590616069872351990217153/5529401407199982911701384158357813388028069570798460548994330356362449522966558503904985947158509730162446541627217569776420380541808234207697,74591794236477442260309811543261351131967548147597064383821070091717710526783283390982266454029672106167702260280279560723366433209678591183/137904095646666971494937384612282170843075096000237818206923683219006374388523699939713042170395102559570292055856803578942282289709510889378,4746521827065348917877345965429274055933531350941830671035582553102254738692586019763672310888312748886498327971746007296506834504076660067787/12761382153126413292692562112296270870081130990461565223796269144259989054941605843577270268437004777119646634781192515587651858471157682640944,86488640517941216378314599581185087507223448214013218503849077381869182416116116205259691780595696932352932831268469977326456313279494964210/52338572097035165717558580504952593158868884724085169459088813336600812586721958253048530862233456541150837447377668937328751665114875591297,13960967939220405610097957201548435607111065714696673034164737486099362606337505051382334328330380439619156598239600970844501296438881249925811/37783843895864847488403266829035052783228787235592321252269224668344456277782190887266490587190842098416813201181387475612759221166462304817436,27373289405627632435598867531806378728120989089052908155808663307193901850227932166980603420340530503811476751481486605250192909202260709387/73462181944395708334271732231456930212754978177362255085433713749202190548761306847537895831365122157339332154326448541224883837289691642124,601825710101591882851589172062081613204857979158835349759567984907883897715446983239001927389891607761480255978438758598366788388127648625007/1550637750266774440558569166293280777438053111569598846659992044233700280378414387365386476451356366063059154701278332991160079115170359437772,238918181776243846423583103017203469847435064525971158650998941450481177878604592932340137373688133677421713745049147877216195600852277312320/133597543005017793076614125572084943171887715476413384702390361574427594467751781612885497725097330070948179240983858701802566392191304354979,1008928856015531407112975720666296756986045046024142241237340632052044069835040234121717790631382678984360773995313698318330983946824620291008/5220161908399906327705892812037224798804584204547470984924330108601972189611906872028863961222616009563016954576086958030960753700368238848239,1694164124640687517620100023778067519766137435959462374810993878755113944253290782254165880482358599862639025999657667170696430831832745539392/1929806546986045334096120506069833793614238094654769891995110191818930566593378136191889708104170177610942786788355104612762108315920485127981,23744443534224911310135277533605277993062221759184795887315518034469380709938948590155299893652099100576994861301090653187641151839890405368/32802394962750159912851525094751683453466332084208060537694219722534666808067065130757934793920019514072123606347106055571197566345077729039,16258473914132823359005103179826388104264832247524963363028780997176874479541533269862868563329233691691026895469002590736470182798993867704/68400993462952804431553552776968436885175838631539277990873501762457416748268824110361501239442895977686724263344438495972015752561154719107,22944009554552042640312180825130440340215245786557355577153856792034591327394353674119106366034889836473119235627489823146531007207584372528/89289677985718789440498334130035562911254168286656065166898656287569527812572335903316135707179177365748279607059982765667927115060095168749,205220718561247447426977165676547488967968423638265842350166485866138425793604154344273842296266008898929212622272541913685706371649253204306/592967563226866612372372013052902903829883962623796830936048692144314862994071755707457931289991962533010801689258323097157670160261593678613,-285045821659822060041386367773247313142684518312874047427911745426377534172258283311117924927407924200188689946327941153015607125444331541629/205315986056391387000221690649957846995100464545025968668905175675532903770427428023128683645304428514707098889873038903088884905800896284548,-1447651720503438833325303892082048592220695851099872208314114788224160672242071002423429270782014195323404842884748030083531362137907441386828/1032476511460897565466490580873783440503252735041330953823733188294608987734979256534993782217496477957134367505921722862099768940477206078861,-682254006719285380107263550787608778422494420965103183059234620902388241166793265925112120934488447974043017275405160790841501466539789024242/2788753077817557310921333200108344444664146489475728364907653640633870978507619765718974861463934548988222910873398509404159867134656860149709,-242876059215297085389152437860853716468210550496048225035459488003891117761493365061009194653057935140501519502303357313760464774398740123766/390197624753153133276724642311497694319002509167946571337374645793141503223642228557124445639856537444639333705733617634931950379876986810687,-407859799502626869005346323145012900967852888264801928544853676323884229347271358436991068585872287826935323450987315645571625267554040598562/106176339406316823323185807353114203298981960448028341932508351565383358838052399379531704174794601698821183414074423801986518577346621645649,-2308010170976200700265111613590365681578056102496330166626829242152629220432338039381011954009439936946801702169692728142329431707724316978/88329968734662186311304039195301668085226683338897383850122466144657619868491913203336856445740777090388302668238108492240605759894186366141,33265647389629306758082079645501652779332283980627990313407504623463926088082888146647463185717160195823838947705735485090121171845857385109/133692740195501687818713571697136442785597513179288539196119190918671932357195702511953106014920302771876467634164673205625131800220820534837,4622968263226385749131152458110468970393140877662107955270527527911499558509701381149000749153582075736523396304801819174317308701172899151386/4105656630042006416695807164258088273219952172064141885414825466765094200840967014889074531599173906169935231563363683391908278422811518922553,138602577367883242959335301897170482139823934983537392753072392854788197421135164995320585318866268216321192585112787851542727617985707916499/207535588829024370119687987671179751064744171168577070519927672403363107597354317328250261402213794826768971774971851394669453610639227028617,49148638883164733797025353833339065210116637459698602040956918487091849581759440153741634465845139810970918899664389798733770285976465344269632/55621907840631011782228262932707117296574683389561601145374184353821310249192070401984100025818247880286325880651470532835966112435468214422021,568652011595642058474683774561671310050198006455028531586018747481829765636413474429044932950603137437757705508694855250129836978254998866/2888206603043360560955777544699142786837919743341726293974046171199410948072178422756011417466583758067168529855825733307731406474616191183,1998775178083139753208622032090366313107355157543067451808705824207204358505704548699972038079376082169723141827265109430892019771625433121984/5118853962979511230116088639396002563000568961145450474173582239954448875720016890883396935492363942633269663276948158052327490122002215304947,-5676326055234980000990829353894081452402367634138515240022367715334164583746788518949394981732327715191628698617045953410400366737363010574/10992351218201325512388217824661354104647337649782178833620953077204221244667815704776678157772795467144252055334844881367669678540501603023,-258151183572924231535723293489575818948041975975870722933435108139143149558256956514593510542640978191377023935952969638585454319274806119052/608653183431181881699016838202827441965915849060405986071144442853116217908828174552637813421655357254357595040221306104706703972948405650169,-76795001868835457141314897783778695026604055564064607589097698576317681707892820511094385193169659114297021873936469670912911211567691746393/52176060142684099050322417591853484783242993936905102671327367480917818727790851744764409454757887360926592161281574743175905052749165552776,-1363679286233744368800266224006023329737492269399131141062023313739136554886926186082526036057362051542352309922810228233276432414713695345474/623774363628274738783249466481221073631411117529025327858358008767357331083703678655913326102134662887002774294685102334848155010247100028073,-291885693752406273211216744342242478432277950065915244159518582007154864627599111546713192549425144294235875871352139620755939876284136062188/248376671764068568844682659760350973547007436178309482822323699021294293074098997563634278136015458761062384091706221832053361814284427257551,-1102099715938615316883416139125794177340196473203265579165353880501076430119582549625081775459428933512196850891709443660991435349568283938236/2462691019082084175664334386290794286357820719822218240133444913121709260287815623247221282842921878496304612664470833129583969884561989388587,-32107932658016385886185589647717679452324127236818947042332176943948117456257521180105062771053803265460484394597573390346015063856782553792/1034983208146232221170581803544027364669811273637705245266356233388726100655922089766800151083974988028083184940250600100141950000413061814673,15815435535456862593744898391368503621886488430471740745490039279260976077340958950063910648976364644472362290477696741791372386018708818224/27282907190218090828311733541089705399621890981108098613715162864886669398663926477716119540303546592029345279160235591791929790576542710167,2419351607872346591940896575401934722842762897422896426151133454434414551820080047360521653502910036042506916476168407092751799929311834760/3764196668305092978476455512936879792439782005129480200107087375299655508733005085488472933824652748741826293341859380079076722873127304927,61395723197723432379926557964483241816002859830094412067611525664212215194163522664273110346342151552244732940685172339212367438333537751763/103143569497646093219248968930677177376659677957050860290316166815449591288061102243832821240663944741045819826767213496103358770131491733340,-365678651637263260342761642921463170731758617503409050144509442770959026527247127176035332434901228308834477811368057204682445238074316678927/1058434534889060688834657072703314518823928781822851351861324992429202150521070139823347922418540081862435995938805222443727010605016310058865,857624378873958339805634829278958473621323450218076508622759219730904389188511982586174862875854228448314722566105095088308296719243652395089/408596041432926927648623050219832496423730925087179036882505029322885826639558591246156347090858509144843429667334743174028122303884624484786,-145334743083118376233304250836978108883524134031919893743298360627263298658678539687339885419073478536522708239766507708068592512310776811555/520950708108239987574763560965039851957712499090876222517985077317938466243413959841965846309833256668497065241808812394855245266208746769984,-642307201268549151784973886943140279350228966729653013792118559199732410725815388016350886441547071004643003417259692193059342597834481927367/3149809705324220801501527587522122600798196844124879765452450669724800692584760046059845028970359310302098342636906831380756205816513909303616,-1114574977518284716117923634010785010253057938866992061514014773203213267149355918871942113719006338446832989814576539589155677402399644603953/5494137877535002877186244459487337010289658156251910204456218730882745860486781792932463391678829021919713891347843427605671500109950592136128,19518710998425776012973861875216167653522082968052978600427868539116505937767548909541317105397955919473862265451793046096126962265436780572/41530670383711672853088471427470228195527813713712368903030941728031846123552338496417746832790389486791831017753972565741504894228035441175,-20031127574917433190896436827715767140252858060714093800086228309946217797216674949430689233620365472233931941116028644911663603261237783743/165426755745030357051913929220664156495738957408019973062955895976814018356404342658117274122283211440400000546796800139212939447223065745610,101418799621283119607101129607360381586758284043642919626545869588362791658332468671766515476147855225816503704141537791234057760995375649267/193368039602748836954185059970298081265426215459944170483043734001020187145071805788003975806433208231781354451633418431298482354554288133970,341002384890338956562945559894648460908644079888431083532516150250714577647025558335445819777348445183388359991312623914485858287803924273799/499521322727542852590766642842156432874784187514437976670953872848989984087708527145570367958484149676803786389125630869372376575887922102062,-264846517628187556586111407301483461263772223103354410450079143949763144311179121028731936183310995328177559202818748907709560467291820496751/982564066900064268491846106171641415215943020696725229975642451288943109894659927658513580542175373896485848751714094106560427700769122180065,-99661356107824037473506884159385603327040620854213845595068647855426353359917721001423544890634422365693734998587631308878799245576336256451/291439400500916685276345460152623260234935140184587626354335346501771288452233494147551514723515053679090052534844749918559242091453390592634,48914765714698691078130029621118129805867223439527664189566746207804694387083078367902553960905375729693222294515204597748711616529970293176/165785269674577790609942835268892414677296567878039262904880616102495248660637456409158794980624840796205841361246063132536419700753843146893,-70648337081185098104819047610192576598208143907276706152947217632278065949215396114454197541646282502794287297448023323350683019805701906083392/155473355972301760823245322096420369673739783116948185381602480851836737491811913569671828481438903703581408729270565354173437886333164845279361,-2146006073092992746924621463962562340045301188470806858282440401159432585897622757290352981828603985113260013891810169181757566681247250246959/3584355053315890794047194672151058987141166032227379124090543903958702288088087900606844960799953249584227208626043757743286788209166180032999,-497243950379140294334874185327433839171667980189748041140736947567882323647605981285818953043806013687674791608154016069128886144982857606197/1722634652179591224886817087768565772351275997344474407665140532968760577521888534094226324115258018627236684246801671077114041009059400805509,-8990284582766551535175155752527309001896628827415724883256640442299089540843123545867360716673168855507514409591524699938486430963010789104192/13860313793842768278003085674135546658453979176673154753604084673218092087488509490669391177622534635922927050814838161373962304936234575620565,-1156758597684676090356133109727059645737726998722984052283643043960554536467924139723847955533680331183304815947034071471001633775142291002302/2816027215368830612659511321960238018735535993041898542482528254321098225727482855676043361768314033115304727678286024768980756506334998304125,-1118090416569775788700097012034124594994169352140053233812359718337127391808653172076781678290041575476159590908061988501424431628657133696251/2731812887702433998014027116391506556144290386026539131220840239223535863444735905564071539354417287466510820049941754253793675004216533515247,-77542704810305237780911686988630061196511667007913256937224141300597820813686913285650061333971125567871470681679148014482055856988705335652288/116675936323592949008405434158524580460807987798661983268152469463888716650535533197008817519594650713036742877360523833726426651546938359252341,-1076774255741562032042347755687775510578293636824067011146380916799565735711791699231558438809296909714792103102187870610568611362722890369568/2346545191370017556315687249933580820931648649443114761629417954260830734707981211708564853917151064541787285214716646148682557576859974755971,-7227798006093985149192008719720411254507334730069881388752183503232955922680392596738830791748887242771207129848189392267788340067944034350024/8201565383116588618634128438781291057455094273871236390295092375846275552881700924474146499541526050550556964042727921689232838224451552056193,-879898430923683862474033305192427472372728258877799923941867591800786654600100399954256586297014411306987144094287279699546672128678405740520/328286227085159774388220287867685423037156916807442732758132044558567451467381411728201858003116053950114677710123903989132370067613979322959,-954684894615073856614244487401348978482410947817090279909635419823871575485777067246516097360358215020903477665915430618245834566862273279936/6640175694263721035952334813163085263265209071814700103125126286463423243974560513776635845611839204303435903805095582123103526915353425071123,-13898104345367400074184731684825744970529789359111609268654238076437321364683127518767522880354044013445573547703215010890736510691413939073176/11717557032452428445219008907945508742598963922589863793748020305075464783877171187129695424310492152430395964470018744787205431320782591858197,-1328355744001631560955138467874058372050898564792683965405331976867101011582123709044296021008905740777069169619926334417275992371144623064497/546367261165376383684245597501105948831533295796221923679247242665238411665596350806307526240314005938934845905435859893793932338287377940104,4343285448209614254596948265458931513696884994756604250323998408827677271615869273870087312163288167513800663506542976257934260436753033761244/8303144901608156546563505437803548737084203663014483010118101535008490587485296475139957652871536506609714515535203654003039413541349019377653,858228907399359819315591223346131038517796787600700026039482307443682197482571401976746065092459940204212835227740538096906979262294366238054/1656899923837288283382622022789573556137629668098651343240839669389870922511228776472755455763883302375182712472392423858362214753182807099827,2549362230800951331737551844563676225529178600967865240732273734552394239326600812055828011093806504722874641451412294848932214705694391839828/2296034015622773035927763502501265674467880492646589028167402865393206056935606026661576987467406156852351720356149049625928734700620093018679,171519301642898532050117396626222143656123784072122674830866568170208109628545752308777585097062309856131707733675800638204915155500593302688/231343789522554711120538524866444100105051312330880489085367771862840841513720799310254910086250555869371279891241522563592836206335360551947,-1715868995957989555633198354431478355523508067364092829121587665305392902470562571586934551770027971464678199785673418963166141678942238229737/9623617504952081091666675394987196914428707759242814978764828433597964536602298182290628867114400201487221332033618768687708349080411946494914,-4897437061819849904545083434545788100657089276071294219349747296052667664931525123007318241752007361361679656937299920652607708988831926229739/15941365484014603289856695520240913897814162974768335533468339122306749791808994446189122749596701383336887429410864311205946228719423632207366,-6271095926583403113350633360040122389623929472724853412025760340142302391314918088574363633848314769109797492379185203731822071617669608165896/27710015862505382008601664095291253188595094669634269418947232075035045711413241670373808155428107165741624782585571645042809534266945370714127,-119521781755923233298924034055154185984442705365297517388865995162873219331461306092374144966620126480346443586819373547452203588674689529145440/447255066828503425617069358634425762552625228871298416855151876948824950234927570578440314039566328698812926942921948260222447885532859388991739,-565927709769049013337756728759584214534270611142892499229663016431797295787672832890602675300402814828085528517348506747936691987309983231025344/2381438764278606404471453374556916112226345785904671917821312777785120545837597822014927634385300220059621392102493595413630079406052432358414175,-54525014993546786561688366885367151367953407543725162535512515304982377340786252739402835088197265618079480561189505581003422831371607303703680/118258907454198946035208099629053477677499272928266173735123362719834132255207450722711716594606115797894664908050577143445501266148350825986733,-4906499102635098438503718197783377233115523466218079410719833182418645132591748066589782184639078966807617526694194222668572345243404693401280/101913074878249015388462919556329944057920133703248338935350740973578097427453905093650640739027288244124699450610858019351767346165931120876919,-82007391210920527830680159780909251699610266126347155147777553596731219870083007531859168518265064129595751710029295229312378566273112083428352/528832125706598950407194119620906268620737840215251833794621641909766063454989118772370594677906770207749297670318240565628896660299075412163601,-3269321057269927953523358272836769369003723383744388234258953464028447848459433921890719015909710455534745688841893851886481765652793367986432/21205692467514900852963650884244064065390683924700578049432355380801683922803661764415074317626056841597275605792438341834745571263877056653845,104702903832461227005509145405406874945886362274882648969664559259908008335539399549456211532194487302957372623178144970101293873391969946679/902058168053370798329677478600462102780464444568659581082608993486263417522965476497990935240380070878967710659270883336548052396835776371735,-165406771081147970548466621447812286173287022673279035307052459959094657511549227660329905759806475837344900154554715921107732120570779650841472/1062656695936341702673896911318816459259598516216619098675259376048538109217273249452166134872678523474328071821780906390008173369441984491029241,-4662732780063414119375861525754752584616612540147274406479693127818556880998038943466453121632469273525820479735609794264237879474527808465216/10239866849006366683211904859844278867666745511649341512323606258714425968226724215432558198400940728308813035606079841985480128242927650526269,-145015752203417740627814602824879699201424741525266330972585853778148773144011948595071426531501764931494892707462335751679226422664091472996322/229910961375688283788593621906344306190983999226125278116317074323358180693574258482117750377844230725235399180626928435807028671008383952137005,-95202327339080909540858446542810840712477960636161069162088667547932469720402213519389090761601590885764598749305122322351146622743315006121618/150210298062783744746389779400662485629337570377972014819405458160891489347284451579858101691473353822227257083969790031777330883920638802920503,-5944879476751938660658504187540645039269325444938876076100345579803246945663001400244485719235265841708784129787271196192152661207968162595361/6801322499825926831463836182266452558818066248963736218487707232071720325279615257058442576427647423592098148765047367734767427806148474431121,-1005594369349923285882991293831042996087882004859079220755260426797837482476931689656177177214139263410879655164084527855021273920763668265288/1610142765312486602201088596964346533300043686417149358185015438333785482725102267044279866728634636693170383734991533062604764624339671045483,119773459053033083278343313002825307436107205800187941759980610023480419795655348602493612040415257568664236736643959467190410050628185447932/462756158029856443747146196639244249365944105374124823979199205373335052380843118733631999689289837014038072086801768027458788686697869270485,25159121833697986099005603169987500756547676742283937109106676683346431908951939419060125646277862546191865666954345422320718929832468634487/61178869717374688158658103381399069653422425912498639490967598708741873437680263880216976431075899690266021733490020620762288506557935019512,41908632283613617738774996886543402138865135772517517852377012529192034931802645898629046581472916620383516039920644702573980136861941734556/99029888066168402867539225843142892946420690770878789755617880024140687519232123751850508184108696087761921693464000384125424955979891288261,33301471712511974369190185029353964013598326724128788743735515684742964462378709222058176555494778803895486199237604065747980847479881289966/82892899862067016372022165004949581408701236975506624408455015786533854198326174131569390891435015786644617762817731051052071860695124784301,15153652133802492866112560794683537723826202940708356076598646646787410353645153940179128775113407126789010242047930554199045805862920892748/742712742461537718210901701563841426890716675248283990798525867607092800549114638299964425636111895900954061915313503075336435858452719348037,-1174131267248132185459931674313517572583775380470667586883786720130631794831824550673678923651786308091369819100306449746769071031750696020508/4360110342147155416066525419532690100039432132443458821508208922502098090915657767847419023949917559651252044775075474731635708420984787101167,-6393066891070423654068160234058064015431985631956137279391819267776275863208026372197861427903128177129490137570936734710218990925993258670780/11292348080041017080289500202100999873522452089028734359126682666210493132542633253948476540332720790874157438415827632482176965461312134815101,-6649178512245117545208949001415280079800076370820870792534366408325986332254591701695106823117367082774146856028659725171862530763634049216868/27119514293674520370136160658510127618938814684276316715373327042807587284008701332743297560646200562903264268075794528983039177258536768701279,-25271192269647775559041942027315851679365389383312972277755567795966008894814670752825547737558784783707813546989862103259898090851014301696/203897306416655110648711035021019571101011722451587110545805567207321869943773550675546349115442201689987145103518928455411308510227089869793,-20260035580036205684769464933784444477723043471921316205354413448275675888584282106262577428534910093802816945257984562160914878261736567776/407868219477745149690540258341155944281751521210367133082758206724930554439560443707584937854598377079892846615846517136022095280614580775031,-2461233947016205941914550700746469731794139036003882505141308017136671186151990026445349271591191548801802716262890980878768318773632188102028/11010884508094970821104347306848851315763752394805267707577685960655247313340489529944662429776190610242740907643542859895538938082288633294747,-438431402379531501394496429851636228202486142605285893270650189474888238368329885525793546889616751265694561460249235292426423802174928881810/3350473767149539754816596653052196729890192744257072596878174741705340225779215781642751085989133025295500989050709569295393449651511058743661,-655705946702723891550840837980153422075709454953004723465484076628989660861995577107203108641149261006862152195011706346039053034556486806455/1419491217437126630803400950384833024401447695554631126123743865974291299048419667427255659240433745835066510933648055989092191800559933715648,-408599035972537227835892286079809364311774048854125056845787199769826423521253940573493322481315344791759615790317812283488314698416974038919/682760113697947718471570603989613034423386204662250188095238131270500053527281817529257701709082341968166254864002558539162063729966013629758,-457351903244127222359441158214677194207519215414245631892083761256562530557351665611148466353692648610238369391279294519471886721982899025210/1600198852237743448590892240952702347243855940231049886681020348948876400286102999250688278913137438964912666564714687084443165898027808410527,-8020000597436372047097059033712661162288174813327045307810751026304946677954700262024893705671310913245356749768420847224950082835503361085342/26158582156825723675423085970606059583092950019161126135012244078761704320868685225777008207416158018999173913132930280117185101880722782067883,-153617813704706548697995601923771791784326975380153627300160935994820544719832148683003868097909920880858992094578859101452756513315877326938/561051317878748417714859912756940455320332171809578221572612680491472062008725996208711220513669845301059807825564863816642067180187373168731,-909701896262308667697247425961787539211252325655951218643168749044360804906752425582424456032008270184873647013417291872999667785235649665190/3271523885872725152821471000757220149654322841216234302453262499511995649129904713619323941602350254358728865486096279119677570357203648284253,40606713224071812781485093515044332544188149033938729620186128259926538028889168734505703790052821921717894905731240263658542265492355692430/68936233045012756289348309211952164983562443187482643860083258355275290250183134779139745152918159493833051601566628890843546487700687389771,-172661373259425610360074182036328062695936439798714305889600724143425746285831396504420781940512134081657948776418844557486046677299996864536/316234907129675116023557163272933779835606291709805971114498863991560871067864218336045659444246028715721193235442676847780373018277253899357,-18392574328382513911228545094589236256495783462479234259908549534701195374626544809129523212190557311545986787355866444952253208499799915469/134683133189731367871338601530851145032154216339198563199717510976943601792533647510603666326806884024098792071172644850078352461846387358054,-70219066835352295990924980711759577069734053695035234163645114349099636948027570296127005235073388096073426887448126649454305898832564144023/162363174377211642044231739411159400702699634404619106741343711999648272041051625652477073570297944216551931751876289065273688548106421292428,95083191900877673041152652044676560414171824245883489129424345921474336168895892145490476500804240684123026318622497239853285735685228826754/217727876654834421579987637485236428585456578648049809328279400447044965891873912110771949458798913861229645612862527340167109858947887130401,12260519348063351964561362646954320155706524698200933515682815472175191600214355412269690771184738746744912717976816352495760299839383104012/29361858217888723457671560167736770685389286724444401248011008972879687483225905205402095027032038853950686674666128580306778497283873253853,46021282625969024587056732181076753905706368294456075925166258381552396853263209168239843222045042518754069347171182740598902277653176041316/55634936553003314550045098634011184232967741682473100474288773545193894890850698551968271987960626084742817423723962467667636022451037443443,217816997467114792454591827261685282087529016949434547291328494025446823343826063062174647878911892282190009002209150927590358042384505710336/312325828863949348743201448152828457555862816315366122275125332572713404025464477485969175768230891855283039156216016610207768471285985458315,96268820945258788999151684240087036124950056375101180715611286455989341529772152445857734679822735855055622166632704128344871818357119815161/128329822880173000228071573431338087484140837316284336474684262180778566863866692257869743544891808149338691731994885875496339794739860973667,19370590217680297222121910635535027051574974079823425584174387686815077804141905643807118032232205774867946448294433894420934363590950726408/20726277016521895517134522195675247392196205825105920341701056633253926954096466045840219176532914124380126085816425342188573323485578366439,157298014652125444817856075492246522074984285525381303653361481022306506034676782183806748378216640484440279598286097114271738435463754622187/200644097177784029737631236106066192551040032945869518788303983538932890244266434070918842743810481611862615998998280197602940352151515404532,33210707193922536414403511821453568518064380724495862491860803884572305555471228940786296273901404314665991943260665300105922457996757433311/46961008792679121114727763871358695520244905299934539848563946018336014062877956255408895219551428193205723600606989023986023667628238912391,-33039335863129357635172631205747797745139432338071189131863404515051159108160214046822607971047529422889215164839765714738936970595893975517184/65819526768905153446825781025174501640009358282688365906316315476669332207887774180130387006543183986904164391687322074040406335558753745549895,-4166237019634330660221449344239328162414350351345763097844379984275253494684577235678627280673137542979543194196677696762541208456226300109208/8493550326331127502236751069630782224606348262183539816581342707003152739035473474429890813462806280379250111988814703669259049057806334431219,16330848762320743034771869522361222701697882542887223024340150723814397563354807299901347299525137303929932011380956750154759092641588032681695/17749788383302792525904935688944121388730460104511797737928909708285131016275802978301299869951321092277626639585304307327065610264460835005661,229785979741418868509136245451137687847995333399573574248317268286057246268672938516838583462812828947013065585739870906748634721354398897902688/280744616506621812856360160154650071462725812015727861918364152292745403480397251074448899616767116521719769940429279325519422448396684877261839,-695230460637798322855422922376840055313751172282353453595790708431469323102570443380972327711746823577098565509046713586830207502474582261644512/2613814347670171864479760937092643776112101013983895042244019623520927401189352062276913696060910079626947887551872385231479973261005936358320765,243591434352828813190372427598628852008914870759918756302176123689420130278398834523716849959616388691613611224731158324711195638296033834423392/257239706801075287615040012641709499926505707814695788540902421783095418403998783106250154785551402946202097103793587296453348915520749771264291,-55562723420230730079115589200525017280020776448021040978676197135113154518107392526423831060020155341918028686490570549280174247826515282146784/199168648496853704538829998222180191133080579919704925746011277210978331856069982312322238631952574216832301806944856662648546164974625624299225,-36975329909748259321712932648621087674065514012774689841665794810570597696575186078661410937720827030090564648193491960754001651896962429695061/40615827396329339794503270783289785654350515834106960556265437512040354600854306641642015416543233478430387915170958975107785639132457985475555,-1841475023658990432571006590800153366810879871774292148605168382408170199093054945730198791524782021991015807835409247775883264425799224145903/2177828254280864889848651187617956961830894375048955898965706277224447421735578878527231485877232624011795711113975328080416256368382973442630,-4287762717126996637217248933777944591884408713741636397467993826725253084049245628304137955549738952221942770839984253318521199855035559297604/3791604480843102697851550235548941232153458362555247741032011772383756661120397695281347827765830578287749443110548887082420612179385264499683,-430888527668366985758829692492080681847995533643535290298495270514636917705344344391064284048051156854314759076606516966400282592704821611296/2371359524127604312579090597473127086352397295075267540968511617615168697115565782962533792767695216677257302026372919544694931000570721131371,-45976603032456449075338721973322581989252717621513072920728451540061695431528127036644352138738946003609952723648195766634972181351084136734056/101967893930253169662081489818282491556613104766756539557008258644499797545593506548307432057661137991307987689374757959001918745156078284653045,-1611494345693871634470329501388603214611212337663169713100133398586858265754169488224008706178939929414899343570872199135341679403483895395296/18969971932341436951600082344020623614298328590501812454011564726969412456198519916340226338223392450700107209534270627871700861459018508708841,4861324094287735783089623868672425495466789826975687293524488169269400407113953808408312518541325349531670480598879374999813819128739328377536/26632580213190208549453476564742614251994068469162368506069583832670018015145625998223204168753721339926695764600488674762403196814410022295243,3144999291463454126545766481316631481703811610687520957705196019309413623459442724234898851148526146094548453756582307078853898227108981720562/7007467874883828712076105539646669129136878545659005075487475487976777705696038085850639820449045743266306599869505285362104568634050905202013,4078334180047302768836615971549877983649512771716745246490799946147244640561547758512652777605158766175178823582111741710649425223624227492516/15673440766559405270981231637657419902917427248394581917449111118292373863886490900564507567293623971778386109157326554357501831258629025674821,2625856386458921773160663700865048905909100139157508280882380749738194807462961648919154363946317906857297015913968023452148773226899384690220/11968331509370981095882076849420144358285560254606405998526743112603004913759436955046994613742837049405635209790913210771740960876251076033011,1340618563736747208686521173144734162926701916056741367407051966985460080268641066633927990028726766627034419303457822570956289180733422495796/5196564076012217622090586328707034370165959946224644449897072087892419447760872429189257368759624596389177930405658523097491065966470501420445,1525246907426862845020986230117275765105276094609902994532238087186932287817551851883582342594049149744114040677805406274517444559164926762116/5703687952966315023811621699002679531936031250013167904957712616494052253758139238709745513366805063086446121764502522203435832187604678488197,80581700599260353962465957544546366919448668410464279451779971708887636156873917023678441729355059491602964175396627919499768398438939595576/230098692891745408519078943959265694784449239921142253927278923803448682742132054411061090012901331462760961517847539966257010287539983322071,-103004056574708550833616714111589500198479111611940366866077760170320164825532719084510747996411992430231686619888226442478215492300496386403/2998326004789534544697055896273180037039118288757076081911582930384573200189869970602322262646046888491006952479269413987600088879862309620740,-394455119122118454463630280259975903383767768364844384918356802897341752217173251591909310397058398380990398798951842590044642832184963963502/12656840572542950583039818335910343675093877289883353290534790540744194965549257481429611454783838687162498828385583246122810235360031875192445,-367065521669929031649416034650529636996140927328394353538676138375574688521499270490122474997800461782961988485346918081366373833566812572581895/314695416157719432476023504597578188656167472208440245702661770801538074376977531333070691319692386066317715867848249800611994585853440656853648,-103935901169573525451021592002011203122756160686500498142331504078086728799575652882913990192960449870930932640115527916185411239131569466974269/151597350603343448855663890757651036815774971121183911040284888403032510593802614812061278316171833086805121328822865649625428118966593915471912,-78037214334405439873557351431397600927129326044536381108577594333757232372494204314868930334342217642579572130639542284826908529252459221217019/140159626451475898735479653179584503329523737119389231321042719333960721459509797538501621941765277773851520564043129427194891875489642487069440,-4247443821345539662921564012917604902200830942471040823670108934173825088251376576729534729317767273854090132275003129812037060061887876081831/9459738949521338811312573142696395289100978523704243990500762373434083931331076030105146958638448680300959707104561715838717576332566277355776,-2904787954024244261819337943486336360771507056208725863685064826090272591307655503952653487329526518893682023209049333081027127687051213903995/3647587376345910659555162519736880468802789469109463871001337546607172542500619476257252010903707147933933704066762572811599914312099558000768,-130507565701108027153585327078440041215840902555343065315238345532457655549870845516640476931216561349599564066442854432974988448177812192839/295799909738701228962298029056524357634977759080560602491183330030049589907659200539214250691744717713219542412221093232888791012514152179968,-334826698934105273422109960616970116364058084504768967215155358665407718073087943623408946149055462798482288702898446066398617905366363043243239/505011863738338385194059146524546906436965767142313649932749275164684428798678013181260766795962493574996020803532240631208458103073055772106176,-162852329851739661374263391924188548363466631209647165118387200274823324027058115027071021091262417384041855291113425759969137202506922350033067/325161820706149412117625323568963215095747803668998329350900036757343479176327329777834680687735991735288858390520424450168340387711892809011968,-1031319422831677471282386531621359942186657312331506609656144679478119106287993511983292958964832538327394876192074755334588039418163723115691/1286796547184540653394139140262038070217817112228452634883216690225781133575163616218489350196470545010342868413878844461062015665262112134652,349260282505684096747378691813792407634462378016913794342016948817832207725041686662852254302522547586337219606576241551856999326253508087530/429427751425308089732644455783662843721786617073742870163003704126226519727893639712647267617927927213296917722004819763026922867896463239849,604684185749584935984795759279524710816126342083902138593141293146358527413164608682598335895071674474110901838815687710136613956922443648749/1134115110048592057523257613840176798347317081701933563304352137512450632894801058122644752940155431816831917623041847587823147526502374910735,6880397359434943582596859185947478221961221914160351366509578502842810831696629167444811203654247653877302037815806080770759575455425270770941/10939945239497018592602703751849347296361023318246162494319277136907807715713385997703476027002138539190153699721020819428530502985976187593965,4074412746439296789568488270622672627570466457485708151973100043641373385830331486219429894839287054020711711054918060291242839751218298350853/5455067159291440662156176642805153321679567007351932710786064538161260085967936840698785905999005145951475909433438115004644128904828643785749,-792993353101373364900014395710602145180294310629661177014268384399024627174087276013193517953278069254971558665347624982588587059547098752365/2617854593275718593987328348150356451568140705738332187064007375329857608932497914613893642771137202945589162819218825793163590988482571958144,-88702732286767931114280590124731850569379218369221108207705287588128814819703920481724709149692763255876614250745649119816923199656977068133/120782362339259362578136967322659007138541555316508565654461423549498395435377049448874888496547442388313018460310642880003383506280709962720,49690070939025799343923136128648168240050306608902880161724825189352477359077590350653242880431107727514370437647493865921543391780388510879/72443270932573201126818350540367775392975505567698635895864519560342413236688719919822435431300772615240454267077623006679538059667896772536,55594073097473882828954488416129036952266104163178863240815102918963923432416571676582186796697755200747582068734298990448995607333568620181/153421265962240779503931563158606887903512729860819424024146577881044116484418904997107641479769055747221782752109570038241401655244957325672,-193126469147515509022354537123466204834018660973137968655539780865216012794769335344792169564464260177872316861990714788223820341985330238999/575161111082858134055026162790894368424945267224644989552160622059844248165132265065540335221297554074586844444509398721801655941639432127392,-80716488140548048521081862281556747515395988722606269511255855775321071859646803355627250209674789250471410468874892970673531573131759272967/300657256942531318701220752090921982782243006195271905806396000791360590511961787080532904339752244891601493960240404910226710325031057030624,-243954959308747649557448181372471719115349054225342422043273273399573455922999913646184068715747373637382901775008537071237622297298791781377/821610081359631908887408133139105810553645846329274727366307571348919625689557504198106412556308804138261802042435108078355252987372469555264,1178696730978322662895530133543162577977748760389819699000129643589892245505726320644238492302928278726862609087202886190771627953682694857669/715155649554785503797674682741160395261241488837299896596682897110873277201674276492162585639003914625427160697629800678078951434201378671840,4639495214915162056268418290954806952421849284812718919061188317519970694868959700057966414619765597295815775870626155605160858570100102803732/2864908555432445500689914517663115885743862402559878533494448235144400897645757769863309497154928708899784340172945257170239401484641204808851,2347257041075611221601561902660057513716875663631421227132550588949319574768467423276965433451807140381672327739214428500284220228200615493036/2437690128223777311144694793589850149976921745437131088753799861063719189691481354128967117201770383121984819740424505461777953695153233873995,9822938284449570138367199872631833711489623987913374263713860914539727562769003950488187475152408780434960563323018078295464757232277103238313/7262926717326970376731523937854246840375595328117954100066537406371208319648771732328312509793014772453006670346503801474614109527748459372050,880991400080774233351739416946291920004826292077556823071351288664966226746247222959149541429674764082675294792032768319407158936572563921096224/890908963107551097360893721266458218561090123436286958150921497773813154202892004730138629679006903906394814849585337701960044755609022344731215,6116148967672412978973790640952000826054702606259141784732780737363834185257966812030478354944334618985611977554979311851402781384418066781961/4393507943487306690139559990478668212275843917338655593080369438352784000204425673528361988458419150811677573208757403502587717620563540787425,13422264893121343888683025677821118652263873087283248535788248066801935778103213716997844659442812472411788861229846882320282029533771917068/36603928800707071859593256563159646119551238099832341525583965235776561835805421692796087620568282298347453759503788966825748249800882777859,1005824221624477380432316331953762654878121208786353434692611936290835245664379389878153827805518318234372534961561727228727991265606280607512/2959932360041107280798921667078405923542059341888855949937290104992494880877389171644876578118214193754034076146925029126605395640804118124919,1312200166699217618598111011918524668387895737896113693572806711971784043597450750332643367211950976169169761788983807091632039295578198028626/2680837822147136020128085998349046637566136454547988076879493660402610963072486889339379359203362154174120699632817319013038564985974769878051,10047063535962167416779206957739500260178416279083631857769737476811037581923747844546929796992660374687100991207203332021245514104584835587/22558174890244467877730715969778817045212922539714457235153177733102331615755711204664789582705466287910128697592762716095940264885385883087,1462438596332289424266904992548502920333975897105938058873899424184077442985949067528322197075150492902121763291877844772037945036315043198813/2032163571076668709538737701321070136376800041367877047210923696668494873356595188530340806009595847025652263636585997723947935630474154460696,729004196264103169177477648790151676619916737782288945789272348593458193884166511565394026205911388611789175976104396873293816613903853581967/1545923948880623289645948945797444914276950371696495767198625202204762549862859474797036785777059728968244988720767923727933923485775351254564,11974203743282143623044148514413843797238604601910487833596018354868178672038252420960810893646842083012660855782290783130711595511258319772008/22080775590811613345055717682344364414270968911053168733206053130898188342621533914329339071567488617551571452909316296682250674249964618036269,41954187327811809738549208840327900917388021752723052697633365707183936975757354292574460408771550970114354118881631096940212958632128385018509/42847815583092120710749218583989778649164598002665474333995529610252994259544760287187241659003400444710432217100849385253775643625498567002450,-6629667616933692146619662547473273523536456338304026303956682250732030886522253783235039783566132716840332229402909661373508653787954751141/10817186933739009418245194814097310784713001566153473015854517257738867491990962434464736895140979659588723469147294821318713185967952239146,-3339667412573537242515224609653758729505806871390983801614813933715449739637332983905436811600434329693974735222506274786999102820380842735481/3284777548626873457018843821492033480843436434435243156543491005968260638442883953714889193308176218840898722717695735317014763746466433980036,-6763083139977580146819170194285822658770800687669123361174788898446181959268260593984498483392297207836455573544268061160292401708350767768301/5311232872630062035057111886911123539080721346259125000291679240295147576526450216470113591270963630956330538038011329029250714067818174038976,-2025202709667210570496661603373160156114841521147755067413454767992848310899872366812875607137320531712157649225973994716837588893094991701405/1925980208640546872435083129277755432481598481714743069754568452922215143029115932373668097353173086042645346762897102578447837941640714417248,-21772788935605366084309303971288020024388375841338821065395838802563671672704839782245160460651008808578922997033843986817451183696601003073631/21186394853075177034767022459554518155708828435079720091876411668949380760211527303949775619256574406920534491275693955116270730481819150410176,1113445243187913667255829652348419477468676596748988739271325775459772932564884342953377773090063280914365107095398137302005345761989655028529/1057654352521204053643921416761038425934271151774699575176813636843215844364972751873145205886305624438825552986583342981561759954162567082250,-513448661090422057461426142387666975056269049154115598782292515826547409192345848659884487204263183001753181785310682273696962596663670503109/355640865613463193112070081933069550485832381301344009395234591474916382225692306241603749954559541005133607502846100134474379507985796580800,-225049536713624036686065085861268480210400769685652211146222486826487817803350672403973735254022520010251716626627512031367008809934467285552/645910565873564265387053131653358036911331886784343655679015149831991074677785026798574284054793850468302804288569566111272965059857585576731,-433678369214018197764870146521047343496809467520665600381060792896527603890000470077858140331515913566651625982431792336699077559334229681612/667057561374526483442603772851832305007465886729617611036418145070527382452792896297130441629242698767824568174215728628302430912542375636411,-1222551362179519624014787390109869096563655428754526262776957071293378716888248326248287464839456845176214115482223502243157499197395307580904/4554817093052547395689483763218807934547342751110407903131345305228579445920286734869856849088052564630076090403307426001606318173607005503993,-1296930513293894617752543776712253121886112672301502060195418832052803068835511551544041232836502509442683143836663230214460762319038834407728/4229626135840597135270809490511863002018209452338318654918649443446178534778273037792044172577471954913072987568089043644994300726095953874507,-26341551800277598910570751142482538443774176629877882208945356500237760425884136800533422041667420812857514926578714838033712590382500811263616/64825574826724550586298040899720659366198505083466593343221132842165946843602113286269295719589081740720920530814260525440517316265952526136837,6570432017107188121277872255215747860986940413049019761700998969845543081775003735366082935455634660946534852711701105025639864036278035632970/9897550592944472009111221587739215661143107088145834900783631297184830356783130845568252250642173542106099997672294625866733225276023090807067,3773839629872670380299452714613105406562919694935394300719946551517890251584921414487694849353219403596095876876887143347898814363821615604050/3716457061580069688666826396538334980735207457475535651028884493893774043305620146976094665746007627671561992118212095714256500590666730605953,407549032638208750425999779316808180958771356319722881781257757624113534683778864296025705358235954766809667663297525253627065817741763381585/470253075777881341623944461599348608219915392776653490782938193436704352388633097025640033179544069962143511826120003778962979404578325527298,388503106759112958889612907844774190544737512253890080677956191256249635534354962958471454957014567979678918467343086011101590773684283563358/510696581870049491121555742668799127862518088523030754508579877342919659086458359651283482752442124107061609466427314307450448890563125898403,559744805179412368287191188456406451912165864011577790532747477400392286319305407034129577428741997979352577288349327923681587861471295338256/611081203427635088951182221229432078846557516488191793802942261313637311230052020143992335705304297904639617585344443672629356266602541506827,-56841002496280516575866690182438194103540582806302116747347299531662403946083028833690784299932760671628407904712828670988165935611265275883697/86015053898291413891942531417939756062823369588140910994535539717978837624615715017850356038341000037859422202588951301697537953526917812078912,-1124480728740148810463763819333355699574306065654608008026940166044338550719227258479486958266785065679544006095457340226386077678392344693/2093792026082855161252518003923909401856217792180371230048508597875162962222529437184237925778472884407471037578699222646936511784626928570,-38792619542180205722484787204760565259679337820774767453094002137377512027827572318657464913153586765233942987306195025853639621427536104098/79817517754689206047168870508633264361634646754159466337455362937644275542754769838435958671608445042508662586838033010644429083427556996225,-4681193719349545785831949766003078404087217167762651055495176246442889268009779052893899785230947397672170397507528810370174115709062738278711/8583900832627430923744031943610691632313998063229860279388110868981503898224142798349290273283639774885375621891627624114036023912823286353728,-528145689157753431478357610243311984017774801738271237138125067821144167204028339485474724027859429427543575792979760484900201607240871118495/920364484037584622720614588371154880834372270650736557896620987228710510395137808036017537864508254941243128068637727425451899837198418808776,-15718093989632403640735167511185173628912209419050340116576115162091129697441373722262215123861145651953792199301722365997512119734338009042827/23677525840815643536395633730905721550481224996414047929592096456473249147356536600356103492115016345399991310353184797404461887442046545516856,-182690275346620828342642750338046926628705408388377168577916432945971404596990828251148531577122166818932672211405353669241725688962360209739/636172179007656701208006650652675035084660066030777718588897726319509119390838259119437409136708373232847146057831398099262710532457558550777,-179155582258313896922417367586543069670515787916150328246643020697765093558831581035846678108108253105162562514266710515581089053592067908369/240433518216728177338215567136489197978990624963870933459801977833652271847006234099850997243678347456806051634919126526401698124473452440480,-2869656683360701617088176713836479600783716575644609438304199968384731727293835521217565321404188169538166614898052111006620874709311252705805/6163918305200613174888359939144236911203373862807272615721430079416986299463622792263007571663684752127643955118742737812246849274018551273408,-13359941786557681680173775839678271333681225676300295875330659020281106441029658394358998595199002854700159890797171902265970215031046506193/18505479697604304072335903685154765712544006682479086846706755274538432975339269720771262398698449729572509097473127805227342644587130896853,-19218164491155556721457921726837827808639735031179319705586444853592869329079271634935817804288270284223988722514908925794838716262980165099/46974142422562944821106414692655762840877062193288267505176221588450958376301532083805569755171393059567140974061532072107934459715694525874,-2154783606392408382481662450455798062381915144874344561681711479942598222645804879754132770585936145056124924566316938548514548560181837865/4239058495968748839513679493765825789185752399587618875562907228542249018551869477241604820468864916928619364097096846169017788758504470624,-37498710473924412339629747878207353338568032048142017377661298790432827909701012865770839166603398564816154007375230260183858141446806265448/90398571049233263259687520277349730750863841305825603578074682578225667665361237966673495604712949777411244573060426042472703479644926959539,3954940439436680484359644089940396789200146399140912124515928474460206460657538446963342840829494097140921348561579535162364296387782396570225024/2880528656608147548228748514066707948325733921319778424095240564359189641103375843288323268355245263996764814949652978360595629550341171938572683,30595383248229748583135669781609966810516323273629553002699292273511965548066346937700216300781697746437138791789240101059492198291046945036813/28611911353349491364691057949431877823478256742279623936512680191135365339720963859129401583507795548752596646426086691403887558893818975068641,51304873328896982539727586213276755920672756745734364133983442638278768139624381872831656704108855675456428484938995234147535776531767154174/44086172049170820733575104122700893188732942486708421230173992946238649130948702932896547744289893177890335020942695314786184670191830024603,31255405908899786177804226045682611954920819978519696043693234011624950511907537191200196711762402953230985577883441464447217291632845863980352/23493110494556749591190479964122124710585571477382637451849584924813505756048233021182832087837192532881475370679243437606706608779051753965219,32242443650151399136553252494945147162093633695518326802584996551377718678131004597803732690514711074638205672054905319991967156376510461063392/21742489184532119788508553130321276127988596833290633465759306398485537248660458107778650364664499487282111999987621924685479097990415543425325,1054092790243165614916314988260695504545823554131292673006971706144133527413911139177950468715353036583924609531827946401478882835830707621846/765216864349626658679174044755756780016752809403973474069837077254393638697654546896853952657436108111027703323641928856494202451497066647529,9525336453051561018267256167118236458289454147861462977373373543460651747955303657521000403605844695023197783714811950876123616900411391008082/7981056240610405460488130123361483275607482866374804222262336747210514673263031765527791861819750214676812818497757926583149180625225846400431,192236490647722161196039522080013542780102397666411727091307874217370860051160647932953703126049049695135238413064826988793901858123843265365064/133622875536387995782041836354882744639880216273386090423227434503737821294093447610043972142265620571663200985024825671886231807042574654890061,42702312596744501843663045204574939019952770203081498578240728339667845829708226034042920202962935869441666437158604452363498934838095439938912/29440082186335968398414041421508578579922043631168953170405315718167828470722943581533403661167177518803235844953514833445401898581487239392075,46243665286696319379193776325600104417688254270770178912601306227000490333294475131582726281438746616144569378194085527863586340986497908097/31116612495967173993476623911133846950991317218618962901245115680905801379030567577478782187872634429440335543422613656010962950974556095375,6515683616167860883442105565806561276334389009268481098970455289445047886311890299152518274822746830646106896777747978586214506519441835754464/3868500325757434566807274639364240731694051090829644327335100434049301638065398029242153654943405867411420989112529639314014953054865173297949,22059154521999675271650731123510866844936141850652117310629177975677387415482899406340361594619750031601553434916063919045320136213628114428757/9579336063799606267258485627027714099118687252861185796606154821165248253550239892055802800860803223934334480021700569899538664296658899317794,64352569562650863929141101593767621881258306484353369360789469255158404550785051796800586706959087050069576247291692122802807211527919845904167/36306208442479257898743498761869906081947618582900061154894173264521844371601752406603812428524417297170881262753053829145077180222061003462616,96919532112460102238647494939573299309902777782823231561529667391021757141115626988474758400830963782047230061669713174096430078774704725529991/89145282124065048828250912180445229908507013246696516311168500167777880744452725288176364561732294435436729844392996542578932433442978425600784,26397297879530349926543213177224258837894126708268401680584191899862764323631986745606923654317025941055684104121605141618111411284613867826211/15317701405130056470279609907922441462107307851787953383425371057183383699000592947672525140659543937844014053451945296807537990319201461511726,995207214469032773476401626707234330865000547721499368134542462506662590862888185976424621840362242999812302917094665644322002586519763706903/195871760557563986330958739906913951095971221102555345694074580752809777137559613437098218418227145231448534483787965992194870142349722911476,156341383153394074279231314220828288813507705582795706812327166092055468473849814048062685270404822837505834131759935236257716549216479308369/66547841955039262996193048771708482691846001007143415148635291958666780678381901121048449091008599317005408336845082932275832367890542518782,67058725484809443011308407076027703260847983537046602749264123470935607617632834573609240186691227628489646458116051044354308190844825870509/76629834079994116035937527073625893997109855305501517968146044662696211002606859516250189192717990938701345909529288016187323172068123097248,192398607668447628844514860162059618891538725126413790773538418294674812707926394077218801012901464405673977383528927867197687858763685323272/214591304963540515889078482263630171074241939928738589324786386313650723255765569560822086168389726033644674470185876298199030450756282374685,1912954034601301877768638088350741664165884535032800203404037970238941754874053619583137914622440965785862646780510420273783458747612493244708/2349496712421256250243747018928573058478881126438043976825596781004744904364133617777748820783162543019529015373631892597640741815055657249003,4507200468315290758958401269920231581099942241299531244478913413889892052460139917655615214991148534123005434515224050808527381355290330848521/5730459339266197009466866703510472110529940965964548519850835379398299295989957601106918976850293118328475863743992412654969139476839919762216,4006177415362606932353738762187707897142246159127408193600582859968880373178677543511564114111521197421534770702931552019923575423008874682543/4660989883020277959966263446429628030360903727607047797089806774662715523798632696586342915382098107162511618976592674867617566751567817380880,2160203532804406524214868066738399881686846483419497105706181620171648803460217141719182559562061127492781634158951598123291282309404197692124/2466961611034066745266147143517135501911888647810090997871588835960210625036318113031632985771364227555047986307346271412265945675972353236769,3499942994484926959562615595167774239305041211002146625556188165494546072487145543737696003560133331171451041860492926509078237913715351229998/3896715132260390820033851045058618529306491379388921359370110867196994045194670723874397559540990340611816155146103329710552221103023992383293,43345087858995546803534970761385173841191423921110210473407878995286279852395223155596442516309872583662809073626137826535321332220258122541/48201417154094650182104219704765446760825648356893719523192737243382478045588303554921086604914233609701649678485988537801700030098093486131,32707837037134857130852016982325180253693723340027587414188216985350985849970822199012247749988493048640296318019499957479977396315157958438/36101909874888367085608313406682817379943439237895404771918640470187767274845763303686747480643751508981753596896372718239543153203964048705,501750515996455705218524801811989655437943082058111764650450621453025175693945872732869423012505381367619872257945170417799853335469157497429/935074770227648173380016484464232030398545438808651935539071413193914584600287421242230813864892330822976138008235679923233532145367083173016,99841638102795301134125712824376955680288501859880997494328445121693718144060315557694730572021599626276291950638107126953438130026025694301/133297237024388649751045758493874814315937583590634709535291296686866855469449686413424758484386026848441512885316556325894657225588436065612,1915702000691773602706498218565227930242682604786831571046822463836305726146557887747044816144780019913764918729525154646461720509219902737317/3411892673944057807379502732077167017061358696329923754531326024153302406261644473853746422105846498667766027279282088387583797820235394267514,19423721730987356580434810619976869430140480381987844241298328825647176041071328977944127679049804530446358558077944736647333791283589800289/44552407546854233652794759176159405891092406648473711453320559824816004219312342435244955433832989864685008978819639171852042693322198869788,247271967901680339246788564393173804434175365544673976045463888504932788471747422922412407494059758101523689932950954590530265634105406449177/452401376288425019152613752467007089972943028222479144990004443021605032113505403338548151548068503336869563118686036338194268458059759670116,141616875619217932961648747420707428028102360473710515319300700250540118024461684382412310479102367357817111749559796080870935361657590021349/349193134007709681399016313676290109093587266713216993871512316940540293031281257510831308273801859665050280185063250345741012780437299379716,859019686241877422672843605308881702200782412981540097319179603570858192805686070584515406890238951233555090784656196951752228255547062157/676136834345103826197285101206353972431414982188868789344340182098716611939561244412221188999547799671001553483278554688034433333974217234,1250501290117595581433013802389774661936940410672035200859446582112180459176083824667944218956095086910721242700263458090259329841746215468937/812462889546635908174415885844585588102630435449010412640550348337637081658692610909443182680106578733099612584237914763981979255558124499868,227116675820920146557973083816562732469779180633605340971329547619173687641119055256032729667418007925716452348659482395181320830549509918172/134333524795024029533831982563669070793230866778053795506272420913843482358675455220628204890839247748684756866239521838435082465254064484927,1677482990176279938615952129858096808547995583031792757934957550287689567211153945612703392056168917395432920149591885997256383525581871966319/1343108591905015982359090537961247044221227423496991974809610386819521173021847443213112219016930891233294487058278975768367173383912946402898,327071840153294878019024436440746650112609478396494666446326026542926034315444267432235476872397144375850849101079330051214797467564564093779/141825797671844919444099635100496397698417010724465204751537980653364409130050193787718847189787219743577801793611328336892692672576043149410,55684042198151759334668257587162855980551175842259349788367029042958884299867565442616564662516016605050212259472200617958121346006133294843/27428395990082206583226494267577909734384318535978304971337634118309661461665451933072050731199172904873055093574595756368322654267566760363,529186519458875136340103469159406827146763735529385534795674198076847214982785147901104849107223751114963626698420642364075919510957764743451/241664909051622778634786273516512830274570423764620199692342486300853325652426058928777911648984671848731288534978242244433129813017196587898,160526881006620183247940192822929831520594833741858817842664383641250022790511492656611037707786675696721582464045610836143977955828235597057/64407815232597359248542607620925065709085067022389675055091505210815082865994964670887041368286422644132054142695584611074220059464370178986,11824836243943510631904339383477071137632780737841856892719726455633374759497296109136003599127526088212623451156138807675153523044170782746721/8183494479260965113309857125851651329001522726833039042336768951150828463281040122320535620675852939234612395008534052945731582704287634838662,5187434163063650911929687171850264591707273272461448234884919956464194029079384294616490093411951768531103847138521407285338360154678782776299/3048211379279381448814701680513415276107456237877170645412218599453542316633657815224556715901890955497737744202306485768480284028180062815008,32096395445143884507541572864793192644343031960367281096886618750460669366967343306963064206200900502958373765668197449903966378093379177160285/19115688074142431942483093839147598938073112876532075632831381660316851681937682219268426399230229075210321585063996626928214073666974890630016,56359047416176514755362123418343336699348234928068047857659189690741180009606396094567235698001292874772165595365046249102084329123960770790/41432281444092055444145603201616764568474376244165584020255566343855702031945631756125482917127241732049178683501897746091984317927580163581,2491215488839752866862880192489071095485975320157001031983174924959210921014719826013253507629102900194605563605148296090670655814713821184416/1683229902682679799536777750627646107827832948238716268037877609118156344008668239711263188171044351372374789430295817333114908788153358149213,7413842426904703349198203265383958119913921416776078399989589026390082401018482392102976269231040796112337373911385926912234840947581980781712/4993054330213822115031185332700932329622323999265374135053672301080466208708444688745821550944455914553000221944992080338207316179730478758527,6353440926974593045883752270135302730241199016175848823456024341370219080069693465268187811661815400612102989157160276829669834713252004634/4436412073042752586374373396130293240373803498521772090494122077315523163507778625356810409851294559092904096761680663377585240292633794829,13511349674586591310060420415311707355666681639992771400822011831068743061742891304717283067947402017522728817854899481200814285293306096695728/7627504375185592999238126353421268839947197135008859939450713390603434495505521672980125625361187395781202710121236496199259878322335566294061,1392953504526353227462248606728692404371796397445853068742414753244652431829215784488778851703399685419413472711359740080052583116032682916103/365063908077898246410006648579090442529325013361242720956693685199104212114712366723036344536124608004755929912221798271153981059446364466494,-72537752444422289410189311796026649094894339652179705817102684835187432547702427905316598390153381633805629173051750185579990795311195132367/131368870890621262453679604377582790415244758766171977695720032005706806945070392229547441985406383817748427148743825551484531015510921468786,-727759596867359128690519307298847267434749481732398526193316221803473248251808097968109153581265350669944788002592043982367596296913050397035/957381323179394144317697383309467260456865119729058756865540198788131431467861061365179872703574448567656910161443133562613974954361275757117,-22856749635110685341720122528288914958399492728773093866022303941182798294578546571080291676041706642165506203882931104101725384622182406686163/30279582936516255242070493628109761916395693364834192686223633745908217560979309125265717567093961319436596211430827743682845848911835609378381,-21976156419458823526965987533262414120996624078712971187306028936367953473472138456295774000576835190146585873352802805735548609896957983398624/27922334594175441069034707790484285380082757846208905796354265118262771330088422938769741584520960709665585201147906931934644937812892568739519,-2433722973386256255492680395621523524764312430535740763979267101229276804874742134558525339448911703774990800662237865325000322467291757215329/1838568143999714663995726189628260165609379667529224063592610026067124587511776485399757175578786059294822209675012595392275271852661100449322,-87059858082896182613350841265656253986546886353125062030393067355147271481169664248023000473090213996744264015928174546269177824702886505827539/64022397751807362434089055456485020649144571003914934985878575176860275184388090687333683477495660594229360036064219221563975805910373647672336,-8528470199201940153884244449531493540791870557111393353956459380766868648558387552171910831258474684918686253513465431844101411157622759936155/6219950657289360379667469187430965387590222875697085718295749630412154319481520022378097345170746404601983004000035637507517104727144987674736,-478582736224134184139371926873160231318498099022153604617495982187010604227162447728495343599121655440329860830604952519625658964452750093429/631137134083746043367568855618467105562263586947056737822128435711419217934847163230985570624922939860153002745690977667382490347221776669859,-39123644826464624118029578259394309979152991192026370577537570024911463408905700311717539107363664377946643244872326546188278482578477355309/83189689702403809666627804295546551349463302562172102023986361315079008263531447135617520434922980838989659044393682561394455308227204235162,27739924332729091416463481796197674346155854710119346126824518042423450247991488970456965670026180720017739474887216856166160431532443375997/182558742389499063172939813901509453650325731953792917366415014502882061282221579964967304505970321901309452175397820795610904851347556123764,7803858547378046720762922051371705849391108812466823498978391716756456610321502148961045988918055782305684200848316017679111102595551177872399/48797380219058813853745642824010175427384333998661910998640418324596259908084389386612030137526958813035156364518989019170528637225130825669682,-2469104281494791206992955407601084322935064456506779096198309432926461239241322500598110733243851236023655767437610373725734565486842659014871/6467798509205739887567724870953350920998303975698329452470385876631512081507214176804455367652887738347954417464859252701922292978863110730147,-2673116751599434835146865732721927245408205099008925771796133247166428971734227253091611468956165580212994073185442410755181428914359804846353/6962572026606739328025731317456142508821089462394293785345159210561189376078834945074420650898384908547563366855120017038458030090658445239937,-4312065688547770728580640802207690543122853941293963741771323485289428280583659780714790640699991553183960316587817569855700710111266670941/10105738367821849821332766139245444417703860121394159089065158939524279958416781409127440431668613045890655213778245725179801240280884668296,-77295620238201870652081505216894273816637246518222199137929785853211782101097099720584556614587212340225611247442737178770815028229059544105695/55494939920922926073944597909922450927971352575707053781911916948246287069805220617546149264880536248673319017671000332837664486880895873289056,-4661302294606129786642572927449053546831930791966824092740860076268633772353691352659019329308885231148966327610423388174545947925633408927177/3348804703123461497567020941437391151589690038642337542868997753791700666043943480444892244108076403982024455585752197014056523744984493926944,-8276798361988154160070897368670137892223440429653076151281504076914837968761283847851663147316493667931436214592746727590168155860321406176481/4066561135863794546655961449908355848157394632075598137388930273451716790100195457000455381344975378568257436918355517635870994030756525470400,-1797233291941711285830402999431270358305910022646033639808383030555948375650598669810094421392764541299667612147799550715627907244296654177761/2455962565594654687668609223702078326225991411681447706308145544895475613137865179138236860851610097672460791013056004724606103952721425457319,-5337003030015869252035694669811169665103320251520472860921412766388926494250257566847163610218814063937805299712345296045140287753770027137/10745626564292692048501936979931586869815549994337916096251651688211839396985825255942264708520619510917926505322596669779904928221026467896,-12132410655295498121977823528565665475209707676482029319376360387020260243677940628110143872771101658075887184572720023945470245936852245491/31118488279710234492673026883731724164677647486291455617938757678132716467256941513609748177791426109554714057621163445507945846894042939896,-15236103637923106933675826804489659958816070725658665285364078125413332127867753071095322633844273505765543205639287218289847070939953976383/53825923789866779709362493327052267101000475236253718264539716960718973873834122846216871563310488098011221150173909644908664729022208792489,-15184112850017475529055769749071775802780771976401495853457483374127336602817089553979678353245831094900713503421002902767426447927797696027/41406168321882012549789162305094922260239711426506662365897399126951622723900248131713441808049778918156934437375354180407447428881504549581,-2163190804846832584459100137182462746282567629572388926740367037396537997131534536458791222460214547873430222001528216414657078939830907143657/1700224459084083731537461390172279156691249075669688899442669846737746469397811139873851063882422122512429615300268179582202254572358814566248,-610461553911439241590670022141010963752892918521063591590109793593971272331823691181774535028938959909652175389682493287167792259189178399027/484050862111524945879764699696389775213670998823535311991026918917676822220055107483779537533983956998400608685410569093539612677923206704544,-109634144122003543379726531007343430211178357049440361343187130704642747205844506459593321812068991690261600974557353876472820227226624178314/214751887369933988692237651069413560308659948591224919031713618630046864998155246193993154999280321334780561287174867438684046194900866885287,-272867741775062255512479069657181289215710748306472680864803921996151949677555342010911092732510544991442237480974075566445626850854672591867/4995594503979217205392897652341522301171189376326863224997696201969507477496913239117829982301757923940350400332708160388659002129801950752,-1095917119185783067305615269795527191453601463397195468748396634989771509995074553181870317243900700274644870280040827782767091402477048870573/2101082172835426059677045449859317391040033077691299493840561316964318130435617823949296871201325561928604926070017110066469267216226296403232,-79202125052465283432335586262006657882350292491199784087334451080325586014654029572256331563792460359761086645963430966898076255294830515376/154013654981591238380349420505511527686898282953676189163681010195451132020725049457325077575154307449985902378286927520920886005381203442059,-276432444533084342534029720889388217658198398052845973260792502508863064973316181114595273167933330534358112483594708464188598539721584758393/530545522356928011460056511716634307241634742262617194479740329408509150887439265950927214734883220571956779714564789117677509673681431314062,2143198412291857244702292179802444194818131272155541100166301274586719921223254021333410171055129493131118118626266522173450636939847710001201/1756965227787141183824705325051834164022309080114279477961709618502618081251964230533445416297137707092236762212221338682843715542892518834583,313300539992273750340236561308541622515591036108450417956212486567098057423018350210053655937882573977404684623312951317201677012374784155648/1069302920436447623431799524983497155309314010145787824677823293038056531074878955732760588080173840778348485384859878344870866821911024369735,16378162604791766199412268927822631640417488639918499829191873730057170681699033499485638668685517295680166297164936118764883485583761783716/4230016825732187535321630604768210867275779884821963621620009044184556754008306986156448102985740292392669224454073189692459687864500728073,-37709601319963354996381038578533948125606944258559899555919358733811467173230041048400492081347354390547107700300697271031302666143567864238673/34974488653825593056688169582793513594615485079374367590374793113122623011693031543437447887459061673747418694765615230719434287890552275183892,-5725028636394289729683826573963766259670085140567989218619693073828007050353146172624848227872613293428703001880488309674005170329395926478561/9615790748750231856912887364012117936033144300991052309928645442571687075050866716317893486886012620812770516765963985324083451088948663256763,-3032691404963337263934896019662706799416029235720917537709723116883837349901634238181766399918403746386143936505790141070910026550512458286832/14747214503250273782014945940597104556875888795107066622602600809435029863413719197780171151056250366458856787875984022244049518203707742011921,256878614106687466821197508945907623663349967350056812008871556730507932692163691854086197645151393434559136812082839219807318785276300207680/1746075159928631351640818459033829113480483105119701106822620607125030144188173620423923781960249689796545205476830969411766399971315569861931,572685239785953419044123748527078342371696743461254732689694305310230622579293314195338279241303866651921109457300471056385391132302798115458/2383800296988500148578892701780963443530496841271669917064758904342855674768576367439479325928742385801038225018062923462889481858598855451857,-99442191371718059852065523531340787248633632074501480324080380405235744080610688751839824314597209601156166187156794065196270302802942864199/462543171495842922783393243837480132768322417808154544426509076783156468663547683914637112711892385555461990619003487502382585352172982364794,-247756919513849610421790601585290076093456589890944993141512781681604461929643590109425318590241259064635648942575586002638323365833998199136/932670348801146850225579212099745523844065027921903291315063274012352363032508147880572627923957404345457070967871361186313421440816433309705,146969221993181309931594324129430569541764902185789405580536155899044953178048461044618695789758197929270404601510829805948115422863530546005/168455189232555735957337500171097835792603445039026822701675420125170866641678980741686761054305006677958991533921216217706265899303214497283,-103390157418516856176854493665712890479918587074071383512132794281618709437131452765020195698475685358678315734385857411965026893213196644796/119679162070159637746720361439954466484305952997789292139437957443200370679579540971167601435690580831573529871595202301628883785471123740463,-512607946663678124915811221160261470857277483407239845097876077969998619547207534961756209218966545570721414583816561417886968837840580116028/177845090054802530202150087768833499821837357894723238457777134181692941637191370186104402387919719301802094686517031887963719570533256643441,-53474609738329601201733879361469598504681613538824213009597994508033043928056523449034286592159698024372219734909690031729945061379772490127/71313559918409429196163403135230847027146540308496182553809610408156411662786109491180483087859550988687929569923754319566199326055219224052,-1174947136766186133045396061572634186198220179489289927246111705303920512333378524456733338633701611849795902708907835818278265714833524841563/1221255939053271040564457154556481465690148969880655031199052281233519431359314197112521080795428041303529495457041269243109636030979387426771,-21784842112944512751735141879239693725110619983939112054738452600636244569354166118254664233723864006033715552360383064342413791695527897719379/21713532147637888883586804866516540359762341866354971609771512146215406216196824007540334004455215801767217345418910850392952770631980386402248,-48385258723382975065870923123501898903280605642076939391588897502317453036902918326007695115454100204648445397284501292382488837027771627313/64470824877210326401733982649213175596623257503752122767514912100195142575160396063190888375473277331660430235365989229022430017956507717952,-432270111455351665315894510982298959079010331565598244625007169317438685977892805961063565157893111206311333067544834828144829431484171054191/575153921285481071113128495643802305703123477912755699761140599143469357365278628722577274428299520316929994509968067376599852164714200047008,-1068360716546528898344979982637052535180982520120520621902797278034598863100192263425500283489554189525401260107020872215510656430247129170151/1422873105228862882696076699534964727896699617177294166097717823476750314458009251624422485956790705217912146004378846608567090039318904111136,-16060420773620155844466200552855411710786460934779125861889683545017336980312445789675429312492913475035484015000574809064639865118079572450/31085948497627765872289497047693212699529975069500731888281946199660663123151897552815989845854545675216731739281664411610406022610533855097,-12382356974066922388461364755666720426976587357841707021900598763316981660793777138637261567538409538772654765622990081633684365843005229311/181056415074824404441394653833992062250689378491564857969600096164362969726563316084256353750184222113318138881486623814257838022710347704591,-408356378706965484983247140715208387602263313660603208022500056869417171043465157612367006283506137864940460833082210702595916255262331321272/1006104695938378938515812088485874391472950581503349574685412256124584802444420234471427263568224509116123955929729606047597353413832036052469,-415328321217032572456210657622068094391467154306242233381146249484635144572100125794845665928495303072232847645731693877376857685985292938552/1497530262777783450439711057552827849752140835487540927423885832417589250908639310043548471890805139383142051174551776482759463337347216511387,-413607435280392573097829379443042829414029757981982056733918640796480096422481892787229957876493539687149019521660733601534611820582729378424/145267817502722359353955643385120623610797420164309942980874251973036311755938079124927224875541302175712874210136839532738171401657443894653,-14783392089297085518947252236304785746525716536121493822401967800403837136694150333502516171413994056807383365231865534944489210680399644984/6143063012887462540109029187266480100454066108823945451503616098027731915299453420941846010977161638744142531619000922536134098212324016877,-26812120368524578389586619558340772760087066887210431274528806125878675533769709603381067514972074311107608782814977326305396316527634694888/13026625095157353083522903989556857953456521345144869833591625639862321582030488809263712711353407404721792509623289665388909588839635524081,46694145162821282421526080373377043931202326470210078803887587326951171728749604983445840488155683468994971918536658324932357409943754571377/107677779946911651654361087337171628419738537019945551899776556384583119287062142273083742266996611444908410976829853528749644553923217349788,-205127854941413671557374132779376912213395438748984055290390413726018587568638282845920127242087037830298667485443631324740356405215576923567/133757880797617182884669324579566101410565655641940070922903668881592410962514693357758858940213569551602170533890198711768303760437914001468,558515422552711090900371369317667025108507703173689209162215640063212118336231566283174353668343514291184213847305495981388542108494707271389/163370627212417109895955786787301094593459464011788315534098875671219702379314234289499506742212579766360155517145075399861195654360191263956,387109611428332411097910747412398535126612194402298468246783187581552493481010982272123572834759763128868218305101204965582137973907230424675/2105931696019239288467245872619302171207120788911018114613962380936863441629947155297619357182187635489941956229199163352455001625936091505448,7735564795849177516720600906278893076133380207723088830364636253842024183812128111326734096019599612158388942909673130721835804204017299434791/17287643471529324854103539137241580729314566983494027213900793036594203585727214243452721063186396435786233629007784587120082740207062685838712,1015350527978014779006169352828630429562110842546240100539415569916477046545766034932159119875672087611281359530250148494684779546065971610709/5016608023209251352767576163113731197918390056706869256617505288994384949484074595764806851123596789218924743091778877186139923235154922184532,62266949750854659270795853327532983318006013764122751462869920453740998221968178549385983741957512865199916278341229535491999702090864275295/598194054351453598178072608346961826635345475897792715450369645836419756270698008066113047995829032231124958839462691552083795323001984160109,366707085354358218058117860287737384049659280574243780697451256670707543394264058375340938560459850427342790700587793040742722709746749546435/4207011782569394983697381116009953796802372379874063668205399814655129835376501078205336927991712391759499757336879367484268466525603869154136,5576294911013284591241871813010934451948502754162385417867749393317288908730013688312573830273287284816351371829318581304940101685016260973/78554879382570087264692658694691917147353558161359160166653036024516147443776055998132663765653259919890950052491854290455855771029900563998,5149475233187686180333516293603272170812824269191702570769831534662738806332105065842551082327142695772423668915851214659178131414459186556760/9348713296354461599412318720457024271443026632784876943256257222497748671316325664539823995662087731377322013029235526061551811171340592791727,1975474875495869400752535722700232592218248443556411574887170978929422092434492597958723064011700057602508408768467340854169456503149614940466/4200930898225363278136820086959515276835435239604037775408851785721299849647691243947606512525160956355280416306537380728304377120768840577783,16166658680070442043919038959293762628123733995232812298123565314796946432900284636262501310865212738910368865390081165366119915411807926314/324322473441683433329871200992098710135049681578711301496508674931313973821350495058146599492449049849571239806604612787407131097023658961939,607701974418615895767780831990194342567005890267102504829994556308007746717401681718712781930088294036835282307753417033186098635286701113307/641399118700613490592029344034112982078819864261677577417826643291935390279820243947227458555386898481639419703826656587272905950343755142728,203121094171707128044173629061287790775102118127454684185363039337316004498729149495831766097657716426244384696242607778154442436198246851824/2200905699514422053600286121950427475099840294712810327307538531752541921686746392632255841271613973655696864621530494914628565589233410534399,1041959044735094381999105003618934118182403182030301128358783040048379347927977770253517259529808478783790464317429722875332947804252195823616/2560369233447101155368154020801288722162295536533060017363847604545187239658710136217313210167177535712283110684245084397645608389044804619887,49107866311068059331267188655440288223069624214998410347753636051009313489259777819697623711262595897625439461943382928550056036998611932397737/34323963285000261199912807852872397782094247789711208805110239194022341430669296818083355495823036419252260584908057919461001697132059160633932,7647313262487897818408760931478380881228824099634485693191024293888180692469671716696409746975937821129265629374731781087018265457781077216308/5539497429900134356353123331247111044212264192300686314333447188599212179800413418122742091196612879056400865940481732200442353767914047479273,7476890482904885893021515124383197736680285017968034055236774373276448598757870730693680210001842439647409545056666442489273936609913397276378/11648897637971333120394999322748925172053050472629520886574064094675866648018736841459427057299978391685850615192667920243948922519640479215819,5167955363431541199005114895969377259171327108543169839417905604489018813422601483017845185188088994618389937306981325413547851410639611122723/9306053141447709128406441208673078684170718906447149604780764277840993538052933700316048124884488825930881940504611564880966084417467137540752,2834824959031506057534007382092027166640356669800300080277610722498343733777828500870090266614647975262293821035290505493621434698475665122724/3283697829986830606657917194545009747742240536205845035825032930899728918950094966673934882568823190762646199742386711308602861578162743761001,12165746543191579502795551818455032238407849446411665392369708619030302738897299441388922883319687198075814136853972766743824539696642241347/14091531427351170296211075570278573673471553669413080419206291722220993071731642262485219315809699626041084804911948165143767100353159818311,3206483662106351738068913674240185179382320022305556497947659088931118523680597445497227561915459731651120931737028744548482018808728149324464/3061782873210481069485355259831867111628407057997697463802548223955401428512246338774214043121652718122799746738213960719311980101878193699519,26845747063530365648514544877450209957808101117314601410138163645505102086219561638210712126216729869545801149151956701692333912973713180468688/22436572740268448829781987934239023597022718406844941765493885591002022305269217193577301141700789128613067428816206246176042703976745080164103,6595536659538992377027311060344198944685396893117977648929871633684364299871904961862270328135064417310882319330509071215211353939082128591456/16938116538754861582398944827906266697154520306695373848094278785563941648874896089411477601275615729649582471293763134765456451427541417910107,641075830159086833298607080994801090071412748711593563692486468252167523587922385942210242692603508896445422849792544571003205016433962536512/6965344267989757738907506426238166702253707814335410446736814815278803384520425784180787112236458451935207328527247044706820860777137260572935,9735895166162142124725519038986666070704395502426918736122146266090561866254498717206422397071428509245749038490952017084558652043646159329/29259762283296555935301448947265618460654610449567508498560439521561543767854551572241991010232194640738424007005680617018091893777771427,16133136663643816190830008723497085118644493102778420568650113756544701392385095060301522267873567956540170418438524726268353892854048666416784/1473692105387686787763688306181107542255974505903819283294840468820178340154856994230699382546092121139998873257985786158676911942729635624683,486545219970286777499314287677277640153698461930317244511277551562521083683739793827560140901855076962970743902655032772662116555812913423932/4974719255883026409652319130931051065975618549272152322387837987684702345079220356160931908087487264909442843278045637381714180684035662673899,-381355665756654922368604552470933221608082285008178977818143173480527967380031052183784822510221690000221359193998348093120085550782550621995/119681510212785837435161016567117592433221687304211796511546475670315016286996591866028775432239227518876383156377784123757953879726993036346,97232261749847372183300572642898128763728825625064389425215697160153173907884808079266757760022314910450101551514066015074795178708799683001/935243776213981614327598494124390027603232950205987561726380101518270079908436758990129329976042632241881540590629022244789441990900889301092,-139134488421814668794306782595205832016775723078353965935292407440857499303621256856830456719672903290426834487914549975049884225214227248973/35016232727035973017115833296205877849327778602341811890204520287232967513149299004983706532632026599981745100203830916625124013987677713617,-32703134214931709059733223445167179269417472661820883860316635292098056010780408077364222158290153529179272449173147055101341220333199766504/10766352093662994256606102023119751782841403439238435990001847399521933186490956289538199282027985314427270701745898682258963079859731530747,-139340423041082556675641474466308161096384976954607477995555707447281466675869221867883826095336436873112855724640391143053630116926761029567/34835422375626375735460979304713384048349400138371552872246504905817670501621039504582999997032484456887352699497963420266595549156016720844,-19572082844432183626040363882385076730547079018146583174551536469023815261717550909360290187086396611937220825792764057281741885551316435148/1381281548120009011881834904191544341074089383646732518375256476518321543050949572343914425387125591572751728068822870971740020827528117817813,114696639531485940574830396607784226182590352399162934160934687238139674089117951791530634445345176040487269459592873714444180548108150520608/124307117593721228143403054055052462271476108971490791409103712840875113476008705440322767306825424686894312317541652984146754637577511217837,-103046125052541342835366792076878423111747328683706670201134474841022084155091077446434747699371533215742217427747433148366425913780251058751/89724816837852143344965599709305341143236398396547051468591742814895352758875299682705364644345105906466431683556105518792153542423339024160,-90259914854343332893329500508040199579841194551827706556048055783786131086603634955747016674186690359223957399605897403616844732970201997483/59868081928506330136485185517482648261957937566843069644396284183232943019187388445207778409732433322045901764063001931072212726701411165266,1671805071208358999374532863949190182428618514181535935986280375997749389948928372706583794397532104577248063128878037815354755448221368640/1792654421487481394492542932157435165417038093967906079084932335716593465700117449238723005828337456185343142274070010602129698637139668517,-644621211829035886121825800505057014787092630825185401798699711895293300846460616392402329086083170071662059862857726496112311571908809546/107385734505900799320977695446609958610730962268668412626360978786809876747173227855500393365126993178441557493870657013484370593844821207,-4008747504808401918500560642038863089445861080468605837524704060234764928322856669985271226566531045504738276635526543121542119321069421728/393268394315082987868080129905284432268322914298083777520406067622648086375103215463071367586378064288035722478195671052994214750773262265,-49084606425283772515053524907489935081824573620494049841569185094890636843393187527527287954814456552424396074383324761313717401951180197409/1926111611090413448486241237031467741078871357063406083253504295100455890098141756365474749393689986856076705314515116444776683150995994128,-196318253548625920634780016429188597254409505104690497301981057032813086201887473487513138820429734497746328235357099727376913340645388046183/12177360307983335926703107282181825552583494266834016306903963127822276748999336066407368457621150217179414746626551733126292451021559862132,-25579692244933095604028422995241379406551687653428149515970138575390899300358988038652297882601988264152990861605993983891635666069153126893/787255048966315939240084144157936049673768409134565878090804414564282419863614549450921709588568092403624413583941185745298318653375844286,-15366483456826954896103541627069224868896337593736181527377485117128701958090757872710382983749355000675340335317525931493765703109270421903/4983874681577806803069445670446972907294712346994730040082064692288142295649625645987512264988148893896273843914553016683460235485207222426,-72640308201859644329846363899220367308138646972158017761471228654943953106299311702970939726127806465830063169237488391889068589638086213472/36956840907039791366587908274465057300881815479252083826129472906660514212842214008495363533489496097954551782154114075828724859119901623779,-65540048539958290475744195221488020107988932685888596504986086587559522542740709051260178900421657753681042673505894552568996133780809803264/32730881638743912135182113686914392195334447684933487056968649984297157814157533437822969631453159141752683687065909611037614575166808218309,-4920885468474456927475351869994563282203846957818678394765479414950514217821598927698565290073330575279924768765645435893631505182360701324922/7367329828243302568655483477622484190504375340585665143713354290016714305566149429019652092171338949281606236141695211825240876538793039398027,-905200569346915589369107424370022158698698668883854882655812308479335891832149481456127513694784543157786970293876087312338662866974458797137975/1307242702325361550210537827277096607806666733648014365703369786670604051059307619934380654353976210419372717402125866683273492437948522212976992,-6805274389326036801714795892156008932883959030387168189492555980138147505529539755516838116030013329431222985180624506052457970732768819027929/9493429834290330194899140516954743428034883116799836507026478234163173057211896544366848692099549895433304318884581400049290399436418566329168,-81634478076750014128247649699940160303971292244888230251404984774196946336198083393796946680704977771375799276604585495293047276828014104495936/169940321842266570859990221953265694860042317322607767320355545656510117643941573771748412169599701011424159090065799159857074349122874264087653,-38744450339501873461615172727770390961286945053120459569252607846534014379903895651458514751690630815759551004289009883390739372463509292715632/76169679282906613939327733360910326611768735238214024496018504676976914384783075059002427734184077724735442095617118681907613239007192354451049,-115271410668369595803571150807631529316539266575643521785640788485260331688089589413441774933276198006356724678871699997070804233018176539373696/235909206088905284652279165343159369079234150222284563298282992772508475541797012845614896876075333244849084379418423375604081261322765711105909,-601878810630502313530280837297349263606764677596604557114536161486532714169762944460579421425136821985950868354389526819070199730593357296000/2870569644632863123896468329050121589688586622184058430091682691546481738779199987119459101937283562063146787925160404424538650924078817841559,-244688892766444371649938575887327612338709960701126491409974981633821649076850341503812161039561410196467888959832264811819118352413952449645/404802695377259696489739348115798205522785541722565512539098473364153778755308257137274498219146383473374791314538192451364875689934837446444,-466654715946190236105574007178827850177266410854667096089263062092563408504915205953071295055417843892282579352615713165356766810653445573417/720040491378189768514808704986113368104115712226493506833268664687225420549477497273896515667310370320245983833443212520663585421885666069916,-1205920384874470991254987798803789521870690254986516418581275146159886783217399743721695823676124834993713560523451397736181249062847389956451/1842080349627368009567259987674209624526440582457573876569522382567728687089876751571380954209259159599560467211197180418416070435230887875174,-92903162086735481727837152257260198721235617317746550427096827145437828537247325330564159951847102840668402637128512691866889719864565912273/147875347035696942136502256149883498346326869365354488060999106440037683570656371516933669170313980946111588666420765991773272390431583647987,-24029275411406302599206494528095195839389625987163590423893387937065178898079823572875889510168327544850118621792383892716560722860723343539/43151894777281704239563133501702761806662641680029339371826098272358145878527534175764429363513801205546609365984443507735282669935975034839,-60412147933540052804225798671028266511756734484978245589025392993776000915415019370364699114757331397772662153244454852504225508436265757957675/90166844329207718099399680415040987088035721643416103412842226389400969492810246645476034599588848948432711889981663660781476304375832706542688,-742138742338980087351986484598933626869313803550821673151170541153138198414659230850928682230657354179718598794436253462780056935328211305473/1154677494238050597385478601588190319217956513301028104494553795070742540380707468026203206759283832479799740503044603155916984871382667329744,-62164963816112171907478191731362499280246857835282286650551589965573590064184282490305268883377521426678829067493422937883833017371117494592/560656828806118911449780238544305145134621169255766175353554807619647744633070819925243741428362973833844507475866534498838272621516309766441,-1248647564831701941088761955329201283001712328700696403305633813915178269096632623666961243363669872015642549907376794581340910599716687672320/7915769771917219752941471062128716543437528847858597010090180482905017833203004612964012155643527207991363944598276591743535210663347558392873,90609647205688694723345761585722638407389930479930101032191505239478591562203228581545889438595400876742131179004866416101611628180651826240/241511239099209785601075636328456075887586509874489931193350368137692696574321640851805179077371976036115200362282234532863842097528061439581,103647251775602751526448044833683754948648706744317804698510980149976776314123589413140246351429848802664368467243484219800481456293211339328/409075726972193773781960417516263495618273433801784899094785660123013577833745794276511751851090488076903313257160982234247538993296970094029,1183404931184954810957623897064791056660986105536507904252377420574040537373774187935037862816689572629324437418340830673808543090324911026269/840331448514714995380310940341019442413175128694893534197248076739190921344016602168310773220354988704508943788305153030696781937805176258142,263335887497385433451742903484996195930304676659010992299766124374923507103327905525492051411458533891220445218701879110286143621547145057833/283746172409472259789690686912928932599117334747496472098074500689196928147647640421207438554206007799412727508239284834470992023880388725026,-191869064616113280358878895600626590660695883267083513710929400348169335764821669326873253897147966217902742602350809269286394279814707829337/345550427651711343810288410244057750545392343954692888205866083996887625175340040750170531591933061629610344153397289133835497400403870946067,-251696931947989349673187650031884504176107586666135630955151091190125518972861513489845381146419372544416727305449780659380065652025701040911/620074505263988011820003351609183060890898519920120687307134274792767796543699026458401925933561778625281770602793262190109742930832178078656,-90113353657921356632779619840040210556591502261595816309044668062313080718007814939269286484358000257746530364831006887071308627467933783449/196269667191075220997979488282468702663261306854223392067940735169881285589713669041190613744504156927919953907592554982579239413117145754638,-8037195371977430172285128318019212712988438450812411194284235683850800372619897846971189130659653306411162855131438978865296073323475987223520/17617203139278102987296383205843167470722044071485503618693934529793401868497064638611986833144186369886477781967922770745162461657759573986463,-10469553869832835700153606300099646668968270975814654514548808267933189167294128872164118910963593408208862882572887301337758689045653469127744/25314831000874155100647585480481613434273156717220329021387367772209672339002069427250362440804164860009325086962084991918156619877892028316105,-856798831403444795839847257812376736111921370226292948553318699716900857255134481949476421583649476701989483094433415201753473095173672344448/2702239977019587622414371610736575863435358317301525101746444411812531390340477025024300331688681292515546159748210275598634325262599615691929,-826497749420458720350882232765095492182113883799429702598781548790330191693599793899511449890864164665311649397009966221238105172286050527271/2224185135926786937024295066080197752964698329087771873837999360415374673552010374903307766841254398203145986378442145755561129197164874056807,-10215305926620905637160282148763197538596553994090441868366140809644038497459414094606100364231717632563330933914683583077894556123355156711552/18823410073191893541431942265178609016828817215048324622129660050439882766940083850178048401014139639722439011183514724721651128024244617908263,546116879591389718385909464929225528318359368928628741463697185580069644724278924567456426350378435261857342540051270095462080775106250092341/1106548572059931970866252737107984501821024353560745519652165880544237762097685045996087791653302440268301974336412109888292796295033220701338,-107597926583675792227011447607113427730939909169134557141060006602390719942131418793475629258027496519630673230603115314333172209019642959506624/115031346536282580594932693242084392966591007128192831492839814411294549486346643616737664838621311933651602955980081730749990782521302043852467,-177713648114289022853517674692994684783461662453178205343974642955798078648682685834466602353834871099403693152300101473723025334146709273061/173121755083550529704973354225217203656591489992585642505981919890893882554195846964415176879786410571069177003618542161561514748118853232352,-2497698036357069078407991024466535091194816063611703167983290199996500564637756050151372589128492611922688629722017513010371063775910370007639/3977902495297626427046078909516663649868292812022214345763668612501475441428453130977793639760103346157021845608375349710562713079316143166368,1055372098487854290062639207284407852400242525472996485851929767804388274769644926339995894971817281716704164268684257906245514612033970112537/437900650596312393352623424373169303710198307432684637255863741060951892841503272583111375152926288006731383977827263405851686490486589475826,-1361026421014291389358231890959095720736449283546886488989131915475500899785252476331213585737678337720052571934492745512801545687425840642871/3070345802045836267653451797078836338822217837175678913133516879738968075292076538616635376215082628173170835723936571011513317706472299769007,2688694754940141318639666606978874162831061213663118072585420199456819046487623412291722826741238215511476440172406097321908779386164455357923/337992041496074614753354426556573866276412453714492224977072845734121888391510439554429453290378618442815762994155451010224649347988898752962,-7096916965979144228042017158416619526179185127576719731287551192353713079978032777703489324172874551118067563613912653662307147122304893491/33714008073284202330913190238406378738455008899971275640497579072520595756302114892881154544872012811991735097110069175958792412679131254528,8173255333078729203307051597107554077303040031845828080004261238117645704435688365945151847407695792131161466028187101556125760311932021656851/1083545329086175851933744849355659015376189495407477670631586127068203278045178257910044996701170249165439315181486362379766987888333998890272,-24662504094800864643723972041493626077953877654723020669727001073731796535304595049057305928857717402339004113968717730632787052105982584679424/10444533386301524973448658458644901267945188187261176204883738148813873216434285108305349541419308527006449726311128229072035763699024750370289,-2159717387437105589439415171002597468916608225324064946012778381234296332335011701966013553866930055693439784157510559178721253954412262349248/150738539083035908321597544631568035964635333043019705968302894577806792915386600426873470325727348347515957713770108556812650881117103660011,-23623060071053341712896214116328000662106901610874656259011251938940117826710976396268866501213759418863451847502489256635512933031131889488768/9451796955374159617993412218714379226724022366845006154057517340280201569635387858395718867247520308249183873645970570673035280099302584869667,198925697896591281606769802030891987619239564097992486107274227040001054587635640046017690693715432860104916990652601887307948130825581436308216/143437042053752484743034436223183212405077601591995579521020514038808701823632400621912089537213505125364048830194638974186390293679217707509285,23221883782118460042597320214903801143872927799068107462329654287143761470780246000326644364111634271396537126473649858076301126930862386752048/18458818944422271388178236496116032137203800411379639990337487814279498988948944919770673899192755002262354968993506187008328002243680422203423,1252364980428917745378750110822155744353612987129026121623750166069655873970367090783725495635010199770890908675866959402339704103358115615682/1212214458889200141148940194221096813464731547349821804947744232044123329341668112391962065058137874622382581150316084295946891134704488342457,389262395701537175146933257232140309288188965254759089078523660596997513737002926431787203738854118806871050621740877956050782236551105390762/371408849756776090547027295263530105087452408845216922711534665241532312421172176352644576485457000169681889374738888151230572041759026964785,506249629391342569272725164079538405816471586673006552643060481377856991279976084800185652828720280029069453433897664498197401477082055772705/217299687023391630559895561369344612128114662824133128619516312054408369670592659396972564777301014458097340429586109513575146614549257517632,876647669718492952227012931454138277820231043704099892233211715654662933225705186812429530158557197231102976808138851426015014271690516608360/343767326034206620821302376196468533876140517557107668343226072413642231398084859394672851680591916102711075707705898249304796385113318350809,19033673282874262637185630624981167890653519847237597835148870796136661080403097618225076242680016636141726763636868565722882460866528990731811/9924287478716637380735895006222186652712060122057353309824974006935525471715126447033245851279322384865882913025954862894694188989141226394370,34033198208136096471207568041441359280129459192447758291183285515158687337180723969695626352351789302575823118210010750436808016645348485166017/9159162177332456096295186663734625012717015109746019733333008154484984341546818252759554170956049722052239708545626400094170778076418633630694,5930909216180879771713970433261818409017450099168821387849224611943679152696221994378916492594477455022983244858129778125063743825035127873588160/2258900555565966209472598954019238989157942390788170189943054163037626336409716654363047460791237611673919052652081225947811633149355432851274917,210759669419341896916346825543075365667303409090595818603449509306713397157184958378769915810035190957048818676864897268967014994193431810365904/105158608511097251250683906714032777466215204288642788817270634051246169018001899530314545961178425686006237868287737363007007906521365781719939,33047521806083596568513749988322070590568737714185192242511401327453488827882579748317617141560158579616924010215544560552903468388961613053968/19441132694539299172387649585129370937215180462407585948901217097539974129371054439164285771652514007610856828252454065560184435441725256557143,1274624405707854308297912414979371998352579084085718887677894137456057896296943601940309156980244345738237905757756056076083514694842927609984/713090499953476046738667194056915458364826029928043890070856674366026298504953735839275963928288517159438436553951754140131173190956435967039,29203342469888574843743121218635188222589498715830243078839135355636910626024700942392885792117503552509488407868317368390945321970213869282632/13038267379008120789279381986321541907277488730315145852466817025367879143436711167502745731248725771305642412165607881779599473309202251182177,870186933585374628816868729710954560903168989994876106607239059126842264690503844645565610397346620440141923530131902099870288535775140846321/448371574876504711029884522396064033086908431649574043438753685907824026322903563686071445654177245587725709929260967427443533233331938237158,62211538691108420430164695164317175869819274756370361530392465428570482286278405486276195205412209463385182357056804260208251520216831649342/58744305942449364370414735790339927058802829643267678292537135125474576217150780516207045741261122456088700892238998947260130866113335751721,1865943662039933221178036672778405200319654833393438246123565132539534248447926533112430310743969686275580437326147318254189815688331134643535/1219737699653408590947314396873125282303246956201796551153642417903425522889166165611559715759176058961542261706677514460986305347924751349454,198664017462250905900516510097868939879290315006302352099992699843990730554772302149139615342940068739726946123361894790555507696129098335337/65305585606486873514045753679002299862092141797624239668088233018750928834342895737575320847702433469461922652473770929359891147853648399066,3735116913385619884163274433685822160054141808953559261982070475860272811053507399805699279942384780249462395769020569649292888873380406414153/3504145091536768481943930948007162624987329495452377208688171499613341872121276191677338876805658871220857269881010754802633104441912198301092,1561875356999692376230061384498586303390984487889954579616085742539343090182139061757996356482823437365685822653527479898055126432752810612653/229925309540094062213175728426314848427736776655964116121818585637816313443802614964428110403681122923474841846818213314637118868851085107634,88459118131565987452466590770868469098411837341016361257849963734867702241004657840202919259992136463001686408609553417858433891246280019553/23808460008482189976738124505747662205892524417427368310226379656162829964821930392436471772955946579923812102811400511554756523322135603574,4086484833526775817214675714434990757942113385293146604617131304859427994827445691324972285799689853017962248111992469490345025882477064905047584/273575186010043871354293206579119589346516069336118768617158409385370073981276303684264932432258457896883446548486751700900347873969879460992329,14896262634701960780957344272444127907274027957072388077999761380342110120286498669704487184077366159164170523122210371617879834001201454086/12407207443496124123455208124519670695339473056090002122880462983361720369742372523241320255282105202028340600383073429329988970763674150181,329676887709602201874283411583791952281789515212379814348105634563083462965937039819853304369292007505370013972430981008357584174259288075702/160789449672181475892479548162844643511861609671499785261688128724074608761526126809979611202318069062603083357576052826545911476897283142643,335335090500642582945532499248325503851047972180915371037387073981155158881949734268298337896984636188213180701595579260684225590596630039241/75608163651903756026829469451533143985674321324812139149255003194500340142337141266215210026009923243453698511037947464604446568128015837936,23283971407451434325780581847700423804150047144080106892977084185262270081800209597777421116511402014020115990915268745171107812228762610891456/2611640079074353375584348302395053539203475098843072739524111382685959744504069977754659644452556026447865287000271122664428237546996880662067,675511454494377885946454098273980448385738293875562027358867025976917015097009400538946053002801659382187965229828596961892173842301322829952/108125221956450017532673989407552802469503555906731306759216084677956950668079713406736629975741609279333844863101180724893684281708401927549,557318707358026018124361483881813391892992060073819442689000988261181007577822432001408178245425194288831276670762269798021835618093771719867/31478368094454466440261873448374183683058105645248877708756055936361421308835732734857595252475766939640827237590576892451776272769977524514,595579631772880153152459775309319609182430427687571714357688649417770871684335129744047789451194619475943235373254257347740738491812227609/687408683887874259789088096796498374630969207283719837290112156880618010200544887381929246949079231710483975955661821404106611219909891951,437837692738358088842784960327975585004842109305676736353684357716668192726260917339576392732192553636646588820530409075808628453258302926805/399967247613949091675170469193172054912257934377968600357271890836879167192669713572041632130446409918920466846757835324855869819596342613469,369081385894014697486140755260162567604769203097516084593037117446099969864007132383822262133219510438920437998827721571982251194621222579520/168653295086819606487527718714329559767551294990482270476195847440597494259528767798868373159170142017461512898619623143843853814618205495411,1169106892275167040078704776860331340968391840420041874482613089997273852987650020272617775373617932872590287944297247795947196584638839525443/452373674939643378820798946846784866894155678368084789443473658686886378345924643879617841927886156655309662940852601293275710947098532349772,3227974138662478950816310865768586812369291364428470660417529850805541842803840824458912526959267611501142837972686351169252818029455652954061/1593669185242576738898469434570935881002449776087372676524572948118165516808257853500179983440596109675111548352897255226724917672008391861420,875495632795850291285008177530117910857002865089798911717982777079442148393792269255104668765453153753365414125067732823916795256720778262051/338462632509667083685503438362150562284408995637624439706630064634109238402024149613777436087702564560919903078062414210129051388987828205124,99958074672055423350892971611362327949525594313197357403971666367399768626293642604339621278958107545031768117994212648484860075690140772813/38398256353230265358982891545439613788198403336233170299284833085640894982465083002791677211799473330085795277917013206197889711388669337988,537945238722248837533916482648767093701931470326453396354874368986387232108352460019498766255366817043004342992906896150195155936173381790115/205736812033533365143381189529817311224905467197188949384031072044791597651269963428280721092234482046638073751091632300827085957611785177228,282274571499188688179129934247200025152487016578428536592929224838612738356962558243042965711277545168207313899562552136360271169552894680363/73921531645342034144047173944590996628648211604566713133914668483037678645759085651524730338977732190495043369932400003598429696836132075210,2603709935402237386205770959458511813520623997749593601764562614695782809608506615334848742603619335613536061933791824580988737914903393005191/1174201688077732018819749936707779288143639101690023513689260635330820547724428292749917361565314678985164433386477985504282672491567724147544,8342970083210771792994181493803753293213864416464254818241564012363436794361739115003093169842756933014058396493730888922205017175896858254279/4314430680702654907579306757243376989957885164716277792189326435710695277821158799762020747342897227765854184721305651628889997578472439085198,382363089888390167298053873827315534050570832085720282121452253333065218810751505577501283353532175883922143689132190511355812530922074317153/182984478366698610631937919742248263856757020645662588637020439975687154550475697792028132017974074600608696724775697456283606944171423746406,11256354329846719993855166448968062508919246065901445163006579303463019998586758170157616690795019174918301125999973197832273892843144229795344/2804173641570054529654056659398126022511203262674204740499618460979598027263234082416471806681024960178158901241697645516761876147230275614473,357293012579616325478400434096152438845752205639381982765099306519313397414826006546588084703433382578424299652391797517622627244153879172393/72784004471047905605422998144604650446279130884392618556647886458684721784217746043132456907585736762259297568819632074673509836934701954378,1132751542175764798092490845265043029709247140538382160395825682936177879460129226787475756853347013735772791654268588849723489860517747646/1246028682336154501632344980822928405676168357245484532576367678823457554179441584809478141026275120386367629286472850360746628368298374931,1935187889320745401708657361539859537512611774667435762377796069350410260849111930265549443976328980277156814773209861540371267790001981807548/194836758742485055296825213331061096889682348047705552391826880303132717591209100695335916520845598090239599734727743735242783340244053242859,30582305671921714923056445526038145988740221048798659680396750002557336177612150275428216029566635480036513667831471270266770718513118218161/11076950244562462103927294453170792903461328246043281201272589199056211259107114245458601556624592026681949814719786987900808104397241546368,852480305353975897302355724220976240073758500098806089692899983595059373698579576573276916691299367571855595723598493583906126483741061824140/6182641768225426404028490099420716339043450111027813302803547903771577219166824661998097702602052318411075052799939466873059448705966717899,241546453860820474686180038398361642478314560785682226342622326715074665033176972089272010402946034593104474761656614684113577969217714572640/540592068019553457256835515196716819939893110031190494038470489666715384459279017148112419564610617589005969713635277847248787149473026608187,110809920738260745137347734476713462449086798707813498029476760320894708247180985082540134704267678541923121986539113198599746463811702300696/36299904212168498871488845930102451063381732747860016711689501664434941416463418991196868320488046679865838026571302675396643357219723496817,74840149660644519190604281411693594697765504956259149410478461981576109360850512111014376275874219988414201578253145712331962166198832498651/12428900593819030376835531887873495147173784022912149837679723409134314534121569847244323996767209581502625060949229963304913904680558978472,52538078013178629712611781331211986057570349256475350347901714631228515325604461303906470873738716107988031146637145891072014228588473918588681/8299529508207224183626006079754863453576837448582134981441507761335544008090342329436960035453725176086459731783419658919143691749742378506306,6104604899802647525089392330034256518802792213391807730034145578849569685562950071150116228828814138751700100951104205488713184396963682117437/1041518584751190308174397586923838995605328856874731293480737150114655044008550092777833752321961209159273125072942824852645618240633318501530,6311075799793514530903937328392409613617500693845668063463837326665066830654016862236884158093844881450682827935674377577981808510619257861205/961273160850992657843008917664831592203862342244057642951373896516709653294424966102463015950313218989465750425253530388730969207563074979706,1391699276781632309769522909321110858987659658381019914446729769900141747950088729348714251728135373867648296200716477545960548309515210637265/154167266576170173150878323867760550771989024761313566885224203028576184985889336825563330978588505633203590276612081810822240927928615186141,1538680102236590455480952190728605089865203138233014417015368167760673223594245896010591782555523328097717275706269111041524149525990635959798/47199557807763109370468640735914560125799452120243733166330727847748461330820260972939039951106613886649395258988936550872265706356920387863,-444957967085474743601618784603878186187845702510335206224096176330095400232299517327840142937780838374163646058026210117466956794090582976289/1441780579305747603722107887367395579533418031862525549006787430414530170760921497176524940641162238575001064890792387380906472968408046181934,1005588550691456554864582337663526866864325547433470800509467964337032119909732789151371766828043964209448937408759784058649011019425340587157/1251673888084623767319986764202202236403652242360127079483094673589928503003870356978222205563355589094782912601973840930647527579607700822634,1784196879756713469011870750668493349944945854518801483938677903135345621776770358855526724445276744477196794612712326086820190451455125564391/3189081692480321021560861474997932594477462924144681257320435878687547109770859969714329069538389082128983858305489566657352224192759350633941,1142297129514104989918429377410394949583104504400014733914016409748943300255716661811852398771039211453677421684465813193402039596080706048694/369182251943054205351623636397035513999906327542074484221720621273950036144195584928823835149205962896785666252669699682311877653358035470287,1802536349695873121710784553629719801951155427965378895380457099911216193080520196513933442692505653248782660753566018400427229761783732471086/381433304092697093855639106977563859399769471387621435757641113585496796455514098824947208039458553391050142512791184556712437458519840231303,4158575286960787223389140568934759192719783169190067730148528756161703008671439700859820916366964660683918884923593978201912919562886102056833/738042703365062703311530218471446642793234206174877490312824000174877632123581699347158359967885639434905888450558051998878338437812737240244,28612930073970412477171340138903785542886342518897502425464489735985185399606422909617499654266535533106222006953906423107433495546001116369677/4982396203059648267278152824341239671392107738404257689839077245440627585783105814972322103129899689460963855842727375431104886853275566960234,2406145412178994237796997729263071950775218188394749061402488615153002776473389336782688095637729604649600896532184924593557399067112229428429/56000858073052041017392173841399769925680985092032201741855937434464375855216694423758082029125541218215532656716846631139320010864980208378,356679176842261629495346683411751017165878740918603244213192894490159220176899411038648461421523296509331485231850547613964068908979107318942/102897304055588059081667516145967394449710772929127604043338469311226041658978172338501621429305673914729721789103110974301421719418610476591,4027198452225020169055913945828407538951761947940560450182180384988801347611583585173961968497322456395999876163288716870812837663624423693174/1236839964828327537565976544735459066404797985223581548236705304621841996381295909076846994017367135705342724801983486377287335943852741874927,878581442708003465372375449890837851052651543703024102053014978101505271706801622044366543418491685773277612382338052861744718812729039469294/201707389911338635108297786325387520995558961798217691931232014529706436958290668484076905273764433019515110783225668289184842099842562961357,14854086183415247911357117150035588235731606943248407720892475140772780271298592259013304327506914264254693072431036369066115610582672789179616/4442366732708514754480185924174765736457070508400416530458702541711513108501252774703955867617969599955301985487184341734215697778485654577149,412992276234571098237901695117656502605222188079486117256107737986784417451634078170778531950940268216467506299231277755954781628095165064/59451731894317882030527761669435970210986695692490528420907729543332082342417194277069025883543518170510678255658508496953094314670328817,11628148358074677457290622280022974085506842434430180768901106564763413883843489371128285190703875009795209108419062560669807623025571875711160/3038585659674855108277332170988503281968030031633715441930526040616075142092862678464912140650334314877004160248791800691398323573641645006853,43545270020298894886055419873345714219188336937514860360920233186575001460428145460070111136099379554065009699550609315007287197499644441100287/1580792854415054612852117498372630196603826239887980889837256563938584783842650073861051594584462117970437230324120658335241679455227550371750,108774470927583077902047905667233642711818287567379786663302418986268214570330090818146786833286823579433176474359474076089070615583767615711292/13445464187436786247281170582812123656984188133835251910575251572390066758152862682412798147233378209165336369691382430377842728271456199112789,230353745791927762068920728721769578069685706896363604873570138405496084453240155786551305824136440267375436625010073626047624930362082660211997/17421244638054118246139687400105786331626636094037964084893667158501713170408430018335247994611852255757739954160239695024430772917088349890254,28568837954852410886464327388584461656486478500041253699126853923469975427962105810799920794116066975633934434114355256539407872758439906424769/4222452492494781668518747450352843229122466737816632173307903230326532125655735560270668078679143628494334080886385190448492800918341607628468,23940254563645916586486483057832572493007320453112368167880001021095035404978733184500234284015631949802836226322200033627067910766972657533948/6505978976504464847252102627035368233635025955718464252732454472200758060292129992540032815755769370838542276430608497170035540080083950052087,9856681405356571951356677425792357666103692451192840383106185845230932784691037757221688709397287324813155443908636404482904644775213428791980/50033647261599369540111167072303959027175456358803941650134789501632153066009786698538420446367473208309802283167232167271744347401139691211,220227035645891616457154880325219487626345179916397835145009927480852449277667825836769749950610498659026678277531738139778531928704956765566/60437818227364298043253124448146502014148897038885985326924692308768491600066573783305436870995385869222550628057015060283771546516364596817,4780825656669316719142773458807593475613872617992595487996712675526721103344365229217673992093107628961159300455104190598396453814729267834250/203998779623475050959282548553773848653088405134307531929283489324385460806511860127935529707028290256404018596996561200700436842096011710613,-779892292107975239176103638348263472751578430869635190459215046263488084282110329550098174539636783150344935941876921730490621313216552918126/1058446603018604166986965463659323698452993060774531873748896137966445382324883565837348901582367866513491477655886701817173730824152918343061,3764518873387766670576312260325354453580616823791661549503529300623976949196348536241292813685364761305339520748026080197412483248538131654912/12903457983763591598767116261389460488957818105134759943621728158233926895171226095243164253217848482579334945195162070690047335908621092771,1722570079632266963646818407442685346066409425042669640246607741657160181561598655984402817390356419829350124671124245341919906975267420585728/16967071466009440045135412373826998835326950435940790667266257458610126298636179402317356300948382218568598771365359406173658300858274800099,9511437168535819001441109795589690224116962735582658761031137000798667204076865211500192978159124820362782118845402571516752195508685210535744/33789115090623646241884407936239655874783315884202404015818161042553697825221460901392584724606464117033933530533950839542104333484379622077,10608083249912180411932404940342814880870552142570347362275585788457500143274456127191590831925007227711906549461933052820730259747823034390665/188734961311117145975195514578106597754985809567690758150974339422085129311793186098938588287935641882562817770067785594060764250403579444836,23048280926734954632144718765333429935731256349158115648931607312776497311149462878635270068887577116283885368453633439016079332714661218678436/4062476417924259097384453011439777493963583395875202249896234908207088956274234944641741120835355936441314967161785109844473303310247915192953,7883864529031235149242700569707228782188549519045215564906971375552994731499730082108530300702579934589249253798540087811178670909075424354226/910884240602045834361810026499877059641327795618388458655577542242272754732645234296957627631979204076528638071707002700968610029435955773683,574303564850474664877326365544161708862315886463112126164851300478090766000726488309320150635016470239617517911038453211709182388543249878681/66375787004118835670131327373980000074392717643242390839888089535089519923399266070450834935309091256189479230671679884574489190431741856015,3970761613556634683887503407639669995710562079928920881907488840154504872557210333025505721766338317266218916211410780813534093940239407875377/119920321663015165959951468977465059819982305690704368316215886996717969954302475453683872528289499934394350950445942722111658338174066968302,4978054309110020823538430491847589243909950534397361735940609768461996686668045294022364715338525899974041128765284843833413982697782389119692/226518470263894129062443851711619408344936751853561453112855416925361266387388140612588686665900360516793587462725969610327905938018137746985,2611645603209111878180201945628796261033657159657669856493483773007467646728803838669229878611550582140094263948107647861310773578062344836736/247204195836556354237660374891735836205821843605495681479745065291249507895800392023095944417696962845384723353911573670884724220715784449679,2955452879030162039867961515091341840278894033133970095785535678827885251637824821033750727231700675546113548951979857843684385588683359714688/117795310048735816109121286046832958208935306222285615174167282199740065156292577916892390147843183280354885460196339739079663148659732775695,5342842403360193923035920785893080732024811789029596188150215084655614902038877716307979218674539264688201098188984649589538138466385872559693/79784504108137121709230653959098577047055288961338199431183486670975775463289690416062234444753012782275572646762227639323342684242640192510,790381450361096020262302551250462688471210344061805416640971963884687531843969520982721219150864739373130755510765879231025001538215037696192/830418115928182567108181958721198210162344792228823921294411734754410101784488461619626709921438152802456939973062664785225012143934331889799,4842930041539855168687038988064672735299822426110477068456048664905860352357714516947904490608028837909248553441379667434556094182419426407119/265893343472451258324636077669494024928426108010678372017778107080967897437322685458958197998756063193943398691196213942301025776047715843431,72542185415248625496426397841475880749262878597593418266923264362752364758624696443102923218482052621946801956929875779085516725420179711616/315659051864642761306983115132316095632110779869130961375555866251241442095467394347974688218612544312496392858420449028729998728890282243,313099245326485134784924369665142221854576218523147468608508080045845131431577160730187440542058160329841807834336760067455961875226664117152/58480375858089060273353513187057644540566102636958713419347013485151318351731879212050642419339726397966730595629810251668791791230495939665,-29655049031565870152249693139778156037578856438607084457586614428447851286447158395551594007819098806724663607407406004386478024039652510752/390205553484677759274938186880285588316896536951099490126159693420627123059160584403364645003664020856057849032665565138389709610641586295805,110689989709252389988104205141648310589107008659712215371986863678670526797673704409654360975567977562091015358051347180854421833996518271232/75386640353766517128588966486686450456915640311343804017587807314067380558198742456476114196854674924948350911532702667644091808887750437331,739321559754069707609455174076322916075866959871435448089822261411514677797057235425578822596195485059749976792656426877240176081854209502848/153872514897805482420971391899161924091772006031127107781631703356510218035700568333099310276055429480690103148518750589430337003387877337907,26226295959086160689653498713386558709099662210793773979829067288603315501186089540632457357217595504255491054708663446459749505990411368523904/6364639163199692710981713186972077585660109492726665622737192802121779089804549155613206736738180083116025540149455411047118669956979533513407,18564104559440061136487498296292663569172187071496769970170073197230510385883090550045751205051466121392989366038833466754609567710526187460480/2011355276106377564611395365461707168814928884020375241274659261578875414427957772809375443718214113317305093145027748712972277497871436138943,1597807488369672025900121559648936220138941905812279739500219749930240893768867344784535270575874752832464208444903858879837003486311141449184/129112691897903040468734523478467958705384579619483674911331451040642979654042161225970030154621426838126949417797422866299247097598219968709,18071075502556212277725793904951139084942109710106468200545370216189313466292549139746340398802530138479948069686870290936259223504389365896557/2293734411275141305338095916009997772991756907947930173916005286813848335597666177860258639046687336199189732170251605435449853080399440404094,1325695943444129981581776492974357739230799148264606891910049633762937295597943096199181459916979607917370793706254597097440840732149370233383/219294559611528207647685937593130115300456289141863320080330737712041709981490733772286061353967986069673799126239527996262241527556265232896,21536725416141567579087391946652377975464148722776870003201880108744392916413359889556095470046283024824121196843124991791974222836680958646400/22658182796958838339859052663821573686875091056251691422495504943839014016333921826830238678374403135420868172101722352310634373158938094533147,17401739390020187593679036449312811891446816164693992732758408622396717698867005800888580994477806042660042038502787784906572270412347894268416/18310316399163725945534887690700076722397661822014791492706892791304294013638555723016480996091426475377680543733303454430067505772077273732849,31806000114840879302083868708285327780307398080625500019335498317595133019988916108000007123261636945981284632512358580194799549893064706538955/7908658324611578478594354191276635666523724643843749658101094239201723998807895996254896042762106121416563948234593760716036997794906733826752,2375968785873126134087927481326473480021771235770440440809350438114462652856838629943804279341599094700615642460149303628399021683375269921912/4147026654255370266840980478408507795555470836220563182402525938337340721215492789380862741963274086819419902542820889529820822410327036619,8567877262196256867508115967196856963155271531429397006013122507135374220558742982716016711879115749067164578570076392189276346728515572496256/1460923797636494097510607587323089005623811885510024711069651379215653741485358301300540241790064157856750381089054644328168779508935404461741,2490817300101260018569755131116271923645769151394567626550385637581218195164053660870445243897766562852606948647303167143740186864923883783106/399112255204963677669238280834084838917356980942524306857014408806222027734054480451455350548142306453021813138412130816824130104797318264221,732171498954821179002074732286994018217334618914168425836455542932517122089384785874121694598633169741758742241994819427925445852331251693824/73753486784869476001595526506074798962743781168108191222809271175049993326036017132064544923919169198434860143557409961420980722770938093187,2703584358239569269181644965593540204618781113049515338255319909362783770501356267600004216194138988959982925362398161542851389321027808797802/426177340648027576953800630616298192008328326699572636433844127261945907773291639544456784725696239096241575634929792058329535128737147252293,3901173958582864058410045214060087524765330887748900855638182348864864479647150221608905447250338432514344652943796107592182488690919732400806/354439495181924910914453751655887993964730399766037044447571055388859656312484393844039097862070282314471817504711182706932676513087172074319,42315516163126944433215323310838663468323850144643450076103735154099039178148431361394045307483401575664904439742318943717852808521557951044728/2634166188119441650456706605539882024716047982757724874216189280720983351918198787710935847802021931478162740580193142514485069985613027384821,8892558598330708335521611776896755655750966286800483292696777918849162768859837203854901931376159561342553301026917966580530121518325172327740/2164117472936990197844405528325368630271012822660151861287685806348720503502289935965999456773293538656492865986927297125056068519510290918707,3154762655691889251682318650282432239777517095032977963765199394318232693406574160113613238036593670726637810126947216221237220640972061744896/2895474799043733819780580188191306328078520764376814686597767055024828931055177684450360231696214550707174556865568510765809219488870591201573,315563039224343307888259689566397322273672519085399970948515493276504419648652016079941643341679821119512893292416767878720581727708588794112/163761130776031835300375258817819103585899120472890627565694391717705531085340669002142279214539638013326324240761722861113791698662325889779,582128963269556024891145899448884262393150754033264728512640614998710892711764311588378012436814318068411162360155788007215656070512865431808/383425428723993202058798905138965726436451214720848335777397509264857593847634582876896516427538761366356492883792660631412873058539731130411,172974796302742597496039745169927669641913546117494738129830421020684088048701462025101569427903360044958301445822228178086952425724511268096/83513753329805455354731594626196458671045436060160715925286903010330538585673156545281037932739986794505783616796667443438525659034061025807,545851964839383900760977049817734278185892973215973685600733264300471046692003468756932147388960552944427297760603810204512599906617263802112/187807692456474619592480920592299856965860540338566369190495848578533841630371103915809959842327503773100382913929562026407469263526332684029,-2506247620409398291081814218937969701245662313235570644746909389084896550677455506292104662346689990724399730078048494100244313554017553965009/1320169179306174940254856540401359433277165819119468015264218772384228697394354841230508994311008402939262572225809193823768650161869963878016,-5176730477759277767841319080699310360045567305341730166487836047532993579902112938604907775295608552746456073926591212801981366254748289067989/2222093035021780344638248824099918896542074273771624005125923655291342331128904014476720201908820819462628334186158519656915758640662316814336,-4949838769802613090391238924716521684779614160418267570811416756357752074554227596333267029494594360653551091585378177291451098943599775579/16441490474968740749209074523063473671229437314858053778776490371637656261009218543886534962543392530243212910011845182343922773316250669280,-185527836266932738445318307358266465877255830396777989442430889328904989042201635037268990570414011440435989128325237408245332030127193678667/178081628112198581641958572175298108361806889380228227303366141016700856689907376026368030580960899639960678168144320318799278388228728798868,-3618297791629385035466898265853689878303853171761093783165764100333599905938894838343967601195325080650488625817460801128593554204255081417/2365221937159540134783256477488419532215760700290095791083968278228033470401487382778600913062621185752292915647470736375981262641246574730,-120832395996806139701249368953689384779981400669124667560547899311501764267512744770768365871425259647208602903624704141638229346155478704799/113776307188308386915845211217050675914022306688299779621453396163602206028436318668962792522775840728471516299355097597978913500122729148336,-48445556690964981696471788508852573984762118891685505671076408014132485665723418429957693453484281454829504581354616066588281302361275487003/29539793004457899487536755659249529560537755737877419812271220192978974774996411781958576933982094827936160246338591138463269056135137620657,-58148815239680698987121632098976364282364142397892478319673780579884967601998505400306104716952096458986762461075209425396914605249723295399/53491795759531534439835711385541757477469043206572606565616547649312416541948792478241786680525972346096476285382327820854855075543266300956,262022541352164088122037373360380819853267235878928741756828044715255004915122653804121478216126050035573564024256409750165799982627957056759/319865360687306188073603688253169872463523261108380761636739072238480573672062083720696409310628455939462139820089368722774580735278822674964,36054458424738320447422814867267481240390399365452373781606845393564063269446019219456519662020973336998335685211741226916036953173189083647/153697134206621770042813082546827694768107516744156320425287739955050283644073403031371941903976598372128099445971987098334087910571226817958,-216684706679505250465280034554144635376656540278563452736418938129723171266599038572230638238387531224531970232226519826422809125963310067213/328407327378328890783191242171867448754405263766523805974840855555932687138015944714918019529174280473234841723475587352468188664207559777392,-1490949646802977659083402382981751506817796341871682317315850262898713908412316880332083025613277309925328711599466164187500955137782448016783/1106109034955455007426171043379710435694897648061028945559276399392861526960228044308508412497016786524020586713822920956388072650394847410312,-1484050344364597911456493043448706520404562425616976676433805342983065924475655654745338270209569299898225619997252975989506159118250964812833/1497153637144033043951087163393413828623055800578027788000658967608924313218217659780429972020400059472969726347979152214790609404259764456336,682373793520034926998039451975898782638513417389293800781217515519269542869842379725850153290560098071860092030254737069646800835052262836137/680603178368862689471234804819107362154287326162823998056120469916376332819937909836880712317442966369526430942380489228721866800295459992624,417121626159595359833315809985005715081729752540365711758640073610033348894646344744771652332977712052922894880609756052493217037301155688103/433141429405418199564742880016301875575143363052790541704076057120342715339889292108596863483949632744345525816754051283530525647683952014970,8583939881674072139945622978942476398192560063344905785575790648540217549401493832950545384210559418737550644903859350053197552037705089183/17967018390371415024429802969652830909278696143966159311348102391266695937635187496822967289721311462852613160396670063596395909563711597650,1181318182035840414584145765807397754942709004436111733753219468959771923155174332830750484186135685668448204876030889008257212360845980885293/709051436110862069354605375745141599720351311300888345584903942623163377298629070665713781201775229164666551190359228959605361342929472444448,119827769014383540728645596660184877764573612190922185348117295082635416313121100030232380807003043425405465222557433131830156595565968808037/482322543641033798116389577697576324819018521094499628874112704813312523923828269646159228664523491039747154754863505402533368200923549860190,289038590435747177520968630410550937785551618599370002981749649259387666913706040371436870428900971423727269526134071324583329993339839544972/352096043149537577292280044955296478455131278423568982440377566638565552273479317221404481249658944232847152119177012225052020579942257420417,9039276245802232393755739120989537203095814245864821663179675800276206091026921648020100895078208602582274937100648706038276430576213314844/18544290072860555126391524559844543489082657474172361194359281232181712303684309935664647479811220494973311131247928146388690847164599318183,-2825568515012113344773074622795431582286712718281640431062237081024572186505717652534375385847445710324657925937733807356964111608662021881/61087837451692909233109186374433788238208181591518679599188764548535309699992297143230367050416089369981295950453796992832422980664182896472,20111100829236154221451035525616301918193401004383620808707970963916288814450167601429985509774996743596061201192227624260522382634522554057/201767498523959503648863283657096701095682527828968503538759381676811971925976785506174780063443088581583894665368750331662891909960325799369,-17432788700968379738212936117479466660285971434344528935079454655805984574159442489942473515231795063244324208009417476077514016162823825559/19488007535777654335067582366627925238482989095164545592681571988719663969128520911942083490610583737686538890421586147568711242567765201389,-58158281038783720758958780630464275349891520173231966706241023433283706671613668247548429234309872109087233537825309748831476002113965391401/82309442800283115566886198468324067093115373408388191430497503708942566092396228481120576363437943781230291076624655482450246531860678550608,-9296429363361300083053609291513071358907108052645015559988878323215713223524513568451164949319415493134274605541704312372974866584883362999/9510528171656777138291675112525859945187896594578834882996240181179575596415209656817153673231113557975910114278137903354746080590435535604,-25796780481961827696354043257087655130451986399106619868394039970840127009860416392797226533888491305317376782058402062635660297647215510921/21750961832124827689882968925416282161701434856616389399038675623751242300117902372086004660097279380960080136246379167931971055738848000066,-354060151958627531008886016879568016079298466836599633906721261723619884448172369787984979519548776881361190185595814987074974316906066561981/316400086129440683078240471978227357613983690888403377372359963513415014352159526368103444475525277069377475041181105029063484491793757706076,-6315728854911815263721396978728703756137701107849494212314061319742236168196664405072114999358442394068393796677197063228390700564047950997889/6507701210089629671176235301713641934382248858480278027039647640988039099114914713536160313998511626270622834207438946112816302548857775838444,5582128758173811403242128918491584703765628001107840263346643644762422410050616186662941455921268523206601664500872913109294595521928672539641/9518639532967075051839180170556452996982364434005644967436631697369612792143540886138448351321597400298647834587140204006281051294244632281693,989364517835180291798837885349868666061327006839291567684467216329887035404663317192969947407503893729094706143894505130777388506783346119551/1857280962402419644925118490436413964855595132471408566556748836315588505404784432775208403583156080536863902999053989114899371292579736473551,3272697031188628148476048772312927989494756371550967529403094811827942190070264834896333846181826817161518336657743211955231609669820607610517/6566378595748070868620076143995951627632085400349937023240228889188088153313877593665603519930207602683314749324256112686228251474035821626509,135953225842081701910742203965689976396550915344382802590644455484717953616245090781450396105452067334447797406934441016390838949955631924004/270058168524173478067779318962815558687046902189990685220891154631487350452410822589310387295575300713947125600623667652681520914797388267569,-20802385579953271582750825974064425711234478573785285541949708252197940045747264451463477934827210218042043382224709048098395062716707353015/19111847314141983056003169472778096567864012315093511041915238980400243463650354509850210270338848719667372387338254417670085641501698193563,-732031303797986375875389556578472510156810603312316357697764619557755161350076336375565497550790456855351933768357939001963673741478843131705/679527017098489280201737731986164288515338335855843549190283786521469229731522081615410589349937382051047514053528474308100213933582772098437,-111655641090321255880573584521231578555473913922565884176584005892076078086801229445487764164748721939965414154097323987476416962017680183595/114144357412211187285443901015793038465931210842909040624716602928346644638109532712678205973887393890853092582264064912820378993926810094831,-70240695308941634110957862826749645070297888865423020430021408973596412696488273125160080155370904552915461014626493647943528510079681762227/87843369844664853638953538050053149377118266270705355719783228146613255263436661687158110828110489686804446069535201526378763871978540081415,86485059503819193865465071023787833568917701515677982995274978203689383559464021378638428885326227426910010582202997353062273508016234142493/270488851008647232752023379725956464859238367726669725777607464639961385925979390869503242462507861559737147290878257914789589433081865038581,195322352169574549337319972507412827711228009370692969907132929281386059592417901430504534431563509745979919106437225270083368862756065821529/461491215997801510227178276749021335714326421028819578882052238105172661562413461723856010972423379401086799363309342175346433159498202028447,59110639567636949755083011841742171131691773223468023789710003665314897789269119660154451917069298128860172739314364099918789880622045294/8189490301894538345033676478750140944517001290204982269337149585586426203615321990526294802818691854095072439727969153334779142637993064805,-1359235682327875088657096303737199791363595935652977024186746381985707287995957666819598313560581906891938570084145216044089748258612372604285/1509752864749177987944164185231941434014986555875585489870125064000918208895046544923900226469253025993350665779498357290614497654530171440138,-187203484379101501384937646560485855894367435523352153432522758774469025427649532899591976726054937924576602617835814723842122807123670028855/206567253403451712673912365853554300426893795548855593167316336168163460171020900003457298743281296715849815541826698943732440210503567580594,-705841699924820469735332300166035570723320219498103232067334056952339362544012720292489157082322877470750821909514970402576824317423441093/6697067918861160156998708049979978521852127899730532969720862201056792346606396737549167592042068481550621172762051988314569784674308012743,-406761566530957167206045090811502332576565781957034921089143016321407338997309838101535158988850221980562897878547294851596415327945551178155/510205387303974425833028404482369049154396813418844236101826719897234590275447417621777651421184514741924939523490775366094275253395616054979,-319497647264275544129092657874614467645097099749582513466217312862564634807123469686188077044405574079396538918506861317832276620892883856505/958112232555936299490417663926442286233453225726745459079967127273506130166648181706653523784270516209845856396965433243138390041834763114072,414916041147500176985687800971453449988198580474578315401935178172285351307973435191475170484137063174504679357446255145030537729533289458722/724859687198824419445878412067721831121757884286150267294012595545631548018772494510461317533914410880725127459667878990088835911777452515407,27808098097162531066838523460698162226568081587246241152089508198312089665964998208696464441119101489157228914367773105767383653648100678045/77745349617566538206019896928669163830242106173220615974619866350900337602249646703838760312129873298229792970866250300915591572725354726141,432716537847993224860547591049994157739228332189729057817005980964636318541395980625365884286143117139515161551416096014692436331544024100067/278715830438365591982789026476471578490745730677585510403584736146378649622805752782507092510072084621717123711651083853002264308300149256359,5614599136851523492024294294743562998735926973238047878121648069433592507421219576835427639434113425086569671870035171227677645870254171207/20151164692508455809111709277517722325118060220925180549536729731576905915986646241252308951906028935141021878457603074818619602867705956452,622851997163934387723672609197657276850750595121769693274382633462248510764385581485657416913533956961935353388217747836015830868422926173489/252964417111506079401777755358225209675669460247263291927180785641809123850295895597645055208599435790177609555680416243908794792478161989262,136673410607438577566793299167753921050120123820050819735620630021763542361638891772462450413862946890793826616344124861856268468994603903423/13979848129608024885218173687055270914684486494783320886249554812084981625955558777429606561170153984866798518066058556742702441936281803366,3116376590229387561717083261384569757791247155895106756692575463221785678268563691817639800960778927944004201176834387568327177616489801437/357896362418432701584675193131434492077549692475270858645020858182403446427470122475345855495375767483885300320887946644820319330527484724,-58324061054206979095514524323483713703062097090345709606453254328127677668127820163809810424570633245428912792852597805208492672620433091493/15004954476557667132030694776120284152224672340602847250053656799808260431485010895959024073515101299069504572870803943259713330723740483401,165493203852634982418327752103641546745520354208484887837789623063123749923857122345937677460369250108346640057038998595909332441124327143787/12600058646972090691524265465129714705593416364471191115201232807764744715159567603960912238077188694090420583724128172988502063359401849413,696900893717489532923357955399353625077106710199325938872914747489314597064973987537298444225154588559880044487040295206580968466741897077653/299951527652630931054134420525492241998289184349410293454902996038076471827086762106231005384646148588669633527117578092159252400791262200296,221585645968041913301147561923426923134383439467434155049398341488317870291080900024850026196220242594186965623462764089171982582787176051085/687216427637022846749073151396017298099046694911393835311859713945636904131640999135966966693615983525779770565051069562128096984095558817363,-2442905983044320435372569105593693502533584494675250573473928092692830033677527121852614188879701340243746802164060220427083576149788615517/5727838643652807775316686571131466818046609444150665658577545035722086911060211303652128723605834396724249780881063836071160277274914209270,2451653965561928552608406209316134502353861426825927568640830494300388262063192850455699869187859351440725045184601088869871668409308420681/54419241292541925423178915679069680978843138538651183367233923585739074245358987359701122461550979654605690780564849343324748948233930918232,52784983122173687547038571208861313023045840761563889669855652719952147239320596422522949150686300256167304621708966414873870705574001749341/1261497121393283123884074287472435313364499874928817732249703547957238920163256922857887277040768379832267118105096299899818056517007545821916,20046722711700111243799518741418370122391902402014083532860193132857388325149206131939241648654643145039416602070651112592144915502564858869/9171155713704306765112840695161081279140549512961764272105794917160200700933677609601318087081696973393825916888912667803695825995864340298,138801528402644374871354886263776200838728893823265460848591960606220031245429765129912905586610843621670221936742028599561588946094728784197/53136938696541373521432652157187735989595654814632430124591873351827838320601387288933282135802230223274679609374158540408626606257098203796,10213631032306578278289516385253172595873416898951665575392567003160523196259581625261376343371090720312479696157040540887352158846557532467/890188396743772821522907102441691164605765512309081331930088860106474594612841106760103949966011894082577515610499249187602293142560007244,3679716150577280450848128195836034418488269237839878107305966922074050059847467291845977596042037799469264259460694846206951572489883193127/2950097705949738038357310028915113157511635217382031603316989771745312826187510991847834028246959103601093964862791697008016037999329649408,8947276597795950939846723868662017608179257170600282434281317760510926538177920327446480862711439404348558305584634594987821800219476857126/4837977426235291722143423880292898699470650846890344424721021453533973496377342332499745904421794212909305163834243451521602805298258451913,201915480851972347677285416934172951813005374658299445900548544785991346541054847504295387294363573344582561424000254667087164525272058431545/109979366304581212405738556148095696218771326531427979645826510788245850611119729289631805446346847335096730359465673049279427922606798162048,595752770953426444492020582236724015605134240536710600066106547693110342006724419562148709473721573441749758454400860588695220874963603671383/305160053051598516412266564293370118211777700452067262543813252807165284623505962267791490097718914161571074327336856482953880669283700513026,1787250002915400758442770810700335525390653855519785586343804635875892352102827462143658242382127422401336240017975130090503818920298307/916443391021192011433289409437953176624976403070142508599683857280192057308045749451462656963680063789623152658319556548775099144051853,177906134392569810509763037981304818217754790289178702731232662896938058341258819547963294461057873856058670053730591755531625917163947654209/99595582316516944473479122826987843544819147501387641417815176264127813775236981230958629193876970332947240148146104329836833948634869176110,100512255898543788398492589448912094996232404022855278208300644527658250168464643863677809158863538359643671078010576403991006777696705280851/339878630471322462373894858374377643192824330875494122454792684494442668797192372760547853082357719997224369197999545021948388481679191901012,-667377019685172388018086519579784918539233961769755127651075505845606057698775737769809840204050681399681205682918262248630664606755535885583/1070463669901027389572617163191356053081534240737340251387852991488359406050972689191272680870195985534566346416493207632603868821288537436920,28761552783880880443474867223485381259640615397907534040417836753634186390810406336143643388489758554048789137906960197189011207531077638363/324315802989358330172593428434040636400358103407251982734502117381085054375616778613990270510950256008541702417280981708749944510327271439180,-15797605823898539684886341517562465560978551025861250296580807604419230556688160862434822090454982888146647136006081416595166500925411368227/37369776715519868126408597245310765718398802156518205569662638257080186313990536798420631616497746383173290089793491764294162443959032488772,-473090568253905051322616733294709935676232535222836178526016422808115093881522697624880406770365542155868016967542137962297879665444271314607/573333471300146280217853128869635924798822064915445892922155401207947902687894404330088877390610634080888142698524778237044106949902079119760,507832190926746913575473143072607581341717338979625711282099239978680906303419141258158049293713877085830719615219996483687509980510126827/622679511154983478322863204919580192893691904422286363903608242336602744320970609131397855516455853423924880382144482941407531767178822656,31357908446995932575462458349767892462937078430661304413382439603500082460893243070793076587523883548994340558805575536314457849236868313223/44223371412075755836084315023389348708554069114234449675453331393470620074985650045366868562064528588577104049939462623230470179985118252352,251063085000971953103029090455332666107793995575152641838648354340203332859087700761722408565409703684684255043784012579000712002989828309891/72056114738729981263106579205257170196134006704265194397346948678295956357112461856552112801384807589042273151870765965713089825457104740768,-482656561268987315916228091629187374883653645234375812526965843962711249986253048788915068199673914762470706119952366241252353555424275263591/306355550802414094910147115891339083703638461324848543089857545870209207234326947692083109871725923652773235413961467678488727250148134466064,-1283813721817775580883046243600521589943491362901917726962911895524672679284775367524125148476207620135235643098403196953244714027061164222037/434807366282935511411944974281994858753775443520271802337036831262191936223645715160613209303813198043252709620271246456611619924207385251424,-2868676762720382949170722431448474217708148461663139282495267428616726026963882469790801400734057041485629523178072188466830812023727376058817/1151184601450839004488328600062330055467167617501084770819392505616436348731328511824666480069069417084972023349603090386548090073399321493504,216990727477159660672766117128986165337721179256470373581943645876730536115766650013895991784354239207438111779083827118955714995627224736493/62821778151889738200661183098585045986639604793854033842140015981126039298221861453480277255451587277971109376858816333202875896440088343648,2726123819634063672758703235496821657447725005390847297465655281770546246551884809011680951942977956604825555127798321759713079773605660066577/757440357886968437717727794433359986968374670185491325354406766329215038219689951898135778476477864545334488574203206985396298860152535752672,-69800071226051708575049324715324390508330803822145252447727882022622748264100496177046911048290848064826794666873565749528731636035084626087/128986547478692632631758641197210648292839252300372832950477597247430010260436111913470529046297699494047631569795098065196747412352246645568,-25168714459292348437246171301784836838391489491811407728496822925809774202008303667024677232924689420885192848764375746379421127366776394065/49245442295724311323628552053705354016600333684759201272935677826043935202174114387497421438156757194690373508277752673294290734676648170378,-348380565298499500604288165027599256394023249469992385997737212603323243847618127745020081418824962854807780538329912718411304529817555485507/452228156808183938751638478393044536117025573966199996720436848556760704327782479106231652345220547395823591302633122282267139299721439056512,-1173301901313110025502476526379500192757370760535090217170739286739754292506370083167576634331365455156496380096658255532134087610386347973227/1442561273801823047280957871196511614436040574344276595367821968877197357454534544299308272103519032846909608961326552678012946988197834935392,57184567727647124719319254884831303422415325668242023961383721595063176827143540556757804472206833508077028982970034581619535794794528727735/86446492361201299373660107663399551334693954499590767509770630558249943197225356168617219665472263650507038557524813346016157162624056745928,-123223938721857108755884298601160599987808412994555128873288744253984179302112911996373119368240792233579618217739852597247295579071497845824/121473684717542666084764436092215640771277353504515667776096118902838240355173874721308180010125673158611096571734872350585062644206640304959,-405512101128529188695142757067210604538435794044924509891596000319426847340523916824822226506413111349261450228438378803748082310594244401049/432544195158141474578508710917625623380964530317449404605016526424590200639285267105823191605585108151189160983376984390210670369221458311264,-72010783970220390842969460117156606156210866674549162163948906292814366839302371598501477068011229301586392126781570898422399438868661253209/77077004474060883790391475044677403584341746274522364224330641008748478113170711171872427793462376214305638604402985229250598054861956370744,-95182460889509420368454733061150606575966177577658329585731707553110119687586762426055229132852841241734934492539343774520718452990443362512/137920690107714037293504778525879956941957969779526700137038879293604434679988156537662109094298019059584387611412949036393779555950895787721,-1592867494459342052863664019830705266777617490666066079959319329618281782256609827785802832765619298342107100610682732277553752984631535040819/989204742626192332457115177296576667689785324613733308985250288749503676007747650617754695544345318510365694043893547737043169991978337455904,-343912758545011614874997349445644917445758989740004398070560955840184557510655421213600459656982530042115459922842108834967285596180762178848/484833001705828107107526761930540942805965648390719452642229908507676294380893657102895335554208916602827255435968459373857468975314258116013,-5805595934740131400866345129002600608002621891069764150781515283523135954068070936638228871330583136635621190143377191167108194113205629951616/3338506963924372504564268650259404754005455973512315740948290573652475985720445204687951213980945668251032404853429488095524386203046431739689,-3303491796337922579053903722875193747754620262044690213460577158837688257597740403223281915186183023650892057284878304660517018964088484849039/1957881856256778741961677402478525611056157627157476280954112794262269580245777004069748168769051595886745998502770833107494380411845323525824,-1430001747560500234577241646488288670605249226900699547687144373026643439514389992278618122447725563234804241738492285029667185933614101510863/783818601159184240240479699349380692765228642178054320519065624975771571949443608673943763414419429065373164163669559628669183676551190125848,-2549147593035203739363222618261276508859005223741590938260080109699236276485293913022989237592824159952772550078054192121473691622917659287477/1420578216458334666790735378817298755525243503289113353152138020511451980292177805831321049238624343536029956896876780050601965313245760823072,-200375203081397756591518792693750146025572646775733124654075234952488769439021714345408692493275357843097999403501789427378616370307549077708/112284319621912947876735095527436976077983479087562327545942407756764719267231456985667979931308449601940845593289050215311012906473979810809,7510654862991442954448251270533605742195511275169267791224421847830934149426863069969282041627319933542167447558405442936476615527580436415893/3414211011537676784611294864812362885096938816408270316318524140123008039504126878426012100501519157429249615059118990029114626231827309428637,7760156255799261058545897694668914108379097913494236562233411233172881639972324878105140048574769651218902918623257202350058574294747035407560/3117090431297659443344492179668119078946390809703048946372803772598208679538188312603018139028931447755729911826841258932493069102089181672669,1320749429373647700839177260542011124463174925326600431718515565903094598216355697098050885963905210953614389344703096988633238381606496380928/555479102171525687044468671929323947590836013273595404825356467305164922820100174290039884926815552676984713482087021335047853434145155956461,-8186455349646280598190370763778580159260183307381769814822590032138027874827037133799380801048861812825218315982743699256434881256872070110619/4442714133385665600202149235037557807378964206731366323005270576260051251075222951918697898027932134799426339181844540348861162459593453300672,-1145103809021902624882790980430367523936847823234936451687724267092348896526882032496108876664039839566212293714476581687327729935965086647643/629830972509951837364737488737358471395337097522263850642927462820376562932602824082235175840942628813130099116802945529373105370415480642086,-17986585875957141590356222081597565608690657802506418460035333887882656515844696890452192842505715688477129815995755539234853995126471940306607/9673294710774978469536971701489573536382094588789858242739059301531780757976742207619909345083572057176268686247366308229697651697895049476416,-34737304056131787769600908073775650207084807100911969910748094663344665025344589752021116457335187518246610138956496048590453818046327353741409/22022585739130039470848534724578286244932831336582201405168083582465787229488809579386538391314087175588417615572392338545503206282755305795968,-14115103763267632660886619344405310465934251494753724060605092947642513972980651024959532463047718997393486214798120228649694408448911137821265/6212680213084468546549960321563410045655161752799040966565607964669960988649334669478620055979983835265617350500524661748351900687076789751424,-641253376299142993783606563649185424594104526565285934455782224699903656882888269963274102051245977868092902575600061685413859472484325885693/270514210698905245810713123005489338219698581937323361003687947231898507117257235159347582746655390546459791232849245917495086862776225696816,4534967664283931425034661911803122116272553367654232696529073564739166778106748692835098772942406325718657627735767357968580346360539851443923/1872456330832390807434789709888304074509782060425505630306134660355635046699642770246415800781687312596597455534692601404165444886380750529824,3363812887080664199320277477011356170488514010534820918788499898527185830455198088728088829194888618517140744088798538641085751085340503870139/11133955522385317530672691854189752322989648157618697368382910548198996385523713846018871498669726217556513493458858119639146173054590314878432,-6950611319677304884815533511976885592017421427035368485217788518838586230642034837327219415227966559677284450634488633735337563575951096413167/9769392500057332514611682115393469768558010102426338790461740666475429375484100398086904401224979957116099032188660515557065652329020734628112,159414267042316861698701087665831347506010875309833171811921657044337469483409585518987291876232172875334278850318405446780473426441820522189/273286970368435099956394450544235725799875784728991029230735519989679986248065630929807342401965698194924334665352557936520725052283424041472,20697936362899171678203216210306188630497257128953859431682906752525832983770706918494582834479510555789575380945078255959892250047999840263/30123205792501142607966765075774692091403918014443714956564386491791136037717376636814409905836939067813735539423224841980216257262420108276,-270140480387419326326637869578133546550914595189747475507089013940406045767272592709500130425814202561029990875675259541608821280708678291765/70860898039808464143301835384677182148868779595607717633665598778166656492345517946657401371978895906698359680599704093954058322492559130784,-1805717622356575952327954866981346508144879435250097148153925277037693198190455618600385366368971389216541406273011082084120373163533225014367/332028364296981015949860567388667514395666148664760320328563785883960047834223796421507125215216329477238449046377798149682460717186449719776,-720233826806117696200610808478102835707663892909532042503595619756905995945304415590684683799865740909338903118456550326319143693754993009525/649474548829967691393352412161203091856800744296798063737248200699121303971893895382621918374666922538871737063997000849674351924749628414912,6264236366587673191120923329179228687628564114898841568851140628482333749474026640292855569626256052376874869261341599515277511196570248083/3534200944347505745451820709189072692937797834010745537919783043950127783356319641866215774891885326692646527016986748813168669755833356565,-260588416761261833022256159053063111692119784168277124965771546510444340483521480220805396418679377620965770662923705941618689044844203554575/223165498350813436755414777097271018644017049980173402757017380648515364342956293694381757053137278463835334070739695150643044777932968949696,18517917145860854253309723185780800887471058663038287934466997333032053721637179192368285976956277265912643740605421620250605792637506762711/25188138811166152285732798165312125517593240854525544178978735371626485716577353083976940258673393664290076119805247047540129854757359960152,-976339615597189143877118151438864458044918356678567157889068488591316776950061195977417682522218070847478228062218927988535678778060485682459/1428567843867328987854451579627799667160618541567215134365523981175765820137188981874925446753422428191517854408374592129258272031572614707328,-2343076232946077584822503462617001145549316004790698519235344397805171544308919849759982777360193513250813865174378514152784522067922654660831/1524998907339021170915752101679422789278916860882386345583993460292259815173462194404759717777104350871299637594570213283681315428105984398592,-6126945765150527932219106043851884919610774231267807081091611334012235897250972310159163595452613673462106398745501559614018709127775058324439/4149880114553908967499370590717558347761965964908885639820267830586998443046934519177802134522240725674678895430550463923124375205910855485760,-2233503244580030465793196911723204970010550689696264013400955496896157110655691487308768319797978884160529057634072529331222778177782727483577/1622375433807406427363005118008825919636454873071839353658821092614884119347132196135290966114262609673322609246162335194965306038502032025640,-7698845404387371027500939839997326564681259653507148441426226913758009250856595312772026821344829326241496655540507169929722007047324974124347/8916347029966908257527389056418779599179696785488268078516215500473641903450499344446196872710995072065869023546277371193356109489746271395040,57517377444172661796836593551055885099025532923037844187751547478683179692145277455474513817450132555375912596500883470019748549531996550464/1282545483901267319812332825722315953274428714844934304463603381501761890625568085067111841947752632347893947576469001520697150144811767059009,-119275391590371986350056895228938204104808622475932129791393035329715571105323781529057699474581600805158014086404735900545646221852734392044/122981970582914559258966754889349236780898007887386751645472402271997285388720527432260897138255459028747207646180043134032150704544230175013,-3084753180717581958528862278499735918040889634083907523764076726200772488956818075765118462445114909423516079620783006780020209315570339346304/1826364055884736338146401612955306218886872031187327515633740175700441809955380765398647722105041472702401267408919496305659073925178955420443,12365568205856547160252090769611715024112767464246996286053779359614803215477502681733256408707499643430623350235497279851157837208110402980352/41936555493231021587660059773324793924812953686181246305031125564645104597282204396914110192548215784154594474352005229491097454520217212402203,-2167618156307548572381375955713604643065978753634000045823383613712500581029215611250510752308241327369376956096249105694321337398684478073216/11456724038086870841596326060542792128626347431619399736898388753356445527998959731428894900946272375376652026178366544705455297146628322146081,14720959919756529282727077210058229402111640092829541230906185840369666215749661345085756475018766586731821729535017908829011180903439339291136/70719502732441701473958505977458179917577354061939696675401501782211583252203798181962946853949710353801688269163754740230540882829383561953899,-1937329170117871774868100832540604731994645492368030289030700635476442897932647660613933089769774091338746518510902339823455910334584818914304/20095086734173004841254419606812558943590360071764463614264710823346524429476628772198404699112422469407641553981023777645871213982731671124911,-6659168478822850607764461990759101033843341172071724564893764769933453216953335333868454277972453628659434514288056645234738171992005803068416/11313422905855691689575929503162074375168113045834773591930258954161248684141103648193208197438606122353916691359999940500857823282219538622279,-4940509031736168939293354356860942093493568117744632084252234625502724800982446145389732874816580454596214475421178730183635454843180776714496/8927341892662102484997891598953326502268077629038177958530513887560842033217586023663352144590583073862800821611441996373162182634425652966717,-17787960253571055163000364664164907422715835170103039231574001241207080162032697337021313658735155449813082305449783313720120070456563608378624/25349724460723831486698965235851340665572913528560702467038595457631578966174633497955340494813516592130226142270025719187917175288103788094873,-623929560466135824420356093015912907703414151651733620402626363003068059058761655307435058863591195831625711577378625944163439776440093049856/3911833647786773472124295914582302775650973607266751486579707636655504208049037762646365598061149850989713210571828307096686911981022837868207,-4790174058941749754994889156079330979041543228084577285994285407663787329393326592073601167418960486465119689467121787995236003942320667965019/6136658587341508037117214926582393262241351135331680275846503628878641631790408829469132776568852580769750984846274904299722459666100092968000,-20186425919009690784380954171512487872809133740518428264724284063101511737442898579359538445573790130598362431286423444079124691078397716293/28874259231924590080416451163421443301925749281853464121678156468079265976406327500848857596810880756677516456322935673605489644709797496539,-9865901531121961520013012248614949836654979430377858757777251116348098560811165780904297344257599524115449148204974001439956987627321957877/39667606709327383794140131990916704374653162774027657721551249073509692819591430205001863192172518595527437606692607655590954979327749435611,-3970801304510528946839817559280071727400179097922776691811424607679447637500423720803572324172773504218636697716929908638879890651997640481/5676158039020845185449609302925971239406463214076334682708686998032746485111713855170219968154261534818743150174655740273946527487282622445,-354612354472097889814589032718750033647232380743297699655676500332577502465540563208587012310633209610920739648696558108765356257460279613367/521038016961988161790729698738736253036185274643266984742355768076876665909131110967476911805612724946135977625624112113423902530292507408742,-19576835248239181455595981728029624169345217378225397391734365579569896932569991791678293929557190014909415520594147516709981204961183308123/31235383697876015117577280123539248933026056554258970071485112124004669517660598911083498710115340171450351726735173187381616801008568564115,-862978433901592250868167876389569322500988660254972267090674019711606498694934927596797052903559153421010734951744893486969249457766303008659/1367458738522973925165367697195309034329015070729309054477197693950527355759554062168268964245626137378150857550932155711979710238785863739950,27957587299231922411416944206403529227220106902847190061038892716118125980097330039480781846437678832334449276775632424441954553993936701121/56807667042386414499944260425451791316102126009197504550398800805429518236480157561608394413883979382378731478394625214035748562357557264496,377453240750977684142248551106154523258242016228516019872153758189411595713427630146842691719776467541446403107973301484491388160313774984243/1467285626659881324995549663302614695518300241693550315532725750415323598334096391934379928881445424124763625736994893012073441997152006496183,-387545046302671491810058985827729345432476785554058540714847433142708792649474923609343320577965370379357160338964392312061984833397420464742/5061855287715358593319318225821315289221356604380434160562178125672826292178527308049222341491044972187440031984469472162573891312365737610269,215095688427936770945847665034784379368574195238322643410646378854332454050982396967727753477562126493537762346068172699095349712620573418412/3232009576446500943398403737256722856127726389822942995961641321905678671299457610210793979874914874766827466880028495848080543588574883585643,-426483330728973289096278880208755804376376303437613766093510797592364089449974070967952464591643932286337187957834775666969276533217517907/2184275980593397737133814864948530779647657564801047378254300481457037846009056406513174450025182858176320632438899029480306914968963548738,20118406064957403316363629601851602964842627663398838432363482339758176549271822031270136743124190525673212178940331377409406848540760802999/11486002297632505357201529972692483520049318295033244125315849739680941943453662112297226227431076341822906537766117473676305388749209688320,215428845434295246443898441443236706777387598095486508472071597455127467720849153414990481620370323767977198920102380535835526502896950120985/63980468913976847049234682692031289389382551171053819292531766380384523790710300236277780903388853870443950747965259171271348941294957977084,-28593767605639793199412871754090556019769172829648075960354123137924367248346219114014956884898259915175768060401637540713673122371204983990/15065265059191852528881041928145676069026326882489928792512816900713657164285353791354770313206870146074710647958008602759235823704025407261,-252099584879901310138996681457605919017516248541839888215130666003512145546624532249234947595960975354871106271711826241323722356410028023283/161701616017482091285258395968103127580039270346019837526149760443900989436506472110183930598787681226557007424221090525869748931041532418734,-15876249275056710058593917088048091787872597796201539864327654822182596170979414201949554527207405976635284166423693198296402065015770185057/11142700595254619867064736893220608653917553592563294821825512062834522602783488118518043487195293275244354067603335034485188924514472039638,213186812039676704241126497662106698911581479839060949812305833724266866066433801413060779275748069043209536480211243752930400515765773919489/148405521206792804431132991549809433280401802075953119064856685910399002362929814840397788696270406251413305053960668013459175967317342858068,306886523414519887315865880567650350248799118951832033758913754758484087999455984051352595903684301904858946946236264407197558824797955842443/141336554693961825220152646874314339188176646281640077547394752735003171727136794656007183295047873686806219648776289202173480954536178446844,86602250557137664297303903753800094085890016722825715338370803396921672113882049110573578936063718310631229554502375716721256378348501405007/38393638332600314419308155630472479634810475343604224118917973038550802860384825006005615340245777047492866078542151601502157468520358129676,196556145701844773869495408785564538279095586077489162975433590794180510344616781852828228467643817184994366333140452332260251107869125342099/112349355704450945542817449359240671557206883672485268112543317139314190411239045064477049491266328607887040801921096449430239294819316692800,-113812676959394270624117306535987992675004087125368594988521257183997511079607648870977372756594807129275342157831071685638145960139650450693/138654974527653624327815508103148872696978243339394725437376851039853379782654582498700819040306264524973557537592904968948193352998856370088,-8291667018915429596398572614798369985883529093573956521865514389072602024215734204387007590679689606943851827666084621662266627023656876441/7951671279135608923404193474110414516970927509368456711588167108645417687057962597778424440661473912977042430877967519256080741276622466440,74435443447420168368182991011536393819394016801135417708277519061981048551436022655665241261624545716729975863770559537017167188578716175887/110440699481759709183581919633019828642554553951579069724775513653403493904949251046035372205296098057716842429537878709899721516236892641368,-17269323588312120596431810523230731871997797253441224523252820370656631697673784850978059327420247834693266282847206017504917217803432722592518/276057340623525132497327336819023344626137942374404633269757059164806112300787391537297234866190848515375020382928403960854924390229720901152363,122756562159778079663593552306676725528705346978604091862456279879400173995747748612331811183125945866476185068669120879371906677371664466735084/369400886739182592963174468667704952246691717551232998548613543863686669655010817087851623561259085488758694389756505872133485116677428045229699,272655045220131930398681378216524106713593389407184410390320680554919640825881137966072571496872865553995774878421318329130697001125711935486508/540035539988262043371831039540569282132008151287033053470408591558445000202414611365276537101891915221357549613458114491799588060458518051835059,8028402035334859936056790991192342095311494984049663965609757319293507044568273541155032584630541788223128371849011438879780524621635932099228/25421983853486362341614542198445159260897992125014256887204001768420300241282949882876659670221879526803877585188067171244447257232292738628415,11912006404500223370534395316007137301191529784228771555567587452874013290021445863004156699956645537030826590205519666779981374349880009658380/23050988328340664674215379347020340031947885089165860798839309480222185575321017104507864078493367585031965299081903348958463731533357423303307,-1867872802851107691549744973908031099476219426252209224669474559765120200999399460696535809611936626530594693397757617722884419589652100671299/7759151652615257877014782880362209979025372339765178568380894873644101650003891792700251198965656240191715057170311605487660939022726199943508,-9055505514561227715691947875505115588696098465003946762752922944210637494847934799664642216750415768009903296897287649639005392367935285484704/55663630058132989247295267264820433120948839264692821502752073101324916038794790299918210947459074725398017392759272908037058666448779183740557,603800692671580090019200710859404280332253418983184102674449416661104852314735197939603248197626528430982245048294398257805026174520042497755/1194936353613283261821535229331888067457579399632129703643617861354966100238552892518112915824780904499946424898736709742203336519987170686368,148852944469026469955542414294263774623356059303553990134633022202753942074022634875397245628806291953506089114515813776047136979590625230592/138380524440244307379603372353814740860569775250384276004483479917492966532803457876125199113879186169323241403116500766121707081622751914015,3221021704280394592771829847137953755651720871976725346514455552951550833656084373100998733635803186896115628540042989859508171604835743782208/3311036490104173840579661179740228477061320836643735189629813919464368494361128148047010106610259977290679440819346054813624256607602640112935,584905650142690677505523811382595049447310957143587897470491988186377701340657307501440060319180706112264052603164535438983071493550355804416/11083480836283121229127781289286156136185562560507240408547560441098251512893269508991725788001616618865935222975072334933628534623263824495095,99799841183563401321804867951535770931241960886456836550587346525932896352259814193381407148764621422354256529893403102008476624741538427648/32827946430409619642742568322824593210396836766548469576422289755869335004526562827270888695166082274661816782244769001370916902668603980433549,204912209885358096898025099868229384904455501744849833549626553171080600705142357127973701632447931471339394770994148930388028348141945043722624/486109212485537145597996055257184326274119300454187627207254884361355698786667681259402882846097348838905168213495160912814051462740575392899377,8261123615357598030351662997047731281864343445588543389318497030885275251390628899583797734112473979391502829811231372433442002631911599960744/15293494409885114759112621015152171297062651408087565827338839034329281379975358222583244067074364060273238253153028622713231124615207702290135,9362200810930182218433759772930660672644365919296302754402363184937122505450778788540114791326722982611048896625292243494468160309011786444721/20452758999266645372493517078946422387305453619843689230974298673853161994266305334465858356860246266133459644716948581055834887456102287215327,-42904819668827343021294924220341705017068794405255604069112091877110939030839168301443559235504059667352276665174353719365495398905921777887096/429833805528558951127119434095113882158534458318485266868948921867684440480735675859765314222559256610991043492648978774796493992177209169750119,-20161837111725791332432271147617367831782417482755515806310539623345093007307543499907857847686715986966067147423582674427528676634670209725117/280448487185117198748368968910073413277986704259135906314760292429640687445894298705711946329242834045105080542267461534544328095956705207224298,-995899529255599682858788266246500223322780165909661581718119383260411795507682744559503548261566218354470020899948087306972025807817325677485/5694763943810610668544795556744349750343546018133539088596268625197146522082151266115039996411879823323443724732528710373368196462306058130748,42807559698965807797931172565526553106679984975305014116508354493571176556908358009333153246505079150232085223455152516057491069741919442040/267803039602623364439620668865054390831919467491042317830470349059574050384313454310985214703546437990911221272601458334482805773285826039341,48829795519624807484085519007058894875206353877188278641665822873135163807085810629440736480308666960692888858239665682740662869434385073037/59137687303766395464890512487511518364306356513174309455084529349643724431662336402127885044260081777874180935520718089225887675520524264564,29540212675773235318124908983381768051220849541204188611568540070507926524180448827205176472866106359443383918985349437488787234543416269493/167442937253129137711762622143291601995123172365420776756641166258088595199887833036659489803074484735368417124764738960995490838061238410466,-929466098859746800361235639521916402090688818690320212215864190386838500505264055790636020444380059967305210493016245473634316623093695227/3964543634956621707593449948636815743765698008933495460996339204133235197267492614322428747010134820511617559481900097414096408495884555312,386937567480399139924919068064942951812117744949076446389570254899845579653408526889689553512040141569166483636730564539665642951241030151517/655076403583221575391022782564175521848524444859950699480609906924073923489296813901888578568687589696325528118158998728575133996183773888488,2563285368387739522452853263870785782844961610732483864958731192665493995392819583615475259213420160044613521940724435699269263267154567329/4352906032955199616732660117693652277631555061256315953996416257810463504569745901064668938424936773173153209608796221718045153813115193160,2362000219623362433244758829348918421712080749249769176035826051908712144617164307174924141584009125940997481020476241416592531378192269687/1929912501148520795706849464938148744313398004847358029326204574191701538593645629711933220604669094375231067274541391337599933676633523329},{56400684827675954347469035003237096364553308784946925415067181542091905309306308133184697264323511300485939151331240616322995627883760567817/190543254304531373639860750765239032508490244817986359145071372079895136547417863891358278275441688017209098618975842631065715497067600390528,2684932918446628539771776695975430016273611486104556401357046121541556497311879411213932686302728967699445212089230261221525512207250567775/6571148975629150399627347801236861418641731139284892341273324960096035033703365085288828774982743170229425083590942940605718504563513257464,41347149119364361729510940104598482213573088025823065228423521679167250191612247874923724888516629622706496345842306599407662035337503535671/247843166592970245282570202516554028121164204695582256297830743405290073248202936640371585998406198376925673567053748257599306918127394171816,-49261165690875404675721149536516939754168667801235744436016365435694207260158514262151095850416989770049361665302346929479109491001467728509/1343452152598916679007774471037722437179047399835508707808728288534551328972891141616610287216983366589271186273956581261478183219539289689947,-1813259658211008230938568790216476941813111494158933520887024170211518089645926491841834512424042775121513166798128849918316960523060158465/57037046300490065423154981323350450028292628885545439194863948843421567292058586464812931914886714074302431712645195806724133499689466565286,33102659548272859036994354938560828520871148088705104674724101144577593682471832822314611266815040617437278175850514794397916817788449027455/499300928557199164242030975800660350359018448980879251695598680500384659575681902525786919086455597564492294350445307552668374725120098363287,28934873175599670896359169913333042902262061294774651292697617988023651584637548947078824946897565685118155309635011583377543756374700500823/162484713279943965693217235890603872484262899071804458454027025279565512387697038237717546682802868683607788374159465773099479122949826126865,-172638818634702971283314353454392237674563499862303404773473603053502588509432330423600707252044689839935174832730351637682492964682624533524/4234907939976858267164364737662844486843021264301493258955111470464378387915597916573659956211106275123310303759580692924292703314892400782769,388289733864156607763139243923886836343844104602474564703721721184034757239728208814306438159588989032905606435677869716820657002007781941319/3419533381597502843410892881810832309945486363921873115524530009011595848249529934245778696303840031769572365731698339338554670152373173815111,157553362686468193813593084975576546460216690365710672265991666182790240219431397248098031502884909832501017547217731910775579335151209572653/1256772555439748498248431561116529545451832841859567799754320322529520801036138852984639384846392001661196804098635435492702773011087000726923,363823177281774702093585668881713746677665121088813117982317713120884211222012306940344690517690699904469998400033637373418502483721095633116/828039887268521216060873424261317552917656073568757785862285337038150539198937630280681057159981170811669525187224005830579847364428948789971,-24406969960046441820380095337011944163473108408073787754226700345100172733947073241927227118200882710679348442057551516985190517082407314418908/61947409266988367706940583109256946977269564013853663882525258456070275306380299346012380108572662295225042477731339196906129067910703865171921,1731402516194013800316751888800550482919436994969906368509256645691096969887844588026731675362829005967643829752823673628610702378780044998385/5873119440095448820857842133396527510834373107152860919878099226579080460176444612170494735984900972384129163326206816186974096531894734543079,5603434286356295766552571066811071065470162520248126143843608885151657267771340556967555762665643647213910626931288449929705649109819544343680/26551692482950836315677252014988915673507177753771933650160294721707514968447407525556559266044844514067241840693999564042339367788718009497849,447170957285486210346011535205189140018080451410360107238126283307015073923248557754164263794094406455984219142570384144864175662263556133036/1277150146429544152214964055966983847574684861668102370975853966125705759429119246938860433346281462057507019318167237870048732034292195863399,-8175812782623585375758054736079728817351827852591755121823042232626433947121969515330119427973629103259564448308617445889872498123904407653758/43089073736704220082931650345405992201185635782483128544126036029837476591568572985611287215268411660794876234981653983763818032859640935480211,2907571701732101573165175669946086222953210797288959735120957223365825431414539057814832822588873223034946055893397590414638151579141427799289/39734159116040463660067194812117285801548170089066967658195858289621646105757508457376440884041059281018567196872082590968357312388606783143267,-1509948692125213740655037161482772966008621088552343311572699368047929518496293088931796561812138829148230784748166531647606668981525879525325488/7098429957929935535358029798253342714162733953979245353015671395481333042994726090236587661250901769358367197374200226029833931544488035316964139,-157296392303807585528586913997305144821678914675221814023499813114386993166861009916595997514031669867905546536736268332149296885232822359248174/2337967303944368034369893084378245233965562714175095123775989274977882342371438357772173566935866582541106559173329270649617032501967081606193681,-206873174929544211591161069936511121120992011848458083067708255972289986569367430487361612147128793970903365290399242369809589920537910490871644/335887043615910985377780469573984162017193941445639414540090365696258853512437272786602588540373430344640378185175934194447439476235837292968115,-2015064079641143384012973959394761413190163228403104102582155935672117399564489315460426538439870337978104032845591806908073158097609247147889084/2499399215304518112254614970881207317953314405217128226944035950888198940165163038636229087888784911709082265777771803607027237643983323966583231,577557390269460797126383354765380522317345512032415603915127105988417533781077757931835741556628299010344088735016997506888623222947315531819/1904424346106200534026114820321247936331624730792907606819693251401326456379623444619836394496453904737933863288435692229796890684016690264916,11799304475698000686092877388036664113851595369753948700124662956688460343770088783322722852592996976205986671601178015509323670969941560338951/33478718847070222856773030417003751432909310347842263608059273689224382569269799640987316022403764631531986459647056001249623946090905353733974,5737389653774084165505582690422733022799103464461436941016453395440762787948443328509767606580334786624676128354242194673415993100137230886446/17608948054502074545816225129462752751890984715980038856909492677276884697024405877977121179698639632847151748627931305671610667717094296154565,4126897077320392688662040684858253680029005363225847095964053666967275955140593328078875662164183234792341957403924757262396712428577123661/10919926139728516286787059748045662191890315191548726823813570418698923072053411409585810183883154942747202700334880364074733187288445482680,-84324724437126654649266425590302313658761077320243289589326333375414927234562943357737082431054237786217014252798466390625838441307651012052/128785435266056456581370629473187764674744122649896439601662083732866910703114026785662013663771373404045383452117305147650581839920363562149,-5627848212587648360627493780032028433416745843463123976790382822710971571093159711455171594077738252659952431217706575083104677389122505113804/8157216135986461000023542974093573373916660861882648584408071359725913906438401729374671631354886420956905510290604658648590322805831167974407,-435403348753219507975040765701561995585259468920855090449970838995745382318888825582229895332502588340768942607981148132737034836712168780188/685997289949270757051338531357844246466821459690269305909020396960862505476842092926422322035934608603226141059468545381956710120759641008059,-150122408798581372035453931421991918547105397575418283694265302179746965502963302560215945632392498721822736016419908084615577807604068265154841/695214024579606642488435963425505640686663671493194055362692614371760743009212880851103901081278769438090793842487985618055895337147162593650840,-202948986996999280492813386748332198882039381181782308283567229058977476624416269418973516870291622912767504372975876094213211240007881599306885/551954420213820948449570970143928800571720046928326616186181321739563883663630375319546760250738905896000883545056272326930551879216196878383576,-10519673354782278469475850543055303031820600996494931126883062186257485301279991025568788780088200028986358728848509242702667772975180488930075/27061831555414699421133942175452294741578292438662547585548440227616628503280842518338526011010315368999474122390105708930709364473497636878792,-63570512013552584300458212864834239854769610938084135336050941367733378548150646504650533869254346442363082876986175887012639975005733539773835/274295448912353462063424767047906993431227716975042050563570847128334233347706758571167738622186087697319770330017408896118102094305611956077564,-5912683116107929551337947774477126095661735789602461338831946411556815435550069789724482511278908931731153491770254447922539886850111290056309/16700481110609690465398058099767426982741955252119019131642657089680320018074958532162162313133580866481142010118038854971213995538353502065076,9570329248746804236063867847042275635747562167999246571253289473944239338819601420005715551456252313247522762019996816512801128340768435585239/31861699021245568312335036837916542544746478771105144975750899657016272646298057030169611285908000050532332723184898880329480952413651576721804,114549399606794644733858223269588414535526187162866750793910946800605157237182182704202068080473786345480990516011634680284585062025761779408653/208497148073475416144343877993794869195933659337018339547902616222493931698624261739672583129629384039072586660529909447124407742148713915773158,32065165348655189353772858335434275516250768659465349729042652047973650870214891263314872829553630863438131804852500135888038140925580965829185/107026053804157130027157951022989708626508703142283808832227809439966346691149988106314047039275715751282848938358641352716307083589707088774312,9675931984913871885587573315687178381240205966447068215775248992403146835477998510740815125207770587618053199837954819754671123027054406090429/26421817407336042099902391651408258687402833749417401821827753693209757993345122218810583903244729575536363858564334131733833664580967527643986,13165943937418404358433756436302537456983508482974380475339299351326055156114469128365508059239188659822893891632850648891803975529342191707273/29232818692250274663992738101699622344049321856124077006408059621775306128513424137906965364651834958076179058872713070844412847661151281164675,5129004669930302482105546384591590274014934175917106982361171726010579497040105584576574481319208977619304056424536854403385551200637473087949/44704021559592115190491896006044939839895626324505439754356178453809959746369027090641645339495343633131183776897221119202356253683969723916353,-82594456388368359483998315182659759731265038942733060470906841633523740732111411014618090831335097065683427961792255501788301672890113695829/244489221717614602904140442385092471789012345118573511724353082899004332788314246564939169595495833051642753261568406590565169486172203797816,-8758452583644967078266240746108271130535640538356685152701672367802482248842265448925450727548527659410096188114190077991777690010278988266483/32993318393628161849051221382680569207578147359725073876363055606307926865361169575935834676528131466842570259459018451138962390951622897541393,359513016141594482346076507730613837274789144926115552633868517177659975848149252534391766204110347081124072589557622291742945128456684172953/2326416304231355514498047392617791564633670367064862039758812216772377154122876053142451433898944234456072177951600352795318549045157710939257,-4358688565599881730140083967044130358655443650232533120564503262183800330465566349031061104870136553518863133089151112888834389941092195270665/14723167889735304246783077221762656018578299214600549190168697599617922170656849418519203071826007544149219123614179112643940412627183061656163,-6038600666309686178203600887339032397232125260188912730969219570760594213578814168504411276582724970152457083766585430537398282233167446303/25693510748096386603444267324247888598861091571649729546564114615222842636351535095889968994286799796254317586957061875185543709593282693737,3140772158104958285357395768012946081496526430005958364747116858999464922101542115189762974949449478995250598556270680450175750588470841671901/8390568232172214491324910277022361716852931201000213148890613245427998672569112710860475736010430126319934474081152203445058004959437131618221,-1889241847977768564139931958998665652546349039660259676842247734912172240132387831996991961283200785684922777394938381603545698439705634495317/6210578783073319227728544539564270017492913172991213254091087588563008188943007084912852800614706598757887498382980657805955586299870425587818,-199489096130081527769618003536500942773199256283352141771622494318780657379323522800175484078861766724933866259382358406574504646639463282785/654267343118763444785623656189108538897564000231821612769721314048159399647193860322139125538419401706691118662470920483293827135312264936699,67295140813591492931984591702838505084196372725777142366333023115266109407207868176913519526814685627590006423034338650553053864043412743913323/121872113918052066922119520068938381932575382173786374072052091647613129032961846041122966821250860264336491905982186539632010306919074288695410,-114063382772819801616373033587387678060957083876764348684755426231561745748242301777059799517251762668876155892302738305218944198172806067329/118411775828959757458992734742846807074274935339574314819551271449446009035575375114468448359237461379170372048172765572250080450761507167456,-1087432563487413321017009629576826961726567122697474639665320792167814455469029070835238324894286005839766747307859311356546044609482395982849/5636673255968532064687221100984441977513592282728840268457196942351379557356224022030022165954398249379914541657408932183670842319942237593172,-14088923704544046327153444000424098424672227097609946035902482003932402620612578404981641679245570739629127581768251314766666021352461532296057/38493262647254930644529597565895974036866224766110536568604853500776023780272867395957475442151913956587191707644357530205122885377652254090484,-131613678345731701025061135922693157433333724139268914905582514641926303549048576791293977970912407253102515227579938428434344539171961464262705/194529817515280578575563529593155754003335800016779876525995520285453869381498270242112543596817840653201746536541211529567850536546827359368948,-364347377665827420774263150498492342681196641021774059377107411078265531041710564371182353686016048966231541969671080237668355989404821296804050/1374087140217073429962153320380218715261806701036593809955441246266588439519795451188664257439431235809565847498754080051199301055246998492073039,-63376137511660076728879548791118287179482154783819610865719635865944425668877505194719677181626070385240386386957836845506688207719179034854680/49396106479013760619872160861680012595121155495809942514885494495218658169910517504420065577112245760828584940892000761152204805950362273848721,-5828751620835305232797727204270357009550153676180510454561547792551135333032095709412156024132097211177321943884166790870492002201787626640759972/4029124768502246430870903410738518009840517816972986026489837744518631453953369234010680090977789047823674011868727926043429956342659090972824263,-795096765021497715836240910876084123313971527809093388543498226054802535447504129484904827724123877835122698256297050094173477426671769258502660/488665203331399114309628242747368596853407454392953685940549782437539239010526982139139662173242973512745519248380931476790036634391606555534317,-129955903575979384663147876639850856806750324280013618189283041944136710508553629435006497036493602666471095805405824207489199035390607008405320/96258971789799378706620455211789574844972465382147614085560820893777389445253724424826158621963504182464200215582970955089748956578881460408463,-206621563214033415777263297099920618671467031669417884575245975112498567203350177257740680254250810211303793310340832100853719046946664891018240/124784094116346737494843008466854899410448298848218839384307882569136535729159560232446898927977553433355732082367587331596215626729199542475751,-3675898348910094007253589854445373880682552263147426995103683448079637868615886450146307887981825857572239898386318619081500782889827288779005519/3545349828912015744885885987269844146946366866323332642933975670282850486032469860471034809085966954781259794422644215931992532655989221812081174,-716598513623849664843617381127583490753920530683015582501220087078162776993640940986481746413209796159576576071385865461835144920498116338139491/909102786679507886163596984911860516382499479161247561905055172287723751094064444799505962376640244399715933260738907758313447391460735001894626,-1808999162412567913238262676300375562427675174044313415039044087856222256285123922484228535437781199525190499267454153609453846217987991330818253/963417593696416610485504379835575862619684248699765591147058562697478497328853260222156835465485188082396755940978972728159448789510977892006253,-11135957735183260413730068634197480405407904658881605277141061831722061158448071247728842009773727252979276913892637678245211906974802492658180/12343354222117971687497876476136938052361812340660270200553540564375781016054279226628601678362426857409600741654614248892051895654886466468353,-147382638652958278828592330376250319989247713585808699751158894337096343556589023618765024126076089877417833882112814187180641752560401363395284/152735353255649170898115890651787096616207531908779634306279586319895099008217264442511608798301823017179773871937166636069525776931663634070549,-32633469305441280568716281308691299809815833483129308774804836628297611085052311255850049129802912005295123691876817510420867179886088396573469/29274301345931801194247472103016772513042969356967210227219630930389018567786902899114193727646296728168845535504413482136080898495076842310253,-485086578557094202117860241273847673879751435330946775589072303496777405191011124414987932879328723240425322364162193303808458614619669317245/504634109260518134298103206713919550996378086747704137388236108426909075877203878031488764542880457168298950709655063406989813428939364930927,-1550379463273978182437267340527050489311155451020433588382134832815560339495823907043227893288418741316756191459048146304771892158302900951491883/1337834002899491326309704380225886909224965382301124322233593886117174877677157099936804462026683556497056955905136898798305124661948384451402688,4967981467896385637771061860388515279081709229070919350469308249563341978906904851723140856866666837118615716883161291117820754872443117708011/12787565925930333209867389749230463674702985063089356926568617561799409897173318711055634021018013962328770254186076606847324191178738411445400,3654623800788924798551009647926735966490287472608896755124808268502205471592102191092869398585031412663971124096305419210833734385492337929906/6550904909378986321470902044113228071126515381644095656272155096259644539309992481631157714185799865658410788161063461785788778774792840417009,11735631864895290044401565591256458796086800075762510638954907446844770315149302399388758776147293199078930354685189898911696447017276302809298/37623040919338828885224492120368949821666404004276121573240624436296787578199601602109723625758409652981537787240523897072765771568705392631977,-3952715657199677469785996480751667845204556498981949671610826279672161715760009165368045054953853350308557868064511599743034353836667886108685988/3215078369693142403836601762322679894499900320094908347714555062862805956613813617700922529043486039356868849742013270761527089338033600267699141,-3882486669346673001045621897353805257123560647011240235791827275597711641220923541085649943493508478122340086872796152685437855806056203171595546/2471297312797322425907286452168412440770850317364035939506106352706753825066665383023545184383356589580830028648341641360834530491625783105294747,-261986218290157859793857702901629225854491507920212859225509699728883012134011021389150644121240409463654452497307162646402586966289392265143834/125075051813803994691319891436525563090857012840651861964982795065378530615457681509829564299010498232761160723534840731555924005173320863195963,-78410876577628541174296044673660417632065688050640909833944532829309602714213680371984377639267167821848746183201566555217432801456490737647294/38682144300428907872237688048284800293724968865669368566954245884398906444857991205562923854876701680017696521949372302871891225398970537458231,-137451404390340095636978741544788881620038904997522736235353038129603920189925900433287786945991297759457762927706516729215575235289888080735988/64962504017537856489173202245559062656341505053426091383826429237955930135112264483553249183160677049089885879289329496534104561728836182786225,-8318847114260818268882962096511967603814952195519144648764923630437087782083988441940777103514574878375538126492287842223083762878693976592891/3829339702743153288522529419972053696206093742234902021837647712747837701227708673107838491063113253507169614593510065823165545352882459331619,-24927158950495627438397614449760302907051486014205517312594731229762405727793701603857313374264021117183437967877543611871365582638151155658971/11552859869920799705906740971636365400900944526052409226615551265055937602068048303816325479987393673120996585049122602773350891259115982588083,-961083366392441589762351377103786733622027139587829904033612173183419203303222003381454772263440437761712865982571747301035790317439281612688/1706069634964987279899328274109048418470194605354343328987181087770745569296777880730132213823760183629496936046720049113482199047072599706579,-270690979608400884157815477295384542199437247822344026264696594808421986396332539555988507707769312657228257981103859950632806121600784826607/694694437333080235138052283318439620698125738366175375733159148345075861568120376295809115612716883492325319046644773736695377831374398487320,-35965311435038444869257532811826916962739926458504751282005638236539426066104905318351962058265449001726045841513275438192802103400764412669703/15572316945620553688307658500228353867759037143794533510461403803393525578127497419330714900394229116140384524380343761022004221790945465043404,-114490704226513805905190277174538711024197420325939292350020278739063926535696780667015750069570922493508179183019312363095437534622569278627640/49505275562501263522635086713964404766499832300600897790689566259975737711429734544818055514520302485943091102897508967360666344177870172005919,-413864216334247351540980459561634492331170362150444339811492554303400543671389100670711268701912184722800190485528224872277887564803640863006/813737592867482282541981383851034298820904152914163147693213102568212167587038614332633590287358608057496640595191098547451579890948871155771,-1345340617647472763237259573445096222368254314366876395264398590480928203045908782086760709594211808074906372240328693009321060725667160166263615/2224404001417450061990767525642951119855879423200137374886015076202134798543804878438291117385742336656147264165796528586817815367385323535822478,-5945068736687235256086013184958216746626504836344878647220010894514047673047965147949099229548765426768695962074307129706746201150411026551426897/2427684046144627132344415926507088865981749348241193597955723288167420059005819958685313677696363756284488141439396284274149810603862231055573394,-4418501445432130754885287994727980057468423687082627422869883848073030084354456423703435353407827149892623408984654109264549439098067535490062539/1578646777315751480330905211108769175738180597994668536726632221798294510571932988185515935429024838021896876231167431675591494651538400375091710,-4728654103728739590890495504625182306332761692802310256174066310034342908252692098450221234295883803373270608325948735849236642225170764799385241/2396340401036938205247063364658437960907991073723939936217378449241092570704636944641550942620192340631857741754009115177101582488173274164340516,-40424759064779979090115598381612801157518636974882397085815628306272902427899651446756346610011215341182958670021005994671376164434605982889311/17072448870587616841978987214524613091974441348704740734684178501310860431956307834358893269843113637476055113677109007603416621794113575409101,-1029344763978647688412279402617664326385210890033696727047628373039506531997761797395656489170114766832577097462269267148648786736486843142686819/236888262733926949726052207672477396873861070517565992831544953898420231352669384906293437238226869948535198359014236072987081871772943366223509,-2455625553269162509363742961772145477947542852323409355182533934612937297139237929759127553553161458447249180849594092473128704200357724343916329/772756702424911925360492354601071609870622947843001751693846406913164743887455081405551339591980439429656982936022569204332328238081256151566654,-70484275894501097372544113959566993127375695438835746155283479487206498532821760754942524080481746535590865723756600587437007619380916638423906/17561755853409903074649009245612193477902390222275402495570029193558881699962516893701527380683467468340377370169462799010800822169878118258489,-32632174012601341345834291113142357609320379429530336108759406470782181299801480882115711244909183342685996938361571334369947454095656696643961/14269416970059733975224700669041195163036894330346063882142194573521864456234747762513383612739796246514731365137196876693992203789642968463289,-37938002340710521217134767885873412709655313327126503396977750852456325333478062058509968428957876477361155945434397298650013712123964029175285/16198256915437978928852863269582397681136484672676840653026863249714075651304254955574156079428701373277288995153625690349256287044547367924693,-84773078777031499195640379040852513403161067386426049552561384628294436537327778789937298870565644805134425841103510178177621339411368333802251/34459511441329149141438257363770518564787987431705145113870910087540441462682298666353080366738867062216388767790661012691263144251586864832162,-1453600798217381686836631415891553385457835329166324316974160424136211281489616524106257395888815326645420500877476578030023928344854011724409934/601830168862194073185893455144899807351385545727501033865914049899540720275429386661080678599806944793050862506091820397309586195849430225383633,-133513736946964953078832578601152573314043155263973586433364752415308627277226400251040267870703450605514749757032625061165162807910508129879423/50557503885558718810211066386688511987423812710772571038872772688968281813245743637706036521632313749335763096103608112636331926829932145246911,-2690170999225289881626982412260092785634363721735933573753479355626900257595116498701534549987518613922162310798095147165725224789848384079303/1284833658900254772889194844065723206074368933530763752058118862142508441003874437919796383410452294788938263312785204287686373449968156561323,23287516266618018644872153349503806202211105340469630399949553283690469935380840556141980939144250675173255311829308621681862849780962659387685/42295015817421510159414667054109512033718808867170676586820473113822371228422441154521154155149159143350729173686484487629486484707626454297054,30587568742203203250851877119847766339951819556025589794871503359313613524591745246028701773326780914480258388749898174024084691242000103262685/54202237725720954603491395955933131972786997405767990632922797079570628751204558837163271179587950453069054821826482184763576679288183364207124,26412961868362735219598774807192227524910096182078286170154419839126987442884039335704058933147014405857003254061934528534091847971944559510363/47918345584594605436085077029398530515118814550078373727526642682915259508816049068357354113803433759142094297748737727940585608221014794429922,-8226376353473426921760475864333841961452863915772755943634745132942679526079692052212508140247297029316662000701129653759743601009145506022449/2595828739488496289972884672926410661393381333418190311976345539795511711303089715086358207070896528244899644364448047084678991018134237644691,114712223041657501855234264896263975380123983035269614114566826442790345988722688025452047126061641736822819565883107764806752758240619114125496/291518365024289121990583659711457621063627535591788438950481115300204316003139671648507339806403400408826310221644974339019269989356218774521499,109455068926058094665386579557609127918563468597746148070704577721250714111078189124660714482102016561702362454835037531477516614653306056670339/207561721498304125637001327069640742084948312342398641162708607737995593441210621991317101155863864102066234726108334244028184030373694847952282,-5283119562868283255660299043461851079487296456488543248519523085169945814220660887151886950794780237390922623578044176421772678123818081805953/2568298423587134702845670856878145557894987188767941557859012223156323934139144845296716664927836501767850145132119559072831838747177102592798,-7800822353118697282877683805067011859907558417712558803969150413378727150736681093071073883994881520018682300721911621773609995819780037265459/3639332072536688524251946896742940256581480062845391815670462514538501729374983642994334357911801463094880431178644200640643275495852099998969,-337023221448321403408183112777427516997637661638790336641991954275372892856026349391119126367322878594923510122805043605043615810327956990673304/139636200618454892049121748639260692263406381907136204136542941836571696306935422037659524097060945911851487212856918600341581516370263544759247,-45518677852352233202654774991897990407998057992579080010147571208200727834861052729780805574738945641873293997373704720954696203872000706344288/29846695487316337802175558666326510313297197449591689530606831564938175273714347229061575330651815895809564444074905643852692855352961994183253,-13734276224308012410209262969811722351842586008714176441415419014096446570358891448593171098165357041476320248803994169465407661581306632402942/8871709776604947147676858311638534575996402803493573474464407844528602654540375268714971854842291907943499230185823692133445855203261207009707,-4179858218187190810945600387637937073026379020623097408396388698304059707199725622054329886184338191561135940540471876173072583988027046246043/1766721803513841851910978667290433620567919704879668058600538381106332960379143255368441664357508046567648313743848876074757491077737521168730,-8605906638968006384680684000223275537498438219410971970838732674056169645011270538746766956348345122676944598088207977404608639180140839785021/16492449307488214004096339388896493304107329066792035747986630605481452469549386939586387159908924593287041298678032266504573303831764209105606,-21087434106672498018601208794980143122406159291400040517397307164886791754452443419002786401854257059798387600096346861965561919347941198652623/54400936455802208364678205823704083560650262026171717121747385305521041806113207609343948455224892578980554105910907570848274117268740096793696,6863411643839252814526630830809768185639286094149048344779931124692417565698761436694988638295800006145853018079606672955304796367922282247629/22067396344220126614427107694321099729863974102451824694697557680288358952540076748577763119418540377087551639136927969917066501826619039225600,12689983278038613126824602774717300012654153001379695151391665163293790581943762817336340704253552460483154482949798411950015196302425088799827/44734070447104636791685750759472338433403534234499046493532157827880821749296053698916402460754499499481301963794357178912056441131044837090965,-2132621991757172329908514192462660773238793909658302201713643203311521103476587711859355189237389307708112647317387993259716102998519222851472789/464372289720569584714789429674115418910841311661084427222861886982398503065109783302505479261280641516304471065240458288073932419364095222575353,3625813881558078856015529162501319563357936762874258245955813727584092357556388421594801048456947705205659549480186482103229626274608637537739/9869130851740764059192758900594587580769236553889159215332382177457968267365077738229530395138149358629519622450755245243694225680559456060850,-324038362376968693871127407910666057055033512110444710282693535371327529916297362502858340546390874067671450502170318720792382850306760757349/1818091518312732386754143873317001491982395615507963084854469266540469432318996781295393263830574465223411983865101748530496120903053814356533,-50874362981187753017369563041601949084140084661679704849062301224546825547371471177126534582114602123911874558798276003091905705129330189696307/25993523598396596750644489293040877251636435707567195702655213073678705148936214149390389934300053823631410076460504024452192456261925473086350,-245305869242195980532433375383266346437986819198277963711201148826651926022074771231506044873480545250671713771173146011105695368222440121787/89952788093006895941000165122322747814328047546352746094519838663835301139407980831782228220826426015246636749323164508088296028939641417705,-6834317451418865587705572176118136979973463944665951941787597443932353132313345582943217040479135123460912962129767988093104690898319447041785/2654466041566228080417454898131650514568289321207214688151318603164694850492296876681125889010606413792559873654518194434385498937284241988691,-137587388974729956124668736959596423273419844493116773754095017338532638407118123486612050662721695007466489653239945065956233160976302886742126/109077838690589961788519153009302186393590123116147580025015186706224160736657920230308480754342949370171919155571173381316388114450772691438639,-13782589216134654908099210345585410328005275500654779203910335293516141538716150058262766931683792338708300592280939305595305636788138110193563/13637692825768925046409924353609620314034460834763875290420167917853574128314848178840901073512106619475998684312990425775171116258901412738967,-263741605480956016581834675340189666180016257588448840132290099773375644617478659654624399632774795136193546089406431909448988054528791326494820/262831181202952128632441937200145810194724931740040052619833946014179296426255597017262444249988450204644507566922623349355378355051697305423141,-17795553719753724383739601564972059830903120101553797535662450350883931072181287982270391144557692355523511900154656231115784811980834308192810/18305634187741138616874142178830350560330807317682700005707430836824401697049797628104427512097493339275375136033784877281538671831389704816709,-1858184767941513454045858116731072566598394061568476214511113454453565006651111039773995920861496404924000460941216620197701025656971434305420/1140717180311719181386760335925735220486488503833674865682462981225137492133195483918446721830079560065563514161429445217151643579241233588657,-487568418003357169947373232511522887039436482841351285484464971925589299361963423824371158147199017172532259113210266838225365735230139684581636/273077850014099585662988531716485541168943249351012429831137102531451827498728929609838720350769053541193974519900899841254809465195742053202119,-6149813692238011270605092976769006254458335043284736685085078353850196911183938036662017143524895110959714517560888204353876076583120192257180/6551324055504242383413607697974047553400835223855536415616868142268203864241069611606219679179533504624937671906849592518975749522277699716591,-3458194838945385164805958248597919825842726078546154655096724284672056924707389038348990414834495568028876740566528019677580385717815962266975/3602096133505325599757108604720598653965625746159133709904673870123669981730161846576170122132642440406805399993820575548808559428192498213731,-26996043939524538074172448144868813560345801105122748678922560429338255497045811039755430472614021210824215928294365302541520904000356734681531/34100551882972292663806268702191589764803365923368752407980756027969056147095177421875799161758983636622483768450121868283017011818870070557538,-72373059205342463820693609324234974096332025201805485377292785516119661019369592346713029548594239373583744250020701684888369118684340153068995/74212096421148589689750396091964631747052130452768760668265641107274011353658608715661134109099685150907929550791618201990605523071301067793378,-6106043516128253188706769784198600951253226952447179880751123053802687831842765689341011476732056908026668430741498040461010218446686881234383/7746254742919506362600847777752352997996174178638124275923541859921727959676913137410527896039215957848096010818638997795664983519868267552110,-14678342663797393955776897138536288924793272268713005205879771777297357614750919944978506879443251969654534134288479684296472437794313032277486/18304594556468900655881500476054775241956422112468133751010858414990749505107286719451334395539818964977256804214834591926322581961451132932639,-16582928339294543991480848873113462574453244428819104812069594131191558837577598415509349979127009940370840192595269086560285437217157897016340/23356260232643387583814747141912597114598116705616651938775326484568628040926249878646593344232843098063475364761792151103581287974635355152273,-10796393216976411900449769954921902224870359470119726160871116396319281972092619766395917799331606594163571372016691850069273667502735482761/3787200887532120560140352748699504805989138546321220546906508610893158902914118115539008968755339592056746019737034422653676100020753865607,-3763124043695185761475316228967292926238679178899576290908928751611109734501233785524711560452661138825897259346853359905824199963794712651722/2407362916571330418252461838258675555899202372378979606040899782398492925530017236727667957018663189615504866827546450981340315591407140189509,-162902490031706932517559578496489900703802647620484664231716328692431023531098658465056667780587113512462536853653664549880727290970046360237133/135000040482540413335654453698108404028238095967053578689228318055114818272882895018805067712994188273688173720388843604665133113387014413527402,-45627285655338153886588600171632478164371089439405756406782760681163711244679823784353627597244416919471436853033616881712634387966903063371087/49671630982215244142591016982456269616123301752358770768293581169071354639277387467734365022451854884905822990842656489258136028826494484290973,-3929987436139884031604032693021908455899043534100610114585158490034526296982972564455158240565535903560638328524393263125368822901553471806727/10421592638415417197727410387231372110695500978185955056259685859489557714157305286266160873558777412351327727842623958238694805141939878149824,-4805083510860574366189732318013694928541341022209973580699533354046542044825676078669853772122331880679946552450377483394870069025199179166525/9073275115023871103131996180831747910710628935931938096926408502519056825843620366788030206800826450236047325558771276369968589585419298207264,-43168072957359708949897263528933557822377260114489905250528653101005108185600841825566529815144916241166260677573638572812152499453873494726389/84299232837887317179909835285527778278729009126978732743998359481183452088626500108343001390495381758104080623720024683321793789353744609839008,-295334886143721174814181633584220050530621397045453182055973581306613001617302631820728881998866982750020445157756651370139558522404476020637/428495362601720519473020212279361667283906272722299230207916040889968610140232280724437077325129384781230320953265363486640571338293138208119,-213062814151759372389383753779234888596955042277047070159493839485781548641481985978338367377928824451683909630848310413051661103662890705008/448434396377415172026699106695083263984268541098925179660812426008695838071621388531798238523097354464780528274691254586327673743725996417533,-9233089383149244413459180077448127954905709817079088349149857782662409604692573824945724470652494035534345953788237307053885497312467617557803/16110963373420360633633927101759870845942103161189798027014634079979434881842820347104669949750648130545024947784378135953937693365832951523455,681841217005048618119174158456430219899587279438384033230334469604514557368861287952539656096970770188145316836222949374282473961411201216769/583315343463468346251439154032738781729366076626300772913000718722269991478593486803995928449738619703334122348109553159173868378372514559437,-3298695517492007108929521490599308271500163419824612613699262223590151665505994255158663146370440485392888712900275596634682810207105566132316/2265909639673245592876458300611473847896077403574213121743718404197968178992692629259199417808218274887690407589786577542964834536034776056771,-452368220233062412218120446164758331670862767346487219364854866991617311835358347131997528404326437743779940526033766293099605879450665730569100/234299403894804370937121726037468340670176748362784944859471922454518889725132222228224624300314626284727319345260249532076978337983424591601207,-10273506317701258944221185900276760104758032913820152267319629186218346599877963361921680359757636405631938527622846059077208559317681783860980/6141302417993900719328078688587085628012916920277738238270103187471299772906950412311974114693901375324103413512487645588808863451911364646929,-1003582744938231256291093587201736874552073657630078722593355969284243460851930173398883404472926238174861537580426261139007075806124346617916/678826292583311418142189979476598239755187775636775631882496639524029992029771236923231137440946891421226557622186000089187341230118332649251,-2951006586746121967084917151521971962051643274704033006479805137407152838918825151554323514149446707436228397065912384183331899745724510123112/1523528911728935245133214908309420272948550249529134041637142599122384770600910870116404389962330087779622176713782272286716946954058583030463,-73956206389000629184774023114602242353643792310820983641984212101360245149525016653751028237311307899165154600310717429159136930169933587897084/36699682880770892078183506379087099297701089164901896385297331998832523091037966649991453151634760766357331304564016618494830409728452836789523,-9286465469350080763871447302866806505772498497822495207507753310836224486391545365183624161841931522374747122662814165403647626506510440913964/5818519086256404971552509452589712097133776544596017389206717266513772812951952632148299371020756776861821739133378476529738673569792588799103,-422156049810627722322269142405354901180982468841360600465430198030943800334478629701486898605788364977463107197049961109992422373860483024771840/173811246554619480568960412225937393336714227535441454109079484262644271613362929942310611289938866814001190849955901889605320345826323957985753,197013130717339639667752474128214072410742145043906645113413420775831547266652708839451341090343211784917762908652298043506662216649057731253/257980830442766799445949656988598670805503033448142209162025143487895494293963985133054839396199899981266729870551443181219078475198045841091,-1724467322686613304995938534081272684934580132655496706581403981035141123804015296128677088440729618227289271881023602851026822516970937444/1517517158769736671322417692782097181522806625914242314361718098105024192170753365405820840783205708202929630802472775526407327753882019457,-43338839220771390607773338011121396749700488855669478070154723142993695038854132987748790107958790799481607263766859542833840512529017305375756/15542689946665469694270942598400151224489523491172431710907540958727019330823092035348995117657927285873163601502207512807813909752089424643857,-31407867721618421739207801398480540524052064342291250195143044412288832934545102086495235168619580912557811793595047303910394176462017905499533/13409852101483985355995977549465285170422983542757782732325690760953578636731987161690117626817301492582234040783108563326146930112425541017557,-670899695403340265499109986100116246132728198014222434878406185462865010326529602021806308224424356004606054222385756673517818566137628141020683/148643359393728195770621936695272683621381776280768655481162875476816949445281617283081628146364502531914396905684513867557458289463566245598960,1008700074223696022876658769351414945194575263322924532626119650426001685355436987739122033513399726301794544764194979044968446670215666020719/788709172439582657089542020076635498306359992636611154054714649734303451077194352545128680310580686351673222596896590675945607909602330594816,111268466164473735752767569447687609336054539961389267570046247511224966246959695494516843088680516160599525629296559392392567573182785515211/106645830425762687334186295805783558030267829027497070660696941232493654426103304129555330155811375112526411583848754456553188401362015538524,-600267986019280531432831791559817110815084559078379212840450565179727957478454113753543417385295794874664524750426978589628580302290688775/312959273510290437417297320812294200433758936201287625039132804078823663091387484358809613165857810774216172053190063532999206426842699644,-5095991728375732298713351418100436756539205242544572279565512625139590538780805622080298742847056647742164850564647484392293697906849501342/887494625312507896950859780629697215715685147217133987557584575480163031855024024201323479004900104100703922907750303618626060033618036199,-6078873247734223596243525826599983653479049678511760100148127371910097021971315957099654247640802161056769053456028551727065551132892245443974/158056928673773192509197213548836509673540762028057612050243192297346025336867412862358100347931325627163355519818182965424549275800370549773,-77409342257084319100112451594154366035540901835164208042554071455341319274636249867062085704853687130663073767746218211047161567030839431605/1211327725511357708517950818378632058343384997754112120026227630528350147916985586632023370083178987341914450054046238558425014552252666379,-12064866992241753747540968363773848535627053718495023056675352394168603692730058384699634558916630539220969244278040146030636863001907293733936/485431840226194504194066686096477208977052470024157058861611155879972474140636625309702150830413814997837415099489621354881808846029223045625,-2581086657258805838963261019760767083518509240284580403809643766648455689776165382431859404809293218698280834070424931394977908396516424958208/153559459708438408559909735280064172257387745253866940318220123754826413108619308788181536303588198192442472652250377666043992287730619877395,-64867287558345488898217520208553336109968501739514796438829408354283042701876091693303649816145302246388466185680237405571608300251860334688/5897078874513190680939534079936730904383705455155220391960844324009732616559591460977686822196549473839777698890912491070695466592864242507,-5831876694880024675212422066469115386782351272685196340566000215718629341810058974351464814995375074239489042282815501655561211415111615405024/32686814460056303245302700092399084748775186032131962635917501066219670581851290233743597008296080023509261708016846106624132614218636922873,-21094053012264561356262970584252702301380101824508565216620550763918994541431115935940286585958475425742888127810016432123907381148996187471987/950694514140726441311744679973725996485058023323551271092847665041342866737153183192085643709503868886980471737684169854460981680680770652140,-16054088528166371706437957886361275343307864946857068550148334672842246029871287544867206169328697413170302485759489498230274314962394566722006/158914382970865736966386331653571215287805936278372256084350005191237126225461650488888702380151348080167524323821558694944192841711653060535,-10552092950347842576949489584452122162870744601465721188240340071475754651739588990228586822360667276055687627255228414863194638865821557326020/1518696295701246554902713294453277934508580039807273248210360330880853655012004095125232217374751356210541148077009766779789182681852042031167,1368080247851249989682134835301566954291381294315035198547777698146300187384177551154773374332738671847316681445631705509269535451433317771320/396677306587484985526664948144251481151846456548804831608221268911714981282810187994478673076884978928256828128879848482134899923501483113459,-103088034036170040919435099275678538165074621097305392040341979778472690577384125455713111496728984277667409705544955808058401066414742044160/35639135547552632622797123311994106978517075802319163327595807195581028572818600287888939171945042684657399737158706497150043272363378890701,-2166589183714913792349581535523514259840113709893609229117260459478157558408423907524697977879048752152080258868318612928766480699881324066080/1030273042674842022429761099315080816804260212256749384442697976405943027100065421328696224495516142841635411725056769423702880515130698152201,-771678911478528231619369573282621795274646427439405821485227407424937663989701973102368420072796309098137123711912719614868176974566235945425/327862544776643080167540018389049138202896702656045886183752470720012892990705091475043278710399265420526040825600438910747279093164842500546,-349593687043735562745413189743281575741899906807440062290246811771548979666763743350599315829927002047120686952405497723899052700279253269068/152893032096271347367788952412366061058684557791857348783160758274322947142381346792422731122895042833347819446884224454442123388414800241957,-24062904465149452346836376047204355811441483297190329542073758993143240958787801555433097526303327865355198089622713141076812682090587312429202/14037935696681900860619834606561905377740293791266801630775185637125550370052592157230182143342608598617637554069012553432598905816764844903273,-54362032515509533225619846832179640546432969481188899461949070062226865271992830219329496604073515996673831354793080899645094695874453760778/20336045139529717378081915684483444171091195083279988580825130519938028439978439017678174282152905369439537600037396596194270255199859090325,-125036775018284309183869724320989779577492357738688640340176428752170550232787380442238807290477839724786307119465742158096044755920629706192/2962935811441440619891401215146154110413813352851032193803569816451847521763514301394520621558659082492195776107824239614681526992987332899,132045725676232774339081490246367723402458171550747959990281997873375011934778754148867101215853309810012105447216049739761245998476456912285/33635122923092211391085538826281178446700195524212079098931730532353988150597210219027292253200589735127048458981354572019722257625371502532,762986000956966322509239234623246443019587699467402177813092443690166733027171589557251573955456263023582637393085302728990730556115343955053/523229083315829693986104238782555570940326388061130749449782767511003611751520808876051741588558454625660114327757874618251295112233088664304,7160193045547308876861344322227719791366421392041967297531025511275218966291261792991092957505020124080063366576680992526210082343897743855833/4552094779184476842489223170267672317670508628241094722015733332082950644015963125058225249736828479474831277481753999125303440765964361676079,5660590407205511023533986047543926763794947268105734271320234266610100259760663222961145862588699395277209903110806002831934493672178168290611/3116356447428655582679625832747508587384474212773551442263988498258723185981936277013919414243638357971845781329931694525301044474943100592096,-7512268130539279310400920123681524747431486849741428068429233491493866983435605566791336919234030255967281066878152397144560534322289690679133/15146162999397043975746809278881041404588492242371012192043664781774711130894839269457519201626942601094890434501820073151856758928987702077712,-86622726655444118857378038242995307545191666326868586926014794731602684401159345236026304436148816935609751042477386741000463865508028904306838/51355179674368847784776508756045849907026942959443691189582134151410712480164299160595906505951809460638646434829709839007427352954193908812027,-83869727865684165293832578015447880822055499467603241066864938199097847107408484495580473597498357992993581010042471297765279889085872156957221/70269807034932549482795183521029580832805000153947726765187094639918931017778295683737754203851313195238175425436420461796784623075780036727712,-184780017709002315013649770472410574012632055993243737580878929631329384102039304425094278687127017231590725224233554011437947863317497076135847/110213597587326193529636137477537581782434977513944606246579790153410856136572574266423666075237780472038342949035211830813191545620905074664728,4150564745433110162281858952317362722151038497980229068902401250154445069770933796030787191349195073885553588635978873179930365248195419411/42076110250123310145213874601119358853267501114984383874344271639039765731275608413463822147554683047153554869932680181308254528283099287049,-394163979822095241466841924550248881456338068434484707663097659035884964837594080931444326133188759066143225938776599735691943469002817803808/2163660671806953483760727351104805856146894916856567014013365300448141304777064815509103541636489957277693991657183568843309720667267121428741,50026863094988170597315708318047282411935278359324868084743312108008526761317611488145213261020377407262017505545937195516547218123301137832577/16651012621938254587080962918173703316157571920367120469652360021659569253000261244858863939875653158935575590053886205198694070762191424778624,1274670092262930483073738849324603783897333930690010111014490643287971188177515444994848401973235722271023471318853139186790791709769347896803/588099706912589275260433359172122056924420748386388359179894059213699202848431111814439561751511648701417636566100145985538062699618691461376,-563771193328545112880858878188596497655228756174336944389839476503777330405504365978270287276141736113624399795412293570367431262881643463172449/51781175569343197421252824764980828817344237878914629577328585311319575629492582623709844171172556986371477124326317915720551418531720755697240,-14608285529261032018538964196868705528632792236341531386465419924013378399769411418704874693651808809459208719243481825606165500188012256299844/385581190595064100606293596208604905627270425581012118487490232541536001431661242805175309085578385380939308512199652523184686826610909736399,5916524774888439317696589065692993553115010015067293218135963263293279236085037848278584538659382747596811992968850739193903230454814140093456/2914303882679868419242236722718907232919335393394188131947008831938776882271757217031325940656103750106469546841725115712309173685967006823603,77828962555117344108229216828848618425347082989860619854921135251495785967682926486126664539688349851598185411510959677211723901188194537172401/16352223220067447276081329960645915820309048462197069987922698840548969955910048372887561877935916418269717615378697409493389551444526329942208,-11727738946673841077782431256059317881641055493517918813301894149985151095122460024598785537418927710505555139915457962148635701871244977366/93988717069609160089977442248250805182402764665245570312695634246327345222572954865441440837988089433718048572596896755632948232715756383399,-50271226052817848296550478048132757192213325962764313750714321990642141140718185052111876131088256223216966141801101024879069733772964304931/35753556443092499991352607727900772092946597531974936043389409802748349210147684329640590685013217939104937382480479094185828148769207512786,-11433073454360609214938502982569518796837890461048376572992298305070837764155152312829327819456369231634821142049749979379323130230573149218/93937644431575545647113811340896406345756440374346216399769919619422947225472343485474729280819934686312991218743463521315983751024321931765,-12009262957705224337875546780441017189879441237776603005552290001267743906623441884530850374346904926680304288432163363295276755502168662858/5198506291520396992059539954419446261531176223864830277293947305600771896823914044282463689788598914385176320875705647863462388846167850555,-1488148209010569647318121642909910468393322036751023240913467344637849390710875738734596641855388154340315474894803320075533603279534047686517/1262002724744332938497224624543478042670563603232293296484819215562979809311915801380649634054054682121598041084200490475443145992561665022562,1326084309690797159098260939623566053626979970581191824970065962381212908963676570886093152568977871644050220973420675350455408140174366333408/863710298510529042406340324825919903484082015977300192264310580815954800817860176895176917783412816484572236418222440280595597408123172186323,598535155045475764082551926788998279464808647145639032675045160731838570665731806505779131156956522019789410395242058137357011875503671164209/210726928164871734575170153900583915833965209113410940757431549673098767924131988016553173467137914750544093103637359369849366160164490619152,941856488646406486816512012730118081015142792510029393791375662226336436380409494336231902652989625809763571584820025140378332782777673469025/189906653277104968198553608275098154837758533398953235669140132120531040516975059117152304318135943831317396372890051610166624802033280231029,-499156802141424771950910269173076324124611551332659695549560139970801675075550137764022194564178699023649458159762210052879578059869742786096/225704818916195762007674345279257476219675532311511824484796821793234238844325407971110860980354591374960636547101025007539203530019592096109,-72597858138652332723733907364410667466240341223627311090969189197859230166516601935413818546125674546503649846429540629323224468613136463079894/21033786404997494205318500940315775565742199431625291715264632540857288522811464552177449592425566992895002838839644624207923040566811068987975,38433392205527872910414698812105817904708196838389607999876312698765734955815017682418948889916630077344026258987700177723527733118112036059/52051273666750255377125601058572237775192503165655702532876152665121938073014148711384216955813508168521931799365809977888201669861803590968,21159061747750319419693470333086135708014135534965165316849689665495345201540664350365813311205526685930099977255689953389908188543604012761/29841584144876463423867034408474913613477764939331130687629393837672341300746594806333777259891028129068000839319318353255703277262385773476,-3734424104650097535776102932950483401872666766357192563860114954073689635435699846114120977181883892228540091417580455132496694531656981021346/737510672099579671572515244764608535999470528337060026550649546046964270542180883514335994020584209207195867206334799246110266652390419591071,-37638000041760566316778974835083571614924594797813191877806998991675541990963698432283928206115327577136968119799271726343070111352659208357/134078894999223184755276874227799102584292863534563106199259294534815775574576422655991461425723853735743465847366260988107801826895139865451,-233000134636253061397303354596989869149193289053863656105686722037843895771149342502740351918473075559232221107273698922738327274957560800012/8853695310906317110292414879248615984065688392397094528701168778088296559555675773320881902769792658130166809889718863942843765357219628395,-7989513163154884422229902261412661119386598972655536005607516598519053767307372547109244314287305622134327165603247551547249938442702402570674/438270768413188118587551878050810070032113579900923803959397310871446080694636513337983867998145988647438488903610740410156987382977842067315,-33749178936481902317740542396772594194368070285673490277152472957192497527993096808461701306070959994932738039032438289979520558380832378924/668696740332193134773470949755481965553457210033301086291717266197326696236076345283193717003672687354506186442201503936765662039463948327,-711600654183293922083416960836533369021916394756246189563372750297573317081394778754640619580379364452615212947304541621641526669679623889298/16068556820204490086748094609623042976713408875432002083303664751305182077426909544663955445461605829510889427013408536912449201530160218691,-185642361160857738664843395776591590220520224651412868215138895179119877568625028993991563684844888604734618575566005117713234942637254581956/39738061990072736916647007190197498659436926288883012225427731291511460366023338054920492266228517728461812662955484530675650432036928519365,-234869993098580718393422977721161022923710369339159186721492505894857365252955140075164108606845131485511119826319684354295194261181076622316/10332945072102827903887475475096074673295631603635189932776668875745075385246621317904026156414990116475770443689857582662100565065118875965,-85641241524624881070411351887446698131746211833814946384704224040536043696381468890801363452266952741769124495853808557648412406249104084362245/21228524810703491789531762007779670846516928032155325384995261220123187836747693071957364807557842853065601148988582143765632377303723958189742,-21185096647095576971219241262029547139105032647177972647537507389929886597042442979371282728394820814757830774753745496572924826942313440890785/15836069533997721377847690951664153500598828130491308299319735090426277516553846314541988900872753944574881866434670175599110710131228479976169,-768422178311160403511638794499613969414180511439220201205402932805312574847499911077902088645842965484613840775029899125895182247793270327006/317607593185518773947845274651700627812163682347127673330380981336828729137452026376410199682990891461079659957973083915435283179833354078525,-14264019047303203714881815218269681185677804124480442897125119703056368515058600727128674930204681497534242879609438249764630029809128715799/8051198134321079099974300179507964099446830104010948807615004833478222387152467552508316950329536786425734686755138720116667250796868486823,-2552585615507593413031912828798583204523065921443178429668224376874276845189581427812114936132799318949014090402192859377384703724175655072593/1097638851360386387320310662618216086991863389635574297870867385250120309579927620380667620508743385983109774588127288378871013916227865769019,-116129872246754707862867682546079907968084008132900865046530577013730355699898488617492541958945645589895585581598280585009791278040338144201/28269928695672478847043862183024139273242212583459783382890709177649833685878154313653935833091964023631892679494244272828157018169990985209,-8375098903146193132267227763428700316626764044943748729796066280731429115309506707521581214018027614082722490006755554975946520356765727069293/11809606923585102006108555700193484696681833288665075812058049287068270053390144861319951972387464292017128784435249502220769555719164059801727,-892983371327109277787452765087738996187819719133767038756425002973102011420287914442441251709444995575677004870536860063316629973006573454925/1267199718596307935215117445433001733958256208158658008632797311259409719105570050893878094472104095639644463058663289361169896632249039807711,-5925182235985303172547220914593776483334470263876539445087016723468321385024820590334871694868105063191740965310356506803611702096491484132941/8442699539247878500947465908679714189573088696489974345540624491676526978636763101332464981962442060272565617873817301426507768115913589602592,-6085450755139368557659121577289009162096815126936806069127913482797454627147653075188006894087519054042361450756477456991384457244484991882813/7345090989015056000477470035584447921466113582299577760697027650551817981221794542686582591674745367933586429985800819606228645966952412902496,-149345091827338107178327029353995938065164226258939216552325377470359944020043592488994787163444075827441656771098623972583091140980890828497/13149344154299222315161811537561607059700295843918223680343701550471991113565413787476462059703799133611361418318858379458136209571443150276,-492797373757685870124632071274318037849897492414135873397719635815276833499154441664929652683118805243562151883989649416425259372766089169549/124361222108020482774963838991065804941353667433136449658791145352129071353230430951545549761290266774603230500336580422711787873673002369857,-56001783607072434245060983923115953612576341906342870146761142020979809871824451893187615328741996637464589200018811302761406115537172643523473/10960314506725305533485166073915615569953195923397293742674101928088158578586559230160211803750935027839283020255031715264617731019797250438745,-12183560924793749830141244727503324361913357998209047164065644869799145348787671395151858637016947607024707488224688475734676188006897333644372/1012247467158620035441415418353771806647448294730802016386732993749602474360443888364205506353226101042546355697505350493975065544755132129389,-14753300649070896598354683406062085132297196021987866479763931491288918414594912891765609826547781962148375126447844492579591094850724877412594/5069579902571923735512588368596540834587309791965691646571011482254508469001491872623636735954934944893988693841263483605443443898780668071303,-110112414961760130331713014208595886924469597575059659548688341975662273940420079146166765599773908877134532379349261042903412470503689696839979/161974307204223351196228902021759950807186716067376789411979176234054898442693355047671393630794980132096307614298803172183035618431194276486272,-26155734323305631228954286015391271628784455645845607019511927181595444786820474718264406599480535922049680898450395801800512605256201364023937/36941603665136113910643841935934658603665012688617019278271853135277278149447570232728294962396271977713085970929266430184195414150774889888811,-1284311395336822359296580326285458043148497535576021998019630214287736532992611337432501572070423010353999896888309006623996348988340625201519/652098969721742260715740579604058820922290864333186367344934171864816440715365502882591982982689395629325252710533957775485604967086303964781,-81946430024685766179437498923470554919752898827263933543851469746317479256818160209824277000569243888988733015044067659462821805771112046943/81011528193583854369176950802649823749136850709654748379508184610042259046557803644971638288852972807759827835411767452915354026963826488674,-317455021566246490943600699581424725537662418971428254856165865610612491964889128499215551838226436891272106598179397930764527655993635000579/213510414390886908705915974464612034900123935439792475162370536832736497521740305759415945336791096702580098471319977395144271409142965724288,3716141228889137485586513407106524463238070220405958082111812560648932949133485920695654900059386703003316429114182649017024182460432460831/2867316695415662938852395583563293951478614675675409046568365319442947410034922190840360602781162554041669588196700716982494368738985408284,-267530478246663480148333994220897759711631470513936051747216469128309058054707906176627959223859599035946425155265628898467706367324435026258/99644340945338954078522855563944670016200284922927886886073222058699983325284315456494104468000747588662256135965241773346804536610921467513,-4127643789966141853754873888803621971952788361457600576233515067978508695493847706575256704459922665409011252745782464366739495808006245622950/1862588446125032641902154449785948948980366200191817112096766624658744083474644804982676241102864387716701131344221131138020620526019021389859,-11945759643573539729769758898832879422317931310019374784929183227642661443648448128198180444327408014307729592055057588956876164335281825221431/9960453366824978655896826451811156860207781967168506187174346203809606108187426851258634943138311362186044837281686807928535354261529607113028,-5572002428718210946612852170187831147028567589891180996743055911617559531843496992526827338472181840543796643492127479646185567760877645907763/5093413317767877840520742774270610802038263135903083509962223835828816038321508417550351119228826040056665501939379983799067022998619953146494,-1330452529681751129400130671727969661857564804127635998092116240164496452781316115792861089760079546221164673097187655765061671294903826279171/1226427176758357502185174475312276860211873560324778355732153708024042796232309415389205662596449156486977070231180432131413089040514176490630,-453612040270171996192244366609018027939473515532171813077849763350570111746612105924697498563921299021332988167753166342467143602487947095883/386775604914077087206366900116283943904169064252303896479806638710922989385290771724135168362643371719785654998859277733136226683949871406842,455760488728427866813764184654769654636002787421175566320425855434036423466918799501021824033654359858769995858512842996856631652015479809498/1646087261766914994112053129375701055307114255537104774077568678518631514570528724476238696576134515502213982497042646384853505790272244718927,-5408830884510531146197675844067355797446979341789568017507221971918872018642325907591426362367857564274657935981565310896325455653161587911878/1291641612095033428014694954358495481941403613001443379947893620009435172887213356889026829006072230808452615133817396208861826554516751303367,-583080913522523228113226836654313419695975731555910331254338616293664133723779967434305131101572198947065469895522081932016755153447246033753138/204548269685288050892614179526567758857838919432556091853955313232377680974818234787457141102563672018540848291550558804208825464318145152580751,-2416602081346914661636583458809145351761961475951975757658170120377613715443629769095076420275673592728823843009851904214497359072123134649286/559361205405473499109451988084499870415934133530523121972059822798530808156734932840911982168772810546623407462680107018292833725867859277003,-2251805871270334764522340270599260267160711475320871883281080030449238823913148793915637580010445498340287915552397607967627015004647600081704/719010498091351346175251096300639616379749090502215295013398186501139916391629206696317407593723786471160824435751496518252821580932315317671,-291848053153975150546924240792755522349074566557473115108950512848943125714131527777052423122238443934029715123356614707877890872392124877216/4133840663057819500860875410444931322877488181149665732410847145754675462862544168505989206049028771894172201443850221450753304085116072545,54947231015201968847477834447994857528256405734216294125120639992752471215474239678344156183629580017060878108403124437187587440180429836930/75603555735677041498359932405163424033735605053271926430012540313577702899719403308318437592896609983904575656310382444028858236958579713001,-7904590702469324882337087479592399029581702124447072974528342462082281575977018514674540012872443028058462917955202888914805764746076878784662/866616801403437083600955888057059229722410978542926100610502228869494972003970047100666579733671350207079324590407427344788737365523211041729,12699474185129008092491022755188676584350898756727733687923884497105296743714020408298594898490294963646755509221105682458721024906131560848/21538825165499090060730127316860232914051335857344992440563215233482755881250954574167803505636987830290162528265799230928833125380317762775,-263277724418123373809507882194167008309109973572045888192287197952289030641380627967353536666642886376986294192386719908368391253360785269476761/65764347387925768676152779938337607533039420139884590563133418546663335636258791727143883503382105661953741290929688714956677019256721675426564,53749413332587066737374038810027302428750409263260727130771836488524507886182035604276811951662793536903833900801447347378440047516120656369/64747527128004377273141941422588502315746075486883846330910627875587403121696845274484364918305938233769568918458523370354633315702923766012,6484585055078924572289951232539115423934148171868777122552159726760457052902107492292829900549404922013506106140738782110463120184606889566/9316047705260071463249805151821010112332530106336567330374502730572852378593659573836347529737742100951222185791811151831462669743942457421,5112642975021167122854219798691306413528276170397043619347855867457977410095958758818785629119496880948163281227739835866525576494546170930/6511784333095150623914098957329803731490041511065471703027614982383208091930218860919830601806250500876615935588712325886568751924344536011,-31086270943083628439254323053372432656696477056938063327957176463249706173356531552162671019878428012278749076118425581123708629882865717866/9355241871120627115987430571297997100725812453011028518873503403205488670807045320000781020183402194642887696529388420599012562952821912379,-66915298910418598189177122283245899298000572686730754451089987004051253491597437353680675691329074315247556838454252268030900627436229746338/21932875549471277414777579974837541909439710531928422538833398332161739076035583781880470890289846655098635193518975122663303425183804354471,-72769195913219006358920671445877345317003375525708604705672695988640556634946903663023061257527784940210642486954224253093654944024653811202622/9693670839632864387918360459239880852302813381093227353719137107080629305077257760553317734943807780950235418979995756379354735625633074392937,-104814828611463762783057925816742265090152633655859026843053634643997674460575093688286229096734357032527711600668571515615347799106932584895442/28982591042698215872332276208397567567248780848672630440654949325605154837844954913006569757997337843088904114738152723331640181054739884469159,1413945004628719057850211051487081623447289057034995912296540467164575146770512840213790499725268764439687382148226499950117560843553646643/1706476031036551752179691097508117808547127744091796934863604902180060491051064110360830760273995437075464883924396784794510239661042754504,3363929593573796868965642423696194309471477411949694222471827010646308320633158965052781767958545555068266960446148339377188286508058231896/4260703708774455880526244117937853890690218583957765574829125779560668508041487895551251502024242467605839934115113239393694204456129287643,-32634285901937977719738135712801939359292559671822800939458559741222775695988198338913700600965154021719371597158641577653219168003130667204/244433852760018287972424768685601715861544045123156683130720765771199126104359160938258972760873807849637521591315023304020056749974819749,-394966039184327907211045691368274544664023830474475126150094671208776549628518894029827025945677136202693370222870682830484572989877442221530/2466033954905447665380463591518463457002455690090563074294324708533761484698247915232797002086051701326193154511204978601900767128336878359,-15427166560471885856574525511579053700500403409734057058780738309263684117124909175004432214386469735603606103745272618361104797792989746916524/883613809145846494089882823507740517916961167173816833361671211122119445565000524315073066253741857691779043809568592585176248305775701376141,-29650682715636351015297787953142323664077564341822648511107186238926554293718128041715797416852329075508762413992765208120754911301766135855707/2488867060968300889100957141552059910824637999029354616433807537145778313744756729745281884238462615638644827500959059742778180567122203809592,-1764522907104045356859594596544473475273102894234638223054302011498560768603265311667274771293349589019356228246685107513758372481420238180768/14841924638441074671643238413349185440115503929655236444176882096838263136926044292759516658410660531222283617814593465892154022045890798207,-541865227883952144656183310620749478846445329690743083402545473816717151275267644597830578840217971853872377873467498222276146080510909458518/22883814529449099627323140963783938398644967956453231430265442123637212402202216534912325039308982983802355439481018150200712956474322509755,-516248670890862934685117834224292980955483711094014934539280039580355546475348794870290524715450342838395613049200777540285135376562438380064/41777743926892339092549883041665725893568614698133432738693908983668040414192694322682188254055165008014366822464368044448401234098123213817,-1352206758938749120563154875177745224669925236536846840143549420379779552679475188226371733350279580079873031129227822276043631914913420199300696/280933913714803636479247111201691158249841613036126918090088416036288087242386945536744850769693911976710702223101262886331949229261989837593521,-10054385245143857954590271721636852819461190353660253915910821463538171661854356542202486933628711831733591694101077177580645921973084560360908417/1307994183687997043811630850690948369044230343155571395811572156606705415998417827269735684375475950760024708699988485245105830365727599275466280,-404906789719931489532085979205163244304708749391502094856740004275999027849345977630571010608565702039826369781331836682475343357506749777477476/24897098087090423224956764180292769484706564623004057304574009312398001737628716454108647495020234158068532968555553999775303111741459757719295,-18891110689419233022110620727808282854190408933382702946299330283743899870589539960226573586234654245503975356902002335534526516213835659372648/1257334182359830307506655898794727263658277115987887520761209713099221628788656019728814653807724559138063381373665799468065708883390255719065,-53949106443244975700486417264945140053307344250671260600988666585769083073070721870529020153868038605560283320070964328827831498209777074827403/22711451942361541131790605428299638982504349928138465227115376149048695973829531785510133154262148714754985588501545851255700762812203440936321,-2380091429119959925780647437862928522356881367355176566404495081627534422810622701205743849157959496364423967020831841325642199461753867532435/1542378086466228799555342896617943276600374816494216264419120363920863440029487155049813551175682397039694300469915201568156284394411076465869,-129314201628813357413536639219818569561690358258180806376489263016263307360679486587771426740318802636664348710334465791811756604870428184837/61335065801521545103302967141739334200720741396631759401908143829413472595343053788654554271721205331339801199939161148031463377926027489451,-767625738335527259784732287055727512482195181692666543302237590304911852936112527676619314189382056431746737871295159514474490658697408418741/22897463255716822989504566262053918455407401111064285139398918017127841602947098894474515915162182108809747808163932706472376728963811636608,-2057800108561230899581330385770163434575349591285111580446587009764834232920909878703552134424417476541802829419056711660112621177376560009081/378426336516704104080636506955844490292744229279172384472877377844886849728573350628440721770578720808374606729368250093864213868016763516992,-49237867132560709503000751544773590746690729066797002166692476962692393297095111487476031844497564074366506923053783281932241618347467862423/18841583716262920137509412273584896829374714558097904614604999101325376585815528029212914596166141971202517707294698107479955757639001113536,-8817191639158470418755875566622703376622415603452644200973541234931488794030300999489507408483648039798777204528526640878988054855652284279/1693877986792301316971791243052530790978230534894284061419760556243601243462711288097540662554679028556523233068775291631013490585502954128,-22243364802772657992783595645522362737701800152414354370601777705002356140188030898958801799114653801006036937243139465874749747157421508037671/2500187621916252107306919691494884558328144513007082896647231328175647261683195511121164887359474910349782477056502584561421692787074014994638,24019361337536808751622425530530592802267450947997586436967636419916475755231865489585951673610025972769537837169155610816888770668945170633/83777619164638147900378832793979137018297881749801897141516752229722307359320051034138343151876329555396397314755197570719652379028509668555,4568810523235181392478836128743032850112330669453565039369446610536123750338362916317279144139561766199819605178716657991527419137483942912029/5079139775303668189182589252365721871162225973796657164220662270185381892232263615434362470078125476135010422124926699475426329591651984162816,249938554736135492967436497431723685793582582657597447277434586887783467547368519111440474468567284933459785605364630216008350129925984250155/124920491000612369105512864108121880364474860007430375393987390212408871388078410426040962810898205062003324822637980978157675870998720126768,455390965650686877499225920014971867290661099909039596527924271782499411806079386059512072400951735455136008530779000922441420265790403385237/30632394567406282458555045450872867433563771606293468812282973103568383497729757197654709603371755633023231144009973358729292656471620022019,529149446991982435674840011021224828521341750275750527888720767864317407829589410299602548175380499382033078967521017995986876303533540874279/3376271335123387600029039401485533873705371612938401350408385190391563601627254349044574984140419585152537584295886797513304047587718490367,1090316273730597610267948996668374832707753863372896707375065861476517392158565759448992211216146207146882401653951234039927073058030678146/8477481751592113338544292242212797459546767973108673336825225146203822714457596603019955561632279371858644566409696054276790428498673614681,152264824761850836262224683690231526349400659638614340050150727734526018441200336596039691561242893473661451219588287287596783782578804065553/46162176453267524403834054308336470409863738881435879531099120733109268811417309743017929545700791854735647482228331686433642371046541725483,213160100095597800760555399956969445035850010438158511131542332103206821710556317144418144219826728417386882371214254582756119244710930070313/45106800167150916643844833142322069221573649611777474234669666253843471099954243345118801042071918183002418063428686634270451930664295782744,500090730894754231400892300028871282593612498869693775351305089538284758042533650678254655096647596813038265482599891830347419000456305060398/69729459889704113818459170863951885124475987367414056349386615323516787833043003976160920475493050468114242155239226105958072732595483866775,158769408305502420124009762240620516646448258256670773357076715706156992325587397655772534339065212843931974900557151647228313422155918862356/50255881921517823602462108873113656507167142853561959346457020290629276385395432163303868139391840645534741866066200810029782592105901263671,-3144410231280218328033818506603195702829250553740286185272532226827456916403254974922942236010090809360786900930101542269306571703436921033/7086847617729476981129466805921303869118622384210683742631173152259061501745387751769095415243516154016910072969336724707591889832098804778,14721170457448995008833737996502663453267361574972798018290288958998183058311308114973359105237875934955856840683143107935798511642740965103839/1112902399746341340652917700945209446991763812683078967686043620804211076392852821585549365731336531160716565619268145850559632608914459836288,3846900568620632464352007152057098758287686832165253609908189141327694131516263287407003474546737977744194712864860028687929515884177695560321/763895068681144220869669740274062536457774696245478285477193294589149135173606978144200680594259129789369665451428360143953630531499742215632,11191223207537372650182988334199990215988171945201972103501853316919871758539163525084498800740287215671851143932298462156158764908408963181335/2089541611493643897560803714769329594627868930290572767876801985103399447728072871508350852964030201994893913055448329108486717230730817356352,27380674087923483023308409407339230094067487369171425721103381839185876957244719003807687572801398324382765097789570207533021291198511868068/4060256473953625086785108152148353229081565512622327766993444441720336021543652948488927940125527614723977424001104413869214851122955758835,1160764617391083644998471551734520171849301636528559740095089757156724546142192623824796334531871808425611917137432334996645661154134740453337/390990929817915006925847151208839710004274115824788070007125561227295064394527361642226155378938218697480692323476926191729920112623649942544,304231228162785313185934825702255872793226978911560936539513420872033286228929049184485803452310109678195257803291857160351461969133104288297/334015996468376419572136550635758838823425430784013108328768257771992935672668168218851722136578222441628187246608840746967383102871669758976,421891723880659277563201994207977295764185798844414066805019195165601106561230387840029819451180933497938570239971077125094300173783595871541/400398825120729663860282186129479613706010904763263839131081108979659429164518706824193160150491682671287170914707107242757110364753146792336,1832382462312002056646153370129478011730745608884639358909719400751028921885475833062664828039843939405739873396311005742075572675675240552359/390966030462041770646585807289198406659685823345715483562531197856660176307736530634891992464672703649146981461609325752431390090187148880056,94287235771261305782060729440026841062312488765130724046252142809655447395799094571845831018397917306802479812986875561988559907427716499654/38370040432202502364611317102353531546007467802134560400017027941331924411269551926328532596714722294470733152516230044809166674135324917365,463341734420021179576860078332764190545903103887369875217410431220922278423267712128226415414573823010113479151352310982923520106777110388295/179416183650742276235813099279019737373132257539692846210611676276724605277953402305671990664119206978710288650627245464603284402891540537014,165853329270568102812503158645886730369511780631648846477313258981108886272110719598914024757323972026503913510607164756659594017721345102097/79049462543328497203362477890143552468370491277018740625904395044524602354069408958491571168014585772573922778274971609617606441816072969990,209819265730738789623848463596759917947830958148881747891427506208262167567915719863501215961348072287692207928688350130508929370215423332091/40269302862529876848355234179703564190988838426631638580252661584604881572396568062396245866311872625715145895640006492732808112162411400828,6228955087167525546402337063207146418988708140582292072591506590189873241310808882989977119975712962169698474852734212351724842504971834803851/2171310460293942679342626650485790073637656765702135770724913343621486636595009060176343685829616966121116815391271430545147131959535820429152,294044137945690990522008876377868423017403572554095282584667278462538891673014684714387726683474290841416705494490840147127315610283154297079/142184979176705908308674085381625767542048775699131151601878359079117392065910555736096282576581401307721742022439548826232862492631143445503,1950528165060715308320689364753798804202614658637525672759276002634243914225299438082033321480530653669471430379611120640757978060359166346131/49774127202114735170262283806358968901848837386569106125113991055565769476414063546908897797953477536653728995453651802834464746535953351648,33106328480424707543861121670853574434426666657726658706345106838585591760207135051448244947671577632502638448470501560003174159976796669392743/1672767863389452668526216290453635056427004761112147927916007826057177553980640464319394177878018227402546985942599266090370150680386052802432,237670229407773699784277793031411927881338820883399280174187948709449474496709273440478062267142605618697165340713207136562949557534956950391/23635511100107166494955548651431953393867755621415080115347201291664009821318318236487648848024841568692360212036439184823299791610749383552,189780249461442387829471617889081061789150194177914272277015959875119054188289489523190987588133344034029203033634943114858463902718196411003/81184279242309620628690790926930669482880706146955503405459678101507038495268497638397809077686825643584933225414683141873888412871697804300,38933894527751887534419236658003939100079830822490432457451972452969321689864380924189388187122870949861502090986346288472167651595632087023/24685547946676583143508174505401867943753936327354041965432291608569569881330910651551008549353417352891352430011474320540278926508071178724,20552683628548173664123739457316029114706438086032659554115924867135415658202071148329507327864961159271132446723191628014033320582896056602/11632186336644924394916682834547531073098745115202788645930408356208423666102850555185700096883986522335327970079439754513497235751578481411,4289417455287807889804564172081913832891258715280525622060489797571084138401930066911768685029271068713944408494195979876387962815506423852589/226321635883764193378314950895775454580059961627653611633549264950771792485503919124111011496822094486267463248999389970472993244918034578202,21017864844524640572666197095922240338610518440798383663694482172476650090404932242941235569666691563497938597624019683591679870609217355957/2685723392439678390790195875887800110205536912978771817299619755944688980502130953634039248665743219842580202205871361611915812013008631451,-126607296821035122472961884173965109600960155323543500161896643965683071273167632527854235977616105247550078407313879043455189845367815777379/82267423839217967158887109676725819241864949131071692350769837786035594689899995801138238629121484872412506386707718260909121347583396797968,-210167932031066621498657231456398667858446285194975259637884093276283847773945596881239743401098129223401853120874502676437041648434041051929/108026088099312281933652333090073350635694900528812076977098198201823628635308384337850617301901218639444828318001899869109516615228438520776,-4712808969957458390600662486266923770532731187566896347786006192321346026404260279029620705478147984438626994461685051221155205023265599040943/1606508893417111346013160183557960176832004658623071878227171022072102168884558085089129096495541630560190653969689506765708236518625150623112,-68439380072884862378060547764312848405412215453730631104314010749055110422330407847139371339416430182505921716608416163880852702529405046330541/29843948960341376450955426354724075590607968752615631289769746943982010944194051240246747492866109662386236820942954702360154792390423050301240,-35208440851039990708073397150779604139089292095915258065155596880945153750215569241529606236521230119330006136445466407581811209647330306838801/17882713051484725274380375221516809856639149620216653649863582915637382513269439510453580130780093625228026632628364696169470260614029761918008,-5939976626359427474576910451127695863105109091839109533605467689071637809181783857786674919299685347361670785982655017796926258376901120194504/561216593099092631572988554992881769964629715771971622836825031036315607149021831944952564349649370283458089727045263401019441638455056953741,-45949343059527342716580235049951184336249586652882862850625774397474198218895042922367547980451074822925727281765172379344307177913084224844/156081454999529880675553281864954474546952358796802071988943762853421795809891393574882003227227259252663804091051134286750994213723690119,-32434809800206741907579863109498721450833752672361168274176673621474707588782992778266125480484743286695932317955555666476435988158820125490181/15336282925460558671999266867604448033240618076287206555215943831090176202448318817378714691370903941374805068616391432827467543178363375382624,-200747776339493446647699627778465914156157292959856758333333890946526111926651443310909119473573413974418685844378697996116867278153747821779/80183088302054804301475709703667966851094845040781572148010923623581518092153451640543867757512083605553265690345977306182540915044459234613,-600063203961241554885768603606474096317501920845329149546184804857220449812996074395366618896200499043702119928227792623960125129539057637826/346432646829249059545403344932933036335132682978860039970834259483144534191505436963050710133653762224055587751577198257813892855347005972073,-1041420400186778126898208046767549188056226021152101103632208566745677195495103817644114457512778753520799628899851346024404830089922087473626/791044204649189080096383196305126861805767716103555782691993467807240074520471797776442868405743201625116179481051331227725972920174795788029,158435599070444518576020527166950321458817039831589650853620782461187602194694393046899884039734528317656270705204326920322183328997460484846/3401257741632475577135301383945161184158412663552420204305850715801341894638643923769353222553318949418317473637286949214697388877546192065,197302578425877479064495191315416097343428257535588280326866892592734590769976512760839247851651099575075413506665811804837532549951831292691/55927884778438800486566143513775262980375533474865242554518291430725274625478686602809638786085336946884300335197226050769209279444580079019,26346438963144744156643355685592587702261058275618864494483086798859583206899592015751161869163397746828912997879290685635043269469605857048/60289247324640443215845880106220303180215548955263738954312289340824468106005162034309238568913235279526132724661017894487025823399744674577,368729415555500728067860231441723231488961383852793215989351245527348451257791782508898875428142244158339085596125413536484043853089518969/20263302662609733474441057448317506774930691228884922462715055436770559960895488223071550878022882121927842077085788151004290877430192115495,-1203408565044553097364095554954680823279241516362036380043285602986145411229569777546768511270723726548958435832963213657802914110951542184387/2031689876365743760335910648342793375326146748968989916715353260737311521001361149928158816937432061025351148129384926629500593367321587702848,-11202959732884844488032563342180694812438495012103018536995240681844895681416130954567905173455876456208908460192878420345559572923830011788497/2073649227853039011278999479589794246057633857546995426089575197599212147447725624093392302746890366090887854863057671982451479603633280687000,-109244769137132500105498383645295160931808623368094180886536973308839826964334290345493634377239971174525480497556274206595793297992023519393691/150706527429356835521286661600707310050754574270302380327316221099889712409201464562212699455734750377460600324638830717090667523545674643489120,-64969505409760048479609513830828055932622187057004866687784170270720332844603472908835528943387710289343976684575077627881342931029552400096117/84478943159070103868526142848929180924034073782004046480539201893126010017952238444592276669550234391322224879618670246576656343509824620854464,-533761177069229404761318383770045857658852992130198827983814798669480919815438433390906309218014932581478246101424918277642180540508743804179/364938707773382864345467605997164124044878713112189153494651686338489095919609401430644156256815584551999624096787043681381594831621613995090,-718415391081766177779878229657893171460324064699242190510620940469840478476818001448696032163570232521741342930399141187673623146043605106853/1633678796128817357490011084435751942815089774725190225363049148056503842786874817047513743467603654682631519704066536976287498449653247098944,-9278539752607244592013716438588611799178456215877730074209314694068972962005665277609542009320117775657946672190352839419192920515353723870769/18835182410694969234397034519522471477314857737432096723030318825682580651581398411119948683162379712706942561811838130020832743171180654086080,3450767243680197111862389906585920506363009737056684994686583886706204870993729465413500296095481039700387139088994244167484045890936488142599/116135116697575307307979704983051845878831327079589008789995027601527092238463765288523397679518798705109908597583530019801871767124117338880,69438826111144691927201701952564016791143070054554587169423624924513410655658846052609600317869541888838536216505738012319362763481477020602/23973522721479323315907206402266369723957223131332312963273319050364985989864450004372441852566375460599270796567151437033232546823682341069,-7794680268654303273924460513014804188507280072288478089570389218326401720748757294024523263253620843595403453541844588139122573700179889970321/702659009311022096845592067824232995433853208681007777239262272235898600261472542090896870519980499511629693694582068540483455988833265232280,25417393821333716028292841176115498371020766513010556016151258187053174113849848242791026474209172078376261152121862602352454972436707232077/21838163497424729677183573711424927348490819169979657386597192913755555340937944080094676177321470509713017366895938690839063434610875634976,-1009389863394663445980733880991378544807494708435574724388149306152375101661077947083769379841974357327310220670651992162889714473654083075291/2829303109647316616395949422939561125510839638531641150895220335646582251906320389898815130624937646973561662167359763941586994825300733297216,-467648839067772702904826322113749330478601593614481721537733651337850482435841350017549705070851489936543978856954347473944976941782750781533/1081647504947038876906956059834547830942548366785082304883314623334255228491876611918255838736738535203868180169832685627384450627061138118072,-67451308804717950537223371252437208499268835708624640976271391310469192490665843968822378491380335543606549176895407897644405932129665940078/194096994751363794723450704420938205892924173036643697860913944290370891195481581632072586572635962240162927602302058142813829342696164228377,-4130644672434371276713050141327493449797313943079639983929139353017225633562245660580013862737916648307237241359473431143213317385579318526/13227563190849079400696514747075401260416470351933786545750363414056950470911160389026178361733234111455242803690224057541114090984886398119,-3807494177422465001777996491517706124571323316292452623990495607594400892516741807799232151651102754789764061957442069576730866333565719371/10885186782549158646806902443721006574483086386265894743746849463098048711899711716122823585476239390102130422479434302982505950848744344659,93299858292061532881589113148672675383324224746096722060346246314616109427220616724291801874923395566851735592481658267646919070274415405936/123931525736245092977802189637468029892770498402377019576336191575155938199632091717419797679100807350481503416845339502656006321679774547765,204022441762075681347032591941338611537180345888813145948826450910175986338170451683712099468180760755103506863908317193117409410252244660648/254509500728336104983604978979193542486291354726242740291468993614074430179305245466468262322139943095822639061614796833528301418856350831149,40819124432160973048150050346829663180843613321413151073338760237909397126767958491459991641836659422981031922275597259349237071797960648262/24527334902190139624756277699542818107204798168731923600050483364202143455359265634621371462833908158633945891656435565076716845861829558717,444426383743308746408866395463831737561887202099056981736324636078195849479844755237326368671599826664443638806176779281193964771119840225314/267401412440832058880668857872778929261840469154591287821029755587173659170999612179820449132582027850252462616334515129082898660354005113961,445868292711889594050759768308777825344067785770318676710403136774344314613382054042138129069008131412098820947471381467750464133867439074367/315964781993470226792548874582632366535255269549224045469553945575634407440129156070833319928807955507933069491861346498773242888212737168696,257697548467238882959047777059341019063083280835750899914385684078384623197120566095879392770425130928786605099528041462060224100551284402571/258963278823292441859153079884855301211799523283411019228280814718808444089372103953232679274787957604179968994669784052297632468752362412760,-36598901324392905897486433708625600555329763847495623508033036308961685293417910540796812725156155574406503292947353253483640573139259797927/154235339414926340104290086243195417254996193922282130621228228529717347712693236790295173804632977309977366013481517942940117166920686675904,4466054560674862921404560063959492050985002789104835293967544091708397443222063011505730409088252428655897460131194974342520594110569296229645/1572097335583815096539207090238899414573466916292035883358834847450908228368005762916017643676710324135257262859796120894832188864230454943104,226832095619316456862896930952141829931625021267854777800083776549059138376569970693349574561985462611364678356771347068267102482456972798802/427814497419674541902664916863350404291715986098198776733005138250667262557524200817172015878340160666151028493520962515551547476375552278431,-693767532940965789898386941729226126442414973464616560341048175713402361179145951693243346862273402658593529328988146340441824434873729057119/3941847852073663530015496550183730362454051509768616760806175316024868939194886000760310534491782485363523140692131398510409241894204040651398,-105067003877009416076486743802721001441913495538543284335198112211543530729573911176009474903591665799611703708643155504546983648322912404739/327143948494804498667718676343070778313941412056460478194515199152000686120931334041959510819081418106613360303822091708558466346102104508910,620143741293515094579904591193271212352983988697031987621620090437230633009461711456600021096640158564760667447059114723242363487411005414873/655260579052080530411434051018376807414053532716566352160974698404810484581299184955188671350558930255562423216175276320931274596786047614888,-1163041071484374085642996868958718590486233107807064976668257206863419323212810900375105477172913722711444483670402885540300483871391016756951/5879933002968179968514830697689124876968775311773859679575038758177569329126216740928747797851365858281193052155500183389327370298681710315480,-14499082997769391792332050629876582284065211898001602783050711791237866377268829218026875709197660850253937769730992143283486961340195494235/59762109142778186121560738454420848548510551439699793317427974880439441024757512073029391531160816495912497305491070978338978697725919080978,-1445666386591746091191481007315098621456570475803549477210259072564011181650477337795891116214360757751702708123577384903407581359532957613417/5102242145793602836178585985867348722293735667348182503473033772721088933595758862503447689457276154348595356282444876639665479612130499218496,-15001922682951888741320117609027483413612733800132695484887994598234489100070481424629422770949245926947961249710231863477824778081553762563/103332619846406573088659544996402211470023501953769885972995477936009075400177394231060347708540526925515471306669719493266328183743858289574,-21416282011945648952780356007952453381987036395611985720074554670926587202005898216278370896590047245839921425487844812193550880075259820523/274762197498483956749950350175103017760109073239419790975198729346108085911379872653392506752428219229846938984659624972574847818386423855522,-5855057496164933040840543318937391664376935766436617961855170141204983168388493231122344006660626009207570439696886161187726967019308907557/30376271309613657968496335324497622862986727796899039170722204001512566465909861512723474827658199407420854819398474400193570229520597563739,5660343201626799874040721345674106679582373542658668249656057430735330115534142443192718977064249833312214458554547410277886421447500687040505/756143246784227014710683685036760103190522292890307170309182933551490188374029747538609966331296645346906712441124070919827764306631387041776,8150964427649297447946532671831422495349871993956638906434771823432731729428108928593513493980386197437923144127485068241112032431488450966781/667869359094588772083983622521294652588098232618869617315962529374573738163022849793981611654517583150581590457232465767086881450368817552778,23783437122122211804995573644096874327973252644566726103351818444588973358084877125437623644825482206929030502132964156304841819956872808132917/5445481685825397210989085940358760303099268259828902548804574350900948386061120845643268147906063399858566328435710731659881640119810850659808,523517480247921815305486249779601609054950909034648285257529519011693745366292395839462528368670301559135883387273389475120310119509549782837/137256346111162667630542203462514637851763132123379854053923989822484590226730993125470543338572056499346397401000856873389473966954782939288,189225736021698892107286281496550294787443740103481876594826495856659520485981513577069525352888351384723267296186075952437133529389689150467/60199527044604001387169052007885120858380027046385964453956514778960062075112380713235166202401434374687334949876743803910668443308591144484,9326748150199041023866216734750034118429244906333464733408474861115732101766828712789179562594582591881711468666184191233244639039302521816919/54590586356575159710638313207360147620746149279738742798579962010220836721278696281477583270923991385733789388991242355723991732933205480352128,-11353175506430582752322126223806875176602147083241688514888720970262532830035828077947408055647065242573665595118435961484046988290946395145/62735060109287135745183323300180119795314104159327455897323747670761797458360047248477536416870983444452844233673990481943139951269884261316,-30185638768560163890997332339844716692986160006377952193534093841287729851589932807602479892914860962996037620139509167696883997805517989051729/120160000550825269000379931697479577923378213216603148375838423788880583744328180548645047073172345512279642037296906794683452371513060140867072,-170164966926783544984790108199987678318485925802564674060232475944845702239562949341179753830670714047850502293764135972246003473068115973571/648788569216819935549553400108130032565871135408700363041920178702948535371584102914533729241587703777309686414684898871644523572715743537461,28328949394512637512813610029774525373899664462221276955818190882997993864555192001962864987384198131013035950317949127917163990018019000754323/5038692822735967400570678688743981909314887807162966414192778993050906647677033436861400483249125289169537651419585559669703003627608045497232,111446324286923866023896202426935897292329626414349891556577327821533255361598650272428151796272460041831932554031221382903679904628306446592/20649296292555391108713356586121011627582065784459380868816383988254018755136373303826494169948607929063611111763580878552833574809071130333,202693195103465646844818289586248376606345954770416373945201584835329038988739235730218781358459834309179933139627666673480500595009749519319/359675590205501724882489980419286727130502277501906227639456925509963181801925036866973238317455385563372974032880710137571638698818714868631,2032007838522550739132834010289729570507019890239810626298084487052238657201409505130742181870045753581911241987760082545608506652797983000447/1523414077411062227799385033347324516602504653032487553727092534711081465048317936568074330504861766560567324977983386964488713585469129907072,1895189470241220263383012597351060181185089233530199988400349214191896018525383434647086631982608199094417383239167498285651381975637874698781/1417180525074836290810484991265300813678969091123798419016968916481189673805054076583175988262892656700703710163222177909990931006628493989504,184071134021432861401650665022842310066229919574202079424093802568163888322550118039033656825475290977581456797350438244713141497715801401626/49087218665684036809476406565227173621471310154418684611146816393760223504809826281474537147338088179377159846875538292278378599766242885559,-56033987259046629089759772207750463898678304788102546755963576010490098996824275657080643307329286350108228008843110828646320364136395599270359/226873830259852906671892853883506101350703299838151627082197527921503387853018060007766565109165370287386632008131775852966761087004929697184448,-319946657526449833666084769185150015504317272238402299696460440288236651467271438145604762423553879266388343009908982779578324434646612822077/742239544357532089490360991714071661479844077576117367969314334580915630267788453142082744733472300344615033936031482749037689863859647403797,-108208977601725649929004615519971463075556268961327409164030689586070609763206785019560137304176263968633705984113728443400979027072352051346/27850562369640039520766229305107178708462180377416085470950445658374803735042158172410553865793759738713269458033385501425880600255266001355,-337072188022482309246095853989809900420489255420949425930296314176202164977721558738797383116063593642288790554202940381762171126194556047582/102615992876108605272693082441341427189322929349862840096420881282075071819719140948218218002889051292122612163191205680083247130081591128003,-10259810322530018068205561680115520492146534879294910317909501197161690293090284483516148908765917649452206815936216797991635682785614081065231/1037077100854896106115969605970563252183751690386193526121545555324335705924353090625899751370386786028716321839113509954230583880886176882120,-1712093072811039936257435881386150836913498811171458166694350831517388349096357806789138018132914816766045368541062599415558561866505679232/677710083548648091855075408635256504166125494339719373840368379353234925332777533459729006338697200301698994991561437125855707448972660821,-66414703022531421244620805688851941489066099759318314990032007935437163311858110723317364414446653291954513076784752696690102255507959856840/37921386645605151942404875669314035697989159408008337108273374158145551973423089023451408057847875387865850119150943591327407920669055907893,-36263537331774951441714445752831620353448369128404279757368792050573328681810021345099340727216896265217162011793818486302771812882894512686/21532615724102409210852349567110384071306364384964436111826361723022395449866494277890792849966659846439582008105356878990708851624623997577,-109027749587779026307029883726893658289606619081335545786823472035154741054594984968688644909754142098479263877184647913299939811681721742126513/158578008634484060492914340760375472196262448664449699130678135986408247957201851623052563390222487843486399836049492321801835375821080733265547,-1649305531839274272349561876768931504842889559637992497680851452413971022221971345804742071038334061878071350149175509568902143554892475940851/2397365886990677939758445511029662093541485480883910199119164107742889326829354183114936256943809076190831907192565893631150137118922322812163,-439032659880697872170797957538816104136039423529943911022047076168119600748162389952179195200422753012613833086254681078005697797499347970312603/644597930445859690260649683058903082589569185662316378985021229705889719498708506989559204106656140634340991527053358178255437491885220794111522,-1326393808941639756713695896995009150085300906385882978177026238684011014151397413047137438446840841306681415690419856431918989543342547136317/1965664105896855019740828882507978934414853490542179292208493397751808591652303029340100248059678538489448028508255623259938107204738009737854,-91280170967641977738503754918746175303197663679327692028517733816600723278990745201626260230101481523531930944806515372181347409213366346468488/133228514373621738224792916716731154834209700946863416118852813562939796792400494685417787559072303808330844720814397846597366430379005023375993,-8078038102850236229696213282921812087903218530526745889860500345414291999664108535977517851529585404008072622965408167791684702966355813575745/7278345203190068789196849460329597131961326230938833559940273226243731316968282487920383219367517803304846780087480774225066605006444378974973,-25722745436631278972013931309647535288905183566900420126050621725767746419630172183719221106956027075499641151153960251511920370457627443581/37085755016828080560677242618073931393453273310263012087423862554057850849924914537569527425679308326031246812884878079001173672876030708282,-67825275990494012776114959761888281611281283566287272129604662404029828785970491426852241372233361979070479833941899965524286728196499639945362/6233294102505206301394172796139780965144437895805670528368851054906598104439205521775515976508183276512527171397836998889852841023795351140587,-48724136372477746626535378848194495055905967767845341173393789731655315164269002251291857537790565950108633089417218704759956685800604975641156/43437824128349037977879844304354268528999528636387970923427673155781991024767407989465164679174728877939138981546682154276653194959789855263701,-83676095886392344608974594025546213452270390609081598270419924161608099587444434447960597013733612167622393652071460101267863983902874897843646/11941302555787914582001422008157914067633978317936357497427876959916879794602990051266847623681391474439225406049907748231985186316898762732817,-21425607706008817478420792909248311390943338692335796748134733836052827791923035405838943181743853123834695024716288841991911195127210162414533/732196756529977768680206686757353036393866901135267249075049714773362649343052210800904383073819190827536330495195260994391527426367479134842,-10012529171555651325216250509320752768031196227555134198360388550151990322981089395540309909592496987422393908986441126080090076213813815428121/8368387444160524150558539284941823630429594401617123049852166985982380109206615354273142339556715304806277429257073359651645061027623420394963,-70066408304687816412761983849225214444191928372683454179057843733884201015954435589489458143788486395286926138899426777644956129468424160879671/71397961102207354360596193481293996394778380647929199670149455566326414395799308619199092634000746540788350557742496921126516734216721150758703,-4223249716210178890755900800187057311300442179929121246117674712391671970056570306984948371887666021562875537947390575979300757283323411178741/4293057086887179700330316333650809535803348690727018440337519614818280945855244440037501114581339852848317873884358721575248218421082669561513,-75525051052474932761888714972136530193417365584243687801912481122094811757646764926573780760606025583119740823144964166431164547534444949897/78952236084540783716430957665713246408219787933567644437099900721893685569514084766113272105259984225428672254853226835027689500615392814821,-11275044707938454771106367951085425569728178756495135075570348008136547700507484697029900307406352657618103333046975943367357357768443205629554/1710293771440669076441422006895452486893649372117891655822206043636152955983163198444629967425323825426908613833952526792475873367466984395939,-36749431356455390373938913606332604121628623653078184822632326989737395541034550306109627282077800753161947564390778286796426379725272754303956/7551005077484609049472092746770708303451675530710040105276391028731327625813967782637584650438329707962457954690657148159202654278847167352253,-103239236104484446572302432324643915611113865025306951339453298816613327874931201433042667386363857585820345317957207785588643368600684655186679/75988363023244815583398457661417392667995909704655961215589591637010608765707388448197935970618502909864172213751553811831475420323069580640071,-148221391770581208852199267525976106476771155473066062983222951568867526092615732538017703911829683398636404881881827995314645856263005505215496/96938065962162996550969503125462017585634132378390791680219112024354973203992917044748710853465445260854470090254782711675125945563366284616673,-4376838138603873715157145934481060557867023657389457419023648682826125493446420362818482743978901799620595951002030567951891878745043816480447614/3143231779135632266363188215310436207704510383989861561521061322605312097601139316869344966104320223064153076972273238489223268889873787697569935,-463513986231482829693956627796151983065822935677307315558204588227026290092012299832570363970991942261035672135517324757095167350832226721797/1503118852167570159256341677716954937317839206633050306172094147816123712654109908876672090300606998461172842427645415378403857213187349991944,-518923207830569474115433724453474330981495742747129229811772772355802436238613362668272303307627266896191649754992106925624856600810474661161/1428330051649847672084787523037840984333626146984743332753973011821363491068467281031038680404217691088039104155307043469961544037291362287424,-12604199746235348546393181023476739485385951790366125139816757214681216725596417251114567768400288439002412732302837621081031468090642241021125/23819728075024861046916687254729329191756129981890797075717660770899899431215550745126363648944060911022848701802634152249331765768413436065792,-3545342263578477350487919862377035887910572837262450455284864507718834313027647481068160777813459011464969334517710686028102672187880026377981/6944235706396769295789260049687925063041204490467964755882149979105377577072353039629839127558538146169840433227578848608244579793191249730264,-14748120779415069984052004465446396914452763465738563826616931145056492923811583705438340851962728954185306512523453325382467527352420756702307/27646519351053058024176049832125994165401932443832242829374839233165540147474460885707155926922279946080126301106555032510650919013515440676328,-1001704556983867958903060883606709720485676627926034435178315348452321140854997071746621470307311144323278081015521438206874272918107122679388482/90407723505933996199877893065451612655840355315146303639044194280703044763854479031060571642211944450477782236087536754595264923721354034740277,-1028877895834542236901141277920607541261360924189619954878297966084779923827192462311560156010999546250226357373319802566416745482087163643527/10034518643482752633367147581932762048022220472021136066503127691370174738563151520555754474653895707321002035693008137811461032876366817683990,-416218222351136341040816063652901784624619054214061662552418680690148658972303028321961686255576600400527997524044483607439723992716194917699/3383196720092431065407061638280722018622149280326618297612252566801625397731211100936416434450648903426716796349980408676122533414979973384192,-70504271589671686533170744326398740447023375564917506392797427309603657745166539795719194912639545347621299144523137001179771466031722832692/199928462687911630950395667413418188066270243630853023694025410418747972234643538012634062418428997201956272934440431990909622757359943045127,-329657039169567692278533399314634159940704973390758501439046954633753291173312900967575702289098273551792186566608862069240902178459681302532/854254612688005411413183945985270792643875218394218727789815082160932671336671733263962173445167743832854840186015173782798251278645137613031,-234050603179479121018575500181145022080195093337017994605605651033058744916610042424578642660457855206710078114718965390673612116297570167339/842960958247485618209093924829203057993495764971453892422568636151508493262441715471910945052064368329071220514434198178069794043073418230526,1927845883543202914038877815156867021341319366507415554826643005154536226559786587531484665920068830379039314955208203544370954913099835686365/1120586946895972225348978360836948249513844728962274274730171628159263630203552583868391150598443535079129973557085659767153208455360346211154,1447790627683704278251355288608260233812024097154454923901616937880673095726982275742382308358892580900285154246806646719350893186790325562016/654869703996949118543317493412373196232426032967288099576442358310316770437123158761133089179173242282854709146137335310578408152399397091379,4726617293355891433527532026834635282642838640542534778328726300244766210922625514754681222869406724333189704926885602717064462616109926027969/6532512285908197369476211193786169799905397123926388036872011968616823733534341131398069752778961103080636798680246794970624567095310980848072,945911980564918759728197707627662611687429495777098053493473415995778544365049779028580636353510426695297549758653495444345772723927343738253/1553946988580599485863407269708372644017165652441833393492554677528738177775862558641942664782173065195932979407171706317843662909459422115926,119211718042365250121701350649255684488428930190650214370540199876183391714038013113476670740823149770229386957245839436831608995488489398882/227346566265386676768721381935933601648391850747651054874117949195236838177711374751035600803669255628719012934260696648243756927906456007311,322691578079711911350055852708942294674907538178442161789716083931205901558108006166093849631747947026378343024355273311289222999778260429195/603654646767012978355841500760423801702004493689019002052441790749088640666393828441864260251626467029671631833873632260614622489979304996806,129795095617674289703716003478560282854241356856809943119525380103983372616198163920468208812202563292710143334454845985741110926074485621098/229031971962298852995202316006275093698441732906421291180203140572440681679268244327439029177390569822212793186965860964451743134922259541781,252391053340712367087128723667975087644547795639847528568349043620690313786353428220827036134952894792762163973968407508563064626591163751421/334686305547907893974960822122154958737403005021550990374501612470156074902381945816556371283527983425166001514947449213292085167974555630077,4639928449491464646015638051427145236153301011925950986637889389753090782017981728015550572638824680269193401320291464895112877798314827258141/4432349910434891209404846496348690472864880199141003084251804654344957555223320489733195764660387972475169022358326045433329650463512160903144,3699055214315940841378434782696960075050765195603787340312651158833688888772955245597474078251938783169627640918358645110972055426511041321585/4922298853755594953916161366071634508447290492448519708062936398471843433334257016078045264365855683065274959405232632132955244922397549503197,1344051408291923015655149764512380860507008246362609135907371590254201252550201581887641820628979769972231888121924421369287947014959200688515/1843133802399994303900461386119271129342689856932820182998110118787483174322186167968328649052836576720815513875739189925473460180602744735899,46460383983326024594850669965634848774608246851177784529597444575744025470826432974184584701196898609649781156101310679266164178458444675830/68952047823333485747468692306141085421537548000118909103461841609503187194261849969856521085197551279785146027928401789471141144854755444689,5312887717851988556889092738950622695135512521374264697147375502357268159772543728948640972859885027999106895760047881048791106429426610219275/6380691076563206646346281056148135435040565495230782611898134572129994527470802921788635134218502388559823317390596257793825929235578841320472,129390637754272461198808969886166826510379827881013973431788810380659413328427700131326697801132268061086435743695917110905583241413870125391/157015716291105497152675741514857779476606654172255508377266440009802437760165874759145592586700369623452512342133006811986254995344626773891,12786504300840053916653044561540102405185781785384815176121170372528478453641155584261729959856415301459850706740960145776889836205949622824985/18891921947932423744201633414517526391614393617796160626134612334172228138891095443633245293595421049208406600590693737806379610583231152408718,12311225287006900952734590325012024805178723807730474772070045691401398500490453346934116178845882950243406530305122311028513022806518164115/18365545486098927083567933057864232553188744544340563771358428437300547637190326711884473957841280539334833038581612135306220959322422910531,230185979544444927664406987340093099343748467072611654146224155067948719426501197028816583418920634136609417667359581995134724681766205728590/387659437566693610139642291573320194359513277892399711664998011058425070094603596841346619112839091515764788675319583247790019778792589859443,-1888034036906085779037205272014336717157459989104409530368642477278841356646790975320234768756369629161278864434774386619412828265933057029648/667987715025088965383070627860424715859438577382066923511951807872137972338758908064427488625486650354740896204919293509012831960956521774895,-6936214812680767523500470660571930115104616185282407991145321237949032609708594067005583706393356856697173587578803116990070377641494573572736/5220161908399906327705892812037224798804584204547470984924330108601972189611906872028863961222616009563016954576086958030960753700368238848239,-2252781263675942367653442581918340683646043818628018927918763956492055105225937080306061386926463577760310808114287541432421442161497241667840/1929806546986045334096120506069833793614238094654769891995110191818930566593378136191889708104170177610942786788355104612762108315920485127981,19012714349907672229697226056436389236239591936174458317341338223349922584208617553238392955171175822561448246140958263736301909542498829350/98407184888250479738554575284255050360398996252624181613082659167604000424201195392273804381760058542216370819041318166713592699035233187117,18787627441798080365186503390622601786389053974651721788003885938732444969440894691333746928834458797760382902343127807559982493781792557094/68400993462952804431553552776968436885175838631539277990873501762457416748268824110361501239442895977686724263344438495972015752561154719107,7936517923117611302660720123989299946328152195901563523811662503517703886727114498393270976672003904221754207769587140800341964673266284505/29763225995239596480166111376678520970418056095552021722299552095856509270857445301105378569059725788582759869019994255222642371686698389583,118377960670821899997855792199015978634646188837067503132052429702396395057902240614070390446898695686696429771374431200140996451219485356254/592967563226866612372372013052902903829883962623796830936048692144314862994071755707457931289991962533010801689258323097157670160261593678613,348171166327593018078806630527233972028255922146064863665384725890853175535358865903433655073175966853955743600594145258731403265463320147753/410631972112782774000443381299915693990200929090051937337810351351065807540854856046257367290608857029414197779746077806177769811601792569096,336165342160859370599154944047118826643470551551924975127969137300637460720523517349152243204681405910519830800847759949759057967459730763393/1032476511460897565466490580873783440503252735041330953823733188294608987734979256534993782217496477957134367505921722862099768940477206078861,-1753134019962769321016782279982490929940497288009578691077692983848628779505988937154775079544534239448041257975407026790687330318861467018778/2788753077817557310921333200108344444664146489475728364907653640633870978507619765718974861463934548988222910873398509404159867134656860149709,-341134577693886842885861935015831832469295028124193032361444414109901826229407248403121668616749482628717892723847512177725008680053336537126/390197624753153133276724642311497694319002509167946571337374645793141503223642228557124445639856537444639333705733617634931950379876986810687,-152343767727863682169412349725519190293556464488729638081219824615841517445964863382568997284362666214472439687372070443503891596251127523900/106176339406316823323185807353114203298981960448028341932508351565383358838052399379531704174794601698821183414074423801986518577346621645649,-606173227489623788275082653826298620484011850507181715064000660436858581522569111260636469023169837088319746401151912118365724557311518714058/794969718611959676801736352757715012767040150050076454651102195301918578816427218830031708011666993813494724014142976430165451839047677295269,23546702518002585100994294544452913969040571264618007794783600174185910124205340406272723482548412576641842695192425045626412443892552956371/89128493463667791879142381131424295190398342119525692797412793945781288238130468341302070676613535181250978422776448803750087866813880356558,237342352008573852004352078573229727276471810284082851268934222425472078930158683297834366517859002757217286719224122398907001918515437471634/12316969890126019250087421492774264819659856516192425656244476400295282602522901044667223594797521718509805694690091050175724835268434556767659,-1580508230037626342832470635384392389674356682503581617512688612296384427787510854509055436282692958269947201275791247582881481112893363005357/3735640598922438662154383778081235519165395081034387269358698103260535936752377711908504705239848306881841491949493325104050164991506086515106,-62753783578820004795147092589848271768623524866581609289006645218186815196099698531439545439657101656140036449529253083352017509522443140977760/55621907840631011782228262932707117296574683389561601145374184353821310249192070401984100025818247880286325880651470532835966112435468214422021,-1219555657214760334941422078419832794741080813220684526321049824753912178084051893072193270399424414623733103546334326922375485050752040866/962735534347786853651925848233047595612639914447242097991348723733136982690726140918670472488861252689056176618608577769243802158205397061,-6319847948528194594269531986236542476622364905583336447846823646433328130392973937656814071195832696019195361464315189837682458775926086190528/5118853962979511230116088639396002563000568961145450474173582239954448875720016890883396935492363942633269663276948158052327490122002215304947,-61890994907711506599954287738359664676449305986302492204576225780687587887872224056758635642723508773635378815125833759319881929375570185811/120915863400214580636270396071274895151120714147603967169830483849246433691345972752543459735500750138586772608683293695044366463945517633253,-292191208474126352654614068684119417740280473687888521154959212936881373255588347146141370856527758301734737480517591713564104002151364261573/608653183431181881699016838202827441965915849060405986071144442853116217908828174552637813421655357254357595040221306104706703972948405650169,-114858817822561656564656789092994994766398922673911190300984794476362179070337535321342215259100662463067671085754389555683492607792560645837/208704240570736396201289670367413939132971975747620410685309469923671274911163406979057637819031549443706368645126298972703620210996662211104,-994901612162317916137545337206706192378397449089768338243640454476187576836575118443973851138754588282493450844121538068541065688007380980455/1247548727256549477566498932962442147262822235058050655716716017534714662167407357311826652204269325774005548589370204669696310020494200056146,-183705336313658521720734277451657415760048129559728766102791044743121542820484093436555202964778677170068948217993734496900519276139722511355/3228896732932891394980874576884562656111096670318023276690208087276825809963286968327245615768200963893810993192180883816693703585697554348163,-319192046911904898351827629748755506793233304507150198060726073144035037089649722277872464962209347741180612795003275123349581757278542546585/820897006360694725221444795430264762119273573274072746711148304373903086762605207749073760947640626165434870888156944376527989961520663129529,374495647311245727828011295559374931427298258259059457703215039322155879629852733926795317923783511934823481183943389140724736333728986709979/344994402715410740390193934514675788223270424545901748422118744462908700218640696588933383694658329342694394980083533366713983333471020604891,203409978148765876408801453637403325232247978909265935133006919265935724426437079502540004570424397134433909844876097619634073081030728231095/300111979092398999111429068951986759395840800792189084750866791513753363385303191254877314943339012512322798070762591509711227696341969811837,80212961920017164370194986963587058508221909993293022312035031741107021714479092665176772467597414415184052692570429728475771641209850242638/124218490054068068289723031926917033150512806169272846603533883384888631788189167821119606816213540708480267680281359542609531854813201062591,192191458432457230389042861075937099310220078405267143145430081103020997734751296404663036281522855103105072191903773629399282728988572923316/283644816118526756352934664559362237785814114381889865798369458742486376042168031170540258411825848037876004523609837114284236617861602266685,254059046306778671843841663663210346398968962001951323815848848688410568638298584963213581589625482716220572061681474361123056759878298668877/211686906977812137766931414540662903764785756364570270372264998485840430104214027964669584483708016372487199187761044488745402121003262011773,-4802248083616821782778659979863874611599954192179848448419418316209666270794423713490275655482485101184154104694552479663892591824713574314839/13075073325853661684755937607034639885559389602789729180240160938332346452465874919877003106907472292634989749354711781568899913724307983513152,11465785875956901660569599901271917201319521787128194101699436494435281434397133838128249599378331925139122339946213433085821249314716824120637/8335211329731839801196216975440637631323399985454019560287761237087015459894623357471453540957332106695953043868940998317683924259339948319744,18609242108536213232194792477290748359351817344311202818424506357775437778390683080647472079917946833378451154217360007835790119513247270673551/18898858231945324809009165525132735604789181064749278592714704018348804155508560276359070173822155861812590055821440988284537234899083455821696,7145000307082420077677235599434845302437871219253995156568204125038114823215272935430255656027040852627447205874673638937333581008213620732775/7325517170046670502914992612649782680386210875002546939274958307843661147315709057243284522238438695892951855130457903474228666813267456181504,1211150846224531843566710332541013819653986334288039988438770516687186177793777841685545980887346477495719042311670648771466557857438997537/1169878038977793601495449899365358540719093344048235743747350471212164679536685591448387234726489844698361437119830213119479011105015082850,1336702872582738390914659543950892916415545487399764185130148858548036218115143327846859765699834252783824282945242101015023379761560050663261/1323414045960242856415311433765313251965911659264159784503647167814512146851234741264938192978265691523200004374374401113703515577784525964880,1521666169459418629923071451537881063500143512250893812299024398964546256927446960568325664667065227868965053456968188040014125356258327187217/1546944316821990695633480479762384650123409723679553363864349872008161497160574446304031806451465665854250835613067347450387858836434305071760,2012077454743830087946374543495722499234487461369968186765921859338056619546169238849145233455267107886618206099264608232807818679963764732349/1998085290910171410363066571368625731499136750057751906683815491395959936350834108582281471833936598707215145556502523477489506303551688408248,3179709151543397740720591631808523422990059281324492690264108494640705882472208351646563298549194755534915701137307335161261966996056904709089/3930256267600257073967384424686565660863772082786900919902569805155772439578639710634054322168701495585943395006856376426241710803076488720260,1907935095899848309061275143542245745582264197420343120355159925045647072474391038331027255652609329094792643353541951233423373457989910685653/2331515204007333482210763681220986081879481121476701010834682772014170307617867953180412117788120429432720420278757999348473936731627124741072,273560226497322871838463846161413425949840160599807268288523646079296742673380665777144406139889730908181386229134359475056798404731142273959/331570539349155581219885670537784829354593135756078525809761232204990497321274912818317589961249681592411682722492126265072839401507686293786,-67728032788099564274106643737648376994212825536483325333604054888228643892864685405086899647866327167802845311758562462475529898282195842876586/155473355972301760823245322096420369673739783116948185381602480851836737491811913569671828481438903703581408729270565354173437886333164845279361,-1008321806262824283878201690426208298595573176700649618948885533639081753452522866201562260838532898416066430654075397906357443235258554857903/3584355053315890794047194672151058987141166032227379124090543903958702288088087900606844960799953249584227208626043757743286788209166180032999,718414794798159659347651925869625902008359417780527602218918842394394051072235067974385044693011504365461402418833688380004438522113323061619/6890538608718364899547268351074263089405103989377897630660562131875042310087554136376905296461032074508946736987206684308456164036237603222036,-211069802430899267292485145636176254962093805729020588826284728252742502745788165951305445812859212713095424430482126266611997416236605423746/815312576108398134000181510243267450497292892745479691388475569012828946322853499451140657507207919760172179459696362433762488525660857389445,366700712758824412528151708193875464905875401805137796971180021527931924132430884635194377865506593677531873266613515419286281761215009015333/563205443073766122531902264392047603747107198608379708496505650864219645145496571135208672353662806623060945535657204953796151301266999660825,7105378198035329865833094095322779872830831790290024589209992462343421561259776538215185416128552509285336465046348974593495727419477203776413/10927251550809735992056108465566026224577161544106156524883360956894143453778943622256286157417669149866043280199767017015174700016866134060988,-135365903046385845835545584621677467748276033435922327654801481973530861543670728068464312967295263632029218008178390364953367093776804100147590/116675936323592949008405434158524580460807987798661983268152469463888716650535533197008817519594650713036742877360523833726426651546938359252341,-4714925309608045305727949204327132676185392986052705966755626329641993590798211561138834006781791327813595683714868931786910536874794030757823/4693090382740035112631374499867161641863297298886229523258835908521661469415962423417129707834302129083574570429433292297365115153719949511942,-9245890930692163625348137304015075259736784138160251142062443820251545482262892765372305375459667267976568744259827136818935469439847975453630/8201565383116588618634128438781291057455094273871236390295092375846275552881700924474146499541526050550556964042727921689232838224451552056193,-649205372908838175547205768199385596444619298685646696352116333370746519504693836314325254818547778438161668496260139024497738729034530549838/328286227085159774388220287867685423037156916807442732758132044558567451467381411728201858003116053950114677710123903989132370067613979322959,-1521653017539012176458124073361519181442129454254518264527000573256782808771235943862351393410651209860804606821788414147404742798667381890797/1810957007526469373441545858135386889981420655949463664488670805399115430174880140120900685166865237537300701037753340579028234613278206837579,-12814531871516669570230258400925078790966871018437225576468945021725782356862522174919867156160551158294988972531470227954126373151318878065770/11717557032452428445219008907945508742598963922589863793748020305075464783877171187129695424310492152430395964470018744787205431320782591858197,-196637852316036558433429018864381142628767924157729038070835737220337389011138492314988576124876530560143898935583456878863612717869309885705/182122420388458794561415199167035316277177765265407307893082414221746137221865450268769175413438001979644948635145286631264644112762459313368,-1337242719092754522893884251315532667438760973266816123276384130166427763649077115225575221835137017201477090507779283646586933845453618991187/16606289803216313093127010875607097474168407326028966020236203070016981174970592950279915305743073013219429031070407308006078827082698038755306,-74041279271645790742913601090870882585632762557078930561730271124812102406132639951636281408076785339288337088507395955234439530514866167171/602509063213559375775498917378026747686410788399509579360305334323589426367719555081001983914139382681884622717233608675768078092066475309028,-916378388292619628538996789469388660642063370371341451152273065894658058393470692429271114854564704946711372015054919450667007820530681283477/4592068031245546071855527005002531348935760985293178056334805730786412113871212053323153974934812313704703440712298099251857469401240186037358,-97107121167038307770627077180232989120499279931302666187679951267661060293870804631286859216432997849092142626855365860232727896858411019871/231343789522554711120538524866444100105051312330880489085367771862840841513720799310254910086250555869371279891241522563592836206335360551947,-7530713191432633399326997852212251103087831179164245436609195884387290612166765068152520104062740668886765514635986284389095731872659616604859/25662980013205549577777801053299191771809887357980839943372875822927905430939461819441676978971733870632590218756316716500555597547765190653104,-50383206141800446911606743239624005993181200048742000142331385527851173224238493037270297540635727357700995920161866685556774079975810821134837/127530923872116826318853564161927311182513303798146684267746712978453998334471955569512981996773611066695099435286914489647569829755389057658928,-79525177255122405054834002193036350445053583224176166444251392487275775314863263572362993175576878211403472250136906288244381728487837585092139/193970111037537674060211648667038772320165662687439885932630624525245319979892691692616657087996750160191373478099001515299666739868617594998889,-134724569089204876486519953405073855327845086647868390100424882000748326433320690779952358852624031313096643301292493780402652032573725522143325/149085022276167808539023119544808587517541742957099472285050625649608316744975856859480104679855442899604308980973982753407482628510953129663913,-354502321937173337582980951132824290104128689107552430186204377168727614574820742684759104937333529093315030806801264912328550300525678553997026/793812921426202134823817791518972037408781928634890639273770925928373515279199274004975878128433406686540464034164531804543359802017477452804725,-78164146114508517913007036799050426385496824542504643614872456486357068270922005382404419692137921485284670152855918554760632090339249745287058/118258907454198946035208099629053477677499272928266173735123362719834132255207450722711716594606115797894664908050577143445501266148350825986733,-4416484157690983495303207620714817953736895160428587203771562063480249079579678927757928463321251226174619825505351385195151916581809933424539/9264824988931728671678447232393631277992739427568030812304612815779827038859445917604603703547935294920427222782805274486524304196902829170629,-172896932223105098288149399002356845810518186827837661574716783898443383149784445754138084254980508937453776992721522136946707088242624172602148/528832125706598950407194119620906268620737840215251833794621641909766063454989118772370594677906770207749297670318240565628896660299075412163601,-6930263711694186263670826301897315161907305903537847336686826512717310094295970352362633815999362762840814911717735534875026298418471816800352/21205692467514900852963650884244064065390683924700578049432355380801683922803661764415074317626056841597275605792438341834745571263877056653845,-137043136014738806548456716909365798165856082202070364974684388978475811066955240318085758844064204060422921674813318142424135277420091394943/656042304038815126057947257163972438385792323322661513514624722535464303653065801089447952902094597002885607752197006062944038106789655543080,-348531045996109559243675350228502995267857967882621882852737155412879015200444920186843178082915999893121068351163763972687453995459765396292888/1062656695936341702673896911318816459259598516216619098675259376048538109217273249452166134872678523474328071821780906390008173369441984491029241,-2816736943570340182156164909222865730428046681382872570984545322593960604191912640911830663455830718966976367330956886028622830871592401236833/10239866849006366683211904859844278867666745511649341512323606258714425968226724215432558198400940728308813035606079841985480128242927650526269,-23653836138896730289774657205900531708643179624396292177330307340621054331510812067235132439367390853860257151128582140089214812258922405601656/76636987125229427929531207302114768730327999742041759372105691441119393564524752827372583459281410241745133060208976145269009557002794650712335,-15188880754111583337771520946155279574886484852483575966433388028321202055222587164001424893712262677240949621704195117236803916952798648052068/50070099354261248248796593133554161876445856792657338273135152720297163115761483859952700563824451274075752361323263343925776961306879600973501,-1704057965169765885252827365644686879467406785341535406947508372182620774291575183293869084726049641344950850671757650578922903535802209236965/6801322499825926831463836182266452558818066248963736218487707232071720325279615257058442576427647423592098148765047367734767427806148474431121,-4024091820367942273133826984171288048849609480799211059780051759901502050533365609870760217990875431692601760532984946562552016633488021060753/11270999357187406215407620178750425733100305804920045507295108068336498379075715869309959067100442456852192686144940731438233352370377697318381,590483854705826177844024980153027435768503699587319773658729671357777427247972122865854226319379512725037814147913674889694543233451135977291/925512316059712887494292393278488498731888210748249647958398410746670104761686237467263999378579674028076144173603536054917577373395738540970,40006695057505495657783004660872400435227325364447514879579903440428614143411759980496735722982497650685489520635520335849124944240047316343/489430957738997505269264827051192557227379407299989115927740789669934987501442111041735811448607197522128173867920164966098308052463480156096,4919156115020767727033620217529167884393395401567637384541621461862086555049942790549492359617839161204220432644238232108755356597721761155/99029888066168402867539225843142892946420690770878789755617880024140687519232123751850508184108696087761921693464000384125424955979891288261,438798472503958305098702612298709306418743353541883323211511815240617854303423281040390940393962535454820083793582631850769458576326255818/7535718169278819670183833182268143764427385179591511309859546889684895836211470375597217353766819616967692523892521004641097441881374980391,337550350547303571060595107398542120620401242806853531548308498297947466682438612138957590124138587171653685612764713662181632984563806342675/742712742461537718210901701563841426890716675248283990798525867607092800549114638299964425636111895900954061915313503075336435858452719348037,587476292497725601653141449838820684183053884756912016528375810627205316746844603548825584596644998180098647911866693673207602168620041209001/4360110342147155416066525419532690100039432132443458821508208922502098090915657767847419023949917559651252044775075474731635708420984787101167,1272223120685328949862028148305443654443217673930264639951619093411152879206581576688204780078522764024760945245431854038774190496595192915301/11292348080041017080289500202100999873522452089028734359126682666210493132542633253948476540332720790874157438415827632482176965461312134815101,3872721196373217506638138377980055376928046956686459335184018137603458147840977717311898075990559343184546951170033013820480494208705703217947/27119514293674520370136160658510127618938814684276316715373327042807587284008701332743297560646200562903264268075794528983039177258536768701279,64244733409442563083958662997940922380559058517838988163889052350510524987131990560707331054789825190390442515236756510997905199463261093613/203897306416655110648711035021019571101011722451587110545805567207321869943773550675546349115442201689987145103518928455411308510227089869793,237455478574975736954526999331565156486583592774618778348218594713284909838061689606264824213394134957050607419078676885140533664250741999570/407868219477745149690540258341155944281751521210367133082758206724930554439560443707584937854598377079892846615846517136022095280614580775031,1569658150382750701111728275073927083524320356422702756348502126417467132967950125768826479420659684311506116815982409767550129754484682421981/11010884508094970821104347306848851315763752394805267707577685960655247313340489529944662429776190610242740907643542859895538938082288633294747,-152595230160198248272283684809514828848581538663126568463177347312963329021547929019969296212788049032556029481463233700419891687782197982696/3350473767149539754816596653052196729890192744257072596878174741705340225779215781642751085989133025295500989050709569295393449651511058743661,-15678890714652785474637928355401532707337959310088421113797075458536731894004256264122490692048757426048114168074111789677516678447218377457/177436402179640828850425118798104128050180961944328890765467983246786412381052458428406957405054218229383313866706006998636523975069991714456,-742271231152288013677496677768332968063772033630637433501414962984045041038851553167203570792512655554666457924302879986591557594515797260859/2731040454791790873886282415958452137693544818649000752380952525082000214109127270117030806836329367872665019456010234156648254919864054519032,123508605038242516086876294090945323265153024047628961752175323690187226959662535160938160654354709959790648942926267026885610565476196337691/1600198852237743448590892240952702347243855940231049886681020348948876400286102999250688278913137438964912666564714687084443165898027808410527,-1358005336087098334218173556523753194937097888750289483261421980145208419739632523985447531116958129336829209783099846220829159292434742536825/26158582156825723675423085970606059583092950019161126135012244078761704320868685225777008207416158018999173913132930280117185101880722782067883,46303684595587985074385653689493717883455195545187774820403872885542407531911182740830255517500434930322656135584299599985671220796241811093/561051317878748417714859912756940455320332171809578221572612680491472062008725996208711220513669845301059807825564863816642067180187373168731,-83275785342235888065779987863527382624322678349918800787364612269297430131655673739617424745211866658680579304117632748548586925323642932493/3271523885872725152821471000757220149654322841216234302453262499511995649129904713619323941602350254358728865486096279119677570357203648284253,-35477278894714238310731183744320445070128055745954336781097006153820336695876346218544858678376545164027763914797423333048693151792315663611/275744932180051025157393236847808659934249772749930575440333033421101161000732539116558980611672637975332206406266515563374185950802749559084,-72443397634600657272944918190872565036094736202727427557103265863470957871105629682386328549408581756112013173898909008591618873176519810945/316234907129675116023557163272933779835606291709805971114498863991560871067864218336045659444246028715721193235442676847780373018277253899357,20173103101972311553406015846377949751599840381664859491403745869276426014070187104355441880675878380361417974435709277236802091163814086375/67341566594865683935669300765425572516077108169599281599858755488471800896266823755301833163403442012049396035586322425039176230923193679027,-2668487990296885634719502718319577136074245967851471947400595928591127256126403250595838916331636277157630621369336850516526390043092333020/40590793594302910511057934852789850175674908601154776685335927999912068010262906413119268392574486054137982937969072266318422137026605323107,78752942497578228300104792136852320153255398594019211352114196313923468609356937838839640130648657236573070078813967255596737868874087520433/435455753309668843159975274970472857170913157296099618656558800894089931783747824221543898917597827722459291225725054680334219717895774260802,15352735103833894598284807267848783566916836447943531057890934725762998468513181147830776822495912283828754831016114304332617057137742298221/234894865743109787661372481341894165483114293795555209984088071783037499865807241643216760216256310831605493397329028642454227978270986030824,534772298342600539765343817751969951166200932280682030149742660344484561089532245441108296497274557378151141511095366193025808859019089432/55634936553003314550045098634011184232967741682473100474288773545193894890850698551968271987960626084742817423723962467667636022451037443443,135608264371253008720152381971041774276468713355054732808774264630442405328065849405245186885913974822349485900535523038915159051593903194451/1249303315455797394972805792611313830223451265261464489100501330290853616101857909943876703072923567421132156624864066440831073885143941833260,38011246566904017218620629256465064417474399423930084943091714540216984668276823033685522292173713106170455243857114799731918188034005107733/513319291520692000912286293725352349936563349265137345898737048723114267455466769031478974179567232597354766927979543501985359178959443894668,9603520235689028032432318458158065525164347657981517060761023345854050119273632275866503384645906553703222730183053580649089443994383766407/41452554033043791034269044391350494784392411650211840683402113266507853908192932091680438353065828248760252171632850684377146646971156732878,39674039931926777883830278606949585109384700261398959857075230913026451518200890801824809741149568426886778460293070746460567639362215921449/200644097177784029737631236106066192551040032945869518788303983538932890244266434070918842743810481611862615998998280197602940352151515404532,6301707130329626903617252582162610051401112976339887879837032905944397485616505573242271579079268675771877708558661417141368704569197433305/187844035170716484458911055485434782080979621199738159394255784073344056251511825021635580878205712772822894402427956095944094670512955649564,-48402801233158901997539328445907417844963618446678726290802712463602747635264290592883267472113855491878056067034724445574577727677519453316524/65819526768905153446825781025174501640009358282688365906316315476669332207887774180130387006543183986904164391687322074040406335558753745549895,-5760214517258045026856316065415209109036791973229058235884400921526860245864845193640613355525606607219351871171490466882559265235591165771811/8493550326331127502236751069630782224606348262183539816581342707003152739035473474429890813462806280379250111988814703669259049057806334431219,-7946111916367976706374925806674906062326605637815390695474410673533439144432732297559024135151352566324339033499940877633299914557124245271874/53249365149908377577714807066832364166191380313535393213786729124855393048827408934903899609853963276832879918755912921981196830793382505016983,-121665298341298462612801429548244563116542144363771772038280087202308602486399128420199138027451140700610251599978088872163570744846216334161443/280744616506621812856360160154650071462725812015727861918364152292745403480397251074448899616767116521719769940429279325519422448396684877261839,-2436348942833440870904259201652408783212052492317411089326505847363795386828111750775274073854267693600931234979796538981714292468953283981976009/2613814347670171864479760937092643776112101013983895042244019623520927401189352062276913696060910079626947887551872385231479973261005936358320765,-101498624397148217976616153223010607122604355580773446055478541328859708475598138269007167935630643081514446855036770491444976220155669309789097/257239706801075287615040012641709499926505707814695788540902421783095418403998783106250154785551402946202097103793587296453348915520749771264291,-1682945260645198863743346876973523503124814028119531045302632729331674358769821972711431684625410221507122308628286564920426376669641906466508793/1792517836471683340849469983999621720197725219277344331714101494898804986704629840810900147687573167951490716262503709963836915484771630618693025,-41518233758490778865642016324678779915472393899548770074035264340908125038931346770393331308273629523292473899918536771754232272048198734214183/40615827396329339794503270783289785654350515834106960556265437512040354600854306641642015416543233478430387915170958975107785639132457985475555,-1087631381566915172131845966851835364998824386939840164709692788638593583929682626975617371009334815291663141123631562702191640298285002733661/1088914127140432444924325593808978480915447187524477949482853138612223710867789439263615742938616312005897855556987664040208128184191486721315,-54957875537281601428131412491541776025025897299888868948768194932394834708022976419662152538163935531618617865758246697474395536661251100746485/45499253770117232374218602826587294785841500350662972892384141268605079933444772343376173933189966939452993317326586644989047346152623173996196,-173661645995385575531791370103960220541686481962665257001467345188504311995682182128645155096440517515383412605161780335632157764447061766180499/192080121454335949318906338395323293994544180901096670818449441026828664466360828419965237214183312550857841464136206483120289411046228411641051,-297187996844034019561462414536701015066742725656295967963831133489654122933852291014449153521121221562823146385641027976342813269814223900057283/244722945432607607188995575563877979735871451440215694936819820746799514109424415715937836938386731179139170454499419101604604988374587883167308,-49083532029411364398113237971036106492929000395158323906407571718018483669133697901940086967662914548333641694206906749501730744194336661032129/56909915797024310854800247032061870842894985771505437362034694180908237368595559749020679014670177352100321628602811883615102584377055526126523,-33268833561355334725413116386498071700410681658841853552745461033900754157769334896582308022054788454408353103399732223894756512169543671444992/26632580213190208549453476564742614251994068469162368506069583832670018015145625998223204168753721339926695764600488674762403196814410022295243,5458985085361100861618518522292465547997124433532584609513339593758529359904478512990883335211688767836128113458487532651851489352120244007073/7007467874883828712076105539646669129136878545659005075487475487976777705696038085850639820449045743266306599869505285362104568634050905202013,10100698964627975032945452179307648245184248798024138043001423091375997768952752519988271296015070784495110646085817543653394506641887153483447/15673440766559405270981231637657419902917427248394581917449111118292373863886490900564507567293623971778386109157326554357501831258629025674821,7692826490161806180229352713045627825767719447910966851835505490871080125069954242645178912937726759921428367965962300952839477814156738635505/11968331509370981095882076849420144358285560254606405998526743112603004913759436955046994613742837049405635209790913210771740960876251076033011,3346175770930308400475021332419049148059555663633354588090750125503114403721759757285139616347885531128615477139708485601968085310572547449031/5196564076012217622090586328707034370165959946224644449897072087892419447760872429189257368759624596389177930405658523097491065966470501420445,3851977870785564913514876749488443914835325904728515905041394041969313294450923260941985492813977283793238442250979657849868412436617035916719/5703687952966315023811621699002679531936031250013167904957712616494052253758139238709745513366805063086446121764502522203435832187604678488197,154449471979016646351504240126071137276278471906781222475961288802381189372507221217062313603406525483918646029199205874847892285003430923405/230098692891745408519078943959265694784449239921142253927278923803448682742132054411061090012901331462760961517847539966257010287539983322071,1573473321680026262567509317280619441394906543706502825924232605185098118012158342107250561137901738828095136573591354743788772163859721920095/2398660803831627635757644717018544029631294631005660865529266344307658560151895976481857810116837510792805561983415531190080071103889847696592,16586019824456880907731467147361908310391958736924862306404084832362420617943310374199431680682618374909561762849652685926619237083922619034823/25313681145085901166079636671820687350187754579766706581069581081488389931098514962859222909567677374324997656771166492245620470720063750384890,-53049032932882520478155889873347167515173597012348068264094824876263614656375100318419078907015058969517200771352284470035042394289351128362629/314695416157719432476023504597578188656167472208440245702661770801538074376977531333070691319692386066317715867848249800611994585853440656853648,-13553293313294942367619373683828302380333049271613645280320095687502475658252687722500472910652150049280706487643159906117047783371496786164919/75798675301671724427831945378825518407887485560591955520142444201516255296901307406030639158085916543402560664411432824812714059483296957735956,4876071234602666349737307374315462322428816372846867501130070380672998375058974443972963057456144140466780644647841916866891195805553626204669/11679968870956324894623304431632041944126978093282435943420226611163393454959149794875135161813773147820960047003594118932907656290803540589120,1574408840730290166893414045229543674201380811745524538534783701760093008366041488279966924141027510703667690500454063601562692211317102225999/2102164211004741958069460698376976730911328560823165331222391638540907540295794673356699324141877484511324379356569270186381683629459172745728,5616734951957350472108843451260780672346233159446471367542484429568631300921729281111843711732278073050128085656834541974168274367144515971711/3647587376345910659555162519736880468802789469109463871001337546607172542500619476257252010903707147933933704066762572811599914312099558000768,26775729593644589986625001043961094610020839202906021681960520738691797866005205794361928971976118838407757938843203927093779263513575619727635/33721189710211940101701975312443776770387464535183908683994899623425653249473148861470424578858897819307027834993204628549322175426613348516352,-1891678510744174102062734723561822275886533209038748356797912850982700346975374460238368949272868710499021698353353890372698961075328785996127/7537490503557289331254614127232043379656205479736024625861929480069916847741462883302399504417350650373074937366152845241917285120493369732928,51435355959106394232147811258727511790769645543106432996791982351224346946679309072566701876255913399049470241946791316969079163422108023307601/81290455176537353029406330892240803773936950917249582337725009189335869794081832444458670171933997933822214597630106112542085096927973202252992,15302988457586512922891415271575155629384213935456072173307854546235467887308664353401436234199367493740001123962533580484246466980776234719825/15441558566214487840729669683144456842613805346741431618598600282709373602901963394621872202357646540124114420966546133532744187983145345615824,-1110730932106122842319515445785957024303087726747885862535328396803344626328199450718803172887467820674579442645549310704771142103996244285435/3435422011402464717861155646269302749774292936589942961304029633009812157823149117701178140943423417706375341776038558104215382943171705918792,-5069823819886305255385428787693888656515549911871042018636035676755891275403429145170671976559542828716235050462778000499230357132457724741277/9072920880388736460186060910721414386778536653615468506434817100099605063158408464981158023521243454534655340984334780702585180212018999285880,-49511326526870651833857666029983760799636823187714826491796511022320179256244095500216193152621859371932321298804198679598855335253706763709023/87519561915976148740821630014794778370888186545969299954554217095262461725707087981627808216017108313521229597768166555428244023887809500751720,-21147840276186941585120751876473037063519254708701859441534717694895793319160786973469502227582499867078649178023002693491942373074402747898459/43640537274331525297249413142441226573436536058815461686288516305290080687743494725590287247992041167611807275467504920037153031238629150285992,3541860610686548298568616003214451586518891840879756528019673775622249326755680187056742498257611961765922285737806084474280002346266541119951/2617854593275718593987328348150356451568140705738332187064007375329857608932497914613893642771137202945589162819218825793163590988482571958144,42241416468482145960146619739413925569267053446968152101124178632120608867671175220217572312841556052445014860784809550286965898072425696301/120782362339259362578136967322659007138541555316508565654461423549498395435377049448874888496547442388313018460310642880003383506280709962720,851345834337380584520904162998306360841704847768737435919295383250533182565283730801561554151198662604361934712233888594419844526225127341501/1448865418651464022536367010807355507859510111353972717917290391206848264733774398396448708626015452304809085341552460133590761193357935450720,371434800755905657910592382237016862734578187522385897411621189301164864071670404783393435833564949868969626656721770167963355727689518327319/613685063848963118015726252634427551614050919443277696096586311524176465937675619988430565919076222988887131008438280152965606620979829302688,320098962736995407277999087758696516544564680164658691052369512551766393500588736869841323678988221593363730363837566190021543500651725241313/766881481443810845406701550387859157899927022966193319402880829413125664220176353420720446961730072099449125926012531629068874588852576169856,804453036516107676005065542365618281044185201742674177461700780934809793866098871631790419072054796090295997073857509063347513955345828668847/601314513885062637402441504181843965564486012390543811612792001582721181023923574161065808679504489783202987920480809820453420650062114061248,163401719317860787082911874739680477324318122274774595139273726296606825281497651225321688046870508184479597312432932154904744849916861232025/121720012053278801316653056761349008970910495752485144795008529088728833435490000621941690749082785798261007709990386381978555998129254748928,-50195135200529675577379426165993272996074886700228986434848375124387364149227506574324269038558517947878550536626259982222980399400300159239/178788912388696375949418670685290098815310372209324974149170724277718319300418569123040646409750978656356790174407450169519737858550344667960,-35479724100247847511493358961144748440009043114403862381313506647662566108685318997181981542355635209597432922779958390870510223383115041303971/91677073773838256022077264565219708343803596881916113071822343524620828724664248635625903908957718684793098885534248229447660847508518553883232,-8301616508199744720082430342297703129056171557593313384472296433040073802404577719948168564671321769153394457319314421282749196080389345975047/21939211154013995800302253142308651349792295708934179798784198749573472707223332187160704054815933448097863377663820549156001583256379104865955,281921102834279608944215504466805410457569441824364351345174331834300919569117072324183571277127106673747189272358297081354086016073041364706/2178878015198091113019457181356274052112678598435386230019961221911362495894631519698493752937904431735902001103951140442384232858324537811615,-355587572439488300256105413553220642293647245127773468445583309663872857393761812384188199545007239156307439509569103232832152384109342671957183/890908963107551097360893721266458218561090123436286958150921497773813154202892004730138629679006903906394814849585337701960044755609022344731215,120963504181710430089119850201543360758743585116434339530604191294091011297181156629127961347207827522894728903380808507958657142322071209691/878701588697461338027911998095733642455168783467731118616073887670556800040885134705672397691683830162335514641751480700517543524112708157485,24795731269674255012074582787506391616216999160620913522345133578434674231525774477636090704987943078954215280637675064150085467892442738673/36603928800707071859593256563159646119551238099832341525583965235776561835805421692796087620568282298347453759503788966825748249800882777859,2359797081942893994938402171032342839342827302696536151081431924316142223302793743416564662808495070612447160785965941511556159829854848899625/2959932360041107280798921667078405923542059341888855949937290104992494880877389171644876578118214193754034076146925029126605395640804118124919,2198886218494533263398021890412772774480351972785124230817356969455124604230189648169181167588533463018748701473312440473519420907685922830795/2680837822147136020128085998349046637566136454547988076879493660402610963072486889339379359203362154174120699632817319013038564985974769878051,79680191203101475270102984806949947834029530759799546240731714601851565785302837481898418841399910639625849856130884118045617111943429588513/90232699560977871510922863879115268180851690158857828940612710932409326463022844818659158330821865151640514790371050864383761059541543532348,257310864114342822995839081007520650441421935016321017066307884930333175328521896553028868810503191987671884400279758906502615571353544176033/1016081785538334354769368850660535068188400020683938523605461848334247436678297594265170403004797923512826131818292998861973967815237077230348,-371881606156368597786716204507685947273819090162167546584806723229013610813253045158300506792850614894479436173101964705753216543084160401721/1545923948880623289645948945797444914276950371696495767198625202204762549862859474797036785777059728968244988720767923727933923485775351254564,-5863647991564207703080957989070794065805995132594792533692486241095974444290093406617931011483206916295950528890938307534861912217573604796464/22080775590811613345055717682344364414270968911053168733206053130898188342621533914329339071567488617551571452909316296682250674249964618036269,-238228050475989271891375737539613458141452981922951671102769884857788133351368731864186255958950958810159535722251953743283080800841487775406/4284781558309212071074921858398977864916459800266547433399552961025299425954476028718724165900340044471043221710084938525377564362549856700245,2579017314705303310896777760537929007804238680540721454816818283669293710261035344954280404483616026231988489762522082177420131425717567583605/1817287404868153582265192728768348211831784263113783466663558899300129738654481688990075798383684582810905542816745529981543815242615976176528,709587413380799654957304329950641004503663725461966952400702508017365559156954216531191843716058010940667433911804872716452045844189408452945/821194387156718364254710955373008370210859108608810789135872751492065159610720988428722298327044054710224680679423933829253690936616608495009,9507819933265514735344055833875355675383405876475563088422947749199833431903568781838290466813115341095766437085528589630969579033703413816107/7081643830173416046742815849214831385440961795012166667055572320393530102035266955293484788361284841275107384050681772039000952090424232051968,1576456173619927580172718286986048631655895995442001581641273967871779812028335003477958988725684351044685405406730521286862836159847017998589/1925980208640546872435083129277755432481598481714743069754568452922215143029115932373668097353173086042645346762897102578447837941640714417248,73429894282845250387815185954460341719054497080151272264547131304951539542058698039902147592526728474463402129361922256711802809431829593611257/84745579412300708139068089838218072622835313740318880367505646675797523040846109215799102477026297627682137965102775820465082921927276601640704,34498243914165123592159191739823727790801958356330340011275725365382612630257423099580946163336993760740095293791523688431194202827967671526/2221074140294528512652234975198180694461969418726869107871308637370753273166442778933604932361241811321533661271825020261279695903741390872725,219369962415859407807150633239712319551692061722361010080100349527466754952185041996996774285639471061609491989038783586975872476515361678697/177820432806731596556035040966534775242916190650672004697617295737458191112846153120801874977279770502566803751423050067237189753992898290400,-2245960240608002940958718007040486605528081661932161917334889989008077297042253637015112644855167971235768529876284207677052515960812692085326/5813195092862078388483478184880222332201986981059092901111136348487919672100065241187168556493144654214725238597126095001456685538718270190579,-9573682334395025125613310417998448896169013578429157689919894432624966988882949322166258766944377926628091556063511420150835546514201983645443/14675266350239582635737283002740310710164249508051587442801199191551602413961443718536869715843339372892140499832746029822653480075932264001042,-9715776099524022013484583790729041491440486446968675077124575269088061187416890304919960581793629829060947214832545284291776971080249871802851/31883719651367831769826386342531655541831399257772855321919417136600056121442007144088997943616367952410532632823151982011244227215249038527951,-1010729208003774801856967746034500728623003129149340358212167853851218821939529967115683949380232533544215271083851904868766956766263799209068/4229626135840597135270809490511863002018209452338318654918649443446178534778273037792044172577471954913072987568089043644994300726095953874507,-25522059829101584324731933845362941001162637007781529344460821785203048768005280418666945496519361367767277463210307980408375162853218829701452/64825574826724550586298040899720659366198505083466593343221132842165946843602113286269295719589081740720920530814260525440517316265952526136837,-1068818259957947138258410462309993484867606756432888434324930121857801293941566452426934747130874234693725959032703798749911061332122760588359/39590202371777888036444886350956862644572428352583339603134525188739321427132523382273009002568694168424399990689178503466932901104092363228268,-3145704489210083532732801553763510569764489836154320211866892635524403100219815997836414096837004995708559281963538289893425696721678274135367/14865828246320278754667305586153339922940829829902142604115537975575096173222480587904378662984030510686247968472848382857026002362666922423812,341398147437132039947919615048335110628756569177106518243854688229366540212552240753359275878103265659830653008216884052399237795643394758521/940506151555762683247888923198697216439830785553306981565876386873408704777266194051280066359088139924287023652240007557925958809156651054596,261872016254449352200924275055538900113023105771257350789956128301197850932363639705411214113637560423161049654670961330225681417531256104138/510696581870049491121555742668799127862518088523030754508579877342919659086458359651283482752442124107061609466427314307450448890563125898403,-549473734436062405176349713757185382052285735115243983271582320845213708951420566188840552265461546138666131163049860627702590229923739061374/611081203427635088951182221229432078846557516488191793802942261313637311230052020143992335705304297904639617585344443672629356266602541506827,-44728750677717838419820867553135528769403703592048225351942133901794775439557872512928177045378915122094447151441447840078422044173555962196489/172030107796582827783885062835879512125646739176281821989071079435957675249231430035700712076682000075718844405177902603395075907053835624157824,-84998299940788622052764317200356335597368873209283848688721790763685769565068989899298256430335940103139692900342891882450792661543637109/837516810433142064501007201569563760742487116872148492019403439150065184889011774873695170311389153762988415031479689058774604713850771428,-460870128504850465266188755616176227950419688685032634869086340675530419984053163434123211859548078957411360782111614644150193277240070502/3192700710187568241886754820345330574465385870166378653498214517505771021710190793537438346864337801700346503473521320425777163337102279849,-4497268858143530334933690739275780098141997722385038883476355107920063939530393899900270183331649432576892212884608956609021851686582394921437/51503404995764585542464191661664149793883988379379161676328665213889023389344856790095741639701838649312253731349765744684216143476939718122368,-160557005856769145781134635071690155063072585696368370475178823143368263409643240306764478174263090884135769833917419895411350416807754996425/1840728968075169245441229176742309761668744541301473115793241974457421020790275616072035075729016509882486256137275454850903799674396837617552,-12838831450182619977901755324866301667553378815917415278168044577226312043648914815511371255818816128587624654349070505963550410129613779558701/47355051681631287072791267461811443100962449992828095859184192912946498294713073200712206984230032690799982620706369594808923774884093091033712,-737552069305747879099193283760914497340024747821555720009975156965840427410285154952031932976419135828305661720982312706220500055797412252377/1272344358015313402416013301305350070169320132061555437177795452639018238781676518238874818273416746465694292115662796198525421064915117101554,141064619172079507338430322529246211609840077908421964055554000168927578828094758105068734753331780532190838574879476583594583603707309931471/480867036433456354676431134272978395957981249927741866919603955667304543694012468199701994487356694913612103269838253052803396248946904880960,329028031495945076535147750780111024827093638743620654305010892608847374387743962734404476255805765434493144099614716373176699565277951068139/12327836610401226349776719878288473822406747725614545231442860158833972598927245584526015143327369504255287910237485475624493698548037102546816,39918612842499710249108153427344985818733844787754539142072646736370380026851712559696118611558324398565915202916071837647843640606109055247/148043837580834432578687229481238125700352053459832694773654042196307463802714157766170099189587597836580072779785022441818741156697047174824,-101030268821040116532102635709940445692730484428001515069023433625818320743429809850773002635047632747712361849573120246669266018925343072117/563689709070755337853276976311869154090524746319459210062114659061411500515618385005666837062056716714805691688738384865295213516588334310488,-110886063569729767397446440401123893686955120535735887774090948291031663005600156515965285789066559468413420368327733217742581227001821820161/3331899977831436587857752082099939070300001386075868436192445081634207728581769409111901388888527824705894820180318121088847981964184513910464,-92636791901470202404528044221781001577975937429977383845141231263167040075336539321177998845866473282157090897317988424732242780720595161343/90398571049233263259687520277349730750863841305825603578074682578225667665361237966673495604712949777411244573060426042472703479644926959539,-1679582406178145308096012883198402101609982549869531258081859688684441184864333499182470986843080505372712562194833914668706966553632443401695645/2880528656608147548228748514066707948325733921319778424095240564359189641103375843288323268355245263996764814949652978360595629550341171938572683,-640233897345117567493538478879126756537815495535227320906233569425249265534666294643564295958516567676691262839493511295537291188408086028904/2768894647098337874002360446719213982917250652478673284178646470109874065134286825077038862920109246653477094815427744329408473441337320167933,-205529638361832840567659671557392033579251098290617595096070748866804509065904625922114827414357212564009412599350076579234371836576247391197/925809613032587235405077186576718756963391792220876845833653851871011631749922761590827502630087756735697035439796601610509878074028430516663,-8362403056186788859412499064956308589853310448392765266073224822771082399453865884299735884035790774770093911349323210583998507273301804269421/23493110494556749591190479964122124710585571477382637451849584924813505756048233021182832087837192532881475370679243437606706608779051753965219,-17556648927378292728965796524041992482706766925952329936991379391957360615437624377260384098380412741967959218053212209192361438849355308998307/21742489184532119788508553130321276127988596833290633465759306398485537248660458107778650364664499487282111999987621924685479097990415543425325,-525694120383603202115590029452239772063276590560581865771720960402901219368283011620942653870697585381137278424901357147065953426881675868587/765216864349626658679174044755756780016752809403973474069837077254393638697654546896853952657436108111027703323641928856494202451497066647529,-30592774252109954431332527686733603793709025113715693510779059856138320828044708871989810197838180890066589599991625681092623929118955528227043/63848449924883243683905040986891866204859862930998433778098693977684117386104254124222334894558001717414502547982063412665193445001806771203448,-407408922529672045275800937609970453833399858996445619094622485545781619642930264610904951661975981849504369859042086469154994058529271266578447/534491502145551983128167345419530978559520865093544361692909738014951285176373790440175888569062482286652803940099302687544927228170298619560244,-5723875342763171825093207202872020438940304564226766934872981405264671567692612454426502315129114056459241930838749512833259970315104670060821/29440082186335968398414041421508578579922043631168953170405315718167828470722943581533403661167177518803235844953514833445401898581487239392075,97030966997472085634825652424008018221813342204256415242837434637663331731279360646575105051266762301866229019357567712276338333113265633649/653448862415310653863009102133810785970817661590998220926147429299021828959641919127054425945325323018247046411874886776230221970465678002875,-1102935135083582806776092730593618830619481569077702963484526640517973021793838506650953377293536458122529995868951508732117319972155473966723/3868500325757434566807274639364240731694051090829644327335100434049301638065398029242153654943405867411420989112529639314014953054865173297949,3841035828234494371449860794226858734848395009985984305802854998892982973739602837858212957718620410406755151714570817317582460262212982720882/14369004095699409400887728440541571148678030879291778694909232231747872380325359838083704201291204835901501720032550854849307996444988348976691,-1533356420960903904409522065533827995219587243260114838509341799265740735508567531373444922795652093046984827956961083479460996514424662709379/2593300603034232707053107054419279005853401327350004368206726661751560312257268029043129459180315521226491518768075273510362655730147214533044,-7129833546612030863488484104080368142700261054132651770178114732028342398785410370503703098736041546188984215231793141637764693979403573183073/133717923186097573242376368270667844862760519870044774466752750251666821116679087932264546842598441653155094766589494813868398650164467638401176,3363730504453455942966479841063366811931988317026086831001139608393248634880318716931623445360780490324216838547818771970973552872969807637854/22976552107695084705419414861883662193160961777681930075138056585775075548500889421508787710989315906766021080177917945211306985478802192267589,239976005859992814799179455260726946286036872242182223425976294637561338210728672215068417838638028436894462635786249022324231796551347781449/391743521115127972661917479813827902191942442205110691388149161505619554275119226874196436836454290462897068967575931984389740284699445822952,40539868362415864794528946372808718382973706822149902246989079834618645610695578115429736503959164209444991594950257529897955516776184633780/99821762932558894494289573157562724037769001510715122722952937938000171017572851681572673636512898975508112505267624398413748551835813778173,4167537315772689815277010866237907411444014418714595360525201219262234927639753035165756845883727111900496461023252380372115079437432518385/5473559577142436859709823362401849571222132521821536997724717475906872214471918536875013513765570781335810422109234858299094512290580221232,164505703944826242144927750624650760008994045852646890163747039285995287972136101624261640861612904338272379479044380105833078618614163807391/214591304963540515889078482263630171074241939928738589324786386313650723255765569560822086168389726033644674470185876298199030450756282374685,1891962313322466897283244778385457084169327267443584927905920146962266501328054083348910731975937817119915341303871162181114511277898496107487/2349496712421256250243747018928573058478881126438043976825596781004744904364133617777748820783162543019529015373631892597640741815055657249003,2236315014862774936991879047017639110699097992941971195666757968957277432495867741186150536017169718313274630263311621093118195332868041254601/2865229669633098504733433351755236055264970482982274259925417689699149647994978800553459488425146559164237931871996206327484569738419959881108,95146853132437825206103394506025681099065874155713010028066767784478775980239224185849206258018101376551952615858348465466484095610711524203/116524747075506948999156586160740700759022593190176194927245169366567888094965817414658572884552452679062790474414816871690439168789195434522,2041379938437274732336177682921983884166846574888445606092004477462625133046688315578079079925596346985206416393845362232746105900626594251556/2466961611034066745266147143517135501911888647810090997871588835960210625036318113031632985771364227555047986307346271412265945675972353236769,4240515383496808513683306317549886711571391818472386391554830781925946522673099080957453403323187042217620704817321608702566374944656163781997/3896715132260390820033851045058618529306491379388921359370110867196994045194670723874397559540990340611816155146103329710552221103023992383293,210078334726683691821596338223401180014813642561361986424465831865411224393732463423658831465563281428413951353346868654668595704795556428459/192805668616378600728416878819061787043302593427574878092770948973529912182353214219684346419656934438806598713943954151206800120392373944524,13125065285916749613426425273461462256235505248698765780945716415705307415313429998110937273123638189903309396221688579933803869251283008299/12033969958296122361869437802227605793314479745965134923972880156729255758281921101228915826881250502993917865632124239413181051067988016235,1288463082426716020205000753276123663877341995837253787991700363592893094031454981848852566749285968016157014437804751010299596937279828929097/1402612155341472260070024726696348045597818158212977903308607119790871876900431131863346220797338496234464207012353519884850298218050624759524,14014800142626637769975740927079353481604209120891066931878539366700727508047920467041741653779216760550455878197590946655268311246698495123/33324309256097162437761439623468703578984395897658677383822824171716713867362421603356189621096506712110378221329139081473664306397109016403,1635356768577870052157083595872767412414084590763198541203840805076132789271448665833427049346157178424177048780831899211994932289889809549810/1705946336972028903689751366038583508530679348164961877265663012076651203130822236926873211052923249333883013639641044193791898910117697133757,92805141190788709403127126209276957199797981120818418439895121429667303033545660119564121343697362982956689392452079605124257912590209508977/133657222640562700958384277528478217673277219945421134359961679474448012657937027305734866301498969594055026936458917515556128079966596609364,181633465189550555586270632253091607058929611014165418067008316750746886274733497407318232458384557450490692147759084008930999974038759803172/339301032216318764364460314350255317479707271166859358742503332266203774085129052503911113661051377502652172339014527253645701343544819752587,803613360028801831383739382644639036023229141803295457169216850829923000898786559658900665463579523904155345435894842612763847803878351561621/1047579402023129044197048941028870327280761800139650981614536950821620879093843772532493924821405578995150840555189751037223038341311898139148,7909846967847252452447522637078765343729190489030797760029184418539472791862654320361951627034335537640613296171579544264093529080111745142/17241489275800147568030770080762026297001082045816154128280674643517273604458811732511640319488468891610539613823603144544878050016342539467,572630754694584188321363712464012521247755947937438732727195691220244842034573298464923323733309728868592591550001293511043237616560437302447/406231444773317954087207942922292794051315217724505206320275174168818540829346305454721591340053289366549806292118957381990989627779062249934,432973877396570007635719701604614747655902525354615457112425227010272315929514669197870785358722558379368390413488276559675650091006069652639/268667049590048059067663965127338141586461733556107591012544841827686964717350910441256409781678495497369513732479043676870164930508128969854,165613965165134617061533361037946207958613712295199568001236255923426288974639247675985487139064710628350831691781701701821217486666309863884/671554295952507991179545268980623522110613711748495987404805193409760586510923721606556109508465445616647243529139487884183586691956473201449,85414406743743814028433682820223119671407919149767688285761387255877094331606850320986951960404289855313890130045151934237794079629293482499/212738696507767379166149452650744596547625516086697807127306970980046613695075290681578270784680829615366702690416992505339039008864064724115,29503517975442878543247606358721752146622426553122508670652733595255700519964410694518199397856246796668180259505480275567608858176116577269/82285187970246619749679482802733729203152955607934914914012902354928984384996355799216152193597518714619165280723787269104967962802700281089,142625525472876931400043506547584047985244664716083115255614803790121931548427860800520490561774403993633519725740105355682235762676010594050/362497363577434167952179410274769245411855635646930299538513729451279988478639088393166867473477007773096932802467363366649694719525794881847,46612310270483178998178902409341764890769191697731041149047567732095404715967300322212850858958925909758828972718590319921791090449816644550/96611722848896038872813911431387598563627600533584512582637257816222624298992447006330562052429633966198081214043376916611330089196555268479,-41624479609501528182872957457743733788394121095552242201308494243467603192376470879277380952668966983160406116395959389052554381359597161931485/65467955834087720906478857006813210632012181814664312338694151609206627706248320978564284965406823513876899160068272423565852661634301078709296,-278114892288076602958460107264394397860988863436661283315077307778756744241410696518509310960923721842820742683805337577503673518872651004379/762052844819845362203675420128353819026864059469292661353054649863385579158414453806139178975472738874434436050576621442120071007045015703752,-66580651040527279054640008194392765447352281887992301141225212448401225189445755621828060606446770952081373808098758605019890672234583128102223/152925504593139455539864750713180791504584903012256605062651053282534813455501457754147411193841832601682572680511973015425712589335799125040128,-166639111925784671429857747991737103177112662007180622978038778088863910325081764129521121071761475681400610188416158280632383023324286412379/207161407220460277220728016008083822842371881220827920101277831719278510159728158780627414585636208660245893417509488730459921589637900817905,-6836828571729981996723785048863336754583262294439966917511666722987352258185520134935363670109935762420876049248729607834061024461009770479913/8416149513413398997683888753138230539139164741193581340189388045590781720043341198556315940855221756861873947151479086665574543940766790746065,-36350435664394126104629090336040883970156159245407475117499981342848703150826123327005907865098657431348318617897891625728430721016741223267857/44937488971924399035280667994308390966600915993388367215483050709724195878376002198712393958500103230977001997504928723043865845617574308826743,-342132227793734561827078374436321058720412687898390867467645031498136463719353473873086497029752904539873702457813109090598760651073531096103/465823267669489021569309206593680790239249367344786069501882818118129932168316755662465093034385928704754930159976469654646450230726548457045,-9178327690387910881605683151730981818827116910373482414189072922284112297213337398980782026798932624469242365935692794539043537002097282198657/22882513125556778997714379060263806519841591405026579818352140171810303486516565018940376876083562187343608130363709488597779634967006698882183,-813699465186700015911676843713627813096934257445392582486043363372493297306576077921349520408197925820639994445398169473619473694708787787531/547595862116847369615009972868635663793987520041864081435040527798656318172068550084554516804186912007133894868332697406730971589169546699741,-35701102312597913821824706762523567749294298753872378781566633770150170370478963880880297436282977750300834569653767921935433769651876778300/65684435445310631226839802188791395207622379383085988847860016002853403472535196114773720992703191908874213574371912775742265507755460734393,-767152189794992788588628833902025011016088594523358876123595316456732609223498301031655268576017807296839246678859657109709869971559483260353/957381323179394144317697383309467260456865119729058756865540198788131431467861061365179872703574448567656910161443133562613974954361275757117,-26240096587170308055363282911369494272243468666073196633278724337378148480135394585906011808617471380530491774234920951961292379829554615899309/30279582936516255242070493628109761916395693364834192686223633745908217560979309125265717567093961319436596211430827743682845848911835609378381,-24375281916583422048734016205044049443554028790254566717960312862334921447460181556853429488467625745590687345217378883452342861658712676150651/27922334594175441069034707790484285380082757846208905796354265118262771330088422938769741584520960709665585201147906931934644937812892568739519,-849720027601651387211651674635088261538912947567978485227911848370867738070155498392453995565156496937707506659125592829783397579100498585067/3677136287999429327991452379256520331218759335058448127185220052134249175023552970799514351157572118589644419350025190784550543705322200898644,-27358495859184319999282446037025135503332989053237054960238515091166083885825760988510210489020392297431236138398776339657343434874731056235329/128044795503614724868178110912970041298289142007829869971757150353720550368776181374667366954991321188458720072128438443127951611820747295344672,-1186576650854393942828669478836668762226055558285811397395828272811218568885330677677835785372124499082987834844678925344590556142756203678549/12439901314578720759334938374861930775180445751394171436591499260824308638963040044756194690341492809203966008000071275015034209454289975349472,-8270585808288054252089184865197072483288604223554989940327786011922040199820773970831622035911599804546772380764485811282436718448065812595989/13885016949842412954086514823606276322369798912835248232086825585651222794566637591081682553748304676923366060405201508682414787638879086736898,-44709522939166325234743797646088445790693802298522379295689719601246934280357914772159816862243713107331915397595720903301917820650486110213/83189689702403809666627804295546551349463302562172102023986361315079008263531447135617520434922980838989659044393682561394455308227204235162,-28440602307282015170421698505793474850876132071240400484136184233295928090066244013260278347741556152380501344560080739827913702022142781749/45639685597374765793234953475377363412581432988448229341603753625720515320555394991241826126492580475327363043849455198902726212836889030941,-61413428658738420551543758827879323883081213309179481308518937171744024129298904026866677396918638052354375321672140807614160569464456580219959/97594760438117627707491285648020350854768667997323821997280836649192519816168778773224060275053917626070312729037978038341057274450261651339364,-4304240485845633604707576631742736896796837484788514954536178177051408629123332515588838106651206003641121598829866752459730284329414668220007/6467798509205739887567724870953350920998303975698329452470385876631512081507214176804455367652887738347954417464859252701922292978863110730147,-4638899838232732184265659147952698806605844480585848023633033602840483537480954993554172266279216296646038943154857398644857824278159767932570/6962572026606739328025731317456142508821089462394293785345159210561189376078834945074420650898384908547563366855120017038458030090658445239937,51592987500445688835438940588966324013872225573952081653595664110197807580856580858508508234519125130121851181699029093523143403734606836165/141480337149505897498658725949436221847854041699518227246912225153339919417834939727784166043360582642469172992895440152517217363932385356144,18610463105520377692155708725210940574562621565137234056896160255089903626189899448803036471097173796824646587285123523066371204835713448617521/110989879841845852147889195819844901855942705151414107563823833896492574139610441235092298529761072497346638035342000665675328973761791746578112,6081505062830552471367691089245909888176740339724497946770994636958682817765881592950634529371483184646280878068191511495839706978950493305439/6697609406246922995134041882874782303179380077284675085737995507583401332087886960889784488216152807964048911171504394028113047489968987853888,3819543997207215391424472534790812850944430594703011113819097890606648151007989623247742053254933746138733543174143844188824373737867334853867/1626624454345517818662384579963342339262957852830239254955572109380686716040078182800182152537990151427302974767342207054348397612302610188160,-2049661387799527838511493066719645121618053079529717427814717920736438095926295190283200306754283270324831664127753911878178986334282284320030/2455962565594654687668609223702078326225991411681447706308145544895475613137865179138236860851610097672460791013056004724606103952721425457319,-242488765926559995316497594581792259101828334109386669501144825719332354168747964917130244498359393941966977880636327895967353875879538743403/236403784414439225067042613558494911135942099875434154117536337140660466733688155630729823587453629240194383117097126735157908420862582293712,-63510647907563575019349850832377968217049814504280159504613721913832816655508343021322895275725372517635343566808233278566899020273647781555/62236976559420468985346053767463448329355294972582911235877515356265432934513883027219496355582852219109428115242326891015891693788085879792,-252212076239526748607038217479339014300632609330689501795282319019331976612609845221667508372682745157944988380516200736588183337162448369229/215303695159467118837449973308209068404001900945014873058158867842875895495336491384867486253241952392044884600695638579634658916088835169956,-47309641557519215882986305134081933551133225764303975158023583250927608531120387881975794143444169168945444841949435971093343616020717300044/41406168321882012549789162305094922260239711426506662365897399126951622723900248131713441808049778918156934437375354180407447428881504549581,-1728754257465942727118195944706245055539790846177552073960722699814340597826046972562156597587071126125886563740885624503229532511839385796447/3400448918168167463074922780344558313382498151339377798885339693475492938795622279747702127764844245024859230600536359164404509144717629132496,-365376034961779149436024925183068333039770000134843729180720620715001618690661849205025593804222863942614416139828267811890885842823316062211/968101724223049891759529399392779550427341997647070623982053837835353644440110214967559075067967913996801217370821138187079225355846413409088,-228956810729915838613346601880517171356902789922941613731344349364420560646112494443896999584754853397094925227418747985112549877638543839793/214751887369933988692237651069413560308659948591224919031713618630046864998155246193993154999280321334780561287174867438684046194900866885287,396264020423554579251304279566288723726611518132792233875920333330886357494853459309611873749687944629593087319206613275334628918060806696597/9991189007958434410785795304683044602342378752653726449995392403939014954993826478235659964603515847880700800665416320777318004259603901504,-2190644081325152769765507941785238937122766012519264490523829148889834827187973236146892094159007279558522929643439979925432533077756904311165/4202164345670852119354090899718634782080066155382598987681122633928636260871235647898593742402651123857209852140034220132938534432452592806464,-80785784410178903934661188146555516022878547090183773854167577950827815392734592003248652501607075097175457627739926109788607004584382057650/154013654981591238380349420505511527686898282953676189163681010195451132020725049457325077575154307449985902378286927520920886005381203442059,-139004343065556125765448027567899610322779774470464892898433244207865156038982699506876111725793613221309515235963759599636889284576855972780/265272761178464005730028255858317153620817371131308597239870164704254575443719632975463607367441610285978389857282394558838754836840715657031,-2013422242483423418220626086565617851297766789017589683258437049773628898468762913690377241268696460377346644810448473483662538025953662262628/1756965227787141183824705325051834164022309080114279477961709618502618081251964230533445416297137707092236762212221338682843715542892518834583,-1164679245739433128411154332973994331370343391452331610906964077485039236199218355842503584216533815387135727376924617360986556069724101858503/855442336349158098745439619986797724247451208116630259742258634430445224859903164586208470464139072622678788307887902675896693457528819495788,-9388915641912683411946142816337294046490334987043760963505325586206786305032787849908907005673052662623840369586981967874026333323643062207/4230016825732187535321630604768210867275779884821963621620009044184556754008306986156448102985740292392669224454073189692459687864500728073,-77090509596876153735436585183961225704753199199905153244385241546096499670925655144686246239968180513808950269797652822453244460679487166078807/69948977307651186113376339165587027189230970158748735180749586226245246023386063086874895774918123347494837389531230461438868575781104550367784,-48686189620396290088070148150490404973388541284105261272948422019472492158283345817284546012947963468976131942480330493873771314894737158012679/38463162995000927427651549456048471744132577203964209239714581770286748300203466865271573947544050483251082067063855941296333804355794653027052,-25218747269032290739341710409428797183360900526968399040122433127304929636469662855113908110935758991370375760742909982564630809502694634076717/14747214503250273782014945940597104556875888795107066622602600809435029863413719197780171151056250366458856787875984022244049518203707742011921,-2987511566135209308376868259807927558163548671847578804509572295916895000667467147776146096087923056303537982217862866239114982043796270760135/1746075159928631351640818459033829113480483105119701106822620607125030144188173620423923781960249689796545205476830969411766399971315569861931,-15507012747817410477634781105346148913312654447521229094300024800760851288915082584825457107041688664740147877523975445372792814746000096312653/9535201187954000594315570807123853774121987365086679668259035617371422699074305469757917303714969543204152900072251693851557927434395421807428,-5979908653497201215604482290310612078092377027131046306249731291983333017214330720966229408067225152770904020591038567343582629882443451838851/4625431714958429227833932438374801327683224178081545444265090767831564686635476839146371127118923855554619906190034875023825853521729823647940,-1211013406427512478177671701495065861210935465690926204858565556365770815985133371924483807481714392289780109559410920243712149776269539819753/932670348801146850225579212099745523844065027921903291315063274012352363032508147880572627923957404345457070967871361186313421440816433309705,-2143720576593097426096821338896453664678687510120563865944632742936739331378986004766220437747572797232102870517638759719599816025369261686277/842275946162778679786687500855489178963017225195134113508377100625854333208394903708433805271525033389794957669606081088531329496516072486415,-238603507399558880357720661279667371968670287000788555841458735574568481673631247189385521285048478359903346533368659830747711391073615191587/119679162070159637746720361439954466484305952997789292139437957443200370679579540971167601435690580831573529871595202301628883785471123740463,-6402069073237045395963219214621395593949762902777426113096860909613042112296864869904360357992126564117498042771917845210338538550234146910083/889225450274012651010750438844167499109186789473616192288885670908464708185956850930522011939598596509010473432585159439818597852666283217205,720180878363704810905823045873551314579004691026510353631201024031308291290327543047504139395544579247796813715697149478504175199157999807517/570508479347275433569307225081846776217172322467969460430476883265251293302288875929443864702876407909503436559390034556529594608441753792416,5636761431277510711819224446505751990652267586243497596370783624892894848727389305818677712011361619416868024595276827157270982185262727927269/4885023756213084162257828618225925862760595879522620124796209124934077725437256788450084323181712165214117981828165076972438544123917549707084,34185422824733788401188460086899488432117524023167364852247619740955039738019723500957784247271533900792294166590658466813571822466318622998449/28951376196850518511449073155355387146349789155139962146362016194953874954929098676720445339273621069022956460558547800523937027509307181869664,976911585939736385877165463315695263631877797333279704388703936046633197428952593913900198122618834088313099596929045938476845296347441417889/773649898526523916820807791790558107159479090045025473210178945202341710901924752758290660505679327979925162824391870748269160215478092615424,5807391186639322943090911308927531637546571119278374522127987754317641838396824079839856904652062487103641081776154021618041113838681964036053/4601231370283848568905027965150418445624987823302045598089124793147754858922229029780618195426396162535439956079744539012798817317713600376064,14387760284746560084753214936148063359451379273752141525224897305739418797911936274019581312954056974361503547609161424931833742425234187055621/11382984841830903061568613596279717823173596937418353328781742587814002515664074012995379887654325641743297168035030772868536720314551232889088,358581433423137140336078917179090227971582201018916924410737586379413507390141865744982815140268827874289833970363146177552998219306321123849/310859484976277658722894970476932126995299750695007318882819461996606631231518975528159898458545456752167317392816644116104060226105338550970,945834765332453665966596677331259356773241767189459306918905462594290392872129835913368236029877420358343358450176775185379322843442446097599/724225660299297617765578615335968249002757513966259431878400384657451878906253264337025415000736888453272555525946495257031352090841390818364,6398437687295657071808902936562112237307435439794616923263102435264012531818154134586982301498129018277802086848198818861067842639933509351428/5030523479691894692579060442429371957364752907516747873427061280622924012222101172357136317841122545580619779648648030237986767069160180262345,655016840633152250364042472813648414511126507438638229618073029406448072719806975212755267062607641971503063906706282219143762548020997586264/499176754259261150146570352517609283250713611829180309141295277472529750302879770014516157296935046461047350391517258827586487779115738837129,1162551407738354819455094733580277311920594633352385860605032911842648638235325226807916989416393024737883272684052616391741024897248876989842/726339087513611796769778216925603118053987100821549714904371259865181558779690395624636124377706510878564371050684197663690857008287219473265,11509837021259492270626680218424816035162512958626505896274100451405397714333189648932415250838604660887637116946429754242603458075070317108/7313170253437455404891701413412476310064364415266601727980495354794918946785063596359340489258525760409693490022620145876350116919433353425,8536452909841268478298648786271255248455110269586970735943639749985348099335284702282539280469441950568536006914605376462041821081340480880/4342208365052451027840967996518952651152173781714956611197208546620773860676829603087904237117802468240597503207763221796303196279878508027,3356509880728234647511896195743137313398404165330242383590457689633102130151769784100769789994866254015991513924349127516799020648048668039189/861422239575293213234888698697373027357908296159564415198212451076664954296497138184669938135972891559267287814638828229997156431385738798304,2095463932081093929789330104692329825743640927563840760111157144061777392252622962966619051350014484069168757869269016105519262327684624496181/535031523190468731538677298318264405642262622567760283691614675526369643850058773431035435760854278206408682135560794847073215041751656005872,1784770365588493073010276726069004400229881324636944350898253801874103005957635010072236636777306604034497084255191276217795821604677483084791/163370627212417109895955786787301094593459464011788315534098875671219702379314234289499506742212579766360155517145075399861195654360191263956,-4614954753822956400692712335028405930712200505349819456480381267278191894619632972694158506033236991961852455313516217172397931707675728954569/8423726784076957153868983490477208684828483155644072458455849523747453766519788621190477428728750541959767824916796653409820006503744366021792,-20023720595437743267231488997238081117831249048792021147435493276602807434971841023490434692670162570929421109583777791681925585779963134822541/34575286943058649708207078274483161458629133966988054427801586073188407171454428486905442126372792871572467258015569174240165480414125371677424,-6059236224193908555881752416607940155016147266787433982416360193838220513806241943768413589024126340736648578493405027823514275754573231223455/10033216046418502705535152326227462395836780113413738513235010577988769898968149191529613702247193578437849486183557754372279846470309844369064,-752299847589181297247639164157238086656142448268218618806693191601192202555086296293741370173228624534914278115399649805739379135502054028933/1196388108702907196356145216693923653270690951795585430900739291672839512541396016132226095991658064462249917678925383104167590646003968320218,-4540275980844763458981188363018624065494618773764027185573991737932985840735974503214633398522256944139842325163341118895340182964440514264347/8414023565138789967394762232019907593604744759748127336410799629310259670753002156410673855983424783518999514673758734968536933051207738308272,-165045338724497153947453289230388098383325836803609282098085123285590769890853775908606788769009112088539608903852230144339334510361970988013/314219517530280349058770634778767668589414232645436640666612144098064589775104223992530655062613039679563800209967417161823423084119602255992,-89561786084776884884102644226785388201202260726593312225166784525590908837993155063226396412630099493315379078275389621849738416971965767339727/149579412741671385590597099527312388343088426124558031092100115559963978741061210632637183930593403702037152208467768416984828978741449484667632,-10032598192572026903780105559465020377854708715358102206813922084761689849799267991247508251437449801407218689775737819442564328483240631454137/16803723592901453112547280347838061107341740958416151101635407142885199398590764975790426050100643825421121665226149522913217508483075362311132,-1451827026891327973285941929346257591478184093605158693599018929330015165145061734939798519710867221150554594407180252513747134026572934425059/2594579787533467466638969607936789681080397452629690411972069399450511790570803960465172795939592398796569918452836902299257048776189271695512,-13253769850904359073241811850768017388773208199813292592173227710214159879315976929979716870444489792666072601578814984385435767830553091331133/20524771798419631698944939009091615426522235656373682477370452585341932488954247806311278673772380751412461430522453010792732990411000164567296,-1509121673501607680702519994129202596129316594008646321361188696380785487187203374519478646315024246063235952132838191623263164267756756009763/2200905699514422053600286121950427475099840294712810327307538531752541921686746392632255841271613973655696864621530494914628565589233410534399,-9811589876918706761104206199778895164794300722487232995274547212856725948787850026351412096798115510086419136493029032653055454462773111159427/15362215400682606932208924124807732332973773219198360104183085627271123437952260817303879261003065214273698664105470506385873650334268827719322,-718506434298375039650078295969677506243310031282911713578102325246719732325428338922274536530606095688805040728908124152109055495281119269836253/1098366825120008358397209851291916729027015929270758681763527654208714925781417498178667375866337165416072338717057853422752054308225893140285824,-14420435520118759185991690675336971010816535688340297266990889085112002683344008006501132723707155602980308899285140664722872317576345648022027/22157989719600537425412493324988444176849056769202745257333788754396848719201653672490968364786451516225603463761926928801769415071656189917092,-112454096154848216050772887180113346842139903763592058014894326246733223254781972973731458784629148468528799314056110706644545105627389586559361/186382362207541329926319989163982802752848807562072334185185025514813866368299789463350832916799654266973609843082686723903182760314247667453104,-5486255545813580451045054118235684153640392078639668303539104742367511325777766519017046772663422157741583971413138810408775128024811381259837/9306053141447709128406441208673078684170718906447149604780764277840993538052933700316048124884488825930881940504611564880966084417467137540752,-2743223847242472958861106737057514732812148454557483003466114011234851634655797487061940707376434612850926685578521276533015073271220515234741/3283697829986830606657917194545009747742240536205845035825032930899728918950094966673934882568823190762646199742386711308602861578162743761001,-10678959923191270409361663590825309438186599693112650342037707497282277472455717650448639525404361192746205652074986554784439175919687214209923/13076941164581886034883878129218516368981601805215338629023438718221081570566964019586283525071401252966126698958287897253415869127732311392608,-897102507582299737489529703933812829723233761588651763314221171290903717345549874850364379426067997397889182404861958842336671823276662556380/1020594291070160356495118419943955703876135685999232487934182741318467142837415446258071347707217572707599915579404653573103993367292731233173,-41860426223913022900872377386498583204817700544276838597918308473286961307451389053855559798013016099383648566436741660206433448094001436733579/44873145480536897659563975868478047194045436813689883530987771182004044610538434387154602283401578257226134857632412492352085407953490160328206,-11599368750719566710857078805337990523141206145406605506094855060268281847710005731776225267546747934921897600832642981981445766174038452800077/16938116538754861582398944827906266697154520306695373848094278785563941648874896089411477601275615729649582471293763134765456451427541417910107,-961273735324934913595692672726156278791899562141454561372896256468560016389403963075639584495516326494366820311523903940528658195945554475179/1393068853597951547781501285247633340450741562867082089347362963055760676904085156836157422447291690387041465705449408941364172155427452114587,-210445748864021393487683438394857978856081595992360104194316443804219324407110957274938597771031861574148887058847658375588402779527206080615/936312393065489789929646366312499790740947534386160271953934064689969400571345650311743712327430228503629568224181779744578940600888685664,-17159056866454078703696175281459052630981870166711982848908574250782002786276767332070149428951678341344224795955243909784445730253126374443871/2947384210775373575527376612362215084511949011807638566589680937640356680309713988461398765092184242279997746515971572317353823885459271249366,-4577365668657997769252098354939161656472008628228458235302351946457014496183345966619486572904960808144726242093233183579179882966783830684589/4974719255883026409652319130931051065975618549272152322387837987684702345079220356160931908087487264909442843278045637381714180684035662673899,613693104083219729052530212257035599943381696428512134012153882231495498882983058622964401958651457055994783813148918384213973103344902098309/478726040851143349740644066268470369732886749216847186046185902681260065147986367464115101728956910075505532625511136495031815518907972145384,-1347469774900884880236549270101988688030941225657283101679107241966079717249149368554706696294104039894814286143532782514649599432088334011493/1870487552427963228655196988248780055206465900411975123452760203036540159816873517980258659952085264483763081181258044489578883981801778602184,1004912160166978300380923768345229220710439027974457605645685476823783754453839811271977995055995856375832852027849354926015548058409457178443/560259723632575568273853332739294045589244457637468990243272324595727480210388784079739304522112425599707921603261294666001984223802843417872,10705911268443559521537666069473871316987140153231681815883144521255442484084637651229149791502413726254571833988853784687434620252455974884/10766352093662994256606102023119751782841403439238435990001847399521933186490956289538199282027985314427270701745898682258963079859731530747,60026369117929877976975300811050665812097890942801477651776712815792715800496962920611603241512871432520435063771378196216668679777977990143/34835422375626375735460979304713384048349400138371552872246504905817670501621039504582999997032484456887352699497963420266595549156016720844,-794655608923147232717466985021915620020624263447218825295060985384592447135908094902797399229025087537457879735774890473875456200525476989198/460427182706669670627278301397181447024696461215577506125085492172773847683649857447971475129041863857583909356274290323913340275842705939271,-236793532939006538042338653005985389578379717349757567137732421322756683184692652168078070278816458740160895914870864266659323593015294993687/82871411729147485428935369370034974847650739314327194272735808560583408984005803626881844871216949791262874878361101989431169758385007478558,35585064006902978376866151032020276604366796280389658455627317384878753963683747229884229828304975780542832334163021133545830827209125671341/35889926735140857337986239883722136457294559358618820587436697125958141103550119873082145857738042362586572673422442207516861416969335609664,205026146295348157688191217938456719388582743305517583544648850179894591372097787499174735924039081946839088651930987177869558574530856576711/53216072825338960121320164904429020677295944503860506350574474829540393794833234173518025253095496286263023790278223938730855757067921035792,917317752903717303180169382431411967083440739368023727905278697921352107101755174815935289399318377062559727090225441981144335369984377425/199183824609720154943615881350826129490782010440878453231659148412954829522235272137635889536481939576149238030452223400236633181904407613,917812410865397693646240696962800635414758283650193168755403768209249710997205488116381433512522910111418919891139065541968043085851988273/143180979341201065761303593928813278147641283024891216835147971715746502329564303807333857820169324237922076658494209351312494125126428276,92953381239744890691731729144060718923924857182211536400853923462346474478118966326974722401784179370178626790100827770099697884697535366901/19663419715754149393404006495264221613416145714904188876020303381132404318755160773153568379318903214401786123909783552649710737538663113250,157364941630615824748271340264547088960005970917977278339002715966012664632723212972569059275375172583681232489158519484862057101503859599491/15408892888723307587889929896251741928630970856507248666028034360803647120785134050923797995149519894848613642516120931558213465207967953024,782387917980465419507281952681568779160440985465638575291257082655382067564855034627134602304867502848581394437250157205996985434442805862371/97418882463866687413624858257454604420667954134672130455231705022578213991994688531258947660969201737435317973012413865010339608172478897056,153766095424844498395637588918050359482735636017868094797929470265055897540594845676939777120091667472109583773736144357895136438533477003073/12596080783461055027841346306526976794780294546153054049452870633028518717817832791214747353417089478457990617343058971924773098454013508576,44948458725353547547898496650261717733424402804726293423278151788879453266799497558537434451681418465544282178422001726950571732050888994855/10336925265494710406366257686852980844759403386359440083133171213634665502088112450937062475530975483636716120711665516084213821747096461328,-519432547331782460212446077135452973294994497910569757052506986474531380785236724793583348159542197868565085181489265867941061209988862770813/110870522721119374099763724823395171902645446437756251478388418719981542638526642025486090600468488293863655346462342227486174577359704871337,-249690303278903177701930287299411940988821714204949974614105804463994393719736950144058901676230563531994538194681580846614448344539372522475/98192644916231736405546341060743176586003343054800461170905949952891473442472600313468908894359477425258051061197728833112843725500424654927,-1916694391921375676827832671631804569293115008275781669173589737583518996289620509238210864151451462222709095636686310314151297922288663866820/7367329828243302568655483477622484190504375340585665143713354290016714305566149429019652092171338949281606236141695211825240876538793039398027,-337143006259035204250775742493064808320391479540913457515539006864046704366831745252809841908854039576393850497004056770702354659026891020819517/1307242702325361550210537827277096607806666733648014365703369786670604051059307619934380654353976210419372717402125866683273492437948522212976992,-13795578664992790375333334395622147446811694475708383531701406531205301559712351407754361405861617810737530732491297399006454133567482440600307/56960579005741981169394843101728460568209298700799019042158869404979038343271379266201092152597299372599825913307488400295742396618511397975008,-76851189547316593843778948681742145343223157908717212938674755567981712591504640379391123328170696735476497541868845061614531852513949737214290/169940321842266570859990221953265694860042317322607767320355545656510117643941573771748412169599701011424159090065799159857074349122874264087653,-108491379472421179266750060718745174516873015208478136294506849601610059662700252954252523462545734961268767681701244667992560765261320411904268/228509037848719841817983200082730979835306205714642073488055514030930743154349225177007283202552233174206326286851356045722839717021577063353147,-107574084747336118698935545637648719353661823978969240495572209770390098503429070791779733195291996788426447695095066441427822545480357258814172/235909206088905284652279165343159369079234150222284563298282992772508475541797012845614896876075333244849084379418423375604081261322765711105909,-1261931844796495850208800337232620417117189338588018591135316522969080688535266593631856315035800324551337157647691426374212899134121701828916/2870569644632863123896468329050121589688586622184058430091682691546481738779199987119459101937283562063146787925160404424538650924078817841559,-467340723975926819045704813160910115587573883709216058034399351446009549712624494731004387771055234243086421403210717280114816984644036832259/1619210781509038785958957392463192822091142166890262050156393893456615115021233028549097992876585533893499165258152769805459502759739349785776,-1518853428961247481512291275102764480540711889628688409524437077809361828858214881852647554949909636952892212012270712771739611136085441235961/5760323931025518148118469639888906944832925697811948054666149317497803364395819978191172125338482962561967870667545700165308683375085328559328,-2927545951518390978369666408226515007529045106651943259821878608271574341084781909747902104520344755758386266133238432722303489968032305211181/11052482097764208057403559926045257747158643494745443259417134295406372122539260509428285725255554957597362803267183082510496422611385327251044,-71403868698979550807686826252969829249113958083536758036086988167071799473855285304707554729937313508260741638336031469343307741190775476219/295750694071393884273004512299766996692653738730708976121998212880075367141312743033867338340627961892223177332841531983546544780863167295974,-19925098002947614038501779555218799330151099159636838307628547904459997645687259108508519063087779159121745324300099413686064967671504066613/86303789554563408479126267003405523613325283360058678743652196544716291757055068351528858727027602411093218731968887015470565339871950069678,-47471350606838846592744720057002286938096598376605180732689932355799641812240263335154645810201282507518932101831373966439244522783102237134619/180333688658415436198799360830081974176071443286832206825684452778801938985620493290952069199177697896865423779963327321562952608751665413085376,-429804164416393611331149966829262935218260157407272806757012105236289181196905634535589808538046762779569219540930749048909600411602232681781/2309354988476101194770957203176380638435913026602056208989107590141485080761414936052406413518567664959599481006089206311833969742765334659488,-80450693102096102341094018178719164965221490377556023239870911161405728344572540343439970960597053498389525876356726752537578906419222616036/186885609602039637149926746181435048378207056418588725117851602539882581544356939975081247142787657944614835825288844832946090873838769922147,-3501720167042666994095499393790850812970860608250751608947970497357050894109623124684168867911790336183862125327198770306650384226404825416076/7915769771917219752941471062128716543437528847858597010090180482905017833203004612964012155643527207991363944598276591743535210663347558392873,-231040292045368804919538414405435512865393924805330176539344918860221150858612839430378528097804476229096518711627777653751734361792151744092/241511239099209785601075636328456075887586509874489931193350368137692696574321640851805179077371976036115200362282234532863842097528061439581,-157914659166076540413132428915851776168068624167132896791271879229481209210998515319729130864186201295576760903562708590461199206344139077916/409075726972193773781960417516263495618273433801784899094785660123013577833745794276511751851090488076903313257160982234247538993296970094029,-993221017430261280697151651414709837608344094647345659618636091494060431847324880450413315873313825708441347563489084035849096453520725608207/6722651588117719963042487522728155539305401029559148273577984613913527370752132817346486185762839909636071550306441224245574255502441410065136,-1831485856805279545512619688396918442806049671217438221064958251640693110953904482531148575532948476461826702463925800862198129250860659279911/9079877517103112313270101981213725843171754711919887107138384022054301700724724493478638033734592249581207280263657114703071744764172439200832,-717330603268873143937940546457073438797391296940508108171306176551206519663425611123588522236182890100663304977504632980420754814641542492125/2073302565910268062861730461464346503272354063728157329235196503981325751052040244501023189551598369777662064920383734803012984402423225676402,-266550067636080998497346476040579141302691436718101420075698137930896123185323969044997260245179380118889609521965962886861684156115552201543/1240149010527976023640006703218366121781797039840241374614268549585535593087398052916803851867123557250563541205586524380219485861664356157312,-70206154511785043042261613426870450418366464800152554196229300573062813881083228813992061597825691837819223736437775246078949398452222820505/392539334382150441995958976564937405326522613708446784135881470339762571179427338082381227489008313855839907815185109965158478826234291509276,-7845717303456636878326011424374095486839185652202045415552442118303537693637982529463339151796397320645792208038576328395698029277697655280927/17617203139278102987296383205843167470722044071485503618693934529793401868497064638611986833144186369886477781967922770745162461657759573986463,-12620274749009578415289955965847325235112806208166013585658236551759345725345713561758355247367381471610310048152211685176722332296078179503636/25314831000874155100647585480481613434273156717220329021387367772209672339002069427250362440804164860009325086962084991918156619877892028316105,-1345820005703376222130624881002250741447123710945503242047883913051770379867111144896181891412332016807805475552511476776051626625035363000488/2702239977019587622414371610736575863435358317301525101746444411812531390340477025024300331688681292515546159748210275598634325262599615691929,-13646813780836579718043592805061071736639687231996921817629578665827281918238296932512406060177027169499907577551537967051832703192282054457297/53380443262242886488583081585924746071152759898106524972111984649968992165248248997679386404190105556875503673082611498133467100731956977363368,-20342363729022131597117442481295787782858104310644247467196785891703043516541840458278889908206275082655646235645960418834162741620152339134585/56470230219575680624295826795535827050486451645144973866388980151319648300820251550534145203042418919167317033550544174164953384072733853724789,-22702219877957877366776538102535111395229521376633195351398590667398723992482734347831701605275606776330561318354819422198491476302978002892023/70819108611835646135440175174911008116545558627887713257738616354831216774251842943749618665811356177171326357530375032850738962882126124885632,-26246435678128041146321683464043726398870481113770025036942218372093725881621414800111713821403566255768519869218626217433935736388228904932082/16433049505183225799276099034583484709513001018313261641834259201613507069478091945248237834088758847664514707997154532964284397503043149121781,121480792092051006948417330464052166528843486553009853113318136840597278790084639481602095980896954142664975086506144626704504596126590389601/1038730530501303178229840125351303221939548939955513855035891519345363295325175081786491061278718463426415062021711252969369088488713119394112,-614791319903546703477674355047503935256034101809855065016702230107719258720916416627927172317763850805849371845147349552040524286533114378055/7955804990595252854092157819033327299736585624044428691527337225002950882856906261955587279520206692314043691216750699421125426158632286332736,-22887352732345085160478333877765420172302284257402687552863201183253311789788038956670949403527051488157769290758675089610186550270111386279571/28025641638163993174567899159882835437452691675691816784375279427900921141856209445319128009787282432430808574580944857974507935391141726452864,-13066931548051563522332074553684960579326512583274706674328824965205397457749751385430147231636782903240074595681366619948969751935440009759219/24562766416366690141227614376630690710577742697405431305068135037911744602336612308933083009720661025385366685791492568092106541651778398152056,-3578550058846394166490922614872493373492997164533883065812903507807220256256171337723039442812069288048110787455533579196413314551933706733105/2703936331968596918026835412452590930211299629715937799816582765872975107132083516435435626323028947542526103953243608081797194783911190023696,-23704405537301359174178021508965457716465921801165746624323456109995909286254264546064166470831374205912115247748516849991657270606314798771/134856032293136809323652760953625514953820035599885102561990316290082383025208459571524618179488051247966940388440276703835169650716525018112,1169685573127548252283669047887264568943906908375935414877834591983676957598829674053366594253663986809397796309046964718088191555628863236489/541772664543087925966872424677829507688094747703738835315793063534101639022589128955022498350585124582719657590743181189883493944166999445136,-31193455499830068360331859344504675942763074446705190858073658453703646801169078246214670452177949257586071479784250504465746844078012473767139/10444533386301524973448658458644901267945188187261176204883738148813873216434285108305349541419308527006449726311128229072035763699024750370289,-3060874484269143648492578054274417616047396461716942549189338687873219935158800108621503128848264485029437568459857988119964994917621933491439/150738539083035908321597544631568035964635333043019705968302894577806792915386600426873470325727348347515957713770108556812650881117103660011,-24594087587830731039496573470093753793182952738439997659520428427921127116273339956704620580894133404269403276532597013867776815343085352501535/9451796955374159617993412218714379226724022366845006154057517340280201569635387858395718867247520308249183873645970570673035280099302584869667,-132725702968796271008429503605639852952592745784704450232278469074496526134688553438356317934124695881648818731680580726856023814042467811719083/286874084107504969486068872446366424810155203183991159042041028077617403647264801243824179074427010250728097660389277948372780587358435415018570,-4811736982965407788779980649634350794417108502802563458415325678141185282728000895033392166756666092987916107324345838822829944603872129436643/18458818944422271388178236496116032137203800411379639990337487814279498988948944919770673899192755002262354968993506187008328002243680422203423,567000271623132286434201804785198611020008570624779989779005157056514266610808829059245344694917409605610562802797383214930685179122288324413/1212214458889200141148940194221096813464731547349821804947744232044123329341668112391962065058137874622382581150316084295946891134704488342457,78792711172863646390319459963474054705974369881025845467486645530742069125311411561732226630945167952819375866471598488197496447935440066826/123802949918925363515675765087843368362484136281738974237178221747177437473724058784214858828485666723227296458246296050410190680586342321595,13749181536003173644882508518303489059286844899643703738736390538260417019920827203093392040984373962908648450781073374550227151957834871037/13581230438961976909993472585584038258007166426508320538719769503400523104412041212310785298581313403631083776849131844598446663409328594852,396607617071251324186779662932652784470020563187822970340778186162201339299073629903544952586152424326649479123390278329469492869770327192782/343767326034206620821302376196468533876140517557107668343226072413642231398084859394672851680591916102711075707705898249304796385113318350809,19333116322507320718834459196680466691952610991653563260678187298653525167969074237231633711282060919229771504438477436729250907994114317768/451103976305301699124358863919190302396002732820788786810226091224342066896142111228783902330878290221176496046634311949758826772233692108835,-161332039579144093091162981874551788296281448963474440874470071317876786490259924789389769723698619374430544414204161861287247804202472055328/4579581088666228048147593331867312506358507554873009866666504077242492170773409126379777085478024861026119854272813200047085389038209316815347,-1727945392250566174981477994370491456948421615669992713050803475460039681632825188338853304073723438685589822260236911839141161988673771128547229/2258900555565966209472598954019238989157942390788170189943054163037626336409716654363047460791237611673919052652081225947811633149355432851274917,-1841578617337221223868035173546823304945943940316330694444340015732512733005309867726676713571607528637698724680146415865879016217237222667559/105158608511097251250683906714032777466215204288642788817270634051246169018001899530314545961178425686006237868287737363007007906521365781719939,458401953404257903012873017333982940175815364077662774111865253235168619949704834190833444682253294764711703524415871511069356785260177387037/19441132694539299172387649585129370937215180462407585948901217097539974129371054439164285771652514007610856828252454065560184435441725256557143,11714186459677972608171860342482105221192147736362397269853924390016146010562250452993757111783528811127572816601683725215589961730965777356/713090499953476046738667194056915458364826029928043890070856674366026298504953735839275963928288517159438436553951754140131173190956435967039,-984076808719795807557577819645073345591795119311716092107727278449749203509021885744931356773519867287203852471967781554161813980395277511419/26076534758016241578558763972643083814554977460630291704933634050735758286873422335005491462497451542611284824331215763559198946618404502364354,213375246216660913194761003318607444480165080620690754499388301889901332873939428435748929611778521249914902164863058084992954619217852140880/224185787438252355514942261198032016543454215824787021719376842953912013161451781843035722827088622793862854964630483713721766616665969118579,63026608508728569662086432635270139594282285160272726372848043772462614782119638450547070620037708747317571366581862493599418686429812498410/58744305942449364370414735790339927058802829643267678292537135125474576217150780516207045741261122456088700892238998947260130866113335751721,728012222672232552464252180961073975203007174221911566833308013568078550670801943920135864824334558298213131718267640501855392644853149652246/609868849826704295473657198436562641151623478100898275576821208951712761444583082805779857879588029480771130853338757230493152673962375674727,104388718328492152153937810456365338334657026113535661342312127008365236205969253211523643033861219507290586792214832698109802770861328489510/97958378409730310271068630518503449793138212696436359502132349528126393251514343606362981271553650204192883978710656394039836721780472598599,153621971225092093849998903304261253278099049428610799884939596149390105708428931965122162080428798110143537443122125831145752209025099115289/134774811212952633920920421077198562499512672902014508026468134600513148927741391987589956800217648893109894995423490569332042478535084550042,174414629374950506530233224485220435055129454579917446087952064552984187511404559116511829074578026476382451850213236339954512097119111871470/114962654770047031106587864213157424213868388327982058060909292818908156721901307482214055201840561461737420923409106657318559434425542553817,11391207709060645329461266197200043205042655457451144477421550016084790587320944812071479869614725815881428440764293804651224834098987262460/11904230004241094988369062252873831102946262208713684155113189828081414982410965196218235886477973289961906051405700255777378261661067801787,-2150282673435541461724449011267358954965417524004525083716211213147783212188971101378105830580617044971610353225463322400015303630892772201643972/273575186010043871354293206579119589346516069336118768617158409385370073981276303684264932432258457896883446548486751700900347873969879460992329,613355171943369853157964005871580856708416720263238901943697291465563063329077517532457161089256484244005218141344785641411760754361946416134/359809015861387599580201035611070450164844718626610061563533426517489890722528803173998287403181050858821877411109129450569680152146550355249,804980731039314066272364586845713172617174537127674240371118986831651230731724330222557692512562084180164033902969233724207158946547014344978/160789449672181475892479548162844643511861609671499785261688128724074608761526126809979611202318069062603083357576052826545911476897283142643,557277829949695576428679057685171759552276112302256887341393888949972827115624047742287238172781845678358938056842851678083651173909905572507/47255102282439847516768418407208214991046450828007586968284376996562712588960713291384506266256202027158561569398717165377779105080009898710,-27341788911702462666955000532034488418084155286794715616703623318805265810895733190425696085091115842590550255487815416637905552139263640794866/2611640079074353375584348302395053539203475098843072739524111382685959744504069977754659644452556026447865287000271122664428237546996880662067,-738950491427259261303904905823233265104094499903967419241969832967086964602707381829596859429846079761516442536229684730600613752716391467242/108125221956450017532673989407552802469503555906731306759216084677956950668079713406736629975741609279333844863101180724893684281708401927549,1636710479077880282768619478420509770850247153065062793190429915032632914490333130615475612919452898506263997695360419773169316887457136737413/31478368094454466440261873448374183683058105645248877708756055936361421308835732734857595252475766939640827237590576892451776272769977524514,4887077858246971175872136062197927134770798619124632315296159016592127153400206736824968984278454238108423199518696219229502448334651072777/1374817367775748519578176193592996749261938414567439674580224313761236020401089774763858493898158463420967951911323642808213222439819783902,452488863224422318822236242182479364771340627914831360531647032342275475264688780755003213514860286299498538178679426881148809311707995022657/399967247613949091675170469193172054912257934377968600357271890836879167192669713572041632130446409918920466846757835324855869819596342613469,111800637124414293347784995489333093889455789163372355632165877849966466596266899990172157011709931652795582818968302509789588951521441364668/168653295086819606487527718714329559767551294990482270476195847440597494259528767798868373159170142017461512898619623143843853814618205495411,5592397323119048459844894401186726493062926818481074329284196179019340798255980603643024283470179150855847754567169334703950550253720001327/226186837469821689410399473423392433447077839184042394721736829343443189172962321939808920963943078327654831470426300646637855473549266174886,547546569793612507318508660132680987748292008000777430946137697124793988473473810326215445529775772803322146550399026794106111513427567230123/796834592621288369449234717285467940501224888043686338262286474059082758404128926750089991720298054837555774176448627613362458836004195930710,6115647773921801819857357219473359342298690213958428714722861407483241577513832463154022243837507649542757598310602812218794553881118645791/169231316254833541842751719181075281142204497818812219853315032317054619201012074806888718043851282280459951539031207105064525694493914102562,644067008102811148784433745739950176752689260411687916562237149168583595392014772746948478295108448117601164273235176099921820013334627081/19199128176615132679491445772719806894099201668116585149642416542820447491232541501395838605899736665042897638958506603098944855694334668994,2065340064077741575180522552340601209443716391986791372169089438107925145711342330561437948920785934884482189158534595663462449432368724575/102868406016766682571690594764908655612452733598594474692015536022395798825634981714140360546117241023319036875545816150413542978805892588614,77265315769630863366809202514938582417270778914191482235007205451014488171736313764647544004428502495486889733391705053971509544428551449883/73921531645342034144047173944590996628648211604566713133914668483037678645759085651524730338977732190495043369932400003598429696836132075210,1934157913175879771568880626802025029370956928969661990427095066797567216149817301098965606336645911949619100054917945145755589353655425790735/1174201688077732018819749936707779288143639101690023513689260635330820547724428292749917361565314678985164433386477985504282672491567724147544,1996091970219394631320621827036688125165157343903860003143121519106496619183373510176701625376148424357721619494322677957764618239994938917244/2157215340351327453789653378621688494978942582358138896094663217855347638910579399881010373671448613882927092360652825814444998789236219542599,82626574891249453197355187020316889622401724426825170625403194265905056538383013961062532915555320305871219974261074538561851567859670839588/91492239183349305315968959871124131928378510322831294318510219987843577275237848896014066008987037300304348362387848728141803472085711873203,-2478042931193209482651127011411094041391750738616111300020892090829666278443591816820737807848769981898548408912699355384658221177423140153027/5608347283140109059308113318796252045022406525348409480999236921959196054526468164832943613362049920356317802483395291033523752294460551228946,255485085022667080314985355410106158162176259780822895727255435894917942376594338145733725520809391883803345732656191275204529472732015030260/36392002235523952802711499072302325223139565442196309278323943229342360892108873021566228453792868381129648784409816037336754918467350977189,16480772351262100028285873050886797642189596588405781097853304076234590366799649855376788302070089037175180868409719507510540405344729300307/4984114729344618006529379923291713622704673428981938130305470715293830216717766339237912564105100481545470517145891401442986513473193499724,-2285394306089584520348719009964231526437888858326666051655722039120431667772190129183192066810040692428025209196989991615114635570430047885746/194836758742485055296825213331061096889682348047705552391826880303132717591209100695335916520845598090239599734727743735242783340244053242859,64688037355169120975411770606161620641979491448509671796157975797260111138497642088454926174992207410104943192204526461079577464080375458937/217385148549538318789573153643476810730428566828599393574974563031478145959977117067125055548757618523633265113875819637553359048795865347472,374379996962908366550299244998397584385598570079722275543373880064688461337551891744210136014432652726287461883950016859535315950691410605462/6182641768225426404028490099420716339043450111027813302803547903771577219166824661998097702602052318411075052799939466873059448705966717899,613653579621452956692266555724734803966425282561338278236765819993902010743981609499626052977291274709855304842340246898848029296433579806274/540592068019553457256835515196716819939893110031190494038470489666715384459279017148112419564610617589005969713635277847248787149473026608187,45300526621740146019009707244383757386127699266622213052661314143259715628462621168479635780686582671606030763329884772288571655546090365896/36299904212168498871488845930102451063381732747860016711689501664434941416463418991196868320488046679865838026571302675396643357219723496817,56696379482834710138530295957170220869227222551859111748108309405068204672982225799473693996011920269145027150282754268334784040363342430579/31072251484547575942088829719683737867934460057280374594199308522835786335303924618110809991918023953756562652373074908262284761701397446180,2185788792051014634549781513723642169487363876112320213758622144729736321025165268904778874526562067421735167189822270963564318928915986320549/3556941217803096078696859748466370051532930335106629277760646183429518860610146712615840015194453646894197027907179853822490153607032447931274,418593107222832704285673461472318495573967994374040464468071904953428834146547227743900053975507043846410827496858776645823221459932469099403/624911150850714184904638552154303397363197314124838776088442290068793026405130055666700251393176725495563875043765694911587370944379991100918,2071882841529059205180855341238507293792604159802214698568095869730934143840417350015657013686842305524190425964420401269351481165011696627747/2883819482552977973529026752994494776611587026732172928854121689550128959883274898307389047850939656968397251275760591166192907622689224939118,2754795764479350115483101863844075589855620821089505193153082424711989461027302485666820444558485255998016239552903412742307330276698452940521/925003599457021038905269943206563304631934148567881401311345218171457109915336020953379985871531033799221541659672490864933445567571691116846,-2437385770869475991841059310276575257927934029377216989007614112525952650220489846032349335018837975168169338918014624106089342432844431786146/141598673423289328111405922207743680377398356360731199498992183543245383992460782918817119853319841659948185776966809652616797119070761163589,-78209671494038139961494497366007645427016894274927573317751070338537338831634074432236069227577220986144674323682287477026634944159829097457/32399563579904440533081076120615631000750967008146641550714324278978206084515089824191571699801398619662945278444772750132729729627147105212,1034084660721204284553508198661707317920373469020012620558315317885420803327113392221831215641692923538089181002636725296217477468973096882651/1877510832126935650979980146303303354605478363540190619224642010384892754505805535467333308345033383642174368902960761395971291369411551233951,1174696682347437832030797001435561778716560174638632796811939328126741492675908790391598325378728970393493094511141639475983146515319778707307/2126054461653547347707240983331955062984975282763120838213623919125031406513906646476219379692259388085989238870326377771568149461839567089294,-460951782827214317231675798366439487017445737463198295675196677258549917045971807884222336484301290227711065774781308734738453278948314986538/1107546755829162616054870909191106541999718982626223452665161863821850108432586754786471505447617888690356998758009099046935632960074106410861,520478609196362266960484606199652890458179038518098502116854731287643730129881609741195908646864206776350416830363024595501555117364598033286/1144299912278091281566917320932691578199308414162864307272923340756490389366542296474841624118375660173150427538373553670137312375559520693909,1506751604145594772654160019229605597344152736915570121223617241369652262228702539844726792463946012722219034042013316094230289201867415087085/2214128110095188109934590655414339928379702618524632470938472000524632896370745098041475079903656918304717665351674155996635015313438211720732,3403959153273255441917427919334177190139306196963166102967733173375738017945801413532205833913453861418379524498438447583012366672742635830683/4982396203059648267278152824341239671392107738404257689839077245440627585783105814972322103129899689460963855842727375431104886853275566960234,1731371195566442329214475507054281528226397168607683494193082870249038021887974481604005434228408378200312044246869035071455317355433222453169/252003861328734184578264782286298964665564432914144907838351718455089691348475124906911369131064935481969896955225809840126940048892410937701,121070371764638634669353295165708451806900339438862317031325088696559254592151376707255781623559267925702829165057654622203792721198896894935/411589216222352236326670064583869577798843091716510416173353877244904166635912689354006485717222695658918887156412443897205686877674441906364,779434942383023459659336517442120056652529048622215294621096541148733737373687815890452977000585672881422153149961735037590674264888890974774/3710519894484982612697929634206377199214393955670744644710115913865525989143887727230540982052101407116028174405950459131862007831558225624781,-71063878653957730309720860906468511842103601942215195231352119006416834605651599358384656729058928029098615863997056682095320422548626568008/201707389911338635108297786325387520995558961798217691931232014529706436958290668484076905273764433019515110783225668289184842099842562961357,1288054551931727896825108075588551610987479940221732245452509679584795781735225045797272920643239673372512614857775787603726009797615644350132/4442366732708514754480185924174765736457070508400416530458702541711513108501252774703955867617969599955301985487184341734215697778485654577149,15575380125150872282603503947375754380990581499622312148544250758241229745455520907946627092504885088722736777706425325210877965345376006/16214108698450331462871207728027991875723644279770144114793017148181477002477416621018825240966414046502912251543229590078116631273726041,4384842030252923149068033924311536792166575687220325095304849252340640988105470280840470674506288748471185396267956652129820049556657610486972/9115756979024565324831996512965509845904090094901146325791578121848225426278588035394736421951002944631012480746375402074194970720924935020559,8828955713774478778179365608622591160767422814223951143990557555771717981927135922045022039484704437186744273968594858593107384093212412612621/1580792854415054612852117498372630196603826239887980889837256563938584783842650073861051594584462117970437230324120658335241679455227550371750,5031821020883859300964028988937738921909279394734034113268975819439765307690689419174388768974948890289436901571105296518656561239896266682413/13445464187436786247281170582812123656984188133835251910575251572390066758152862682412798147233378209165336369691382430377842728271456199112789,20164753731830197774081550535065466191856444797356894478516490428932227254147417010218497724185495462577147510662438139694221911067182963893184/8710622319027059123069843700052893165813318047018982042446833579250856585204215009167623997305926127878869977080119847512215386458544174945127,1669688457237406028661915844684643914840836562420353262406425297327248203320707814569889087819661808980445594346582588508763798131847830424264/1055613123123695417129686862588210807280616684454158043326975807581633031413933890067667019669785907123583520221596297612123200229585401907117,2668055888143595014271700937208960363158742817338787241820952822687355573389615701461709477141753165994834716190025516308507351380635415465314/6505978976504464847252102627035368233635025955718464252732454472200758060292129992540032815755769370838542276430608497170035540080083950052087,3883284600804554450624104099571025371645699927222409264968991989196902965391640426706707984400066665538108133956413740602762311351736680221097/50033647261599369540111167072303959027175456358803941650134789501632153066009786698538420446367473208309802283167232167271744347401139691211,14433459171992175192444205645066696450161468413830720676013939684762895971817102069541091642520398231630886762569107709503111323918400664302/13947188821699453394596874872649192772495899316665996613905698225100421138476901642301254662537396739051357837243926552373178049196084137727,4978113466538379489728710491756063371485338894491822530537582597472988213645118239609457394914998998888509442014514427887619252688488475213202/611996338870425152877847645661321545959265215402922595787850467973156382419535580383806589121084870769212055790989683602101310526288035131839,-2451297727656574128500484834622567978918057863201548803921894190723763198750599930866736012441050290326162463995668236815149187177921605747391/1058446603018604166986965463659323698452993060774531873748896137966445382324883565837348901582367866513491477655886701817173730824152918343061,-2541807307091666288681631190668295883605194023006294148464465741884116874638566678668382558648369991495702904187449820655312229184598900196440/12903457983763591598767116261389460488957818105134759943621728158233926895171226095243164253217848482579334945195162070690047335908621092771,-2716153078509714837201101858260532171322907498633294996617586192275880958657014882116683298507632974077078104476622445479245247056432313465624/50901214398028320135406237121480996505980851307822372001798772375830378895908538206952068902845146655705796314096078218520974902574824400297,-6424059632508332209392876586637162779084767173892347875130938277452463588997893512008759959581642896514151594149750011526141478713299177291360/33789115090623646241884407936239655874783315884202404015818161042553697825221460901392584724606464117033933530533950839542104333484379622077,-43846529645034401003018712748645516926483738587003322618781169187278260274069648169210979157489766703197068083335703965237281022764373887997305/1509879690488937167801564116624852782039886476541526065207794715376681034494345488791508706303485135060502542160542284752486114003228635558688,-94166889599848893360381642326916840097797638298135634116595922765672690269408811177917208959634938901401709280011335043077629836120737583829641/24374858507545554584306718068638664963781500375251213499377409449242533737645409667850446725012135618647889802970710659066839819861487491157718,-56043866080743204488135024655331555576835844939781248800653595398252436994255031908486610105068749451242290818513368121642760134490107706150655/10930610887224550012341720317998524715695933547420661503866930506907273056791742811563491531583750448918343656860484032411623320353231469284196,-1129906048589178322592344723006439039712747354702482587254537317326916387315517943113741859189162609363403282711304798430195917090633302357661/531006296032950685361050618991840000595141741145939126719104716280716159387194128563606679482472730049515833845373439076595913523453934848120,-15013690296241763133831142994358761020159568304558859743768902143470286503691967229534290406562441318581152203114121028758473969282969595552801/959362573304121327679611751819720478559858445525634946529727095973743759634419803629470980226315999475154807603567541776893266705392535746416,-1729714205789224428702042937516308664519174963002324806920299889909555642014759495093756932523639897657352825586728359327624159587239358759619/453036940527788258124887703423238816689873503707122906225710833850722532774776281225177373331800721033587174925451939220655811876036275493970,-909212899597866398548360015629863827886402984146735549738616962362218477652929981172623612617418394102613958963043707830203267376007929113987/247204195836556354237660374891735836205821843605495681479745065291249507895800392023095944417696962845384723353911573670884724220715784449679,-4006149199930806083347000565901448875385048364531229390747641354576978246744818413161383529592341942565667246564419578591433391678658618826877/353385930146207448327363858140498874626805918666856845522501846599220195468877733750677170443529549841064656380589019217238989445979198327085,-1287042696666337134277599411675834090521720483053597072246357476579895194550262153813058094212607507467096403257918033029271294077392141185661/37545648992064527863167366568987565669202488922982682085262817256929776688606913136970463268119064838717916539652813006740396557290654208240,-11391666098344073163586930361631991427580795533942137624620631364152528730948245413558584005270296102581256312916313442590938587169763762510240/7473763043353643103973637628490783891461103130059415291649705612789690916060396154576640389292943375222112459757563983067025109295408987008191,-250102647592012788144199077014862964809785811336244259633913799506513098787815978949898463311922378314057388005780226065977696967837226010766/265893343472451258324636077669494024928426108010678372017778107080967897437322685458958197998756063193943398691196213942301025776047715843431,-49168039575513640970759022082277035755807716889131822798832689484179777381923569170333479898059055101106592484593898244099930690583034618732/315659051864642761306983115132316095632110779869130961375555866251241442095467394347974688218612544312496392858420449028729998728890282243,-360734943763793097937507712763884020347386832008005240419303109777997892422371724678525504149786840725805607937617521908697676670297729904584/58480375858089060273353513187057644540566102636958713419347013485151318351731879212050642419339726397966730595629810251668791791230495939665,-58844333258772822635944664333754805737078996994679316507791919927766789427134592804548419838538282606090771234567384730809827076558793514932/30015811806513673790379860529252737562838195150084576163550745647740547927627737261797280384897232373542911464051197318337669970049352791985,-1563028146571158686557807370609374012142194431631370208798781531904253105652224304561139031928058038312212898360769930359686795660712656065316/527706482476365619900122765406805153198409482179406628123114651198471663907391197195332799377982724474638456380728918673508642662214253061317,-43549882160756293221110430180949180115169457483553618693124394162609180695152862295050663966857834264777730739630629654118030925443452234364/7327262614181213448617685328531520194846286001482243227696747778881438954080979444433300489335972832413814435643750028068111285875613206567,-681360211631441781148337227063813872220742909165687618342808801386190463940192674293419960879544615271551170167788352713031880643657343502516/124796846337248876685915944842589756581570774367189522014454760825917237054991159913984445818395687904235794904891282569551346469744696735557,-8940934645767895832577367752046331751648223857589159568624441284342854334917769768622190397453847934511836219966982693032065968803632248670332/2011355276106377564611395365461707168814928884020375241274659261578875414427957772809375443718214113317305093145027748712972277497871436138943,-539843408343619029084993788370308396356863243692223586199342422666689784357894415317238273843119713826793376016202155771945611706655471322736/129112691897903040468734523478467958705384579619483674911331451040642979654042161225970030154621426838126949417797422866299247097598219968709,-1829963580970709713648769494020643526414529714591277656210043649856025019839480430039221797352267553288449531186825400542632753598010218508833/18349875290201130442704767328079982183934055263583441391328042294510786684781329422882069112373498689593517857362012843483598824643195523232752,6578604536791521142966830073692947793612263789296217207761511341751681272978038517998215633030129550144656157145912862590218167886372270573639/12280495338245579628270412505215286456825552191944345924498521311874335758963481091248019435822207219901732751069413567790685525543150853042176,-34564245049309193466338568067527224661165965164203113566942337707891255264636728238670802548714294713147616812929896246912331819057903225102476/22658182796958838339859052663821573686875091056251691422495504943839014016333921826830238678374403135420868172101722352310634373158938094533147,-27870740567486651691516214158369746961594403015923446738816764044052689530506087839494842402519492173752225646709102733733332720558581090300276/18310316399163725945534887690700076722397661822014791492706892791304294013638555723016480996091426475377680543733303454430067505772077273732849,16225114979324144413378347036932852550687336038357514299641108939349231993590732735709958419557462424279425447122873159943720961102814839016081/63269266596892627828754833530213085332189797150749997264808753913613791990463167970039168342096848971332511585876750085728295982359253870614016,-3055542975824756382594157807399164930810267576841785709581975022595693249634161033840762595972692072997059150629681926629985155528070089561992/12441079962766110800522941435225523386666412508661689547207577815012022163646478368142588225889822260458259707628462668589462467230981109857,-5899392892184926631741601362503159391800317586104246773633548277842248784853601787976845967668776870586544120646713789750064011975774428470740/1460923797636494097510607587323089005623811885510024711069651379215653741485358301300540241790064157856750381089054644328168779508935404461741,-6565708767457064163690662894383710354900712533322274863413829343133203889998256918096663491174040922657231170142066836433819299345476454928917/1596449020819854710676953123336339355669427923770097227428057635224888110936217921805821402192569225812087252553648523267296520419189273056884,-298415475269090391094679289178284234221639061129394973472851085723055440277591860348887116682738598144012494203504606850881833812521286088316/73753486784869476001595526506074798962743781168108191222809271175049993326036017132064544923919169198434860143557409961420980722770938093187,-5493634330606269778392319178399173595766793464753289155292940422109984724810983249099562385086913104738926312360766088184741318830540983235789/1704709362592110307815202522465192768033313306798290545735376509047783631093166558177827138902784956384966302539719168233318140514948589009172,-3054074857255517826043863581949378671141923191170681899887040945161241197072476927118772857809571238168780029112158662054707465395192029108405/1417757980727699643657815006623551975858921599064148177790284221555438625249937575376156391448281129257887270018844730827730706052348688297276,-9893678994260523350097034350097987881123758208914300549662805306788810727866743777577749311750421070299426825306125367344371677698103711522204/2634166188119441650456706605539882024716047982757724874216189280720983351918198787710935847802021931478162740580193142514485069985613027384821,3531626536474700236007484341608789209293437551290977347927874156074796284135832610876452687985298331242684054148570224502532840134894843606445/4328234945873980395688811056650737260542025645320303722575371612697441007004579871931998913546587077312985731973854594250112137039020581837414,-4288631109469315247371970563467335128953742382860682261977381635949834989279573170923549452195238382838338612256712882672049654511875638579748/2895474799043733819780580188191306328078520764376814686597767055024828931055177684450360231696214550707174556865568510765809219488870591201573,60804768817243492410433448452782346841694301680164512602267339141853948938759364192328485937148127028495585310817885143536787182866570492612/163761130776031835300375258817819103585899120472890627565694391717705531085340669002142279214539638013326324240761722861113791698662325889779,-133555825468486730503327245274322683205508517463364783990943479752344293720935803441037950183917176259786678238927315846759760270847130452892/383425428723993202058798905138965726436451214720848335777397509264857593847634582876896516427538761366356492883792660631412873058539731130411,-17317707961028370052865934799702782983753363744155123778987855058086396143734992384127304163447175177100777772854343999854984378953065917804/83513753329805455354731594626196458671045436060160715925286903010330538585673156545281037932739986794505783616796667443438525659034061025807,23742724216940290465004135156981952122588596823253998708215525092255362551058287605872211140341646301208032290052969834566836646045442925276/51220279760856714434312978343354506445234692819609009779226140521418320444646664704311807229725682847209195340162607825383855253688999822917,400822178693751401059058368129295177149445667228970144849891598687139259371731172740408421220119203010810051212975029108863532310171094429017/73342732183676385569714252244519968515398101062192667514678820688012705410797491179472721906167133496625698456989399656876036120103886882112,16164219036907232332796092483105457421604589298283492949627580853593925559886022478113371464036234887601636900175419109429284311070118957822971/4444186070043560689276497648199837793084148547543248010251847310582684662257808028953440403817641638925256668372317039313831517281324633628672,219547757016452802886181972293028530548580151960996829125297597520110218925352454769117023957214375440302853429839964837089854609709992223601/164414904749687407492090745230634736712294373148580537787764903716376562610092185438865349625433925302432129100118451823439227733162506692800,467923129881687704145955178226768989712613943025656992669662690684012765581616173368165509663208673609294993963983768285293211958633676921683/356163256224397163283917144350596216723613778760456454606732282033401713379814752052736061161921799279921356336288640637598556776457457597736,46019439073061075627164524942214156641803805282293154860489593629574803907784733946874029916758071214453624297023025616948610296834965109783/18921775497276321078266051819907356257726085602320766328671746225824267763211899062228807304500969486018343325179765891007850101129972597840,1291384027476411005733344880335831412814798196435281789778555934113117639238182084796876833872138421269066246655549383568381953840309258797167/455105228753233547663380844868202703656089226753199118485813584654408824113745274675851170091103362913886065197420390391915654000490916593344,3943676170261358794363162037910546492604237655543635199724305925926017709240086271987488791553597423005849897048343395688050926119648306028063/1417910064213979175401764271643977418905812275418116150989018569262990789199827765534011692831140551740935691824252374646236914694486605791536,1249184518925280522445646826348406545844848136394988578212055120608989283034418827299993486194595354106811261593219443899574150445259389331689/427934366076252275518685691084334059819752345652580852524932381194499332335590339825934293444207778768771810283058622566838840604346130407648,1352125621347864623540025491435696896495880345992368686208771580173324023135757622867126113955939373661599125152310639601869229206145850604461/319865360687306188073603688253169872463523261108380761636739072238480573672062083720696409310628455939462139820089368722774580735278822674964,188335558955895515126677879206644424150153699024145478021063415372834640588307276015398610225867160276912647178574325729610775917366288426451/76848567103310885021406541273413847384053758372078160212643869977525141822036701515685970951988299186064049722985993549167043955285613408979,827547888311265981636816712295958747466701559942877854688236990138218062127670485965410280860288356417822607956250166699887601915911355188061/328407327378328890783191242171867448754405263766523805974840855555932687138015944714918019529174280473234841723475587352468188664207559777392,2656579524963844101925060275400745244509979827896702849113664088863918781601307256906449326017487659923002662395520223003809452993026392060351/1106109034955455007426171043379710435694897648061028945559276399392861526960228044308508412497016786524020586713822920956388072650394847410312,638220596261508554798070490263251097950255104402493758165109422196600929925371526701882884583403541199916508486949377226051067235980244175605/332700808254229565322463814087425295249567955684006175111257548357538736270715035506762216004533346549548828077328700492175690978724392101408,1379552723343068319841672407974367661161938405804281494603522025538368122635347675035671370508371150412654824314029654961920487599011639089027/680603178368862689471234804819107362154287326162823998056120469916376332819937909836880712317442966369526430942380489228721866800295459992624,1490917768004722475527383088748931262849264165752224504813190136502549922390087001396045322869272617090157906799750177187524101225667849730073/433141429405418199564742880016301875575143363052790541704076057120342715339889292108596863483949632744345525816754051283530525647683952014970,40361247568966408144282899349015322296301304490188035933125692870480102123519366400194184733421181858533357568074118533016814317703852003381/17967018390371415024429802969652830909278696143966159311348102391266695937635187496822967289721311462852613160396670063596395909563711597650,915249858420147681098541555915966162791971731242623153465387906519219195293358416411915617083812517957161303215438347529742356284916723798769/177262859027715517338651343936285399930087827825222086396225985655790844324657267666428445300443807291166637797589807239901340335732368111112,418998887774104902124741658667181141097513577296984131716253805286977962427590640340663004167969931251008494852931646796242275155552812457939/482322543641033798116389577697576324819018521094499628874112704813312523923828269646159228664523491039747154754863505402533368200923549860190,654268550068613897267991048689979204336253652428183222713156775385733895864824238335088265969381340280391439980977450383472119159352217446065/704192086299075154584560089910592956910262556847137964880755133277131104546958634442808962499317888465694304238354024450104041159884514840834,10597410918798296424841554841023069504395572114170655254986172371411821889976729456426417354844242732986401246017786621864024384450652054915/12362860048573703417594349706563028992721771649448240796239520821454474869122873290443098319874146996648874087498618764259127231443066212122,62032221895833135785742632666297822759503365220739752679110907984041431851767622748040825331938620367080080634942032410484689892748231983981/61087837451692909233109186374433788238208181591518679599188764548535309699992297143230367050416089369981295950453796992832422980664182896472,216131071576230917450192688762149455280220144671414769763123812835677315501476186098814281435651008890030615382131448383577762084147099454009/403534997047919007297726567314193402191365055657937007077518763353623943851953571012349560126886177163167789330737500663325783819920651598738,51644060675660836541192957268128852697976956535098411527702797221434200492034252070819606456273345309827274013839893345226852836417223448129/77952030143110617340270329466511700953931956380658182370726287954878655876514083647768333962442334950746155561686344590274844970271060805556,86986659170251993385689459408816555613272187249410526961458259992154250996568486703365166399754663761444942550855346445923106134848734357113/164618885600566231133772396936648134186230746816776382860995007417885132184792456962241152726875887562460582153249310964900493063721357101216,2646946812423207550606269606257652399200544008964918949123750768295589919025437880328641529610549907060820436636224134083669941654416161643/4755264085828388569145837556262929972593948297289417441498120090589787798207604828408576836615556778987955057139068951677373040295217767802,115092895592861159299034427004510444509853940933215049797148529450120996021170599030262059111113318228371067011555651105463895336416893487427/174007694656998621519063751403330257293611478852931115192309404990009938400943218976688037280778235047680641089971033343455768445910784000528,187798687275102412717380784907248016443687096544785429012502492216451758384895304446385879662502637635392425748132847116908440256236058895659/316400086129440683078240471978227357613983690888403377372359963513415014352159526368103444475525277069377475041181105029063484491793757706076,1413650548897840741322310122648616836468105877426388252834634465493622577856114091762809212807883121689960694317251555105811338263876765888073/3253850605044814835588117650856820967191124429240139013519823820494019549557457356768080156999255813135311417103719473056408151274428887919222,10514173820899940841378562408538240738734382998983932442867975019502746852813341874546173390262987991809549513080433443000580660390202512405333/19037279065934150103678360341112905993964728868011289934873263394739225584287081772276896702643194800597295669174280408012562102588489264563386,2053056747792063962417755628470827417296013198116853705685886191350479290435610709919440356055846501844411031168141009318264805284984336793407/3714561924804839289850236980872827929711190264942817133113497672631177010809568865550416807166312161073727805998107978229798742585159472947102,7382932570735648369281993937481505320243595805254017260578495064795345043956956146471116729457197348958919576230720268784494318304639127103173/13132757191496141737240152287991903255264170800699874046480457778376176306627755187331207039860415205366629498648512225372456502948071643253018,397475139686895822055192223538101437211522783037585823892101428435971783160977541373123042233426243062151628744803867664737102046888022518051/810174505572520434203337956888446676061140706569972055662673463894462051357232467767931161886725902141841376801871002958044562744392164802707,38154549787402936970640767647558043866374702911845420709092297534100280782339951858078471390551984435546564328265441371712337949073573719067/76447389256567932224012677891112386271456049260374044167660955921600973854601418039400841081355394878669489549353017670680342566006792774252,228446849998462751183013752509234332013225459036314168432459302431895576761446331931744277464544119477517809717843816433998713966645516365092/679527017098489280201737731986164288515338335855843549190283786521469229731522081615410589349937382051047514053528474308100213933582772098437,69176245358323799429452594850611565760300467269975096328395194854399543243350521852147016864233912433856761328080829588321572234393505151916/114144357412211187285443901015793038465931210842909040624716602928346644638109532712678205973887393890853092582264064912820378993926810094831,6526690157103755303738876635493759935740906642850656668658084624709957066598666751230269253087447508648273601780189916176013910814996596454/87843369844664853638953538050053149377118266270705355719783228146613255263436661687158110828110489686804446069535201526378763871978540081415,369942930616602682940718236732408015550119477939654497364587492454536715388457855812802479619359768557511345200240536611945409172702634783737/540977702017294465504046759451912929718476735453339451555214929279922771851958781739006484925015723119474294581756515829579178866163730077162,232645741888796168018666949702314610880597060034039423350137626372340868183048638520616558822110378446543159297005305361729507488586797800905/307660810665201006818118851166014223809550947352546385921368158736781774374942307815904007314948919600724532908872894783564288772998801352298,15755828342287866912827436240197504719353959013989958512240760874162549864614599062160267210884545349599255179836529602875272638971558272867/16378980603789076690067352957500281889034002580409964538674299171172852407230643981052589605637383708190144879455938306669558285275986129610,1633260525051575530642003850354181029278738682362956971636171915106832003554412095692944097319268364306179072986275185537214066418452803983493/1509752864749177987944164185231941434014986555875585489870125064000918208895046544923900226469253025993350665779498357290614497654530171440138,254863751727897822805563494570154323672315008419814168086236642451640320943912263842460633326056484676247928558558793250132625849017927200089/206567253403451712673912365853554300426893795548855593167316336168163460171020900003457298743281296715849815541826698943732440210503567580594,6714666054846066415173914836550494898673071800446124782653517784660056892651430177287976985423364013136969263754219171792943453823853434534/6697067918861160156998708049979978521852127899730532969720862201056792346606396737549167592042068481550621172762051988314569784674308012743,1323121926345840425381084037068419472442968470305306515181067048519200850064102298758273986218427413992950882937174005099453716882364215480651/2040821549215897703332113617929476196617587253675376944407306879588938361101789670487110605684738058967699758093963101464377101013582464219916,316816109921572828868098555665024736186830985542044795337113236177377717909891153309539997161378573155887414816277653002687516897619103510443/958112232555936299490417663926442286233453225726745459079967127273506130166648181706653523784270516209845856396965433243138390041834763114072,694446429841394311705889289368189634579647819467811601379087042231203920549065689541742721650365946735597891333619462119024647698381640161515/1449719374397648838891756824135443662243515768572300534588025191091263096037544989020922635067828821761450254919335757980177671823554905030814,-30626617329821972206142927022175430470209725738783831645223211819036559947450199956918851346460463629008592971548419546373819137490216379303/155490699235133076412039793857338327660484212346441231949239732701800675204499293407677520624259746596459585941732500601831183145450709452282,211438949820562916752424669329040400945941934402932626558125093488102583623080562236433983426231941032904169558973307000186929740160354881999/557431660876731183965578052952943156981491461355171020807169472292757299245611505565014185020144169243434247423302167706004528616600298512718,39827653288913936540102652509856526974796987647204106526321310303423157073452683070312089203646003402030995251707330313567101535695780376369/20151164692508455809111709277517722325118060220925180549536729731576905915986646241252308951906028935141021878457603074818619602867705956452,594702723093290276740983144115479553765860244617402460101690248680520031117567886911399346260697079535828528337217833728409287154731590760893/505928834223012158803555510716450419351338920494526583854361571283618247700591791195290110417198871580355219111360832487817589584956323978524,120418844293439240168037794366661706460686359818895722587256881340711264376329140679744831715540109729572612216776797718752768831479867686359/6989924064804012442609086843527635457342243247391660443124777406042490812977779388714803280585076992433399259033029278371351220968140901683,4709397160020666930215934927553809696918274481482359468907544998324127967504758437692802177017294908242790591137272634857900962034614395689/178948181209216350792337596565717246038774846237635429322510429091201723213735061237672927747687883741942650160443973322410159665263742362,62042784544948716801162419080987923897906533288019069753062051713882450634071348201131167002588087353755166867171746353326488636284816867013/4287129850445047752008769936034366900635620668743670642872473371373788694710003113131149735290028942591287020820229698074203808778211566686,303046119640315347907666213387796322471068137294565240382766938190702167678149859864308543316695888656954457948576713949057158637756782053137/3600016756277740197578361561465632773026690389848911747200352230789927061474162172560260639450625341168691595349750906568143446674114814118,2179466232489016554271210550860097370270498804253779473020468265525171769513775695302830414109359939749305352499876860380230677510911502006439/599903055305261862108268841050984483996578368698820586909805992076152943654173524212462010769292297177339267054235156184318504801582524400592,1730895712195502746817594427704538519120311232248664350891626923507836340773192144505930898449061057696356348402668109610068305554197491610113/1374432855274045693498146302792034596198093389822787670623719427891273808263281998271933933387231967051559541130102139124256193968191117634726,36012590291539007244295072539399157955459432480690275058077740655944880741963235458846925080183605076220534045302040393348156309017050787681/24820634122495500359705641808236356211535307591319551187169361821462376614594248982492557802291949052471749050484609956308361201524628240170,29346492281448852777052671018068291520848263698955963331122173778059407792037753315953976099003486155397704132870122272674397607523340183101/36279494195027950282119277119379787319228759025767455578155949057159382830239324906467414974367319769737127187043232895549832632155953945488,465062121802078281994393012502150886031216008296136152858645338178181783423011541703591601081557578690499274447629055524176646180567607596551/630748560696641561942037143736217656682249937464408866124851773978619460081628461428943638520384189916133559052548149949909028258503772910958,96282435379049987492447053310310447547799767858780330789565050966995616101715000079416672000454953141851686383832784678490919643965919701467/27513467141112920295338522085483243837421648538885292816317384751480602102801032828803954261245090920181477750666738003411087477987593020894,493219202418680234979234513440482027311675081734246836382619977738959859475457974119618526132318412335163608778178555497701573701976101378315/119558112067218090423223467353672405976590223332922967780331715041612636221353121400099884805555018002368029121091856715919409864078470958541,313329465311162631519812649405329131543179137000091816588238730689099620295131192296679731356965102274887740371490738222048683061683051448689/10014619463367444242132704902469025601814862013477164984213499676197839189394462451051169437117633808428997050618116553360525797853800081495,48016547762449885908641459890979001927150406458098413754275344490577320053555886805836068702054258126061161932575272349113402574850176408761/7375244264874345095893275072287782893779088043455079008292474429363282065468777479619585070617397759002734912156979242520040094998324123520,271168552069374944671190800622409966860964128180186114172668430335348926512241652671045920649447555655942029569320411588202222867921280884703/48379774262352917221434238802928986994706508468903444247210214535339734963773423324997459044217942129093051638342434515216028052982584519130,542880829118939914005383849656193345440702842988211623228006153288270068218319252167693358231797920160199986936620346128514382051428687458333/164969049456871818608607834222143544328156989797141969468739766182368775916679593934447708169520271002645095539198509573919141883910197243072,976784465582420270570386445655272486108929285014149732731579288598789860395832525021215126638457317219363992528999476533669413652462637710153/305160053051598516412266564293370118211777700452067262543813252807165284623505962267791490097718914161571074327336856482953880669283700513026,6628905438339871221353247582325399368909152391438915330169088216450361455410441870081822373693182883025304768901659174676622338376082503/1832886782042384022866578818875906353249952806140285017199367714560384114616091498902925313927360127579246305316639113097550198288103706,93943214272024940452285275451585881249587078572780320340678062424120716788130816354314236827522876829219974064926281987959151407088403133127/33198527438838981491159707608995947848273049167129213805938392088042604591745660410319543064625656777649080049382034776612277982878289725370,304371189228513651209835901705548543467804399256395587991005174415672673685459809951996323250351222712550329178171973113198655805144641705287/169939315235661231186947429187188821596412165437747061227396342247221334398596186380273926541178859998612184598999772510974194240839595950506,442569307284784763195440542460763331101054823585171830908200411608117589773976424323338626524862927907831916664489654354351414077557222162997/535231834950513694786308581595678026540767120368670125693926495744179703025486344595636340435097992767283173208246603816301934410644268718460,17556852352611098110129782150768150587504303514435232253359292541629227993366317356224231379128091107373681371276201269382801330805967861793/32431580298935833017259342843404063640035810340725198273450211738108505437561677861399027051095025600854170241728098170874994451032727143918,475227389032710801408973769967984176692286532695515289451834523955067262096936063540184534434681043906137496137118778780463069631633650304103/803450199383677164717784840774181462945574246365141419747746722527224005750796541166043579754701547238225736930560072932324492545119198508598,112217967016505449949321056137190713734451391837675973769941506619276470194387972941156749021512918020512678431940617109957304257032029100417/229333388520058512087141251547854369919528825966178357168862160483179161075157761732035550956244253632355257079409911294817642779960831647904,552777288478746356321454940179781690974488729484373120253011260936166323757253453671387012115604438301673921010482312290289883997530950720359/239731611794668639154302333894038374264071383202580250102889173299592056563573684515588174373835503568211078947125625932441899730363846722560,262139699197768215068357296931970974841801686686310848959405453306946176894985931863334963906914126551306970615840088875176571643149294013215/121614271383208328549231866314320708948523690064144736607496661332044205206210537624758888545677453618587036137333522213883792994959075193968,269051105776187909252629189556118191869556448031056392662050194376204632326450924857838219614785221235019769970031304669266522329115360854909/144112229477459962526213158410514340392268013408530388794693897356591912714224923713104225602769615178084546303741531931426179650914209481536,569911761689648446401178569775444279795669260861336010579848750071209821983796241061493759895299302982619736497480180807683482515740888624853/612711101604828189820294231782678167407276922649697086179715091740418414468653895384166219743451847305546470827922935356977454500296268932128,165741560026504737028384419412802784701192432909547571611277105212381458492773087272600503154265293172199594054222633379760398068508545315645/124230676080838717546269992651998531072507269577220514953439094646340553206755918617318059801089485155215059891506070416174748549773538643264,214226178771987368531239678754874154114060894705847051370375669718361075919443907762399889498009265996426740287264440166528538252763729342869/209306291172879818997877927284060010084939566818379049239889546475715699769332456695393905467103530379085822427200561888463289104254422089728,237747987643497682310692684396402328260429066582931768453183309418205531803238135602633741375793175129838654499896942053582761658031904909939/125643556303779476401322366197170091973279209587708067684280031962252078596443722906960554510903174555942218753717632666405751792880176687296,2570024619021429764392805433606084167186124784458935773903793089472421979821835345475587874098998916726549190587550511136886489296667443350543/1514880715773936875435455588866719973936749340370982650708813532658430076439379903796271556952955729090668977148406413970792597720305071505344,31514889928719805467965438673439040926834266255996998619202143591943584172371728622957265232667808606795073306574962595587905388237970422909/12092488826127434309227372612238498277453679903159953089107274741946563461915885491887862098090409327566965459668290443612195069908023123022,1764643190923657023734061705736508085122342135748282772039576070718000512076910780849334436726442466499065483846602417319960668590962255472943/787927076731588981178056832859285664265605338956147220366970845216702963234785830199958743010508115115045976132444042772708651754826370726048,460993974353325035955199510024131062706113778184511289516182512610776546752445060816851313889243918719493432630250713401253341916380983372349/775248268814029609288523105816647776200615269656342851520748883240161207419055678467825689734663795535697585090228209626743667370951038382592,3081625871381895039810333658595753534141187802259251652068984159978939776213130649219331733745912961422063674255499177278226573892367033953771/5770245095207292189123831484786046457744162297377106381471287875508789429818138177197233088414076131387638435845306210712051787952791339741568,733713489462024165434143543422883005387543182688160958915895576119352050208035729880642772705508271556322384471647906931013523465548945140159/345785969444805197494640430653598205338775817998363070039082522232999772788901424674468878661889054602028154230099253384064628650496226983712,-79490117196586661829552114793092251901334625623321921788710752477566696462213474098281810027974594877182319626105093660467306814655574374373/121473684717542666084764436092215640771277353504515667776096118902838240355173874721308180010125673158611096571734872350585062644206640304959,247818347367408311424785013219568542530462323312721429860717674747800502312673075195279632005373881251988103708683912133780189603603689098471/865088390316282949157017421835251246761929060634898809210033052849180401278570534211646383211170216302378321966753968780421340738442916622528,-8479160971097533666781336456628938504509067154796208296343572918212721922804357934800948345414410446665692522660645753716542308866544807529/154154008948121767580782950089354807168683492549044728448661282017496956226341422343744855586924752428611277208805970458501196109723912741488,-22744761121466669811514855073400967611241112643251199639969840057498154691350592062211073465159093627332340298555957347475908371884891487927/137920690107714037293504778525879956941957969779526700137038879293604434679988156537662109094298019059584387611412949036393779555950895787721,-878478609703940499065240346689131305966358069802362770972947070691981098435024641250143459359165929870309093420638902209985311712354984856339/1978409485252384664914230354593153335379570649227466617970500577499007352015495301235509391088690637020731388087787095474086339983956674911808,-244628584929675555003360648268069771392987974724716840352112265556339890810389621943775136512512810094016025773386039737379961390076166370739/484833001705828107107526761930540942805965648390719452642229908507676294380893657102895335554208916602827255435968459373857468975314258116013,-2195086670189849738722720109439059916400031214368718257068571993306826813138694176718148694057439733396627920435679932821431632843539243370835/3338506963924372504564268650259404754005455973512315740948290573652475985720445204687951213980945668251032404853429488095524386203046431739689,-480298798268575948243494304214809833154773550747402334732430139648381995840884305034941564396341542330427751657268446180385019117522535140321/978940928128389370980838701239262805528078813578738140477056397131134790122888502034874084384525797943372999251385416553747190205922661762912,-986576963155994888702096736620165227976168944749012757864750642210061837424598342390699342673225478441785957959916220552172901477503203667315/1567637202318368480480959398698761385530457284356108641038131249951543143898887217347887526828838858130746328327339119257338367353102380251696,-1721049576575296636320825498808842494608486684017580402229185855948247935779724054897554645047101985775867419435650682715771459784335116330257/2841156432916669333581470757634597511050487006578226706304276041022903960584355611662642098477248687072059913793753560101203930626491521646144,-72229960406753474148929223248879537235012603425642645144909861830234623446781139170257815312717314462832764320644597177763049924259166368873/112284319621912947876735095527436976077983479087562327545942407756764719267231456985667979931308449601940845593289050215311012906473979810809,5762955933362585492953988257832942894622341168497152513724640827021853084027423532041570284404670636754360527948952552838123664655872717187471/27313688092301414276890358918498903080775510531266162530548193120984064316033015027408096804012153259433996920472951920232917009854618475429096,1880691934023630508905634097975526012004128993011797810433651247497581384426901929259002383517945399362825222087612371935381995917501367017516/3117090431297659443344492179668119078946390809703048946372803772598208679538188312603018139028931447755729911826841258932493069102089181672669,951962379368556367830846169488879655682135150105550985413292036326258970831042910003803488447164707455842141740915360488754720627301130238676/1666437306514577061133406015787971842772508039820786214476069401915494768460300522870119654780446658030954140446261064005143560302435467869383,-1711559400798096783243589155759422361845248803163620840560676878780488069911860548071877646407010758060856298321376277183042549110538017986025/4442714133385665600202149235037557807378964206731366323005270576260051251075222951918697898027932134799426339181844540348861162459593453300672,-197337303331007054811717475670841633219249687883800685657534978189185351046171543324843115334188211099272215345645856354621761204935529908587/629830972509951837364737488737358471395337097522263850642927462820376562932602824082235175840942628813130099116802945529373105370415480642086,-820741857761834602570356908933435325441952403832993776820960235713945468596539675273841424362150249803617089521692657701783527993651033532505/3224431570258326156512323900496524512127364862929952747579686433843926919325580735873303115027857352392089562082455436076565883899298349825472,9731527523743424930157141402619028470690385804811695392050323001693559448615727873638287674041146535878340275219408318281519310303541310780467/11011292869565019735424267362289143122466415668291100702584041791232893614744404789693269195657043587794208807786196169272751603141377652897984,9775252288141084411254800263212279892122052829717359635212528589262092837747738696181038924365090513165347926915660667581226940999629131684735/6212680213084468546549960321563410045655161752799040966565607964669960988649334669478620055979983835265617350500524661748351900687076789751424,2087989147628027153029545317496949374252542444980131503296067799579431326309247924094126914616582707682329123011347580824222393207361793166085/1082056842795620983242852492021957352878794327749293444014751788927594028469028940637390330986621562185839164931396983669980347451104902787264,191743062589984653082296581705310656675281618308701585582621034534803891385864592210503516860822082157300296101712377242808827928142894562413/468114082708097701858697427472076018627445515106376407576533665088908761674910692561603950195421828149149363883673150351041361221595187632456,7862979422791344519359704050897850116304883711578174503849820301960890305296824771838620870544871091876437343567415453449650731510729286763561/11133955522385317530672691854189752322989648157618697368382910548198996385523713846018871498669726217556513493458858119639146173054590314878432,2334860989205718737326280088306575411172067596385239141547002514775863777866226162180804341007481957474852656042262016867107345078577055723119/2791255000016380718460480604398134219588002886407525368703354476135836964424028685167686971778565702033171152053903004444875900665434495608032,477672978050021652455868714173298656749032140543607681700780868238220357172915798679613368066667358944804414681004680669514643952538840150383/273286970368435099956394450544235725799875784728991029230735519989679986248065630929807342401965698194924334665352557936520725052283424041472,190365703104960440739584787577260995066186869622374939826444932551275739566855174936745416364935848893873062244894939068457655904464991378521/90369617377503427823900295227324076274211754043331144869693159475373408113152129910443229717510817203441206618269674525940648771787260324828,1548945646352621083460110428502945281183221314223304727699905644646951612056669445285115495635106847486827735663804546652832346933502701619935/425165388238850784859811012308063092893212677573646305801993592668999938954073107679944408231873375440190158083598224563724349934955354784704,6164380615421576254995771655499207581446785552708384972077638984200419528535057794411150345240955097994979094530778290511462196744694092401215/664056728593962031899721134777335028791332297329520640657127571767920095668447592843014250430432658954476898092755596299364921434372899439552,922546374526588687911619140248280514617066231367484286539409038041770012899906842856028810168156905468392137902917853712692909286585540183341/162368637207491922848338103040300772964200186074199515934312050174780325992973473845655479593666730634717934265999250212418587981187407103728,46477567117477833043174414847766840642728813568280636306004916335288327898905103784955224211021968218244595212242703143451988996830014158499/14136803777390022981807282836756290771751191336042982151679132175800511133425278567464863099567541306770586108067946995252674679023333426260,475402260178427340702678670473117205508660528669805876078204142433790639622497462927119714443392935323961875502538064677070246336839355358669/111582749175406718377707388548635509322008524990086701378508690324257682171478146847190878526568639231917667035369847575321522388966484474848,145275722863639742935586029888139864211020197336727523853464202178760839209447257456692278324494857388013381119529881781043298486162937425299/75564416433498456857198394495936376552779722563576632536936206114879457149732059251930820776020180992870228359415741142620389564272079880456,2620622490402413192781129917158291408116370958903035590626829671014736997033535077436444724077546584402074935526194701481095250019052240078401/1428567843867328987854451579627799667160618541567215134365523981175765820137188981874925446753422428191517854408374592129258272031572614707328,535791989661619481576452614052640041446267605930573682368292801041727826213802962497152481496905599615814918220810324602439501642619521244021/169444323037669018990639122408824754364324095653598482842665940032473312797051354933862190864122705652366626399396690364853479492011776044288,4260037040505207235985403449478550941070526167993689850635083121191972344333053801862266113585035585734528791944643527856523863518455089217017/4149880114553908967499370590717558347761965964908885639820267830586998443046934519177802134522240725674678895430550463923124375205910855485760,665870866344870209249410491415085017898014995365380565528969162824280747274331438998098832694105628902921816713281829338887642578362532176033/811187716903703213681502559004412959818227436535919676829410546307442059673566098067645483057131304836661304623081167597482653019251016012820,2753447826984204746603812813802935769324073330616603972727341496610107642512076565769794013372628272067559592301455105702147411088585662486111/8916347029966908257527389056418779599179696785488268078516215500473641903450499344446196872710995072065869023546277371193356109489746271395040,-500935237197942278447091489345399936868051014019891392142624267887814109377261890119650994554724055333492455857305571457728449038774822785596/1282545483901267319812332825722315953274428714844934304463603381501761890625568085067111841947752632347893947576469001520697150144811767059009,-162712658359349406488931518329136798227798387415206186293941507985555075237008288230820530743158423805424886544812966020141313086758443542117/245963941165829118517933509778698473561796015774773503290944804543994570777441054864521794276510918057494415292360086268064301409088460350026,-1201399625690252139660617923551488417835110990749004528327865740932801458743296602824159304866823937104590101812485044068219704073368846552143/1826364055884736338146401612955306218886872031187327515633740175700441809955380765398647722105041472702401267408919496305659073925178955420443,-27695108272484986577789577223987177311174585716519753213691766453048262896265156157673599768062856696961925908697551893414917516429940504210172/41936555493231021587660059773324793924812953686181246305031125564645104597282204396914110192548215784154594474352005229491097454520217212402203,-5640630496270875459540293100388970851156204516357769484693731860592212510122329978561776432326901275194855271437461474204573235019136609909238/11456724038086870841596326060542792128626347431619399736898388753356445527998959731428894900946272375376652026178366544705455297146628322146081,-40686778934205091970620577270982032628413653514993259708487412777459755427603861116991662418849939143363323782100629241484970136330143192906684/70719502732441701473958505977458179917577354061939696675401501782211583252203798181962946853949710353801688269163754740230540882829383561953899,-13308092261793700548236968512909996808731579866654708624142576705243369139173986958097527341223058883212948857644858437279235629632214612217932/20095086734173004841254419606812558943590360071764463614264710823346524429476628772198404699112422469407641553981023777645871213982731671124911,-605396520843136688032135031182884778288393474778650765556666982196459768668897194064687906958068478662918951696298258154592746680395307896925/1028492991441426517234175409378370397742555731439524871993659904923749880376463968017564381585327829304901517396363630954623438480201776238389,-5914128720307071500679795624871100266206885943400221467120089969390539941992570743709096900896881720764420536552187120972719863971667385866364/8927341892662102484997891598953326502268077629038177958530513887560842033217586023663352144590583073862800821611441996373162182634425652966717,-16104265982362957118782767928197685296767277592658431251373898098676660169191721690950270480684715713751676114354395172501798101283276271462241/25349724460723831486698965235851340665572913528560702467038595457631578966174633497955340494813516592130226142270025719187917175288103788094873,-2207995052475616502817386911065462928253967946828224210820418204415210240989853768860111987755843839776493349385928704407351738784405137596588/3911833647786773472124295914582302775650973607266751486579707636655504208049037762646365598061149850989713210571828307096686911981022837868207,2731671335645193498048504582599156043617076635801375089819364320906122222719431665597745472996523859764806503284020919885020309178982957854119/2045552862447169345705738308860797754080450378443893425282167876292880543930136276489710925522950860256583661615424968099907486555366697656000,127841162878540212409584034989875441014614634368382241706032009537886681406526003080268480614259274796221540192604602495394236440118844130335/346491110783095080964997413961057319623108991382241569460137877616951191716875930010186291161730569080130197475875228083265875736517569958468,764144834167033314973732589095169932430783494615035331277946079303739324906277925225485479859435696754626610140559165232100227811156389985/5666800958475340542020018855845243482093308967718236817364464153358527545655918600714551884596074085075348229527515379370136425618249919373,381415308340785493546305812878582181506495973167237320654986247359218538303778796448913751484910192633705999809208177228950023412572492797/5676158039020845185449609302925971239406463214076334682708686998032746485111713855170219968154261534818743150174655740273946527487282622445,36306636556451700655676859608510447408708267486235593098884003899083551374330210899070607860773267181108600695775455283531856746804609799459/521038016961988161790729698738736253036185274643266984742355768076876665909131110967476911805612724946135977625624112113423902530292507408742,695732513930372180600671859746039775008545874939042539414429418728720262235229219112735561034072184590076557922068510756863174826957703595367/874590743540528423292163843459098970124729583519251162001583139472130746494496769510337963883229524800609848348584849246685270428239919795220,826054116017798099563600938812271129333442060829119821820897048265400720815995921740157204065173784036555128586787551476079682339497606240149/2734917477045947850330735394390618068658030141458618108954395387901054711519108124336537928491252274756301715101864311423959420477571727479900,457844059459722866013727750247996510607010218131945207261905943700648963940618805191433378254247326052987450736918397024973718482470369279235/965730339720569046499052427232680452373736142156357577356779613692301810020162678547342705036027649500438435132708628638607725560078473496432,7997682805966626625244823490750846576751088869609254928396264204221018672475580653124266422484412703411641938350301704132027115517317708583/101192112183440091379003425055352737621951740806451745898808672442436110229937682202371029578030718905156112119792751242211961517044965965254,-4146530012965849531182963864034687051026214564522461187533557662337372497181987993520797222775928010341947990589779093069783601252628738754341/20247421150861434373277272903285261156885426417521736642248712502691305168714109232196889365964179888749760127937877888650295565249462950441076,-2793656432084427289865410057822162176028464847954786617969707120793586078840616416010541870283622301195576543933929755965531071516696804773822/9696028729339502830195211211770168568383179169468828987884923965717036013898372830632381939624744624300482400640085487544241630765724650756929,-18131625696852019996163791759586552536106896664139064973500898417114049631191872019515652903971930004677747365306754545267420617737561955265/104845247068483091382423113517529477423087563110450274156206423109937816608434707512632373601208777192463390357067153415054731918510250339424,55622682306449702755752232348939805947044043938811548667306600777574004307516596088939527422908943330800243607781175608333098420361360209327/17229003446448758035802294959038725280073977442549866187973774609521412915180493168445839341146614512734359806649176210514458083123814532480,327475799941478644245232661412392468441990582082545311775834310200949960026622712048056851644130307938359758024631187362782135617693696090/216949802112745165703323523308367504094700389297654750991938788589466634308820376880103449425794510658102175779167031715161787408830005471,25775528771853240335610875710557707453689648755833694283145438136005734986153060560778591905982881580274951933383272979939629484941936905838/15065265059191852528881041928145676069026326882489928792512816900713657164285353791354770313206870146074710647958008602759235823704025407261,270564913440408163922112960100202863516243610998151779110700567913673021430136150683937221197509826016636630935957209896528355141020043269167/161701616017482091285258395968103127580039270346019837526149760443900989436506472110183930598787681226557007424221090525869748931041532418734,17552981767875626188551247374022522217862256748528341326001700262281530015265337644745979398200322267111279289092197349081216848517010959343/11142700595254619867064736893220608653917553592563294821825512062834522602783488118518043487195293275244354067603335034485188924514472039638,19447557631499842105793565278043763823899771586079223582536439692902147473087400556332807443136169478161294055948245138857550208576565527058/37101380301698201107783247887452358320100450518988279766214171477599750590732453710099447174067601562853326263490167003364793991829335714517,45841760785804204548541131064484600232400807933494906712253730852462549835334080371016700712875660829683349801539299146804712717462987868390/35334138673490456305038161718578584797044161570410019386848688183750792931784198664001795823761968421701554912194072300543370238634044611711,68939804760462934664810304076479378274380330759485109721936605767066623844076258733645211187678888850749829005085920205488465670487098829288/28795228749450235814481116722854359726107856507703168089188479778913102145288618754504211505184332785619649558906613701126618101390268597257,532780442818611142168644666072884079917799418692101623831780524168844335008661178658109307413195494299248473774034589222713332616289162747327/168524033556676418314226174038861007335810325508727902168814975708971285616858567596715574236899492911830561202881644674145358942228975039200,166668990459239719490553122674136061243589826310790226101915186546472973854298040055461228535738964467490227195088368208135873415078166512269/69327487263826812163907754051574436348489121669697362718688425519926689891327291249350409520153132262486778768796452484474096676499428185044,89645001781174959655775502131454209534965221695863331037050752645310762025199785865505960824468532369283563211673882215208236405235721734037/91444219710059502619148224952269766945165666357737252183263921749422303401166569874451881067606949999235987955096626471444928524681158364060,19302772534540810801772163128588478714961115230125130146212846453702408039998712360910850671995220828342002376483547396605169740387134343017/27610174870439927295895479908254957160638638487894767431193878413350873476237312761508843051324024514429210607384469677474930379059223160342,-198314114452570922303485854170217962252434037981215220838746471047578511299105203846940185932094075159920067380783742792324541218504076247024933/1104229362494100529989309347276093378504551769497618533079028236659224449203149566149188939464763394061500081531713615843419697560918883604609452,-67539815202866375943276783231862001751225414717827151391656897003893320777609947636273143947214875418488954293599881472218677986388208525615356/369400886739182592963174468667704952246691717551232998548613543863686669655010817087851623561259085488758694389756505872133485116677428045229699,-145739226820093658222031826497962262007891121196909763039180163236177768036142556572510573245910257739373454734556053352928974594595064269952093/1080071079976524086743662079081138564264016302574066106940817183116890000404829222730553074203783830442715099226916228983599176120917036103670118,-5189715059189499096767706682748518118657961317690890915744755175877063442057697824542929733386813083932517565804619448751027435275081800288286/25421983853486362341614542198445159260897992125014256887204001768420300241282949882876659670221879526803877585188067171244447257232292738628415,-11812436304757421083382544553871278491771024175754698059131440864839998020576587007070849651978597790331902105460623672665252055911514374853093/46101976656681329348430758694040680063895770178331721597678618960444371150642034209015728156986735170063930598163806697916927463066714846606614,395408205069371944828610916036467333570609081982371784065320116012899908203326023937173859228467163038404855984658829496772157684840909849203/3879575826307628938507391440181104989512686169882589284190447436822050825001945896350125599482828120095857528585155802743830469511363099971754,-10340315647991197462223967776137492224552549995013495236129894158102717811757282283703116327273500177861409184724289279647598814599577415740510/55663630058132989247295267264820433120948839264692821502752073101324916038794790299918210947459074725398017392759272908037058666448779183740557,427259106566173744225451416927543552007692511918957977846224395180074397641555570428215540993381799965283464088577928781175603609924155209751/1045569309411622854093843325665402059025381974678113490688165628685595337708733780953348801346683291437453121786394621024427919454988774350572,24206664605706422073270290966274329806235453703037227467703642524696406741696065689641808158701876211331431817664530853348938105543807079048/138380524440244307379603372353814740860569775250384276004483479917492966532803457876125199113879186169323241403116500766121707081622751914015,452309829117579915960387304658897993900482986093281377078159172249608839939290714861638163480893210894371531073327486176731359526814680413877/3311036490104173840579661179740228477061320836643735189629813919464368494361128148047010106610259977290679440819346054813624256607602640112935,-747542063282369363263934847297510754036939483595145293139991129314856646801219418147998593816494094239036556276267396675619375189578522343132/2216696167256624245825556257857231227237112512101448081709512088219650302578653901798345157600323323773187044595014466986725706924652764899019,-11684640478315242866832424467694248227719855274615900940114577026030813618545364613356039524641167389791337934152014171162685711687796784006916/32827946430409619642742568322824593210396836766548469576422289755869335004526562827270888695166082274661816782244769001370916902668603980433549,-60305283012769117751985605204691270215616736350200047983350999481193443875949623167863693986417027621545160856975318283073501201742920598129508/486109212485537145597996055257184326274119300454187627207254884361355698786667681259402882846097348838905168213495160912814051462740575392899377,-6866266507732933508083563829538683324480965161452051370269306906984514680548839493425180776912080133458880421742349481803904993130630235914256/110453015182503606593591151776099014923230260169521308753002726359044809966488698274212318262203740435306720717216317830706669233332055627650975,5663900710110484426707133057462733996048720814690407632997255807840036595867853886920524047730125316788538797895920259399497306516250276002440/61358276997799936117480551236839267161916360859531067692922896021559485982798916003397575070580738798400378934150845743167504662368306861645981,-4922512966434824788117525534682558302027681055961442410535192549710757116936492353292828001866789255766507244576225685260253218141378687036260/33064138886812227009778418007316452473733419870652712836072993989821880036979667373828101094043019739307003345588382982676653384013631474596163,-5051960786896192802653428680977051442057981179267230673121412180031003161355057286507244134390425779656803045296843871382117643206986143649892/140224243592558599374184484455036706638993352129567953157380146214820343722947149352855973164621417022552540271133730767272164047978352603612149,131060995416762030846070110000220127603136601706406531951419774188274753359671210327281890399432688135290468951931871037972361941470451128911/1423690985952652667136198889186087437585886504533384772149067156299286630520537816528759999102969955830860931183132177593342049115576514532687,-52236607180805416644996955887884248885590243071905571930884770455705058533303301985589464285031511865936344296070683915361698543898020350660/267803039602623364439620668865054390831919467491042317830470349059574050384313454310985214703546437990911221272601458334482805773285826039341,3339351399013956881507073584941489002379103579775897674198765538402906695345477009516150986936875748817894825892606507151191053764988340824/14784421825941598866222628121877879591076589128293577363771132337410931107915584100531971261065020444468545233880179522306471918880131066141,56676038250060744971482568861425683591899597408575795466732818695660982259341227748672295223754569958525357029496091327865362005327805647/83721468626564568855881311071645800997561586182710388378320583129044297599943916518329744901537242367684208562382369480497745419030619205233,1518790132225766737010562751372503846195626295282532880588184044183615158525580257982326323754429964305852916543299069733591368164681454393/10902494996130709695881987358751243295355669524567112517739932811366396792485604689386679054277870756406948288575225267888765123363682527108,87497765503266583175582171089007812927777135233912958861634793371037505372786011961204639216322067198089017532102634818441696252335198809947/163769100895805393847755695641043880462131111214987674870152476731018480872324203475472144642171897424081382029539749682143783499045943472122,613338725517355869520054094707384958465894091388522949032238430367088676710912546215274893216322143581685537369798138330828688321639224707/1088226508238799904183165029423413069407888765314078988499104064452615876142436475266167234606234193293288302402199055429511288453278798290,2409327872296317718436811992233918435543172233151196834449207842084956820607083371537142887897087087221198679757447426855528465337962889273/5789737503445562387120548394814446232940194014542074087978613722575104615780936889135799661814007283125693201823624174012799801029900569987},{-826427346634531578677771698955140687411984403696268063170758940539980197183382551131693180914950020550609702285817214135308722506393622946565/1524346034436250989118886006121912260067921958543890873160570976639161092379342911130866226203533504137672788951806741048525723976540803124224,3655921415878529061189820473610851748768371276310759425114379382999005796499988349528430220443249323986269312694602198958947147203785841309/105138383610066406394037564819789782698267698228558277460373199361536560539253841364621260399723890723670801337455087049691496073016212119424,-90214503009636510166510389485349136304217563318880365189518557632979200630412440170813559523761459492335646411285065624168669983688400538365/1982745332743761962260561620132432224969313637564658050382645947242320585985623493122972687987249587015405388536429986060794455345019153374528,-28249831127247768594945451939195662991314540198970990435983022198456381881165756495783862940379522253501553526880884702887202755703228842553415/10747617220791333432062195768301779497432379198684069662469826308276410631783129132932882297735866932714169490191652650091825465756314317519576,-2404551562150861892333410136253137625829610137047122503170108190296736357243789114094273163790733383566344324991072500759028684674237900359041/912592740807841046770479701173607200452682062168727027117823181494745076672937383437006910638187425188838907402323132907586135995031465044576,-11836459539928840095406659712616161002700670504040213285930356599172169738798177021415337970091673107771352272905929778268476299461207578064857/3994407428457593313936247806405282802872147591847034013564789444003077276605455220206295352691644780515938354803562460421346997800960786906296,-769721445667337110952499473537899936827348918338722155591010207045296892933754491842786115010894669535862284952423031308229690964608150343519/259975541247910345109147577424966195974820638514887133526443240447304819820315261180348074692484589893772461398655145236959166596719721802984,-11113757298700986195027199384120355694890122006257127234033734284860466260100066000743870853951827840713158002364272713968682988637643171977660/4234907939976858267164364737662844486843021264301493258955111470464378387915597916573659956211106275123310303759580692924292703314892400782769,-29180015638634034506554488542890736815583273856580377965252713743426827033047450084846292943549161439027438077957241765137267711456586235925/3419533381597502843410892881810832309945486363921873115524530009011595848249529934245778696303840031769572365731698339338554670152373173815111,162617058242006650737756830632924672942080952042086551093477387705342906914044323914152599751783149158252908343538456185308899472185782329787/2513545110879496996496863122233059090903665683719135599508640645059041602072277705969278769692784003322393608197270870985405546022174001453846,640852712021457616541880367464927817414678946770403488696427528706953962283372292473682421694857507155099051872052801853421295717711677786993/3312159549074084864243493697045270211670624294275031143449141348152602156795750521122724228639924683246678100748896023322319389457715795159884,-16052362061395274521795407515022053212344355017063314702417180518744443290951695421322254199317922788503125130558058493746299872734700901257620/20649136422329455902313527703085648992423188004617887960841752818690091768793433115337460036190887431741680825910446398968709689303567955057307,1462641037809552405271036806536264580725906319775176989754372680106409060866588770863027346590598472349351145386119834285934956671310704153427/11746238880190897641715684266793055021668746214305721839756198453158160920352889224340989471969801944768258326652413632373948193063789469086158,8050816796613329175399431609099176605562474926291088100973351270809469591986811915264446511276253072953820588295857342467360726840410747434463/35402256643934448420903002686651887564676237005029244866880392962276686624596543367408745688059792685422989120925332752056452490384957345997132,2232529579151671627786772952130645293405982888154468333645083873361896408846665661342952708204603406831720163471948391839523664215431195432363/15325801757154529826579568671603806170896218340017228451710247593508469113149430963266325200155377544690084231818006854440584784411506350360788,-4224496936262532865244604972696355275237714833411088535030584205210519439428081171498853875258536002374366688163751727185363734965692749969085/43089073736704220082931650345405992201185635782483128544126036029837476591568572985611287215268411660794876234981653983763818032859640935480211,7090476102475596044923199777453734650227273110905454955248956783783129824251689181748474750418317630919232278010483668546799795838811475231395/79468318232080927320134389624234571603096340178133935316391716579243292211515016914752881768082118562037134393744165181936714624777213566286534,-745234022449252382730360151309574690659241425052544839136866679712236146167604167992647245391273947946666191533470323745249446607763535119117862/7098429957929935535358029798253342714162733953979245353015671395481333042994726090236587661250901769358367197374200226029833931544488035316964139,-74626519465236309327569020299246991593607069277825031859817779356145234615807362529229042295010656199663724760895643844996189818429980741637314/2337967303944368034369893084378245233965562714175095123775989274977882342371438357772173566935866582541106559173329270649617032501967081606193681,-50211023552077160209646902616253542975994612239965103576266950289678186618039559104999911994050409624442674118720817834002811296440861356503646/67177408723182197075556093914796832403438788289127882908018073139251770702487454557320517708074686068928075637035186838889487895247167458593623,-2991641084573657153356578759984106641826832040535788876755699101227808677971677853566992514865527175687127321153172886022891152774328200274454318/2499399215304518112254614970881207317953314405217128226944035950888198940165163038636229087888784911709082265777771803607027237643983323966583231,590327279797421757919015883943772758724430340273893772768441320264185211132179269945758176517631112391688678448745544799774577234413189339843/4761060865265501335065287050803119840829061826982269017049233128503316140949058611549590986241134761844834658221089230574492226710041725662290,2192537305543592970363479413685334609589587783362658916724350004799180155055860167757224863580240330167683522904513112780219115754436740591887/16739359423535111428386515208501875716454655173921131804029636844612191284634899820493658011201882315765993229823528000624811973045452676866987,1530854427213567859036802516384594806795237903241348418799804858967014605021465092383047462728906023350195475973867530369926942749379491880802/17608948054502074545816225129462752751890984715980038856909492677276884697024405877977121179698639632847151748627931305671610667717094296154565,14527515202854840559501526712475442468253141817878404756454346497434425475966327887210857863965927746326909974494696175537870676127543386783/174718818235656260588592955968730595070245043064779629181017126699182769152854582553372962942130479083955243205358085825195730996615127722880,-1471528689261178330453802276179345420971053159359502929975354810443869789241982744477701135458505189301677329028492595457755483104094657490052/643927176330282282906853147365938823373720613249482198008310418664334553515570133928310068318856867020226917260586525738252909199601817810745,-18613314914653759056794701336366773817893257242174268188403818730830080526634819464705255329744994404400088982701185347183757253435861403630132/8157216135986461000023542974093573373916660861882648584408071359725913906438401729374671631354886420956905510290604658648590322805831167974407,-93625095079739180166901764067490112301069540901513491254926558438489541386342158125112998551821994733635223912724143914049916461272381045388/40352781761721809238314031256343779203930674099427606229942376291815441498637770172142489531525565211954478885851090904820982948279978882827,26014380674017040984637542745483506487403634839859467408705082448073268012294890206044609172874065423608291030615707953673552752972334600048056/86901753072450830311054495428188205085832958936649256920336576796470092876151610106387987635159846179761349230310998202256986917143395324206355,14896481271770698353144754851748170863154424623589094432428837269248962029070437901987824382509133622817534390102519147412765410458665871809936/22998100842242539518732123755997033357155001955346942341090888405815161819317932304981115010447454412333370147710678013622106328300674869932649,811250237057561963672823041082208137559005768964756009070618969910947406916915442546307694124785651815773940888259253488002487459865597491384/1127576314808945809213914257310512280899095518277606149397851676150692854303368438264105250458763140374978088432921071205446223519729068203283,34287921225227339737615207582122780941893093287687944372727444651120675605477188994177043289970184078177942154221340404427047585245428690772934/68573862228088365515856191761976748357806929243760512640892711782083558336926689642791934655546521924329942582504352224029525523576402989019391,1170699973878234651066127156645220587229395098948757289077627333936907353070211141660444038573009903989310635394654970532551771915812818524022/1391706759217474205449838174980618915228496271009918260970221424140026668172913211013513526094465072206761834176503237914267832961529458505423,2019141115184883822427213391568638260380245285233339566780387383502507757794868294466402147562511000388478334026249279920913891381921593086341/5310283170207594718722506139652757090791079795184190829291816609502712107716342838361601880984666675088722120530816480054913492068941929453634,18163652334854629285066788096919976143567638116109488007731742192481640867532284716458402027057289360296719749311394524299507913310527405612582/34749524678912569357390646332299144865988943222836389924650436037082321949770710289945430521604897339845431110088318241187401290358118985962193,3394325569477342413278541267552414104455379926253602156365225497967493352035365120494618567126654892493393679180111342740424021698224699452649/26756513451039282506789487755747427156627175785570952208056952359991586672787497026578511759818928937820712234589660338179076770897426772193578,2049273944596401371158386118982216131346588377270278046792802443955814139783232986689415597830675162636402190981521802321778447135048571231948/13210908703668021049951195825704129343701416874708700910913876846604878996672561109405291951622364787768181929282167065866916832290483763821993,3011064563863187575044132474281647684015408955424761473917597792629586730491251145689494118870718531246783456764690116327203450927638438316366/9744272897416758221330912700566540781349773952041359002136019873925102042837808045968988454883944986025393019624237690281470949220383760388225,3103111761461285477824273741940206344622202028912828152272178476910079915131273753162315414283787292916541496844900003849029208580039881591522/14901340519864038396830632002014979946631875441501813251452059484603319915456342363547215113165114544377061258965740373067452084561323241305451,414718691545504424804152187934952602252121114160485667927751512658584708105072281596933420128762434108737234460982671842030145085507910390648/397294985291123729719228218875775266657145060817681956552073759710882040781010650668026150592680728708919474050048660709668400415029831171451,13336192512296086119898271790345943277668104360034092747922659361183291774487752845247681634459106074141532068682399294605382787835623696910274/10997772797876053949683740460893523069192715786575024625454351868769308955120389858645278225509377155614190086486339483712987463650540965847131,7627913363326542699929071877834080771348938499123931223028145060438266776882370967097558852660321260261878477902613679126512235042143583794/8338409692585503636193718253110364030945055079085527024225133393449380480727154312338535605372559980129290960400001264499349638154687135983,18432420994593042040278040960292363013017321533082800994259685122632467000474331929946730630030671033271533371458618615171954229696529446842408/14723167889735304246783077221762656018578299214600549190168697599617922170656849418519203071826007544149219123614179112643940412627183061656163,111168971535567988088023888468238455129995037622737674872757488772863651304700713601943933270825900701088138772040551882259086919953108277724/77080532244289159810332801972743665796583274714949188639692343845668527909054605287669906982860399388762952760871185625556631128779848081211,6664722321840375986067557430863193318842943159402295838125573012770080319967420712517630723559313657893862258642396881829497976626290167651286/8390568232172214491324910277022361716852931201000213148890613245427998672569112710860475736010430126319934474081152203445058004959437131618221,3251947844963051880716644600727598453077857352966983537828141456214262779324827082973864217502048772428385098359554857020304068482910636819476/3105289391536659613864272269782135008746456586495606627045543794281504094471503542456426400307353299378943749191490328902977793149935212793909,1375250163628618546138226054691439315597202899936051687980225855316145190143740914739327780137877295045904781405650632311189047229725435623585/1308534686237526889571247312378217077795128000463643225539442628096318799294387720644278251076838803413382237324941840966587654270624529873398,10781505120938109752860876962278224379785923655736373319741703689342155999051834962537038734452294820226891321285365033658193082717070019783506/20312018986342011153686586678156396988762563695631062345342015274602188172160307673520494470208476710722748650997031089938668384486512381449235,158049759650937296290782187025623112287495986431137362693354835528172023861208039999555931573353514023385608363537254665755547732482718582729/96209567861029802935431596978563030747848384963404130790885408052674882341404992280505614291880437370575927289140372027453190366243724573558,91524731967452540264639568843467484378460002003320388702361561712038755502122285706234322212688661268080315002861992299432787381688797034982/469722771330711005390601758415370164792799356894070022371433078529281629779685335169168513829533187448326211804784077681972570193328519799431,8207956477869383652531174017702278566607231451541751591106338181447902360972872408894272145599373519674647621928840591532998611809196299666162/9623315661813732661132399391473993509216556191527634142151213375194005945068216848989368860537978489146797926911089382551280721344413063522621,19939054968206859465709137312738950190585607782861234936141825956576977258508690554575584903543459622003044336228030055703886500773553542154386/48632454378820144643890882398288938500833950004194969131498880071363467345374567560528135899204460163300436634135302882391962634136706839842237,-180594827072419658803655373683454409178866614881736920430984013982030080567376847130276863649020626585868372021058658491986085770332512230322286/1374087140217073429962153320380218715261806701036593809955441246266588439519795451188664257439431235809565847498754080051199301055246998492073039,-66196631979671142460171480418196042923490072143347307917739092290298874984770700436382761618451059443210796992192590318965406761269227020663458/49396106479013760619872160861680012595121155495809942514885494495218658169910517504420065577112245760828584940892000761152204805950362273848721,-5176615032591252738283775262667542072884434720957485904960669827837035438931280599804389022437325117785470347975363996177842986124042627335800542/4029124768502246430870903410738518009840517816972986026489837744518631453953369234010680090977789047823674011868727926043429956342659090972824263,-209211614068120044040104382290355652645064099999863078225911037543031226559760385840328347165409855182646381384962978472785925434037614389172858/488665203331399114309628242747368596853407454392953685940549782437539239010526982139139662173242973512745519248380931476790036634391606555534317,10479609486984992441735692718457906012884428528623603611288407664317810206294895982892059261602730589994411419799350859335340637422499540222978/96258971789799378706620455211789574844972465382147614085560820893777389445253724424826158621963504182464200215582970955089748956578881460408463,-118493062244242861102422278765264266063462411660614161699869783441593991722609632817591128996627953052970783364054352112765762335956640469003118/124784094116346737494843008466854899410448298848218839384307882569136535729159560232446898927977553433355732082367587331596215626729199542475751,460668450743351488586602873521004930343754216104145455486492468221911356907736213950020976609965529880178184000539480661375285969421732976733226/1772674914456007872442942993634922073473183433161666321466987835141425243016234930235517404542983477390629897211322107965996266327994610906040587,125845380154610537311285712321248250470090004410427287902466198603003718604106903348510355652207367969433399612493291948234095312764510758337634/454551393339753943081798492455930258191249739580623780952527586143861875547032222399752981188320122199857966630369453879156723695730367500947313,-1033878537419430307261657976207664398613279182379788061207515698427193446867411294385404014369986076196072689218393304839890465902843939669042042/963417593696416610485504379835575862619684248699765591147058562697478497328853260222156835465485188082396755940978972728159448789510977892006253,116411330478169623241951998615535049124329212807029961812888188298425179382406080063651551669389466805871224329078009101150619593368955821037962/135776896443297688562476641237506318575979935747262972206088946208133591176597071492914618461986695431505608158200756737812570852203751131151883,79349493252752135653176501654982526303957241479247284357970798569775310498623758418314180951099974085974508819290587068426646849636039701047958/152735353255649170898115890651787096616207531908779634306279586319895099008217264442511608798301823017179773871937166636069525776931663634070549,34164593027351801368784578498976115258037758102895568964406126364600781399510132051463781488217480743214679754397523882782780276975000043467926/29274301345931801194247472103016772513042969356967210227219630930389018567786902899114193727646296728168845535504413482136080898495076842310253,6348624774827274312224469117566729337413916155256776571442229820428079505102018911532484062638995678175279926753587908849000107529531557681098/6560243420386735745875341687280954162952915127720153786047069409549817986403650414409353939057445943187886359225515824290867574576211744102051,600296666064867859362019946197322440456989109181489920387721118017455412915100812859858711948688661876822288336357145953005049082046171600799/83614625181218207894356523764117931826560336393820270139599617882323429854822318746050278876667722281066059744071056174894070291371774028212668,1282200664676870461434868097384601661853698176698438773585477627809182850208598667586236262058668493958556742342123690416312267760405096149919/2131260987655055534977898291538410612450497510514892821094769593633234982862219785175939003503002327054795042364346101141220698529789735240900,1243570400296850351965755996753041907992061512417269912961716420223733767981540211142346996884524309357536093524077715916421478959383570062489/2183634969792995440490300681371076023708838460548031885424051698753214846436664160543719238061933288552803596053687820595262926258264280139003,837348722425634265854175533964489566026278199054020393755911581565176330289331487070877386033010220944463377802276749018438118657041506588282/12541013639779609628408164040122983273888801334758707191080208145432262526066533867369907875252803217660512595746841299024255257189568464210659,-5531035109481598441876657147611781638960116561572825809292427812326558001306598372385686145207071216563666375800363456268844856422204828508802330/3215078369693142403836601762322679894499900320094908347714555062862805956613813617700922529043486039356868849742013270761527089338033600267699141,-1843244786594336318689650246114142782649696487134275365584460086863467567515520982524197888347019323970610857891230857203182540409282035146416930/823765770932440808635762150722804146923616772454678646502035450902251275022221794341181728127785529860276676216113880453611510163875261035098249,-121716038502219269619297770604154859286593296077624002398800935045984851681999786873498301848969445433783719833871637320508719317158491666679010/41691683937934664897106630478841854363619004280217287321660931688459510205152560503276521433003499410920386907844946910518641335057773621065321,-13070641255474545561667726836532797104865910939714456972792546666711169369128380678165276010373626388993781624412428518277479841579563552191022/38682144300428907872237688048284800293724968865669368566954245884398906444857991205562923854876701680017696521949372302871891225398970537458231,-28919052876460859562701528903194786509184474926236766589702979658970884224571467175359558190659337798957778844315990628413093112446809208911866/64962504017537856489173202245559062656341505053426091383826429237955930135112264483553249183160677049089885879289329496534104561728836182786225,3601732988819823653264794417906935733826218294625614934161353923301780161267748855279183509015094935206277924695181417213357609822371220405002/3829339702743153288522529419972053696206093742234902021837647712747837701227708673107838491063113253507169614593510065823165545352882459331619,4540366183317380941303910064535791884927506596670397996017194336869349304370485795854201628721680773618141549707594127902018181504475428820302/3850953289973599901968913657212121800300314842017469742205183755018645867356016101272108493329131224373665528349707534257783630419705327529361,2514367485564445240156575623682722992378851730136826463780955938271377525764160122410422294633585921917992145667438674102892550132629725676858/1706069634964987279899328274109048418470194605354343328987181087770745569296777880730132213823760183629496936046720049113482199047072599706579,703256244647142813620703082103117666893067127511604358380013614969252976392360487828139822726297446592741899367227218571747170027426909486797/521020827999810176353539212488829715523594303774631531799869361258806896176090282221856836709537662619243989284983580302521533373530798865490,1353095782133874218781630907412260997236618605879976010593674590940692723412634647929809384994560038618073422097813501201737933944858343048642/3893079236405138422076914625057088466939759285948633377615350950848381394531874354832678725098557279035096131095085940255501055447736366260851,21715267656601164735036055346048799829160198632884336443099676739343679213698722277229166962450519639138274673751560178430322371881301235256914/49505275562501263522635086713964404766499832300600897790689566259975737711429734544818055514520302485943091102897508967360666344177870172005919,1220348583477362010264396969843347937656913144310013813212399479373391008050514173680894965819597588434728109363336502317808866611817506380138/813737592867482282541981383851034298820904152914163147693213102568212167587038614332633590287358608057496640595191098547451579890948871155771,-289246729079542854957873925033807858375629566684966070828536287820685728222208876201471361236140118578895878648929227247943171305871175618830510/1112202000708725030995383762821475559927939711600068687443007538101067399271902439219145558692871168328073632082898264293408907683692661767911239,-2132216007027551428375021037689367223472843864921961854985427214152900169811828547656221283064317678684716423042480106000808088344419827853360498/1213842023072313566172207963253544432990874674120596798977861644083710029502909979342656838848181878142244070719698142137074905301931115527786697,-97580436229518971418059469429721788637623620552665704438026137838336040360068234084761164987266292590411377514974787484023889196644759886468694/157864677731575148033090521110876917573818059799466853672663222179829451057193298818551593542902483802189687623116743167559149465153840037509171,-49126301164548940469370987676493105144338544113070966806763579671873689133202085577453040134029148700852150904029834822198620652941354712545198/599085100259234551311765841164609490226997768430984984054344612310273142676159236160387735655048085157964435438502278794275395622043318541085129,1269085531899538525126156363260611547106800551566597950096057225898928379692636422280186659400152632241581625937707110138754743721163396689957/11381632580391744561319324809683075394649627565803160489789452334207240287970871889572595513228742424984036742451406005068944414529409050272734,-25941048673306333543521257301067420498819031687644178284675230296018543609001879444679379553545944540007972840455516111387470446149573032006906/26320918081547438858450245296941932985984563390840665870171661544268914594741042767365937470914096660948355373223804008109675763530327040691501,-74105917310915387519826595529678503816676391238032804515992267624887446668838639047575550790858756482639943667875849801328232931572550285099434/128792783737485320893415392433511934978437157973833625282307734485527457314575846900925223265330073238276163822670428200722054706346876025261109,-3187630219919984227666464195976714229373508802902043269622575368066461328221125300482987617317461022889484929340057273970384770242537771588326/5853918617803301024883003081870731159300796740758467498523343064519627233320838964567175793561155822780125790056487599670266940723292706086163,-3223189824140910662095558331464951901771322474012768479200750032081021370805671356827347113006095197193769537704824484809328639039403095307286/4756472323353244658408233556347065054345631443448687960714064857840621485411582587504461204246598748838243788379065625564664067929880989487763,-3997239561812655198349805793075023829750173039213967687186844491251668878856653212740394953939054957920154561338800128767808115385138484914622/5399418971812659642950954423194132560378828224225613551008954416571358550434751651858052026476233791092429665051208563449752095681515789308231,-12564642283577190270324948465939685135732205844137000760849980049515953401034369344635381928705968627662546187377954266876560815372490509796830/5743251906888191523573042893961753094131331238617524185645151681256740243780383111058846727789811177036064794631776835448543857375264477472027,-219353401004379488735207729705122592064272819336691216740106606215886398758001565299956564736043029011226023344292924562877219540424136917389670/200610056287398024395297818381633269117128515242500344621971349966513573425143128887026892866602314931016954168697273465769862065283143408461211,-58214320757338061167528817960357984307870947248968141740015418264748902696802184318411590827592074752794231259853926905632374777729279764058330/16852501295186239603403688795562837329141270903590857012957590896322760604415247879235345507210771249778587698701202704212110642276644048415637,9219238338063368364166642389273458016844742764044486212257575618262262345532851969984622567277209941286460138312171983902890564939445481335662/3854500976700764318667584532197169618223106800592291256174356586427525323011623313759389150231356884366814789938355612863059120349904469683969,7964521588754313706407325893694849412339054296710691776316888443031941089630862277144958586529521317973742937772851850168234618552463526937086/7049169302903585026569111175684918672286468144528446097803412185637061871403740192420192359191526523891788195614414081271581080784604409049509,2682143902345560527301554314338233897224377019315653432720314356530035040906712445808712427618952272027604789657010559135963501519616109860822/4516853143810079550290949662994427664398916450480665886076899756630885729267046569763605931632329204422421235152206848730298056607348613683927,5324290960641326659736335307275368367425965112104259525261826534094914197888413057865042816442301819686584567735899312265270270909649880396962/7986390930765767572680846171566421752519802425013062287921107113819209918136008178059559018967238959857015716291456287990097601370169132404987,-1862025354498351420934863932619891504810107930409947487251152189278522023759048620335969235050790400235294693113164562819903053919677604795286/2595828739488496289972884672926410661393381333418190311976345539795511711303089715086358207070896528244899644364448047084678991018134237644691,196829584982343047831863383107343098738691957672831258936927519753281025795625601381664186664644688028383922023599660243540840842790150925846574/97172788341429707330194553237152540354542511863929479650160371766734772001046557216169113268801133469608770073881658113006423329785406258173833,28969680751118802297921105810652710306434572242868980598919988313671590612730627226630298230578719045366038110537576691362822396349588305850298/34593620249717354272833554511606790347491385390399773527118101289665932240201770331886183525977310683677705787684722374004697338395615807992047,16073053940360678429750650783618243930760388971743865777976980470723332412744042348505540952243431714165731643834687149342176725861013993734366/3852447635380702054268506285317218336842480783151912336788518334734485901208717267945074997391754752651775217698179338609247758120765653889197,8975165322189098400947311346209650526022948733689979737497194517572128593450083282235002554702339276038234651997482703750990289083991781109994/1213110690845562841417315632247646752193826687615130605223487504846167243124994547664778119303933821031626810392881400213547758498617366666323,978436505597071998916781298369222112818007195877209824637480232232581883086134152960520343669623046834172245486868243751189515775679075046029106/139636200618454892049121748639260692263406381907136204136542941836571696306935422037659524097060945911851487212856918600341581516370263544759247,140612429997509803968884398021466718240370717574315427685668957827377698492238270744477590799295257609171855039707642551536027588162695228381854/29846695487316337802175558666326510313297197449591689530606831564938175273714347229061575330651815895809564444074905643852692855352961994183253,40091493274550858562195694748930001492302928767969752707276055233807995879334006470876863097368347870466819913430557721583529808666064945905204/8871709776604947147676858311638534575996402803493573474464407844528602654540375268714971854842291907943499230185823692133445855203261207009707,2721346249878824900636768259332595102859378922108153219923317295617947801537279325300615740313468742414960421812961641575009272119509345678/490483565661810619631032389586461304988317519400240993503758573322135746912588355182798907372989463233661386380857544718144778200371327365,1096714779784122761421630351503021846588623376483863052353135629636959946492695601929528493198036909851933437479705155673279509818423782626634/434011823881268789581482615497276139581771817547158835473332384354775064988141761568062819997603278770711613123106112276436139574520110765937,69806763831156492677998337024580869132901954340117170595715639707403155787035139802858644330107362666047883315163678817510478570444721837300059/27200468227901104182339102911852041780325131013085858560873692652760520903056603804671974227612446289490277052955453785424137058634370048396848,3861462895638956008317825098778551145275436127160179289072449755826017691396589596983814303576995032354788730645513687004091044419857618837641/3677899390703354435737851282386849954977329017075304115782926280048059825423346124762960519903090062847925273189487994986177750304436506537600,5139125140484124647447254354582691460197647425540674026125248529224537262631136840781080074203269129139901912369528041290958671746197906380879/2982271363140309119445716717298155895560235615633269766235477188525388116619736913261093497383633299965420130919623811927470429408736322472731,-171220008527857709030970233611727621590734722206721826567290838578271535162356272644292465463314149984880547937826091183610753608069756630550098/51596921080063287190532158852679490990093479073453825246984654109155389229456642589167275473475626835144941229471162032008214713262677246952817,3468717706162772158077992189324662037715303972975244603200808448352619815461548025265373021721185482639874514236307310342547236392535204008618/4934565425870382029596379450297293790384618276944579607666191088728984133682538869114765197569074679314759811225377622621847112840279728030425,3297960100685904982572458297279602743867149608713197441733461345790260522533850745664619889406836502399116351755686250119515650657050257785769/1818091518312732386754143873317001491982395615507963084854469266540469432318996781295393263830574465223411983865101748530496120903053814356533,25370116472942849501568719155564912262339744144028127440930831249263109712433889350497824070597026048008588500343402100425027751921898590453028/12996761799198298375322244646520438625818217853783597851327606536839352574468107074695194967150026911815705038230252012226096228130962736543175,22415672839920013666444802704620880968222970785190242530401676791303299481617576797089713575110581168044466972679783186772738954521247909955858/9265137173579710281923017007599243024875788897274332847735543382375036017359022025673569506745121879570403585180285944333094490980783066023615,16815406547962358971204630284655182550805436670575235222971197556903674777939581217209900277201897859383255135203798742950328876509916803577854/7963398124698684241252364694394951543704867963621644064453955809494084551476890630043377667031819241377679620963554583303156496811852725966073,-75147291301553643965179296101859620639582538580360393791613491374491764530085575367908888831444951314617213787321498339055435330641193196447900/109077838690589961788519153009302186393590123116147580025015186706224160736657920230308480754342949370171919155571173381316388114450772691438639,-7966908057750336390941387416803594536413807049892365734962913669308589185392070119370291163213514167879487001116766881274049819871056896905120/13637692825768925046409924353609620314034460834763875290420167917853574128314848178840901073512106619475998684312990425775171116258901412738967,-312795051939381530763743230215825314941921715688598503021304379404264523249655394276775164967926903350790843972299829527825896023269697454474920/262831181202952128632441937200145810194724931740040052619833946014179296426255597017262444249988450204644507566922623349355378355051697305423141,-18953830024818016510282135068671452679292828358955119725339245625097459798022510475614491249770937124845913142113371995057743395283758816820200/18305634187741138616874142178830350560330807317682700005707430836824401697049797628104427512097493339275375136033784877281538671831389704816709,-1938699762928193173496211497671320271363518180942536223922480305988697462169610761216209290302825706170540973502434316973789888857676438228556/1140717180311719181386760335925735220486488503833674865682462981225137492133195483918446721830079560065563514161429445217151643579241233588657,-386517896095077129447491996730174326194984418287506280938391707825522175934690255203348214913291115117950304972982063455663362015718192411030940/273077850014099585662988531716485541168943249351012429831137102531451827498728929609838720350769053541193974519900899841254809465195742053202119,-74748570305931296298345185856824397174146493804289562828962223459790055832688143402540493040602795092657804499900664467720326457677013651632680/72064564610546666217549684677714523087409187462410900571785549564950242506651765727668416470974868550874314390975345517708733244745054696882501,-899621242584472579340376309810915763603239343288181336005087754494762920938629113779177434528355712205181803176348690850502310834779353285504/3602096133505325599757108604720598653965625746159133709904673870123669981730161846576170122132642440406805399993820575548808559428192498213731,9415070833500381291476978865341012215419080426530553196333250714544487160224070024254605947728761830693500644733934316173638069153238537504233/34100551882972292663806268702191589764803365923368752407980756027969056147095177421875799161758983636622483768450121868283017011818870070557538,19540866971573784934913469345056261790588610074899546135638986314769860664348698154085238771547463605339966105656588074447250662238341888549069/74212096421148589689750396091964631747052130452768760668265641107274011353658608715661134109099685150907929550791618201990605523071301067793378,-2038594579204714938959619758751126458660787743564855635247966573140399444079489202077558805607343714930161523440519748177250676830872788719799/7746254742919506362600847777752352997996174178638124275923541859921727959676913137410527896039215957848096010818638997795664983519868267552110,8660224395983300476403715725294468774950405148097766058023963453600355581076724198349274243568018315996542259888088345597662202926878991656120/18304594556468900655881500476054775241956422112468133751010858414990749505107286719451334395539818964977256804214834591926322581961451132932639,-58494759913792852515432406609804676652070087899948806620243884931645740322823227446118392786601009498986725887694705948754225221121145192996604/23356260232643387583814747141912597114598116705616651938775326484568628040926249878646593344232843098063475364761792151103581287974635355152273,-3621750947400482420852686525395299718975387239578312255574096129767571515577140935066945317746502487152016226537653874559454680051529625099741/711993766856038665306386316755506903525958046708389462818423618847913873747854205721333686126003843306668251710562471458891106803901726734116,-6599522669423819280576622595443383021714150773389673400564879755689171842867042218276162303751068584003625956195216939863238719989374736791520/7222088749713991254757385514776026667697607117136938818122699347195478776590051710183003871055989568846514600482639352944020946774221420568527,-50309994325035905370052778195370075691268426458187650489224180251231640234252706765152428469024946434502035617047587632472205026728197236697374/67500020241270206667827226849054202014119047983526789344614159027557409136441447509402533856497094136844086860194421802332566556693507206763701,-11213671271888590325832389882827677831290871836237412027209022468316358291951570922634200706525826812058863384165093081844940493585414525431829/16557210327405081380863672327485423205374433917452923589431193723023784879759129155911455007483951628301940996947552163086045342942164828096991,-3098354905388375938153105603957128795124989924860708098770049397420368488373871560002894428712597725508205419844929398634529799908294638811783/5210796319207708598863705193615686055347750489092977528129842929744778857078652643133080436779388706175663863921311979119347402570969939074912,-403358608054157508952020499202275094155126355610757112278593780288194876393813236077375005983451822595733240766422155989418314459481809409422285/562543057131480008394183763211568370464058994027780162009437327156181523202304462740857872821651239914634934184643819134938052554295996488850368,-68475505673632934025786935021719012717671215730642173856768292748950635065675440245305529523292701239321847528460863395362610838628803212058121/84299232837887317179909835285527778278729009126978732743998359481183452088626500108343001390495381758104080623720024683321793789353744609839008,-3778941802779726438910307267813703317530467171755736266370463996056719124956907409770505917689655850930116372580667135883837493789200500270185/2570972175610323116838121273676170003703437636333795381247496245339811660841393684346622463950776308687381925719592180919843428029758829248714,-612815286428105131966779551486586779648905471053472486628586273514200506026274225931696117380795876253086330618110225514808131379646021415524/448434396377415172026699106695083263984268541098925179660812426008695838071621388531798238523097354464780528274691254586327673743725996417533,-43906710319345196341887732363189017228673292590355685328554648542579907237198410637991042302019435305018391352513173359203260651325178695508413/32221926746840721267267854203519741691884206322379596054029268159958869763685640694209339899501296261090049895568756271907875386731665903046910,-13244248217938499208994166257073744496348029471570188507006953854626664964856082180073018715573053918062598774657383287694456925485952136984621/5833153434634683462514391540327387817293660766263007729130007187222699914785934868039959284497386197033341223481095531591738683783725145594370,-5498510961390891211223672130929893359983241218969046325136225775132492216601969855620490556599070904440097955118951344725444417564216410571431/2265909639673245592876458300611473847896077403574213121743718404197968178992692629259199417808218274887690407589786577542964834536034776056771,-735302094132655908616656518503163068457069184986139293799532397087005967093987750971481944255658888791392896128662131236631698870161113925317176/234299403894804370937121726037468340670176748362784944859471922454518889725132222228224624300314626284727319345260249532076978337983424591601207,-11016385674026824624819964744884058936500651352867888643666878924796668297296413743348625316455226143016862163025821744356525915905671307994104/6141302417993900719328078688587085628012916920277738238270103187471299772906950412311974114693901375324103413512487645588808863451911364646929,-8297624805299409153562952769268766281977069525481657330515405983110281278718551727693228974464005522615828924241997136961563233705192587398948/3394131462916557090710949897382991198775938878183878159412483197620149960148856184616155687204734457106132788110930000445936706150591663246255,-23898025559272521363256570312241090071394963614333515696904287748740674348460444066397864611825534079658331228369020786549922635186537490856508/7617644558644676225666074541547101364742751247645670208185712995611923853004554350582021949811650438898110883568911361433584734770292915152315,-119984557875768108319642078955632205107079089861693618697308164350593668852250338882781210323655353505440172232320332693928332772249981195013144/36699682880770892078183506379087099297701089164901896385297331998832523091037966649991453151634760766357331304564016618494830409728452836789523,-15501958822489539417453928209035163387815063864513790929199398104130653364570266996012483259859960105479237490360085009247358916252125205596740/5818519086256404971552509452589712097133776544596017389206717266513772812951952632148299371020756776861821739133378476529738673569792588799103,-355100897821754478483669650511239008779869953076104867800030691832973929380395176926480358668208383629381225183900995337577701812952182335937380/173811246554619480568960412225937393336714227535441454109079484262644271613362929942310611289938866814001190849955901889605320345826323957985753,-538621054548980968772529709549713743721825958408213183755073800692306582955002871577680434774280210806019719899334736778348270441091506559275/515961660885533598891899313977197341611006066896284418324050286975790988587927970266109678792399799962533459741102886362438156950396091682182,-6948771974870246699926459684723462209889130714202105744512953114609744570667045267589424124489920467511477653080592274663915092074348427311/1517517158769736671322417692782097181522806625914242314361718098105024192170753365405820840783205708202929630802472775526407327753882019457,-150931666451691473770185326294828700066101476660308558190978162010076977289955459551251377384678459087574575214109289638117020113839061513388899/31085379893330939388541885196800302448979046982344863421815081917454038661646184070697990235315854571746327203004415025615627819504178849287714,-204148156662475260610855637435017872407635261754151866331934654786955768849465059310290933646477620226905327670381214695214451688408523110112511/53639408405935941423983910197861140681691934171031130929302763043814314546927948646760470507269205970328936163132434253304587720449702164070228,-36182252959977502100238206137093033360155437431106104428269868581026166363466991953078026409467665971626333594117786632176300323543369652023773/9290209962108012235663871043454542726336361017548040967572679717301059340330101080192601759147781408244649806605282116722341143091472890349935,-196067101195650948807890224075674765937607046655919588985483124584330755679550907705971497336046250274400155400038253772017459656066819949177/98588646554947832136192752509579437288294999079576394256839331216787931384649294068141085038822585793959152824612073834493200988700291324352,-52962497940741001653108013323839372014755696258916137835478340656352912975474631943539968990534117728237046719037743393757498699903230372206/26661457606440671833546573951445889507566957256874267665174235308123413606525826032388832538952843778131602895962188614138297100340503884631,-587224592953831382892436358082933310434086876075320902532124578847140837239899582189881846759054318937306074944095133427019259625534482350/78239818377572609354324330203073550108439734050321906259783201019705915772846871089702403291464452693554043013297515883249801606710674911,-36015283221044813759866863386024298813044161329761719072880588430882907191204249946112535148974611531930284878754805923676993635834242282529/3549978501250031587803439122518788862862740588868535950230338301920652127420096096805293916019600416402815691631001214474504240134472144796,-14346305089416655300721464520436449342271982754053202680951047913962343973433413858969951950347767641377286317001164941345013033983400340039849/210742571565030923345596284731782012898054349370743482733657589729794700449156550483144133797241767502884474026424243953899399034400494066364,-382647893257225406315399467821708364170155207877128163847596155006271936996570618033131680081326787008353911666490154882159039396989220800375/3230207268030287222714535515676352155582359994010965653403273681408933727778628231018728986888477299578438533477456636155800038806007110344,-21719633090946658683395650233291120565271266572288485612399138587195641030065571757077415472713736847630296312827669822123572463457267310070094/485431840226194504194066686096477208977052470024157058861611155879972474140636625309702150830413814997837415099489621354881808846029223045625,-4914603935766115410032692915047762710905952293266105635829262278247907477242968537086424694621109183036396695935537784153062502152808486289002/153559459708438408559909735280064172257387745253866940318220123754826413108619308788181536303588198192442472652250377666043992287730619877395,-729751586876499010165698091712550447425801008781429888543788368112526889994396057540326807141291498543648919818132881197339601221976495591638/41279552121592334766576738559557116330685938186086542743725910268068128315917140226843807755375846316878443892236387437494868266150049697549,-1589140395738758719111187974381953378974315066106459468382298108593039699693778591344467893894051124444402393301271151197577981427038432085746/7380893587754649119907061311186890104562138781449152853271693789146377228159968762458231582518469682727897805036062024076417041920337369681,-39193624275258534057004008285183797951231095054280135465089747634053337601593381556905295678907488556256567626680939099948150436041564295407089/1663715399746271272295553189954020493848851540816214724412483413822350016790018070586149876491631770552215825540947297245306717941191348641245,-130546328726628577847720740636756030689935896682194446499944368351990713941715391204437931739756547608732553502647789276909312086889529935388572/1112400680796060158764704321574998507014641553948605792590450036338659883578231553422220916661059436561172670266750910864609349891981571423745,-91637385643773624267352902536782216748026423679452578952460174753564894346601202155223306551342622102773796334901091497812593410409810974399807/7593481478506232774513566472266389672542900199036366241051801654404268275060020475626161086873756781052705740385048833898945913409260210155835,-3525495729632019925654603496100535124451077001263072848844431775563671871527547963071774201668185879857663561177894324263467375192694071256884/396677306587484985526664948144251481151846456548804831608221268911714981282810187994478673076884978928256828128879848482134899923501483113459,-230474342710009007159532939052067237485547697057776571375156323421060920169475963261699459870927478760374594682131894155550547428226373737334/35639135547552632622797123311994106978517075802319163327595807195581028572818600287888939171945042684657399737158706497150043272363378890701,-6035463864645230932054702629801243859913329004774042238488841712058165316569604204765248494744118797063674204182328765081691013778693515562494/1030273042674842022429761099315080816804260212256749384442697976405943027100065421328696224495516142841635411725056769423702880515130698152201,-1632232809097133158356568068590053109054054599658474479276477683585863314833764833094765578345541126079311302568034678344479372675358874188999/327862544776643080167540018389049138202896702656045886183752470720012892990705091475043278710399265420526040825600438910747279093164842500546,-752145884903341712871879105310321152488350929985337352562404735452942973777625479857674273573542079758983697248290881254039304879131298526762/152893032096271347367788952412366061058684557791857348783160758274322947142381346792422731122895042833347819446884224454442123388414800241957,-69297731539263523195863802597063997710726787435767839273003472760237570124464921461527868624052461357832070850175032559605782114825371346121628/14037935696681900860619834606561905377740293791266801630775185637125550370052592157230182143342608598617637554069012553432598905816764844903273,-6327052050718858093008941014041006554743264355374335955126381192756385394652206669348401942155879649908545521065295622209781315810911700781/813441805581188695123276627379337766843647803331199543233005220797521137599137560707126971286116214777581504001495863847770810207994363613,-376196372038141615092343359098861630017458204302794414356464604823406030303267226167308144193470488577632063055590404196168736376230497758167/4990207682427689465080254678140891133328527752170159484300749164550480036654339876032876836309320559986856043971072403561568887567136560672,-57900466038343903941137703957751995510151475853259273589128304359416685840611331445861958745238608978422631362927444557633443601372962098906/8408780730773052847771384706570294611675048881053019774732932633088497037649302554756823063300147433781762114745338643004930564406342875633,-296325386054587061180163340081740176971208470053964840808255743574124389621073173063054929998778912167883629501982117796288001126543351449543/130807270828957423496526059695638892735081597015282687362445691877750902937880202219012935397139613656415028581939468654562823778058272166076,-23247248148566304619578250222285387227049943975525438906246332581292092961274352980236138566282905814857585019793977603580737121696358573735269/9104189558368953684978446340535344635341017256482189444031466664165901288031926250116450499473656958949662554963507998250606881531928723352158,-2383661306118899590610379190070023142359045989673150868001396647351757356768754365162211480381924756051801996325881279514082307427601688397649/779089111857163895669906458186877146846118553193387860565997124564680796495484069253479853560909589492961445332482923631325261118735775148024,-47755322712932419383742299025968751725298350485648751258164869107030183694356927244560967851998225646451256377619280803343530471815527371872249/30292325998794087951493618557762082809176984484742024384087329563549422261789678538915038403253885202189780869003640146303713517857975404155424,-271249850600162878556671437069954061143328079728443986559681811501091620482965490661161757468611219629344385460254686244331988125495383868520181/51355179674368847784776508756045849907026942959443691189582134151410712480164299160595906505951809460638646434829709839007427352954193908812027,-766285930600543913432314073147288583329984985719834560197982527943356146449239061251800848681984370845592562028509547715290764707839746263624503/140539614069865098965590367042059161665610000307895453530374189279837862035556591367475508407702626390476350850872840923593569246151560073455424,-23158164725761242330632150226674336649940268603609468546605938563246286791129630325867180996058513339925410655523024848133369294064776180398044/13776699698415774191204517184692197722804372189243075780822473769176357017071571783302958259404722559004792868629401478851648943202613134333091,-1012110153254218904059110736658352781562554558616783779270715405489659747910997436604322161724200265201465796340282198830889522776523131734005/84152220500246620290427749202238717706535002229968767748688543278079531462551216826927644295109366094307109739865360362616509056566198574098,-9606094650224939767363334994545246348039058686301270424226611448951181833882469640226423207763994750357491304167492807645429195662363006835400/2163660671806953483760727351104805856146894916856567014013365300448141304777064815509103541636489957277693991657183568843309720667267121428741,-427226963684031191337580295743071296655045771250777517359895308734046892492242713422881252517124137361434661730076387190842612162342499097619063/33302025243876509174161925836347406632315143840734240939304720043319138506000522489717727879751306317871151180107772410397388141524382849557248,-982486198927026666377196019798675965888743807025798191271600594468000238335561779407536393927921389643175986428265537738734304632261370823289/294049853456294637630216679586061028462210374193194179589947029606849601424215555907219780875755824350708818283050072992769031349809345730688,-105577682740300039334305774384518871605196911889835068423980928409110499548608817364455467942356618393288753797889354548587126778122022508109596/6472646946167899677656603095622603602168029734864328697166073163914946953686572827963730521396569623296434640540789739465068927316465094462155,-622512800983188530522393208256983399999948608714414419341948359249387522741823266369311508679671536168252955498340045519083895166980960105506603/9639529764876602515157339905215122640681760639525302962187255813538400035791531070129382727139459634523482712804991313079617170665272743409975,-5400903248285163779390904523967262550412606683530758785267453537343628920879266248688296326731062359870870223309121736261113682556264390315440/971434627559956139747412240906302410973111797798062710649002943979592294090585739010441980218701250035489848947241705237436391228655668941201,-378422284849697147232240154488710330985440186116711812439403137075915085990043133140006561221296688608653471655701416501629269153519398774155615/32704446440134894552162659921291831640618096924394139975845397681097939911820096745775123755871832836539435230757394818986779102889052659884416,-1220212428205743841652541831949518410236070730932426341329455818847015956447912670934507189555470062789819054894867540925698784007463927762288/281966151208827480269932326744752415547208293995736710938086902738982035667718864596324322513964268301154145717790690266898844698147269150197,-6899329682011366406386634417733426675893291006834805520586909299418416009228428546594190900885336263448637891798359470234955490698594057995/760713966874308510454310802721293023254182926212232681774242761760603174683993283609374269893898254023509306010222959450762301037642713038,-1380140032704159061387865053378755453717479138115926075062898610004571672355001426271138710493760487713646882656127611235754702040943599355741/187875288863151091294227622681792812691512880748692432799539839238845894450944686970949458561639869372625982437486927042631967502048643863530,-123035399188044593032237915848363570459071259392902642928899287859460815895573014845458599497876080466064601644745722181262197285147550261071/16635220132865270374590527854142228036899763916367456887340631377922470069836524941703883807323516526032564226802258073163079644307737121776,-5501430678636107785157572103556786243841733039119609598725728047869150144872815585619918589762812420166398904170433064912988753626192919689479/1262002724744332938497224624543478042670563603232293296484819215562979809311915801380649634054054682121598041084200490475443145992561665022562,-5466959206530055682114717305498703695691549353430335184284589648822780556278598272719968843752985008095577154546562147019718825972026655170432/863710298510529042406340324825919903484082015977300192264310580815954800817860176895176917783412816484572236418222440280595597408123172186323,-366614765640987173405522644428584913916545658962379334788060688143395146299915441182532201191792645502569708217021371560856811321301248727873/52681732041217933643792538475145978958491302278352735189357887418274691981032997004138293366784478687636023275909339842462341540041122654788,-116494917032178844058367005926890569482823437260230833727359649071435679303035162499746835235677777965226436922960192119186705386258732635121/9995087014584472010450189909215692359882028073629117666796849058975317921946055743008016016743997043753547177520529032114032884317541064791,24971626889899112848027779459883918591390572437517030456685317571145993674299444958898978296723479078328215937338474354947354603652392431366/225704818916195762007674345279257476219675532311511824484796821793234238844325407971110860980354591374960636547101025007539203530019592096109,-17422329079646386402016734946518618557990483405530966068988430714021936737950694115121170312186705838751953669025693361092415382858263094383908/21033786404997494205318500940315775565742199431625291715264632540857288522811464552177449592425566992895002838839644624207923040566811068987975,14578122282665280778794464697232200230977078109598711461694407386781134868056059805108041000537219901437542361169222285716835428274226418799/52051273666750255377125601058572237775192503165655702532876152665121938073014148711384216955813508168521931799365809977888201669861803590968,7870130692611218201991210151250610115982827001344803389934819511993214372436155777312985783372484839138803028055143671799855787095490892455/29841584144876463423867034408474913613477764939331130687629393837672341300746594806333777259891028129068000839319318353255703277262385773476,-2448796638145233808833416698511758432005940309036958965316096296431220066895479867926646616883618672248040050343900628945186615671095006362426/737510672099579671572515244764608535999470528337060026550649546046964270542180883514335994020584209207195867206334799246110266652390419591071,-317776521786201631473488643740635049294565378856727399557893049489500242688499467286740656060793392063340122291526698876336074523826429961839/268157789998446369510553748455598205168585727069126212398518589069631551149152845311982922851447707471486931694732521976215603653790279730902,-6942470447320380906538549804536845203827496702763193044828605925882661689202236275544488940504922984489894410295465262903444333997989253114/8853695310906317110292414879248615984065688392397094528701168778088296559555675773320881902769792658130166809889718863942843765357219628395,-688671747943321303605430538914584553064496033046050531999578781093528900400650752155771275836750709822538650429610823221491952447413852413278/438270768413188118587551878050810070032113579900923803959397310871446080694636513337983867998145988647438488903610740410156987382977842067315,-1025258970846002927112629490275770686778690465660413626418491637961802403266187396529273830287676887151311323709617174244103499164643168610/668696740332193134773470949755481965553457210033301086291717266197326696236076345283193717003672687354506186442201503936765662039463948327,-116877839068526397738327222847767683759012381794340288383262228238480932019210292763089821753718560903303391829077919476881927495071861425790/16068556820204490086748094609623042976713408875432002083303664751305182077426909544663955445461605829510889427013408536912449201530160218691,36110184628269000366878763403222089973446706163604081981874858004685010218116889357188211648209796855537973098796117976413119300694016973122/39738061990072736916647007190197498659436926288883012225427731291511460366023338054920492266228517728461812662955484530675650432036928519365,15261535281059947414935554012545797794919175767526112581086925696310361184033952195665034213312235485211247912675561573740420610944968718898/10332945072102827903887475475096074673295631603635189932776668875745075385246621317904026156414990116475770443689857582662100565065118875965,-3175376285292256478865414847539872475502431125397707622409339316439594393719598895634396965026174406706342891486183566209577295325289810630478/10614262405351745894765881003889835423258464016077662692497630610061593918373846535978682403778921426532800574494291071882816188651861979094871,-17906846518724269825558900598613533166334262150374193634190621986037276735921376687180385519818678607348190195337544745928093219468786802638408/47508208601993164133543072854992460501796484391473924897959205271278832549661538943625966702618261833724645599304010526797332130393685439928507,686308359390936193211521735052698215115331505143668755251245926550348534844772850394824705290728369743557587096759814686233761676752016722406/317607593185518773947845274651700627812163682347127673330380981336828729137452026376410199682990891461079659957973083915435283179833354078525,6599316413275649056089372061814565976016796595089218946530604085961435197951818115078061115650656696042538080130243650097761436678892727638/2683732711440359699991433393169321366482276701336982935871668277826074129050822517502772316776512262141911562251712906705555750265622828941,1024784039083096124883286266873184082097615928677090363198208384036780405666772333789838364023015916860111045719760934693236808214386726168446/365879617120128795773436887539405362330621129878524765956955795083373436526642540126889206836247795327703258196042429459623671305409288589673,47068446983688597051924493683148479463727187329039443978077168386294417497020940102411821876466812397165938703581781684007963070753869779594/9423309565224159615681287394341379757747404194486594460963569725883277895292718104551311944363988007877297559831414757609385672723330328403,-2866885057905815764623437949368606159849062076276894925072480820361329389112752948362091530915832290532119391464958473475241524229173357971074/11809606923585102006108555700193484696681833288665075812058049287068270053390144861319951972387464292017128784435249502220769555719164059801727,-305743108883741658356417196518989411434348651123711509967376143870074934061358252838486147153345798249236067445638567258792895002433666164926/1267199718596307935215117445433001733958256208158658008632797311259409719105570050893878094472104095639644463058663289361169896632249039807711,-1560412472814927027096334789576201929916898827819607467552383812732926154335887515568993097357770095074214770304709082376025375805431044308519/8442699539247878500947465908679714189573088696489974345540624491676526978636763101332464981962442060272565617873817301426507768115913589602592,863752292693517631500485857514826042451383357355893591334340853501131110098827168009752883882286572488625790728060675367731004803242443939733/7345090989015056000477470035584447921466113582299577760697027650551817981221794542686582591674745367933586429985800819606228645966952412902496,269315730142007425973009661131999943193374976394610132528851963461517281049382525535681083558047405932702676890467137927210011190515581979537/13149344154299222315161811537561607059700295843918223680343701550471991113565413787476462059703799133611361418318858379458136209571443150276,493312064918977129462569081537593657396882729272851216933777977636614395753618348503629194451320893509105012427530090414851760802495248242034/124361222108020482774963838991065804941353667433136449658791145352129071353230430951545549761290266774603230500336580422711787873673002369857,9772642115500881617616449294659505764275899504432075543555622093899530709950066397652091444517487445985917677298092431459724030420245660279438/10960314506725305533485166073915615569953195923397293742674101928088158578586559230160211803750935027839283020255031715264617731019797250438745,2549841880023592619813324871666099053727750088990400560175639659825661992612941331139401514678406805832022222884951969838150401911128210589130/1012247467158620035441415418353771806647448294730802016386732993749602474360443888364205506353226101042546355697505350493975065544755132129389,5394195067017362248018420929601289511495799135677440934335132236650622413471931559887904940942905262236333715080097875569350106240327617515594/1689859967523974578504196122865513611529103263988563882190337160751502823000497290874545578651644981631329564613754494535147814632926889357101,-78248483000752324038984818370187918945270752393957984516691434776146162440984893435282074374287990623118799678098647308193588982279664264851703/323948614408446702392457804043519901614373432134753578823958352468109796885386710095342787261589960264192615228597606344366071236862388552972544,-9011314770523814730081602563023248696947988627250245026797828981746867485973333713841810698472340247413037812606963063068316319455353316688277/36941603665136113910643841935934658603665012688617019278271853135277278149447570232728294962396271977713085970929266430184195414150774889888811,1813834612558620779709030207785199261468621443231319105256322257295463687912177650075591804171784213347857982987676526086206079058086603380672/652098969721742260715740579604058820922290864333186367344934171864816440715365502882591982982689395629325252710533957775485604967086303964781,1754556627909965665526203049766467623632099961559006124682801803983462024061619236061356744517185784877331213338901567933872759911821011508144/283540348677543490292119327809274383121978977483791619328278646135147906662952312757400734010985404827159397423941186085203739094373392710359,118788084880248476224719340807953852388885330113050058142088368959244324299422704375836734451412804513028011810709530051533764669628182630117/26688801798860863588239496808076504362515491929974059395296317104092062190217538219926993167098887087822512308914997174393033926142870715536,51007318689894296844748693154176637589399168127031777543541625996314785167239221820693758604892004150841857142596787001754577376067856148793/1433658347707831469426197791781646975739307337837704523284182659721473705017461095420180301390581277020834794098350358491247184369492704142,103789657401610626296493758315268378899620665836285867238442563255960671569305370991940724520050073642202504019928660433806004719974898652632/99644340945338954078522855563944670016200284922927886886073222058699983325284315456494104468000747588662256135965241773346804536610921467513,1733125909396768903234768236560164433239452484886243294309976770017984273684621188779441942621877556675020758834386459530501487666489164194504/1862588446125032641902154449785948948980366200191817112096766624658744083474644804982676241102864387716701131344221131138020620526019021389859,1677774002800249560882039183735777176780006942173720107465460725676288588892254261471132639387966220506260510997687413271367427336399010161437/830037780568748221324735537650929738350648497264042182264528850317467175682285570938219578594859280182170403106807233994044612855127467259419,6834142571832496679714758270506312209996514511841680215832432366268461158400279235944486055519755477389170525978338686585260386137650149371448/2546706658883938920260371387135305401019131567951541754981111917914408019160754208775175559614413020028332750969689991899533511499309976573247,2911996438498598311314255917935764678514685408089690466356122901739256438668693585156152777490588632063031047186716197662847869506708967603188/613213588379178751092587237656138430105936780162389177866076854012021398116154707694602831298224578243488535115590216065706544520257088245315,565459908157821042649860000556595036452335840496298957676348314003374003795558539279647886960845819245983583736090021834648214492965921003996/193387802457038543603183450058141971952084532126151948239903319355461494692645385862067584181321685859892827499429638866568113341974935703421,-414944502987810838335744556303478141303847828182216404788889660938381973979715882781528781376562085539467422053331927678440875957660215588138/548695753922304998037351043125233685102371418512368258025856226172877171523509574825412898858711505167404660832347548794951168596757414906309,-3046143882404121401141527874836954471923895271183277022419573346563146767877954350428715073564030611531912859870759903900047609894253055677434/430547204031677809338231651452831827313801204333814459982631206669811724295737785629675609668690743602817538377939132069620608851505583767789,-278725000517281075274732429929801125833099587576494502922883031151318733294703026822498883457624860043112600739139952628760704982749555667172970/68182756561762683630871393175522586285946306477518697284651771077459226991606078262485713700854557339513616097183519601402941821439381717526917,-283229231682532086311438100881700146408201534642540347201442885997445833601231134630422097345544779170966168524079799985410381374657303135058/186453735135157833036483996028166623471978044510174373990686607599510269385578310946970660722924270182207802487560035672764277908622619759001,-77204811976381002305147078989295876693646207142137638819339227292430151180136551574092630290994611626811279913399244850824647299932941863706/239670166030450448725083698766879872126583030167405098337799395500379972130543068898772469197907928823720274811917165506084273860310771772557,-29013616039977356340940662987007051727476725075415671450831768720658451617970617498003792471822884611567862250604191331915600273977178044434/4133840663057819500860875410444931322877488181149665732410847145754675462862544168505989206049028771894172201443850221450753304085116072545,-62172443542528166679044447791375691325426679793775321800279051678334309127864848778371603185403478935889658357006894322872389537654540258046/75603555735677041498359932405163424033735605053271926430012540313577702899719403308318437592896609983904575656310382444028858236958579713001,-4615458124118467977887628370830726548610433437652699432908492918461841031649323899715424240471397088986562726878348788776023965358352885938566/288872267134479027866985296019019743240803659514308700203500742956498324001323349033555526577890450069026441530135809114929579121841070347243,-13642103812046335536208481410157954481579368624279424113161155926502709509708256287760389450987400646477715620892167239056314164400308686683/21538825165499090060730127316860232914051335857344992440563215233482755881250954574167803505636987830290162528265799230928833125380317762775,-19350876397950320778475452855474216816930672799669369380649347951374970538703511921327808863903602784134477372121106583392476088360866898622706/16441086846981442169038194984584401883259855034971147640783354636665833909064697931785970875845526415488435322732422178739169254814180418856641,16540890168342528727758269739844248860184368822583092867664333697204571024369715539986735978430667051049837541066878258144370799981979758953/64747527128004377273141941422588502315746075486883846330910627875587403121696845274484364918305938233769568918458523370354633315702923766012,-3581277095361781664445619631159455937613282573281955908083062897710302159066521142952710966016662244903856610534477840751346127210016347025/9316047705260071463249805151821010112332530106336567330374502730572852378593659573836347529737742100951222185791811151831462669743942457421,-4981722336794839066831722017217139951545683899523876631435859686715148821064420115840801820460144758564833771670469287969663079922008344711/6511784333095150623914098957329803731490041511065471703027614982383208091930218860919830601806250500876615935588712325886568751924344536011,-78157623569514973789192043216288329318997075397648594806681948547963804614786571041991954844111189597590945303140391527884741510387161093872/9355241871120627115987430571297997100725812453011028518873503403205488670807045320000781020183402194642887696529388420599012562952821912379,-117676417987752102921860842355638617950367946729200189707870283712002842358255433233903437930342288351980220654107622511182229679597916434046/21932875549471277414777579974837541909439710531928422538833398332161739076035583781880470890289846655098635193518975122663303425183804354471,-41458391250855887245712249461351569666496202873139035889620698604893986727374616360689754771520987205078688999958506958650579015474652465993398/3231223613210954795972786819746626950767604460364409117906379035693543101692419253517772578314602593650078472993331918793118245208544358130979,-159461794156476929275657651741157759495949094393876733458717159676983949522770485739949589701390542754581189218009963413838699992992582962800826/28982591042698215872332276208397567567248780848672630440654949325605154837844954913006569757997337843088904114738152723331640181054739884469159,-384581743357998997165997765760108487386036725354820166547646483134773532853624817168448817531067521903376468780331191477468631721142205831/426619007759137938044922774377029452136781936022949233715901225545015122762766027590207690068498859268866220981099196198627559915260688626,-1144121565137747668022522749865823039905870939670094803225504439300409135235609981742897966814252861548490093431850944429082315391174037358/4260703708774455880526244117937853890690218583957765574829125779560668508041487895551251502024242467605839934115113239393694204456129287643,-2949841900227034605235989123294238777270739570090929098009266509037362749302365597104241966032040509667641783979450258316411581975164857622/244433852760018287972424768685601715861544045123156683130720765771199126104359160938258972760873807849637521591315023304020056749974819749,-41361316556305593901735151365701691471035608088548777393633750310862137279058376171459576867275051226804221339891467289910208865671922888830/2466033954905447665380463591518463457002455690090563074294324708533761484698247915232797002086051701326193154511204978601900767128336878359,-2938779175419603350404394142617861003753471089508920340344227906036407515707438517606306900307612633862712480951705130228545151696983042894410/883613809145846494089882823507740517916961167173816833361671211122119445565000524315073066253741857691779043809568592585176248305775701376141,-2108499016380796353766340719316542729474306519471863201115367566016096725543492016417105364060488239446729700423247575610733245088275374123522/103702794207012537045873214231335829617693249959556442351408647381074096406031530406053411843269275651610201145873294155949090856963425158733,-344284368523047836408193416910704758045933439786228757893552811055169119713957963538027130024348706955724058477129678654475359047394557262123/1649102737604563852404804268149909493346167103295026271575209121870918126325116032528835184267851170135809290868288162876906002449543422023,-881023052255477673490286462655488423710091552784994560940183964086822515382545685089081155952512850790096753686595070198583911719448176861042/22883814529449099627323140963783938398644967956453231430265442123637212402202216534912325039308982983802355439481018150200712956474322509755,-4755493494477786085865006425780016503360040534836382511088038278901395774307696079971823939384655560626761286365330402276887077470438671476658/292444207488246373647849181291660081254980302886934029170857362885676282899348860258775317778386155056100567757250576311138808638686862496719,-249619794008876536008117670878662020499630193584079896936060180211261286199713963960848859705646643183283315744906512345500003069885075027630886/93644637904934545493082370400563719416613871012042306030029472012096029080795648512248283589897970658903567407700420962110649743087329945864507,-673830767034722842581489056103908546070997338760390643584353214051166198243511686853309388056115510641036037207812485993330006682144915265060674/163499272960999630476453856336368546130528792894446424476446519575838176999802228408716960546934493845003088587498560655638228795715949909433285,-238308462806349458061284914671763381291986817673733794859722292645220002045078329664233971610391517441471245065854635997429479717343451049134734/24897098087090423224956764180292769484706564623004057304574009312398001737628716454108647495020234158068532968555553999775303111741459757719295,-19654947501375360302792890667282930273389876991171979869890145530648857160856469860204120869467639555573430187696712328855586353663172269445982/1257334182359830307506655898794727263658277115987887520761209713099221628788656019728814653807724559138063381373665799468065708883390255719065,14995237506796128730853118238434177989438749531185560932748645486104420648320257277806485759201511195270141057600104393430298170124665229095160/22711451942361541131790605428299638982504349928138465227115376149048695973829531785510133154262148714754985588501545851255700762812203440936321,1605169126878150191278869785422848114821712609706040505968261247599013044103907483838759716055153160284010549300849325527638705680929922041578/1542378086466228799555342896617943276600374816494216264419120363920863440029487155049813551175682397039694300469915201568156284394411076465869,110179943904450344339462039527094972786610895070470348062207971785230143880882995921675276619252180248763760651304730042839131581149201890898/61335065801521545103302967141739334200720741396631759401908143829413472595343053788654554271721205331339801199939161148031463377926027489451,139305082541307812701237691330132266361483220230057669017431944657870994854054132743378036525648319364944040111828816838576417504876672803321/5724365813929205747376141565513479613851850277766071284849729504281960400736774723618628978790545527202436952040983176618094182240952909152,1615170381306924558192114364763095183210145395299405994250670259351202518954948798503923101665042598717405851757679451103661966618854421150723/189213168258352052040318253477922245146372114639586192236438688922443424864286675314220360885289360404187303364684125046932106934008381758496,41908063769411195952202535640318095871596535449779707200124977655796852514272793477870403347107098389383521286311442065657606096328351060109/9420791858131460068754706136792448414687357279048952307302499550662688292907764014606457298083070985601258853647349053739977878819500556768,26985989677670076531367686637645575694810531721384902435113668965075422112877293486103501850295623059931683494001039176054515253583920263253/3387755973584602633943582486105061581956461069788568122839521112487202486925422576195081325109358057113046466137550583262026981171005908256,7571432321322287072630019228896949058050546604018071397109359334267877112788968694172075326401467810194632021223875784799757918978464224013358/1250093810958126053653459845747442279164072256503541448323615664087823630841597755560582443679737455174891238528251292280710846393537007497319,2172946444979190560614394838169482049960688396727622077579103885509766172384136193741315564655613921017015651420948258074925902900934585809497/670220953317105183203030662351833096146383053998415177132134017837778458874560408273106745215010636443171178518041580565757219032228077348440,65524621316771368241502436110373546891795621726616747836945069945061716919112508490401851337918211733124569147756460850009615452314013646585091/20316559101214672756730357009462887484648903895186628656882649080741527568929054461737449880312501904540041688499706797901705318366607936651264,959345894855470487953959081260628283115898650670709721645205359337218738850511628008578608533731575879276843998583964644859277525912964223211/249840982001224738211025728216243760728949720014860750787974780424817742776156820852081925621796410124006649645275961956315351741997440253536,715716737977212998825218686095485358800344602319805772590605931645143687085936732435276439046494127343501852035008968829584581469838887083655/61264789134812564917110090901745734867127543212586937624565946207136766995459514395309419206743511266046462288019946717458585312943240044038,1684697715306230796521698466392980323675617758852354104012880084335446824373258826751050009234030288778487718301872361627607046998459882027265/13505085340493550400116157605942135494821486451753605401633540761566254406509017396178299936561678340610150337183547190053216190350873961468,254359917357053694855687660539053441440554778737840808139031954113618678001121695555158230044516999743738350756865119723247699863200669699401/67819854012736906708354337937702379676374143784869386694601801169630581715660772824159644493058234974869156531277568434214323427989388917448,2133347088069803748140512436144234964905548133613460612646192497488093501464134955356245670161119771946471055559063027397243636581958232176867/92324352906535048807668108616672940819727477762871759062198241466218537622834619486035859091401583709471294964456663372867284742093083450966,161975368671439098087373888685398178896180622482491895069635118452413651908815958453795452434216481927110350622096552275786769127966464531940/5638350020893864580480604142790258652696706201472184279333708281730433887494280418139850130258989772875302257928585829283806491333036972843,259365325315173451712802168945223593198643311067300438531342917841995943121418295228849482537458429219030017622179516231052329858554915003317/5578356791176329105476733669116150809958078989393124507950929225881343026643440318092873638039444037449139372419138088476645818607638709342,2722380060600290834194814948504445023947264136893797580933635154154408427098290011674266807664378899311031676713859482418967554834496721871769/100511763843035647204924217746227313014334285707123918692914040581258552770790864326607736278783681291069483732132401620059565184211802527342,171625056024747690232930344423538287371791825921364034374263390505444380420465707805996761051130364330313557173369994322902452705044642592767/14173695235458953962258933611842607738237244768421367485262346304518123003490775503538190830487032308033820145938673449415183779664197609556,2992045841146547707236000312020684683127424742645257470729900536941951647603769636168114341311652068787469319544633184626062335604967906773193/278225599936585335163229425236302361747940953170769741921510905201052769098213205396387341432834132790179141404817036462639908152228614959072,13988258182586814657880441935013214716647804494835077868093792586087819920152406811426109207329999104003014898392376711969540689050467302568963/1527790137362288441739339480548125072915549392490956570954386589178298270347213956288401361188518259578739330902856720287907261062999484431264,2232853889585343183542002306315863247307117914016446255335901382820342091131298877330300929276062833032528212144635323905095329900471748553791/261192701436705487195100464346166199328483616286321595984600248137924930966009108938543856620503775249361739131931041138560839653841352169544,7300237144730910353779256298862290672312400209237894127568048389427543655022425702953220729755183860941660840440581004725303719851015600425/1624102589581450034714043260859341291632626205048931106797377776688134408617461179395571176050211045889590969600441765547685940449182303534,16784855194199608159034410070362410617926518558740484654221560689356606231836894676042449709713381804104692495811792837544651844732139470434395/3127927438543320055406777209670717680034192926598304560057004489818360515156218893137809243031505749579845538587815409533839360900989199540352,9629372278112825939767780185435900597393999828679495368116481347971501971798087014330246757085576487688095861008528756461484225070296561402167/4676223950557269874009911708900623743527956030976183516602755608807901099417354355063924109912095114182794621452523770457543363440203376625664,20189316747200197987487685718935182573483577391904568019855193037329760799943345550095802776787077266598236645714013372625250999560223539203617/4804785901448755966323386233553755364472130857159166069572973307755913149974224481890317921805900192055446050976485286913085324377037761508032,2159349934585506806552414573707783820269522954391022451350767934918738819446790881150933849798867745932283720747793494865292266037557644911889/195483015231020885323292903644599203329842911672857741781265598928330088153868265317445996232336351824573490730804662876215695045093574440028,183387557209980552149470389095142594568794179845977439647362023526336327923536418415233839401639162717443870759639173293780183693177320661481/56276059300563670134763265083451846267477619443130688586691640980620155803195342825281847808514926031890408623690470732386777788731809878802,143049637207520452201805560926641936086245193773056493038537768824610572159494156840458238652108667424593680687227110020085145235210263835444/29902697275123712705968849879836622895522042923282141035101946046120767546325567050945331777353201163118381441771207577433880733815256756169,40395653094972931547631699354167846939875778706283210154501213125636928231385184573846359054611189736885720473676123774385813054652234502057/7904946254332849720336247789014355246837049127701874062590439504452460235406940895849157116801458577257392277827497160961760644181607296999,4305303219098812208822253950579950806245715267662315653992271332060324033284752400572228028793972906789210952450273439722919970433626950468523/402693028625298768483552341797035641909888384266316385802526615846048815723965680623962458663118726257151458956400064927328081121624114008280,11322770302481987689090019700828237056878842294797024711323545265262147908431738327932519324731293305585972176815541454701144742835784436320649/2171310460293942679342626650485790073637656765702135770724913343621486636595009060176343685829616966121116815391271430545147131959535820429152,534677820531917703793147771594119453261008186838006768642690107785566440245318118888276279505042960140782872071293367583026562759865559279554/142184979176705908308674085381625767542048775699131151601878359079117392065910555736096282576581401307721742022439548826232862492631143445503,1442142614616286813522256537432189877762903267918493418532183648577172960722538221150227149767305146938461677129679411576513203700388283359211/24887063601057367585131141903179484450924418693284553062556995527782884738207031773454448898976738768326864497726825901417232373267976675824,1369812649163038047923089943620268705144346547684223796636025338798941225113188098307503413742353973015943728764164546167863264262436902005961/52273995730920395891444259076676095513343898784754622747375244564286798561895014509981068058688069606329593310706227065324067208762064150076,166516903504343829505787416311202851077547335920178732913309153228999375261633317499009476349461492422952213319952774644571553795375008256887/11817755550053583247477774325715976696933877810707540057673600645832004910659159118243824424012420784346180106018219592411649895805374691776,361484401380488972061046008441438028570096560083194030616927273770432003907081564170845166553041474831657479177498742871257325966911696914161/243552837726928861886072372780792008448642118440866510216379034304521115485805492915193427233060476930754799676244049425621665238615093412900,16096967223762748566027128570713575555811371932789469384796360615887813014678535084361691374727210028097919301627571783275139828689919717341/24685547946676583143508174505401867943753936327354041965432291608569569881330910651551008549353417352891352430011474320540278926508071178724,86549520100847804384998839109910692559126739399441866401858001665675571105908361003907098394755227430175364507055230497554753514669755404579/104689677029804319554250145510927779657888706036825097813373675205875812994925654996671300871955878701017951730714957790621475121764206332699,1918604347922375285583261383147772135283464119317651299137735730338567883583963142690221793103931274483282182014567441572705534842894186386284/113160817941882096689157475447887727290029980813826805816774632475385896242751959562055505748411047243133731624499694985236496622459017289101,16077079355718930699939247890282739661335415904227558204211415830457549515464360773460472207273217934029986736470553471222288376852123625804/2685723392439678390790195875887800110205536912978771817299619755944688980502130953634039248665743219842580202205871361611915812013008631451,68065783366048046657124693571514405334033156112426414056027419567363619128860351679376288824872767189195771872517270589412076024147212616365/20566855959804491789721777419181454810466237282767923087692459446508898672474998950284559657280371218103126596676929565227280336895849199492,495798408090754349112228469094269343445702461566983104129512470441057313062116692312695047273750764609163557426695213951293753044483767726931/189045654173796493383891582907628363612466075925421134709921846853191350111789672591238580278327132619028449556503324770941654076649767411358,919924157207144758234805823116928158882858432553249744553616200683349456667452175811394171123010597185692751297129666558128663930626477945478/200813611677138918251645022944745022104000582327883984778396377759012771110569760636141137061942703820023831746211188345713529564828143827889,9910768070851649450415980992322057369721775875628246147823175663433697285841547523452208007204432735313706505262676229848039626583410659128794/3730493620042672056369428294340509448825996094076953911221218367997751368024256405030843436608263707798279602617869337795019349048802881287655,1348569940430902545652256866153821396416295409672713244790244508917974350263749108098615432066237651877686743664498403263325439712172735097506/745113043811863553099182300896533744026631234175693902077649288151557604719559979602232505449170567717834443026181862340394594192251240079917,588017325853989686325311207590772371594708148734856994861974779200321567563092185468961358565273318753407528993219807679087769744086434510026/561216593099092631572988554992881769964629715771971622836825031036315607149021831944952564349649370283458089727045263401019441638455056953741,-3963394114316028793463084507785394013994673994780069425113108032711643148108825496171509423346483903184120576307916863801114319166022984418/156081454999529880675553281864954474546952358796802071988943762853421795809891393574882003227227259252663804091051134286750994213723690119,361307182128160937719957661139366295944410505699130292546849225633010476872620344484229341225080879335588247871429942824467020151511679221228/479258841420642458499977089612639001038769314883975204850498244721568006326509963043084834105340748167962658394262232275858360724323855480707,64999550525121880208839360628658733514361912047539203649096515687070550502791791761778686880399521711557172300294505171356818044322081536809/80183088302054804301475709703667966851094845040781572148010923623581518092153451640543867757512083605553265690345977306182540915044459234613,114906551428660902222350512160827549906534344829344591244084131627332719917759924890378248466633330778245608704640862063698764277288426898626/346432646829249059545403344932933036335132682978860039970834259483144534191505436963050710133653762224055587751577198257813892855347005972073,225050235308919593494131563223755455094407726120959375661523372564613340384810993567746426296166949524707929585223293807545535546656732720938/791044204649189080096383196305126861805767716103555782691993467807240074520471797776442868405743201625116179481051331227725972920174795788029,109070362197068188143523067186082395188532676613708658925046923672335313932770252019347177587913686105721692423364522869190564999391432238893/3401257741632475577135301383945161184158412663552420204305850715801341894638643923769353222553318949418317473637286949214697388877546192065,192944327601635482461362937118085498724649191258408297906842351762579894921863247621211071987440583229036424335959552292846379470811109813024/55927884778438800486566143513775262980375533474865242554518291430725274625478686602809638786085336946884300335197226050769209279444580079019,31681203389852726984056934049481749259834363690694686610688397295209817069822438473030118011713855246093200028570266348936798076247845710872/60289247324640443215845880106220303180215548955263738954312289340824468106005162034309238568913235279526132724661017894487025823399744674577,560219731951936121783071845990861508568221376003838238835769563779449817175254702964204231998343053683466622934825111562412734605193172380971/162106421300877867795528459586540054199445529831079379701720443494164479687163905784572407024183056975422736616686305208034327019441536923960,1529651650455440994736531576142060702136614126074317013957600298830151041398601197633826168406370023968520532130835671555668222303901986476463/2031689876365743760335910648342793375326146748968989916715353260737311521001361149928158816937432061025351148129384926629500593367321587702848,-4253692496281264740311458840870028340998655930202573714358563345070060144490981355518618543935616820442772074451567657480109164712129900963749/1036824613926519505639499739794897123028816928773497713044787598799606073723862812046696151373445183045443927431528835991225739801816640343500,-63598436104602019165566090981108694584315688380484298834112905116152691044445398689734273641618587185481714511553420994509761839193331138392657/75353263714678417760643330800353655025377287135151190163658110549944856204600732281106349727867375188730300162319415358545333761772837321744560,-54515920146448899746065662236067332595551282381600392718818736180343766142806159217973021593655804830631263835467035116158326702890245612846325/42239471579535051934263071424464590462017036891002023240269600946563005008976119222296138334775117195661112439809335123288328171754912310427232,-2968900092512202689135119422103524356725319823730472216921583087132910504276523644594041482050461525934088061441695087423587788776951159870631/364938707773382864345467605997164124044878713112189153494651686338489095919609401430644156256815584551999624096787043681381594831621613995090,-5739657490800393317057510092069980477587805273198413844028699466834193526651537189500930743148992768638441832837001932280767831399283644713403/4901036388386452072470033253307255828445269324175570676089147444169511528360624451142541230402810964047894559112199610928862495348959741296832,-25453243535655062738864492888619957607336098684484492209681830460620003537073836186436000919023421491328560989285168542172090020279552737886099/37670364821389938468794069039044942954629715474864193446060637651365161303162796822239897366324759425413885123623676260041665486342361308172160,1843538355211144410156763413868106815639506154621629940405340880262737989233136319928755559896184263113249567979206000701713058790558636655121/87101337523181480480984778737288884409123495309691756592496270701145319178847823966392548259639099028832431448187647514851403825343088004160,-45592743546908083352431098072132655779746931835286279824257792389425429491609520555863619119162505178761589020583224501500184560753136870537/47947045442958646631814412804532739447914446262664625926546638100729971979728900008744883705132750921198541593134302874066465093647364682138,-5547237701086459282330887391214606422075754195526813782162465456271904109887426302276071186633224865921818296432899154796166030009514617124351/702659009311022096845592067824232995433853208681007777239262272235898600261472542090896870519980499511629693694582068540483455988833265232280,-25143853914262206186084379319295134327351621010711881635892847339118953706447717831574069292916159920685963911553671430576515015931473426837/10919081748712364838591786855712463674245409584989828693298596456877777670468972040047338088660735254856508683447969345419531717305437817488,-1487165950470435356020185663845940648885355189325746374321876035753419507449374121971625647816169029799270376552560260947779861558770993642153/2829303109647316616395949422939561125510839638531641150895220335646582251906320389898815130624937646973561662167359763941586994825300733297216,-674602914631896418758080356385687489368634603563652380932024733328754059811270823255762553293426333111887464384527506252250563173412422118867/1081647504947038876906956059834547830942548366785082304883314623334255228491876611918255838736738535203868180169832685627384450627061138118072,-102340544098031338395638561449729937825856658422047920558074309598396761411355439950523094763831519053413900079045677625998418208471415607482/194096994751363794723450704420938205892924173036643697860913944290370891195481581632072586572635962240162927602302058142813829342696164228377,-12040954659908418801246445358888686967861149167855301665554811394049024305357434655433605374412956184701664766279492793561599517949577842013/26455126381698158801393029494150802520832940703867573091500726828113900941822320778052356723466468222910485607380448115082228181969772796238,-22634484089169499228831615907855773454600420877892236906352268429774510057886231810139524918482097537869162477951741068267594932139022692721/43540747130196634587227609774884026297932345545063578974987397852392194847598846864491294341904957560408521689917737211930023803394977378636,-72029636535961431013051943228152257478231698351324218220915677993431891180966153560337732582226168793275813687066595796475568639442810764639/247863051472490185955604379274936059785540996804754039152672383150311876399264183434839595358201614700963006833690679005312012643359549095530,-399215467371562600275745581337917660203032927652751803845489318867923457865734965841693807715576050320261415869135992394175356702352489453133/1018038002913344419934419915916774169945165418904970961165875974456297720717220981865873049288559772383290556246459187334113205675425403324596,-32390841018498249513726808327744966581845710498527886998363416062469689584416096322401897583294777968478662566612376134036978132576338495699/49054669804380279249512555399085636214409596337463847200100966728404286910718531269242742925667816317267891783312871130153433691723659117434,-149134524832366531955289708318266189423604747657412727534644819859319157178229419742095737396329198347470374441934710979103363019218017452277/534802824881664117761337715745557858523680938309182575642059511174347318341999224359640898265164055700504925232669030258165797320708010227922,-64223159487739459728534919714836258894428018392650162837160283745485922092863899338647251032551938733826864785546446351372773976844430071439/157982390996735113396274437291316183267627634774612022734776972787817203720064578035416659964403977753966534745930673249386621444106368584348,-29792879521400885793998919636724572724255907639412640607610749720561989586086101054321326756254812242852153023770500855564908290020021520567/64740819705823110464788269971213825302949880820852754807070203679702111022343025988308169818696989401044992248667446013074408117188090603190,-401725956493155128358723919163033426366172066251139937769361734009982579981708012374150555234935182364898094397036335707119651148492469207683/732617862220900115495377909655178231961231921130840120450834085516157401635292874753902075572006642222392488564037210228965556542873261710544,340790579896061013657333800195658209643932503457361040180074706489275131615472598162859878412383481272468358566730228611693678443517832814083/786048667791907548269603545119449707286733458146017941679417423725454114184002881458008821838355162067628631429898060447416094432115227471552,-717479066037559691283138592875608946249000415999647451207857372955168108616737783685484364660972035035455620707533103316487892500140782156307/1711257989678698167610659667453401617166863944392795106932020553002669050230096803268688063513360642664604113974083850062206189905502209113724,-703387715100856701989477120496317530059616297782679421686950180151353205414123439267515097640130432612956522233193290422056390791303899479117/463746806126313356472411358845144748524006059972778442447785331297043404611163058912977709940209704160414487140250752765930499046376945958988,-1037796591422460794838501867726978777965003404093436848384416431107724135288898198476687950614697391695597384362597187992658165418478330153657/654287896989608997335437352686141556627882824112920956389030398304001372241862668083919021638162836213226720607644183417116932692204209017820,-4062635989006155083259158129636067116994863094326968304204621186659633807151666049210513238625226867541689992814125301213313258275372816048571/1310521158104161060822868102036753614828107065433132704321949396809620969162598369910377342701117860511124846432350552641862549193572095229776,-8094240320973008006988321267240130208276268952703257356317761768185823160639933743667610750126388493132305798319500023587445851296871180078897/4703946402374543974811864558151299901575020249419087743660031006542055463300973392742998238281092686624954441724400146711461896238945368252384,-237059350709656478000727492522928624793758242896936025819380651631575537074610121124883910408747051560071744070764614348364053757856156859892/149405272856945465303901846136052121371276378599249483293569937201098602561893780182573478827902041239781243263727677445847446744314797702445,-1803232324347114373115763950326593537496477271761686008624028753207165851499024186600406989459579805141362024232258933845620700443464487987791/1275560536448400709044646496466837180573433916837045625868258443180272233398939715625861922364319038587148839070611219159916369903032624804624,-222992326184652077712282649863418921460262413823789514162091715469300840529865110236987396715533481813597923908065131325351886959169131764843/413330479385626292354638179985608845880094007815079543891981911744036301600709576924241390834162107702061885226678877973065312734975433158296,-277616396530370691883526154531198545923902973731105390228349690935129505924312254437418518803711286140962477657936640615911602209621086246109/549524394996967913499900700350206035520218146478839581950397458692216171822759745306785013504856438459693877969319249945149695636772847711044,-64583773692127802563493642112375666928014949965852709665350338464925028349543409083365155758169362647030911807426851357668742660904993402107/121505085238454631873985341297990491451946911187596156682888816006050265863639446050893899310632797629683419277593897600774280918082390254956,653379164840706566730930960825632149366491786194500757918151184719618583563786730814083912271632209526054005638919481666978966990239957618875/189035811696056753677670921259190025797630573222576792577295733387872547093507436884652491582824161336726678110281017729956941076657846760444,-2238807102587498340506594667578039003628395301091324608684865925921306070703979558150893747518455307042473891476850726136287328242513571337302/333934679547294386041991811260647326294049116309434808657981264687286869081511424896990805827258791575290795228616232883543440725184408776389,-1355178200201414192445649566250443167724975943449719077674285283883521958680571503367593193584136731416404540771879300367980725163867368244385/680685210728174651373635742544845037887408532478612818600571793862618548257640105705408518488257924982320791054463841457485205014976356332476,21008920663815966440268154696717216268080895342726871645902347614358077142442720051759095428706692880676001537491533649781911939612529505716/17157043263895333453817775432814329731470391515422481756740498727810573778341374140683817917321507062418299675125107109173684245869347867411,40004488727865952521883478210825636889330124568665353659063615750954602515745710123230793747260640817457687274940518638457240300620722851307/60199527044604001387169052007885120858380027046385964453956514778960062075112380713235166202401434374687334949876743803910668443308591144484,20589232231088967937600313198176020180936592640061264948089731188205214314759429137041510066313973665421688512893493724765581005454981725736709/13647646589143789927659578301840036905186537319934685699644990502555209180319674070369395817730997846433447347247810588930997933233301370088032,430690366597318108522525304674006500973059058930926382956315988129917581170216009546023563845146021366426251382445736627608880862930471553309/313675300546435678725916616500900598976570520796637279486618738353808987291800236242387682084354917222264221168369952409715699756349421306580,10188016024860311798994849873190464168158145817705239604639485596662863652681864814301068318674625280946782252879896130413241263837575480525679/7510000034426579312523745731092473620211138326037696773489901486805036484020511284290315442073271594517477627331056674667715773219566258804192,892234175248680040647285766178172937335981693402387602335994166099696162373809980416161135897808960880326570887676291594691009371687163585642/648788569216819935549553400108130032565871135408700363041920178702948535371584102914533729241587703777309686414684898871644523572715743537461,3684828397860627139666382208137956028614460155387352019192873710457954899553894603266125352766517549474284933939382078252813651035399943901933/1259673205683991850142669672185995477328721951790741603548194748262726661919258359215350120812281322292384412854896389917425750906902011374308,8757628976359032337998456872018690531992460046437314399681412285187178840233309798237267403203540714186944734412525993856800199726884560656/6883098764185130369571118862040337209194021928153126956272127996084672918378791101275498056649535976354537037254526959517611191603023710111,166165870522482903997809890087417575833438197510404021070361697344801356418468456499159389042997529222382254318499971012438401699060908463434/119891863401833908294163326806428909043500759167302075879818975169987727267308345622324412772485128521124324677626903379190546232939571622877,509547405068969575685601636462652533856359791377062034939560573172031547172728488745292500970104037259790255475028873038304627393746105639085/380853519352765556949846258336831129150626163258121888431773133677770366262079484142018582626215441640141831244495846741122178396367282476768,118272921717179951534811219565718495947362013537543411537195137340232705167965003998485692963198176962563756024483155990230190304632646798389/88573782817177268175655311954081300854935568195237401188560557280074354612815879786448499266430791043793981885201386119374433187914280874344,62841012879998338657560573102087238488276019768155638320608375095514629237822352605874148277108926086605473000565698230154529456949624385004/49087218665684036809476406565227173621471310154418684611146816393760223504809826281474537147338088179377159846875538292278378599766242885559,4212352465903069580499957394729221704501307809656945204334052958162090843694208530830533036210350898391763593614384251601965801186387974602200/3544903597810201666748325841929782833604739059971119173159336373773490435203407187621352579830708910740416125127058997702605641984452026518507,1025807946587235429474877751613240706891188154040651059451505428774520375888489182570297249405658398724007775075203204568003008495696141124762/742239544357532089490360991714071661479844077576117367969314334580915630267788453142082744733472300344615033936031482749037689863859647403797,-1672315900510973485700608950121443664860267827748872213720481936285798887483828105410872983117561983396117920470448108294176032358552435597/209402724583759695644858866955693072995956243439218687751507110213344388985279384754966570419501952922656161338596883469367523310189969935,-714116070717878072642694823157752909262204282896396441476366454888122468265963365650986062868956747390706868702381111405693425102979342072251/102615992876108605272693082441341427189322929349862840096420881282075071819719140948218218002889051292122612163191205680083247130081591128003,-492908471024849557076591736911018630809815869150454739853108328376985437554694463017803626116329687299984564975220223230560293475778240408590/25926927521372402652899240149264081304593792259654838153038638883108392648108827265647493784259669650717908045977837748855764597022154422053,-20075874871129417751928190248554607734524440042276940090290530686833046107019744280761648855217228184017978656462859371016355612362888976578/3388550417743240459275377043176282520830627471698596869201841896766174626663887667298645031693486001508494974957807185629278537244863304105,-27474149469889908479844290214540671500495698841338674993083829295781987242330310458569935738119331889113298642140892868885570702130408157428/5417340949372164563200696524187719385427022772572619586896196308306507424774727003350201151121125055409407159878706227332486845809865129699,-215892735350689059770805054461277624607879357475331636349754652142286847370927612793481081225393314890242833436860156959991480948209010662007/43065231448204818421704699134220768142612728769928872223652723446044790899732988555781585699933319692879164016210713757981417703249247995154,-6229806237639325989433051648756211320195649315117635533611079837639219139812004186912494036659524352702744657788829381479304394026159935812446/17619778737164895610323815640041719132918049851605522125630903998489805328577983513672507043358054204831822204005499146866870597313453414807283,-428472779738406577446324904097824179183381182011435517097834758510726774407127809678995848609117423250225731620743175310842800624458268989431/2397365886990677939758445511029662093541485480883910199119164107742889326829354183114936256943809076190831907192565893631150137118922322812163,-20058589488323923077763414419215733686140285786538355401766100916062277730112292865373930113032131121218429846529360955278617247944884266556806/46042709317561406447189263075635934470683513261594027070358659264706408535622036213539943150475438616738642251932382727018245535134658628150823,-687185503346210591159460807336971862483321048222542937849109204101422170271621651346699236583543204804115348484725285105592501766065227945443/1965664105896855019740828882507978934414853490542179292208493397751808591652303029340100248059678538489448028508255623259938107204738009737854,-53046711098420869363528043559696065851959721797407522555784207695313365519408270210759600789851324681071610673732186319663384009800371006185786/133228514373621738224792916716731154834209700946863416118852813562939796792400494685417787559072303808330844720814397846597366430379005023375993,4897025390615398185784473001543413302043423504178036668402651639158890581739302200582278252464578291558333788662066717853706271095776441182228/7278345203190068789196849460329597131961326230938833559940273226243731316968282487920383219367517803304846780087480774225066605006444378974973,-228261592005750048553461524355211033122558034044754771105301362849991335825326269263047971800185863653407611602041447277626422602656854333724/785932731318164322651275410867643699915105907459804602314251856434072146858024150392338831213434572601662192073060300828063334375180496933207,-12138137046463655949186073424507291660690904614115437631295701915256967030650677261488680803461753201963847368383249568791087121061942112348246/6233294102505206301394172796139780965144437895805670528368851054906598104439205521775515976508183276512527171397836998889852841023795351140587,6582403559906464459720685934313135564760424607272635479586260595984291989493759373565853726292986785128019175383872405913909570344045039310333/43437824128349037977879844304354268528999528636387970923427673155781991024767407989465164679174728877939138981546682154276653194959789855263701,-4271874692174206196620353259385650810964325930499994619475862109823668257089146668559226850417492362285142852974804897430249491317375141111241/3980434185262638194000474002719304689211326105978785832475958986638959931534330017088949207893797158146408468683302582743995062105632920910939,-987885796830617308893276215121691465714909195036687223074279835724490698935510041637862390637888579796023821509180471898402918299122699060691/122032792754996294780034447792892172732311150189211208179174952462227108223842035133484063845636531804589388415865876832398587904394579855807,3925528397653632818371798271180970642635120872184387176361592680073900101313011688278698670857141442237182411754032325621652227819724297420113/8368387444160524150558539284941823630429594401617123049852166985982380109206615354273142339556715304806277429257073359651645061027623420394963,129792850961760954111372278420326930973699019015106826213307812561939801662564726236143622936549229836497121104986095873354014403642676158953/2163574578854768313957460408524060496811466080240278777883316835343224678660585109672699776787901410326919713870984755185652022248991550022991,339081820780570411063310578656553978710965064150887681960666583147133575136920248360936002713963957096256721704228672085207365258792563149579/4293057086887179700330316333650809535803348690727018440337519614818280945855244440037501114581339852848317873884358721575248218421082669561513,1496596105737663638490947989776283726291581656744115499951791225485835532839390187367522240326124881365488020364728047326961489407658811143/78952236084540783716430957665713246408219787933567644437099900721893685569514084766113272105259984225428672254853226835027689500615392814821,-875331460855407852656372292024698600129303036518705185106874832735246866243196706941298567047659695604083706863842695278894123385762882291053/570097923813556358813807335631817495631216457372630551940735347878717651994387732814876655808441275142302871277984175597491957789155661465313,-3685928094281565910183915936774228840180323095080198199525785856190387331440798846997679235321693314082180912024856875694881332845987428127033/2517001692494869683157364248923569434483891843570013368425463676243775875271322594212528216812776569320819318230219049386400884759615722450751,14996858160616817787088231601653582688642464238315810215650323223703863334501722324961476748392535878316997084624305971067155747740176053681598/75988363023244815583398457661417392667995909704655961215589591637010608765707388448197935970618502909864172213751553811831475420323069580640071,52440149286393340675391313909965576534860727431563838694591565947212970315502102158985311503837673418723185278519780927167326955129421158232706/96938065962162996550969503125462017585634132378390791680219112024354973203992917044748710853465445260854470090254782711675125945563366284616673,-46064976994385864420492463260190654022407092787114814437462954309180533568824260264000884146679802146181612463895429985051364426131744691166778/628646355827126453272637643062087241540902076797972312304212264521062419520227863373868993220864044612830615394454647697844653777974757539513987,-5032835154646541613031330220637757612036452437790494577691322415594815588365967108898661582868021646503578879019514587389425510213706927807735/6012475408670280637025366710867819749271356826532201224688376591264494850616439635506688361202427993844691369710581661513615428852749399967776,-5667406781583471331598804377500049459402439984919831297842298962163464166574544430182379145979963631783605604452094859106242320030402123821275/5713320206599390688339150092151363937334504587938973331015892047285453964273869124124154721616870764352156416621228173879846176149165449149696,-9229288925284705671469499153271288061495402478600494403625506370859211744093561580640711527708506022600488185890725345854451435913457379980327/11909864037512430523458343627364664595878064990945398537858830385449949715607775372563181824472030455511424350901317076124665882884206718032896,-25334185084517019675190283643429231685019207614061010955710421474805998155703242133041800787382164735795188557107799971358024669757688995735733/27776942825587077183157040198751700252164817961871859023528599916421510308289412158519356510234152584679361732910315394432978319172764998921056,-57871944791270170167050188373907656338440536039381724004286382124789306493219447889497693071629425740672954550105559160594292004955260272240779/110586077404212232096704199328503976661607729775328971317499356932662160589897843542828623707689119784320505204426220130042603676054061762705312,-273443543310863770468585485638341900670308779657049699020723804288045983476213783209657856316672964801047221764041212815664489318910666490131162/90407723505933996199877893065451612655840355315146303639044194280703044763854479031060571642211944450477782236087536754595264923721354034740277,-6859446963009370035609122646048478794439479606417750928330510551490534876306633101423348482147659195601725470357205832375732531929179443682009/5017259321741376316683573790966381024011110236010568033251563845685087369281575760277877237326947853660501017846504068905730516438183408841995,-1332357399203733665496897120110363518058905343788602446967194491549237741344252570218716310471538845153577448767980403451794538114220889460795/563866120015405177567843606380120336437024880054436382935375427800270899621868516822736072408441483904452799391663401446020422235829995564032,-367991308235648863566532013552734096659388081686889236275039793293900407734476537025222379575704441190187069957524425718427429043379528127952/199928462687911630950395667413418188066270243630853023694025410418747972234643538012634062418428997201956272934440431990909622757359943045127,-1444302487120428194878402495049703963339429956555231108541320675071578112547486590413164767677204019738172952886404640709881422101089075718932/854254612688005411413183945985270792643875218394218727789815082160932671336671733263962173445167743832854840186015173782798251278645137613031,-629119886072333892706395789437506468276632597180192695245511662915589108302499525451105154969524615302930500760651042160680968340476734560389/421480479123742809104546962414601528996747882485726946211284318075754246631220857735955472526032184164535610257217099089034897021536709115263,490361878960595158097073879073638855678211803614828422470364351707189387593809017370831160090932549841291516128028300807449664931223249530262/560293473447986112674489180418474124756922364481137137365085814079631815101776291934195575299221767539564986778542829883576604227680173105577,605831379998175623114963030766125654517171523192088877406995613495108553812347771466640908346370516347356800828406015154340820076086667166264/654869703996949118543317493412373196232426032967288099576442358310316770437123158761133089179173242282854709146137335310578408152399397091379,837071960331801483116472589552809844381659283605156045219560635076475722212933795140554002896542778430003431195515474263696365732014538162371/1633128071477049342369052798446542449976349280981597009218002992154205933383585282849517438194740275770159199670061698742656141773827745212018,384551819963427668558971444750232039242799461833598851578011560869108690845216452976424415406128787545812992931704916891066372222623090934334/776973494290299742931703634854186322008582826220916696746277338764369088887931279320971332391086532597966489703585853158921831454729711057963,125492204980719456605637256998303582829162350935324765852199681309451938178519889785023989377282033486287040805580746877449808969556894327823/227346566265386676768721381935933601648391850747651054874117949195236838177711374751035600803669255628719012934260696648243756927906456007311,1307874202396067913390233856567277986609639596396063004531056359801921600650924637926807765783696640899026236267072372325029506177066152539405/2414618587068051913423366003041695206808017974756076008209767162996354562665575313767457041006505868118686527335494529042458489959917219987224,116765947369558447030480060067733550869531539297002018851292348414671685685655913132025794553791225635842006449255369956100607569194680551731/229031971962298852995202316006275093698441732906421291180203140572440681679268244327439029177390569822212793186965860964451743134922259541781,-14112800625398484194191062515485220059726907537818007348760902165090289456856146701296595513725778154356642247505506619992067851200837744243/111562101849302631324986940707384986245801001673850330124833870823385358300793981938852123761175994475055333838315816404430695055991518543359,-154083321813142380971020437431208675835814740199274262374416828022439336073451753130214350638210837857981766443376942583285897600237168475469/1108087477608722802351211624087172618216220049785250771062951163586239388805830122433298941165096993118792255589581511358332412615878040225786,-544919938474278554807545495112379218806835200258885090469929272436361014180303115934995658932339044784314563855834021633594940859798640542088/4922298853755594953916161366071634508447290492448519708062936398471843433334257016078045264365855683065274959405232632132955244922397549503197,-51540000338198877859220885247335138617506814314956363837319513069553713208502107638414306715442841927825885994438940086012398016543090281002/614377934133331434633487128706423709780896618977606727666036706262494391440728722656109549684278858906938504625246396641824486726867581578633,5502925353687286415242032293280711718258799233769967670799723167319740958115255584521529462540092340013057853478350338701862884791435497742/68952047823333485747468692306141085421537548000118909103461841609503187194261849969856521085197551279785146027928401789471141144854755444689,-118712579583402229479944414304784856173414993066314407550657989795085875486799154113869168643794365797796520548514300206490623055427634586358/797586384570400830793285132018516929380070686903847826487266821516249315933850365223579391777312798569977914673824532224228241154447355165059,-33760361816946266177454914921789457573730499197091047617583450821540727382225030885589187052034042259096671418292626796455885205274307727191/157015716291105497152675741514857779476606654172255508377266440009802437760165874759145592586700369623452512342133006811986254995344626773891,1836205985407054374798146515615470796249640948795377387179899730125992936613856732287252879358418589708559679876407370396662892870654758814372/9445960973966211872100816707258763195807196808898080313067306167086114069445547721816622646797710524604203300295346868903189805291615576204359,7580750486830952445937646954465308698806847566213250182161944744247802154525566460815714282111175939361532001672934230990311431455462890243/36731090972197854167135866115728465106377489088681127542716856874601095274380653423768947915682561078669666077163224270612441918644845821062,179539302880739556799887678972436670467704053829622643585900178189616985498382260937437022559002791421192528952504552471437666090360374358014/387659437566693610139642291573320194359513277892399711664998011058425070094603596841346619112839091515764788675319583247790019778792589859443,-4045984338956843145235686329268549770141270676149862927720992121321457513224575749664191269088301711075115541083534329551957492829163717807014/667987715025088965383070627860424715859438577382066923511951807872137972338758908064427488625486650354740896204919293509012831960956521774895,-9981465195216471306502086065120282302221558176536229803171273332133092809315341623394589708289766264237887968328133545530359827573548549972242/5220161908399906327705892812037224798804584204547470984924330108601972189611906872028863961222616009563016954576086958030960753700368238848239,-4687721980301290095520273240487324660436411067070022798972013927275036670764093334618878242977860456565145729895627167476722264316054420357142/1929806546986045334096120506069833793614238094654769891995110191818930566593378136191889708104170177610942786788355104612762108315920485127981,-87639345276089745614615544099169939617612678619882168356052007495328638563396304006967704296763776322165425199262611932085310224835114141335/196814369776500959477109150568510100720797992505248363226165318335208000848402390784547608763520117084432741638082636333427185398070466374234,-31137354542705943818436879733216356232460010827149683126340657314643342520221310000615491045311368719228485236600941659462764732961233218528/68400993462952804431553552776968436885175838631539277990873501762457416748268824110361501239442895977686724263344438495972015752561154719107,-40116638431965722722124170632082488062862839805403261277980268340661674600599746115265733992059867545357515165900350870269828604752188492596/89289677985718789440498334130035562911254168286656065166898656287569527812572335903316135707179177365748279607059982765667927115060095168749,-195175717619531660714462863245692986575584930904923479561707721078489050268984123548892469545155186709857829827131943107312688164584465820032/592967563226866612372372013052902903829883962623796830936048692144314862994071755707457931289991962533010801689258323097157670160261593678613,-21790371395030365613484824486876943936552695823934774631214209381939356560636080752381779901037170306783153792658858635370213700803668089667/34219331009398564500036948441659641165850077424170994778150862612588817295071238003854780607550738085784516481645506483848147484300149380758,-605421738962121354644194783835567027061324063890008717525294524893147156576399603233426522644554631619459851833969919228562823908005137013974/1032476511460897565466490580873783440503252735041330953823733188294608987734979256534993782217496477957134367505921722862099768940477206078861,-275210547621385330794050205753937414094105488278670536630853570724211965428416121547989449063716308532171734233461869503572606435952183930934/2788753077817557310921333200108344444664146489475728364907653640633870978507619765718974861463934548988222910873398509404159867134656860149709,-70440320901834055177306795901601865164095779618079104221705278238582067108803728669521333388820424528461355580668186812145249886140427307250/390197624753153133276724642311497694319002509167946571337374645793141503223642228557124445639856537444639333705733617634931950379876986810687,18374448949381780868064225145379736656906783605214963060389668122623474054777773128342308707642912235578584007529986214744855097807227353769/106176339406316823323185807353114203298981960448028341932508351565383358838052399379531704174794601698821183414074423801986518577346621645649,-724031947641401604982910015603472446695728596879941682113042788283461125827585036490913243290439660065664703754333117633146731738313536906374/794969718611959676801736352757715012767040150050076454651102195301918578816427218830031708011666993813494724014142976430165451839047677295269,-60606805090207222496462309692703122175572888002342081687461920367015191546657669862070600346192795080499044057517367949256901662041822674152/133692740195501687818713571697136442785597513179288539196119190918671932357195702511953106014920302771876467634164673205625131800220820534837,-6887417726856016480623156788389189570026608745955876216197492479311655071318236199661170580611312839487944851556391296547209936472876545624266/12316969890126019250087421492774264819659856516192425656244476400295282602522901044667223594797521718509805694690091050175724835268434556767659,-2070478888484002984806024257462546366649904830729670940670419118584754670839421726370622406238346948568521888680574137521404600676649375760998/1867820299461219331077191889040617759582697540517193634679349051630267968376188855954252352619924153440920745974746662552025082495753043257553,-128909922277047531175850646979036610087959150528131777625508577870568516813268585713747659699448503829173701036741584288231451052619864201939014/55621907840631011782228262932707117296574683389561601145374184353821310249192070401984100025818247880286325880651470532835966112435468214422021,-1773914507492098170303419504032172744507508309001248613373935323648601297951543114747007579641685007576542003663452786974077123168211395910/962735534347786853651925848233047595612639914447242097991348723733136982690726140918670472488861252689056176618608577769243802158205397061,-924313627847638934240635042387898348337570124637177662629259256164227368515254703540470696257286894988277864685641929658060500041985541556766/465350360270864657283280785399636596636415360104131861288507476359495352338183353716672448681123994784842696661540741641120680920182019573177,-47681033344477372521367189796138556570814802554974208549703106987549269132889320459079968692740002977268471269443834478099489897603516542557/120915863400214580636270396071274895151120714147603967169830483849246433691345972752543459735500750138586772608683293695044366463945517633253,-310935808720955135084009840049180587601946419296766801471867208275422910526497595861135529074257917302897611234790813800775815397301062144424/608653183431181881699016838202827441965915849060405986071144442853116217908828174552637813421655357254357595040221306104706703972948405650169,-117167843251844912793006189570252186946091531653070903602243313467129592325397608508629939693643714859452107777402588723309223897996298763349/104352120285368198100644835183706969566485987873810205342654734961835637455581703489528818909515774721853184322563149486351810105498331105552,-133452068674731654847000479903032604530094337029619198843946534048337500459817984518557384222990888618611947072398867223416186987508255664067/623774363628274738783249466481221073631411117529025327858358008767357331083703678655913326102134662887002774294685102334848155010247100028073,-1715287502847957193033982259174273079502626194264020217603234350965831386072333564907094943230461904990335604752964098565424790061072947764742/3228896732932891394980874576884562656111096670318023276690208087276825809963286968327245615768200963893810993192180883816693703585697554348163,-1089853415530509458453721715180405573927225844327510161050740417107472089674691241703324706228017303037712930471103368500753517897868247322182/2462691019082084175664334386290794286357820719822218240133444913121709260287815623247221282842921878496304612664470833129583969884561989388587,-271566810593611306037888347768163727594623323612766048111826850541301295631730065851254495929591092911642119287860894461375988075559730397892/1034983208146232221170581803544027364669811273637705245266356233388726100655922089766800151083974988028083184940250600100141950000413061814673,-40510114746087695460715161120330609801636408460962924794949599507404239240322924661729703635948740297905804204765716050102892220284437416148/300111979092398999111429068951986759395840800792189084750866791513753363385303191254877314943339012512322798070762591509711227696341969811837,-74215209937711051899698594882278309923003610345215130967141814954190869275533513615208941091046052189018426464914995262383338067735147762643/496873960216272273158892127707668132602051224677091386414135533539554527152756671284478427264854162833921070721125438170438127419252804250364,-13175857807614510124459414881918995560560868113649825031781635530533924674165279025361243137042521439812622081327060189061872067250010449293/113457926447410702541173865823744895114325645752755946319347783496994550416867212468216103364730339215150401809443934845713694647144640906674,-62727509404478152940105203229925019711196903165309510348133196982827192117570901000237234285433128747830405701393989730529240978467844941136/211686906977812137766931414540662903764785756364570270372264998485840430104214027964669584483708016372487199187761044488745402121003262011773,-918619335084261659065639240215092888656103352975813106118916479796886730177476232210026133834410106702002708725122175413459924244342154720703/817192082865853855297246100439664992847461850174358073765010058645771653279117182492312694181717018289686859334669486348056244607769248969572,-225196621536456916714153763079079688683846403213103738003499681352525335908172045701945484201276899899724974976524833546167224870255331173973/1041901416216479975149527121930079703915424998181752445035970154635876932486827919683931692619666513336994130483617624789710490532417493539968,-393493568836451984316328881094371314584728652045161567742440232445621796631444334226319300923118355351151556601322720819572211808046713870783/4724714557986331202252291381283183901197295266187319648178676004587201038877140069089767543455538965453147513955360247071134308724770863955424,-44881752582461715741749712574350339015354235444848503621412101169229375091490122818197314095815442468635713948538107413876705069309944027127/915689646255833812864374076581222835048276359375318367409369788480457643414463632155410565279804836986618981891307237934278583351658432022688,-11381899115102823149099742169285738841820978465260269301597065610538293796233837112800124411215212366267111905760022626389422093482701812327/41530670383711672853088471427470228195527813713712368903030941728031846123552338496417746832790389486791831017753972565741504894228035441175,-2093424152119772349288283647695978110557448593585422210533015167043705187516257165149109400414194516917971456092761724732631395484011693607/11816196838930739789422423515761725463981354100572855218782563998343858454028881618436948151591657960028571467628342867086638531944504696115,-1634668874491573719111207703006867758108901577986544306051813606724915609554239782762785756793300368436607503456917088210151829218954113079/19336803960274883695418505997029808126542621545994417048304373400102018714507180578800397580643320823178135445163341843129848235455428813397,-42832624275869056667789448400083402452215228383098893888525464335799493167938261923262177356208560028988711420535053837019210356846400920916/249760661363771426295383321421078216437392093757218988335476936424494992043854263572785183979242074838401893194562815434686188287943961051031,-363305894503039362695645596174837882829094856127934982079889113282099793855184266696758728455099929117567266415728769172775787874313624718758/982564066900064268491846106171641415215943020696725229975642451288943109894659927658513580542175373896485848751714094106560427700769122180065,-50139720476066047052296211040728371141369632636114765544250744448379073881362756522583376339481556603789301444672936420241467599866798223487/145719700250458342638172730076311630117467570092293813177167673250885644226116747073775757361757526839545026267422374959279621045726695296317,-78139643555683931296296630571424513316586097044804230406752189795801116444606419255611358383053435703126280090112254994423225943882803940017/165785269674577790609942835268892414677296567878039262904880616102495248660637456409158794980624840796205841361246063132536419700753843146893,-211144365100176809072329331559198174821125459784344737214833484127178077842547740965448837445169006664014005937694060130147689810604708085456008/155473355972301760823245322096420369673739783116948185381602480851836737491811913569671828481438903703581408729270565354173437886333164845279361,-3646926368143118353228741072281955262050752959469335587143763360237317890284899451303509971202555001253629888591459744252889348737403398040405/3584355053315890794047194672151058987141166032227379124090543903958702288088087900606844960799953249584227208626043757743286788209166180032999,-489920983367932346208498186638274224060689085854294566667503648748256599042464579905929843758274626314594966155269080862805934421005260400482/574211550726530408295605695922855257450425332448158135888380177656253525840629511364742108038419339542412228082267223692371347003019800268503,-1244134461462321900089947335874549972705257673959493996604403460336551406086717859374963083467422738775047938718186100375388798925518306234072/1260028526712978934363916879466867878041270834243014068509462243019826553408046317333581016147503148720266095528621651033996573176021325056415,-253800908736424309919613332874774647788059861091037657464065926563685658129459386421563989968642806787754132429056590038753673183807190281918/563205443073766122531902264392047603747107198608379708496505650864219645145496571135208672353662806623060945535657204953796151301266999660825,-1233841166461493419677506228471788680541308579875664901060654181502173924857877736867444244148265609197078389956212254928167845107902924289914/2731812887702433998014027116391506556144290386026539131220840239223535863444735905564071539354417287466510820049941754253793675004216533515247,-158047800918376876858429284806574299777883734830576968024397342657614271297113960753673848107781622407600222130324135333818917474142894424215896/116675936323592949008405434158524580460807987798661983268152469463888716650535533197008817519594650713036742877360523833726426651546938359252341,-5705558919859255326938687752511116599183895376494643399695262783642354168809591219708559937864980003589826933804253407813939480404700514873101/4693090382740035112631374499867161641863297298886229523258835908521661469415962423417129707834302129083574570429433292297365115153719949511942,-13008671175266983954799580518098141005904271624788526711539061682042280561111057691339476082546083714681600097942610858646384410905428559320232/8201565383116588618634128438781291057455094273871236390295092375846275552881700924474146499541526050550556964042727921689232838224451552056193,-1324285002808728467150348385545933879661769533766412956173030889159662520655774950782746348988077850588839563647773533294224840364567140187388/328286227085159774388220287867685423037156916807442732758132044558567451467381411728201858003116053950114677710123903989132370067613979322959,-16810771455745401390144901237526577991893037390139243075955976801193729469108759768246394009459113134745559607345579429925671619185440827292117/19920527082791163107857004439489255789795627215444100309375378859390269731923681541329907536835517612910307711415286746369310580746060275213369,-19839780376913701319502485479935079469220168709567752273521008718379750589979624238254077455324434290551536488481975680141815655796072601759048/11717557032452428445219008907945508742598963922589863793748020305075464783877171187129695424310492152430395964470018744787205431320782591858197,3123606891371009231872367618721507277928141070760489962149136783993057772826335836051221894049790203004142965973654994228728956195248580819/91061210194229397280707599583517658138588882632703653946541207110873068610932725134384587706719000989822474317572643315632322056381229656684,-49218111467881289602892987388676607251026929683347599657370338661756243062463352965283206153871029237495983952327873328967352140177851230602041/66425159212865252372508043502428389896673629304115864080944812280067924699882371801119661222972292052877716124281629232024315308330792155021224,-6413319999801786879242398980524493776427193824953350940168337027530760838487444265468659584275922211875821972009998908335903630980334511757399/8836799593798870844707317454877725632734024896526140497284478236745978253393220141188029097407377612667641133186092927244598478683641637865744,-9107300051185885695578239838671391454104074957287049419282154255190655259938722190234721761277077516544571506492017413748698729581767371825491/18368272124982184287422108020010125395743043941172712225339222923145648455484848213292615899739249254818813762849192397007429877604960744149432,-89267904864770844291212582648649920869756904567458414610555309950120012080046260993140412916845177540318429856618301619451758700075632755399/231343789522554711120538524866444100105051312330880489085367771862840841513720799310254910086250555869371279891241522563592836206335360551947,-267570633370416462625013063279175625941230607109887164144238592874157419450937458774425556357177920443625629547850771420459585907670545244301137/307955760158466594933333612639590301261718648295770079320474509875134865171273541833300123747660806447591082625075800598006667170573182287837248,-473915686509686301379444252294823984342705400571990224081530356040963519683566904571513981537959213990065707836643449808011142370220582227703131/510123695488467305275414256647709244730053215192586737070986851913815993337887822278051927987094444266780397741147657958590279319021556230635712,-71952469475222742912106618262008060198092697686760521031512249782065334012101264929877169652093663300195695954311314432104506247632474261282041/110840063450021528034406656381165012754380378678537077675788928300140182845652966681495232621712428662966499130342286580171238137067781482856508,-21924333066894499725564514576665276967038056420557171463254165206031884157791041848748201288450492940647853453264590718114311867112493929028780/49695007425389269513007706514936195839180580985699824095016875216536105581658618953160034893285147633201436326991327584469160876170317709887971,-510079885668406703856651461858316801156373719729384911362824053505078116256127034114259466411989751918490317230435907767081769075641618538402016/793812921426202134823817791518972037408781928634890639273770925928373515279199274004975878128433406686540464034164531804543359802017477452804725,-131621704698269771216603052170183798378508582370359828688754626025528382481156772911165829590611093626700984010408775482814816533281139438813370/118258907454198946035208099629053477677499272928266173735123362719834132255207450722711716594606115797894664908050577143445501266148350825986733,-21579801931937892077129700297761914401266850055131026598481801972236184701959553227245895864704583519077761505132526402357469226350647986958341/33971024959416338462820973185443314685973377901082779645116913657859365809151301697883546913009096081374899816870286006450589115388643706958973,-369466939210098563088161189869992026536141489540680723772123678876505767511832174461162502692751253618965675850061985559274739450423022079180772/528832125706598950407194119620906268620737840215251833794621641909766063454989118772370594677906770207749297670318240565628896660299075412163601,-2958991069526491451177714539200776205201592923756652316646947616293617143411259112279860968714686177221574346795571234868652110842446606618056/4241138493502980170592730176848812813078136784940115609886471076160336784560732352883014863525211368319455121158487668366949114252775411330769,-4169205066750884940536428407599378339075449908257533479610125683044411807517074338183755065143452417994307384380007360849281411641007146213261/5773172275541573109309935863042957457794972445239421318928697558312085872146979049587141985538432453625393348219333653353907535339748968779104,-740808873219720410813525628022625667226995695467952192608521682280027929319690952903388951785185308221949110376420215099803045576300886225704572/1062656695936341702673896911318816459259598516216619098675259376048538109217273249452166134872678523474328071821780906390008173369441984491029241,-840714780091324261196627454769387803384875331453042981406958014586511425357755414679529694319349842185809542472508277534118018972351369182313/40959467396025466732847619439377115470666982046597366049294425034857703872906896861730232793603762913235252142424319367941920512971710602105076,29377717450301733947025163923917457649774516371145738503853973143871298368023986500718641237997665333336727904419704703200178259649339764468264/76636987125229427929531207302114768730327999742041759372105691441119393564524752827372583459281410241745133060208976145269009557002794650712335,19711589693841158173964543754587083819686128550635573928724211690175213339947565457621755878756154708784256456206004917841151168942495124751916/50070099354261248248796593133554161876445856792657338273135152720297163115761483859952700563824451274075752361323263343925776961306879600973501,4115205326091572032683897282953678859911914636436264884503634556696617612552281963127195641982432943680622418185749131666232349584985758446290/6801322499825926831463836182266452558818066248963736218487707232071720325279615257058442576427647423592098148765047367734767427806148474431121,4276229408678633702309194175166514466426319627987712204728753185959270140344990677176559276941866866536819279528336862288751084063431691779692/11270999357187406215407620178750425733100305804920045507295108068336498379075715869309959067100442456852192686144940731438233352370377697318381,-179852723084106559648229458679949258608648332111285028809607503061089160366470132033850878456823339761755490403392137087319730392624848655629/1234016421412950516659056524371317998309184280997666197277864547662226806348914983289685332504772898704101525564804714739890103164527651387960,-1059542429927142007650841810568479328779176435335842822063813457943871050368547253967688396539958502002511795158517337152831078991311234522321/1957723830955990021077059308204770228909517629199956463710963158679739950005768444166943245794428790088512695471680659864393232209853920624384,-56095553226183037432370702934085926845084952285232535530075567658303916087342000455189664831739507325514710566383883434913320618035837933744/99029888066168402867539225843142892946420690770878789755617880024140687519232123751850508184108696087761921693464000384125424955979891288261,-45538362553370363094796059452291515955135851856321530210428800757359409218964760773486428124658194416074099098148210036969217860629642539544/82892899862067016372022165004949581408701236975506624408455015786533854198326174131569390891435015786644617762817731051052071860695124784301,-89960754081095766825297482434160439545719039109718179068397642551561381404464566139119315470762958048615792627449579946969344490601824613850/742712742461537718210901701563841426890716675248283990798525867607092800549114638299964425636111895900954061915313503075336435858452719348037,-678864368759196395711237129596789568903095968129199441657291298315762173402225024696547640513017237233095055191259898824474890015713417843218/4360110342147155416066525419532690100039432132443458821508208922502098090915657767847419023949917559651252044775075474731635708420984787101167,-2946283354889163859613399695206146022034236100552940809756712948588062820451089361133287763812506381364162976894760393150812141254268705198198/11292348080041017080289500202100999873522452089028734359126682666210493132542633253948476540332720790874157438415827632482176965461312134815101,-5009976822258860014682011168276009729375476807297260476015184686893816060220521753941245208331954613707299362588991566573049691829840265237394/27119514293674520370136160658510127618938814684276316715373327042807587284008701332743297560646200562903264268075794528983039177258536768701279,-24909663415973492908082743157634173366551296005095926838402618839389542820659138032849454697535595004970241251347658065345006107888174317574/203897306416655110648711035021019571101011722451587110545805567207321869943773550675546349115442201689987145103518928455411308510227089869793,-50409507715131716318822349083201301024966710157029558496794820343278536347759676019354617789811142359959925138243159381196649273423130429330/407868219477745149690540258341155944281751521210367133082758206724930554439560443707584937854598377079892846615846517136022095280614580775031,-1827045600021615841448499738876832303534366567895409347995983373329103747529454581105871532430024703767597366209265872448848432176034293434938/11010884508094970821104347306848851315763752394805267707577685960655247313340489529944662429776190610242740907643542859895538938082288633294747,-2156049447933036954965557810181690528397251972605857258246018724588163196683710292570994520722951987858038376579395704868482425691761245858439/6700947534299079509633193306104393459780385488514145193756349483410680451558431563285502171978266050591001978101419138590786899303022117487322,7503353902673727391778353021815458875701190443802043585582971634114504340267142827212303520168100239872389399351646628493271391323675367471/44359100544910207212606279699526032012545240486082222691366995811696603095263114607101739351263554557345828466676501749659130993767497928614,479540504895320652420480404574674804659825470839495613940801150390374949373135917260852208766109568836669462999326958393948457348219244476689/1365520227395895436943141207979226068846772409324500376190476262541000107054563635058515403418164683936332509728005117078324127459932027259516,-120894477586208935481459681004944810032424387521706138894397193816824524617824906461057336025422072619219940809523899658261431991448482625362/1600198852237743448590892240952702347243855940231049886681020348948876400286102999250688278913137438964912666564714687084443165898027808410527,-1619043122980067832057247502037391073009552618394321666128443165595671053449380521983952418735168513071808850099883054431648039017754981515482/26158582156825723675423085970606059583092950019161126135012244078761704320868685225777008207416158018999173913132930280117185101880722782067883,-43263529722073308679002611287639277438542219084490806614153622297001103169196824976436320294906466584009760993383961997441945128399581023098/561051317878748417714859912756940455320332171809578221572612680491472062008725996208711220513669845301059807825564863816642067180187373168731,-72912919943767592706957482230579558722672300484518908659690335483128019772160653515227888540671447128648385039860688402551799319692910616242/1090507961957575050940490333585740049884774280405411434151087499837331883043301571206441313867450084786242955162032093039892523452401216094751,-58635744941431458098188487196655134428147056042837359382668959374228735278827571383335525711762260238465863163239006394268889336125762267403/1102979728720204100629572947391234639736999090999722301761332133684404644002930156466235922446690551901328825625066062253496743803210998236336,31585116449738549615975750321640656651444811388131308518322949093566716828958881898358978338605533839865634688244078949038363586348837816196/105411635709891705341185721090977926611868763903268657038166287997186957022621406112015219814748676238573731078480892282593457672759084633119,-6850030717586991726245862124259244483280545019698076866510538190298055903881266438657149581727831662360075899881006774841869510899804790330/67341566594865683935669300765425572516077108169599281599858755488471800896266823755301833163403442012049396035586322425039176230923193679027,5727919451548932758990883535132708066071418375031054935297992411681928387647384250649198410565696624617081589728529505778937445274074252318/40590793594302910511057934852789850175674908601154776685335927999912068010262906413119268392574486054137982937969072266318422137026605323107,-62969621170090537124668440179842688193138566017139910493039613039141228141000533183503822359276659883427193950375171380013485156903413379723/580607671079558457546633699960630476227884209728132824875411734525453242378330432295391865223463770296612388300966739573778959623861032347736,-507556523377688291729136434679802365088093115002651375267501498227784278848045459024230086070949274245671063989885235169949877920628191716803/939579462972439150645489925367576661932457175182220839936352287132149999463228966572867040865025243326421973589316114569816911913083944123296,-70222322285497351109944649505203506248499850268892406755441488951197625033163434584140008726705529196755027168203025861918677013118508600143/222539746212013258200180394536044736931870966729892401897155094180775579563402794207873087951842504338971269694895849870670544089804149773772,-161316617801857016791473251694232077943150417374521385369219923490318243556142356481649028120930555571904156310221243009932957721015145549867/1665737753941063193297074390148418440297935020348619318800668440387804821469143879925168937430564756561509542166485421921108098513525255777680,143621465509757237627341770502923826958112511943716866994660973940565976300502387661578475037419241445123219798385804949521311361357268780373/2053277166082768003649145174901409399746253397060549383594948194892457069821867076125915896718268930389419067711918174007941436715837775578672,-36351080433437036330623798602268962232223152143019762571613719684101779656936446528719323513887960755564770796441012334261007257628589067063/165810216132175164137076177565401979137569646600847362733608453066031415632771728366721753412263312995041008686531402737508586587884626931512,-81172807667959692347770291196822062995288270827332753137690362337298886519097115435175850892437037724316735162054683362635125298099983428433/802576388711136118950524944424264770204160131783478075153215934155731560977065736283675370975241926447450463995993120790411761408606061618128,377197071419968678564299216240228368523374431703011373733495733848656629222472271479300825123510712849474958837889950892875405799750802482913/751376140682865937835644221941739128323918484798952637577023136293376225006047300086542323512822851091291577609711824383776378682051822598256,-77501172983225589173423642660297704452776860761801579345540421045191490580222026247901527883197148729336960255185897689476031446035345143008388/65819526768905153446825781025174501640009358282688365906316315476669332207887774180130387006543183986904164391687322074040406335558753745549895,-40363538176200262738640642821259903790434072347150002920156745021116028593683014895981045809881472224652957738457408713425551372152914243217195/33974201305324510008947004278523128898425393048734159266325370828012610956141893897719563253851225121517000447955258814677036196231225337724876,41327913443262025022986069443281071245511188557561507339860094181745901372385692656131525180089253364718887816965836645344391626215776502275110/53249365149908377577714807066832364166191380313535393213786729124855393048827408934903899609853963276832879918755912921981196830793382505016983,-140537809412318776121994763125430784191407354391496993721613942299227113409040158925677373845406751317408837551498136932779189334495789992518994/280744616506621812856360160154650071462725812015727861918364152292745403480397251074448899616767116521719769940429279325519422448396684877261839,-1111817129005165735086227759667216517184362670128492822884771337189703052390424568516363384027036159252140061433577875354928320485666983448862806/2613814347670171864479760937092643776112101013983895042244019623520927401189352062276913696060910079626947887551872385231479973261005936358320765,-306689535240548906835882523683723001339311564045993837680501878117237779261147105002520723937962089607145517481648136161906079792142139950603706/257239706801075287615040012641709499926505707814695788540902421783095418403998783106250154785551402946202097103793587296453348915520749771264291,-808737221345845213832680762206193476652795188845544043332678328342745332794407524310396221741319124192641305514713202745312074271500452894128662/1792517836471683340849469983999621720197725219277344331714101494898804986704629840810900147687573167951490716262503709963836915484771630618693025,10939723305197309295392604303299427060416113386719973409205164040555642088713219246542657464472800182732075601151646396452781042151444563659638/40615827396329339794503270783289785654350515834106960556265437512040354600854306641642015416543233478430387915170958975107785639132457985475555,42131097803944556924835634263462800767110126575676206470364010243499576090482912671539015499526089369657932263279987422759738841092781982126/1088914127140432444924325593808978480915447187524477949482853138612223710867789439263615742938616312005897855556987664040208128184191486721315,2473083594918043439494526347433915859358053677859714214574520305688609477012511658593295453551867255750717941910065771860642370980414043713354/11374813442529308093554650706646823696460375087665743223096035317151269983361193085844043483297491734863248329331646661247261836538155793499049,-152441537785919733851091888347496678526124771123013645364527916280700200111696104006950958216170032360434235288390373761962880623788814614151834/192080121454335949318906338395323293994544180901096670818449441026828664466360828419965237214183312550857841464136206483120289411046228411641051,-227944897551015297151606821944121874491194612386531780003913228998530273642779233729603006615808796071600130866583032880594144497708465081680346/305903681790759508986244469454847474669839314300269618671024775933499392636780519644922296172983413973923963068124273877005756235468234853959135,-51035889606115391842451340523339116988142992831947212750312756633144273416119968746971385239473809008079225937651114949416987951813474546260570/56909915797024310854800247032061870842894985771505437362034694180908237368595559749020679014670177352100321628602811883615102584377055526126523,-47869366876516422849125556898422465808008551837852326057561924567687868164966914588785944631113052921656916303128407093358088077191294598073114/26632580213190208549453476564742614251994068469162368506069583832670018015145625998223204168753721339926695764600488674762403196814410022295243,-2869882250565139044777474372594950369077424454181542763425392736119760901329145514687273769771857217235522538097345655288038211435087179916597/7007467874883828712076105539646669129136878545659005075487475487976777705696038085850639820449045743266306599869505285362104568634050905202013,-1527383266958886830117978835099251338916283026117216021504570613736520523623113088574156120780491296766029040680530321706824490815132471515505/10448960511039603513987487758438279935278284832263054611632740745528249242590993933709671711529082647852257406104884369571667887505752683783214,-1470356527649488953404030740756093757189832130031619526584763439289018074986747640877614265029996019669994070051904448544856932817344727398452/11968331509370981095882076849420144358285560254606405998526743112603004913759436955046994613742837049405635209790913210771740960876251076033011,-246213020963125425591431300300437015098673987516785300343414691548923348145023042552083257314543125280361119302525336640888765933891232343514/1732188025337405874030195442902344790055319982074881483299024029297473149253624143063085789586541532129725976801886174365830355322156833806815,-762628611985504112090431043555479265058291132261674142378591652394870587677938738612070332311109848461411475531069165795005646843810480570636/5703687952966315023811621699002679531936031250013167904957712616494052253758139238709745513366805063086446121764502522203435832187604678488197,33217904712051782961943010955013895077975623444858529370940938803403111815423672816551532566951042510201441721590128984919706504028867912188/230098692891745408519078943959265694784449239921142253927278923803448682742132054411061090012901331462760961517847539966257010287539983322071,-96311563754396304932045188886684009695505522428626950293291674331069831547052940654498966674788623253492814976058061657610459438439461342333/749581501197383636174263974068295009259779572189269020477895732596143300047467492650580565661511722122751738119817353496900022219965577405185,-1577473716633374605367217939890100450341421640012306246845678955201002771822212861292214918349904316995556192264675133399933343397904482670222/12656840572542950583039818335910343675093877289883353290534790540744194965549257481429611454783838687162498828385583246122810235360031875192445,15629588225570519754311109107778074077124881332719995075246758528123314596632500996123721597467936951577185647225996380886931823183471023895610/19668463509857464529751469037348636791010467013027515356416360675096129648561095708316918207480774129144857241740515612538249661615840041053353,4835665459941112175488049417745283924742238134228235786589518557662584800980411575801310571187760780824136544956589678370617112668321004225007/606389402413373795422655563030604147263099884484735644161139553612130042375210459248245113264687332347220485315291462598501712475866375661887648,-87995566250499581094261057192695470360548092254289937074949290994758376121868143990775940697711178135226280400710187735800823445771859207311/1459996108869540611827913053954005243015872261660304492927528326395424181869893724359391895226721643477620005875449264866613457036350442573640,-11374455872045628139368542395874248365592245695038675582985873311693341718877406234483576045190674134372105775970806230052249444456582264535/131385263187796372379341293648561045681958035051447833201399477408806721268487167084793707758867342781957773709785579386648855226841198296608,3699991431309440878200001451069457761107257467180737013993825708625604565101710107895260428076977926233821560777888598346380149916581032132405/1823793688172955329777581259868440234401394734554731935500668773303586271250309738128626005451853573966966852033381286405799957156049779000384,-444897292580643897858398019493612737491057292907637097493380417257774126661376886011817818782067962982932019425678404412755059713065093560667/2107574356888246256356373457027736048149216533448994292749681226464103328092071803841901536178681113706689239687075289284332635964163334282272,-241501490553954157129255164034631284542563064946540077623391391630838570030566212274542637129525276086460184662982481186119808795658006708835299/252505931869169192597029573262273453218482883571156824966374637582342214399339006590630383397981246787498010401766120315604229051536527886053088,-3303269002533819051003719846580929006797626832668111120768349575726451144875359930048377060254076303053883896049065207701985792109009931291909/10161306897067169128675791361530100471742118864656197792215626148666983724260229055557333771491749741727776824703763264067760637115996650281624,-627796394357020359172211225925013895521742803532011078547558694499601462278026349769719670216460180043865732527988317177401940121708623323208/965097410388405490045604355196528552663362834171339476162412517669335850181372712163867012647352908757757151310409133345796511748946584100989,-4397268462014982914200855652916877315494336699157257440794669114016071231547145256027974044127303713717831385852856084988272910483196968268079/13741688045609858871444622585077210999097171746359771845216118532039248631292596470804712563773693670825501367104154232416861531772686823675168,-5963719584014002966298793287113726813763780240936092824076094672075878590756859034009136268994445567880219827534655286208108687327946436921689/36291683521554945840744243642885657547114146614461874025739268400398420252633633859924632094084973818138621363937339122810340720848075997143520,-6930898421197019926938566329921626008569753584824237428567037667673841358394968189142058134755339509493421937823281889756984170509960523970085/23338549844260306330885768003945274232236849745591813321214457892069989793521890128434082190937895550272327892738177748114198406370082533533792,-66146458716282359491535933372479289708829850744108258453214400627966766683348743058928948274179796820628672907015875967764694504624877610100083/174562149097326101188997652569764906293746144235261846745154065221160322750973978902361148991968164670447229101870019680148612124954516601143968,69763944097714144509754586963867305177433982935572566729971770500571148070950908198445071016931864220777373547635523976811910269264497798097/81807956039866206062104010879698639111504397054322880845750230479058050279140559831684176336598037592049661338100588306036362218390080373692,75686696782468659970000133801242999581650685844883707056677346988914580986198832327136279818391323205953253968914972358507267988467589840603/60391181169629681289068483661329503569270777658254282827230711774749197717688524724437444248273721194156509230155321440001691753140354981360,-328438946108560071848513497293552875068898425489143275493243534566877659426780364718451267342589126282672924219112458198784079107648269200453/1448865418651464022536367010807355507859510111353972717917290391206848264733774398396448708626015452304809085341552460133590761193357935450720,-24847243555156468766372924406116372319251864766053282726214432270983943388805615654440398351902664997780937818912270088538223288756298440315/613685063848963118015726252634427551614050919443277696096586311524176465937675619988430565919076222988887131008438280152965606620979829302688,2083382789760460398045668286509792350828479041060394360965423099627242686772101598364181331587652489861363922715675468746579877947866202185/191720370360952711351675387596964789474981755741548329850720207353281416055044088355180111740432518024862281481503132907267218647213144042464,486676628514056352494672891872657935921963445785345337582641468345966159550808266229008989663880214516701328267852306276738451356467930647367/601314513885062637402441504181843965564486012390543811612792001582721181023923574161065808679504489783202987920480809820453420650062114061248,75074622358311344217088745390623973037588544432096188873456686211089124947169816097830244491299870463344782948995450852383221300835334252125/91290009039959100987489792571011756728182871814363858596256396816546625076617500466456268061812089348695755782492789786483916998596941061696,-775904326619026572173908493963158891499572516196840550844385059110187900034405501178708984498148283158156381452017977525532879114864374596651/1430311299109571007595349365482320790522482977674599793193365794221746554403348552984325171278007829250854321395259601356157902868402757343680,-53692692535492679632400962208987483726740898499468855210301845036877132312910009093213637902682837033820219375959115536384497778548878735479839/91677073773838256022077264565219708343803596881916113071822343524620828724664248635625903908957718684793098885534248229447660847508518553883232,-26249237448496356149292858900417552855761810208409813979395377027262817860844252456534116120406981770427339595082524693013024842080553269740138/21939211154013995800302253142308651349792295708934179798784198749573472707223332187160704054815933448097863377663820549156001583256379104865955,-1061706648835190077236453612313411068555312129474145694899680879368821696260816342573290398925875434770159517699462316911969457080832203772522/2178878015198091113019457181356274052112678598435386230019961221911362495894631519698493752937904431735902001103951140442384232858324537811615,-1106929654323599213685272604756422244074688729747608116547708229644303136384936991599229782857503934602764858451115235258560729469561896066883634/890908963107551097360893721266458218561090123436286958150921497773813154202892004730138629679006903906394814849585337701960044755609022344731215,-85983816700180639763580172343395592548570591972771201013966783539600914589007225747567470433532420046459274962524639354584844551710069422430/175740317739492267605582399619146728491033756693546223723214777534111360008177026941134479538336766032467102928350296140103508704822541631497,-7658216766042689871240795631037646676822583412215326885310411715398730325159985849497407729300050362180690208524967645303413046337431539724/36603928800707071859593256563159646119551238099832341525583965235776561835805421692796087620568282298347453759503788966825748249800882777859,-171054245292534676117948363200010818724958089736288232631031828451336732935715913456255056970404354605451187155966183227692228976968826153676/986644120013702426932973889026135307847353113962951983312430034997498293625796390548292192706071397918011358715641676375535131880268039374973,-1221605005225467278328769889793021684889818018081126496070120547169342718565715260875831346405287801221311109276745263475463489059502442650079/2680837822147136020128085998349046637566136454547988076879493660402610963072486889339379359203362154174120699632817319013038564985974769878051,-11989570955773021963028163519636450918283191753745029450324303711329230804880426376906840404200179159144027359593004553140028926354327679383/22558174890244467877730715969778817045212922539714457235153177733102331615755711204664789582705466287910128697592762716095940264885385883087,3084863872740302001953182157554787424097498453103394973417564857448563217577211027604182771896614607064248625475183180372057219014860910322753/4064327142153337419077475402642140272753600082735754094421847393336989746713190377060681612019191694051304527273171995447895871260948308921392,6729984919877183263553737282699689059810600234070654134047114949607524686366004415448539653753841266088313162759058678303239417113961104616749/6183695795522493158583795783189779657107801486785983068794500808819050199451437899188147143108238915872979954883071694911735693943101405018256,24569095250647224571130473488515182655974613602555114591142995220729451852466036274297706677338124033307780853600441261955134632939083044507722/22080775590811613345055717682344364414270968911053168733206053130898188342621533914329339071567488617551571452909316296682250674249964618036269,859701191377534388960707885353022078348967323772657684002382758222117670281004066085566366873929266721460296186186453920327615668256861952042/856956311661842414214984371679795572983291960053309486679910592205059885190895205743744833180068008894208644342016987705075512872509971340049,384433371391951704286387433203287859060184779481667791361185060105584664779678018552798885751434511586926837836406618809048946453259113040125/151440617072346131855432727397362350985982021926148622221963241608344144887873474082506316531973715234242128568062127498461984603551331348044,891757003001609054620881135260832219796421305433275840552326469142653311742289923786331675094757120789568965262469187616603829832640402592122/821194387156718364254710955373008370210859108608810789135872751492065159610720988428722298327044054710224680679423933829253690936616608495009,4297785257324993022507544995718670052176250811808537353721541426401993606730667338970777749912765132789918846867243904672257676429377288844281/1770410957543354011685703962303707846360240448753041666763893080098382525508816738823371197090321210318776846012670443009750238022606058012992,134067114417737234293008487035676757021495788679311928356763836361911367048412409757767198684010930876857277294022133759484308456613756933143/120373763040034179527192695579859714530099905107171441859660528307638446439319745773354256084573317877665334172681068911152989871352544651078,5794690013577956905967345914454145676510409782253189962981558822632770740937642754236043703838061012747494424203694788252188675750125304527995/5296598713268794258691755614888629538927207108769930022969102917237345190052881825987443904814143601730133622818923488779067682620454787602544,2129359063565304987062273187557719294118638917844674466474523916773955719718481730731153001275968846787247005215706835967116480422316358352498/2221074140294528512652234975198180694461969418726869107871308637370753273166442778933604932361241811321533661271825020261279695903741390872725,28562817300801902530969775674751333591313959232305748383286323584591732382548865644154347108293863591904515459375156253122765881598223633743/22227554100841449569504380120816846905364523831334000587202161967182273889105769140100234372159971312820850468927881258404648719249112286300,-1702683540820647427082523805620136763288095748680144195668526548022301455434101744320793508016403974871070450962657019290872895305032973790075/1291821131747128530774106263306716073822663773568687311358030299663982149355570053597148568109587700936605608577139132222545930119715171153462,-101901461796067638096949692441336943558869493107667982886779175624385379215106123360305697732340355567333228171601579718213962204714103710882225/58701065400958330542949132010961242840656998032206349771204796766206409655845774874147478863373357491568561999330984119290613920303729056004168,-152561408984561982903410958361428211731970863492353530679220058403385302928147234837583542222521249855802407288982551553843826269206061261110851/127534878605471327079305545370126622167325597031091421287677668546400224485768028576355991774465471809642130531292607928044976908860996154111804,-763556411077896913316491955223653900470424928705546314283683994469806580661417290793710636117324936949786128457142935002641747684349217887184/604232305120085305038687070073123286002601350334045522131235634778025504968324719684577738939638850701867569652584149092142042960870850553501,-87833123591716697391071096055742397710969748571709127070190111640020043310925053796324002805651007068247192859572259742565572941824481552666048/64825574826724550586298040899720659366198505083466593343221132842165946843602113286269295719589081740720920530814260525440517316265952526136837,-146353994608998998203420965672169918585917261331175162395269681891982742603208040897235471102197745917601541332056703098524977067683029765843043/158360809487111552145779545403827450578289713410333358412538100754957285708530093529092036010274776673697599962756714013867731604416369452913072,-78168598298304336803433803994437652930261911634116001778404146776012751936892806734744595291884230657411143039392910949567266760346722852992783/59463312985281115018669222344613359691763319319608570416462151902300384692889922351617514651936122042744991873891393531428104009450667689695248,-4158831563916530381869392254337304861405392448026802047263567627641564095164005510365547866980202616905310343337767614922042039408425665018801/3762024606223050732991555692794788865759323142213227926263505547493634819109064776205120265436352559697148094608960030231703835236626604218384,-647924613191264144259770900452819004815430132671021723307001700114503761763587698246545981291851772037721283449119686168302500083216767398227/510696581870049491121555742668799127862518088523030754508579877342919659086458359651283482752442124107061609466427314307450448890563125898403,-3012120814483753404771438945158116328610634666237131548618980709106653588559717858803223501770604010065814505993018796187807710834113071812503/1222162406855270177902364442458864157693115032976383587605884522627274622460104040287984671410608595809279235170688887345258712533205083013654,-41417704395708144716502746259222797830110333790911188237973553509876888273913993072961008070099633570933363982208565928606023793751510125410501/43007526949145706945971265708969878031411684794070455497267769858989418812307857508925178019170500018929711101294475650848768976763458906039456,-365300204604959370591381364815843279722677664107861624406105259155324975388029865322359084215953360559267500722404880597767484666552867601/418758405216571032250503600784781880371243558436074246009701719575032592444505887436847585155694576881494207515739844529387302356925385714,-72805048427604830900928689130689887596319031830367386120367457383951441496397979872646740654006172781233510103606034549019861789433586085479/79817517754689206047168870508633264361634646754159466337455362937644275542754769838435958671608445042508662586838033010644429083427556996225,-10856124539754454280673507591176085160893768832551415744024480354501527278434203044845452596401112497663646711364204279562857031602660972060919/12875851248941146385616047915416037448470997094844790419082166303472255847336214197523935409925459662328063432837441436171054035869234929530592,-829868840120796470709453272654270846211538250080960514596649376737770917652096836982423059845902989841452470994315556138729894941744964464369/920364484037584622720614588371154880834372270650736557896620987228710510395137808036017537864508254941243128068637727425451899837198418808776,3027278296670539663249994267724581683337093981271603355305633602888734728702829691910435981453882668984555502370583851498231897796524399160693/94710103363262574145582534923622886201924899985656191718368385825892996589426146401424413968460065381599965241412739189617847549768186182067424,1653328148428551168978984660442091128947623987969407763144344395541055441256166381047097893685836042952396056671741534589353154947313222108/48936321462127438554462050050205771929589235848521362968376748178423778414679866086110569933592951787142088158294722930712516194804427580829,37006734987043534465793118215581709720517345889305632033928020143947600600802708178964630285818341479928493050981476080016642566522296012289/30054189777091022167276945892061149747373828120483866682475247229206533980875779262481374655459793432100756454364890815800212265559181555060,126315780668052950548557051827222442901881486347508610153126227893341894102997685341468581139247518670010855001313272365192675341220248087517/3081959152600306587444179969572118455601686931403636307860715039708493149731811396131503785831842376063821977559371368906123424637009275636704,22735944961136233583222243168649331790142709236060871475532257025431902397531881937859577484655668192934702348266305856064143059731500580172/18505479697604304072335903685154765712544006682479086846706755274538432975339269720771262398698449729572509097473127805227342644587130896853,-1980582216883294943629457514666266073501845812680964657322866066840376085723965831122545901158546997532725057394782293858504482024513692426133/2254758836283021351413107905247476616362098985277836840248458636245646002062473540022667348248226866859222766754953539461180854066353337241952,-1005185545793363570333421044462531737036039500212124650253250522428120422050829650696131038317266846902530153366799521922941351063257506894663/1665949988915718293928876041049969535150000693037934218096222540817103864290884704555950694444263912352947410090159060544423990982092256955232,81396781121541472116476756692120776973048743295418029603949798059740578976723601569698411503965341542280359754017428286803972813926615465550/90398571049233263259687520277349730750863841305825603578074682578225667665361237966673495604712949777411244573060426042472703479644926959539,-732247721923388454409419515417861879698380213538263513046063221789258848095170740850180392041787447609702705831711776840069986430661425142913226/2880528656608147548228748514066707948325733921319778424095240564359189641103375843288323268355245263996764814949652978360595629550341171938572683,58163724711791148725466922152838811602436426247277911182206747679565820053194834118281560619744080562490421097592873055219832907683238115630702/85835734060048474094073173848295633470434770226838871809538040573406096019162891577388204750523386646257789939278260074211662676681456925205923,426972222940368699616821232399386793097831848108872314435325260785036822016980689762903985565485857652016156378396341648921409851092727776209/1851619226065174470810154373153437513926783584441753691667307703742023263499845523181655005260175513471394070879593203221019756148056861033326,-649284903140997740011172391423589124296953704947137062812934813914915691587842619253908495308235671898918648623126065675300745736783016718668/1807162345735134583937729228009394208506582421337125957834583455754885058157556386244833237525937887144728874667634110585131277598388596458863,-20551149119147757121223424175138437651391244159230083186707513507466474709766350690409232132811020739480215923233638180463463075673154818743/869699567381284791540342125212851045119543873331625338630372255939421489946418324311146014586579979491284479999504876987419163919616621737013,389130841175328662191787968908143908233460607326423232581016689032652361938249015309921817180300498427299622641458244979448550158107932172035/1530433728699253317358348089511513560033505618807946948139674154508787277395309093793707905314872216222055406647283857712988404902994133295058,734372594054999838205725397519005613850167641913214574839397707257795907541120874885986273220280665638873071003388371461726692442075956579284/1140150891515772208641161446194497610801068980910686317466048106744359239037575966503970265974250030668116116928251132369021311517889406628633,-14888045729538323461713453976185230318475788126824317218140365510945241723436207315832200488962821288967564044112099304132783816666628354829994/133622875536387995782041836354882744639880216273386090423227434503737821294093447610043972142265620571663200985024825671886231807042574654890061,-16847718924265870461711270577192245143956538332074075852271107548834308005322710532832961107525981173045425756662852867913434387550591543063391/29440082186335968398414041421508578579922043631168953170405315718167828470722943581533403661167177518803235844953514833445401898581487239392075,-30228126977634335171826869867086330877977166196084759557473717516514869049776038101045748577292761610315319827509871800220663448721531396211/76876336754742429866236364956918915996566783716588025991311462270473156348193166956124050111214743884499652519044104326615320231819491529750,-2371240342685188626606605568612910792130246703315018971225423556654171468170587051454907794857000858997812972389198241302130385230348392021119/3868500325757434566807274639364240731694051090829644327335100434049301638065398029242153654943405867411420989112529639314014953054865173297949,16605434608416240288281896721552999570451458493265130692475748323137073807278164475108121227321539176346111368396654201098782337774914526946974/14369004095699409400887728440541571148678030879291778694909232231747872380325359838083704201291204835901501720032550854849307996444988348976691,10845425286090271850497248497254760772842838331495270526593693738615533096073972035997441290763847135391128077320975962860511789528453297341256/4538276055309907237342937345233738260243452322862507644361771658065230546450219050825476553565552162146360157844131728643134647527757625432827,17750649390584892649046197338686880303364317728634125683948304396342932338070794392625446559716294076356717602339523538455720572860369404589257/16714740398262196655297046033833480607845064983755596808344093781458352639584885991533068355324805206644386845823686851733549831270558454800147,27149154742007020786130429027717337224589781864469072054323060756495035797977608877979782628996032195540623929701427341540606515359172260220178/22976552107695084705419414861883662193160961777681930075138056585775075548500889421508787710989315906766021080177917945211306985478802192267589,111715246214574981566238105168292389450329368655724527071305651500862207909763883155531775744645622405171320726624819371170847372857730419386/48967940139390996582739684976728487773992805275638836423518645188202444284389903359274554604556786307862133620946991498048717535587430727869,119761852005218337719581072582128429259087121213022899535631146709682349741879659894216540173559646257408227495541054906842563514584794993857/99821762932558894494289573157562724037769001510715122722952937938000171017572851681572673636512898975508112505267624398413748551835813778173,-10689339276397205870631511837853462815916091250425924819918243191154487641820235016805458182719573340683449796417616715754230911763964852937/76629834079994116035937527073625893997109855305501517968146044662696211002606859516250189192717990938701345909529288016187323172068123097248,-67086927068533000969061926603469075410211689752849348933222197207505419730584478586568209493307568553424831717617809635852213942895522290629/429182609927081031778156964527260342148483879857477178649572772627301446511531139121644172336779452067289348940371752596398060901512564749370,-463209409075933588470759657587925940079823095858454334300329694571762987328072216723226312862309675030230408026646956471931609786853428550246/2349496712421256250243747018928573058478881126438043976825596781004744904364133617777748820783162543019529015373631892597640741815055657249003,-14637708761676044637827796623802760735850935992633937612478380067864844125114047703693722662237952864243685099019144841918338631818502005560/102329631058324946597622619705544144830891802963652652140193488917826773142677814305480696015183805684437068995428435940267306062086427138611,-161739812584232956908259640048965536400142272760825449568129384430323268523737962713110958830353545643607482125215436872599428877372900857237/1165247470755069489991565861607407007590225931901761949272451693665678880949658174146585728845524526790627904744148168716904391687891954345220,-376993056916868713783811464793350922029396941918903634493523025304333183615070732653093416743761398276880396350859462818408595010106660076528/2466961611034066745266147143517135501911888647810090997871588835960210625036318113031632985771364227555047986307346271412265945675972353236769,-2545003870801666786037564799983802919731542243131463624127133298086869173378565147566468084363821376122985943394241407563506424761780098299701/3896715132260390820033851045058618529306491379388921359370110867196994045194670723874397559540990340611816155146103329710552221103023992383293,-31539451262274553518227594756586305456379451924889755916432969231516493812702196403012150615787562569542477284917293521728468600546578291337/48201417154094650182104219704765446760825648356893719523192737243382478045588303554921086604914233609701649678485988537801700030098093486131,-4755822670737533352126657168835107321361292632727781932273600414810265305896282553985907513337724152165592472712530911724985912437999374545/7220381974977673417121662681336563475988687847579080954383728094037553454969152660737349496128750301796350719379274543647908630640792809741,626415128446518047593060657181481915746592052032909693277856096907454233643381199301086685692539401518107514938815481477999299683068190373011/623383180151765448920010989642821353599030292539101290359380942129276389733524947494820542576594887215317425338823786615489021430244722115344,384067700342406721032921614246830048828742232324185630865586000230931726394694751845455914445246995661620042192950868128239512658898201659827/533188948097554599004183033975499257263750334362538838141165186747467421877798745653699033937544107393766051541266225303578628902353744262448,-402074410060176421134010994346888640731507064195676185848170214388123074446164369098132290780575392588556532985325531908168405987240771215419/1705946336972028903689751366038583508530679348164961877265663012076651203130822236926873211052923249333883013639641044193791898910117697133757,5129395144279668971094276650755142891005572691475843498767295330435845937571928074582240136643341548714920488174923380441707613383992280625/22994790991924765756281166026404854653467048592760625266229966361195357016419273514965138288429930252740649795519813766117183325585651029568,328839510699458090813986598540864314380181944184409815517635464988161963962886672880926936141512437026747055460353812852144487793152367668339/603201835051233358870151669956009453297257370963305526653339257362140042818007204451397535397424671115826084158248048450925691277413012893488,71173180222865666785010964419387776261856823128609679507406554156244607274041055713671997328213961069227374284106700054829534880353100265489/116397711335903227133005437892096703031195755571072331290504105646846764343760419170277102757933953221683426728354416781913670926812433126572,4976940384609502510828210108127626789716775682165081289682544757464154801615418377780269555960594207986624277509982769597691988772541135153/5747163091933382522676923360254008765667027348605384709426891547839091201486270577503880106496156297203513204607867714848292683338780846489,-607582849185476148759824394275012916100073355732534657115155430043243722110691017222760376123317578161081977259452297952669600501526907990651/1624925779093271816348831771689171176205260870898020825281100696675274163317385221818886365360213157466199225168475829527963958511116248999736,-3302783532331310336806572419616845984312068943956491577315391241449682185174530522065055872578321636940927474116101576268633628168858112873/5840588034566262153644868807116046556227428990350165022011844387558412276464150226983834995253880336899337255053892253845003585445828890649,1413911315616041478362970318079256385430484462565726202260683741278798359641547524120020598397287745480371285684609590346562745102452427012277/1343108591905015982359090537961247044221227423496991974809610386819521173021847443213112219016930891233294487058278975768367173383912946402898,288475042909372741593436622766066671710555564950925383738931634571749220509421664311190625435011352252413155247050807823522771505133139095613/212738696507767379166149452650744596547625516086697807127306970980046613695075290681578270784680829615366702690416992505339039008864064724115,200917852499079364063087682022636029186295226323899844698619191369886913948822755538311927322496947161426421919432775766406250218409716240111/164570375940493239499358965605467458406305911215869829828025804709857968769992711598432304387195037429238330561447574538209935925605400562178,440175181752340274753192466780135372283813582076781479660459432895332067454419636522215851219405786706270743713537327508997543296760438235698/362497363577434167952179410274769245411855635646930299538513729451279988478639088393166867473477007773096932802467363366649694719525794881847,217204126694161858970967455186019111594144785923941775613988218136837116583464247837748534673696750730022767936563350591283920268303405061397/193223445697792077745627822862775197127255201067169025165274515632445248597984894012661124104859267932396162428086753833222660178393110536958,-94816261551625348136538657407668484877134839252426177161387512566619171498509148425359574038614462303064845166121518627608761675815628674842647/261871823336350883625915428027252842528048727258657249354776606436826510824993283914257139861627294055507596640273089694263410646537204314837184,-3200137293215317877510199569994223933623367988305181704582426709255008801796280866930721762091110847223458452384602114920535425704006248564129/6096422758558762897629403361026830552214912475754341290824437198907084633267315630449113431803781910995475488404612971536960568056360125630016,-48590862325367378774669207842502718461101505109595812045582021386365446307843375821718405389066250992795840345237195801901002937364051517548677/87386002624651117451351286121817595145477087435575202892943459018591321974572261573798520682195332915247184388863984580243264336763313785737216,13191716312386113824909834317060821617176175459162323155874046987398179686563791520183996592704632323670401203805076741829383591297006286777/59188973491560079205922290288023949383534823205950834314650809062651002902779473937322118453038916760070255262145568208702834739896543090830,-24724830718742261412893487142276722485065367415588782742127673109844691711443009725510110658764137047871922104989049654479871567951531860353/1202307073344771285383412679019747219877023534456225905741341149370111674291905885508045134407888822408839135307354155237939220562966684392295,-232927552265182976645286070711765542814167937702233553027271677985584339014308835645537682214712318735428059067248628675888762512849479288711/9986108660427644230062370665401864659244647998530748270107344602160932417416889377491643101888911829106000443889984160676414632359460957517054,201644171813324284575346719108473816195352482327226713304163800808044655451184753873294966026083549400004054278802193782545976942269817432199/931646535338978043138618413187361580478498734689572139003765636236259864336633511324930186068771857409509860319952939309292900461453096914090,-8424243607375521412880519011714042885804647217423160155179322918989141040314126987788181899242281060100408044074883224061477893832481177534357/15255008750371185998476252706842537679894394270017719878901426781206868991011043345960251250722374791562405420242472992398519756644671132588122,6365787997411355382437634621722236919865002555540136005220074874435547444231005079609857066381906689526469750012560434584420990009338676520971/1095191724233694739230019945737271327587975040083728162870081055597312636344137100169109033608373824014267789736665394813461943178339093399482,153532732770967468453902878184073134712452186922034325744974982995837382889885654593650556205831940963556811317804736767578895380128958462925/131368870890621262453679604377582790415244758766171977695720032005706806945070392229547441985406383817748427148743825551484531015510921468786,1101225237704833038158629315572001954736901561630376626230649410760022507678193884840337697203062085224090855272192828170013649058324578888545/957381323179394144317697383309467260456865119729058756865540198788131431467861061365179872703574448567656910161443133562613974954361275757117,35680885970739092537213320407152057534822320028914773017007817813373710713753034960735931142648584846348165557877686823592524118397386657629106/30279582936516255242070493628109761916395693364834192686223633745908217560979309125265717567093961319436596211430827743682845848911835609378381,33451747353753911257687845194857797123630411807431708806390092231421506611816052239932019714358478797852132134360614934404892318893609762716414/27922334594175441069034707790484285380082757846208905796354265118262771330088422938769741584520960709665585201147906931934644937812892568739519,1044281092848858450722555782960497625713555774383134844254751241281833316578079947305470359427816018558590122351275238080789720941741529081342/919284071999857331997863094814130082804689833764612031796305013033562293755888242699878587789393029647411104837506297696137635926330550224661,9147562500033269230519754474926423422040392364888589487983323731770833158108718039258737063280031109095323179123369946337029163680103110395079/8002799718975920304261131932060627581143071375489366873234821897107534398048511335916710434686957574278670004508027402695496975738796705959042,56238478501928808679070712979201233752338725716771125155626035371541372937689336586535210466353149217433970702224434011368134791831073233551/45734931303598238085790214613462980791104579968360924399233453164795252349128823693956598126255488269132227970588497334614096358287830791726,7279676540636564702469738037353600931238255359729160997278652828459019066532217925042076744682130116979130360439104498706823459760264791770684/6942508474921206477043257411803138161184899456417624116043412792825611397283318795540841276874152338461683030202600754341207393819439543368449,403538558337419382174630408575388281300960003034030956604376470942819938831417414911967732432938041000740887135978907257782585852793042991967/332758758809615238666511217182186205397853210248688408095945445260316033054125788542470081739691923355958636177574730245577821232908816940648,1105093694803277090650099677130605429238090365338816457637941373049106832438864764568711601522284650737850241086379521077827810669620454574229/730234969557996252691759255606037814601302927815171669465660058011528245128886319859869218023881287605237808701591283182443619405390224495056,37077316343877172563253112865435039069788080535236523711887979601918352107581955624755575689598583274793591698518384023319604540619118631615258/24398690109529406926872821412005087713692166999330955499320209162298129954042194693306015068763479406517578182259494509585264318612565412834841,8486435000323746417693798230768928189733168019257209297037432887418725752873205909515055447106190206302127356879971028499884107573066502776286/6467798509205739887567724870953350920998303975698329452470385876631512081507214176804455367652887738347954417464859252701922292978863110730147,9138053935258902320761614795961670304239431840920069269315999234247389553836939608209753834586169658678829992669862583596553680020910269905394/6962572026606739328025731317456142508821089462394293785345159210561189376078834945074420650898384908547563366855120017038458030090658445239937,40452918419244173242598616619782379906460943681667469091978227366940086607523992382612636405993309817809426633965240263993782805225751229575/17685042143688237187332340743679527730981755212439778405864028144167489927229367465973020755420072830308646624111930019064652170491548169518,39891182652142015012209553657185622061702345678337198481890997285570954635641059744469976227623546890043511543562572343069503034597123017353873/27747469960461463036972298954961225463985676287853526890955958474123143534902610308773074632440268124336659508835500166418832243440447936644528,961613510473372978811306212080559163119644446412781317146040243664168795163959652611572269242592715610951286117838143401446616985907443306259/418600587890432687195877617679673893948711254830292192858624719223962583255492935055611530513509550497753056948219024626757065468123061740868,285007008694693225759819734386455964397241532757636402021936925462581337672150076128462493812211657356208372097165645857318626705812743929007/65589695739738621720257442740457352389635397291541905441756939894382528872583797693555731957177022234971894143844443832836628935979943959200,3051066103292547628779175214380402423558854004597098889764544409486672524322386898834383858436479393463707897040269710391940403646692250908718/2455962565594654687668609223702078326225991411681447706308145544895475613137865179138236860851610097672460791013056004724606103952721425457319,1015894964914283552092633910465532396253350592879650539704319581176908315447459735478568451246292612184265016937929193823951955918708585269517/945615137657756900268170454233979644543768399501736616470145348562641866934752622522919294349814516960777532468388506940631633683450329174848,9862095917691223880559357372003578289719721608985896671540430125900954368110788800809883648986136756881568920852853904341888288077086498375/7779622069927558623168256720932931041169411871572863904484689419533179116814235378402437044447856527388678514405290861376986461723510734974,988528161431381290920790367376828703429720931861894261437331905430432672980986571818538811097779211588380949612113542116971277919273396096431/861214780637868475349799893232836273616007603780059492232635471371503581981345965539469945012967809568179538402782554318538635664355340679824,368296639781734788392079235961254074506972988008751898868789449795602600343476238977612930064241199137231967472099350685249314574935186708627/331249346575056100398313298440759378081917691412053298927179193015612981791201985053707534464398231345255475499002833443259579431052036396648,8092093738254648047970666429037556803772509271155034126208486375104756611923289693204662712970771295459698255728850171867811329407541997906599/6800897836336334926149845560689116626764996302678755597770679386950985877591244559495404255529688490049718461201072718328809018289435258264992,84136258971689670163491466506446654332626460055034907600015208146253780845970576408312981608267717699228071477959015837717035921781822149939/60506357763940618234970587462048721901708874852941913998878364864709602777506888435472442191747994624800076085676321136692451584740400838068,935421496335495406561156452065232492806960446279803228100551119249106978301933471228596607539012974239446535994108951366325431567539376240687/859007549479735954768950604277654241234639794364899676126854474520187459992620984775972619997121285339122245148699469754736184779603467541148,20611173467256405041049049772782647646098322621228071562646802489503096474612972822001998446303932888806751235278691625177759422122922011614/156112328249350537668528051635672571911599668010214475781178006311547108671778538722432186946929935123135950010397130012145593816556310961,1259002287810671836846817680284430466555394453260422632859581543642949794329994156565713912238831384603015382353410579528597179278580532224547/1050541086417713029838522724929658695520016538845649746920280658482159065217808911974648435600662780964302463035008555033234633608113148201616,738904244474475823573724539960798181414086416848734422182036171701649347375232390492654351250594894508099296358564249550199058215489112177437/616054619926364953521397682022046110747593131814704756654724040781804528082900197829300310300617229799943609513147710083683544021524813768236,634761297203569715135660716284398721687867222405209968337074296669054325886645623461814586352381651067497044123213378207968093786161006392939/530545522356928011460056511716634307241634742262617194479740329408509150887439265950927214734883220571956779714564789117677509673681431314062,5320229468655832934997414627306199019558864775798495272150292154651781753296259681479137250369620242964038883929791848645859002205605457412974/1756965227787141183824705325051834164022309080114279477961709618502618081251964230533445416297137707092236762212221338682843715542892518834583,1720983144051994491997530841902662205976325075886644697903106030168867172548129842930038688089598722683643083584706516424048741657355240597434/1069302920436447623431799524983497155309314010145787824677823293038056531074878955732760588080173840778348485384859878344870866821911024369735,123494749167278408340767361844082771930989267013960759496905820448196092069787357949377277617995516457642557382601390199798922255558242934951/16920067302928750141286522419072843469103119539287854486480036176738227016033227944625792411942961169570676897816292758769838751458002912292,12655175506920155474080786676420823717564240371025434950473985839244730349899308544231403057040117976437072955730556902546969715543511785850762/8743622163456398264172042395698378398653871269843591897593698278280655752923257885859361971864765418436854673691403807679858571972638068795973,12125026664324887763948466648793055701371385036461477030638882659514228350732186384325522564590060961634744114652499757047610229947886860182026/9615790748750231856912887364012117936033144300991052309928645442571687075050866716317893486886012620812770516765963985324083451088948663256763,21160853362839327604450992588021671075581380992737952226859990128368422269417430177025677409269179690070269932351402476398035343519826851640882/14747214503250273782014945940597104556875888795107066622602600809435029863413719197780171151056250366458856787875984022244049518203707742011921,2743688168469967101063112782782799293199994863760417055223050668925577901990043899037911403284471412726444019678804445160274900418577665578246/1746075159928631351640818459033829113480483105119701106822620607125030144188173620423923781960249689796545205476830969411766399971315569861931,7438734783174322974339783704860219909666089762943214923334058472325443820551260351489475694025164602802307685796529066291059695012303585350511/4767600593977000297157785403561926887060993682543339834129517808685711349537152734878958651857484771602076450036125846925778963717197710903714,1387581816997441011485184960312562429651916164223236297505399165565070382209341575774119756877898184765268122983131305334166228436868295679199/1156357928739607306958483109593700331920806044520386361066272691957891171658869209786592781779730963888654976547508718755956463380432455911985,220772015141765865542019461481629305959940648569602612721899733540021245196112108464181464303204459539276536522421224294803781394839069622050/186534069760229370045115842419949104768813005584380658263012654802470472606501629576114525584791480869091414193574272237262684288163286661941,448293752765976262272752690858502406861009706068953376040189436681381802207520272221638128384115543213028613896605226504556948288705984712323/168455189232555735957337500171097835792603445039026822701675420125170866641678980741686761054305006677958991533921216217706265899303214497283,196283409045397163345847067561200045612914515510575924233652207763964585621272415700428473026972655306658234124705329317315514454130676825778/119679162070159637746720361439954466484305952997789292139437957443200370679579540971167601435690580831573529871595202301628883785471123740463,4398076399506171752077858412011649425565206799089009257835522029083222864456560783701024558540120135491807509063600012933915293039706805238506/889225450274012651010750438844167499109186789473616192288885670908464708185956850930522011939598596509010473432585159439818597852666283217205,-18710793252983486565593307641507473899478003700120478187247334753670942579328496682567785459666941234708298295396048597671287534179550565629/35656779959204714598081701567615423513573270154248091276904805204078205831393054745590241543929775494343964784961877159783099663027609612026,-1007635138373523202115858773062986897848228127597561371724146553393978955904265079291279654329462658971163185661667591845447831881179699767602/1221255939053271040564457154556481465690148969880655031199052281233519431359314197112521080795428041303529495457041269243109636030979387426771,-733167862066914609032646766379041678087458815787488020863305729182125051580398519285485727523887558369039283140477825374511886238100729178499/904730506151578703482783536104855848323430911098123817073813006092308592341534333647513916852300658406967389392454618766373032109665849433427,-126830888747029238577423086091725206030030729037733700031037362129866378200880208707471981214492808464691183304467905403908776632648209067649/241765593289538724006502434934549408487337215639070460378180920375731784656851485236965831408024789993726613382622459608834112567336903942320,-151312695985087188035667603754681177817524280565363121858370388234374678079359392780456512054927465811759259921341627237425109314692878049801/287576960642740535556564247821901152851561738956377849880570299571734678682639314361288637214149760158464997254984033688299926082357100023504,-373576840643246149326374584572485577097141156232656451010422555600498528972969652416621333729595638922515977334060557271581045238364189986509/711436552614431441348038349767482363948349808588647083048858911738375157229004625812211242978395352608956073002189423304283545019659452055568,-84225045266431397709176165302901530819056942304002161070567465407996726077531839220733114029533923668054198742555535395535703409739029060014/155429742488138829361447485238466063497649875347503659441409730998303315615759487764079949229272728376083658696408322058052030113052669275485,-42768930385499487679863908018579278964707908368607624870826492532539005434360406068121203450169910953853227254287096748345364712475294107897/60352138358274801480464884611330687416896459497188285989866698721454323242187772028085451250061407371106046293828874604752612674236782568197,-1729967223040668067440767252251436025076733238212990370706744843137594312325074893007253992610715008432280032668452170931498933414901058530798/5030523479691894692579060442429371957364752907516747873427061280622924012222101172357136317841122545580619779648648030237986767069160180262345,-601920675984896685789519413904691115466338525309292265991772975393572425095859636323310949090377856338404007187136325512162992110903708994962/1497530262777783450439711057552827849752140835487540927423885832417589250908639310043548471890805139383142051174551776482759463337347216511387,-1121769992778435129710123273177974608842069339614180661833321370319914285137567280862666839021295095716724328543329680866716573051852011591022/726339087513611796769778216925603118053987100821549714904371259865181558779690395624636124377706510878564371050684197663690857008287219473265,-198513258466761369532156326068467083705213115666727310611385573217218796162975169154755592762870637355981889662734379755985355866302075096118/153576575322186563502725729681662002511351652720598636287590402450693297882486335523546150274429040968603563290475023063403352455308100421925,-183667136143543741568787757634475790729200378643176087863931903040743478402471750318147445629018589854243633718384141778192629492536732018502/91186375666101471584660327926898005674195649416014088835141379479036251074213421664845988979473851833052547567363027657722367121877448668567,-129541933110887883344361349459836417826427817107818684389869488975759530023417946824389931333689385575951588683941828124793095226630053529551/215355559893823303308722174674343256839477074039891103799553112769166238574124284546167484533993222889816821953659707057499289107846434699576,406086188720515630993408462118464582712677622403930561142640165516931061162531641346696468542333613215697964076631579213069069162783843906407/267515761595234365769338649159132202821131311283880141845807337763184821925029386715517717880427139103204341067780397423536607520875828002936,-109360065160187886653343836269379292817777362396989989247181338568840439165455666416716549133409557082272940402513540939054734277140618023978/40842656803104277473988946696825273648364866002947078883524718917804925594828558572374876685553144941590038879286268849965298913590047815989,307807202201946677248197946019085443400603352453242217629950417270769616677263149684213365405316487793742111536365790338890467478072563502781/8423726784076957153868983490477208684828483155644072458455849523747453766519788621190477428728750541959767824916796653409820006503744366021792,-7990618184593808108533902082016514406828595913474310915942147087924922750189259552198003046038193562898055922075047420539257070884399438507897/69150573886117299416414156548966322917258267933976108855603172146376814342908856973810884252745585743144934516031138348480330960828250743354848,709220156985312209370320083055980889308321513831516503226271407759919916025346767648633771875245360499493100514362414167437063220530601206741/20066432092837005411070304652454924791673560226827477026470021155977539797936298383059227404494387156875698972367115508744559692940619688738128,96744714847047340624258544541835561592191885664094498785305205803039436199499076948184711194364210361262421783515353358662379088677429326023/2392776217405814392712290433387847306541381903591170861801478583345679025082792032264452191983316128924499835357850766208335181292007936640436,701223885032459665827930670931626808325592471310643956702172408892481508390747448095061246184664753316824763019599695728485726292199056315707/16828047130277579934789524464039815187209489519496254672821599258620519341506004312821347711966849567037999029347517469937073866102415476616544,89821302764609476150511375490944126392249046607343086139631227656311847237718912545681690319021891642786121854850601297415225262382454173/511758171873420763939365854688546691513703961963251857763211961071766432858475934841255138538457719347823778843595141957367138573484694228,-5436108182015105015693171230879648482268692551466446161331083748399495987079627071156769732265635078437516081095093808371658794407102441417133/18697426592708923198824637440914048542886053265569753886512514444995497342632651329079647991324175462754644026058471052123103622342681185583454,-12350837499765557887954479323271668390891101877457280673441229582362671453314117690524208931155839643889574557608760285766294124269318774581645/33607447185802906225094560695676122214683481916832302203270814285770398797181529951580852100201287650842243330452299045826435016966150724622264,-829307049700948719892291832152898187597959741190763770837887066449656252700473016557963997367384186440180195756071850328165405219844822460147/2594579787533467466638969607936789681080397452629690411972069399450511790570803960465172795939592398796569918452836902299257048776189271695512,-8766730539178099662965446919141912299576297233900270413981753009206759480346180190490726998002062276308428675593025406466326989379867891994385/10262385899209815849472469504545807713261117828186841238685226292670966244477123903155639336886190375706230715261226505396366495205500082283648,-349498072213464408092687687636829055748268134669080681688398525325131324342216477498620277536352534817889134776695306358165789076798169142854/2200905699514422053600286121950427475099840294712810327307538531752541921686746392632255841271613973655696864621530494914628565589233410534399,-2275677095976295711328848587815488585761904378863992637630190136045718779954803820335686635459217860431629604002425763050629131951711851832722/7681107700341303466104462062403866166486886609599180052091542813635561718976130408651939630501532607136849332052735253192936825167134413859661,-191508954718398971388409463079875482812291333387685769478872371560148386607420970335010285993430928931758467989283297381955288006017793782003649/549183412560004179198604925645958364513507964635379340881763827104357462890708749089333687933168582708036169358528926711376027154112946570142912,-15094196354257521591237775371250373195042405965667315036595348672241488449639984001747563124082407568159328050546320198805353695284702447200719/44315979439201074850824986649976888353698113538405490514667577508793697438403307344981936729572903032451206927523853857603538830143312379834184,-1790398703911918926997125193004543911833474937181577783013762185765135048334438122726470467877650629274189792600873856976448699524279020575969/6656512935983618925939999612999385812601743127216869078042322339814780941724992480833958318457130509534771780110095954425113670011223130980468,-5902086948891011990119638872336484945313655337770397350600676566957750547014078079171593834502016623067155150752072343273699539517868103107573/37224212565790836513625764834692314736682875625788598419123057111363974152211734801264192499537955303723527762018446259523864337669868550163008,-143711842926998079339306965549515993105256655434307011695863932780439379704728282909987082697264062547554945328423884908791463115826768537901/3283697829986830606657917194545009747742240536205845035825032930899728918950094966673934882568823190762646199742386711308602861578162743761001,-301791516196062130059078051081031336186357554896591819505226929711044367560710049030092189356286010671655522342905164195189701134858108971229/3269235291145471508720969532304629092245400451303834657255859679555270392641741004896570881267850313241531674739571974313353967281933077848152,-122104508227949346898872183302973051284268099996897005340087592231757208960096971073844921454917045141850796305554670974467936435222357053659/2041188582140320712990236839887911407752271371998464975868365482636934285674830892516142695414435145415199831158809307146207986734585462466346,-991244399998329598718876388066637585194239426785073925094248867786491663308309766965837346617484780034481884982356764230934928816997909813723/22436572740268448829781987934239023597022718406844941765493885591002022305269217193577301141700789128613067428816206246176042703976745080164103,-4602060957530342843889931499962054738241377466038567053035147244957452837321672072131075611269633616485256506496384213618746327633019528234094/16938116538754861582398944827906266697154520306695373848094278785563941648874896089411477601275615729649582471293763134765456451427541417910107,-1093623002272587027021611737949346967148116072621433516355940928678658593241190225958712801574588379966127380652755167152656297976447300235654/6965344267989757738907506426238166702253707814335410446736814815278803384520425784180787112236458451935207328527247044706820860777137260572935,-146502084213068709147479981069125163397717091700868244716712519297625305989387578470822903731146783926834859648654254160837041160799094772067/468156196532744894964823183156249895370473767193080135976967032344984700285672825155871856163715114251814784112090889872289470300444342832,-5239141015060526428316919456944531400939418853504264041673496603398539088383368242104988468562773261929236144517953777577441599303619777852591/1473692105387686787763688306181107542255974505903819283294840468820178340154856994230699382546092121139998873257985786158676911942729635624683,2167052556057349367170706356899699180016828883830943343156274422022191128921863955440729532741881013104209207862193918130445645461676005014853/4974719255883026409652319130931051065975618549272152322387837987684702345079220356160931908087487264909442843278045637381714180684035662673899,805004390297847109175471631712189861489975426853695078163237319878851649069243213287947668219218041026865652111312303007733620473846069114178/59840755106392918717580508283558796216610843652105898255773237835157508143498295933014387716119613759438191578188892061878976939863496518173,796837442820789445168747756933052225427576980703233420097638053650841682055449626843977729721293388786825166303875300023550720705940246701065/3740975104855926457310393976497560110412931800823950246905520406073080319633747035960517319904170528967526162362516088979157767963603557204368,2417901496381448146075740404337504963194432611900916215338798190916087183052266524776469548920571057625147248286424449764748925276203910138287/140064930908143892068463333184823511397311114409367247560818081148931870052597196019934826130528106399926980400815323666500496055950710854468,402421347314185643888726264153125856288313565839446874728262430823789403302083068893324276397384065047328219018978908195290974633459870779/30849146400180499302596280868537970724473935355984057277942256159088633772180390514436101094636061072857509174057016281544306819082325303,2318700558856024137668283555776497480862130754548270601661435382244377900793285118707464027027658327809300275898267571931176267754597622586175/139341689502505502941843917218853536193397600553486211488986019623270682006484158018331999988129937827549410797991853681066382196624066883376,799176622789369700495654632019164150766818714190491048620793364098110499334147455619467818167082013437909998053753526724977262198305821792468/460427182706669670627278301397181447024696461215577506125085492172773847683649857447971475129041863857583909356274290323913340275842705939271,126953558272527554684494244352871294069264393847159937544006754428596666866057110797291618630402078862562490053256699548024070724509111610365/41435705864573742714467684685017487423825369657163597136367904280291704492002901813440922435608474895631437439180550994715584879192503739279,183420308458799966202466491107045016419976027624139942923906376474810363709274235345064734193456912437859415968146987201446618188962150060105/71779853470281714675972479767444272914589118717237641174873394251916282207100239746164291715476084725173145346844884415033722833938671219328,44734862243639402900337160870030398699549377569958032821149146951978371045138084763245031721426162624899010213275754431813431036294706679785/29934040964253165068242592758741324130978968783421534822198142091616471509593694222603889204866216661022950882031500965536106363350705582633,-5951014239787430423803516270185473530953543819767163678204962375794846738711778358592968448518084102476917699674725522809228880987955006559/7170617685949925577970171728629740661668152375871624316339729342866373862800469796954892023313349824741372569096280042408518794548558674068,-137068059577388862763237067516228732180562649582364800495232037152991770784442395762872371083021820570119850521698956293201832764223840997/21174651874402974513995601919049850993665260165652926433366953563596313724794720985591626860729266260537771900199847861813819553715880238,-20696880210965594523363822287522010291446596221865013554572854552396285657078943474452516084080614205590405630772081266635591725008169518438/9831709857877074696702003247632110806708072857452094438010151690566202159377580386576784189659451607200893061954891776324855368769331556625,-1185728517466378375838193273495457217243747880100609928306927126737012745554017861011755762539099926025639835590234717380549225006134016463/481527902772603362121560309257866935269717839265851520813376073775113972524535439091368687348422496714019176328628779111194170787748998532,-8576507440146674287487905471864913145506527733897968109943648590706083135238804803550296152828397665678288086501853708301970571655557419855/6088680153991667963351553641090912776291747133417008153451981563911138374499668033203684228810575108589707373313275866563146225510779931066,-5144026962552687883866627160828791564337802826227392853912997074455817846338691289428317374116299821302389732379878566192360542547782018485/787255048966315939240084144157936049673768409134565878090804414564282419863614549450921709588568092403624413583941185745298318653375844286,142931331302323024844831713313156876197296547807727617006683688989361905146650313073911566948985497396719176147098620260740631912917233876197/69774245542089295242972239386257620702125972857926220561148905692033992139094759043825171709834084514547833814803742233568443296792901113964,-279928521494691016771277114493133528507957410797139855295458719743624702724872404346610745527764382161348466896574723748413772555960417118198/110870522721119374099763724823395171902645446437756251478388418719981542638526642025486090600468488293863655346462342227486174577359704871337,-23858575193734706860512056523248963806689456669221927846658617640060433785208810730434126585859553718454704517226385756811401852433233966520/10910293879581304045060704562304797398444815894977829018989549994765719271385844479274323210484386380584227895688636537012538191722269406103,-7396605451408193654178045524861071575178975573971370272097905823816929693608651361822599674030828027487828838880051031861636416085670156681254/7367329828243302568655483477622484190504375340585665143713354290016714305566149429019652092171338949281606236141695211825240876538793039398027,-657591997551083093564012979720967825987258682043634126755751219500009665755548355737663784581462936326852154384520646874475337395221296421608577/653621351162680775105268913638548303903333366824007182851684893335302025529653809967190327176988105209686358701062933341636746218974261106488496,-29566246894631730892433705202932992736756135352026610793727238502192694201324980854278210009170990723435040811149451956570492063008874074019279/28480289502870990584697421550864230284104649350399509521079434702489519171635689633100546076298649686299912956653744200147871198309255698987504,-241753300980667417899250180956705337324580960167307908517642956000488219354339099300439861684819012711559440137168171097272422302186084094632232/169940321842266570859990221953265694860042317322607767320355545656510117643941573771748412169599701011424159090065799159857074349122874264087653,-679845905793194196923549913402714442050509151679697675480915864089116011327446178300697569559431649469650274962568485600463519140174779182275721/457018075697439683635966400165461959670612411429284146976111028061861486308698450354014566405104466348412652573702712091445679434043154126706294,-344123618793239823630748324384300416509718138939767711893243054632914416291243836851020462058007132443640531590816709195496671213296474804569472/235909206088905284652279165343159369079234150222284563298282992772508475541797012845614896876075333244849084379418423375604081261322765711105909,-4466496552454099790779093250511701405842232241887869766185347597820259542878795011575451669858388301666144382133334160439165994585018536731504/2870569644632863123896468329050121589688586622184058430091682691546481738779199987119459101937283562063146787925160404424538650924078817841559,-412171859454341261118452448117098437305730819065493000210980649946229355281147267299343453139584760483258556678650008603805153782657920812249/404802695377259696489739348115798205522785541722565512539098473364153778755308257137274498219146383473374791314538192451364875689934837446444,-356293279010672640190930464527576384977229699603594174635384903589482126963850886683545982883993421962192395392989076524773287950104666414081/360020245689094884257404352493056684052057856113246753416634332343612710274738748636948257833655185160122991916721606260331792710942833034958,-2698733717338587618871685375667685606815526235911749280742036659604023723803460062126997659595368569099254685063079328275104167582842937860677/2763120524441052014350889981511314436789660873686360814854283573851593030634815127357071431313888739399340700816795770627624105652846331812761,-143750494330889351894996771371481004942821787571544348593556614853451180842930232482698135795786697580641331163651026851296166384676699615617/147875347035696942136502256149883498346326869365354488060999106440037683570656371516933669170313980946111588666420765991773272390431583647987,-41949293981586622511283013924330229961769321629395918977538184487104046927608694503541656290197081759038254797655888919821433730763282279287/43151894777281704239563133501702761806662641680029339371826098272358145878527534175764429363513801205546609365984443507735282669935975034839,-44166914356886647982863376924380481235304890751942135308116786991269726345718940977225101079223520267102680770419050646647336182318533795597413/45083422164603859049699840207520493544017860821708051706421113194700484746405123322738017299794424474216355944990831830390738152187916353271344,-1126934526733557899894364447888715745375344924808280442051684804755334925852159394681941079588011446375569445440184553498769405844914188935357/1154677494238050597385478601588190319217956513301028104494553795070742540380707468026203206759283832479799740503044603155916984871382667329744,-909398359504336369905304136095489932729501050829662842826572198644388908016849608853296949768465067488307981256912530997994222719882308163664/560656828806118911449780238544305145134621169255766175353554807619647744633070819925243741428362973833844507475866534498838272621516309766441,-12553625352861381646239014380058657695039229381522474385498563052424516782988589513659649850662433328737874752686071253819641837777490809707836/7915769771917219752941471062128716543437528847858597010090180482905017833203004612964012155643527207991363944598276591743535210663347558392873,-696137394103507030200362415813655028099408361899328332489068164538845009370506705911155280905578756016133374574075540084967412354370131570402/241511239099209785601075636328456075887586509874489931193350368137692696574321640851805179077371976036115200362282234532863842097528061439581,-805149457175612930314744437231263558503335423101882315023123907951358877229825867529981598902870769860457617712737359479819476458262469599408/409075726972193773781960417516263495618273433801784899094785660123013577833745794276511751851090488076903313257160982234247538993296970094029,-8744093942288197973619713069086006689831552748361855577883552857658344852540095664437429442152216108831123626654933246014645424007313498538321/3361325794058859981521243761364077769652700514779574136788992306956763685376066408673243092881419954818035775153220612122787127751220705032568,-602355575866596421419344030351777053881806865466666381207212470487193791561463927007311531088710632284403181703375195914953746788587271885019/283746172409472259789690686912928932599117334747496472098074500689196928147647640421207438554206007799412727508239284834470992023880388725026,-2071839055811958636946310776224608128111629691035180658340207831078690713758482185377590872006317959438367574973588535649224011163346722728687/2073302565910268062861730461464346503272354063728157329235196503981325751052040244501023189551598369777662064920383734803012984402423225676402,-1229184873054856276738588612604460690244989178476261756233035263017367493418472551697993587595805775785465358761827634828630976623039577855963/1240149010527976023640006703218366121781797039840241374614268549585535593087398052916803851867123557250563541205586524380219485861664356157312,-191303499189498653414313379156298986202898287688810400713284681609726255759772493451984195481629801286513521926613817921799121835932712594933/196269667191075220997979488282468702663261306854223392067940735169881285589713669041190613744504156927919953907592554982579239413117145754638,-24068764589567913914263968759582114182602631042498202214561292595139721914997936299604865422739664680770444087295627905021968067350658716631248/17617203139278102987296383205843167470722044071485503618693934529793401868497064638611986833144186369886477781967922770745162461657759573986463,-6390206958718215138792892431726034592025868470032867257773017799285679941991817467735564004305730708443352040580430699228537098509546683972574/5062966200174831020129517096096322686854631343444065804277473554441934467800413885450072488160832972001865017392416998383631323975578405663221,-3599386240306982281854353734056142814973310318251452282453979057578449482802441079473504188253027801545058360565292388831572701966684163651644/2702239977019587622414371610736575863435358317301525101746444411812531390340477025024300331688681292515546159748210275598634325262599615691929,-214772128917893672466932129586829501689847887931954022900652334701510671399749131321945842833733092943216669228113730155425499536116200817264563/213521773048971545954332326343698984284611039592426099888447938599875968660992995990717545616760422227502014692330445992533868402927827909453472,-56725501698773302038758618851220130495658555443306967878865305423471364135615356660717366843994394967947486709750225670187210585303095060306504/56470230219575680624295826795535827050486451645144973866388980151319648300820251550534145203042418919167317033550544174164953384072733853724789,-60691836456826539832480972311459027755357826412467897334735942046323409571366404116132522264556649831259874718370838420282306500309128817427839/35409554305917823067720087587455504058272779313943856628869308177415608387125921471874809332905678088585663178765187516425369481441063062442816,-277595836070500583769696357236844552869244873598919475078155777898098064040996854531469729877171502961111941810006724978320196158538031797952712/115031346536282580594932693242084392966591007128192831492839814411294549486346643616737664838621311933651602955980081730749990782521302043852467,-633067566540083669655064353597413535491206230417156798335759468520549294358311917472610549326174040912187977408776325827973760827711324521241/519365265250651589114920062675651610969774469977756927517945759672681647662587540893245530639359231713207531010855626484684544244356559697056,-3910939696383503049341796823008420465469432648432767656426943918303602603153585253548167399129835552494334098272487979319176979275169414421513/3977902495297626427046078909516663649868292812022214345763668612501475441428453130977793639760103346157021845608375349710562713079316143166368,-54218478096607853601216377351679125630546326870729954060791194613704842033651184595339387123857173665986286563191039660901561756661295502048963/14012820819081996587283949579941417718726345837845908392187639713950460570928104722659564004893641216215404287290472428987253967695570863226432,-34784247500960744520489246867444402691928753759388117156030528135084833904033726193386837053337209100122375245831919195802540076287949340927729/24562766416366690141227614376630690710577742697405431305068135037911744602336612308933083009720661025385366685791492568092106541651778398152056,-13228135475819826739294302697374726616149985836058935468567461337125729384831964194563497961386057010272159886218835217111596206825290522435881/1351968165984298459013417706226295465105649814857968899908291382936487553566041758217717813161514473771263051976621804040898597391955595011848,-39445702491664389273550235638458561624712859774773808884082021200450135254829120696340831721657552642406680300801605820699739858337597708807/33714008073284202330913190238406378738455008899971275640497579072520595756302114892881154544872012811991735097110069175958792412679131254528,-8132965636526127558701086001427055604748854147289743570326171749244069151049249893415294044776896060906272524588980377807825050561135752740215/1083545329086175851933744849355659015376189495407477670631586127068203278045178257910044996701170249165439315181486362379766987888333998890272,-35779684979625241157810533557467055770033703347841971061823171110770582256332066972067119021333935358993541873248549041182342656829034658539512/10444533386301524973448658458644901267945188187261176204883738148813873216434285108305349541419308527006449726311128229072035763699024750370289,-3203495835923926047894918352369177059233458386630585921027136338641388692113025766541469331186836584862663661061888264482927449762197909688594/150738539083035908321597544631568035964635333043019705968302894577806792915386600426873470325727348347515957713770108556812650881117103660011,-26817099771021901980017407055962484416092320241582874586132386566563481588801338102569307864118649467101539063437875693508541008688540921458132/9451796955374159617993412218714379226724022366845006154057517340280201569635387858395718867247520308249183873645970570673035280099302584869667,-217043955946492007123453311787196597002776986084352921118535433045450023001939036406870078620159378498970777976737049645429723091814027871498586/143437042053752484743034436223183212405077601591995579521020514038808701823632400621912089537213505125364048830194638974186390293679217707509285,-54514850017930796828403538774810886665345144785201920411769355097474596066627129876631454331578840897190245249950228759788583443504156596115937/36917637888844542776356472992232064274407600822759279980674975628558997977897889839541347798385510004524709937987012374016656004487360844406846,-2882206655216566191958982105101526502668003477648998392917264940387279083812156493966281674218388756835682552469231371654424213806065009313783/2424428917778400282297880388442193626929463094699643609895488464088246658683336224783924130116275749244765162300632168591893782269408976684914,-503433313714128892026898456242685393340025732659634214137632419580184609123642200103263874289050609341511668150495562374254083501847098151633/371408849756776090547027295263530105087452408845216922711534665241532312421172176352644576485457000169681889374738888151230572041759026964785,-15138060740944501384600106567801333253273122124944692895778474705302641792332729321088049236397104528318569831163209025650242649480597984125/54324921755847907639973890342336153032028665706033282154879078013602092417648164849243141194325253614524335107396527378393786653637314379408,-101075949858382939642275090136349518313348615738281494524481802179334664003188543789148901070300238356010896007956048440103713687276322569143/343767326034206620821302376196468533876140517557107668343226072413642231398084859394672851680591916102711075707705898249304796385113318350809,-4294583775678570946486285206431893874823730199914031868602810645961692984698461938266390513405178280193773677622117990334908544504785273554246/4962143739358318690367947503111093326356030061028676654912487003467762735857563223516622925639661192432941456512977431447347094494570613197185,-1047360403480223038502023758037331819444282415441599103117390707209122558934152346016514327948377951895311624543023761322666458198818823470258/4579581088666228048147593331867312506358507554873009866666504077242492170773409126379777085478024861026119854272813200047085389038209316815347,-2915109196324095314958316884115483379261311052133626648228862051860403027052054229023028904115022053957694642382327851304981866605564657891453798/2258900555565966209472598954019238989157942390788170189943054163037626336409716654363047460791237611673919052652081225947811633149355432851274917,-251073181697896129813602744887623252868172990439823363658946069751495629233790890688826698561676483970451613510594550733981018868717892100661559/210317217022194502501367813428065554932430408577285577634541268102492338036003799060629091922356851372012475736575474726014015813042731563439878,-48995258739639713345931331577326700243149230981705357211475182254725259752533893203816097691979255037299469700343681376229342996681975565454667/38882265389078598344775299170258741874430360924815171897802434195079948258742108878328571543305028015221713656504908131120368870883450513114286,-938964474374926073227884513194502571524732306916547534294360714266873866699154854244068448733904021082236107558502012120461949071853569530688/713090499953476046738667194056915458364826029928043890070856674366026298504953735839275963928288517159438436553951754140131173190956435967039,-69373463112561125274125849098107317703532937784113018847899149438805719359932806147486298826005286742461257564222066130475056800498983221999529/52153069516032483157117527945286167629109954921260583409867268101471516573746844670010982924994903085222569648662431527118397893236809004728708,-69144433301802868988521806333675007160413031239629901357436316181575553615512187054184845688025452923336616571780707305077091266329279227606/224185787438252355514942261198032016543454215824787021719376842953912013161451781843035722827088622793862854964630483713721766616665969118579,-95281751633048533275081318744407309814995549599067507899735333927431596699275759115560629727641220543933424674037512731656295909688948142437/117488611884898728740829471580679854117605659286535356585074270250949152434301561032414091482522244912177401784477997894520261732226671503442,-263483695336576049402652474752571454053306915263768666729770915927270589941714917349461349369636966794616353295048344104640799336590626813029/609868849826704295473657198436562641151623478100898275576821208951712761444583082805779857879588029480771130853338757230493152673962375674727,11701539193635401756311363054157797582442902542300506496561477411411452197192726995930029306632903893474119387600379900924220243296193814609/65305585606486873514045753679002299862092141797624239668088233018750928834342895737575320847702433469461922652473770929359891147853648399066,-2686156821120017634089047267181482082568322356988504224221224408050958147351016635423915603961179985323059735805770571259536527173122289066549/3504145091536768481943930948007162624987329495452377208688171499613341872121276191677338876805658871220857269881010754802633104441912198301092,106886353718449964359291839876578167497980046279657546380411658005674797205453055923681619096772680469735820203780377127690416287725319277477/76641769846698020737725242808771616142578925551988038707272861879272104481267538321476036801227040974491613948939404438212372956283695035878,8802514171727702084069495809251891335605063668876830143070893518156305665607788851625096362464885351357466620033562653150980528553078023961/23808460008482189976738124505747662205892524417427368310226379656162829964821930392436471772955946579923812102811400511554756523322135603574,-1690831602705583630451578623507131937248503088565636877595072984392791731746603754812298057095726813126375246955496732260484203810969138506359346/273575186010043871354293206579119589346516069336118768617158409385370073981276303684264932432258457896883446548486751700900347873969879460992329,-347577458971507899781073870397719613758537330969141687597706061278288803760978047665848940362096975986685725930706525681505968290377939096673/359809015861387599580201035611070450164844718626610061563533426517489890722528803173998287403181050858821877411109129450569680152146550355249,-4309024922813379531508446497201900860403940702884379094051548710178361456850154062268941765903978416836358676175405728396048231960719432450/1657623192496716246314222146008707665070738244036080260429774522928604214036351822783294960848639887243330756263670647696349602854611166419,-73312781838752607261835583026935739838978387627818302959399314815141508366340242804903156176795768942428627761186644011564722712725182381491/18902040912975939006707367362883285996418580331203034787313750798625085035584285316553802506502480810863424627759486866151111642032003959484,-52676893721687331426400336359506804078535930644510166795695216206091044846696310154213347270575742913770057038718422002033648676044901837334890/2611640079074353375584348302395053539203475098843072739524111382685959744504069977754659644452556026447865287000271122664428237546996880662067,-1554309233884217025746893022785898144917441845703862809954317227862491576585342217592295607765077393501624303674149195232240516032688158325840/108125221956450017532673989407552802469503555906731306759216084677956950668079713406736629975741609279333844863101180724893684281708401927549,-277306037211818789337025918054172255526652206850573498622846357680152958513736215351728356084283555173070489936531199134706515659554764834183/20985578729636310960174582298916122455372070430165918472504037290907614205890488489905063501650511293093884825060384594967850848513318349676,-1931370806953726576786184763047374666403638083842359284561615877387555097853589620568132625116663609668857323485614587266425769472103414433/2749634735551497039156352387185993498523876829134879349160448627522472040802179549527716987796316926841935903822647285616426444879639567804,-23522713010199633935419787075982697775367896118989814812143419774855717780977990645600896942872944630135396577299872423358252111790322872472/30766711354919160898090036091782465762481379567536046181328606987452243630205362582464740933111262301455420526673679640373528447661257124113,-33786116079588795680851681375945648686198506285799322764081686136459108051412584894099490123896217335913531929947302280779362634289046662704/15332117735165418771593428974029959978868299544589297316017804312781590387229887981715306650833649274314682990783602103985804892238018681401,-1330972654072916286811940167352562799636540867347799221718861155820166963018341515722648048595153184105410788825703369394044272623069716624809/904747349879286757641597893693569733788311356736169578886947317373772756691849287759235683855772313310619325881705202586551421894197064699544,-2411187304878664640565466746071181554209826501623288873992363804454498203197470484669653676169459469469362172109940548575397374212806740438987/3187338370485153477796938869141871762004899552174745353049145896236331033616515707000359966881192219350223096705794510453449835344016783722840,-991723445158825180428296097018931673505502238750704450328357046658435896305414663173134048634547061918287564655110315213545230154918704691609/676925265019334167371006876724301124568817991275248879413260129268218476804048299227554872175405129121839806156124828420258102777975656410248,-114089632251824703532977153466591548266406159120282520395291212516658111211531121057560065692469830068924238438917743710569413324304946401751/76796512706460530717965783090879227576396806672466340598569666171281789964930166005583354423598946660171590555834026412395779422777338675976,-611610453319044067907603999653073978320777071139269647577944849632608191171104978713269217798000112186624785448403587528311996664171581309005/411473624067066730286762379059634622449810934394377898768062144089583195302539926856561442184468964093276147502183264601654171915223570354456,-220260031537779966141853112848286223442800964312255968121017531968964000413307298758219905263678031016580123017195791653184771779101145418633/73921531645342034144047173944590996628648211604566713133914668483037678645759085651524730338977732190495043369932400003598429696836132075210,-1149593872889891092252597738875711863714082224896858170687866717698029589377360984247748868679093613261299313806395546158680263892034533588939/1174201688077732018819749936707779288143639101690023513689260635330820547724428292749917361565314678985164433386477985504282672491567724147544,-5508904518832155420318103350217802405189197208287246090269154435884025843998249240293054756574860291283574286771948651695675750727052784486963/8628861361405309815158613514486753979915770329432555584378652871421390555642317599524041494685794455531708369442611303257779995156944878170396,-107898173320476914700257097972423763267199912635312808932776264240990715117987168564466487259653505786515873232601258223416484612800806679951/182984478366698610631937919742248263856757020645662588637020439975687154550475697792028132017974074600608696724775697456283606944171423746406,-6343084699322918126389221777665219469945480577934725045124676805478920810557577675653012987655604419587000977671037903625052749239479311212029/2804173641570054529654056659398126022511203262674204740499618460979598027263234082416471806681024960178158901241697645516761876147230275614473,-163406178716871709766637500355785354006369195280005544391895071690954654948226447683581424387518886982696688611839487355266303540191293095267/72784004471047905605422998144604650446279130884392618556647886458684721784217746043132456907585736762259297568819632074673509836934701954378,-6204499868294827211518959965152208968345341363490818749878015565503774348030595526702028084427195203097415152405004783922882154085988670507/9968229458689236013058759846583427245409346857963876260610941430587660433435532678475825128210200963090941034291782802885973026946386999448,-4392111293068852260873027690566254982806703468447136840723176572589936273670770126564756424567768648917858170233151427902622562430650236929850/194836758742485055296825213331061096889682348047705552391826880303132717591209100695335916520845598090239599734727743735242783340244053242859,-78831126513738287269199304171739558789270123512972708535467728645538164256723808454146416939048477446405140556460442048879335168832730847599/108692574274769159394786576821738405365214283414299696787487281515739072979988558533562527774378809261816632556937909818776679524397932673736,51440766680001366833649603455115615384143955073700716789979635586016598781765189481754394716099572224630053505923759919995725678404358444287/6182641768225426404028490099420716339043450111027813302803547903771577219166824661998097702602052318411075052799939466873059448705966717899,3456630932190591860835894848260304577487081078196394526043219676908400507715054644380387940416793184055969877695047051129709839886092694507/31799533412914909250402089129218636467052535884187676119910028803924434379957589244006612915565330446412115865507957520426399244086648624011,-200847711121539320587949547724132748976126266253383792454119651902480181860221294663146475912784161348316097318720232382058036804815690364928/36299904212168498871488845930102451063381732747860016711689501664434941416463418991196868320488046679865838026571302675396643357219723496817,-6809584812115113449061982441979348400850486171772359615468508295393923249428327452376526863386343688175167646639071948720491889561474601573/1129900053983548216075957444352135922470344002082922712516338491739483139465597258840393090615200871045693187359020905754992173152778088952,44884691341721218624474398996855185665971855562703814873195517306585115702613979135592140598739098422600739280981046591802461358166279656943518/12449294262310836275439009119632295180365256172873202472162261642003316012135513494155440053180587764129689597675129488378715537624613567759459,4389129122850633946218984762346988274053101115504988446375444008487300940280157399594889320670934718654112222790850459316768894369866565054406/1562277877126785462261596380385758493407993285312096940221105725171982566012825139166750628482941813738909687609414237278968427360949977752295,5299077149623985866780273407953606010525579678978388315151012573338502705006414258320404368008011946327510949757607280620364902051290013987334/1441909741276488986764513376497247388305793513366086464427060844775064479941637449153694523925469828484198625637880295583096453811344612469559,2871913738304868671719336547233903132226050807230741362554116092285343776836849019934672988515338616533200363278408093619922642151984259780042/462501799728510519452634971603281652315967074283940700655672609085728554957668010476689992935765516899610770829836245432466722783785845558423,8478009153918372907086281042667139636482449172893215096697695113687419730441831293819894946041360298650846588816167138712083796904190559623978/141598673423289328111405922207743680377398356360731199498992183543245383992460782918817119853319841659948185776966809652616797119070761163589,988608758630090553771850733982820335578358088166283965868507968627568110888045980066465178276013871072669166363379016229445332803305518427442/240296763217624600620351314561232596588903005310420924834464571735755028460153582862754156773527039762500177481798731230151078828068007696989,1469975738221919465366043968085388820770280062716571911035456795009707491608608520594745561497838345898832696444461498402375153684009645544674/1877510832126935650979980146303303354605478363540190619224642010384892754505805535467333308345033383642174368902960761395971291369411551233951,2088548005605185687545009493075619543901854035338952514875928593188162657264996647072946278986014325705321447515084548249223118923784172444046/3189081692480321021560861474997932594477462924144681257320435878687547109770859969714329069538389082128983858305489566657352224192759350633941,-848620991667436448000205734987026009656410524127745095439187281801112797148934082705110321028388157938310212324825140745631337478345733999110/1107546755829162616054870909191106541999718982626223452665161863821850108432586754786471505447617888690356998758009099046935632960074106410861,-1277198551995368126200216787620224500590428681634336569664776804081139110886258778021663126747462047093006677634789634517464862671005116634166/1144299912278091281566917320932691578199308414162864307272923340756490389366542296474841624118375660173150427538373553670137312375559520693909,1349245561308915634457900145803991319032159187214127128632836887725002032989696005906160381344589170514508234772129627998450525527798540123634/553532027523797027483647663853584982094925654631158117734618000131158224092686274510368769975914229576179416337918538999158753828359552930183,6232814337155658786649875769109339319094744774909356699245964986852271337432463987926976897975746842244113636956974667689347576184423989207458/2491198101529824133639076412170619835696053869202128844919538622720313792891552907486161051564949844730481927921363687715552443426637783480117,6519347212891149414403522853542641826271310805900725036327593021464595680718857833269085518923220424240275584047453080310456464669235470479382/252003861328734184578264782286298964665564432914144907838351718455089691348475124906911369131064935481969896955225809840126940048892410937701,-106802682979380275643931019291280894667462230074493373463555571594194726709851411595551846463978310778088378147458086049602624011524254146990/102897304055588059081667516145967394449710772929127604043338469311226041658978172338501621429305673914729721789103110974301421719418610476591,-55570319580318488104800947158787503790850588589044525179142207740435916354429407550358573514382647620223075360327125850517199237627981426754/55380893947537053920864621406065331331558118741354397682240536027843671479759518316873746000777632942030271259790305360177044893008331725743,-462859146745295075023728538422387087625021466625382256528795387666154548976071097623921479356249008827832095484170582174516214542279830907174/201707389911338635108297786325387520995558961798217691931232014529706436958290668484076905273764433019515110783225668289184842099842562961357,-1371470510831118373611651988529114124000007555547806654981085680682222841479741522032240642019670613007072160705847188225915869007376221435650/1480788910902838251493395308058255245485690169466805510152900847237171036167084258234651955872656533318433995162394780578071899259495218192383,-430390144431409910559436192948234742655967669517815546509055312420926056421327252080657213651642016759917851081537156745867273865908768602/178355195682953646091583285008307910632960087077471585262723188629996247027251582831207077650630554511532034766975525490859282944010986451,-9204729014054610661888210900980036218580943947463265384536217686230964407911412011418670606637209516185793520759192463666424785028743830448098/9115756979024565324831996512965509845904090094901146325791578121848225426278588035394736421951002944631012480746375402074194970720924935020559,2258595698249937240346111586212765726160088093383987349721176052739526125246766521368104212723732645783453612825305063129689583662453100234838/263465475735842435475352916395438366100637706647996814972876093989764130640441678976841932430743686328406205054020109722540279909204591728625,4458095576507058969171815854422621280662647653536151143349737656725853542798721561159980735582402045336280593329732516634544274701606495757982/4481821395812262082427056860937374552328062711278417303525083857463355586050954227470932715744459403055112123230460810125947576090485399704263,9613837241454967847769915363653168538848708528179717503549895155731300443411910545380590365155190807211378283153468034586803767582925764621866/2903540773009019707689947900017631055271106015672994014148944526416952195068071669722541332435308709292956659026706615837405128819514724981709,962241650109076520383389786146866853941424503177528882899737716209286664682929013456647577016408353418281025936574659922782109022750611933362/1055613123123695417129686862588210807280616684454158043326975807581633031413933890067667019669785907123583520221596297612123200229585401907117,-3140415938360365450303313265358455542060926493303770420133554528331481780519135142711270005318161590595080921300583435527036492376652354541042/6505978976504464847252102627035368233635025955718464252732454472200758060292129992540032815755769370838542276430608497170035540080083950052087,940976797492044940446015389001797243102099740578511754893461032124210938654793292234753698184885576983298411668187276249861065321724256063002/50033647261599369540111167072303959027175456358803941650134789501632153066009786698538420446367473208309802283167232167271744347401139691211,-290442977315705535891913082158077730856669070400995097128479925588017853043270929607755284695526623225138943077725674351718664718566527633478/181313454682092894129759373344439506042446691116657955980774076926305474800199721349916310612986157607667651884171045180851314639549093790451,-231243277453019829330173011245273366458690138334274095741986376124890226955110856677873813979994499698389772209987760862114415854028995895458/611996338870425152877847645661321545959265215402922595787850467973156382419535580383806589121084870769212055790989683602101310526288035131839,1042759961582496085315293329380027852432010124725350331523300226131844162833540032798860840407351264466383878828449405566844135692908147573026/352815534339534722328988487886441232817664353591510624582965379322148460774961188612449633860789288837830492551962233939057910274717639447687,-3539299131659133210239014439061188214756177876753959433655387725489840855536232903132307032519282567358174235120861077685730138176071215663516/12903457983763591598767116261389460488957818105134759943621728158233926895171226095243164253217848482579334945195162070690047335908621092771,-2198981087731780833708004341486409914244042004425159298022982869242660223507206531970584495413908628424810710879742052673190349210685849750540/50901214398028320135406237121480996505980851307822372001798772375830378895908538206952068902845146655705796314096078218520974902574824400297,-8946923910936785650312723793502811047452073502251159663943762600679412307300768111700650428606756984234380160697253665208493704311240796843412/33789115090623646241884407936239655874783315884202404015818161042553697825221460901392584724606464117033933530533950839542104333484379622077,-7128383531510144236255925102636777170224597636323884077325653670038514327539789338495059395928757057283228298827489336949572442656699670391299/377469922622234291950391029156213195509971619135381516301948678844170258623586372197877176575871283765125635540135571188121528500807158889672,-5056720194102286510028191277831050015204452257465604221923883042281202894540601856437147078098597443069832281062897269568403731533576959856677/4062476417924259097384453011439777493963583395875202249896234908207088956274234944641741120835355936441314967161785109844473303310247915192953,-1710350656964978502157477001754970035211892017532267992803760043060269718442046146495332555029825451690191046073565174028609238522112021212524/910884240602045834361810026499877059641327795618388458655577542242272754732645234296957627631979204076528638071707002700968610029435955773683,-2311146046049088011895588861840165168942806617549474497389663766470477574659990929057870457477085206366937404109095801730234878970454199126483/424805036826360548288840495193472000476113392916751301375283773024572927509755302850885343585978184039612667076298751261276730818763147878496,-4815405978326346050577177099398616772617161978501170238469719640535924704896939918096745555850258004932613192486953422734481512505370091796339/479681286652060663839805875909860239279929222762817473264863547986871879817209901814735490113157999737577403801783770888446633352696267873208,-3704478804352587365060187059089603911106469522521378506161964159310685242304859535402899695700886357755934212274978683593655449902279853126511/226518470263894129062443851711619408344936751853561453112855416925361266387388140612588686665900360516793587462725969610327905938018137746985,-1468824104657342409190384059918129405592950299560387171507658902140838973269406384719015000437581046953489896841534487776560889886378404817630/247204195836556354237660374891735836205821843605495681479745065291249507895800392023095944417696962845384723353911573670884724220715784449679,-1258077474814697597880425074560062032597205779070795234950424742117481153166089028039172774227170657829697705189628204888947014897273338890106/117795310048735816109121286046832958208935306222285615174167282199740065156292577916892390147843183280354885460196339739079663148659732775695,-3618457680904454378580327555811941664241953308566832405143278229411023401983523614876893383786472452846147439589196493697227563179604936181767/159569008216274243418461307918197154094110577922676398862366973341951550926579380832124468889506025564551145293524455278646685368485280385020,-15160786312237939982500829876642249224235904256765342726159338861392602444179599213516860545573345276674787362929644642606746273493306863836348/7473763043353643103973637628490783891461103130059415291649705612789690916060396154576640389292943375222112459757563983067025109295408987008191,-32888426421715211024059147343405489178051709716397350659423909039383348866176454444965394668826465363537494088738148734005006447816196991736493/2127146747779610066597088621355952199427408864085426976142224856647743179498581483671665583990048505551547189529569711538408206208381726747448,-22874412385296459581320355700106180922834012757585199028667241368842816809407265785838359739164168089087631965529779189233192149218529508680/105219683954880920435661038377438698544036926623043653791851955417080480698489131449324896072870848104165464286140149676243332909630094081,-141231790622633814307018172255244659271945379171029652724101535141990881769204076446027934630710086233900460710738511717823322043076998918387/11696075171617812054670702637411528908113220527391742683869402697030263670346375842410128483867945279593346119125962050333758358246099187933,-1247295874206034319705351861305450362502757572763116310642931934364489358798184694610376423424593090074488193526522224589495969465940486381044/390205553484677759274938186880285588316896536951099490126159693420627123059160584403364645003664020856057849032665565138389709610641586295805,-3144331854358382189404517594886157683195919845825295308782592100992071990306247924849170509002361967219882334986861977735674917281962231425292/527706482476365619900122765406805153198409482179406628123114651198471663907391197195332799377982724474638456380728918673508642662214253061317,-1682424362716482086422223131493902621280903456171289092798337394251679718105296335783222830993439750631168166503990923671248598675468802301528/153872514897805482420971391899161924091772006031127107781631703356510218035700568333099310276055429480690103148518750589430337003387877337907,-62112180289198439152540488520692647058688075957708686467902860700680696417235320923869971721500986377024136925821130751768040682263167682149048/6364639163199692710981713186972077585660109492726665622737192802121779089804549155613206736738180083116025540149455411047118669956979533513407,-24729757019129512202744178141341651961614780705565035996643139449545013247695875944976127566402188148373128235642657850557471567257194249634692/2011355276106377564611395365461707168814928884020375241274659261578875414427957772809375443718214113317305093145027748712972277497871436138943,-1957150654779133086788818769721650065286678023401935931925249936252637081550332823018466329111183753999357545993044735253524461956179078968292/129112691897903040468734523478467958705384579619483674911331451040642979654042161225970030154621426838126949417797422866299247097598219968709,-70648765263924440230695995590842320174351589121521953530465789651273772542870495504024374938900853452376582199732855371024979490348498974023167/9174937645100565221352383664039991091967027631791720695664021147255393342390664711441034556186749344796758928681006421741799412321597761616376,-280634887788540055153487499179211664897917840352111623728631601763935124038622784464134458064268587378900276304582414576705369173002123030468655/49121981352982318513081650020861145827302208767777383697994085247497343035853924364992077743288828879606931004277654271162742102172603412168704,-46061526296596797950368260970127473096849213201876500475258539580372924214060832406519751831577253321101997387941001396183697718504495024525720/22658182796958838339859052663821573686875091056251691422495504943839014016333921826830238678374403135420868172101722352310634373158938094533147,-37138815421308399427005970954713203587672581855250053328087933315885927774954199774293508685976791230279564564350511137024905674771098766931628/18310316399163725945534887690700076722397661822014791492706892791304294013638555723016480996091426475377680543733303454430067505772077273732849,-29075119182930811552526315884943709843903032683144307242018690821796126996407650417706309788370912069575017320653644374539343952375924488248031/7908658324611578478594354191276635666523724643843749658101094239201723998807895996254896042762106121416563948234593760716036997794906733826752,-3346791542707417636575620204513972605466808990473367981950316362800759931041694706921113469007825052025071011372527746398658888843279544057385/16588106617021481067363921913634031182221883344882252729610103753349362884861971157523450967853096347277679610171283558119283289641308146476,-31790570299104057299913953088732587252295929094230952911330581224428469465840692487514565407144403656086740976554122559235092131874028337400/21804832800544688022546381900344612024235998291194398672681363868890354350527735840306570772986032206817169867000815586987593724013961260623,-9802290437676607726119409958863885112530416752674471464307997184643722218949228157040915600848275056261130838688356549422087240849155097489999/6385796083279418842707812493345357422677711695080388909712230540899552443744871687223285608770276903248349010214594093069186081676757092227536,-817287927412480397377793368916168516245663154561840995527811615630145447644234123544491202782200552159019668927134453095735776827591827827412/73753486784869476001595526506074798962743781168108191222809271175049993326036017132064544923919169198434860143557409961420980722770938093187,-18295050946630310548447951189601378154333544955882562325625607442210155367796494889535652531859595972090471689738472464696081395807726487067467/6818837450368441231260810089860771072133253227193162182941506036191134524372666232711308555611139825539865210158876672933272562059794356036688,-36768350982686733212169584943286292682282376531097159023611148647245695821045753603231484297135549143746102060328714969205380172319241285684941/5671031922910798574631260026494207903435686396256592711161136886221754500999750301504625565793124517031549080075378923310922824209394753189104,-88238927987632784349403446302048966456266452417081649752802995836745400493588005151893858330452083905175272977168000700198316295982785968506609/10536664752477766601826826422159528098864191931030899496864757122883933407672795150843743391208087725912650962320772570057940279942452109539284,-17375718547296488880304918706937622407587403998076300326642094429239620968400394553908903452682623003757830068304350886850167057563757258032405/4328234945873980395688811056650737260542025645320303722575371612697441007004579871931998913546587077312985731973854594250112137039020581837414,-7161010515182080743548910052061582613387306444997937474301644493251339119387724599362014999651691800800049627375346236768429178343659357637772/2895474799043733819780580188191306328078520764376814686597767055024828931055177684450360231696214550707174556865568510765809219488870591201573,-588955097418107903036277052693454510305326182419996090713362483140379857603659064597598967039484542045803727651565162133622286691439259132116/163761130776031835300375258817819103585899120472890627565694391717705531085340669002142279214539638013326324240761722861113791698662325889779,-1272262554141831831517651583277971873087286996155409240640037491765019810142141738864602841268533076653792039686609207091967082217239162358644/383425428723993202058798905138965726436451214720848335777397509264857593847634582876896516427538761366356492883792660631412873058539731130411,-287046460415620723933560739488898576283577624351409771747475659564422546058706189853990712287867281705040940191918450807739362810730586701828/83513753329805455354731594626196458671045436060160715925286903010330538585673156545281037932739986794505783616796667443438525659034061025807,-657080081993341429842684626312137948857460063868678149709811377968696199433905261333434250269578703388941288930144589861471103589356401611116/187807692456474619592480920592299856965860540338566369190495848578533841630371103915809959842327503773100382913929562026407469263526332684029,-192549451522735978390591804382032554573948849164102795058307600938102877715677208749219239229388052693683034738070920334973461391770165026319/146685464367352771139428504489039937030796202124385335029357641376025410821594982358945443812334266993251396913978799313752072240207773764224,572927127502090463174708036027790458243236771524864121770518379484771361421024951932348277489323179279557047649837875957874671545069550972811/1111046517510890172319124412049959448271037136885812002562961827645671165564452007238360100954410409731314167093079259828457879320331158407168,1083692308757411325354317628617888730282573167811244166572317223263810162132694054900117589374266270565355917948729907101880633844611658045/1644149047496874074920907452306347367122943731485805377877649037163765626100921854388653496254339253024321291001184518234392277331625066928,150204887719617872219730110543147083974830706828416405803763206270736449051366871580046882649646500469645030275251100759684239655814981979833/178081628112198581641958572175298108361806889380228227303366141016700856689907376026368030580960899639960678168144320318799278388228728798868,5596292390740084814861197371774993144738458159104292943624580450149890657155075430262141000980933533425522717675404912369947257172990642627/4730443874319080269566512954976839064431521400580191582167936556456066940802974765557201826125242371504585831294941472751962525282493149460,64972522686560196545646330392832915548380516162290577684411693215358721651151408303755092102367664229927521053614775504985152315507209179143/56888153594154193457922605608525337957011153344149889810726698081801103014218159334481396261387920364235758149677548798989456750061364574168,473639530600302865338200515555261188535456682735466727215506102982303456462791549252076257578982292798609411751573568384544075059021066691449/354477516053494793850441067910994354726453068854529037747254642315747697299956941383502923207785137935233922956063093661559228673621651447884,251970283658683360278804255097318412542320105230597131743887811114020577270504470853937515708277486419328588398462916237874345386139174892189/213967183038126137759342845542167029909876172826290426262466190597249666167795169912967146722103889384385905141529311283419420302173065203824,-124395776952276429679256135300091849268050325547768330572464630232774718631293845467066622813662316703813813434861778977304739689323115263099/639730721374612376147207376506339744927046522216761523273478144476961147344124167441392818621256911878924279640178737445549161470557645349928,514709550487784029000149575259402707543562037438369985889096619602881061163972133013271500750289605659116667623523067773675785108884713211845/614788536826487080171252330187310779072430066976625281701150959820201134576293612125487767615906393488512397783887948393336351642284907271832,386746860208051915643773315175748073758397960920574282560277406810082712453228102040461290928948638884881724503864543422312320529023371564997/328407327378328890783191242171867448754405263766523805974840855555932687138015944714918019529174280473234841723475587352468188664207559777392,376639839985302059609517081554367929865137501891956775896280439602148825134951278415100444818263985157034583917678985127859373708607947618203/276527258738863751856542760844927608923724412015257236389819099848215381740057011077127103124254196631005146678455730239097018162598711852578,509042478708311639195481057770833114542572266324292068183051199655511150023329190569087345767356517577831073064171115498493460376187738880763/499051212381344347983695721131137942874351933526009262666886322536308104406072553260143324006800019824323242115993050738263536468086588152112,258634329036106700630607560310596915607596465185507850760645258598925744301590122510598623855240239219073652526211597606855922466584119978899/680603178368862689471234804819107362154287326162823998056120469916376332819937909836880712317442966369526430942380489228721866800295459992624,-393653732333786972308355358263533482780494165493746595892194922054152591884112674155202832543634051625545710951141300592846665835608993476797/866282858810836399129485760032603751150286726105581083408152114240685430679778584217193726967899265488691051633508102567061051295367904029940,-9265203057207338103174953307584567693723968152507613003260638000402097245103819943272708894416403497337635700538031298665930866436939175821/35934036780742830048859605939305661818557392287932318622696204782533391875270374993645934579442622925705226320793340127192791819127423195300,-819445607225924600846668978704560023084867638514815515684733556948970907582664126497276189063844713895084471494804733316447198381193607314997/709051436110862069354605375745141599720351311300888345584903942623163377298629070665713781201775229164666551190359228959605361342929472444448,196451767433596685995507815584306564418462151499782762609514730888057392314409051788145140659301969126923079953022460420191394363571089023941/964645087282067596232779155395152649638037042188999257748225409626625047847656539292318457329046982079494309509727010805066736401847099720380,330663413617023495269305597274315874341288379486280236550939447188699159703957096623865644518686114249212448580694658826071769914584173152969/1408384172598150309169120179821185913820525113694275929761510266554262209093917268885617924998635776931388608476708048900208082319769029681668,18750688676381169908199479364413101435309564982567919484598111603435688870555133030230398078221417197649306781403172617961392369198523031353/49451440194294813670377398826252115970887086597792963184958083285817899476491493161772393279496587986595496349994475057036508925772264848488,74430425036131995789826180897539319870312556955394334781582709081821655098865331690429324103484061854129093726722932004728054889493722582607/122175674903385818466218372748867576476416363183037359198377529097070619399984594286460734100832178739962591900907593985664845961328365792944,37975081763349705791220336541218456625220483364134662851456170951372607400533291482196054178457387123776855289377711247350683526852861745793/1614139988191676029190906269256773608765460222631748028310075053414495775407814284049398240507544708652671157322950002653303135279682606394952,29142702021013495923702309916799677848688887433755772996037705837967665670889884825861445287757845182030791012470349731417235786240026668793/77952030143110617340270329466511700953931956380658182370726287954878655876514083647768333962442334950746155561686344590274844970271060805556,38670095117559298075052086534062826887447483016989846079744108944608205641275875843058274596521837143906970809757263524929582985157093605119/164618885600566231133772396936648134186230746816776382860995007417885132184792456962241152726875887562460582153249310964900493063721357101216,811081865012214726849814407093694660102601906232452186995756548084745788198430158659168940799117817252097861725728883637970525355232070845/9510528171656777138291675112525859945187896594578834882996240181179575596415209656817153673231113557975910114278137903354746080590435535604,-8966610048027599820226818480575835065381276148400363912134096316953342065500604015663604007608699924351202946929232644437809056905223526665/43501923664249655379765937850832564323402869713232778798077351247502484600235804744172009320194558761920160272492758335863942111477696000132,-48266861023801403513181260395628717668892572491159796406171750079861401624904762453353873744960900707345141964060134547840722329319571651345/316400086129440683078240471978227357613983690888403377372359963513415014352159526368103444475525277069377475041181105029063484491793757706076,-513152960607587622792049974789244534192568959111231026315870402595550825335251002036640661528375361746774091665540802966512541400012085687405/6507701210089629671176235301713641934382248858480278027039647640988039099114914713536160313998511626270622834207438946112816302548857775838444,1659006821851907582806143210468021803412498947051028336222713301078123867876155895529928182394527743996683113929347429249623187126673361213418/3172879844322358350613060056852150998994121478001881655812210565789870930714513628712816117107199133432882611529046734668760350431414877427231,1106076625748767072945513094995462472348318969686761255869586074655472625161991562778201693099119983170087913681483044604701072477277674539850/1857280962402419644925118490436413964855595132471408566556748836315588505404784432775208403583156080536863902999053989114899371292579736473551,3088085151087942979046763269860715050487882424659562895849149311931620402630381678772258783758513213311275083718060642218466737919436485236318/6566378595748070868620076143995951627632085400349937023240228889188088153313877593665603519930207602683314749324256112686228251474035821626509,555882054406747307355162572419703413231578526520377857342492502667055549568612687087755009186773590088226000042444811804459737443774950468010/810174505572520434203337956888446676061140706569972055662673463894462051357232467767931161886725902141841376801871002958044562744392164802707,258786883964911805479047215603623109638892589035658822634267438717968448722154281739809781200009511943065758421624243010304712363372582298991/152894778513135864448025355782224772542912098520748088335321911843201947709202836078801682162710789757338979098706035341360685132013585548504,2094378791886927923739481870317547915345689767850783391608748234604882772535684180820991965637170447382834309606395788535124447578061001597611/1359054034196978560403475463972328577030676671711687098380567573042938459463044163230821178699874764102095028107056948616200427867165544196874,242425846545064458096536896804347025663740516540038943651112941579185876411709463577677656113230770898379437665818157366838518400081194247393/228288714824422374570887802031586076931862421685818081249433205856693289276219065425356411947774787781706185164528129825640757987853620189662,32898214466878986114878269354103986037438356223763184183701134930155267607728849701253356252506151854987681144525475475458133176522168575841/35137347937865941455581415220021259750847306508282142287913291258645302105374664674863244331244195874721778427814080610551505548791416032566,91508152133820122577600115162438032904050571182938927235479983785058284209087721735370315324151063105968140768410419601654047353271362040832/270488851008647232752023379725956464859238367726669725777607464639961385925979390869503242462507861559737147290878257914789589433081865038581,58340040326393687684691003262561333824128782649448260697460958313135175386478574342198780961124674214799621430558954189321419942235484878856/153830405332600503409059425583007111904775473676273192960684079368390887187471153907952003657474459800362266454436447391782144386499400676149,9458972532062004178233231617789192392961281324714392399396124227631214616226031914309342064847309383035642613547442026972931580344772970077/16378980603789076690067352957500281889034002580409964538674299171172852407230643981052589605637383708190144879455938306669558285275986129610,2469901312712029640845157019218707085305350211149436680859578303184188801641213470096160458704894841492596230867346508251804212089085418580239/3019505729498355975888328370463882868029973111751170979740250128001836417790093089847800452938506051986701331558996714581228995309060342880276,54977636894927357885384322093240411538205664969909666780950138805425507614088875050337021693165041740533470605702380895345236548344393139461/59019215258129060763974961672444085836255370156815883762090381762332417191720257143844942498080370490242804440521913983923554345858162165884,8363085284731874615534918164928451723372789965500196038076879069286944966881183809893826503807825590574513977095108346355862236808700898927/13394135837722320313997416099959957043704255799461065939441724402113584693212793475098335184084136963101242345524103976629139569348616025486,1047817241294262110215214046012127240027064913905915561823761382311174736357745452535701680738485245041409614989409479547003522947477529647699/2040821549215897703332113617929476196617587253675376944407306879588938361101789670487110605684738058967699758093963101464377101013582464219916,423913113075926106284864636013027455907088761617764950366816446514829895575661282253796568772501176532772234693130838008444886915579234194395/1916224465111872598980835327852884572466906451453490918159934254547012260333296363413307047568541032419691712793930866486276780083669526228144,313559913080544010073290539351261886474585289930370167257817612751273093639197448561913216195541591786569261173058431757936888833859281877897/1449719374397648838891756824135443662243515768572300534588025191091263096037544989020922635067828821761450254919335757980177671823554905030814,99799901575018459550812494388185969844826049723696018152790278361297617413592773715645950981954268334046346072992948679214032843582025544427/103660466156755384274693195904892218440322808230960821299493155134533783469666195605118347082839831064306390627821667067887455430300472968188,-7359746587055245300177729363484408609906878305296517568863796658658374267521982139879828393457046463237071813313758877952089938673976711604351/2229726643506924735862312211811772627925965845420684083228677889171029196982446022260056740080576676973736989693208670824018114466401194050872,-40963274973337097056976225684090275762227910308625104803516373021932369964962133427089194972572908794802296451201017430403330028741833665365/40302329385016911618223418555035444650236120441850361099073459463153811831973292482504617903812057870282043756915206149637239205735411912904,-628334593953841308106710528570501620854773170827244357001065273850883005258123232751915078306962704608857940687436168485080606676872859278027/126482208555753039700888877679112604837834730123631645963590392820904561925147947798822527604299717895088804777840208121954397396239080994631,-1202447561947782075328224854208988435438928105695759784834332853364290212824355866516735178926324935980087323999846824775494563879544950760921/27959696259216049770436347374110541829368972989566641772499109624169963251911117554859213122340307969733597036132117113485404883872563606732,-7851515024971743561122829854615262813985023234179944438638002767907591321282622292248245762969667464391038289273929435116866032339628440449/357896362418432701584675193131434492077549692475270858645020858182403446427470122475345855495375767483885300320887946644820319330527484724,-407333948940596228994260925221065772583712164298027213501065075977458614633311340987521326790018114773476061534477942516677372691648640912959/15004954476557667132030694776120284152224672340602847250053656799808260431485010895959024073515101299069504572870803943259713330723740483401,-3051737344015010072469977555131773166419620530420846711192752493085783407288381766305742852248889134877834758270763453573555302141458336151583/12600058646972090691524265465129714705593416364471191115201232807764744715159567603960912238077188694090420583724128172988502063359401849413,-15932605788766298530756944667456361354872464706154202243812082466640813309104554809464848855725739337538059068328540778754543465204953234230231/1199806110610523724216537682101968967993156737397641173819611984152305887308347048424924021538584594354678534108470312368637009603165048801184,-4270783613323970950951431910379309734211107699623518580841726395919294496610892974378070943146643017262837711606875082446655091184460319258425/687216427637022846749073151396017298099046694911393835311859713945636904131640999135966966693615983525779770565051069562128096984095558817363,-61365030445572367459923772684376913721996442922970916430212275003301645410831779443268386384508466613016428166047589576977435704042538720819/37230951183743250539558462712354534317302961386979326780754042732193564921891373473738836703437923578707623575726914934462541802286942360255,-17681378739792776420361465712704199378073863847814372103304056935422019389016096337546834862116205993313621779519059378372698424737651560579/16744381936166746284055050978175286455028658011892671805302745718688945921648919187600345372784916816801751009404569028715307368687363359456,-1183756678736537198493186384301149624934258657300711608313544778724891092003494670223539819726176219284338411128667454251383040001686169506583/1261497121393283123884074287472435313364499874928817732249703547957238920163256922857887277040768379832267118105096299899818056517007545821916,-3649879212482027096301438770585991444035598722371519745821964138100358454108574951729282887290662160685105593455842249596296699447362591015/4076069206090803006716818086738258346284688672427450787602575518737866978192745604267252483147420877063922629728405630134975922664828595688,-200342183629984727647849441817644854031121907953972214189613593378072407037742013325713705017328417961805844973025833553103902043283679075015/159410816089624120564297956471563207968786964443897290373775620055483514961804161866799846407406690669824038828122475621225879818771294611388,-189069969612478249147861556643256106462263730488294701966205021479330256531281249381749843725291503708851032319412315169432420499092565837093/13352825951156592322843606536625367469086482684636219978951332901597118919192616601401559249490178411238662734157488737814034397138400108660,-36491569456207820094531414001353063652973319702052223396702081984726286093879209479836347777206129806246837615762602896743525981246475139323/14750488529748690191786550144575565787558176086910158016584948858726564130937554959239170141234795518005469824313958485040080189996648247040,-309768864350704375596968028966807694511226655723875497467987672729363451043946353198327149321174434551654237819404268681441202400750768159553/193519097049411668885736955211715947978826033875613776988840858141358939855093693299989836176871768516372206553369738060864112211930338076520,-290382858933966680381064978993738320090210546394002518611292165619940643915960665566332596748968003518040952840475272750426703588540856927919/329938098913743637217215668444287088656313979594283938937479532364737551833359187868895416339040542005290191078397019147838283767820394486144,-901275420683653639707843102854332849336356452892088828622903015173331129616185215830192788084332610845508971007684641310382178341013069365481/1220640212206394065649066257173480472847110801808269050175253011228661138494023849071165960390875656646284297309347425931815522677134802052104,-6394428320011136363629559342048715783937096463400026518393740894089719387176371010133737187270596625683757522636200619296017007621865537/7331547128169536091466315275503625412999811224561140068797470858241536458464365995611701255709440510316985221266556452390200793152414824,-16231966532805325399834721452117133658407088181676487360200694960340146020998401876584322110260060041971435934928427611560409739342779138339/26558821951071185192927766087196758278618439333703371044750713670434083673396528328255634451700525422119264039505627821289822386302631780296,-148666383326504879185384228706421389057960176009165296080589900295111031183715051191796894132959334444175276129170371770182330117703779612115/339878630471322462373894858374377643192824330875494122454792684494442668797192372760547853082357719997224369197999545021948388481679191901012,-62488587189314545571209485308432179718496822834535922002429464762381335743726841195358699646695138638611872572845125671372170663623558561928/133807958737628423696577145398919506635191780092167531423481623936044925756371586148909085108774498191820793302061650954075483602661067179615,-5109481709358582185189853301602368787720043216503149007307848328257877757487748623978378611232290686246069428004149123883452025718181833187/324315802989358330172593428434040636400358103407251982734502117381085054375616778613990270510950256008541702417280981708749944510327271439180,-442791856619481886312252139496417942183917929035163380386987713889454123387669142110587307495665319003461397928787524076762745858674060892125/1606900398767354329435569681548362925891148492730282839495493445054448011501593082332087159509403094476451473861120145864648985090238397017196,3070967505330492401627686115891984451361224654416308159949721631176491244513704928662156884540115016262919395496162726753148864665724438718661/2293333885200585120871412515478543699195288259661783571688621604831791610751577617320355509562442536323552570794099112948176427799608316479040,33302998782678064597221222481146209681435134720384122457200211635213027845105376829901086821115411020239398876860444159753672243085667362511/59932902948667159788575583473509593566017845800645062525722293324898014140893421128897043593458875892052769736781406483110474932590961680640,328926076120501279042801548135024882812788230282426691028492570513093860788059091274889250212794101865019765513617661802382567551955028470553/486457085532833314196927465257282835794094760256578946429986645328176820824842150499035554182709814474348144549334088855535171979836300775872,-241587449916469337109840705790283484133642764973222775133718990697171870129008211737518858091791264329160308655052535823188232478032268371067/72056114738729981263106579205257170196134006704265194397346948678295956357112461856552112801384807589042273151870765965713089825457104740768,648790032036692590179432817947447401058325425374663412168419595531286054965338453341092215813611360319740297927224137356710056991777500283197/1225422203209656379640588463565356334814553845299394172359430183480836828937307790768332439486903694611092941655845870713954909000592537864256,-464088272271569825497503265007223889292695389199878381094693451633578199357824993521969856304482034871912211432355458306483064600747278043553/434807366282935511411944974281994858753775443520271802337036831262191936223645715160613209303813198043252709620271246456611619924207385251424,-4497536272059814161966648888139716413964412848397849576311775398691394328011944088094475581510171908024548462613348321129176503427928197371485/4604738405803356017953314400249320221868670470004339083277570022465745394925314047298665920276277668339888093398412361546192360293597285974016,-229854227085023545211831871503935776088462716212015034676108498310275219438331877358370141250857460329229484835921419454857943063489162464757/62821778151889738200661183098585045986639604793854033842140015981126039298221861453480277255451587277971109376858816333202875896440088343648,-2691176588106058375526459795049143750880005370186571308473276022255027113485383890905216359413863255099241464036225542727719946257867601743289/757440357886968437717727794433359986968374670185491325354406766329215038219689951898135778476477864545334488574203206985396298860152535752672,468685430499501666373302635638791331939337596213127765533578243631914815663950921001956877547436631571455130329009504700793582662834275210261/386959642436077897895275923591631944878517756901118498851432791742290030781308335740411587138893098482142894709385294195590242237056739936704,2110990763585572142133511600351129596298752195324503633666120541856520722563831444942730186337996254077204799741948167562939022601815357775749/1575854153463177962356113665718571328531210677912294440733941690433405926469571660399917486021016230230091952264888085545417303509652741452096,7637683920383027969944700170969812964938173254483538852425117121628528824053989692176542557373490714957482832733562288224055692506599285787337/5426737881698207265019661740716534433404306887594399960645242182681128451933389749274779828142646568749883095631597467387205671596657268678144,661906151339228427871109275130906228425562024473420440859923685793408782870320324639884227717212733799155391306821876092990711024385821485969/524567735927935653556711953162367859794923845216100580133753443228071766347103470654293917128552375580694403258664200973822889813890121794688,495643171356805678968174723358986844099206494534794915621553328410193314894783445315345721703846783103801942859897302907670652850826642017465/691571938889610394989280861307196410677551635996726140078165044465999545577802849348937757323778109204056308460198506768129257300992453967424,-13099557673890892819244036967964754723512597710853700370217865323713458206279928611578886382957278176959433116361859154715895816586643666042/40491228239180888694921478697405213590425784501505222592032039634279413451724624907102726670041891052870365523911624116861687548068880101653,494972485345879565149104748712462289136145754502441544608747979445467367907046734072105833086049777813566046862799939107773216121289945488977/432544195158141474578508710917625623380964530317449404605016526424590200639285267105823191605585108151189160983376984390210670369221458311264,660833471940978