<?php
/**
 *  +----------------------------------------------------------------------+
 *  | Copyright (c) 1997-2023 The PHP Group                                |
 *  +----------------------------------------------------------------------+
 *  | This source file is subject to version 3.01 of the PHP license,      |
 *  | that is bundled with this package in the file LICENSE, and is        |
 *  | available through the world-wide-web at the following url:           |
 *  | https://www.php.net/license/3_01.txt.                                |
 *  | If you did not receive a copy of the PHP license and are unable to   |
 *  | obtain it through the world-wide-web, please send a note to          |
 *  | license@php.net, so we can mail you a copy immediately.              |
 *  +----------------------------------------------------------------------+
 *  | Authors:     André L F S Bacci <ae php.net>                          |
 *  +----------------------------------------------------------------------+
 *  | Description: Files ignored on translation tree.                      |
 *  +----------------------------------------------------------------------+
 */

require_once __DIR__ . '/all.php';

class RevcheckIgnore
{
    public static function ignore( $filename ) : bool
    {
        // Ignore dot files

        if ( $filename[0] == '.' )
            return true;

        // Ignore files other than xml assets

        if ( ( str_ends_with( $filename , '.xml' ) || str_ends_with( $filename , '.ent' ) ) == false )
            return true;

        // Ignore autogenerated files

        if ( str_starts_with( $filename , "entities." ) )
            return true;
        if ( str_contains( $filename , "/entities." ) )
            return true;
        if ( str_contains( $filename , "/versions.xml" ) )
            return true;

        // Only in English, autogenerated, marked not translatable

        if ( $filename == "contributors.ent" )
            return true;
        if ( $filename == "contributors.xml" )
            return true;
        if ( $filename == "appendices/license.xml" )
            return true;
        if ( $filename == "appendices/extensions.xml" )
            return true;
        if ( $filename == "appendices/reserved.constants.xml" )
            return true;
        if ( $filename == "reference/datetime/timezones.xml" )
            return true;

        // Only in translations

        if ( $filename == "translation.xml" )
            return true;

        // At least, do not ignore
        return false;
    }
}
