% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subsetFactors}
\alias{subsetFactors}
\title{Subset factors}
\usage{
subsetFactors(object, factors)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{factors}{character vector with the factor names (LF1,LF2,...),
or numeric vector with the index of the factors.}
}
\value{
\code{\link{MOFAmodel}} object with a subset of factors
}
\description{
Method to subset (or sort) factors. \cr
Some factors might not be interesting for the downstream analysis and the user can choose to remove them.
This has no effect on the values of the other factors.
For example, this could be done if the model contains factors
which are inactive in all views.
}
\examples{
# Using an existing trained model on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
MOFA_CLL_small <- subsetFactors(MOFA_CLL, factors=c(1,2,3))
MOFA_CLL_small
MOFA_CLL_small <- subsetFactors(MOFA_CLL, factors=c("LF1","LF2","LF3"))
MOFA_CLL_small
}
