% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex.R
\name{read.bib}
\alias{read.bib}
\title{bibtex parser}
\usage{
read.bib(
  file = findBibFile(package),
  package = "bibtex",
  encoding = "unknown",
  header,
  footer
)
}
\arguments{
\item{file}{bib file to parse.  By default, the file
\file{REFERENCES.bib} in the root directory of the package given by
the \code{package} argument is used.}

\item{package}{package from which we want to read the bibliography.
Only used if \code{file} is unspecified.
Core R packages (base, datasets, graphics, grDevices, methods,
stats, stats4, tools and utils) are treated specially: this package
contains bibtex entries for these packages.}

\item{encoding}{encoding}

\item{header}{DEPRECATED.}

\item{footer}{DEPRECATED}
}
\value{
An object of class \code{"bibentry"}, similar to those obtained by the
       \code{\link[utils]{bibentry}} function.
}
\description{
Parser for bibliography databases written in the bib format.
}
\examples{
## this package has a REFERENCES.bib file
bib <- read.bib(package = "bibtex")

## bibtex collects bibtex entries for R base packages
base.bib <- read.bib(package = "base")

\dontshow{
bib <- read.bib(package = "base")
bib <- read.bib(package = "datasets")
bib <- read.bib(package = "graphics")
bib <- read.bib(package = "grDevices")
bib <- read.bib(package = "methods")
bib <- read.bib(package = "stats")
bib <- read.bib(package = "stats4")
bib <- read.bib(package = "tools")
bib <- read.bib(package = "utils")
}
}
\references{
Nelson H. F. Beebe. bibparse 1.04. 1999. \url{http://www.math.utah.edu/~beebe/}
}
