% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ks-tidiers.R
\name{tidy.kde}
\alias{tidy.kde}
\alias{kde_tidiers}
\alias{ks_tidiers}
\title{Tidy a(n) kde object}
\usage{
\method{tidy}{kde}(x, ...)
}
\arguments{
\item{x}{A \code{kde} object returned from \code{\link[ks:kde]{ks::kde()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each point in the
estimated grid. The result contains one column (named \code{x1},
\code{x2}, etc) for each dimension, and an \code{estimate} column
containing the estimated density.
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (requireNamespace("ks", quietly = TRUE)) {
  
  library(ks)
  
  dat <- replicate(2, rnorm(100))
  k <- kde(dat)

  td <- tidy(k)
  td

  library(ggplot2)
  ggplot(td, aes(x1, x2, fill = estimate)) +
    geom_tile() +
    theme_void()

  # also works with 3 dimensions
  dat3 <- replicate(3, rnorm(100))
  k3 <- kde(dat3)

  td3 <- tidy(k3)
  td3
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[ks:kde]{ks::kde()}}
}
