% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-scalar.R
\name{chk_scalar}
\alias{chk_scalar}
\alias{vld_scalar}
\title{Check Scalar}
\usage{
chk_scalar(x, x_name = NULL)

vld_scalar(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a vector using

\code{length(x) == 1L}
}
\section{Functions}{
\itemize{
\item \code{vld_scalar()}: Validate Scalar

}}
\examples{
# chk_scalar
chk_scalar(1)
chk_scalar(list(1))
try(chk_scalar(1:2))
# vld_scalar
vld_scalar(1)
}
\seealso{
\code{\link[=length]{length()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other scalar_checkers: 
\code{\link{chk_count}()},
\code{\link{chk_date}()},
\code{\link{chk_date_time}()},
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_string}()},
\code{\link{chk_true}()},
\code{\link{chk_tz}()}
}
\concept{scalar_checkers}
