% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-valid-name.R
\name{chk_valid_name}
\alias{chk_valid_name}
\alias{vld_valid_name}
\title{Check Valid Name}
\usage{
chk_valid_name(x, x_name = NULL)

vld_valid_name(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if valid name using

\code{identical(make.names(x[!is.na(x)]), as.character(x[!is.na(x)]))}
}
\section{Functions}{
\itemize{
\item \code{vld_valid_name()}: Validate Valid Name

}}
\examples{
# chk_valid_name
chk_valid_name("text")
try(chk_valid_name(".1"))
# vld_valid_name
vld_valid_name(".1")
}
\seealso{
\code{\link[=identical]{identical()}}

\code{\link[=make.names]{make.names()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other name_checkers: 
\code{\link{chk_named}()}
}
\concept{name_checkers}
