% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtab_diff.R
\name{oddsratio}
\alias{oddsratio}
\alias{riskratio}
\alias{cohens_h}
\alias{arr}
\alias{nnt}
\title{Odds Ratios, Risk Ratios and Other Effect Sizes for 2-by-2 Contingency Tables}
\usage{
oddsratio(x, y = NULL, ci = 0.95, alternative = "two.sided", log = FALSE, ...)

riskratio(x, y = NULL, ci = 0.95, alternative = "two.sided", log = FALSE, ...)

cohens_h(x, y = NULL, ci = 0.95, alternative = "two.sided", ...)

arr(x, y = NULL, ci = 0.95, alternative = "two.sided", ...)

nnt(x, y = NULL, ci = 0.95, alternative = "two.sided", ...)
}
\arguments{
\item{x}{a numeric vector or matrix. \code{x} and \code{y} can also
    both be factors.}

\item{y}{a numeric vector; ignored if \code{x} is a matrix.  If
    \code{x} is a factor, \code{y} should be a factor of the same length.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{log}{Take in or output the log of the ratio (such as in logistic models),
e.g. when the desired input or output are log odds ratios instead odds ratios.}

\item{...}{Ignored}
}
\value{
A data frame with the effect size (\code{Odds_ratio}, \code{Risk_ratio}
(possibly with the prefix \code{log_}), \code{Cohens_h}, \code{ARR}, \code{NNT}) and its CIs
(\code{CI_low} and \code{CI_high}).
}
\description{
Compute Odds Ratios, Risk Ratios, Cohen's \emph{h}, Absolute Risk Reduction or
Number Needed to Treat. Report with any \code{\link[stats:chisq.test]{stats::chisq.test()}} or
\code{\link[stats:fisher.test]{stats::fisher.test()}}.
\cr\cr
Note that these are computed with each \strong{column} representing the different
groups, and the \emph{first} column representing the treatment group and the
\emph{second} column baseline (or control). Effects are given as \code{treatment / control}. If you wish you use rows as groups you must pass a transposed
table, or switch the \code{x} and \code{y} arguments.
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Confidence intervals are estimated using the standard normal parametric
method (see Katz et al., 1978; Szumilas, 2010).
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{
data("RCT_table")
RCT_table # note groups are COLUMNS

oddsratio(RCT_table)
oddsratio(RCT_table, alternative = "greater")

riskratio(RCT_table)

cohens_h(RCT_table)

arr(RCT_table)

nnt(RCT_table)

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
\item Katz, D. J. S. M., Baptista, J., Azen, S. P., & Pike, M. C. (1978). Obtaining confidence intervals for the risk ratio in cohort studies. Biometrics, 469-474.
\item Szumilas, M. (2010). Explaining odds ratios. Journal of the Canadian academy of child and adolescent psychiatry, 19(3), 227.
}
}
\seealso{
Other effect sizes for contingency table: 
\code{\link{cohens_g}()},
\code{\link{phi}()}
}
\concept{effect sizes for contingency table}
