% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattable.R
\name{formattable.factor}
\alias{formattable.factor}
\title{Create a formattable factor object}
\usage{
\method{formattable}{factor}(x, ..., formatter = "vmap", preproc = NULL, postproc = NULL)
}
\arguments{
\item{x}{a factor object.}

\item{...}{arguments to be passed to \code{formatter}.}

\item{formatter}{formatting function, \code{vmap} in default.}

\item{preproc}{pre-processor function that prepares \code{x} for
formatting function.}

\item{postproc}{post-processor function that transforms formatted
output for printing.}
}
\value{
a \code{formattable} factor object.
}
\description{
Create a formattable factor object
}
\examples{
formattable(as.factor(c("a", "b", "b", "c")),
  a = "good", b = "fair", c = "bad")
}
