.runThisTest <- Sys.getenv("RunAllggeffectsTests") == "yes"

if (.runThisTest) {

  if (suppressWarnings(
    require("testthat") &&
    require("ggeffects") &&
    require("MASS")
  )) {
    context("ggeffects, decimals")

    y <- c(180,111, 0, 60, 317, 224, 76, 760, 1, 64, 80, 50, 147,  324, 149, 487,
           222, 222, 31, 2,  131,  198,  256,  364,  544,  789,  4,  113,  52, 375,
           444,  239, 1033,  303,  129,  118,  210,  99, 398,  101, 291, 154, 244, 519,
           99, 0,  13, 5,  416,  489,  462,  244,  74, 276, 1270,  81, 375, 1254, 36,  368,
           114, 89,  248,  115)

    trat <- c("FERTIL", "FERTIL", "FERTIL", "CTRL", "CTRL", "CTRL", "CTRL", "FERTIL", "FERTIL", "FERTIL", "FERTIL",
             "FERTIL", "FERTIL", "FERTIL", "FERTIL", "FERTIL", "CTRL", "CTRL", "FERTIL", "FERTIL", "FERTIL", "FERTIL",
             "FERTIL", "FERTIL", "FERTIL", "FERTIL", "FERTIL", "CTRL", "CTRL", "CTRL", "FERTIL", "FERTIL", "FERTIL",
             "FERTIL", "FERTIL", "CTRL", "CTRL", "FERTIL", "FERTIL", "CTRL", "CTRL", "CTRL", "CTRL", "CTRL",
             "CTRL", "FERTIL", "FERTIL", "FERTIL", "FERTIL", "FERTIL", "CTRL", "CTRL", "CTRL", "CTRL", "CTRL",
             "CTRL", "FERTIL", "FERTIL", "FERTIL", "FERTIL", "FERTIL", "CTRL", "CTRL", "CTRL")

    C <- c("X2062", "X2062", "X1002", "X1002", "X1002", "X1002", "X2062", "X1002", "X1002", "X1002", "X1043", "X1043",
         "X1002", "X1002", "X1043", "X1043", "X1043", "X1043", "X1043", "X1043", "X1043", "X2062", "X2062", "X2062",
         "X2062", "X2062", "X1043", "X1043", "X1043", "X1002", "X2062", "X2062", "X1002", "X1002", "X1002", "X1043",
         "X1002", "X1002", "X2062", "X1002", "X1002", "X1043", "X1043", "X2062", "X2062", "X1043", "X1043", "X1043",
         "X1002", "X1002", "X2062", "X2062", "X2062", "X2062", "X2062", "X1002", "X2062", "X2062", "X1043", "X1043",
         "X1043", "X1002", "X1002", "X1043")

    x1 <- c(1.0510557018036901233415, -0.2181436362234073500499, -1.4873429742505046569079,
            -1.4873429742505046569079, 1.0510557018036901233415, -0.2181436362234073500499,
            1.0510557018036901233415, -0.2181436362234073500499, -1.4873429742505046569079,
            1.0510557018036901233415, -1.4873429742505046569079, -0.2181436362234073500499,
            -1.4873429742505046569079, 1.0510557018036901233415, -1.4873429742505046569079,
            -0.2181436362234073500499, -1.4873429742505046569079, 1.0510557018036901233415,
            1.0510557018036901233415, -1.4873429742505046569079, -0.2181436362234073500499,
            -1.4873429742505046569079, -0.2181436362234073500499, 1.0510557018036901233415,
            1.0510557018036901233415, -0.2181436362234073500499, -1.4873429742505046569079,
            -0.2181436362234073500499, 1.0510557018036901233415, -1.4873429742505046569079,
            1.0510557018036901233415, -1.4873429742505046569079, 1.0510557018036901233415,
            -1.4873429742505046569079, -0.2181436362234073500499, -0.2181436362234073500499,
            -0.2181436362234073500499, 1.0510557018036901233415, 1.0510557018036901233415,
            -0.2181436362234073500499, 1.0510557018036901233415, 1.0510557018036901233415,
            -0.2181436362234073500499, 1.0510557018036901233415, -0.2181436362234073500499,
            1.0510557018036901233415, -1.4873429742505046569079, -0.2181436362234073500499,
            -0.2181436362234073500499, 1.0510557018036901233415, 1.0510557018036901233415,
            -0.2181436362234073500499, 1.0510557018036901233415, -0.2181436362234073500499,
            1.0510557018036901233415, 1.0510557018036901233415, -0.2181436362234073500499,
            1.0510557018036901233415, -1.4873429742505046569079, -0.2181436362234073500499,
            1.0510557018036901233415, 1.0510557018036901233415, -0.2181436362234073500499,
            -0.2181436362234073500499)

    x2 <- c(-0.16315747994073070969989, -1.05360463900379586199563, -0.93415267997080730921766
            , -0.99252850004998782740273, 0.42735235724712267169068, -0.48798991709717626230614
            , 2.23014349851008431002697, -0.21660376882282647570399, -0.72058928240081254745775
            , 1.88298518683389759509339, -0.39593086292497708944538, 0.47803447414888039501690
            , -0.87730234961981912178430, 1.45009767915056353437819, -0.64258282192604954108361
            , -0.19048163415359734007559, -0.99134159919342790256991, 0.54366244394847862420050
            , 1.66531762304370256622121, -0.79390525090304220334758, -0.01135437096435308254594
            , -1.12494052429199431486495, -0.85482479546253875568596, -0.01159930187192333150836
            , 0.75465437362335030524463, -0.54144904373718538703741, -0.85598224435921810293593
            , -0.44893610617967599774047, 1.63402389894952282389795, -1.09431441740485424496399
            , 1.22772575275634254765578, -0.88120822563015821504706, 2.18965726407797056651816
            , -0.88830486762534022204818, 0.49904785683978480914647, -0.96391262983003389575032
            , -0.84584241895151246470874, 0.01820625581143533663897, 2.04426796652258913056244
            , -0.51725662678387962500892, 0.68076969847060686547024, 0.31955573105719387028145
            , -0.76372130858969833333560, 0.48931143096917706358795, -0.63996954524487148496803
            , -0.74922815557619715232107, -1.22071057920300574117789, -1.06313667425498303842346
            , -0.39394827284068967276909, 1.14055737651990241054989, 0.08203018278837372057044
            , -0.81693043678611854119254, 0.30102881937280212554242, -0.71118362891575670481359
            , 0.16401615885635717484448, 0.07371942371769488189237, -0.34288372588738608159886
            , 2.66190601319726560802792, -0.71051489168642878446747, 0.02034948571161497923865
            , 1.92939368169321356916157, 0.75986042229322825480864, -0.70121494097762349095859
            , -0.05413653704868248706106)

    dat <- data.frame(y, trat, C, x1, x2)
    m <- glm.nb(y~trat*C + x1+ I(x1^2) + x1:trat + I(x1^2):trat+x2 , dat)

    test_that("ggeffect, decimals", {
      testthat::expect_gt(nrow(ggeffect(m, c("x1"))), 0)
      testthat::expect_gt(nrow(ggeffect(m, c("x2"))), 0)
      testthat::expect_gt(nrow(ggeffect(m, c("x1", "x2"))), 0)
      testthat::expect_gt(nrow(ggeffect(m, c("x1", "trat"))), 0)
    })

    test_that("ggemmeans, decimals", {
      testthat::expect_gt(nrow(ggemmeans(m, c("x1"))), 0)
      testthat::expect_gt(nrow(ggemmeans(m, c("x2"))), 0)
      testthat::expect_gt(nrow(ggemmeans(m, c("x1", "x2"))), 0)
      testthat::expect_gt(nrow(ggemmeans(m, c("x1", "trat"))), 0)
    })

    test_that("ggpredict, decimals", {
      testthat::expect_gt(nrow(ggpredict(m, c("x1"))), 0)
      testthat::expect_gt(nrow(ggpredict(m, c("x2"))), 0)
      testthat::expect_gt(nrow(ggpredict(m, c("x1", "x2"))), 0)
      testthat::expect_gt(nrow(ggpredict(m, c("x1", "trat"))), 0)
    })
  }

}
