% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{Server}
\alias{Server}
\title{Server class}
\description{
The \code{Server} class is the parent class for \code{\link{WebServer}} and
\code{\link{PipeServer}}. This class defines an interface and is not meant to
be instantiated.
}
\section{Methods}{


\describe{
\item{\code{stop()}}{Stops a running server.}
\item{\code{isRunning()}}{Returns TRUE if the server is currently running.}
\item{\code{getStaticPaths()}}{Returns a list of \code{\link{staticPath}}
objects for the server.
}
\item{\code{setStaticPath(..., .list = NULL)}}{Sets a static path for the
current server. Each static path can be given as a named argument, or as
an named item in \code{.list}. If there already exists a static path with
the same name, it will be replaced.
}
\item{\code{removeStaticPath(path)}}{Removes a static path with the given
name.
}
\item{\code{getStaticPathOptions()}}{Returns a list of default
\code{staticPathOptions} for the current server. Each static path will
use these options by default, but they can be overridden for each static
path.
}
\item{\code{setStaticPathOption(..., .list = NULL)}}{Sets one or more
static path options. Each option can be given as a named argument, or as
a named item in \code{.list}.
}
}
}

\seealso{
\code{\link{WebServer}} and \code{\link{PipeServer}}.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-stop}{\code{Server$stop()}}
\item \href{#method-isRunning}{\code{Server$isRunning()}}
\item \href{#method-getStaticPaths}{\code{Server$getStaticPaths()}}
\item \href{#method-setStaticPath}{\code{Server$setStaticPath()}}
\item \href{#method-removeStaticPath}{\code{Server$removeStaticPath()}}
\item \href{#method-getStaticPathOptions}{\code{Server$getStaticPathOptions()}}
\item \href{#method-setStaticPathOption}{\code{Server$setStaticPathOption()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\if{latex}{\out{\hypertarget{method-stop}{}}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isRunning"></a>}}
\if{latex}{\out{\hypertarget{method-isRunning}{}}}
\subsection{Method \code{isRunning()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$isRunning()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getStaticPaths"></a>}}
\if{latex}{\out{\hypertarget{method-getStaticPaths}{}}}
\subsection{Method \code{getStaticPaths()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$getStaticPaths()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setStaticPath"></a>}}
\if{latex}{\out{\hypertarget{method-setStaticPath}{}}}
\subsection{Method \code{setStaticPath()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$setStaticPath(..., .list = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeStaticPath"></a>}}
\if{latex}{\out{\hypertarget{method-removeStaticPath}{}}}
\subsection{Method \code{removeStaticPath()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$removeStaticPath(path)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getStaticPathOptions"></a>}}
\if{latex}{\out{\hypertarget{method-getStaticPathOptions}{}}}
\subsection{Method \code{getStaticPathOptions()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$getStaticPathOptions()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setStaticPathOption"></a>}}
\if{latex}{\out{\hypertarget{method-setStaticPathOption}{}}}
\subsection{Method \code{setStaticPathOption()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Server$setStaticPathOption(..., .list = NULL)}\if{html}{\out{</div>}}
}

}
}
