% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degseq.R
\name{is_graphical}
\alias{is_graphical}
\alias{is.graphical.degree.sequence}
\title{Is a degree sequence graphical?}
\usage{
is_graphical(out.deg, in.deg = NULL)
}
\arguments{
\item{out.deg}{Integer vector, the degree sequence for undirected graphs, or
the out-degree sequence for directed graphs.}

\item{in.deg}{\code{NULL} or an integer vector. For undireted graphs, it
should be \code{NULL}. For directed graphs it specifies the in-degrees.}
}
\value{
A logical scalar.
}
\description{
Determine whether the given vertex degrees (in- and out-degrees for
directed graphs) can be reliazed in a simple graph, i.e. a graph without
multiple or loop edges.
}
\references{
Hakimi SL: On the realizability of a set of integers as degrees
of the vertices of a simple graph. \emph{J SIAM Appl Math} 10:496-506, 1962.

PL Erdos, I Miklos and Z Toroczkai: A simple Havel-Hakimi type algorithm to
realize graphical degree sequences of directed graphs.  \emph{The Electronic
Journal of Combinatorics} 17(1):R66, 2010.
}
\seealso{
Other graphical degree sequences

g <- sample_gnp(100, 2/100)
is_degseq(degree(g))
is_graphical(degree(g)): \code{\link{is_degseq}}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com}
}
\keyword{graphs}
