% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{allowFunctions}
\alias{allowFunctions}
\title{Allow function calls without authorization}
\usage{
allowFunctions(funs = NULL)
}
\arguments{
\item{funs}{Vector of function names to be added to the list. If \code{NULL},
returns names of all currently allowed R functions.}
}
\value{
Names of all currently allowed functions if \code{funs = NULL}.
}
\description{
Adds R function names to the list of functions, that
can be called from a web page without manual confirmation on the R side.
}
\details{
This function is a wrapper around \code{allowFunctions} method of class \code{\link{App}}.
}
\examples{
\dontrun{
# to run this example an installed web browser is required
openPage()
allowFunctions(c("myFunction1", "print", "someObject$method"))
funs <- allowFunctions()
closePage()}

}
\seealso{
\code{\link{allowVariables}}, \code{\link{authorize}}, \code{\link{openPage}} (check argument
\code{allowedFunctions}), \code{\link{callFunction}}.
}
