% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{with.mids}
\alias{with.mids}
\title{Evaluate an expression in multiple imputed datasets}
\usage{
\method{with}{mids}(data, expr, ...)
}
\arguments{
\item{data}{An object of type \code{mids}, which stands for 'multiply imputed
data set', typically created by a call to function \code{mice()}.}

\item{expr}{An expression with a formula object, with the response on the
left of a \code{~} operator, and the terms, separated by \code{+} operators,
on the right. See the documentation of \code{\link{lm}} and
\code{\link{formula}} for details.}

\item{\dots}{Additional parameters passed to \code{expr}}
}
\value{
A list object of S3 class \code{mira}
}
\description{
Performs a computation of each of imputed datasets in data.
}
\examples{


imp <- mice(nhanes2)
fit1 <- with(data=imp,exp=lm(bmi~age+hyp+chl))
fit2 <- with(data=imp,exp=glm(hyp~age+bmi+chl,family=binomial))
anova.imp <- with(data=imp,exp=anova(lm(bmi~age+hyp+chl)))
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=mids-class]{mids}}, \code{\link[=mira-class]{mira}}, \code{\link{pool}},
\code{\link{D1}}, \code{\link{D3}}, \code{\link{pool.r.squared}}
}
\author{
Karin Oudshoorn, Stef van Buuren 2009-2012
}
\keyword{multivariate}
