%     The multitaper R package
%     Multitaper and spectral analysis package for R
%     Copyright (C) 2011 Karim Rahim 
%
%     Written by Karim Rahim and Wesley Burr.
%
%     This file is part of the multitaper package for R.
%
%     The multitaper package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The multitaper package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with multitaper.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     karim.rahim@gmail.com

\name{plot.mtm}
\alias{plot.mtm}
\title{Compute and plot the multitaper spectrum estimate}
\description{
   Plots the multitaper spectral estimate and the multitaper F-test.
}
\usage{
\method{plot}{mtm}(x, jackknife = FALSE, Ftest = FALSE, ftbase = 1.01, siglines = NULL, ...) 
}
\arguments{
  \item{x}{An object of the class mtm generated by spec.mtm.}
  \item{jackknife}{Boolean variable indicating if jackknife
    confidence intervals should be plotted, only applies if Ftest=FALSE.}
  \item{Ftest}{Boolean variable indicating if the multitaper harmonic F-test
    should be plotted instead of the spectrum.}
  \item{ftbase}{Lowest value to be plotted when the F-test is
    plotted. When Ftest = TRUE, max(ftestvalue, ftbase) is plotted.}
  \item{siglines}{Vector of significance values (as probabilities, 0.0 to 1.0) 
    to plot as horizontal significance lines on the F-test plot. }
  \item{...}{Arguments to be passed to methods, such as graphical
    parameters (see 'par').}
}
\details{
  The value log can be set to \dQuote{yes} (default), \dQuote{no}, or \dQuote{dB}
  as in the function plot.spec.}
\seealso{ \code{\link{spec.mtm}} and \code{\link{plot.spec}} }
\references{
Thomson, D.J (1982)
Spectrum estimation and harmonic analysis. \emph{Proceedings of the IEEE}
Volume \bold{70}, number 9, pp. 1055--1096.

Percival, D.B. and Walden, A.T. (1993)
\emph{Spectral analysis for physical applications}
Cambridge University Press. 
}
\examples{
data(willamette)
resSpec <- spec.mtm(willamette, nw=4.0, k=8, Ftest=TRUE, plot=FALSE, deltat=1.0, dtUnits="month")
plot(resSpec)
plot(resSpec, Ftest=TRUE)
plot(resSpec, Ftest=TRUE, siglines=c(0.90, 0.99))

# with jackknife estimate
resSpec2 <- spec.mtm(willamette, nw=4.0, k=8, Ftest=TRUE, jackknife=TRUE, plot=FALSE,
                     deltat=1.0, dtUnits="month")
plot(resSpec2,jackknife=TRUE)

}
\keyword{multitaper}
