% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{renameWorksheet}
\alias{renameWorksheet}
\title{Rename a worksheet}
\usage{
renameWorksheet(wb, sheet, newName)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet}

\item{sheet}{The name or index of the worksheet to rename}

\item{newName}{The new name of the worksheet. No longer than 31 chars.}
}
\description{
Rename a worksheet
}
\details{
DEPRECATED. Use \code{\link[=names]{names()}}
}
\examples{

## Create a new workbook
wb <- createWorkbook("CREATOR")

## Add 3 worksheets
addWorksheet(wb, "Worksheet Name")
addWorksheet(wb, "This is worksheet 2")
addWorksheet(wb, "Not the best name")

#' ## rename all worksheets
names(wb) <- c("A", "B", "C")


## Rename worksheet 1 & 3
renameWorksheet(wb, 1, "New name for sheet 1")
names(wb)[[1]] <- "New name for sheet 1"
names(wb)[[3]] <- "A better name"

## Save workbook
\dontrun{
saveWorkbook(wb, "renameWorksheetExample.xlsx", overwrite = TRUE)
}
}
\author{
Alexander Walker
}
