% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_debug.R
\name{handler_debug}
\alias{handler_debug}
\title{Progression Handler: Progress Reported as Debug Information (Text) in the Terminal}
\usage{
handler_debug(
  interval = getOption("progressr.interval", 0),
  intrusiveness = getOption("progressr.intrusiveness.debug", 0),
  target = "terminal",
  uuid = FALSE,
  ...
)
}
\arguments{
\item{interval}{(numeric) The minimum time (in seconds) between
successive progression updates from this handler.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{uuid}{If TRUE, then the progressor UUID and the owner UUID are shown,
otherwise not (default).}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
Progression Handler: Progress Reported as Debug Information (Text) in the Terminal
}
\section{Appearance}{

Below is how this progress handler renders by default at 0\%, 30\% and 99\%
progress:

With \code{handlers(handler_debug())}:\if{html}{\out{<div class="sourceCode r">}}\preformatted{[21:27:11.236] (0.000s => +0.001s) initiate: 0/100 (+0) '' \{clear=TRUE, enabled=TRUE, status=\}
[21:27:11.237] (0.001s => +0.000s) update: 0/100 (+0) 'Starting' \{clear=TRUE, enabled=TRUE, status=\}
[21:27:14.240] (3.004s => +0.002s) update: 30/100 (+30) 'Importing' \{clear=TRUE, enabled=TRUE, status=\}
[21:27:16.245] (5.009s => +0.001s) update: 100/100 (+70) 'Summarizing' \{clear=TRUE, enabled=TRUE, status=\}
[21:27:16.246] (5.010s => +0.003s) update: 100/100 (+0) 'Summarizing' \{clear=TRIE, enabled=TRUE, status=\}
}\if{html}{\out{</div>}}
}

\examples{
handlers("debug")
with_progress({ y <- slow_sum(1:10) })
print(y)
}
