% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.R
\name{arg_match}
\alias{arg_match}
\title{Match an argument to a character vector}
\usage{
arg_match(arg, values = NULL)
}
\arguments{
\item{arg}{A symbol referring to an argument accepting strings.}

\item{values}{The possible values that \code{arg} can take. If \code{NULL},
the values are taken from the function definition of the \link[=caller_frame]{caller
frame}.}
}
\value{
The string supplied to \code{arg}.
}
\description{
This is equivalent to \code{\link[base:match.arg]{base::match.arg()}} with a few differences:
\itemize{
\item Partial matches trigger an error.
\item Error messages are a bit more informative and obey the tidyverse
standards.
}
}
\examples{
fn <- function(x = c("foo", "bar")) arg_match(x)
fn("bar")

# This would throw an informative error if run:
# fn("b")
# fn("baz")
}
