% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_set.R
\name{validation_set}
\alias{validation_set}
\alias{analysis.val_split}
\alias{assessment.val_split}
\alias{training.val_split}
\alias{validation.val_split}
\alias{testing.val_split}
\title{Create a Validation Split for Tuning}
\usage{
validation_set(split, ...)

\method{analysis}{val_split}(x, ...)

\method{assessment}{val_split}(x, ...)

\method{training}{val_split}(x, ...)

\method{validation}{val_split}(x, ...)

\method{testing}{val_split}(x, ...)
}
\arguments{
\item{split}{An object of class \code{initial_validation_split}, such as resulting
from \code{\link[=initial_validation_split]{initial_validation_split()}} or \code{\link[=group_initial_validation_split]{group_initial_validation_split()}}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{x}{An \code{rsplit} object produced by \code{validation_set()}.}
}
\value{
An tibble with classes \code{validation_set}, \code{rset}, \code{tbl_df}, \code{tbl}, and
\code{data.frame}. The results include a column for the data split object and a
column called \code{id} that has a character string with the resample identifier.
}
\description{
Create a Validation Split for Tuning
}
\examples{
set.seed(1353)
car_split <- initial_validation_split(mtcars)
car_set <- validation_set(car_split)
}
