% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminal.R
\name{terminalBusy}
\alias{terminalBusy}
\title{Is Terminal Busy}
\usage{
terminalBusy(id)
}
\arguments{
\item{id}{The terminal id. The \code{id} is obtained from
\code{\link{terminalList}()}, \code{\link{terminalVisible}()},
\code{\link{terminalCreate}()}, or \code{\link{terminalExecute}()}.}
}
\value{
a boolean
}
\description{
Are terminals reporting that they are busy?
}
\note{
The \code{terminalBusy} function was added in version 1.1.350 of RStudio.
}
\examples{
\dontrun{
# create a hidden terminal and run a lengthy command
termId <- rstudioapi::terminalCreate(show = FALSE)
rstudioapi::terminalSend(termId, "sleep 5\n")

# wait until a busy terminal is finished
while (rstudioapi::terminalBusy(termId)) {
  Sys.sleep(0.1)
}
print("Terminal available")
}
}
