% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.statcheck.R
\name{identify.statcheck}
\alias{identify.statcheck}
\title{Identify specific points in a statcheck plot.}
\usage{
\method{identify}{statcheck}(x, alpha = 0.05, ...)
}
\arguments{
\item{x}{A statcheck object. See \code{\link{statcheck}}.}

\item{alpha}{assumed level of significance in the scanned texts. Defaults to 
.05.}

\item{...}{arguments to be passed to methods, such as graphical parameters 
(see \code{\link{par}}).}
}
\description{
With this function you can simply point and click on the datapoints in the 
plot to see the corresponding statcheck details, such as the paper from which 
the data came and the exact statistical results.
}
\examples{
\dontrun{

# First we need a statcheck object
# Here, we create one by running statcheck on some raw text

txt <- "This test is consistent t(28) = 0.2, p = .84, but this one is 
inconsistent: F(2, 28) = 4.2, p = .01. This final test is even a
gross/decision inconsistency: z = 1.23, p = .03"

result <- statcheck(txt)

# Now, we can run identify.statcheck(), or shorter, simply identify():
identify(result)

# Further instructions:
# click on one or multiple points of interest
# press Esc
# a dataframe with information on the selected points will appear

}

}
