% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sci2comm.R
\name{sci2comm}
\alias{sci2comm}
\alias{sci2comm.default}
\alias{sci2comm.uid}
\alias{sci2comm.tsn}
\alias{sci2comm.wormsid}
\alias{sci2comm.iucn}
\title{Get common names from scientific names.}
\usage{
sci2comm(...)

\method{sci2comm}{default}(sci, db = "ncbi", simplify = TRUE, scinames = NULL, ...)

\method{sci2comm}{uid}(id, ...)

\method{sci2comm}{tsn}(id, simplify = TRUE, ...)

\method{sci2comm}{wormsid}(id, simplify = TRUE, ...)

\method{sci2comm}{iucn}(id, simplify = TRUE, ...)
}
\arguments{
\item{...}{Further arguments passed on to functions \code{\link[=get_uid]{get_uid()}},
\code{\link[=get_tsn]{get_tsn()}}.}

\item{sci}{character; One or more scientific names or partial names.}

\item{db}{character; Data source, one of \code{"ncbi"} (default),
\code{"itis"} \code{"eol"}, \code{"worms"}, or \code{"iucn"}. Note that
each taxonomic data source has their own identifiers,  so that if you
provide the wrong \code{db} value for the identifier you could get a
result, but it will likely be wrong (not what you were expecting).
If using ncbi or iucn we recommend getting an API key;
see \link{taxize-authentication}}

\item{simplify}{(logical) If TRUE, simplify output to a vector of names.
If FALSE, return variable formats from different sources, usually a
data.frame. Only applies to eol and itis. Specify \code{FALSE} to obtain
the language of each vernacular in the output for eol and itis.}

\item{scinames}{Deprecated, see \code{sci}}

\item{id}{character; identifiers, as returned by \code{\link[=get_tsn]{get_tsn()}},
\code{\link[=get_uid]{get_uid()}}.}
}
\value{
List of character vectors, named by input taxon name,
or taxon ID. \code{character(0)} on no match
}
\description{
Get common names from scientific names.
}
\section{Authentication}{

See \link{taxize-authentication} for help on authentication
}

\section{HTTP version for NCBI requests}{

We hard code \code{http_version = 2L} to use HTTP/1.1 in HTTP requests to
the Entrez API. See \code{curl::curl_symbols('CURL_HTTP_VERSION')}
}

\examples{
\dontrun{
sci2comm(sci='Helianthus annuus')
sci2comm(sci='Helianthus annuus', db='eol')
sci2comm(sci=c('Helianthus annuus', 'Poa annua'))
sci2comm(sci='Puma concolor', db='ncbi')
sci2comm('Gadus morhua', db='worms')
sci2comm('Pomatomus saltatrix', db='worms')
sci2comm('Loxodonta africana', db='iucn')

# Passing id in, works for sources: itis and ncbi, not eol
sci2comm(get_uid('Helianthus annuus'))
sci2comm(get_wormsid('Gadus morhua'))
sci2comm(get_iucn('Loxodonta africana'))

# Don't simplify returned
sci2comm(get_iucn('Loxodonta africana'), simplify=FALSE)

# Use curl options
sci2comm('Helianthus annuus', db="ncbi", verbose = TRUE)
}
}
\seealso{
\code{\link[=comm2sci]{comm2sci()}}
}
\author{
Scott Chamberlain (myrmecocystus@gmail.com)
}
