% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_handler.R
\name{RequestHandler}
\alias{RequestHandler}
\title{RequestHandler}
\description{
Base handler for http requests, deciding whether a
request is stubbed, to be ignored, recordable, or unhandled
}
\details{
\strong{Private Methods}
\describe{
\item{\code{request_type(request)}}{
Get the request type
}
\item{\code{externally_stubbed()}}{
just returns FALSE
}
\item{\code{should_ignore()}}{
should we ignore the request, depends on request ignorer
infrastructure that's not working yet
}
\item{\code{has_response_stub()}}{
Check if there is a matching response stub in the
http interaction list
}
\item{\code{get_stubbed_response()}}{
Check for a response and get it
}
\item{\code{request_summary(request)}}{
get a request summary
}
\item{\code{on_externally_stubbed_request(request)}}{
on externally stubbed request do nothing
}
\item{\code{on_ignored_request(request)}}{
on ignored request, do something
}
\item{\code{on_recordable_request(request)}}{
on recordable request, record the request
}
\item{\code{on_unhandled_request(request)}}{
on unhandled request, run UnhandledHTTPRequestError
}
}
}
\examples{
\dontrun{
# record mode: once
vcr_configure(
 dir = tempdir(),
 record = "once"
)

data(crul_request)
crul_request$url$handle <- curl::new_handle()
crul_request
x <- RequestHandler$new(crul_request)
# x$handle()

# record mode: none
vcr_configure(
 dir = tempdir(),
 record = "none"
)
data(crul_request)
crul_request$url$handle <- curl::new_handle()
crul_request
insert_cassette("testing_record_mode_none", record = "none")
file.path(vcr_c$dir, "testing_record_mode_none.yml")
x <- RequestHandlerCrul$new(crul_request)
# x$handle()
crul_request$url$url <- "https://api.crossref.org/works/10.1039/c8sm90002g/"
crul_request$url$handle <- curl::new_handle()
z <- RequestHandlerCrul$new(crul_request)
# z$handle()
eject_cassette("testing_record_mode_none")
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request_original}}{original, before any modification}

\item{\code{request}}{the request, after any modification}

\item{\code{vcr_response}}{holds \link{VcrResponse} object}

\item{\code{stubbed_response}}{the stubbed response}

\item{\code{cassette}}{the cassette holder}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RequestHandler$new()}}
\item \href{#method-handle}{\code{RequestHandler$handle()}}
\item \href{#method-clone}{\code{RequestHandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{RequestHandler} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandler$new(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request from an object of class \code{HttpInteraction}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RequestHandler} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-handle"></a>}}
\subsection{Method \code{handle()}}{
Handle the request (\code{request} given in \verb{$initialize()})
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandler$handle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
handles a request, outcomes vary
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
