% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finite.R
\name{wkt_has_missing}
\alias{wkt_has_missing}
\alias{wkb_has_missing}
\alias{wkt_is_finite}
\alias{wkb_is_finite}
\title{Test well-known geometries for missing and non-finite coordinates}
\usage{
wkt_has_missing(wkt)

wkb_has_missing(wkb)

wkt_is_finite(wkt)

wkb_is_finite(wkb)
}
\arguments{
\item{wkt}{A character vector containing well-known text.}

\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{sf::st_as_binary()}.}
}
\value{
A logical vector with the same length as the input.
}
\description{
Note that EMTPY geometries are considered finite and non-missing.
Use the \code{size} column of \code{\link[=wkt_meta]{wkt_meta()}} to test for empty geometries.
}
\examples{
wkt_has_missing("POINT (0 1)")
wkt_has_missing("POINT (nan nan)")
wkt_has_missing("POINT (inf inf)")

wkt_is_finite("POINT (0 1)")
wkt_is_finite("POINT (nan nan)")
wkt_is_finite("POINT (inf inf)")

}
