// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class PortForwardingInfo : ICloneable {
    public object Clone() {
      PortForwardingInfo copy = new PortForwardingInfo();
      copy.enabled = this.enabled;
      copy.nodeIndexValid = this.nodeIndexValid;
      copy.nodeIndex = this.nodeIndex;
      copy.slaveConnected = this.slaveConnected;
      copy.masterDownstreamIfName = this.masterDownstreamIfName;
      copy.masterIPv4AddrInfos = this.masterIPv4AddrInfos;
      copy.masterIPv6AddrInfos = this.masterIPv6AddrInfos;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["nodeIndexValid"] = this.nodeIndexValid;
      json["nodeIndex"] = this.nodeIndex;
      json["slaveConnected"] = this.slaveConnected;
      json["masterDownstreamIfName"] = this.masterDownstreamIfName;
      json["masterIPv4AddrInfos"] = new JsonArray(this.masterIPv4AddrInfos.Select(
        _value => (JsonValue)(_value.Encode())));
      json["masterIPv6AddrInfos"] = new JsonArray(this.masterIPv6AddrInfos.Select(
        _value => (JsonValue)(_value.Encode())));
      return json;
    }

    public static PortForwardingInfo Decode(LightJson.JsonObject json, Agent agent) {
      PortForwardingInfo inst = new PortForwardingInfo();
      inst.enabled = (bool)json["enabled"];
      inst.nodeIndexValid = (bool)json["nodeIndexValid"];
      inst.nodeIndex = (int)json["nodeIndex"];
      inst.slaveConnected = (bool)json["slaveConnected"];
      inst.masterDownstreamIfName = (string)json["masterDownstreamIfName"];
      inst.masterIPv4AddrInfos = new System.Collections.Generic.List<Com.Raritan.Idl.net.PortForwardingMasterAddrInfo>(json["masterIPv4AddrInfos"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.net.PortForwardingMasterAddrInfo.Decode(_value, agent)));
      inst.masterIPv6AddrInfos = new System.Collections.Generic.List<Com.Raritan.Idl.net.PortForwardingMasterAddrInfo>(json["masterIPv6AddrInfos"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.net.PortForwardingMasterAddrInfo.Decode(_value, agent)));
      return inst;
    }

    public bool enabled = false;
    public bool nodeIndexValid = false;
    public int nodeIndex = 0;
    public bool slaveConnected = false;
    public string masterDownstreamIfName = "";
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.net.PortForwardingMasterAddrInfo> masterIPv4AddrInfos = new System.Collections.Generic.List<Com.Raritan.Idl.net.PortForwardingMasterAddrInfo>();
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.net.PortForwardingMasterAddrInfo> masterIPv6AddrInfos = new System.Collections.Generic.List<Com.Raritan.Idl.net.PortForwardingMasterAddrInfo>();
  }
}
