/*
 *	beget - search for Life patterns
 *	ansi functions
 *
 *	This file contains functions for use with non-ANSI conforming systems
 *	to implement absent ANSI functionality.
 */

#if 1 /* ndef __STDC__ */

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <main.h>


/*
 *  NAME
 *      strerror - string for error number
 *
 *  SYNOPSIS
 *      char *strerror(int errnum);
 *
 *  DESCRIPTION
 *      The strerror function maps the error number in errnum to an error
 *      message string.
 *
 *  RETURNS
 *      The strerror function returns a pointer to the string, the contents of
 *      which are implementation-defined.  The array pointed to shall not be
 *      modified by the program, but may be overwritten by a subsequent call to
 *      the strerror function.
 *
 *  CAVEAT
 *      Unknown errors will be rendered in the form "Error %d", where %d will
 *      be replaced by a decimal representation of the error number.
 */

#ifndef strerror

char *
strerror(n)
	int	n;
{
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char buffer[16];

	if (n < 1 || n > sys_nerr)
	{
		sprintf(buffer, "Error %d", n);
		return buffer;
	}
	return sys_errlist[n];
}

#endif
#endif /* __STDC__ */
