
#line 1 "ragel/i18n/hi.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/hi.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_hi/gherkin_lexer_hi.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 13, 23, 24, 25, 26, 
	27, 28, 29, 30, 32, 34, 45, 46, 
	47, 49, 51, 56, 61, 66, 71, 75, 
	79, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 90, 91, 92, 93, 94, 95, 
	96, 101, 108, 113, 117, 123, 126, 128, 
	134, 145, 146, 147, 148, 149, 150, 151, 
	152, 153, 154, 155, 156, 157, 158, 159, 
	160, 161, 162, 163, 170, 172, 174, 176, 
	178, 180, 182, 184, 186, 188, 190, 192, 
	194, 196, 198, 200, 202, 204, 206, 208, 
	219, 220, 221, 223, 224, 225, 226, 227, 
	228, 229, 230, 231, 232, 233, 234, 235, 
	236, 237, 238, 239, 240, 241, 242, 243, 
	244, 245, 246, 247, 248, 249, 250, 251, 
	252, 253, 254, 255, 258, 259, 261, 262, 
	264, 265, 267, 268, 269, 270, 271, 272, 
	273, 274, 275, 276, 277, 278, 279, 280, 
	281, 282, 284, 285, 286, 287, 288, 289, 
	290, 291, 292, 293, 294, 295, 296, 297, 
	298, 299, 300, 301, 302, 303, 304, 305, 
	306, 307, 308, 317, 319, 329, 331, 333, 
	335, 337, 339, 341, 343, 345, 347, 350, 
	352, 354, 356, 358, 360, 362, 364, 366, 
	368, 370, 372, 374, 376, 378, 380, 382, 
	384, 386, 388, 390, 392, 394, 396, 398, 
	400, 402, 404, 406, 408, 410, 412, 414, 
	418, 420, 422, 424, 427, 429, 432, 434, 
	436, 438, 440, 442, 444, 446, 448, 450, 
	452, 454, 456, 458, 460, 462, 464, 466, 
	468, 470, 472, 474, 476, 478, 480, 482, 
	484, 486, 488, 490, 492, 494, 496, 498, 
	500, 502, 504, 506, 508, 510, 512, 514, 
	516, 518, 520, 522, 524, 526, 528, 530, 
	531, 532, 541, 543, 553, 555, 557, 559, 
	561, 563, 565, 567, 569, 571, 574, 576, 
	578, 580, 582, 584, 586, 588, 590, 592, 
	594, 596, 598, 600, 602, 604, 606, 608, 
	610, 612, 614, 616, 618, 620, 622, 624, 
	626, 628, 630, 632, 634, 636, 638, 642, 
	644, 647, 649, 652, 654, 657, 659, 661, 
	663, 665, 667, 669, 671, 673, 675, 677, 
	679, 681, 683, 685, 687, 690, 692, 694, 
	696, 698, 700, 702, 704, 706, 708, 710, 
	712, 714, 716, 718, 720, 722, 724, 726, 
	728, 730, 732, 734, 736, 738, 740, 742, 
	744, 746, 748, 750, 752, 754, 756, 758, 
	760, 762, 764, 766, 768, 770, 772, 774, 
	776, 778, 780, 782, 784, 786, 788, 790, 
	792, 794, 796, 798, 800, 802, 804, 806, 
	808, 810, 812, 814, 816, 818, 820, 822, 
	824, 826, 828, 830, 832, 834, 836, 838, 
	840, 842, 844, 845, 846, 847, 848, 849, 
	850, 851, 852, 853, 854, 855, 856, 857, 
	858, 859, 860, 861, 862, 863, 864, 865, 
	866, 867, 868, 869, 878, 880, 890, 892, 
	894, 896, 898, 900, 902, 904, 906, 908, 
	911, 913, 915, 917, 919, 921, 923, 925, 
	927, 929, 931, 933, 935, 937, 939, 941, 
	943, 945, 947, 949, 951, 953, 955, 957, 
	959, 961, 963, 965, 967, 969, 971, 973, 
	975, 979, 981, 983, 985, 988, 990, 993, 
	995, 997, 999, 1001, 1003, 1005, 1007, 1009, 
	1011, 1013, 1015, 1017, 1019, 1021, 1023, 1026, 
	1028, 1030, 1032, 1034, 1036, 1038, 1040, 1042, 
	1044, 1046, 1048, 1050, 1052, 1054, 1056, 1058, 
	1060, 1062, 1064, 1066, 1068, 1070, 1072, 1074, 
	1076, 1078, 1080, 1082, 1084, 1086, 1088, 1090, 
	1092, 1094, 1096, 1098, 1100, 1102, 1104, 1106, 
	1108, 1110, 1112, 1114, 1116, 1118, 1120, 1122, 
	1124, 1126, 1128, 1130, 1132, 1134, 1136, 1137, 
	1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 
	1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 
	1154, 1155, 1156, 1157, 1158, 1166, 1168, 1172, 
	1174, 1176, 1178, 1180, 1182, 1184, 1186, 1188, 
	1190, 1192, 1194, 1196, 1198, 1200, 1202, 1204, 
	1206, 1209, 1211, 1213, 1215, 1217, 1219, 1221, 
	1223, 1225, 1227, 1229, 1231, 1233, 1235, 1237, 
	1239, 1241, 1243, 1245, 1247, 1250, 1252, 1254, 
	1256, 1258, 1260, 1262, 1264, 1266, 1268, 1270, 
	1272, 1274, 1276, 1278, 1280, 1282, 1284, 1286, 
	1288, 1290, 1292, 1294, 1296, 1298, 1300, 1302, 
	1304, 1306, 1308, 1310, 1312, 1314, 1316, 1318, 
	1320, 1322, 1324, 1326, 1328, 1330, 1332, 1334, 
	1336, 1338, 1340, 1342, 1344, 1346, 1348, 1350, 
	1352, 1354, 1356, 1358, 1360, 1362, 1364, 1366, 
	1368, 1370, 1372, 1374, 1376, 1378, 1380, 1382, 
	1384, 1386, 1388, 1390, 1392, 1394, 1396, 1397, 
	1398
};

static const char _lexer_trans_keys[] = {
	-32, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -92, -123, -119, -108, 
	-107, -102, -100, -92, -86, -81, -80, -32, 
	-92, -105, -32, -92, -80, 32, 10, 13, 
	10, 13, -32, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, 34, 34, 10, 
	13, 10, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 9, 13, 10, 32, 9, 13, 10, 
	13, 10, 95, 70, 69, 65, 84, 85, 
	82, 69, 95, 69, 78, 68, 95, 37, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 32, 124, 9, 13, 10, 32, 92, 
	124, 9, 13, 10, 92, 124, 10, 92, 
	10, 32, 92, 124, 9, 13, -32, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -32, -92, -90, -32, -92, -66, -32, 
	-92, -71, -32, -92, -80, -32, -92, -93, 
	58, 10, 10, -32, 10, 32, 35, 124, 
	9, 13, -92, 10, -80, 10, -32, 10, 
	-91, 10, -126, 10, -32, 10, -92, 10, 
	-86, 10, 10, 32, -32, 10, -92, 10, 
	-78, 10, -32, 10, -91, 10, -121, 10, 
	-32, 10, -92, 10, -106, 10, 10, 58, 
	-32, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -32, -92, -90, -65, -32, 
	-92, -66, -32, -92, -88, -32, -91, -115, 
	-32, -92, -92, -32, -91, -127, -32, -91, 
	-126, -32, -92, -126, -32, -92, -107, -32, 
	-92, -65, -32, -92, -84, -32, -92, -84, 
	-91, -90, -32, -92, -91, -80, -32, 32, 
	-92, -88, -65, -32, -92, -90, -32, -91, 
	-125, -32, -92, -74, -32, -91, -115, -32, 
	-92, -81, 32, 58, -32, -92, -80, -32, 
	-91, -126, -32, -92, -86, -32, -92, -80, 
	-32, -91, -121, -32, -92, -106, -32, -92, 
	-66, 58, 10, 10, -32, 10, 32, 35, 
	37, 42, 64, 9, 13, -92, 10, -123, 
	-108, -107, -102, -100, -92, -86, -81, -80, 
	10, -32, 10, -92, 10, -105, 10, -32, 
	10, -92, 10, -80, 10, 10, 32, -32, 
	10, -92, 10, -90, -65, 10, -32, 10, 
	-92, 10, -66, 10, -32, 10, -92, 10, 
	-88, 10, -32, 10, -91, 10, -115, 10, 
	-32, 10, -92, 10, -92, 10, -32, 10, 
	-91, 10, -127, 10, -32, 10, -91, 10, 
	-126, 10, -32, 10, -92, 10, -126, 10, 
	-32, 10, -92, 10, -107, 10, -32, 10, 
	-92, 10, -65, 10, -32, 10, -92, 10, 
	-84, 10, -32, 10, -92, 10, -84, 10, 
	-91, -90, -32, 10, -92, 10, -80, 10, 
	-32, 10, 32, -92, 10, -88, -65, 10, 
	-32, 10, -92, 10, -90, 10, -32, 10, 
	-91, 10, -125, 10, -32, 10, -92, 10, 
	-74, 10, -32, 10, -91, 10, -115, 10, 
	-32, 10, -92, 10, -81, 10, 10, 58, 
	-32, 10, -92, 10, -90, 10, -32, 10, 
	-91, 10, -126, 10, -32, 10, -92, 10, 
	-86, 10, 10, 32, -32, 10, -92, 10, 
	-78, 10, -32, 10, -91, 10, -121, 10, 
	-32, 10, -92, 10, -106, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, 10, 10, -32, 10, 32, 35, 
	37, 42, 64, 9, 13, -92, 10, -123, 
	-108, -107, -102, -100, -92, -86, -81, -80, 
	10, -32, 10, -92, 10, -105, 10, -32, 
	10, -92, 10, -80, 10, 10, 32, -32, 
	10, -92, 10, -90, -65, 10, -32, 10, 
	-92, 10, -66, 10, -32, 10, -92, 10, 
	-88, 10, -32, 10, -91, 10, -115, 10, 
	-32, 10, -92, 10, -92, 10, -32, 10, 
	-91, 10, -127, 10, -32, 10, -91, 10, 
	-126, 10, -32, 10, -92, 10, -126, 10, 
	-32, 10, -92, 10, -107, 10, -32, 10, 
	-92, 10, -65, 10, -32, 10, -92, 10, 
	-84, 10, -32, 10, -92, 10, -84, 10, 
	-91, -90, -32, 10, -92, -91, 10, -80, 
	10, -32, 10, 32, -92, 10, -88, -65, 
	10, -32, 10, -92, 10, -90, 10, -32, 
	10, -91, 10, -125, 10, -32, 10, -92, 
	10, -74, 10, -32, 10, -91, 10, -115, 
	10, -32, 10, -92, 10, -81, 10, 10, 
	32, 58, -32, 10, -92, 10, -80, 10, 
	-32, 10, -91, 10, -126, 10, -32, 10, 
	-92, 10, -86, 10, -32, 10, -92, 10, 
	-80, 10, -32, 10, -91, 10, -121, 10, 
	-32, 10, -92, 10, -106, 10, -32, 10, 
	-92, 10, -66, 10, 10, 58, -125, 10, 
	-32, 10, -92, 10, -73, 10, -32, 10, 
	-91, 10, -115, 10, -32, 10, -92, 10, 
	-96, 10, -32, 10, -92, 10, -83, 10, 
	-32, 10, -91, 10, -126, 10, -32, 10, 
	-92, 10, -82, 10, -32, 10, -92, 10, 
	-65, 10, -32, 10, -92, 10, -90, 10, 
	-32, 10, -91, 10, -126, 10, -32, 10, 
	-92, 10, -86, 10, 10, 32, -32, 10, 
	-92, 10, -78, 10, -32, 10, -91, 10, 
	-121, 10, -32, 10, -92, 10, -106, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -125, -32, -92, -73, 
	-32, -91, -115, -32, -92, -96, -32, -92, 
	-83, -32, -91, -126, -32, -92, -82, -32, 
	-92, -65, 58, 10, 10, -32, 10, 32, 
	35, 37, 42, 64, 9, 13, -92, 10, 
	-123, -108, -107, -102, -100, -92, -86, -81, 
	-80, 10, -32, 10, -92, 10, -105, 10, 
	-32, 10, -92, 10, -80, 10, 10, 32, 
	-32, 10, -92, 10, -90, -65, 10, -32, 
	10, -92, 10, -66, 10, -32, 10, -92, 
	10, -88, 10, -32, 10, -91, 10, -115, 
	10, -32, 10, -92, 10, -92, 10, -32, 
	10, -91, 10, -127, 10, -32, 10, -91, 
	10, -126, 10, -32, 10, -92, 10, -126, 
	10, -32, 10, -92, 10, -107, 10, -32, 
	10, -92, 10, -65, 10, -32, 10, -92, 
	10, -84, 10, -32, 10, -92, 10, -84, 
	10, -91, -90, -32, 10, -92, 10, -80, 
	10, -32, 10, 32, -92, 10, -88, -65, 
	10, -32, 10, -92, 10, -90, 10, -32, 
	10, -91, 10, -125, 10, -32, 10, -92, 
	10, -74, 10, -32, 10, -91, 10, -115, 
	10, -32, 10, -92, 10, -81, 10, 10, 
	32, 58, -32, 10, -92, 10, -80, 10, 
	-32, 10, -91, 10, -126, 10, -32, 10, 
	-92, 10, -86, 10, -32, 10, -92, 10, 
	-80, 10, -32, 10, -91, 10, -121, 10, 
	-32, 10, -92, 10, -106, 10, -32, 10, 
	-92, 10, -66, 10, 10, 58, -32, 10, 
	-92, 10, -90, 10, -32, 10, -91, 10, 
	-126, 10, -32, 10, -92, 10, -86, 10, 
	10, 32, -32, 10, -92, 10, -78, 10, 
	-32, 10, -91, 10, -121, 10, -32, 10, 
	-92, 10, -106, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-32, -92, -90, -32, -91, -126, -32, -92, 
	-86, 32, -32, -92, -78, -32, -91, -121, 
	-32, -92, -106, 58, 10, 10, -32, 10, 
	32, 35, 37, 64, 9, 13, -92, 10, 
	-119, -86, -80, 10, -32, 10, -92, 10, 
	-90, 10, -32, 10, -92, 10, -66, 10, 
	-32, 10, -92, 10, -71, 10, -32, 10, 
	-92, 10, -80, 10, -32, 10, -92, 10, 
	-93, 10, 10, 58, -32, 10, -92, -91, 
	10, -80, 10, -32, 10, -92, 10, -65, 
	10, -32, 10, -92, 10, -90, 10, -32, 
	10, -91, 10, -125, 10, -32, 10, -92, 
	10, -74, 10, -32, 10, -91, 10, -115, 
	10, -32, 10, -92, 10, -81, 10, 10, 
	32, 58, -32, 10, -92, 10, -80, 10, 
	-32, 10, -91, 10, -126, 10, -32, 10, 
	-92, 10, -86, 10, -32, 10, -92, 10, 
	-80, 10, -32, 10, -91, 10, -121, 10, 
	-32, 10, -92, 10, -106, 10, -32, 10, 
	-92, 10, -66, 10, -125, 10, -32, 10, 
	-92, 10, -73, 10, -32, 10, -91, 10, 
	-115, 10, -32, 10, -92, 10, -96, 10, 
	-32, 10, -92, 10, -83, 10, -32, 10, 
	-91, 10, -126, 10, -32, 10, -92, 10, 
	-82, 10, -32, 10, -92, 10, -65, 10, 
	-32, 10, -91, 10, -126, 10, -32, 10, 
	-92, 10, -86, 10, 10, 32, -32, 10, 
	-92, 10, -78, 10, -32, 10, -91, 10, 
	-121, 10, -32, 10, -92, 10, -106, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 1, 10, 1, 1, 1, 1, 
	1, 1, 1, 2, 2, 9, 1, 1, 
	2, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	9, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 9, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 2, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 7, 2, 10, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 7, 2, 10, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 3, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 2, 10, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 6, 2, 4, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 14, 25, 27, 29, 31, 
	33, 35, 37, 39, 42, 45, 56, 58, 
	60, 63, 66, 71, 76, 81, 86, 90, 
	94, 97, 99, 101, 103, 105, 107, 109, 
	111, 113, 115, 117, 119, 121, 123, 125, 
	127, 132, 139, 144, 148, 154, 158, 161, 
	167, 178, 180, 182, 184, 186, 188, 190, 
	192, 194, 196, 198, 200, 202, 204, 206, 
	208, 210, 212, 214, 221, 224, 227, 230, 
	233, 236, 239, 242, 245, 248, 251, 254, 
	257, 260, 263, 266, 269, 272, 275, 278, 
	289, 291, 293, 296, 298, 300, 302, 304, 
	306, 308, 310, 312, 314, 316, 318, 320, 
	322, 324, 326, 328, 330, 332, 334, 336, 
	338, 340, 342, 344, 346, 348, 350, 352, 
	354, 356, 358, 360, 363, 365, 368, 370, 
	373, 375, 378, 380, 382, 384, 386, 388, 
	390, 392, 394, 396, 398, 400, 402, 404, 
	406, 408, 411, 413, 415, 417, 419, 421, 
	423, 425, 427, 429, 431, 433, 435, 437, 
	439, 441, 443, 445, 447, 449, 451, 453, 
	455, 457, 459, 468, 471, 482, 485, 488, 
	491, 494, 497, 500, 503, 506, 509, 513, 
	516, 519, 522, 525, 528, 531, 534, 537, 
	540, 543, 546, 549, 552, 555, 558, 561, 
	564, 567, 570, 573, 576, 579, 582, 585, 
	588, 591, 594, 597, 600, 603, 606, 609, 
	613, 616, 619, 622, 626, 629, 633, 636, 
	639, 642, 645, 648, 651, 654, 657, 660, 
	663, 666, 669, 672, 675, 678, 681, 684, 
	687, 690, 693, 696, 699, 702, 705, 708, 
	711, 714, 717, 720, 723, 726, 729, 732, 
	735, 738, 741, 744, 747, 750, 753, 756, 
	759, 762, 765, 768, 771, 774, 777, 780, 
	782, 784, 793, 796, 807, 810, 813, 816, 
	819, 822, 825, 828, 831, 834, 838, 841, 
	844, 847, 850, 853, 856, 859, 862, 865, 
	868, 871, 874, 877, 880, 883, 886, 889, 
	892, 895, 898, 901, 904, 907, 910, 913, 
	916, 919, 922, 925, 928, 931, 934, 938, 
	941, 945, 948, 952, 955, 959, 962, 965, 
	968, 971, 974, 977, 980, 983, 986, 989, 
	992, 995, 998, 1001, 1004, 1008, 1011, 1014, 
	1017, 1020, 1023, 1026, 1029, 1032, 1035, 1038, 
	1041, 1044, 1047, 1050, 1053, 1056, 1059, 1062, 
	1065, 1068, 1071, 1074, 1077, 1080, 1083, 1086, 
	1089, 1092, 1095, 1098, 1101, 1104, 1107, 1110, 
	1113, 1116, 1119, 1122, 1125, 1128, 1131, 1134, 
	1137, 1140, 1143, 1146, 1149, 1152, 1155, 1158, 
	1161, 1164, 1167, 1170, 1173, 1176, 1179, 1182, 
	1185, 1188, 1191, 1194, 1197, 1200, 1203, 1206, 
	1209, 1212, 1215, 1218, 1221, 1224, 1227, 1230, 
	1233, 1236, 1239, 1241, 1243, 1245, 1247, 1249, 
	1251, 1253, 1255, 1257, 1259, 1261, 1263, 1265, 
	1267, 1269, 1271, 1273, 1275, 1277, 1279, 1281, 
	1283, 1285, 1287, 1289, 1298, 1301, 1312, 1315, 
	1318, 1321, 1324, 1327, 1330, 1333, 1336, 1339, 
	1343, 1346, 1349, 1352, 1355, 1358, 1361, 1364, 
	1367, 1370, 1373, 1376, 1379, 1382, 1385, 1388, 
	1391, 1394, 1397, 1400, 1403, 1406, 1409, 1412, 
	1415, 1418, 1421, 1424, 1427, 1430, 1433, 1436, 
	1439, 1443, 1446, 1449, 1452, 1456, 1459, 1463, 
	1466, 1469, 1472, 1475, 1478, 1481, 1484, 1487, 
	1490, 1493, 1496, 1499, 1502, 1505, 1508, 1512, 
	1515, 1518, 1521, 1524, 1527, 1530, 1533, 1536, 
	1539, 1542, 1545, 1548, 1551, 1554, 1557, 1560, 
	1563, 1566, 1569, 1572, 1575, 1578, 1581, 1584, 
	1587, 1590, 1593, 1596, 1599, 1602, 1605, 1608, 
	1611, 1614, 1617, 1620, 1623, 1626, 1629, 1632, 
	1635, 1638, 1641, 1644, 1647, 1650, 1653, 1656, 
	1659, 1662, 1665, 1668, 1671, 1674, 1677, 1679, 
	1681, 1683, 1685, 1687, 1689, 1691, 1693, 1695, 
	1697, 1699, 1701, 1703, 1705, 1707, 1709, 1711, 
	1713, 1715, 1717, 1719, 1721, 1729, 1732, 1737, 
	1740, 1743, 1746, 1749, 1752, 1755, 1758, 1761, 
	1764, 1767, 1770, 1773, 1776, 1779, 1782, 1785, 
	1788, 1792, 1795, 1798, 1801, 1804, 1807, 1810, 
	1813, 1816, 1819, 1822, 1825, 1828, 1831, 1834, 
	1837, 1840, 1843, 1846, 1849, 1853, 1856, 1859, 
	1862, 1865, 1868, 1871, 1874, 1877, 1880, 1883, 
	1886, 1889, 1892, 1895, 1898, 1901, 1904, 1907, 
	1910, 1913, 1916, 1919, 1922, 1925, 1928, 1931, 
	1934, 1937, 1940, 1943, 1946, 1949, 1952, 1955, 
	1958, 1961, 1964, 1967, 1970, 1973, 1976, 1979, 
	1982, 1985, 1988, 1991, 1994, 1997, 2000, 2003, 
	2006, 2009, 2012, 2015, 2018, 2021, 2024, 2027, 
	2030, 2033, 2036, 2039, 2042, 2045, 2048, 2051, 
	2054, 2057, 2060, 2063, 2066, 2069, 2072, 2074, 
	2076
};

static const short _lexer_trans_targs[] = {
	2, 702, 13, 13, 14, 24, 26, 10, 
	40, 43, 13, 0, 3, 0, 4, 49, 
	7, 88, 106, 118, 121, 124, 566, 569, 
	0, 5, 0, 6, 0, 7, 0, 8, 
	0, 9, 0, 10, 0, 11, 0, 13, 
	25, 12, 13, 25, 12, 2, 13, 13, 
	14, 24, 26, 10, 40, 43, 13, 0, 
	15, 0, 16, 0, 18, 17, 17, 18, 
	17, 17, 19, 19, 20, 19, 19, 19, 
	19, 20, 19, 19, 19, 19, 21, 19, 
	19, 19, 19, 22, 19, 19, 13, 23, 
	23, 0, 13, 23, 23, 0, 13, 25, 
	24, 13, 0, 27, 0, 28, 0, 29, 
	0, 30, 0, 31, 0, 32, 0, 33, 
	0, 34, 0, 35, 0, 36, 0, 37, 
	0, 38, 0, 39, 0, 704, 0, 0, 
	0, 0, 0, 41, 42, 13, 42, 42, 
	40, 41, 41, 13, 42, 40, 42, 0, 
	43, 44, 43, 0, 48, 47, 46, 44, 
	47, 45, 0, 46, 44, 45, 0, 46, 
	45, 48, 47, 46, 44, 47, 45, 2, 
	48, 48, 14, 24, 26, 10, 40, 43, 
	48, 0, 50, 0, 51, 0, 52, 0, 
	53, 0, 54, 0, 55, 0, 56, 0, 
	57, 0, 58, 0, 59, 0, 60, 0, 
	61, 0, 62, 0, 63, 0, 64, 0, 
	65, 0, 67, 66, 67, 66, 68, 67, 
	67, 13, 13, 67, 66, 69, 67, 66, 
	70, 67, 66, 71, 67, 66, 72, 67, 
	66, 73, 67, 66, 74, 67, 66, 75, 
	67, 66, 76, 67, 66, 67, 77, 66, 
	78, 67, 66, 79, 67, 66, 80, 67, 
	66, 81, 67, 66, 82, 67, 66, 83, 
	67, 66, 84, 67, 66, 85, 67, 66, 
	86, 67, 66, 67, 87, 66, 2, 13, 
	13, 14, 24, 26, 10, 40, 43, 13, 
	0, 89, 0, 90, 0, 91, 94, 0, 
	92, 0, 93, 0, 10, 0, 95, 0, 
	96, 0, 97, 0, 98, 0, 99, 0, 
	100, 0, 101, 0, 102, 0, 103, 0, 
	104, 0, 105, 0, 10, 0, 107, 0, 
	108, 0, 109, 0, 110, 0, 111, 0, 
	112, 0, 113, 0, 114, 0, 115, 0, 
	116, 0, 117, 0, 10, 0, 119, 0, 
	120, 0, 10, 0, 122, 0, 123, 0, 
	10, 91, 0, 125, 0, 126, 418, 0, 
	127, 0, 128, 11, 0, 129, 0, 97, 
	130, 0, 131, 0, 132, 0, 133, 0, 
	134, 0, 135, 0, 136, 0, 137, 0, 
	138, 0, 139, 0, 140, 0, 141, 0, 
	142, 0, 143, 0, 144, 0, 145, 0, 
	146, 271, 0, 147, 0, 148, 0, 149, 
	0, 150, 0, 151, 0, 152, 0, 153, 
	0, 154, 0, 155, 0, 156, 0, 157, 
	0, 158, 0, 159, 0, 160, 0, 161, 
	0, 162, 0, 163, 0, 164, 0, 165, 
	0, 166, 0, 167, 0, 168, 0, 170, 
	169, 170, 169, 171, 170, 170, 13, 257, 
	179, 13, 170, 169, 172, 170, 169, 173, 
	176, 180, 198, 210, 213, 216, 238, 241, 
	170, 169, 174, 170, 169, 175, 170, 169, 
	176, 170, 169, 177, 170, 169, 178, 170, 
	169, 179, 170, 169, 170, 87, 169, 181, 
	170, 169, 182, 170, 169, 183, 186, 170, 
	169, 184, 170, 169, 185, 170, 169, 179, 
	170, 169, 187, 170, 169, 188, 170, 169, 
	189, 170, 169, 190, 170, 169, 191, 170, 
	169, 192, 170, 169, 193, 170, 169, 194, 
	170, 169, 195, 170, 169, 196, 170, 169, 
	197, 170, 169, 179, 170, 169, 199, 170, 
	169, 200, 170, 169, 201, 170, 169, 202, 
	170, 169, 203, 170, 169, 204, 170, 169, 
	205, 170, 169, 206, 170, 169, 207, 170, 
	169, 208, 170, 169, 209, 170, 169, 179, 
	170, 169, 211, 170, 169, 212, 170, 169, 
	179, 170, 169, 214, 170, 169, 215, 170, 
	169, 179, 170, 183, 169, 217, 170, 169, 
	218, 170, 169, 219, 170, 169, 220, 170, 
	87, 169, 221, 170, 169, 189, 222, 170, 
	169, 223, 170, 169, 224, 170, 169, 225, 
	170, 169, 226, 170, 169, 227, 170, 169, 
	228, 170, 169, 229, 170, 169, 230, 170, 
	169, 231, 170, 169, 232, 170, 169, 233, 
	170, 169, 234, 170, 169, 235, 170, 169, 
	236, 170, 169, 237, 170, 169, 170, 87, 
	169, 239, 170, 169, 240, 170, 169, 207, 
	170, 169, 242, 170, 169, 243, 170, 169, 
	244, 170, 169, 245, 170, 169, 246, 170, 
	169, 247, 170, 169, 170, 248, 169, 249, 
	170, 169, 250, 170, 169, 251, 170, 169, 
	252, 170, 169, 253, 170, 169, 254, 170, 
	169, 255, 170, 169, 256, 170, 169, 237, 
	170, 169, 170, 258, 169, 170, 259, 169, 
	170, 260, 169, 170, 261, 169, 170, 262, 
	169, 170, 263, 169, 170, 264, 169, 170, 
	265, 169, 170, 266, 169, 170, 267, 169, 
	170, 268, 169, 170, 269, 169, 170, 270, 
	169, 170, 13, 169, 273, 272, 273, 272, 
	274, 273, 273, 13, 404, 282, 13, 273, 
	272, 275, 273, 272, 276, 279, 283, 301, 
	313, 316, 319, 385, 388, 273, 272, 277, 
	273, 272, 278, 273, 272, 279, 273, 272, 
	280, 273, 272, 281, 273, 272, 282, 273, 
	272, 273, 87, 272, 284, 273, 272, 285, 
	273, 272, 286, 289, 273, 272, 287, 273, 
	272, 288, 273, 272, 282, 273, 272, 290, 
	273, 272, 291, 273, 272, 292, 273, 272, 
	293, 273, 272, 294, 273, 272, 295, 273, 
	272, 296, 273, 272, 297, 273, 272, 298, 
	273, 272, 299, 273, 272, 300, 273, 272, 
	282, 273, 272, 302, 273, 272, 303, 273, 
	272, 304, 273, 272, 305, 273, 272, 306, 
	273, 272, 307, 273, 272, 308, 273, 272, 
	309, 273, 272, 310, 273, 272, 311, 273, 
	272, 312, 273, 272, 282, 273, 272, 314, 
	273, 272, 315, 273, 272, 282, 273, 272, 
	317, 273, 272, 318, 273, 272, 282, 273, 
	286, 272, 320, 273, 272, 321, 363, 273, 
	272, 322, 273, 272, 323, 273, 87, 272, 
	324, 273, 272, 292, 325, 273, 272, 326, 
	273, 272, 327, 273, 272, 328, 273, 272, 
	329, 273, 272, 330, 273, 272, 331, 273, 
	272, 332, 273, 272, 333, 273, 272, 334, 
	273, 272, 335, 273, 272, 336, 273, 272, 
	337, 273, 272, 338, 273, 272, 339, 273, 
	272, 340, 273, 272, 273, 341, 87, 272, 
	342, 273, 272, 343, 273, 272, 344, 273, 
	272, 345, 273, 272, 346, 273, 272, 347, 
	273, 272, 348, 273, 272, 349, 273, 272, 
	350, 273, 272, 351, 273, 272, 352, 273, 
	272, 353, 273, 272, 354, 273, 272, 355, 
	273, 272, 356, 273, 272, 357, 273, 272, 
	358, 273, 272, 359, 273, 272, 360, 273, 
	272, 361, 273, 272, 362, 273, 272, 273, 
	87, 272, 364, 273, 272, 365, 273, 272, 
	366, 273, 272, 367, 273, 272, 368, 273, 
	272, 369, 273, 272, 370, 273, 272, 371, 
	273, 272, 372, 273, 272, 373, 273, 272, 
	374, 273, 272, 375, 273, 272, 376, 273, 
	272, 377, 273, 272, 378, 273, 272, 379, 
	273, 272, 380, 273, 272, 381, 273, 272, 
	382, 273, 272, 383, 273, 272, 384, 273, 
	272, 362, 273, 272, 386, 273, 272, 387, 
	273, 272, 310, 273, 272, 389, 273, 272, 
	390, 273, 272, 391, 273, 272, 392, 273, 
	272, 393, 273, 272, 394, 273, 272, 273, 
	395, 272, 396, 273, 272, 397, 273, 272, 
	398, 273, 272, 399, 273, 272, 400, 273, 
	272, 401, 273, 272, 402, 273, 272, 403, 
	273, 272, 362, 273, 272, 273, 405, 272, 
	273, 406, 272, 273, 407, 272, 273, 408, 
	272, 273, 409, 272, 273, 410, 272, 273, 
	411, 272, 273, 412, 272, 273, 413, 272, 
	273, 414, 272, 273, 415, 272, 273, 416, 
	272, 273, 417, 272, 273, 13, 272, 419, 
	0, 420, 0, 421, 0, 422, 0, 423, 
	0, 424, 0, 425, 0, 426, 0, 427, 
	0, 428, 0, 429, 0, 430, 0, 431, 
	0, 432, 0, 433, 0, 434, 0, 435, 
	0, 436, 0, 437, 0, 438, 0, 439, 
	0, 440, 0, 441, 0, 443, 442, 443, 
	442, 444, 443, 443, 13, 552, 452, 13, 
	443, 442, 445, 443, 442, 446, 449, 453, 
	471, 483, 486, 489, 533, 536, 443, 442, 
	447, 443, 442, 448, 443, 442, 449, 443, 
	442, 450, 443, 442, 451, 443, 442, 452, 
	443, 442, 443, 87, 442, 454, 443, 442, 
	455, 443, 442, 456, 459, 443, 442, 457, 
	443, 442, 458, 443, 442, 452, 443, 442, 
	460, 443, 442, 461, 443, 442, 462, 443, 
	442, 463, 443, 442, 464, 443, 442, 465, 
	443, 442, 466, 443, 442, 467, 443, 442, 
	468, 443, 442, 469, 443, 442, 470, 443, 
	442, 452, 443, 442, 472, 443, 442, 473, 
	443, 442, 474, 443, 442, 475, 443, 442, 
	476, 443, 442, 477, 443, 442, 478, 443, 
	442, 479, 443, 442, 480, 443, 442, 481, 
	443, 442, 482, 443, 442, 452, 443, 442, 
	484, 443, 442, 485, 443, 442, 452, 443, 
	442, 487, 443, 442, 488, 443, 442, 452, 
	443, 456, 442, 490, 443, 442, 491, 443, 
	442, 492, 443, 442, 493, 443, 87, 442, 
	494, 443, 442, 462, 495, 443, 442, 496, 
	443, 442, 497, 443, 442, 498, 443, 442, 
	499, 443, 442, 500, 443, 442, 501, 443, 
	442, 502, 443, 442, 503, 443, 442, 504, 
	443, 442, 505, 443, 442, 506, 443, 442, 
	507, 443, 442, 508, 443, 442, 509, 443, 
	442, 510, 443, 442, 443, 511, 87, 442, 
	512, 443, 442, 513, 443, 442, 514, 443, 
	442, 515, 443, 442, 516, 443, 442, 517, 
	443, 442, 518, 443, 442, 519, 443, 442, 
	520, 443, 442, 521, 443, 442, 522, 443, 
	442, 523, 443, 442, 524, 443, 442, 525, 
	443, 442, 526, 443, 442, 527, 443, 442, 
	528, 443, 442, 529, 443, 442, 530, 443, 
	442, 531, 443, 442, 532, 443, 442, 443, 
	87, 442, 534, 443, 442, 535, 443, 442, 
	480, 443, 442, 537, 443, 442, 538, 443, 
	442, 539, 443, 442, 540, 443, 442, 541, 
	443, 442, 542, 443, 442, 443, 543, 442, 
	544, 443, 442, 545, 443, 442, 546, 443, 
	442, 547, 443, 442, 548, 443, 442, 549, 
	443, 442, 550, 443, 442, 551, 443, 442, 
	532, 443, 442, 443, 553, 442, 443, 554, 
	442, 443, 555, 442, 443, 556, 442, 443, 
	557, 442, 443, 558, 442, 443, 559, 442, 
	443, 560, 442, 443, 561, 442, 443, 562, 
	442, 443, 563, 442, 443, 564, 442, 443, 
	565, 442, 443, 13, 442, 567, 0, 568, 
	0, 115, 0, 570, 0, 571, 0, 572, 
	0, 573, 0, 574, 0, 575, 0, 576, 
	0, 577, 0, 578, 0, 579, 0, 580, 
	0, 581, 0, 582, 0, 583, 0, 584, 
	0, 585, 0, 586, 0, 588, 587, 588, 
	587, 589, 588, 588, 13, 688, 13, 588, 
	587, 590, 588, 587, 591, 607, 672, 588, 
	587, 592, 588, 587, 593, 588, 587, 594, 
	588, 587, 595, 588, 587, 596, 588, 587, 
	597, 588, 587, 598, 588, 587, 599, 588, 
	587, 600, 588, 587, 601, 588, 587, 602, 
	588, 587, 603, 588, 587, 604, 588, 587, 
	605, 588, 587, 606, 588, 587, 588, 87, 
	587, 608, 588, 587, 609, 650, 588, 587, 
	610, 588, 587, 611, 588, 587, 612, 588, 
	587, 613, 588, 587, 614, 588, 587, 615, 
	588, 587, 616, 588, 587, 617, 588, 587, 
	618, 588, 587, 619, 588, 587, 620, 588, 
	587, 621, 588, 587, 622, 588, 587, 623, 
	588, 587, 624, 588, 587, 625, 588, 587, 
	626, 588, 587, 627, 588, 587, 628, 588, 
	587, 588, 629, 87, 587, 630, 588, 587, 
	631, 588, 587, 632, 588, 587, 633, 588, 
	587, 634, 588, 587, 635, 588, 587, 636, 
	588, 587, 637, 588, 587, 638, 588, 587, 
	639, 588, 587, 640, 588, 587, 641, 588, 
	587, 642, 588, 587, 643, 588, 587, 644, 
	588, 587, 645, 588, 587, 646, 588, 587, 
	647, 588, 587, 648, 588, 587, 649, 588, 
	587, 606, 588, 587, 651, 588, 587, 652, 
	588, 587, 653, 588, 587, 654, 588, 587, 
	655, 588, 587, 656, 588, 587, 657, 588, 
	587, 658, 588, 587, 659, 588, 587, 660, 
	588, 587, 661, 588, 587, 662, 588, 587, 
	663, 588, 587, 664, 588, 587, 665, 588, 
	587, 666, 588, 587, 667, 588, 587, 668, 
	588, 587, 669, 588, 587, 670, 588, 587, 
	671, 588, 587, 606, 588, 587, 673, 588, 
	587, 674, 588, 587, 675, 588, 587, 676, 
	588, 587, 677, 588, 587, 678, 588, 587, 
	588, 679, 587, 680, 588, 587, 681, 588, 
	587, 682, 588, 587, 683, 588, 587, 684, 
	588, 587, 685, 588, 587, 686, 588, 587, 
	687, 588, 587, 606, 588, 587, 588, 689, 
	587, 588, 690, 587, 588, 691, 587, 588, 
	692, 587, 588, 693, 587, 588, 694, 587, 
	588, 695, 587, 588, 696, 587, 588, 697, 
	587, 588, 698, 587, 588, 699, 587, 588, 
	700, 587, 588, 701, 587, 588, 13, 587, 
	703, 0, 13, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 43, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 149, 
	126, 57, 110, 23, 0, 29, 54, 0, 
	5, 1, 0, 29, 1, 35, 0, 43, 
	0, 43, 0, 43, 139, 48, 9, 106, 
	11, 0, 134, 45, 45, 45, 3, 122, 
	33, 33, 33, 0, 122, 33, 33, 33, 
	0, 122, 33, 0, 33, 0, 102, 7, 
	7, 43, 54, 0, 0, 43, 114, 25, 
	0, 54, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 43, 
	43, 43, 43, 0, 27, 118, 27, 27, 
	51, 27, 0, 54, 0, 1, 0, 43, 
	0, 0, 0, 43, 54, 37, 37, 87, 
	37, 37, 43, 0, 39, 0, 43, 0, 
	0, 54, 0, 0, 39, 0, 0, 96, 
	54, 0, 93, 90, 41, 96, 90, 99, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 81, 81, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 21, 0, 63, 130, 
	31, 60, 57, 31, 63, 57, 66, 31, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 78, 33, 
	84, 78, 0, 0, 0, 54, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	19, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 19, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 144, 57, 54, 0, 
	84, 54, 0, 75, 33, 84, 75, 0, 
	0, 0, 54, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 17, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 72, 33, 84, 72, 
	0, 0, 0, 54, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 15, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 15, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 15, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	15, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 69, 33, 69, 0, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 13, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 13, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 13, 0, 
	0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43
};

static const int lexer_start = 1;
static const int lexer_first_final = 704;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/hi.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1452 "ext/gherkin_lexer_hi/gherkin_lexer_hi.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/hi.c.rl"
    
#line 1459 "ext/gherkin_lexer_hi/gherkin_lexer_hi.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/hi.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/hi.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/hi.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/hi.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/hi.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/hi.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/hi.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/hi.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/hi.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/hi.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/hi.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/hi.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/hi.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/hi.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/hi.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/hi.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/hi.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/hi.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/hi.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/hi.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/hi.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/hi.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/hi.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/hi.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1749 "ext/gherkin_lexer_hi/gherkin_lexer_hi.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/hi.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1812 "ext/gherkin_lexer_hi/gherkin_lexer_hi.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/hi.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_hi()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Hi", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

