
#line 1 "ragel/i18n/tl.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/tl.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_tl/gherkin_lexer_tl.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 13, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 33, 
	34, 35, 36, 37, 38, 39, 40, 41, 
	43, 45, 56, 57, 58, 60, 62, 67, 
	72, 77, 82, 86, 90, 92, 93, 94, 
	95, 96, 97, 98, 99, 100, 101, 102, 
	103, 104, 105, 106, 107, 112, 119, 124, 
	128, 134, 137, 139, 145, 156, 157, 158, 
	159, 160, 161, 162, 163, 164, 165, 166, 
	167, 168, 169, 170, 171, 172, 173, 174, 
	175, 176, 177, 178, 179, 180, 181, 182, 
	183, 184, 185, 186, 187, 188, 189, 190, 
	191, 192, 193, 194, 195, 196, 197, 198, 
	199, 200, 201, 202, 203, 204, 205, 206, 
	207, 208, 209, 210, 211, 212, 213, 214, 
	221, 223, 225, 227, 229, 231, 233, 235, 
	237, 239, 241, 243, 245, 247, 249, 251, 
	262, 263, 264, 266, 267, 268, 269, 270, 
	271, 272, 273, 274, 275, 284, 286, 294, 
	296, 298, 300, 302, 304, 306, 308, 310, 
	312, 314, 316, 318, 320, 322, 324, 326, 
	328, 330, 332, 334, 336, 338, 340, 342, 
	344, 346, 348, 350, 352, 354, 356, 358, 
	360, 362, 364, 366, 368, 370, 372, 374, 
	376, 378, 380, 382, 384, 386, 388, 390, 
	392, 394, 396, 398, 400, 402, 404, 406, 
	408, 410, 412, 414, 416, 418, 420, 422, 
	424, 426, 428, 430, 432, 434, 436, 438, 
	440, 442, 444, 446, 448, 450, 452, 454, 
	456, 458, 460, 462, 464, 466, 468, 470, 
	472, 474, 476, 478, 480, 482, 484, 486, 
	488, 490, 492, 494, 496, 498, 500, 502, 
	504, 506, 508, 510, 512, 514, 516, 518, 
	520, 522, 524, 526, 528, 530, 532, 534, 
	536, 538, 540, 542, 544, 546, 548, 550, 
	552, 554, 556, 558, 560, 562, 564, 566, 
	568, 570, 572, 574, 576, 578, 580, 582, 
	584, 586, 588, 590, 592, 593, 594, 595, 
	596, 597, 598, 599, 600, 601, 602, 603, 
	604, 605, 606, 607, 608, 609, 610, 611, 
	612, 613, 621, 623, 629, 631, 633, 635, 
	637, 639, 641, 643, 645, 647, 649, 651, 
	653, 655, 657, 659, 661, 663, 665, 667, 
	669, 671, 673, 675, 677, 679, 681, 683, 
	685, 687, 689, 691, 693, 695, 697, 699, 
	701, 703, 705, 707, 709, 711, 713, 715, 
	717, 719, 721, 723, 725, 727, 729, 731, 
	733, 735, 737, 739, 741, 743, 745, 747, 
	749, 751, 753, 755, 757, 759, 761, 763, 
	765, 767, 769, 771, 773, 775, 777, 779, 
	781, 783, 785, 787, 789, 791, 793, 795, 
	797, 799, 801, 803, 805, 807, 809, 810, 
	811, 812, 813, 814, 815, 816, 817, 818, 
	819, 820, 821, 822, 823, 824, 825, 826, 
	827, 828, 829, 830, 831, 832, 833, 834, 
	835, 836, 837, 838, 839, 840, 841, 842, 
	843, 844, 845, 846, 847, 848, 849, 850, 
	851, 852, 853, 854, 855, 856, 857, 866, 
	868, 876, 878, 880, 882, 884, 886, 888, 
	890, 892, 894, 896, 898, 900, 902, 904, 
	906, 908, 910, 912, 914, 916, 918, 920, 
	922, 924, 926, 928, 930, 932, 934, 936, 
	938, 940, 942, 944, 946, 948, 950, 952, 
	954, 956, 958, 960, 962, 964, 966, 968, 
	970, 972, 974, 976, 978, 980, 982, 984, 
	986, 989, 991, 993, 995, 997, 999, 1001, 
	1003, 1005, 1007, 1009, 1011, 1013, 1015, 1017, 
	1019, 1021, 1023, 1025, 1027, 1029, 1031, 1033, 
	1035, 1037, 1039, 1041, 1043, 1045, 1047, 1049, 
	1051, 1053, 1055, 1057, 1059, 1061, 1063, 1065, 
	1067, 1069, 1071, 1073, 1075, 1077, 1079, 1081, 
	1083, 1085, 1087, 1089, 1091, 1093, 1095, 1097, 
	1099, 1101, 1103, 1105, 1107, 1109, 1111, 1113, 
	1115, 1117, 1119, 1121, 1123, 1125, 1127, 1129, 
	1131, 1133, 1135, 1137, 1139, 1141, 1143, 1145, 
	1147, 1149, 1151, 1153, 1155, 1157, 1159, 1161, 
	1163, 1165, 1167, 1169, 1171, 1173, 1175, 1177, 
	1179, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 
	1188, 1189, 1190, 1191, 1192, 1193, 1194, 1195, 
	1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 
	1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 
	1212, 1213, 1214, 1215, 1216, 1217, 1226, 1228, 
	1237, 1239, 1241, 1243, 1245, 1247, 1249, 1251, 
	1253, 1255, 1257, 1259, 1261, 1263, 1265, 1267, 
	1269, 1271, 1273, 1275, 1277, 1279, 1281, 1283, 
	1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 
	1301, 1303, 1305, 1307, 1309, 1311, 1313, 1315, 
	1317, 1319, 1321, 1323, 1325, 1327, 1329, 1331, 
	1333, 1335, 1337, 1339, 1341, 1343, 1345, 1347, 
	1350, 1352, 1354, 1356, 1358, 1360, 1362, 1364, 
	1366, 1368, 1370, 1372, 1374, 1376, 1378, 1380, 
	1382, 1384, 1386, 1388, 1390, 1392, 1394, 1396, 
	1398, 1400, 1402, 1404, 1406, 1408, 1410, 1412, 
	1414, 1416, 1418, 1420, 1422, 1424, 1426, 1428, 
	1430, 1432, 1434, 1436, 1438, 1440, 1442, 1444, 
	1446, 1448, 1450, 1452, 1454, 1456, 1458, 1460, 
	1462, 1464, 1466, 1468, 1470, 1472, 1474, 1476, 
	1478, 1480, 1482, 1484, 1486, 1488, 1490, 1492, 
	1494, 1496, 1498, 1500, 1502, 1504, 1506, 1508, 
	1510, 1512, 1514, 1516, 1518, 1520, 1522, 1524, 
	1526, 1528, 1530, 1532, 1534, 1536, 1538, 1540, 
	1542, 1544, 1546, 1548, 1550, 1552, 1554, 1556, 
	1558, 1560, 1562, 1564, 1566, 1568, 1570, 1572, 
	1573, 1574
};

static const char _lexer_trans_keys[] = {
	-32, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -80, -123, -120, -119, 
	-107, -105, -102, -88, -82, -72, -32, -80, 
	-86, -32, -79, -115, -32, -80, -86, -32, 
	-79, -127, -32, -80, -95, -32, -79, -127, 
	32, 10, 13, 10, 13, -32, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	34, 34, 10, 13, 10, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 9, 13, 10, 32, 
	9, 13, 10, 13, 10, 95, 70, 69, 
	65, 84, 85, 82, 69, 95, 69, 78, 
	68, 95, 37, 13, 32, 64, 9, 10, 
	9, 10, 13, 32, 64, 11, 12, 10, 
	32, 64, 9, 13, 32, 124, 9, 13, 
	10, 32, 92, 124, 9, 13, 10, 92, 
	124, 10, 92, 10, 32, 92, 124, 9, 
	13, -32, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, 32, -32, -80, -86, 
	-32, -80, -80, -32, -80, -65, -32, -80, 
	-72, -32, -79, -115, -32, -80, -91, -32, 
	-80, -65, -32, -80, -92, -32, -80, -65, 
	-32, -80, -78, -32, -79, -117, -32, -80, 
	-90, -32, -80, -66, -32, -80, -71, -32, 
	-80, -80, -32, -80, -93, -32, -80, -78, 
	-32, -79, -127, 58, 10, 10, -32, 10, 
	32, 35, 124, 9, 13, -80, 10, -105, 
	10, -32, 10, -79, 10, -127, 10, -32, 
	10, -80, 10, -93, 10, -32, 10, -80, 
	10, -82, 10, -32, 10, -79, 10, -127, 
	10, 10, 58, -32, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, -32, -80, 
	-91, -66, -32, -80, -88, -32, -80, -126, 
	58, 10, 10, -32, 10, 32, 35, 37, 
	42, 64, 9, 13, -80, 10, -123, -120, 
	-107, -105, -102, -82, -72, 10, -32, 10, 
	-80, 10, -86, 10, -32, 10, -79, 10, 
	-115, 10, -32, 10, -80, 10, -86, 10, 
	-32, 10, -79, 10, -127, 10, -32, 10, 
	-80, 10, -95, 10, -32, 10, -79, 10, 
	-127, 10, 10, 32, 10, 32, -32, 10, 
	-80, 10, -86, 10, -32, 10, -80, 10, 
	-80, 10, -32, 10, -80, 10, -65, 10, 
	-32, 10, -80, 10, -72, 10, -32, 10, 
	-79, 10, -115, 10, -32, 10, -80, 10, 
	-91, 10, -32, 10, -80, 10, -65, 10, 
	-32, 10, -80, 10, -92, 10, -32, 10, 
	-80, 10, -65, 10, -32, 10, -80, 10, 
	-78, 10, -32, 10, -79, 10, -117, 10, 
	-32, 10, -80, 10, -66, 10, -32, 10, 
	-80, 10, -88, 10, -32, 10, -80, 10, 
	-65, 10, -32, 10, -79, 10, -127, 10, 
	-32, 10, -80, 10, -93, 10, -32, 10, 
	-80, 10, -82, 10, -32, 10, -79, 10, 
	-127, 10, 10, 58, -32, 10, -79, 10, 
	-122, 10, -32, 10, -80, 10, -86, 10, 
	-32, 10, -79, 10, -115, 10, -32, 10, 
	-80, 10, -86, 10, -32, 10, -80, 10, 
	-84, 10, -32, 10, -80, 10, -95, 10, 
	-32, 10, -80, 10, -65, 10, -32, 10, 
	-80, 10, -88, 10, -32, 10, -80, 10, 
	-90, 10, -32, 10, -80, 10, -80, 10, 
	-32, 10, -80, 10, -65, 10, -32, 10, 
	-80, 10, -81, 10, -32, 10, -80, 10, 
	-88, 10, -32, 10, -79, 10, -115, 10, 
	-32, 10, -80, 10, -88, 10, -32, 10, 
	-80, 10, -65, 10, -32, 10, -80, 10, 
	-75, 10, -32, 10, -79, 10, -121, 10, 
	-32, 10, -80, 10, -74, 10, -32, 10, 
	-80, 10, -126, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-32, -80, -88, -32, -80, -65, -32, -79, 
	-127, -32, -80, -93, -32, -80, -82, -32, 
	-79, -127, 58, 10, 10, -32, 10, 32, 
	35, 37, 64, 9, 13, -80, 10, -119, 
	-107, -105, -88, -72, 10, -32, 10, -80, 
	10, -90, 10, -32, 10, -80, 10, -66, 
	10, -32, 10, -80, 10, -71, 10, -32, 
	10, -80, 10, -80, 10, -32, 10, -80, 
	10, -93, 10, -32, 10, -80, 10, -78, 
	10, -32, 10, -79, 10, -127, 10, 10, 
	58, -32, 10, -80, 10, -91, 10, -32, 
	10, -80, 10, -88, 10, -32, 10, -80, 
	10, -126, 10, -32, 10, -79, 10, -127, 
	10, -32, 10, -80, 10, -93, 10, -32, 
	10, -80, 10, -82, 10, -32, 10, -79, 
	10, -121, 10, -32, 10, -80, 10, -86, 
	10, -32, 10, -80, 10, -91, 10, -32, 
	10, -79, 10, -115, 10, -32, 10, -80, 
	10, -81, 10, -32, 10, -80, 10, -88, 
	10, -32, 10, -79, 10, -115, 10, -32, 
	10, -80, 10, -88, 10, -32, 10, -80, 
	10, -65, 10, -32, 10, -80, 10, -75, 
	10, -32, 10, -79, 10, -121, 10, -32, 
	10, -80, 10, -74, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -32, -79, -122, -32, -80, -86, -32, 
	-79, -115, -32, -80, -86, -32, -80, -84, 
	-32, -80, -95, -32, -80, -65, -32, -80, 
	-88, -32, -80, -90, -32, -79, -121, -32, 
	-80, -86, -32, -80, -91, -32, -79, -115, 
	-32, -80, -81, -32, -80, -126, 58, 10, 
	10, -32, 10, 32, 35, 37, 42, 64, 
	9, 13, -80, 10, -123, -120, -107, -105, 
	-102, -82, -72, 10, -32, 10, -80, 10, 
	-86, 10, -32, 10, -79, 10, -115, 10, 
	-32, 10, -80, 10, -86, 10, -32, 10, 
	-79, 10, -127, 10, -32, 10, -80, 10, 
	-95, 10, -32, 10, -79, 10, -127, 10, 
	10, 32, 10, 32, -32, 10, -80, 10, 
	-86, 10, -32, 10, -80, 10, -80, 10, 
	-32, 10, -80, 10, -65, 10, -32, 10, 
	-80, 10, -72, 10, -32, 10, -79, 10, 
	-115, 10, -32, 10, -80, 10, -91, 10, 
	-32, 10, -80, 10, -65, 10, -32, 10, 
	-80, 10, -92, 10, -32, 10, -80, 10, 
	-65, 10, -32, 10, -80, 10, -78, 10, 
	-32, 10, -79, 10, -117, 10, -32, 10, 
	-80, 10, -91, -66, 10, -32, 10, -80, 
	10, -88, 10, -32, 10, -80, 10, -126, 
	10, 10, 58, -32, 10, -80, 10, -88, 
	10, -32, 10, -80, 10, -65, 10, -32, 
	10, -79, 10, -127, 10, -32, 10, -80, 
	10, -93, 10, -32, 10, -80, 10, -82, 
	10, -32, 10, -79, 10, -127, 10, -32, 
	10, -79, 10, -122, 10, -32, 10, -80, 
	10, -86, 10, -32, 10, -79, 10, -115, 
	10, -32, 10, -80, 10, -86, 10, -32, 
	10, -80, 10, -84, 10, -32, 10, -80, 
	10, -95, 10, -32, 10, -80, 10, -65, 
	10, -32, 10, -80, 10, -88, 10, -32, 
	10, -80, 10, -90, 10, -32, 10, -80, 
	10, -80, 10, -32, 10, -80, 10, -65, 
	10, -32, 10, -80, 10, -81, 10, -32, 
	10, -80, 10, -88, 10, -32, 10, -79, 
	10, -115, 10, -32, 10, -80, 10, -88, 
	10, -32, 10, -80, 10, -65, 10, -32, 
	10, -80, 10, -75, 10, -32, 10, -79, 
	10, -121, 10, -32, 10, -80, 10, -74, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -32, -80, -80, 
	-32, -80, -65, -32, -80, -81, -32, -80, 
	-88, -32, -79, -115, -32, -80, -88, -32, 
	-80, -65, -32, -80, -75, -32, -79, -121, 
	-32, -80, -74, -32, -80, -126, 58, 10, 
	10, -32, 10, 32, 35, 37, 42, 64, 
	9, 13, -80, 10, -123, -120, -107, -105, 
	-102, -88, -82, -72, 10, -32, 10, -80, 
	10, -86, 10, -32, 10, -79, 10, -115, 
	10, -32, 10, -80, 10, -86, 10, -32, 
	10, -79, 10, -127, 10, -32, 10, -80, 
	10, -95, 10, -32, 10, -79, 10, -127, 
	10, 10, 32, 10, 32, -32, 10, -80, 
	10, -86, 10, -32, 10, -80, 10, -80, 
	10, -32, 10, -80, 10, -65, 10, -32, 
	10, -80, 10, -72, 10, -32, 10, -79, 
	10, -115, 10, -32, 10, -80, 10, -91, 
	10, -32, 10, -80, 10, -65, 10, -32, 
	10, -80, 10, -92, 10, -32, 10, -80, 
	10, -65, 10, -32, 10, -80, 10, -78, 
	10, -32, 10, -79, 10, -117, 10, -32, 
	10, -80, 10, -91, -66, 10, -32, 10, 
	-80, 10, -88, 10, -32, 10, -80, 10, 
	-126, 10, 10, 58, -32, 10, -80, 10, 
	-88, 10, -32, 10, -80, 10, -65, 10, 
	-32, 10, -79, 10, -127, 10, -32, 10, 
	-80, 10, -93, 10, -32, 10, -80, 10, 
	-82, 10, -32, 10, -79, 10, -127, 10, 
	-32, 10, -79, 10, -122, 10, -32, 10, 
	-80, 10, -86, 10, -32, 10, -79, 10, 
	-115, 10, -32, 10, -80, 10, -86, 10, 
	-32, 10, -80, 10, -84, 10, -32, 10, 
	-80, 10, -95, 10, -32, 10, -80, 10, 
	-65, 10, -32, 10, -80, 10, -88, 10, 
	-32, 10, -80, 10, -90, 10, -32, 10, 
	-79, 10, -121, 10, -32, 10, -80, 10, 
	-86, 10, -32, 10, -80, 10, -91, 10, 
	-32, 10, -79, 10, -115, 10, -32, 10, 
	-80, 10, -81, 10, -32, 10, -80, 10, 
	-80, 10, -32, 10, -80, 10, -65, 10, 
	-32, 10, -80, 10, -81, 10, -32, 10, 
	-80, 10, -88, 10, -32, 10, -79, 10, 
	-115, 10, -32, 10, -80, 10, -88, 10, 
	-32, 10, -80, 10, -65, 10, -32, 10, 
	-80, 10, -75, 10, -32, 10, -79, 10, 
	-121, 10, -32, 10, -80, 10, -74, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 2, 
	2, 9, 1, 1, 2, 2, 3, 3, 
	3, 3, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 3, 5, 3, 2, 
	4, 3, 2, 4, 9, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 5, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 9, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 2, 8, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 6, 2, 6, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 7, 2, 
	8, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 2, 9, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 1, 1, 
	1, 0, 0, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 14, 24, 26, 28, 30, 
	32, 34, 36, 38, 40, 42, 44, 46, 
	48, 50, 52, 54, 56, 58, 60, 62, 
	65, 68, 79, 81, 83, 86, 89, 94, 
	99, 104, 109, 113, 117, 120, 122, 124, 
	126, 128, 130, 132, 134, 136, 138, 140, 
	142, 144, 146, 148, 150, 155, 162, 167, 
	171, 177, 181, 184, 190, 201, 203, 205, 
	207, 209, 211, 213, 215, 217, 219, 221, 
	223, 225, 227, 229, 231, 233, 235, 237, 
	239, 241, 243, 245, 247, 249, 251, 253, 
	255, 257, 259, 261, 263, 265, 267, 269, 
	271, 273, 275, 277, 279, 281, 283, 285, 
	287, 289, 291, 293, 295, 297, 299, 301, 
	303, 305, 307, 309, 311, 313, 315, 317, 
	324, 327, 330, 333, 336, 339, 342, 345, 
	348, 351, 354, 357, 360, 363, 366, 369, 
	380, 382, 384, 387, 389, 391, 393, 395, 
	397, 399, 401, 403, 405, 414, 417, 426, 
	429, 432, 435, 438, 441, 444, 447, 450, 
	453, 456, 459, 462, 465, 468, 471, 474, 
	477, 480, 483, 486, 489, 492, 495, 498, 
	501, 504, 507, 510, 513, 516, 519, 522, 
	525, 528, 531, 534, 537, 540, 543, 546, 
	549, 552, 555, 558, 561, 564, 567, 570, 
	573, 576, 579, 582, 585, 588, 591, 594, 
	597, 600, 603, 606, 609, 612, 615, 618, 
	621, 624, 627, 630, 633, 636, 639, 642, 
	645, 648, 651, 654, 657, 660, 663, 666, 
	669, 672, 675, 678, 681, 684, 687, 690, 
	693, 696, 699, 702, 705, 708, 711, 714, 
	717, 720, 723, 726, 729, 732, 735, 738, 
	741, 744, 747, 750, 753, 756, 759, 762, 
	765, 768, 771, 774, 777, 780, 783, 786, 
	789, 792, 795, 798, 801, 804, 807, 810, 
	813, 816, 819, 822, 825, 828, 831, 834, 
	837, 840, 843, 846, 849, 852, 855, 858, 
	861, 864, 867, 870, 873, 875, 877, 879, 
	881, 883, 885, 887, 889, 891, 893, 895, 
	897, 899, 901, 903, 905, 907, 909, 911, 
	913, 915, 923, 926, 933, 936, 939, 942, 
	945, 948, 951, 954, 957, 960, 963, 966, 
	969, 972, 975, 978, 981, 984, 987, 990, 
	993, 996, 999, 1002, 1005, 1008, 1011, 1014, 
	1017, 1020, 1023, 1026, 1029, 1032, 1035, 1038, 
	1041, 1044, 1047, 1050, 1053, 1056, 1059, 1062, 
	1065, 1068, 1071, 1074, 1077, 1080, 1083, 1086, 
	1089, 1092, 1095, 1098, 1101, 1104, 1107, 1110, 
	1113, 1116, 1119, 1122, 1125, 1128, 1131, 1134, 
	1137, 1140, 1143, 1146, 1149, 1152, 1155, 1158, 
	1161, 1164, 1167, 1170, 1173, 1176, 1179, 1182, 
	1185, 1188, 1191, 1194, 1197, 1200, 1203, 1205, 
	1207, 1209, 1211, 1213, 1215, 1217, 1219, 1221, 
	1223, 1225, 1227, 1229, 1231, 1233, 1235, 1237, 
	1239, 1241, 1243, 1245, 1247, 1249, 1251, 1253, 
	1255, 1257, 1259, 1261, 1263, 1265, 1267, 1269, 
	1271, 1273, 1275, 1277, 1279, 1281, 1283, 1285, 
	1287, 1289, 1291, 1293, 1295, 1297, 1299, 1308, 
	1311, 1320, 1323, 1326, 1329, 1332, 1335, 1338, 
	1341, 1344, 1347, 1350, 1353, 1356, 1359, 1362, 
	1365, 1368, 1371, 1374, 1377, 1380, 1383, 1386, 
	1389, 1392, 1395, 1398, 1401, 1404, 1407, 1410, 
	1413, 1416, 1419, 1422, 1425, 1428, 1431, 1434, 
	1437, 1440, 1443, 1446, 1449, 1452, 1455, 1458, 
	1461, 1464, 1467, 1470, 1473, 1476, 1479, 1482, 
	1485, 1489, 1492, 1495, 1498, 1501, 1504, 1507, 
	1510, 1513, 1516, 1519, 1522, 1525, 1528, 1531, 
	1534, 1537, 1540, 1543, 1546, 1549, 1552, 1555, 
	1558, 1561, 1564, 1567, 1570, 1573, 1576, 1579, 
	1582, 1585, 1588, 1591, 1594, 1597, 1600, 1603, 
	1606, 1609, 1612, 1615, 1618, 1621, 1624, 1627, 
	1630, 1633, 1636, 1639, 1642, 1645, 1648, 1651, 
	1654, 1657, 1660, 1663, 1666, 1669, 1672, 1675, 
	1678, 1681, 1684, 1687, 1690, 1693, 1696, 1699, 
	1702, 1705, 1708, 1711, 1714, 1717, 1720, 1723, 
	1726, 1729, 1732, 1735, 1738, 1741, 1744, 1747, 
	1750, 1753, 1756, 1759, 1762, 1765, 1768, 1771, 
	1774, 1777, 1779, 1781, 1783, 1785, 1787, 1789, 
	1791, 1793, 1795, 1797, 1799, 1801, 1803, 1805, 
	1807, 1809, 1811, 1813, 1815, 1817, 1819, 1821, 
	1823, 1825, 1827, 1829, 1831, 1833, 1835, 1837, 
	1839, 1841, 1843, 1845, 1847, 1849, 1858, 1861, 
	1871, 1874, 1877, 1880, 1883, 1886, 1889, 1892, 
	1895, 1898, 1901, 1904, 1907, 1910, 1913, 1916, 
	1919, 1922, 1925, 1928, 1931, 1934, 1937, 1940, 
	1943, 1946, 1949, 1952, 1955, 1958, 1961, 1964, 
	1967, 1970, 1973, 1976, 1979, 1982, 1985, 1988, 
	1991, 1994, 1997, 2000, 2003, 2006, 2009, 2012, 
	2015, 2018, 2021, 2024, 2027, 2030, 2033, 2036, 
	2040, 2043, 2046, 2049, 2052, 2055, 2058, 2061, 
	2064, 2067, 2070, 2073, 2076, 2079, 2082, 2085, 
	2088, 2091, 2094, 2097, 2100, 2103, 2106, 2109, 
	2112, 2115, 2118, 2121, 2124, 2127, 2130, 2133, 
	2136, 2139, 2142, 2145, 2148, 2151, 2154, 2157, 
	2160, 2163, 2166, 2169, 2172, 2175, 2178, 2181, 
	2184, 2187, 2190, 2193, 2196, 2199, 2202, 2205, 
	2208, 2211, 2214, 2217, 2220, 2223, 2226, 2229, 
	2232, 2235, 2238, 2241, 2244, 2247, 2250, 2253, 
	2256, 2259, 2262, 2265, 2268, 2271, 2274, 2277, 
	2280, 2283, 2286, 2289, 2292, 2295, 2298, 2301, 
	2304, 2307, 2310, 2313, 2316, 2319, 2322, 2325, 
	2328, 2331, 2334, 2337, 2340, 2343, 2346, 2349, 
	2352, 2355, 2358, 2361, 2364, 2367, 2370, 2373, 
	2375, 2377
};

static const short _lexer_trans_targs[] = {
	2, 823, 25, 25, 26, 36, 38, 22, 
	52, 55, 25, 0, 3, 0, 4, 61, 
	95, 136, 306, 414, 441, 617, 626, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 11, 0, 12, 0, 
	13, 0, 14, 0, 15, 0, 16, 0, 
	17, 0, 18, 0, 19, 0, 20, 0, 
	21, 0, 22, 0, 23, 0, 25, 37, 
	24, 25, 37, 24, 2, 25, 25, 26, 
	36, 38, 22, 52, 55, 25, 0, 27, 
	0, 28, 0, 30, 29, 29, 30, 29, 
	29, 31, 31, 32, 31, 31, 31, 31, 
	32, 31, 31, 31, 31, 33, 31, 31, 
	31, 31, 34, 31, 31, 25, 35, 35, 
	0, 25, 35, 35, 0, 25, 37, 36, 
	25, 0, 39, 0, 40, 0, 41, 0, 
	42, 0, 43, 0, 44, 0, 45, 0, 
	46, 0, 47, 0, 48, 0, 49, 0, 
	50, 0, 51, 0, 825, 0, 0, 0, 
	0, 0, 53, 54, 25, 54, 54, 52, 
	53, 53, 25, 54, 52, 54, 0, 55, 
	56, 55, 0, 60, 59, 58, 56, 59, 
	57, 0, 58, 56, 57, 0, 58, 57, 
	60, 59, 58, 56, 59, 57, 2, 60, 
	60, 26, 36, 38, 22, 52, 55, 60, 
	0, 62, 0, 63, 0, 64, 0, 65, 
	0, 66, 0, 67, 0, 68, 0, 69, 
	0, 70, 0, 71, 0, 72, 0, 73, 
	0, 74, 0, 75, 0, 76, 0, 77, 
	0, 78, 0, 79, 0, 80, 0, 81, 
	0, 82, 0, 83, 0, 84, 0, 85, 
	0, 86, 0, 87, 0, 88, 0, 89, 
	0, 90, 0, 91, 0, 92, 0, 93, 
	0, 94, 0, 22, 0, 96, 0, 97, 
	0, 98, 0, 99, 0, 100, 0, 101, 
	0, 102, 0, 103, 0, 104, 0, 105, 
	0, 106, 0, 107, 0, 108, 0, 109, 
	0, 110, 0, 111, 0, 112, 0, 113, 
	0, 114, 0, 115, 0, 116, 0, 117, 
	0, 119, 118, 119, 118, 120, 119, 119, 
	25, 25, 119, 118, 121, 119, 118, 122, 
	119, 118, 123, 119, 118, 124, 119, 118, 
	125, 119, 118, 126, 119, 118, 127, 119, 
	118, 128, 119, 118, 129, 119, 118, 130, 
	119, 118, 131, 119, 118, 132, 119, 118, 
	133, 119, 118, 134, 119, 118, 119, 135, 
	118, 2, 25, 25, 26, 36, 38, 22, 
	52, 55, 25, 0, 137, 0, 138, 0, 
	139, 300, 0, 140, 0, 141, 0, 142, 
	0, 143, 0, 144, 0, 145, 0, 146, 
	0, 148, 147, 148, 147, 149, 148, 148, 
	25, 286, 169, 25, 148, 147, 150, 148, 
	147, 151, 170, 204, 213, 226, 253, 262, 
	148, 147, 152, 148, 147, 153, 148, 147, 
	154, 148, 147, 155, 148, 147, 156, 148, 
	147, 157, 148, 147, 158, 148, 147, 159, 
	148, 147, 160, 148, 147, 161, 148, 147, 
	162, 148, 147, 163, 148, 147, 164, 148, 
	147, 165, 148, 147, 166, 148, 147, 167, 
	148, 147, 168, 148, 147, 169, 148, 147, 
	148, 135, 147, 148, 171, 147, 172, 148, 
	147, 173, 148, 147, 174, 148, 147, 175, 
	148, 147, 176, 148, 147, 177, 148, 147, 
	178, 148, 147, 179, 148, 147, 180, 148, 
	147, 181, 148, 147, 182, 148, 147, 183, 
	148, 147, 184, 148, 147, 185, 148, 147, 
	186, 148, 147, 187, 148, 147, 188, 148, 
	147, 189, 148, 147, 190, 148, 147, 191, 
	148, 147, 192, 148, 147, 193, 148, 147, 
	194, 148, 147, 195, 148, 147, 196, 148, 
	147, 197, 148, 147, 198, 148, 147, 199, 
	148, 147, 200, 148, 147, 201, 148, 147, 
	202, 148, 147, 203, 148, 147, 169, 148, 
	147, 205, 148, 147, 206, 148, 147, 207, 
	148, 147, 208, 148, 147, 209, 148, 147, 
	210, 148, 147, 211, 148, 147, 212, 148, 
	147, 169, 148, 147, 214, 148, 147, 215, 
	148, 147, 216, 148, 147, 217, 148, 147, 
	218, 148, 147, 219, 148, 147, 220, 148, 
	147, 221, 148, 147, 222, 148, 147, 223, 
	148, 147, 224, 148, 147, 225, 148, 147, 
	148, 135, 147, 227, 148, 147, 228, 148, 
	147, 229, 148, 147, 230, 148, 147, 231, 
	148, 147, 232, 148, 147, 233, 148, 147, 
	234, 148, 147, 235, 148, 147, 236, 148, 
	147, 237, 148, 147, 238, 148, 147, 239, 
	148, 147, 240, 148, 147, 241, 148, 147, 
	242, 148, 147, 243, 148, 147, 244, 148, 
	147, 245, 148, 147, 246, 148, 147, 247, 
	148, 147, 248, 148, 147, 249, 148, 147, 
	250, 148, 147, 251, 148, 147, 252, 148, 
	147, 210, 148, 147, 254, 148, 147, 255, 
	148, 147, 256, 148, 147, 257, 148, 147, 
	258, 148, 147, 259, 148, 147, 260, 148, 
	147, 261, 148, 147, 166, 148, 147, 263, 
	148, 147, 264, 148, 147, 265, 148, 147, 
	266, 148, 147, 267, 148, 147, 268, 148, 
	147, 269, 148, 147, 270, 148, 147, 271, 
	148, 147, 272, 148, 147, 273, 148, 147, 
	274, 148, 147, 275, 148, 147, 276, 148, 
	147, 277, 148, 147, 278, 148, 147, 279, 
	148, 147, 280, 148, 147, 281, 148, 147, 
	282, 148, 147, 283, 148, 147, 284, 148, 
	147, 285, 148, 147, 225, 148, 147, 148, 
	287, 147, 148, 288, 147, 148, 289, 147, 
	148, 290, 147, 148, 291, 147, 148, 292, 
	147, 148, 293, 147, 148, 294, 147, 148, 
	295, 147, 148, 296, 147, 148, 297, 147, 
	148, 298, 147, 148, 299, 147, 148, 25, 
	147, 301, 0, 302, 0, 303, 0, 304, 
	0, 305, 0, 22, 0, 307, 0, 308, 
	0, 309, 0, 310, 0, 311, 0, 312, 
	0, 313, 0, 314, 0, 315, 0, 316, 
	0, 317, 0, 318, 0, 319, 0, 321, 
	320, 321, 320, 322, 321, 321, 25, 400, 
	25, 321, 320, 323, 321, 320, 324, 346, 
	355, 364, 379, 321, 320, 325, 321, 320, 
	326, 321, 320, 327, 321, 320, 328, 321, 
	320, 329, 321, 320, 330, 321, 320, 331, 
	321, 320, 332, 321, 320, 333, 321, 320, 
	334, 321, 320, 335, 321, 320, 336, 321, 
	320, 337, 321, 320, 338, 321, 320, 339, 
	321, 320, 340, 321, 320, 341, 321, 320, 
	342, 321, 320, 343, 321, 320, 344, 321, 
	320, 345, 321, 320, 321, 135, 320, 347, 
	321, 320, 348, 321, 320, 349, 321, 320, 
	350, 321, 320, 351, 321, 320, 352, 321, 
	320, 353, 321, 320, 354, 321, 320, 345, 
	321, 320, 356, 321, 320, 357, 321, 320, 
	358, 321, 320, 359, 321, 320, 360, 321, 
	320, 361, 321, 320, 362, 321, 320, 363, 
	321, 320, 342, 321, 320, 365, 321, 320, 
	366, 321, 320, 367, 321, 320, 368, 321, 
	320, 369, 321, 320, 370, 321, 320, 371, 
	321, 320, 372, 321, 320, 373, 321, 320, 
	374, 321, 320, 375, 321, 320, 376, 321, 
	320, 377, 321, 320, 378, 321, 320, 352, 
	321, 320, 380, 321, 320, 381, 321, 320, 
	382, 321, 320, 383, 321, 320, 384, 321, 
	320, 385, 321, 320, 386, 321, 320, 387, 
	321, 320, 388, 321, 320, 389, 321, 320, 
	390, 321, 320, 391, 321, 320, 392, 321, 
	320, 393, 321, 320, 394, 321, 320, 395, 
	321, 320, 396, 321, 320, 397, 321, 320, 
	398, 321, 320, 399, 321, 320, 352, 321, 
	320, 321, 401, 320, 321, 402, 320, 321, 
	403, 320, 321, 404, 320, 321, 405, 320, 
	321, 406, 320, 321, 407, 320, 321, 408, 
	320, 321, 409, 320, 321, 410, 320, 321, 
	411, 320, 321, 412, 320, 321, 413, 320, 
	321, 25, 320, 415, 0, 416, 0, 417, 
	0, 418, 0, 419, 0, 420, 0, 421, 
	0, 422, 0, 423, 0, 424, 0, 425, 
	0, 426, 0, 427, 0, 428, 0, 429, 
	0, 430, 0, 431, 0, 432, 0, 433, 
	0, 434, 0, 435, 0, 436, 0, 437, 
	0, 438, 0, 439, 0, 440, 0, 303, 
	0, 442, 0, 443, 0, 444, 0, 445, 
	0, 446, 0, 447, 0, 448, 0, 449, 
	0, 450, 0, 451, 0, 452, 0, 453, 
	0, 454, 0, 455, 0, 456, 0, 457, 
	0, 458, 0, 459, 0, 460, 0, 462, 
	461, 462, 461, 463, 462, 462, 25, 603, 
	483, 25, 462, 461, 464, 462, 461, 465, 
	484, 518, 534, 546, 573, 582, 462, 461, 
	466, 462, 461, 467, 462, 461, 468, 462, 
	461, 469, 462, 461, 470, 462, 461, 471, 
	462, 461, 472, 462, 461, 473, 462, 461, 
	474, 462, 461, 475, 462, 461, 476, 462, 
	461, 477, 462, 461, 478, 462, 461, 479, 
	462, 461, 480, 462, 461, 481, 462, 461, 
	482, 462, 461, 483, 462, 461, 462, 135, 
	461, 462, 485, 461, 486, 462, 461, 487, 
	462, 461, 488, 462, 461, 489, 462, 461, 
	490, 462, 461, 491, 462, 461, 492, 462, 
	461, 493, 462, 461, 494, 462, 461, 495, 
	462, 461, 496, 462, 461, 497, 462, 461, 
	498, 462, 461, 499, 462, 461, 500, 462, 
	461, 501, 462, 461, 502, 462, 461, 503, 
	462, 461, 504, 462, 461, 505, 462, 461, 
	506, 462, 461, 507, 462, 461, 508, 462, 
	461, 509, 462, 461, 510, 462, 461, 511, 
	462, 461, 512, 462, 461, 513, 462, 461, 
	514, 462, 461, 515, 462, 461, 516, 462, 
	461, 517, 462, 461, 483, 462, 461, 519, 
	462, 461, 520, 462, 461, 521, 528, 462, 
	461, 522, 462, 461, 523, 462, 461, 524, 
	462, 461, 525, 462, 461, 526, 462, 461, 
	527, 462, 461, 462, 135, 461, 529, 462, 
	461, 530, 462, 461, 531, 462, 461, 532, 
	462, 461, 533, 462, 461, 483, 462, 461, 
	535, 462, 461, 536, 462, 461, 537, 462, 
	461, 538, 462, 461, 539, 462, 461, 540, 
	462, 461, 541, 462, 461, 542, 462, 461, 
	543, 462, 461, 544, 462, 461, 545, 462, 
	461, 527, 462, 461, 547, 462, 461, 548, 
	462, 461, 549, 462, 461, 550, 462, 461, 
	551, 462, 461, 552, 462, 461, 553, 462, 
	461, 554, 462, 461, 555, 462, 461, 556, 
	462, 461, 557, 462, 461, 558, 462, 461, 
	559, 462, 461, 560, 462, 461, 561, 462, 
	461, 562, 462, 461, 563, 462, 461, 564, 
	462, 461, 565, 462, 461, 566, 462, 461, 
	567, 462, 461, 568, 462, 461, 569, 462, 
	461, 570, 462, 461, 571, 462, 461, 572, 
	462, 461, 531, 462, 461, 574, 462, 461, 
	575, 462, 461, 576, 462, 461, 577, 462, 
	461, 578, 462, 461, 579, 462, 461, 580, 
	462, 461, 581, 462, 461, 480, 462, 461, 
	583, 462, 461, 584, 462, 461, 585, 462, 
	461, 586, 462, 461, 587, 462, 461, 588, 
	462, 461, 589, 462, 461, 590, 462, 461, 
	591, 462, 461, 592, 462, 461, 593, 462, 
	461, 594, 462, 461, 595, 462, 461, 596, 
	462, 461, 597, 462, 461, 598, 462, 461, 
	599, 462, 461, 600, 462, 461, 601, 462, 
	461, 602, 462, 461, 524, 462, 461, 462, 
	604, 461, 462, 605, 461, 462, 606, 461, 
	462, 607, 461, 462, 608, 461, 462, 609, 
	461, 462, 610, 461, 462, 611, 461, 462, 
	612, 461, 462, 613, 461, 462, 614, 461, 
	462, 615, 461, 462, 616, 461, 462, 25, 
	461, 618, 0, 619, 0, 620, 0, 621, 
	0, 622, 0, 623, 0, 624, 0, 625, 
	0, 19, 0, 627, 0, 628, 0, 629, 
	0, 630, 0, 631, 0, 632, 0, 633, 
	0, 634, 0, 635, 0, 636, 0, 637, 
	0, 638, 0, 639, 0, 640, 0, 641, 
	0, 642, 0, 643, 0, 644, 0, 645, 
	0, 646, 0, 647, 0, 648, 0, 649, 
	0, 650, 0, 651, 0, 653, 652, 653, 
	652, 654, 653, 653, 25, 809, 674, 25, 
	653, 652, 655, 653, 652, 656, 675, 709, 
	725, 737, 764, 779, 788, 653, 652, 657, 
	653, 652, 658, 653, 652, 659, 653, 652, 
	660, 653, 652, 661, 653, 652, 662, 653, 
	652, 663, 653, 652, 664, 653, 652, 665, 
	653, 652, 666, 653, 652, 667, 653, 652, 
	668, 653, 652, 669, 653, 652, 670, 653, 
	652, 671, 653, 652, 672, 653, 652, 673, 
	653, 652, 674, 653, 652, 653, 135, 652, 
	653, 676, 652, 677, 653, 652, 678, 653, 
	652, 679, 653, 652, 680, 653, 652, 681, 
	653, 652, 682, 653, 652, 683, 653, 652, 
	684, 653, 652, 685, 653, 652, 686, 653, 
	652, 687, 653, 652, 688, 653, 652, 689, 
	653, 652, 690, 653, 652, 691, 653, 652, 
	692, 653, 652, 693, 653, 652, 694, 653, 
	652, 695, 653, 652, 696, 653, 652, 697, 
	653, 652, 698, 653, 652, 699, 653, 652, 
	700, 653, 652, 701, 653, 652, 702, 653, 
	652, 703, 653, 652, 704, 653, 652, 705, 
	653, 652, 706, 653, 652, 707, 653, 652, 
	708, 653, 652, 674, 653, 652, 710, 653, 
	652, 711, 653, 652, 712, 719, 653, 652, 
	713, 653, 652, 714, 653, 652, 715, 653, 
	652, 716, 653, 652, 717, 653, 652, 718, 
	653, 652, 653, 135, 652, 720, 653, 652, 
	721, 653, 652, 722, 653, 652, 723, 653, 
	652, 724, 653, 652, 674, 653, 652, 726, 
	653, 652, 727, 653, 652, 728, 653, 652, 
	729, 653, 652, 730, 653, 652, 731, 653, 
	652, 732, 653, 652, 733, 653, 652, 734, 
	653, 652, 735, 653, 652, 736, 653, 652, 
	718, 653, 652, 738, 653, 652, 739, 653, 
	652, 740, 653, 652, 741, 653, 652, 742, 
	653, 652, 743, 653, 652, 744, 653, 652, 
	745, 653, 652, 746, 653, 652, 747, 653, 
	652, 748, 653, 652, 749, 653, 652, 750, 
	653, 652, 751, 653, 652, 752, 653, 652, 
	753, 653, 652, 754, 653, 652, 755, 653, 
	652, 756, 653, 652, 757, 653, 652, 758, 
	653, 652, 759, 653, 652, 760, 653, 652, 
	761, 653, 652, 762, 653, 652, 763, 653, 
	652, 722, 653, 652, 765, 653, 652, 766, 
	653, 652, 767, 653, 652, 768, 653, 652, 
	769, 653, 652, 770, 653, 652, 771, 653, 
	652, 772, 653, 652, 773, 653, 652, 774, 
	653, 652, 775, 653, 652, 776, 653, 652, 
	777, 653, 652, 778, 653, 652, 715, 653, 
	652, 780, 653, 652, 781, 653, 652, 782, 
	653, 652, 783, 653, 652, 784, 653, 652, 
	785, 653, 652, 786, 653, 652, 787, 653, 
	652, 671, 653, 652, 789, 653, 652, 790, 
	653, 652, 791, 653, 652, 792, 653, 652, 
	793, 653, 652, 794, 653, 652, 795, 653, 
	652, 796, 653, 652, 797, 653, 652, 798, 
	653, 652, 799, 653, 652, 800, 653, 652, 
	801, 653, 652, 802, 653, 652, 803, 653, 
	652, 804, 653, 652, 805, 653, 652, 806, 
	653, 652, 807, 653, 652, 808, 653, 652, 
	715, 653, 652, 653, 810, 652, 653, 811, 
	652, 653, 812, 652, 653, 813, 652, 653, 
	814, 652, 653, 815, 652, 653, 816, 652, 
	653, 817, 652, 653, 818, 652, 653, 819, 
	652, 653, 820, 652, 653, 821, 652, 653, 
	822, 652, 653, 25, 652, 824, 0, 25, 
	0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 43, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 149, 126, 
	57, 110, 23, 0, 29, 54, 0, 5, 
	1, 0, 29, 1, 35, 0, 43, 0, 
	43, 0, 43, 139, 48, 9, 106, 11, 
	0, 134, 45, 45, 45, 3, 122, 33, 
	33, 33, 0, 122, 33, 33, 33, 0, 
	122, 33, 0, 33, 0, 102, 7, 7, 
	43, 54, 0, 0, 43, 114, 25, 0, 
	54, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 43, 43, 
	43, 43, 0, 27, 118, 27, 27, 51, 
	27, 0, 54, 0, 1, 0, 43, 0, 
	0, 0, 43, 54, 37, 37, 87, 37, 
	37, 43, 0, 39, 0, 43, 0, 0, 
	54, 0, 0, 39, 0, 0, 96, 54, 
	0, 93, 90, 41, 96, 90, 99, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	81, 81, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 21, 
	0, 63, 130, 31, 60, 57, 31, 63, 
	57, 66, 31, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	78, 33, 84, 78, 0, 0, 0, 54, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 19, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 19, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 69, 33, 
	69, 0, 0, 0, 54, 0, 0, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 13, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 72, 33, 
	84, 72, 0, 0, 0, 54, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 15, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 75, 33, 84, 75, 
	0, 0, 0, 54, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 17, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 0, 43, 0, 
	43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 825;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/tl.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1625 "ext/gherkin_lexer_tl/gherkin_lexer_tl.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/tl.c.rl"
    
#line 1632 "ext/gherkin_lexer_tl/gherkin_lexer_tl.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/tl.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/tl.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/tl.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/tl.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/tl.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/tl.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/tl.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/tl.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/tl.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/tl.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/tl.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/tl.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/tl.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/tl.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/tl.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/tl.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/tl.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/tl.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/tl.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/tl.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/tl.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/tl.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/tl.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/tl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1922 "ext/gherkin_lexer_tl/gherkin_lexer_tl.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/tl.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1985 "ext/gherkin_lexer_tl/gherkin_lexer_tl.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/tl.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_tl()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Tl", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

