pq-sys
======

Autogenerated Rust bindings for libpq

Building
--------

This repository contains direct, one-to-one mappings to the C functions provided
in `libpq-fe.h` and `postgres_ext.h`. This library expects that libpq be
installed on the system.

The build script of crate will attempt to find the lib path of libpq using the
following methods:

* First it will look for an environment variable in the format of `PQ_LIB_DIR_{TARGET}`
where `{TARGET}` gets replaced by the Target environment variable set for cross-compilation
* Second, if the environment variable `PQ_LIB_DIR` is set, it will use its value
* If the environment variable isn't set, it tries to use pkg-config to locate it.
All the config options, such as `PKG_CONFIG_ALLOW_CROSS`, `PKG_CONFIG_ALL_STATIC`
etc., of the crate [pkg-config](https://docs.rs/pkg-config/)
apply.
* Then, for MSVC ABI builds the build script will attempt use the library from a
[vcpkg](https://github.com/Microsoft/vcpkg) installation if there is one available.
You may need to set VCPKG_ROOT (or run `vcpkg integrate install`), set VCPKGRS_DYNAMIC=1, and run
`vcpkg install libpq:x64-windows`. See the documentation for the [vcpkg](https://docs.rs/vcpkg/) crate for more.
* If it still can't locate the library, it will invoke the Postgres command
`pg_config --libdir`

The build script instructs Cargo to link the library statically if the environmental
variable `PQ_LIB_STATIC` is set. This can be useful, if targeting for a musl target.
If pkg-config is being used, it's configuration options will apply.

## FAQ

### I'm seeing `dyld: Symbol not found __cg_jpeg_resync_to_restart` on macOS

This is caused when the output of `pg_config --libdir` is a directory that also
contains `libjpeg.dylib` which differs from the system libjpeg. This is usually
caused by install postgres via homebrew, or using postgresapp.com.

If you've installed via homebrew, you should not see this issue unless you've
provided `features = ["pkg-config"]`. You can work around the issue by exporting
`PQ_LIB_DIR="$(brew --prefix postgres)/lib"`.

If you've installed postgresql using postgresapp.com, you will not be able to
run your binaries using `cargo run` or `cargo test`. You can compile the binary
manually via `cargo build` and then run `/target/debug/yourapp`. You can also
manually create a directory that contains only a symlink to `libpq.dylib` and
nothing else, then export `PQ_LIB_DIR` to that directory. It is recommended that
you do not use postgresapp.com.

## License

Licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or
   http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or
   http://opensource.org/licenses/MIT)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.
