Attempted to cast to/from a pointer with an unknown kind.

Erroneous code examples:

```compile_fail,E0641
let b = 0 as *const _; // error
```

Must give information for type of pointer that is being cast from/to if the
type cannot be inferred.

```
// Creating a pointer from reference: type can be inferred
let a = &(String::from("Hello world!")) as *const _; // Ok

let b = 0 as *const i32; // Ok

let c: *const i32 = 0 as *const _; // Ok
```
