//go:build wasip1

//
//Copyright The containerd Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go-plugin. DO NOT EDIT.
// versions:
// 	protoc-gen-go-plugin v0.1.0
// 	protoc               v3.20.1
// source: pkg/api/api.proto

package api

import (
	context "context"
	wasm "github.com/knqyf263/go-plugin/wasm"
	_ "unsafe"
)

const PluginPluginAPIVersion = 1

//go:wasmexport plugin_api_version
func _plugin_api_version() uint64 {
	return PluginPluginAPIVersion
}

var plugin Plugin

func RegisterPlugin(p Plugin) {
	plugin = p
}

//go:wasmexport plugin_configure
func _plugin_configure(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(ConfigureRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.Configure(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_synchronize
func _plugin_synchronize(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(SynchronizeRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.Synchronize(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_shutdown
func _plugin_shutdown(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(Empty)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.Shutdown(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_create_container
func _plugin_create_container(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(CreateContainerRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.CreateContainer(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_update_container
func _plugin_update_container(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(UpdateContainerRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.UpdateContainer(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_stop_container
func _plugin_stop_container(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(StopContainerRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.StopContainer(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_update_pod_sandbox
func _plugin_update_pod_sandbox(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(UpdatePodSandboxRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.UpdatePodSandbox(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_state_change
func _plugin_state_change(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(StateChangeEvent)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.StateChange(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

//go:wasmexport plugin_validate_container_adjustment
func _plugin_validate_container_adjustment(ptr, size uint32) uint64 {
	b := wasm.PtrToByte(ptr, size)
	req := new(ValidateContainerAdjustmentRequest)
	if err := req.UnmarshalVT(b); err != nil {
		return 0
	}
	response, err := plugin.ValidateContainerAdjustment(context.Background(), req)
	if err != nil {
		ptr, size = wasm.ByteToPtr([]byte(err.Error()))
		return (uint64(ptr) << uint64(32)) | uint64(size) |
			// Indicate that this is the error string by setting the 32-th bit, assuming that
			// no data exceeds 31-bit size (2 GiB).
			(1 << 31)
	}

	b, err = response.MarshalVT()
	if err != nil {
		return 0
	}
	ptr, size = wasm.ByteToPtr(b)
	return (uint64(ptr) << uint64(32)) | uint64(size)
}

type hostFunctions struct{}

func NewHostFunctions() HostFunctions {
	return hostFunctions{}
}

//go:wasmimport env log
func _log(ptr uint32, size uint32) uint64

func (h hostFunctions) Log(ctx context.Context, request *LogRequest) (*Empty, error) {
	buf, err := request.MarshalVT()
	if err != nil {
		return nil, err
	}
	ptr, size := wasm.ByteToPtr(buf)
	ptrSize := _log(ptr, size)
	wasm.Free(ptr)

	ptr = uint32(ptrSize >> 32)
	size = uint32(ptrSize)
	buf = wasm.PtrToByte(ptr, size)

	response := new(Empty)
	if err = response.UnmarshalVT(buf); err != nil {
		return nil, err
	}
	return response, nil
}
