//===-- Floating point math functions ---------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIBC_SHARED_MATH_H
#define LLVM_LIBC_SHARED_MATH_H

#include "libc_common.h"

#include "math/expf.h"
#include "math/expf16.h"
#include "math/frexpf.h"
#include "math/frexpf128.h"
#include "math/frexpf16.h"
#include "math/ldexpf.h"
#include "math/ldexpf128.h"
#include "math/ldexpf16.h"

#endif // LLVM_LIBC_SHARED_MATH_H
