/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeChartElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.xml.sax.SAXException;

public class OdfChartDocument
extends OdfDocument {
    private static final String EMPTY_CHART_DOCUMENT_PATH = "/OdfChartDocument.odc";
    static final OdfPackageDocument.Resource EMPTY_CHART_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfChartDocument.odc");

    public static OdfChartDocument newChartDocument() throws Exception {
        return (OdfChartDocument)OdfDocument.loadTemplate(EMPTY_CHART_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.CHART);
    }

    public static OdfChartDocument newChartTemplateDocument() throws Exception {
        OdfChartDocument doc = (OdfChartDocument)OdfDocument.loadTemplate(EMPTY_CHART_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.CHART_TEMPLATE);
        doc.changeMode(OdfMediaType.CHART_TEMPLATE);
        return doc;
    }

    public static OdfChartDocument loadDocument(InputStream inputStream) throws Exception {
        return (OdfChartDocument)OdfDocument.loadDocument(inputStream);
    }

    public static OdfChartDocument loadDocument(String documentPath) throws Exception {
        return (OdfChartDocument)OdfDocument.loadDocument(documentPath);
    }

    public static OdfChartDocument loadDocument(File file) throws Exception {
        return (OdfChartDocument)OdfDocument.loadDocument(file);
    }

    protected OdfChartDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    @Override
    public OfficeChartElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeChartElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public static enum OdfMediaType implements MediaType
    {
        CHART(OdfDocument.OdfMediaType.CHART),
        CHART_TEMPLATE(OdfDocument.OdfMediaType.CHART_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

