CREATE TABLE parent (
	a int
);

ALTER TABLE parent SET (fillfactor = 50);
ALTER TABLE parent RESET (fillfactor);
ALTER TABLE parent SET UNLOGGED;
ALTER TABLE parent SET LOGGED;

CREATE INDEX parent_index ON parent(a);
ALTER TABLE parent CLUSTER ON parent_index;
DROP INDEX parent_index;

CREATE TABLE child () INHERITS (parent);

CREATE TABLE grandchild () INHERITS (child);

ALTER TABLE parent ADD COLUMN b serial;

ALTER TABLE parent RENAME COLUMN b TO c;

-- Constraint, no recursion
ALTER TABLE ONLY grandchild ADD CONSTRAINT a_pos CHECK (a > 0);
-- Constraint, with recursion
ALTER TABLE parent ADD CONSTRAINT a_pos CHECK (a > 0);

CREATE TABLE part (
	a int
) PARTITION BY RANGE (a);

CREATE TABLE part1 PARTITION OF part FOR VALUES FROM (1) to (100);

CREATE TABLE part2 (a int);
ALTER TABLE part ATTACH PARTITION part2 FOR VALUES FROM (101) to (200);
ALTER TABLE part DETACH PARTITION part2;
DROP TABLE part2;

ALTER TABLE part ADD PRIMARY KEY (a);

ALTER TABLE parent ALTER COLUMN a SET NOT NULL;
ALTER TABLE parent ALTER COLUMN a DROP NOT NULL;
ALTER TABLE parent ALTER COLUMN a SET NOT NULL;

ALTER TABLE parent ALTER COLUMN a ADD GENERATED ALWAYS AS IDENTITY;

ALTER TABLE parent ALTER COLUMN a SET GENERATED BY DEFAULT;

ALTER TABLE parent ALTER COLUMN a DROP IDENTITY;

ALTER TABLE parent ALTER COLUMN a SET STATISTICS 100;

ALTER TABLE parent ALTER COLUMN a SET STORAGE PLAIN;

ALTER TABLE parent ENABLE ROW LEVEL SECURITY;
ALTER TABLE parent NO FORCE ROW LEVEL SECURITY;
ALTER TABLE parent FORCE ROW LEVEL SECURITY;
ALTER TABLE parent DISABLE ROW LEVEL SECURITY;

CREATE STATISTICS parent_stat (dependencies) ON a, c FROM parent;

ALTER TABLE parent ALTER COLUMN c TYPE numeric;

ALTER TABLE parent ALTER COLUMN c SET DEFAULT 0;

CREATE TABLE tbl (
	a int generated always as (b::int * 2) stored,
	b text
);

ALTER TABLE tbl ALTER COLUMN a DROP EXPRESSION;

ALTER TABLE tbl ALTER COLUMN b SET COMPRESSION pglz;

CREATE TYPE comptype AS (r float8);
CREATE DOMAIN dcomptype AS comptype;
ALTER DOMAIN dcomptype ADD CONSTRAINT c1 check ((value).r > 0);
ALTER TYPE comptype ALTER ATTRIBUTE r TYPE bigint;
