/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.variant.variantcontext.Allele;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.pairhmm.JNILoglessPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.LoglessPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMMModel;
import org.broadinstitute.gatk.utils.pairhmm.VectorLoglessPairHMM;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class DebugJNILoglessPairHMM
extends LoglessPairHMM {
    private static final boolean dumpSandboxOnly = false;
    private static final boolean debug = false;
    private static final boolean verify = true;
    private static final boolean debug0_1 = false;
    private static final boolean debug1 = false;
    private static final boolean debug2 = false;
    private static final boolean debug3 = false;
    private int numCalls = 0;
    private int numComputeLikelihoodCalls = 0;
    protected HashMap<String, BufferedWriter> filenameToWriter = new HashMap();
    private JNILoglessPairHMM jniPairHMM = null;
    private HashMap<Haplotype, Integer> haplotypeToHaplotypeListIdxMap = null;

    public DebugJNILoglessPairHMM(PairHMM.HMM_IMPLEMENTATION hmmType) {
        switch (hmmType) {
            case VECTOR_LOGLESS_CACHING: {
                this.jniPairHMM = new VectorLoglessPairHMM();
                break;
            }
            default: {
                throw new UserException.BadArgumentValue("pairHMM", "Specified JNIPairHMM implementation is unrecognized or incompatible with     the HaplotypeCaller. Acceptable options are VECTOR_LOGLESS_CACHING");
            }
        }
    }

    @Override
    public void close() {
        this.jniPairHMM.close();
        this.debugClose();
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
    }

    @Override
    public void initialize(List<Haplotype> haplotypes, Map<String, List<GATKSAMRecord>> perSampleReadList, int readMaxLength, int haplotypeMaxLength) {
        super.initialize(haplotypes, perSampleReadList, readMaxLength, haplotypeMaxLength);
        this.jniPairHMM.initialize(haplotypes, perSampleReadList, readMaxLength, haplotypeMaxLength);
        this.haplotypeToHaplotypeListIdxMap = this.jniPairHMM.getHaplotypeToHaplotypeListIdxMap();
    }

    @Override
    public void finalizeRegion() {
        this.jniPairHMM.finalizeRegion();
    }

    @Override
    public PerReadAlleleLikelihoodMap computeLikelihoods(List<GATKSAMRecord> reads, Map<Allele, Haplotype> alleleHaplotypeMap, Map<GATKSAMRecord, byte[]> GCPArrayMap) {
        int readMaxLength = this.findMaxReadLength(reads);
        int haplotypeMaxLength = this.findMaxHaplotypeLength(alleleHaplotypeMap);
        if (!this.initialized || readMaxLength > this.maxReadLength || haplotypeMaxLength > this.maxHaplotypeLength) {
            this.initialize(readMaxLength, haplotypeMaxLength);
        }
        if (!this.initialized) {
            throw new IllegalStateException("Must call initialize before calling jniComputeLikelihoods in debug/verify mode");
        }
        int readListSize = reads.size();
        int numHaplotypes = alleleHaplotypeMap.size();
        int numTestcases = readListSize * numHaplotypes;
        int idx = 0;
        for (GATKSAMRecord gATKSAMRecord : reads) {
            byte[] overallGCP = GCPArrayMap.get(gATKSAMRecord);
            ++idx;
        }
        idx = 0;
        for (Map.Entry entry : alleleHaplotypeMap.entrySet()) {
            byte[] haplotypeBases = ((Haplotype)((Object)entry.getValue())).getBases();
            ++idx;
        }
        double[] likelihoodArray = null;
        Object var11_14 = null;
        this.jniPairHMM.computeLikelihoods(reads, alleleHaplotypeMap, GCPArrayMap);
        likelihoodArray = this.jniPairHMM.getLikelihoodArray();
        PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap = super.computeLikelihoods(reads, alleleHaplotypeMap, GCPArrayMap);
        boolean toDump = false;
        double[] tmpArray = new double[numHaplotypes];
        idx = 0;
        int idxInsideHaplotypeList = 0;
        int readIdx = 0;
        for (GATKSAMRecord read : reads) {
            for (int j = 0; j < numHaplotypes; ++j) {
                tmpArray[j] = likelihoodArray[readIdx + j];
            }
            for (Map.Entry<Allele, Haplotype> currEntry : alleleHaplotypeMap.entrySet()) {
                idxInsideHaplotypeList = this.haplotypeToHaplotypeListIdxMap.get((Object)currEntry.getValue());
                likelihoodArray[idx] = tmpArray[idxInsideHaplotypeList];
                ++idx;
            }
            readIdx += numHaplotypes;
        }
        for (int i = 0; i < likelihoodArray.length; ++i) {
            double abs_error = Math.abs(likelihoodArray[i] - this.mLikelihoodArray[i]);
            double relative_error = 0.0;
            relative_error = this.mLikelihoodArray[i] == 0.0 ? 0.0 : Math.abs(abs_error / this.mLikelihoodArray[i]);
            if (!(abs_error > 1.0E-5) || !(relative_error > 1.0E-5)) continue;
            toDump = true;
            break;
        }
        if (toDump) {
            idx = 0;
            System.out.println("Dump : Java numReads " + readListSize + " numHaplotypes " + numHaplotypes);
            boolean firstLine = true;
            for (GATKSAMRecord read : reads) {
                byte[] overallGCP = GCPArrayMap.get(read);
                byte[] tmpByteArray = new byte[read.getReadBases().length];
                for (Map.Entry<Allele, Haplotype> currEntry : alleleHaplotypeMap.entrySet()) {
                    int k;
                    byte[] haplotypeBases = currEntry.getValue().getBases();
                    this.debugDump("debug_dump.txt", new String(haplotypeBases) + " ", true);
                    this.debugDump("debug_dump.txt", new String(read.getReadBases()) + " ", true);
                    for (k = 0; k < read.getReadBases().length; ++k) {
                        tmpByteArray[k] = (byte)(read.getBaseQualities()[k] + 33);
                    }
                    this.debugDump("debug_dump.txt", new String(tmpByteArray) + " ", true);
                    for (k = 0; k < read.getReadBases().length; ++k) {
                        tmpByteArray[k] = (byte)(read.getBaseInsertionQualities()[k] + 33);
                    }
                    this.debugDump("debug_dump.txt", new String(tmpByteArray) + " ", true);
                    for (k = 0; k < read.getReadBases().length; ++k) {
                        tmpByteArray[k] = (byte)(read.getBaseDeletionQualities()[k] + 33);
                    }
                    this.debugDump("debug_dump.txt", new String(tmpByteArray) + " ", true);
                    for (k = 0; k < read.getReadBases().length; ++k) {
                        tmpByteArray[k] = (byte)(overallGCP[k] + 33);
                    }
                    this.debugDump("debug_dump.txt", new String(tmpByteArray), true);
                    if (firstLine) {
                        this.debugDump("debug_dump.txt", String.format(" %d %d\n", readListSize, numHaplotypes), true);
                        firstLine = false;
                    } else {
                        this.debugDump("debug_dump.txt", "\n", true);
                    }
                    this.debugDump("debug_results.txt", String.format("%e %e\n", this.mLikelihoodArray[idx], likelihoodArray[idx]), true);
                    ++idx;
                }
            }
        }
        this.debugClose();
        ++this.numComputeLikelihoodCalls;
        return perReadAlleleLikelihoodMap;
    }

    private native void jniInitialize(int var1, int var2);

    private static native void jniInitializeProbabilities(double[][] var0, byte[] var1, byte[] var2, byte[] var3);

    private native double jniInitializePriorsAndUpdateCells(boolean var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6, int var7);

    private native double jniSubComputeReadLikelihoodGivenHaplotypeLog10(int var1, int var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, int var9);

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        boolean doInitialization;
        boolean bl = doInitialization = this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length;
        if (doInitialization) {
            double initialValue = INITIAL_CONDITION / (double)haplotypeBases.length;
            for (int j = 0; j < this.paddedHaplotypeLength; ++j) {
                this.deletionMatrix[0][j] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            DebugJNILoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i = 1; i < this.paddedReadLength; ++i) {
            for (int j = hapStartIndex + 1; j < this.paddedHaplotypeLength; ++j) {
                this.updateCell(i, j, this.prior[i][j], this.transition[i]);
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = 0.0;
        for (int j = 1; j < this.paddedHaplotypeLength; ++j) {
            finalSumProbabilities += this.matchMatrix[endI][j] + this.insertionMatrix[endI][j];
        }
        ++this.numCalls;
        return Math.log10(finalSumProbabilities) - INITIAL_CONDITION_LOG10;
    }

    @Override
    protected void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.prior[i + 1][j + 1] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual) / (this.doNotUseTristateCorrection ? 1.0 : 3.0);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected static void initializeProbabilities(double[][] transition, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        PairHMMModel.qualToTransProbs(transition, insertionGOP, deletionGOP, overallGCP);
    }

    @Override
    protected void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior * (this.matchMatrix[indI - 1][indJ - 1] * transition[0] + this.insertionMatrix[indI - 1][indJ - 1] * transition[1] + this.deletionMatrix[indI - 1][indJ - 1] * transition[1]);
        this.insertionMatrix[indI][indJ] = this.matchMatrix[indI - 1][indJ] * transition[2] + this.insertionMatrix[indI - 1][indJ] * transition[3];
        this.deletionMatrix[indI][indJ] = this.matchMatrix[indI][indJ - 1] * transition[4] + this.deletionMatrix[indI][indJ - 1] * transition[5];
    }

    protected void debugDump(String filename, String s, boolean toAppend) {
        try {
            BufferedWriter currWriter;
            File file = new File(filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((currWriter = this.filenameToWriter.get(filename)) == null) {
                FileWriter fw = new FileWriter(file, toAppend);
                currWriter = new BufferedWriter(fw);
                this.filenameToWriter.put(filename, currWriter);
            }
            currWriter.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void debugClose() {
        for (Map.Entry<String, BufferedWriter> currEntry : this.filenameToWriter.entrySet()) {
            BufferedWriter currWriter = currEntry.getValue();
            try {
                currWriter.flush();
                currWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.filenameToWriter.clear();
    }
}

