// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/ad_group_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AdGroupService.GetAdGroup][google.ads.googleads.v3.services.AdGroupService.GetAdGroup].
type GetAdGroupRequest struct {
	// Required. The resource name of the ad group to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupRequest) Reset()         { *m = GetAdGroupRequest{} }
func (m *GetAdGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupRequest) ProtoMessage()    {}
func (*GetAdGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4788d5c8fc9bdd61, []int{0}
}

func (m *GetAdGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupRequest.Unmarshal(m, b)
}
func (m *GetAdGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetAdGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupRequest.Merge(m, src)
}
func (m *GetAdGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupRequest.Size(m)
}
func (m *GetAdGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupRequest proto.InternalMessageInfo

func (m *GetAdGroupRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupService.MutateAdGroups][google.ads.googleads.v3.services.AdGroupService.MutateAdGroups].
type MutateAdGroupsRequest struct {
	// Required. The ID of the customer whose ad groups are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual ad groups.
	Operations []*AdGroupOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupsRequest) Reset()         { *m = MutateAdGroupsRequest{} }
func (m *MutateAdGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupsRequest) ProtoMessage()    {}
func (*MutateAdGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4788d5c8fc9bdd61, []int{1}
}

func (m *MutateAdGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupsRequest.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupsRequest.Merge(m, src)
}
func (m *MutateAdGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupsRequest.Size(m)
}
func (m *MutateAdGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupsRequest proto.InternalMessageInfo

func (m *MutateAdGroupsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupsRequest) GetOperations() []*AdGroupOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateAdGroupsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateAdGroupsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on an ad group.
type AdGroupOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupOperation_Create
	//	*AdGroupOperation_Update
	//	*AdGroupOperation_Remove
	Operation            isAdGroupOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupOperation) Reset()         { *m = AdGroupOperation{} }
func (m *AdGroupOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupOperation) ProtoMessage()    {}
func (*AdGroupOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_4788d5c8fc9bdd61, []int{2}
}

func (m *AdGroupOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupOperation.Unmarshal(m, b)
}
func (m *AdGroupOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupOperation.Marshal(b, m, deterministic)
}
func (m *AdGroupOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupOperation.Merge(m, src)
}
func (m *AdGroupOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupOperation.Size(m)
}
func (m *AdGroupOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupOperation proto.InternalMessageInfo

func (m *AdGroupOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isAdGroupOperation_Operation interface {
	isAdGroupOperation_Operation()
}

type AdGroupOperation_Create struct {
	Create *resources.AdGroup `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupOperation_Update struct {
	Update *resources.AdGroup `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdGroupOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdGroupOperation_Create) isAdGroupOperation_Operation() {}

func (*AdGroupOperation_Update) isAdGroupOperation_Operation() {}

func (*AdGroupOperation_Remove) isAdGroupOperation_Operation() {}

func (m *AdGroupOperation) GetOperation() isAdGroupOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupOperation) GetCreate() *resources.AdGroup {
	if x, ok := m.GetOperation().(*AdGroupOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupOperation) GetUpdate() *resources.AdGroup {
	if x, ok := m.GetOperation().(*AdGroupOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdGroupOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupOperation_Create)(nil),
		(*AdGroupOperation_Update)(nil),
		(*AdGroupOperation_Remove)(nil),
	}
}

// Response message for an ad group mutate.
type MutateAdGroupsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateAdGroupResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MutateAdGroupsResponse) Reset()         { *m = MutateAdGroupsResponse{} }
func (m *MutateAdGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupsResponse) ProtoMessage()    {}
func (*MutateAdGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4788d5c8fc9bdd61, []int{3}
}

func (m *MutateAdGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupsResponse.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupsResponse.Merge(m, src)
}
func (m *MutateAdGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupsResponse.Size(m)
}
func (m *MutateAdGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupsResponse proto.InternalMessageInfo

func (m *MutateAdGroupsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateAdGroupsResponse) GetResults() []*MutateAdGroupResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the ad group mutate.
type MutateAdGroupResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupResult) Reset()         { *m = MutateAdGroupResult{} }
func (m *MutateAdGroupResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupResult) ProtoMessage()    {}
func (*MutateAdGroupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_4788d5c8fc9bdd61, []int{4}
}

func (m *MutateAdGroupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupResult.Unmarshal(m, b)
}
func (m *MutateAdGroupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupResult.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupResult.Merge(m, src)
}
func (m *MutateAdGroupResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupResult.Size(m)
}
func (m *MutateAdGroupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupResult proto.InternalMessageInfo

func (m *MutateAdGroupResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupRequest)(nil), "google.ads.googleads.v3.services.GetAdGroupRequest")
	proto.RegisterType((*MutateAdGroupsRequest)(nil), "google.ads.googleads.v3.services.MutateAdGroupsRequest")
	proto.RegisterType((*AdGroupOperation)(nil), "google.ads.googleads.v3.services.AdGroupOperation")
	proto.RegisterType((*MutateAdGroupsResponse)(nil), "google.ads.googleads.v3.services.MutateAdGroupsResponse")
	proto.RegisterType((*MutateAdGroupResult)(nil), "google.ads.googleads.v3.services.MutateAdGroupResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/ad_group_service.proto", fileDescriptor_4788d5c8fc9bdd61)
}

var fileDescriptor_4788d5c8fc9bdd61 = []byte{
	// 771 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xcd, 0x6e, 0xd3, 0x4c,
	0x14, 0xfd, 0xec, 0x7c, 0x2a, 0x74, 0xd2, 0x16, 0x98, 0xaa, 0x25, 0x04, 0x24, 0x22, 0x53, 0x89,
	0x28, 0x2a, 0x36, 0x4a, 0x84, 0x8a, 0x5c, 0x75, 0xe1, 0x08, 0x9a, 0xb2, 0x28, 0x2d, 0xae, 0x54,
	0x24, 0x14, 0xc9, 0x9a, 0xd8, 0xd3, 0x60, 0xd5, 0xf6, 0x98, 0x19, 0x3b, 0x52, 0x55, 0x75, 0xd3,
	0x57, 0xe0, 0x0d, 0x58, 0xb2, 0xeb, 0x96, 0x47, 0xe8, 0x16, 0x89, 0x45, 0x57, 0x5d, 0x74, 0xc5,
	0x23, 0x74, 0x85, 0xec, 0x99, 0xc9, 0x1f, 0x8d, 0xa2, 0xb2, 0xbb, 0x99, 0x7b, 0xce, 0xb9, 0xf7,
	0xce, 0x99, 0xeb, 0x80, 0xb5, 0x2e, 0x21, 0xdd, 0x00, 0x1b, 0xc8, 0x63, 0x06, 0x0f, 0xb3, 0xa8,
	0xd7, 0x30, 0x18, 0xa6, 0x3d, 0xdf, 0xc5, 0xcc, 0x40, 0x9e, 0xd3, 0xa5, 0x24, 0x8d, 0x1d, 0x71,
	0xa2, 0xc7, 0x94, 0x24, 0x04, 0x56, 0x38, 0x5a, 0x47, 0x1e, 0xd3, 0xfb, 0x44, 0xbd, 0xd7, 0xd0,
	0x25, 0xb1, 0xfc, 0x72, 0x92, 0x34, 0xc5, 0x8c, 0xa4, 0x74, 0x58, 0x9b, 0x6b, 0x96, 0x9f, 0x48,
	0x46, 0xec, 0x1b, 0x28, 0x8a, 0x48, 0x82, 0x12, 0x9f, 0x44, 0x4c, 0x64, 0x1f, 0x0e, 0x65, 0xdd,
	0xc0, 0xc7, 0x51, 0x22, 0x12, 0x4f, 0x87, 0x12, 0x07, 0x3e, 0x0e, 0x3c, 0xa7, 0x83, 0x3f, 0xa3,
	0x9e, 0x4f, 0xa8, 0x00, 0x3c, 0x1a, 0x02, 0xc8, 0xe2, 0x22, 0x25, 0xc6, 0x30, 0xf2, 0x5f, 0x9d,
	0xf4, 0x40, 0x08, 0x84, 0x88, 0x1d, 0x8e, 0x95, 0xa5, 0xb1, 0x6b, 0xb0, 0x04, 0x25, 0xa9, 0xe8,
	0x47, 0xeb, 0x80, 0x07, 0x2d, 0x9c, 0x58, 0x5e, 0x2b, 0x9b, 0xc0, 0xc6, 0x5f, 0x52, 0xcc, 0x12,
	0xb8, 0x0d, 0xe6, 0x65, 0x05, 0x27, 0x42, 0x21, 0x2e, 0x29, 0x15, 0xa5, 0x3a, 0xdb, 0xac, 0x5e,
	0x5a, 0xea, 0xb5, 0xa5, 0x81, 0xca, 0xe0, 0xaa, 0x44, 0x14, 0xfb, 0x4c, 0x77, 0x49, 0x68, 0x48,
	0x9d, 0x39, 0x49, 0x7f, 0x8f, 0x42, 0xac, 0x5d, 0x29, 0x60, 0x69, 0x3b, 0x4d, 0x50, 0x82, 0x45,
	0x9e, 0xc9, 0x42, 0x2b, 0xa0, 0xe8, 0xa6, 0x2c, 0x21, 0x21, 0xa6, 0x8e, 0xef, 0x89, 0x32, 0x85,
	0x4b, 0x4b, 0xb5, 0x81, 0x3c, 0x7f, 0xe7, 0xc1, 0x8f, 0x00, 0x90, 0x18, 0x53, 0x7e, 0x8f, 0x25,
	0xb5, 0x52, 0xa8, 0x16, 0xeb, 0x75, 0x7d, 0x9a, 0x75, 0xba, 0x28, 0xb6, 0x23, 0xa9, 0x42, 0x78,
	0x20, 0x05, 0x9f, 0x83, 0x7b, 0x31, 0xa2, 0x89, 0x8f, 0x02, 0xe7, 0x00, 0xf9, 0x41, 0x4a, 0x71,
	0xa9, 0x50, 0x51, 0xaa, 0x77, 0xed, 0x05, 0x71, 0xbc, 0xc9, 0x4f, 0xe1, 0x33, 0x30, 0xdf, 0x43,
	0x81, 0xef, 0xa1, 0x04, 0x3b, 0x24, 0x0a, 0x8e, 0x4a, 0xff, 0xe7, 0xb0, 0x39, 0x79, 0xb8, 0x13,
	0x05, 0x47, 0xda, 0xa9, 0x0a, 0xee, 0x8f, 0xd7, 0x84, 0xeb, 0xa0, 0x98, 0xc6, 0x39, 0x2f, 0x73,
	0x23, 0xe7, 0x15, 0xeb, 0x65, 0xd9, 0xbc, 0x34, 0x4c, 0xdf, 0xcc, 0x0c, 0xdb, 0x46, 0xec, 0xd0,
	0x06, 0x1c, 0x9e, 0xc5, 0xf0, 0x0d, 0x98, 0x71, 0x29, 0x46, 0x09, 0x37, 0xa0, 0x58, 0xaf, 0x4d,
	0x1c, 0xba, 0xff, 0x1a, 0xe5, 0xd4, 0x5b, 0xff, 0xd9, 0x82, 0x9b, 0xa9, 0x70, 0xcd, 0x92, 0xfa,
	0x2f, 0x2a, 0x9c, 0x0b, 0x4b, 0x60, 0x86, 0xe2, 0x90, 0xf4, 0xf8, 0x15, 0xcd, 0x66, 0x19, 0xfe,
	0xbb, 0x59, 0x04, 0xb3, 0xfd, 0x3b, 0xd5, 0xce, 0x14, 0xb0, 0x3c, 0xee, 0x35, 0x8b, 0x49, 0xc4,
	0x30, 0xdc, 0x04, 0x4b, 0x63, 0xb7, 0xed, 0x60, 0x4a, 0x09, 0xcd, 0x05, 0x8b, 0x75, 0x28, 0xdb,
	0xa2, 0xb1, 0xab, 0xef, 0xe5, 0x6f, 0xd4, 0x5e, 0x1c, 0xf5, 0xe1, 0x6d, 0x06, 0x87, 0x3b, 0xe0,
	0x0e, 0xc5, 0x2c, 0x0d, 0x12, 0xf9, 0x16, 0x5e, 0x4d, 0x7f, 0x0b, 0x23, 0x2d, 0xd9, 0x39, 0xdb,
	0x96, 0x2a, 0x9a, 0x09, 0x16, 0x6f, 0xc8, 0x67, 0xa6, 0xdf, 0xb0, 0x05, 0xa3, 0x6f, 0xbb, 0xfe,
	0xa3, 0x00, 0x16, 0x04, 0x6d, 0x8f, 0x17, 0x83, 0x67, 0x0a, 0x00, 0x83, 0x9d, 0x82, 0x8d, 0xe9,
	0xdd, 0xfd, 0xb5, 0x81, 0xe5, 0x5b, 0x78, 0xa4, 0x35, 0x2f, 0xac, 0xd1, 0x46, 0x4f, 0x7f, 0x5e,
	0x7d, 0x55, 0x57, 0x61, 0x2d, 0xfb, 0x4c, 0x1d, 0x8f, 0x64, 0x36, 0xe4, 0x56, 0x31, 0xa3, 0x66,
	0x20, 0x61, 0x90, 0x51, 0x3b, 0x81, 0xbf, 0x14, 0xb0, 0x30, 0x6a, 0x1b, 0x5c, 0xbb, 0xe5, 0xad,
	0xca, 0xa5, 0x2e, 0xbf, 0xbe, 0x3d, 0x91, 0xbf, 0x10, 0xed, 0xc3, 0x85, 0xb5, 0x3c, 0xf4, 0x3d,
	0x58, 0x1d, 0xac, 0x6a, 0x3e, 0x52, 0x5d, 0x7b, 0x91, 0x8d, 0x34, 0x98, 0xe1, 0x78, 0x08, 0xbc,
	0x51, 0x3b, 0xe9, 0x4f, 0x64, 0x86, 0xb9, 0xbe, 0xa9, 0xd4, 0xca, 0x8f, 0xcf, 0xad, 0xd2, 0xa4,
	0xcf, 0x55, 0xf3, 0x5a, 0x01, 0x2b, 0x2e, 0x09, 0xa7, 0xf6, 0xdb, 0x5c, 0x1c, 0xb5, 0x78, 0x37,
	0x5b, 0xdb, 0x5d, 0xe5, 0xd3, 0x96, 0x20, 0x76, 0x49, 0x80, 0xa2, 0xae, 0x4e, 0x68, 0xd7, 0xe8,
	0xe2, 0x28, 0x5f, 0x6a, 0x63, 0x50, 0x6a, 0xf2, 0xdf, 0xd2, 0xba, 0x0c, 0xbe, 0xa9, 0x85, 0x96,
	0x65, 0x7d, 0x57, 0x2b, 0x2d, 0x2e, 0x68, 0x79, 0x4c, 0xe7, 0x61, 0x16, 0xed, 0x37, 0x74, 0x51,
	0x98, 0x9d, 0x4b, 0x48, 0xdb, 0xf2, 0x58, 0xbb, 0x0f, 0x69, 0xef, 0x37, 0xda, 0x12, 0xf2, 0x5b,
	0x5d, 0xe1, 0xe7, 0xa6, 0x69, 0x79, 0xcc, 0x34, 0xfb, 0x20, 0xd3, 0xdc, 0x6f, 0x98, 0xa6, 0x84,
	0x75, 0x66, 0xf2, 0x3e, 0x1b, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x5c, 0xd1, 0xae, 0xc6, 0x3d,
	0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AdGroupServiceClient is the client API for AdGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupServiceClient interface {
	// Returns the requested ad group in full detail.
	GetAdGroup(ctx context.Context, in *GetAdGroupRequest, opts ...grpc.CallOption) (*resources.AdGroup, error)
	// Creates, updates, or removes ad groups. Operation statuses are returned.
	MutateAdGroups(ctx context.Context, in *MutateAdGroupsRequest, opts ...grpc.CallOption) (*MutateAdGroupsResponse, error)
}

type adGroupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAdGroupServiceClient(cc grpc.ClientConnInterface) AdGroupServiceClient {
	return &adGroupServiceClient{cc}
}

func (c *adGroupServiceClient) GetAdGroup(ctx context.Context, in *GetAdGroupRequest, opts ...grpc.CallOption) (*resources.AdGroup, error) {
	out := new(resources.AdGroup)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.AdGroupService/GetAdGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupServiceClient) MutateAdGroups(ctx context.Context, in *MutateAdGroupsRequest, opts ...grpc.CallOption) (*MutateAdGroupsResponse, error) {
	out := new(MutateAdGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.AdGroupService/MutateAdGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupServiceServer is the server API for AdGroupService service.
type AdGroupServiceServer interface {
	// Returns the requested ad group in full detail.
	GetAdGroup(context.Context, *GetAdGroupRequest) (*resources.AdGroup, error)
	// Creates, updates, or removes ad groups. Operation statuses are returned.
	MutateAdGroups(context.Context, *MutateAdGroupsRequest) (*MutateAdGroupsResponse, error)
}

// UnimplementedAdGroupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAdGroupServiceServer struct {
}

func (*UnimplementedAdGroupServiceServer) GetAdGroup(ctx context.Context, req *GetAdGroupRequest) (*resources.AdGroup, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAdGroup not implemented")
}
func (*UnimplementedAdGroupServiceServer) MutateAdGroups(ctx context.Context, req *MutateAdGroupsRequest) (*MutateAdGroupsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateAdGroups not implemented")
}

func RegisterAdGroupServiceServer(s *grpc.Server, srv AdGroupServiceServer) {
	s.RegisterService(&_AdGroupService_serviceDesc, srv)
}

func _AdGroupService_GetAdGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupServiceServer).GetAdGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.AdGroupService/GetAdGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupServiceServer).GetAdGroup(ctx, req.(*GetAdGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupService_MutateAdGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupServiceServer).MutateAdGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.AdGroupService/MutateAdGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupServiceServer).MutateAdGroups(ctx, req.(*MutateAdGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.AdGroupService",
	HandlerType: (*AdGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroup",
			Handler:    _AdGroupService_GetAdGroup_Handler,
		},
		{
			MethodName: "MutateAdGroups",
			Handler:    _AdGroupService_MutateAdGroups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/ad_group_service.proto",
}
