/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef NEWPROFILEWIZARD_H
#define NEWPROFILEWIZARD_H

//#define QWIZARD_QT4_PORT

#if defined(QWIZARD_QT4_PORT)
#include <QtGui/QWizard>
#else
#include <Qt3Support/Q3Wizard>
#endif

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtGui/QPixmap>
#include <QtGui/QWidget>

#include <kfiledialog.h>
#include <kvbox.h>

#include "importcertificatedialog.h"
#include "importipsecprofiledialog.h" //< IPSec import
#include "importopenvpnprofiledialog.h" //< OpenVPN import
#include "importprofiledialog.h" //< PCF import
#include "kvpncconfig.h"
#include "newprofilewizardauthselection.h"
#include "newprofilewizardcert.h"
#include "newprofilewizardciscomanually.h"
#include "newprofilewizardciscoselection.h"
#include "newprofilewizardconnectionstatuscheck.h"
#include "newprofilewizardconnectoptions.h"
#include "newprofilewizardfreeswan.h"
#include "newprofilewizardgeneral.h"
#include "newprofilewizardnat.h"
#include "newprofilewizardnetwork.h"
#include "newprofilewizardnetworkroute.h"
#include "newprofilewizardopenvpn.h"
#include "newprofilewizardopenvpnauth.h"
#include "newprofilewizardopenvpnselection.h"
#include "newprofilewizardp12certselection.h"
#include "newprofilewizardpptp.h"
#include "newprofilewizardpsk.h"
#include "newprofilewizardracoon.h"
#include "newprofilewizardstart.h"
#include "newprofilewizardtypeselection.h"
#include "newprofilewizarduser.h"
#include "profilenetworkrouteoptions.h"
#include "profilenetworkvirtualipoptions.h"
#include "profilesshoptions.h"
#include "profilevtunoptions.h"

class QLabel;

#if defined(QWIZARD_QT4_PORT)
class NewProfileWizard : public QWizard
{
    Q_OBJECT

public:
    enum NewProfileWizardPages {
        Page_Intro,
        Page_Conclusion
    };

    NewProfileWizard(KVpncConfig *GlobalConfig = 0,
                     QWidget *parent = 0);
    ~NewProfileWizard();

    void accept();

public:
    VpnAccountData *profileData;
    bool newProfileCreated;
    bool connectaftercreating;
    bool daemonavailable;

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
};

class ProfileIntroductionPage : public QWizardPage
{
    Q_OBJECT

public:
    ProfileIntroductionPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    int nextId() const;

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *label;
};

class ProfileConclusionPage : public QWizardPage
{
    Q_OBJECT

public:
    ProfileConclusionPage(KVpncConfig *GlobalConfig = 0, QWidget *parent = 0);

    void initializePage();

private:
    KVpncConfig *globalConfiguration;
    int debugLevel;
    QLabel *label;
};
#else
/**
 * Provides a wizard for creating a new profile
 */
class NewProfileWizard : public Q3Wizard
{
    Q_OBJECT

public:
	NewProfileWizard(KVpncConfig* GlobalConfig, QWidget *parent = 0);

    void dataChanged(const QString &);
    QString getName();
    QString getProfile();
    bool getFinished();
    bool newProfileCreated;
    bool daemonavailable; //< true if required is found, used for connecting after creating
    bool connectaftercreating; //< connect if successful created
    VpnAccountData *profileData;

public slots:
    void showPage(QWidget* page);
    void next();
    void back();
    void accept();
    void reject();
    void userdefinedOpenvpnPortToggeled(bool);
    void nsCertTypeOpenvpnToggled(bool);
    void additionalNetworkRoutesToggled(bool);
    void addNetworkRouteClicked();
    void delNetworkRouteClicked();
    void pskIsInFileToggled(bool);
    void useNatToggled(bool);
    void udpPortToggled(bool);
    void pingIpAfterConnectToggled(bool);
    void useSpecialServerCertificateToggled(bool);
    void useUserdefiniedCipherToggled(bool);
    void useHttpProxyToggeled(bool);
    void useTlsAuthToggled(bool);
    void useTlsRemoteHostToggled(bool);
    void connectionStatusCheckToggled(bool);
    void authenticateWithUsernameAndPasswordToggled(bool);
    void pskInputToggled(const QString& str);
    void userpassToggled(const QString& str);
    void usernameToggled(const QString& str);
    void pskToggled(const QString& str);
    void useRightNextHopToggled(bool);
    void useLeftNextHopToggled(bool);
    void domainNameToggled(bool);
    void idTypeToggled();
    void usePkcs11ProvidersToggled(bool);
    void useSmartcardToggled(bool);
    void useSmartcardOnCertFormateToggled(bool);
    void detectPkcs11Ids();
    void detectPkcs11Slots();
    void mtuToggled(bool);
    void mruToggled(bool);
    void useVirtualIpAddressToggled(bool);
    void usePortToggled(bool);
    void useAuthenticationAlgorithmToggled(bool);
    void useRemoteNetworkToggled(bool);
    void useEspToogled(bool);
    void useIkeToggled(bool);
    void defaultRouteToggled(const QString&);
    void ikeGroupToggled(bool);
	void remoteIDTypeRacoonToggled(const QString&);
	void localIDTypeRacoonToggled(const QString&);
	void remoteIDTypeIpsecToggled(const QString&);
	void localIDTypeIpsecToggled(const QString&);
	void useXauthFreeswanToggled(bool);
    void useXauthRacoonToggled(bool);
    void tunnelDeviceTypeChanged(const QString &);
    void useDnsServerToggled(bool);
    void useSearchDomainInResolvConfToggled(bool);
    //void reject();

protected:
    QString ConnectionType;
    QString Gateway;
    QString ID;
    QString Username;
    QString UserPassword;
    QString PreSharedKey;
    QString ApplicationVersion;
    QString NtDomainName;
    QString PerfectForwardSecrecy;
    QString IkeGroup;
    QString DnsServer; //< userdefined DNS server for pptp
    QString Name;
    QString Description;
    bool saveUserPassword;
    bool savePsk;
    bool useApplicationVersion;
    bool useGlobalIpsecSecret;
    bool useIkeGroup;
    bool useLocalPort;
    bool useNtDomainName;
    bool useSingleDes;
    bool useAdvancedSettings;
    bool usePerfectSecrecy;
    bool useUdp; //< True if NAT-T should be used
    bool useUdpPort; //< True if userdefined UDP port should be used
    bool useDnsServer; //< True if userdefined DNS server should be used
    bool useGetDnsFromPeer; //< True if DNS servers should be retrieved from peer (pptp)bool
    bool refuse40BitEncryption; //< True if 40 bit encryption is refused (pptp)
    bool refuse128BitEncryption; //< True if 128 bit encryption is refused (pptp)
    bool allowStatefulMode;
    bool useNoBsdComp;
    bool useNoDeflate;
    bool requireMppe; //< True if MPPE is required (pptp)
    bool refuseEap; //< True if EAP is refused (pptp)
    int Port;
    int UdpPort; //< Port number of UDP port

private:
    void setupPages();
    bool importProfile(VpnAccountData::ConnectionType ConnType);
    bool importCertificate();
    KHBox *startpage;
    KHBox *newprofilewizardtypeselectionpage;
    KHBox *newprofilewizardgeneralpage;
    KHBox *newprofilewizardciscoselectionpage;
    KHBox *newprofilewizardciscomanuallypage;
    KHBox *newprofilewizardracoonpage;
    KHBox *newprofilewizardfreeswanpage;
    KHBox *newprofilewizardfreeswanselectionpage;
    KHBox *newprofilewizardopenvpnpage;
    KHBox *newprofilewizardopenvpnselectionpage;
    KHBox *newprofilewizardopenvpnauthpage;
    KHBox *newprofilewizardpptppage;
    KHBox *newprofilewizardvtunpage;
    KHBox *newprofilewizardsshpage;
    KHBox *newprofilewizardauthselectionpage;
    KHBox *newprofilewizardpskpage;
    KHBox *newprofilewizardcertpage;
    KHBox *newprofilewizardp12certselectionpage;
    KHBox *newprofilewizarduserpage;
    KHBox *newprofilewizardnetworkpage;
    KHBox *newprofilewizardvirtualipaddresspage;
    KHBox *newprofilewizardnetworkroutepage;
    KHBox *newprofilewizardnatpage;
    KHBox *newprofilewizardconnectionstatuscheckpage;
    KHBox *newprofilewizardconnectoptionspage;
    KHBox *endpage;
    NewProfileWizardTypeSelection *newprofilewizardtypeselectionpagecontent;
    NewProfileWizardGeneral *newprofilewizardgeneralpagecontent;
    NewProfileWizardCiscoSelection *newprofilewizardciscoselectionpagecontent;
    NewProfileWizardCiscoManually *newprofilewizardciscomanuallypagecontent;
    NewProfileWizardRacoon *newprofilewizardracoonpagecontent;
    NewProfileWizardFreeswan *newprofilewizardfreeswanpagecontent;
    NewProfileWizardOpenvpnSelection *newprofilewizardfreeswanselectionpagecontent;
    NewProfileWizardOpenvpn *newprofilewizardopenvpnpagecontent;
    NewProfileWizardOpenvpnAuth *newprofilewizardopenvpnauthpagecontent;
    NewProfileWizardOpenvpnSelection *newprofilewizardopenvpnselectionpagecontent;
    NewProfileWizardPptp *newprofilewizardpptppagecontent;
    ProfileVtunOptions *newprofilewizardvtunpagecontent;
    ProfileSshOptions *newprofilewizardsshpagecontent;
    NewProfileWizardAuthSelection *newprofilewizardauthselectioncontent;
    NewProfileWizardPsk *newprofilewizardpskcontent;
    NewProfileWizardCert *newprofilewizardcertcontent;
    NewProfileWizardStart *newprofilewizardstartcontent;
    NewProfileWizardP12CertSelection *newprofilewizardp12certselectioncontent;
    NewProfileWizardUser *newprofilewizarduserpagecontent;
    NewProfileWizardNetwork *newprofilewizardnetworkcontent;
    ProfileNetworkRouteOptions *newprofilewizardnetworkroutecontent;
    NewProfileWizardNat *newprofilewizardnatcontent;
    NewProfileWizardConnectionStatusCheck *newprofilewizardconnectionstatuscheckcontent;
    NewProfileWizardConnectOptions *newprofilewizardconnectoptionscontent;
    ProfileNetworkVirtualIpOptions *profilenetworkvirtualipoptionscontent;
    KVpncConfig* GlobalConfig; //< pointer to global config class
    QWidget* currentpage; // pointer to current page
    QWidget* previouspage; //< pointer to previous page
    bool finished;
    bool enterdatamanually; //< enter data manually
    bool useCert; //< use certificate for authentication
    bool importOK; //< import was successful
    QPixmap *SetupPixmap;
    QPixmap *SetupPixmapFinal;
};
#endif

#endif
