/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * The source code contains parts of code of the konversation project        *
 * (konvisettingsdialog.cpp) http://konversation.kde.org                     *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "preferencesdialog.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QList>

#include <QtCore/QObject>
#include <QtCore/QStringList>
#include <QtGui/QCheckBox>
#include <QtGui/QCursor>
#include <QtGui/QLabel>
#include <QtGui/QLayout>
#include <QtGui/QPixmap>
#include <QtGui/QPushButton>
#include <QtGui/QShowEvent>
#include <QtGui/QSpinBox>
#include <QtGui/QSplitter>
#include <QtGui/QTabWidget>
#include <QtGui/QWhatsThis>
#include <QTreeWidgetItemIterator>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <kcolordialog.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <klineedit.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <knuminput.h>
#include <kpagedialog.h>
#include <kpassworddialog.h>
#include <ktextedit.h>
#include <kurlrequester.h>
#include <kvbox.h>

#include "importcertificatedialog.h"
#include "networkinterface.h"
#include "newprofiledialog.h"
#include "utils.h"

PreferencesDialog::PreferencesDialog(QWidget *parent, KApplication *app, QTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles) : KPageDialog(parent)
{
    setFaceType(KPageDialog::Tree);
    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));
	GlobalConfig->prefDlgOpen = true;
    // main = new PreferencesDialogBase(this);

    // setMainWidget(main);

    // main->setMinimumSize(main->sizeHint())

    this->AccountList = GlobalConfig->AccountList;
    this->LogOutput = LogOutput;
    this->currentProfile = GlobalConfig->currentProfile;
    this->KvpncDebugLevel = GlobalConfig->KvpncDebugLevel;
    this->app = app;
    this->GlobalConfig = GlobalConfig;

    lastProfileName = "";
    profileHasChanged = false;
    prev_page = 0;
    current_page = 0;

    this->showOnlyProfiles = showOnlyProfiles;
    if (showOnlyProfiles) {
        setCaption(i18n("Manage Profiles"));
    }
    setupGui();

    // ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
    // programsInPathToggled(GlobalConfig->programsInPath);

    ok_icon = KIconLoader::global() ->loadIcon("dialog-ok-apply", KIconLoader::NoGroup, 16);
    wrong_icon = KIconLoader::global() ->loadIcon("dialog-close", KIconLoader::NoGroup, 16);

    if (!showOnlyProfiles) {
        ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->clear();

		/* these levels must be deactivated because we need informational output !!! */
		//ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem(0, "none" );
		//ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem(1, "warning" );
		//ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem(2, "notify");
		
		ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem(0, "info" );
        ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem(1, "debug");
        ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem(2, "debug2");

        switch (GlobalConfig->PptpLogLevel) {
        case 0:
			// low
            ConfigDaemonOptionsWidget->PptpLogLevelComboBox->setCurrentIndex(0);
            break;
        case 1:
			// default
            ConfigDaemonOptionsWidget->PptpLogLevelComboBox->setCurrentIndex(1);
            break;
        case 2:
			// high
            ConfigDaemonOptionsWidget->PptpLogLevelComboBox->setCurrentIndex(2);
            break;
        }

        ConfigDaemonOptionsWidget->DoKillL2tpdIfStillRunningCheckBox->setChecked(GlobalConfig->doKillL2tpdIfStillRunning);
        ConfigDaemonOptionsWidget->DoKillXl2tpdIfStillRunningCheckBox->setChecked(GlobalConfig->doKillXl2tpdIfStillRunning);
        ConfigDaemonOptionsWidget->DoKillRacoonIfStillRunningCheckBox->setChecked(GlobalConfig->doKillRacoonIfStillRunning);

        slotStatusMsg(i18n("Collecting daemon tool data..."), ID_STATUS_MSG);

        ToolInfo *VpncInfo = Utils(GlobalConfig).getToolInfo("vpnc");
        VpncInfo->collectToolInfo();
        ToolInfo *CiscoVpncInfo = Utils(GlobalConfig).getToolInfo("vpnclient");
        CiscoVpncInfo->collectToolInfo();
        ToolInfo *IpsecInfo = Utils(GlobalConfig).getToolInfo("ipsec");
        IpsecInfo->collectToolInfo();
        ToolInfo *RacoonInfo = Utils(GlobalConfig).getToolInfo("racoon");
        RacoonInfo->collectToolInfo();
        ToolInfo *PppdInfo = Utils(GlobalConfig).getToolInfo("pppd");
        PppdInfo->collectToolInfo();
        ToolInfo *PptpInfo = Utils(GlobalConfig).getToolInfo("pptp");
        PptpInfo->collectToolInfo();
        ToolInfo *L2tpdInfo = Utils(GlobalConfig).getToolInfo("l2tpd");
        L2tpdInfo->collectToolInfo();
        ToolInfo *Xl2tpdInfo = Utils(GlobalConfig).getToolInfo("xl2tpd");
        Xl2tpdInfo->collectToolInfo();
        ToolInfo *Openl2tpInfo = Utils(GlobalConfig).getToolInfo("openl2tpd");
        Openl2tpInfo->collectToolInfo();
        ToolInfo *OpenvpnInfo = Utils(GlobalConfig).getToolInfo("openvpn");
        OpenvpnInfo->collectToolInfo();
        ToolInfo *VtunInfo = Utils(GlobalConfig).getToolInfo("vtund");
        VtunInfo->collectToolInfo();
        ToolInfo *SshInfo = Utils(GlobalConfig).getToolInfo("ssh");
        SshInfo->collectToolInfo();

        ConfigDaemonOptionsWidget->VpncVersionLineEdit->setText(VpncInfo->Version);
        ConfigDaemonOptionsWidget->CiscoVpncVersionLineEdit->setText(CiscoVpncInfo->Version);
        ConfigDaemonOptionsWidget->IpsecVersionLineEdit->setText(IpsecInfo->Version);
        ConfigDaemonOptionsWidget->RacoonVersionLineEdit->setText(RacoonInfo->Version);
        ConfigDaemonOptionsWidget->PppdVersionLineEdit->setText(PppdInfo->Version);
        ConfigDaemonOptionsWidget->PptpVersionLineEdit->setText(PptpInfo->Version);
        ConfigDaemonOptionsWidget->OpenvpnVersionLineEdit->setText(OpenvpnInfo->Version);
        ConfigDaemonOptionsWidget->L2tpdVersionLineEdit->setText(L2tpdInfo->Version);
        ConfigDaemonOptionsWidget->Xl2tpdVersionLineEdit->setText(Xl2tpdInfo->Version);
        ConfigDaemonOptionsWidget->VtunVersionLineEdit->setText(VtunInfo->Version);
        ConfigDaemonOptionsWidget->VtunVersionLineEdit->setText(VtunInfo->Version);
        ConfigDaemonOptionsWidget->SshVersionLineEdit->setText(SshInfo->Version);

        if (GlobalConfig->pathToVpnc.isEmpty() && !VpncInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->VpncPathInput->setUrl(VpncInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->VpncPathInput->setUrl(GlobalConfig->pathToVpnc);
        }

        if (GlobalConfig->pathToVpnc.isEmpty() && !VpncInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->CiscoVpncPathInput->setUrl(CiscoVpncInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->CiscoVpncPathInput->setUrl(GlobalConfig->pathToCiscoVpnc);
        }

        if (GlobalConfig->pathToIpsec.isEmpty() && !IpsecInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->FreeswanPathInput->setUrl(IpsecInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->FreeswanPathInput->setUrl(GlobalConfig->pathToIpsec);
        }

        if (GlobalConfig->pathToRacoon.isEmpty() && !RacoonInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->RacoonPathInput->setUrl(RacoonInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->RacoonPathInput->setUrl(GlobalConfig->pathToRacoon);
        }

        if (GlobalConfig->pathToPppd.isEmpty() && !PppdInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->PppdPathInput->setUrl(PppdInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->PppdPathInput->setUrl(GlobalConfig->pathToPppd);
        }

        if (GlobalConfig->pathToPptp.isEmpty() && !PptpInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->PptpPathInput->setUrl(PptpInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->PptpPathInput->setUrl(GlobalConfig->pathToPptp);
        }

        if (GlobalConfig->pathToOpenvpn.isEmpty() && !OpenvpnInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->OpenvpnPathInput->setUrl(OpenvpnInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->OpenvpnPathInput->setUrl(GlobalConfig->pathToOpenvpn);
        }

        if (GlobalConfig->pathToL2tpd.isEmpty() && !L2tpdInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->L2tpdPathInput->setUrl(L2tpdInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->L2tpdPathInput->setUrl(GlobalConfig->pathToL2tpd);
        }

        if (GlobalConfig->pathToXl2tpd.isEmpty() && !Xl2tpdInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->Xl2tpdPathInput->setUrl(Xl2tpdInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->Xl2tpdPathInput->setUrl(GlobalConfig->pathToXl2tpd);
        }

        if (GlobalConfig->pathToOpenl2tp.isEmpty() && !Openl2tpInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->Openl2tpPathInput->setUrl(Openl2tpInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->Openl2tpPathInput->setUrl(GlobalConfig->pathToOpenl2tp);
        }

        if (GlobalConfig->pathToVtund.isEmpty() && !VtunInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->VtundPathInput->setUrl(VtunInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->VtundPathInput->setUrl(GlobalConfig->pathToVtund);
        }

        if (GlobalConfig->pathToSsh.isEmpty() && !SshInfo->PathToExec.isEmpty()) {
            ConfigDaemonOptionsWidget->SshPathInput->setUrl(SshInfo->PathToExec);
        } else {
            ConfigDaemonOptionsWidget->SshPathInput->setUrl(GlobalConfig->pathToSsh);
        }

        if (VpncInfo->found && QFileInfo(VpncInfo->PathToExec).isFile() && VpncInfo->found) {
            ConfigDaemonOptionsWidget->VpncStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (VpncInfo->found && QFileInfo(CiscoVpncInfo->PathToExec).isFile() && CiscoVpncInfo->found) {
            ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (VtunInfo->found && QFileInfo(VtunInfo->PathToExec).isFile() && VtunInfo->found) {
            ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (SshInfo->found && QFileInfo(SshInfo->PathToExec).isFile() && SshInfo->found) {
            ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (IpsecInfo->found) {
            ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (RacoonInfo->found) {
            ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (PppdInfo->found) {
            ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (PptpInfo->found) {
            ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (OpenvpnInfo->found) {
            ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (L2tpdInfo->found) {
            ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (Xl2tpdInfo->found) {
            ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (Openl2tpInfo->found) {
            ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap(ok_icon);
        } else {
            ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap(wrong_icon);
        }

        HelperProgramOptionsWidget->IptablesPathInput->setUrl(GlobalConfig->pathToIptables);
        HelperProgramOptionsWidget->OpenSSLPathInput->setUrl(GlobalConfig->pathToOpenssl);
        HelperProgramOptionsWidget->KillPathInput->setUrl(GlobalConfig->pathToKill);
        HelperProgramOptionsWidget->KillallPathInput->setUrl(GlobalConfig->pathToKillall);
        HelperProgramOptionsWidget->PingPathInput->setUrl(GlobalConfig->pathToPing);
        HelperProgramOptionsWidget->IpPathInput->setUrl(GlobalConfig->pathToIp);
        HelperProgramOptionsWidget->IfconfigPathInput->setUrl(GlobalConfig->pathToIfconfig);
        HelperProgramOptionsWidget->RoutePathInput->setUrl(GlobalConfig->pathToRoute);
        HelperProgramOptionsWidget->Pkcs11ToolPathInput->setUrl(GlobalConfig->pathToPkcs11Tool);
        HelperProgramOptionsWidget->CiscoCertMgrPathInput->setUrl(GlobalConfig->pathToCiscoCertMgr);
        HelperProgramOptionsWidget->TailPathInput->setUrl(GlobalConfig->pathToTail);
        HelperProgramOptionsWidget->KsshaskpassPathInput->setUrl(GlobalConfig->pathToKsshAskpass);
        HelperProgramOptionsWidget->GnomeaskpassPathInput->setUrl(GlobalConfig->pathToGnomeSshAskpass);

        slotStatusMsg(i18n("Collecting helper tool data..."), ID_STATUS_MSG);

        ToolInfo *OpensslInfo = Utils(GlobalConfig).getToolInfo("openssl");
        OpensslInfo->collectToolInfo();
        ToolInfo *IptablesInfo = Utils(GlobalConfig).getToolInfo("iptables");
        IptablesInfo->collectToolInfo();
        ToolInfo *KillInfo = Utils(GlobalConfig).getToolInfo("kill");
        KillInfo->collectToolInfo();
        ToolInfo *KillallInfo = Utils(GlobalConfig).getToolInfo("killall");
        KillallInfo->collectToolInfo();
        ToolInfo *PingInfo = Utils(GlobalConfig).getToolInfo("ping");
        PingInfo->collectToolInfo();
        ToolInfo *IpInfo = Utils(GlobalConfig).getToolInfo("ip");
        IpInfo->collectToolInfo();
        ToolInfo *IfconfigInfo = Utils(GlobalConfig).getToolInfo("ifconfig");
        IfconfigInfo->collectToolInfo();
        ToolInfo *RouteInfo = Utils(GlobalConfig).getToolInfo("route");
        RouteInfo->collectToolInfo();
        ToolInfo *Pkcs11ToolInfo = Utils(GlobalConfig).getToolInfo("pkcs11-tool");
        Pkcs11ToolInfo->collectToolInfo();
        ToolInfo *CiscoCertMgrInfo = Utils(GlobalConfig).getToolInfo("cisco_cert_mgr");
        CiscoCertMgrInfo->collectToolInfo();
        ToolInfo *TailInfo = Utils(GlobalConfig).getToolInfo("tail");
        TailInfo->collectToolInfo();
        ToolInfo *KsshaskpassInfo = Utils(GlobalConfig).getToolInfo("ksshaskpass");
        KsshaskpassInfo->collectToolInfo();
        ToolInfo *GnomeaskpassInfo = Utils(GlobalConfig).getToolInfo("gnome-ssh-askpass");
        GnomeaskpassInfo->collectToolInfo();

        HelperProgramOptionsWidget->OpensslVersionLineEdit->setText(OpensslInfo->Version);
        HelperProgramOptionsWidget->IptablesVersionLineEdit->setText(IptablesInfo->Version);
        HelperProgramOptionsWidget->KillVersionLineEdit->setText(KillInfo->Version);
        HelperProgramOptionsWidget->KillallVersionLineEdit->setText(KillallInfo->Version);
        HelperProgramOptionsWidget->PingVersionLineEdit->setText(PingInfo->Version);
        HelperProgramOptionsWidget->IpVersionLineEdit->setText(IpInfo->Version);
        HelperProgramOptionsWidget->IfconfigVersionLineEdit->setText(IfconfigInfo->Version);
        HelperProgramOptionsWidget->RouteVersionLineEdit->setText(RouteInfo->Version);
        HelperProgramOptionsWidget->Pkcs11ToolVersionLineEdit->setText(Pkcs11ToolInfo->Version);
        HelperProgramOptionsWidget->CiscoCertMgrVersionLineEdit->setText(CiscoCertMgrInfo->Version);
        HelperProgramOptionsWidget->TailVersionLineEdit->setText(TailInfo->Version);
        HelperProgramOptionsWidget->KsshaskpassVersionLineEdit->setText(KsshaskpassInfo->Version);
        HelperProgramOptionsWidget->GnomeaskpassVersionLineEdit->setText(GnomeaskpassInfo->Version);

        if (OpensslInfo->found) {
            HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (IptablesInfo->found) {
            HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (KillInfo->found) {
            HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (KillallInfo->found) {
            HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (PingInfo->found) {
            HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (IpInfo->found) {
            HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (IfconfigInfo->found) {
            HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (RouteInfo->found) {
            HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (Pkcs11ToolInfo->found) {
            HelperProgramOptionsWidget->Pkcs11ToolStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->Pkcs11ToolStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (CiscoCertMgrInfo->found) {
            HelperProgramOptionsWidget->CiscoCertMgrStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->CiscoCertMgrStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (TailInfo->found) {
            HelperProgramOptionsWidget->TailStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->TailStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (KsshaskpassInfo->found) {
            HelperProgramOptionsWidget->KsshaskpassStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->KsshaskpassStatePixmapLabel->setPixmap(wrong_icon);
        }

        if (GnomeaskpassInfo->found) {
            HelperProgramOptionsWidget->GnomeaskpassStatePixmapLabel->setPixmap(ok_icon);
        } else {
            HelperProgramOptionsWidget->GnomeaskpassStatePixmapLabel->setPixmap(wrong_icon);
        }

        slotStatusMsg(i18n("Ready."), ID_STATUS_MSG);

        ConnectOptionsWidget->checkMinimizeAfterConnectCheck->setChecked(GlobalConfig->minimizeAfterConnect);
        DebugOptionsWidget->showDebugCheck->setChecked(GlobalConfig->showDebugConsole);
        DebugOptionsWidget->WriteLogCheck->setChecked(GlobalConfig->writeLogFile);
        DebugOptionsWidget->spinKvpncDebugLevel->setValue(GlobalConfig->KvpncDebugLevel);
		
		if (GlobalConfig->RacoonDebugLevel != "info" && GlobalConfig->RacoonDebugLevel != "debug" && GlobalConfig->RacoonDebugLevel != "debug2" )
			GlobalConfig->RacoonDebugLevel = "info";
		if (GlobalConfig->RacoonDebugLevel == "info") {
			ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentIndex(0);
		} else if (GlobalConfig->RacoonDebugLevel == "debug") {
			ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentIndex(1);
		} else if (GlobalConfig->RacoonDebugLevel == "debug2") {
			ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentIndex(2);
		}
		
        ConfigDaemonOptionsWidget->spinVpncDebugLevel->setValue(GlobalConfig->VpncDebugLevel);
        ConfigDaemonOptionsWidget->spinOpenvpnDebugLevel->setValue(GlobalConfig->OpenvpnDebugLevel - 1);
        ConfigDaemonOptionsWidget->DebugPppdcheckBox->setChecked(GlobalConfig->enableDebugPppd);
        ConfigDaemonOptionsWidget->DebugPptpdcheckBox->setChecked(GlobalConfig->enableDebugPptpd);
        ConfigDaemonOptionsWidget->spinSshDebugLevel->setValue(GlobalConfig->SshDebugLevel);

        ConfigDaemonOptionsWidget->EnableDebugXl2tpdtunnelCheckBox->setChecked(GlobalConfig->enableDebugXl2tpdtunnel);
        ConfigDaemonOptionsWidget->EnableDebugXl2tpdstateCheckBox ->setChecked(GlobalConfig->enableDebugXl2tpdstate);
        ConfigDaemonOptionsWidget->EnableDebugXl2tpdpacketCheckBox->setChecked(GlobalConfig->enableDebugXl2tpdpacket);
        ConfigDaemonOptionsWidget->EnableDebugXl2tpdNetworkCheckBox->setChecked(GlobalConfig->enableDebugXl2tpdNetwork);

        ConfigDaemonOptionsWidget->DebugOpenl2tpCheckBox->setChecked(GlobalConfig->enableDebugOpenl2tp);

		
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->insertItem(0, i18n("none"));
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->insertItem(1, i18n("general"));
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->insertItem(2, i18n("general + packets"));
		
		// none
        ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentIndex(0);

        switch (GlobalConfig->PppdKernelLogLevel) {
        case 0:
			// none
            ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentIndex(0);
            break;
        case 1:
			// general
            ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentIndex(1);
            break;
        case 2:
			// general + packets
            ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->setCurrentIndex(2);
            break;
        }

        ConfigDaemonOptionsWidget->DebugL2tpdCheckBox->setChecked(GlobalConfig->enableDebugL2tpd);
		for ( QStringList::Iterator it = GlobalConfig->PlutoDebug.begin(); it != GlobalConfig->PlutoDebug.end(); ++it )
		{
			if (*it == "raw")
				ConfigDaemonOptionsWidget->IpsecRawDebugCheckBox->setChecked(true);
			if (*it == "crypt")
				ConfigDaemonOptionsWidget->IpsecCryptDebugCheckBox->setChecked(true);
			if (*it == "parsing")
				ConfigDaemonOptionsWidget->IpsecParsingDebugCheckBox->setChecked(true);
			if (*it == "emitting")
				ConfigDaemonOptionsWidget->IpsecEmittingDebugCheckBox->setChecked(true);
			if (*it == "control")
				ConfigDaemonOptionsWidget->IpsecControlDebugCheckBox->setChecked(true);
			if (*it == "klips")
				ConfigDaemonOptionsWidget->IpsecKlipsDebugCheckBox->setChecked(true);
			if (*it == "private")
				ConfigDaemonOptionsWidget->IpsecPrivateDebugCheckBox->setChecked(true);
			
		}
		
		for ( QStringList::Iterator it = GlobalConfig->KlipsDebug.begin(); it != GlobalConfig->KlipsDebug.end(); ++it )
		{
			if (*it == "tunnel-xmit")
				ConfigDaemonOptionsWidget->KlipsDebugTunnel_xmitCheckBox->setChecked(true);
			if (*it == "pfkey")
				ConfigDaemonOptionsWidget->KlipsDebugPfkeyCheckBox->setChecked(true);
			if (*it == "xform")
				ConfigDaemonOptionsWidget->KlipsDebugXformCheckBox->setChecked(true);
			if (*it == "eroute")
				ConfigDaemonOptionsWidget->KlipsDebugErouteCheckBox->setChecked(true);
			if (*it == "spi")
				ConfigDaemonOptionsWidget->KlipsDebugSpiCheckBox->setChecked(true);
			if (*it == "radij")
				ConfigDaemonOptionsWidget->KlipsDebugRadijCheckBox->setChecked(true);
			if (*it == "esp")
				ConfigDaemonOptionsWidget->KlipsDebugEspCheckBox->setChecked(true);
			if (*it == "ah")
				ConfigDaemonOptionsWidget->KlipsDebugAhCheckBox->setChecked(true);
			if (*it == "ipcomp")
				ConfigDaemonOptionsWidget->KlipsDebugIpcompCheckBox->setChecked(true);
			if (*it == "verbose")
				ConfigDaemonOptionsWidget->KlipsDebugVerboseCheckBox->setChecked(true);
		}
		
        ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->setValue(GlobalConfig->tryConnectTimeout);
        ConnectOptionsWidget->SilentQuitcheckBox->setChecked(GlobalConfig->useSilentQuit);
        GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->setChecked(GlobalConfig->dontQuitOnCloseEvent);
        GeneralOptionsWidget->HideOnStartupCheckBox->setChecked(GlobalConfig->hideMainWindow);
        GeneralOptionsWidget->useKwalletCheckBox->setChecked(GlobalConfig->useKwallet);
        ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
        DebugOptionsWidget->KeepConnectionFilesCheckBox->setChecked(GlobalConfig->holdGeneratedScripts);


        QPalette InfoLogPalette;
        InfoLogPalette.setColor(LogOptionsWidget->InfoLogLabel->backgroundRole(), GlobalConfig->InfoLogColor);
        LogOptionsWidget->InfoLogLabel->setPalette(InfoLogPalette);

        QPalette RemoteLogPalette;
        RemoteLogPalette.setColor(LogOptionsWidget->RemoteLogLabel->backgroundRole(), GlobalConfig->RemoteLogColor);
        LogOptionsWidget->RemoteLogLabel->setPalette(RemoteLogPalette);

        QPalette ErrorLogPalette;
        InfoLogPalette.setColor(LogOptionsWidget->ErrorLogLabel->backgroundRole(), GlobalConfig->ErrorLogColor);
        LogOptionsWidget->ErrorLogLabel->setPalette(ErrorLogPalette);

        QPalette SuccessLogPalette;
        SuccessLogPalette.setColor(LogOptionsWidget->SuccessLogLabel->backgroundRole(), GlobalConfig->SuccessLogColor);
        LogOptionsWidget->SuccessLogLabel->setPalette(SuccessLogPalette);

        QPalette DebugLogPalette;
        DebugLogPalette.setColor(LogOptionsWidget->DebugLogLabel->backgroundRole(), GlobalConfig->DebugLogColor);
        LogOptionsWidget->DebugLogLabel->setPalette(DebugLogPalette);

        QPalette BackgroundLogPalette;
        BackgroundLogPalette.setColor(LogOptionsWidget->BackgroundLogLabel->backgroundRole(), GlobalConfig->DebugBackgroundcolor);
        LogOptionsWidget->BackgroundLogLabel->setPalette(BackgroundLogPalette);

        LogOptionsWidget->UseColorizedLogOutputcheckBox->setChecked(GlobalConfig->useColorizedLogOutput);
        ConfigDaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->setChecked(GlobalConfig->showInterfaceIPinTooltip);
        ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked(GlobalConfig->doAutoConnectAtStartup);
        LogOptionsWidget->LogFontSizeSpinBox->setValue(GlobalConfig->LogViewerFontSize);

		/* keep english names! */
		ConfigDaemonOptionsWidget->KlipsDebugTunnel_xmitCheckBox->setText( QString( "&tunnel-xmit" ) );
		ConfigDaemonOptionsWidget->KlipsDebugPfkeyCheckBox->setText( QString( "pfkey" ) );
		ConfigDaemonOptionsWidget->KlipsDebugXformCheckBox->setText( QString( "xform" ) );
		ConfigDaemonOptionsWidget->KlipsDebugErouteCheckBox->setText( QString( "eroute" ) );
		ConfigDaemonOptionsWidget->KlipsDebugSpiCheckBox->setText( QString( "spi" ) );
		ConfigDaemonOptionsWidget->KlipsDebugRadijCheckBox->setText( QString( "radij" ) );
		ConfigDaemonOptionsWidget->KlipsDebugEspCheckBox->setText( QString( "esp" ) );
		ConfigDaemonOptionsWidget->KlipsDebugAhCheckBox->setText( QString( "ah" ) );
		ConfigDaemonOptionsWidget->KlipsDebugIpcompCheckBox->setText( QString( "ipcomp" ) );
		ConfigDaemonOptionsWidget->KlipsDebugVerboseCheckBox->setText( QString( "verbose" ) );
		
		ConfigDaemonOptionsWidget->IpsecEmittingDebugCheckBox->setText( QString( "emitting" ) );
		ConfigDaemonOptionsWidget->IpsecCryptDebugCheckBox->setText( QString( "cr&ypt" ) );
		ConfigDaemonOptionsWidget->IpsecRawDebugCheckBox->setText( QString( "&raw" ) );
		ConfigDaemonOptionsWidget->IpsecKlipsDebugCheckBox->setText( QString( "&klips" ) );
		ConfigDaemonOptionsWidget->IpsecParsingDebugCheckBox->setText( QString( "&parsing" ) );
		ConfigDaemonOptionsWidget->IpsecPrivateDebugCheckBox->setText( QString( "&private" ) );
		ConfigDaemonOptionsWidget->IpsecControlDebugCheckBox->setText( QString( "&control" ) );
		
        bool profileInList = false;
        for (int i = 0; i < GlobalConfig->AccountList->count();i++) {
            ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem(i, GlobalConfig->AccountList->at(i) ->getName());
			// FIXME insert profiles
            if (GlobalConfig->AccountList->at(i) ->getName() == GlobalConfig->AutoConnectProfile) {
                profileInList = true;
            }
        }

        ProfileCertOptionsWidget->x509certComboBox->clear();

        if (profileInList) {
			int ProfileNameIndex = ConnectOptionsWidget->AutoConnectProfileComboBox->findText(GlobalConfig->AutoConnectProfile);
			if (ProfileNameIndex == -1)
				ProfileNameIndex = 0;
            ConnectOptionsWidget->AutoConnectProfileComboBox->setCurrentIndex(ProfileNameIndex);
        } else {
            GlobalConfig->doAutoConnectAtStartup = false;
            ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked(GlobalConfig->doAutoConnectAtStartup);
        }
    }
    adjustSize();

    // TODO read types from list
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::cisco, i18n("Cisco (vpnc)"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::racoon, i18n("IPSec (racoon)"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::freeswan, i18n("IPSec (Openswan/strongSwan)"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::pptp, i18n("PPTP"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::openvpn, i18n("OpenVPN"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::l2tpd_racoon, i18n("L2TP (racoon)"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::l2tpd_freeswan, i18n("L2TP (Openswan/strongSwan)"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::ciscoorig, i18n("Cisco (proprietary)"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::vtun, i18n("Vtun"));
    ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem(VpnAccountData::ssh, i18n("SSH"));
    // ConnectionTypeComboBox->insertItem(10, "-", 5 );

	// 	modp768		1
	// 	modp1024	2
	// 	modp1536	5
	// 	modp2048	14
	// 	modp3072	15
	// 	modp4096	16
	// 	modp6144	17
	// 	modp8192	18
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(0, "modp768");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(1, "modp1024");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(2, "ec2n155");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(3, "ec2n185");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(4, "modp1536");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(5, "modp2048");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(6, "modp3072");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(7, "modp4096");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(8, "modp6144");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(9, "modp8192");

    // ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(0, "SHA1");
    // ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(1, "MD5");
	
	/*
	none:		No ID
	address:		The type is the IP address. This is the default type if you do not specify an identifier to use
	user_fqdn:	The type is a USER_FQDN (user fully-qualified domain name)
	fqdn:		The type is a FQDN (fully-qualified domain name)
	keyid:		The type is a KEY_ID, read from the file
	keyid:		The type is a KEY_ID, specified in the quoted string
	asn1dn:		The type is an ASN.1 distinguished name. If empty, DN from the Subject field in the certificate will be used
	*/
	
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(0, "none");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(1, "address");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(2, "user_fqdn");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(3, "fqdn");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(4, "keyid (file)");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(5, "keyid");
	ProfileRacoonOptionsWidget->LocalIdTypeCombobox->insertItem(6, "asn1dn");
	
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(0, "none");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(1, "address");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(2, "user_fqdn");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(3, "fqdn");	
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(4, "keyid (file)");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(5, "keyid");
	ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->insertItem(6, "asn1dn");

    ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(0, i18n("Certificate ID"));
    ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(1, "asn1dn");
    ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(2, "address");
    ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(3, "fqdn");
    ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(4, "keyid");
    ProfileIpsecOptionsWidget->LocalIdTypeCombobox->insertItem(5, "user_fqdn");
	
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem(0, "asn1dn");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem(1, "address");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem(2, "fqdn");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem(3, "keyid");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem(4, "user_fqdn");
	ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->insertItem(5, "none");

    slotStatusMsg(i18n("Collecting kernel crypto..."), ID_FLASH_MSG);
    Utils::IpsecAlgos KernelCrypto = Utils(GlobalConfig).getKernelCrypto();

    // man racoon.conf
    ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem(0, "des");
    ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem(1, "3des");
    ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem(2, "blowfish");
    ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem(3, "cast128");
    ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem(4, "aes");
    ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem(5, "camellia");

    // man racoon.conf
    ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(0, "md5");
    ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(1, "sha1");
    ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(2, "sha256");
    ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(3, "sha384");
    ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem(4, "sha512");

#if 0
    // phase 2 encr algos from kernel
    int espEncryptionIdx = 0;
    for (QStringList::Iterator it = KernelCrypto.IpsecEspEncryptionAlgorithms.begin(); it != KernelCrypto.IpsecEspEncryptionAlgorithms.end(); ++it) {
        ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(espEncryptionIdx, espEncryptionIdx, *it);
        espEncryptionIdx++;
    }

    // phase 2 auth algos from kernel
    int espAuthenticationIdx = 0;
    for (QStringList::Iterator it = KernelCrypto.IpsecEspAuthenticationAlgorithms.begin(); it != KernelCrypto.IpsecEspAuthenticationAlgorithms.end(); ++it) {
        ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(espAuthenticationIdx, *it);
        espAuthenticationIdx++;
    }
#endif

    // vpn mit linux book
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(0, "des");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(1, "3des");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(2, "des_iv64");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(3, "des_iv32");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(4, "rc5");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(5, "rc4");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(6, "idea");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(7, "3idea");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(8, "cast128");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(9, "blowfish");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(10, "null_enc");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(11, "twofish");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(12, "rijndael");
    ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(13, "aes");

    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(0, "des");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(1, "3des");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(2, "des_iv64");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(3, "des_iv32");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(4, "hmac_md5");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(5, "hmac_sha1");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(6, "hmac_sha256");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(7, "hmac_sha384");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(8, "hmac_sha512");
    ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(9, "non_auth");

    ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->insertItem(0, "Basic");
    ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->insertItem(1, "NTLM");

    slotStatusMsg(i18n("Collecting OpenVPN capabilities..."), ID_FLASH_MSG);
    QStringList ciphers = Utils(GlobalConfig).getOpenvpnCiphers();
    QStringList digests = Utils(GlobalConfig).getOpenvpnDigests();

    int chipherIdx = 0;
    for (QStringList::Iterator it = ciphers.begin(); it != ciphers.end(); ++it) {
        ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->insertItem(chipherIdx, *it);
        chipherIdx++;
    }

    int digestIdx = 0;
    for (QStringList::Iterator it = digests.begin(); it != digests.end(); ++it) {
        ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->insertItem(digestIdx, *it);
        digestIdx++;
    }
    
    

	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem(VpnAccountData::chap, "CHAP");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem(VpnAccountData::pap, "PAP");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem(VpnAccountData::mschap, "MSCHAP");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem(VpnAccountData::mschap_v2, "MSCHAP-v2");

    ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->insertItem(0, "TUN");
    ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->insertItem(1, "TAP");

    ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem(0, "natt");
    ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem(1, "force-natt");
    ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem(2, "cisco-udp");
    ProfileCiscoOptionsWidget->CiscoNatModeComboBox->insertItem(3, "none");
	
	connect (ProfileCiscoOptionsWidget->CiscoNatModeComboBox, SIGNAL(textChanged ( const QString &)), this, SLOT(natModeToggled( const QString &)));
	

    profileAddedOrDeleted = false;
    NewProfileName = "";
    bool vpnclient_profile_in_list = false;

    // profile data

    if (!GlobalConfig->AccountList->isEmpty()) {
        for (int accountIdx = 0; accountIdx < GlobalConfig->AccountList->size(); ++accountIdx) {
            VpnAccountData *it = GlobalConfig->AccountList->at(accountIdx);
            if (it != 0) {
                if (GlobalConfig->KvpncDebugLevel > 5) {
                    GlobalConfig->appendLogEntry(i18n("Item found: %1", it->getName()),
                                                 KVpncEnum::debug);
                }

                ProfileGeneralSelector->insertItem(accountIdx, it->getName());
                ProfileNetworkRouteSelector->insertItem(accountIdx, it->getName());
                ProfileNetworkGeneralSelector->insertItem(accountIdx, it->getName());
                ProfileNetworkNatSelector->insertItem(accountIdx, it->getName());
                ProfileNetworkHttpProxySelector->insertItem(accountIdx, it->getName());
                ProfileNetworkVirtualIpSelector->insertItem(accountIdx, it->getName());
                ProfileCertSelector->insertItem(accountIdx, it->getName());
                ProfileSmartcardSelector->insertItem(accountIdx, it->getName());
                ProfilePskSelector->insertItem(accountIdx, it->getName());
                ProfileAuthenticationSelector->insertItem(accountIdx, it->getName());
                ProfileUserSelector->insertItem(accountIdx, it->getName());
                ProfileOpenvpnSelector->insertItem(accountIdx, it->getName());
                ProfilePptpSelector->insertItem(accountIdx, it->getName());
                ProfileVtunSelector->insertItem(accountIdx, it->getName());
                ProfileSshSelector->insertItem(accountIdx, it->getName());
                ProfileRacoonSelector->insertItem(accountIdx, it->getName());
                ProfileIpsecSelector->insertItem(accountIdx, it->getName());
                ProfileCiscoSelector->insertItem(accountIdx, it->getName());
				ProfileSpecificSelector->insertItem(accountIdx, it->getName());
                ProfileCmdExecBeforeConnectSelector->insertItem(accountIdx, it->getName());
                ProfileCmdExecBeforeDisconnectSelector->insertItem(accountIdx, it->getName());
                ProfileCmdExecAfterConnectSelector->insertItem(accountIdx, it->getName());
                ProfileCmdExecAfterDisconnectSelector->insertItem(accountIdx, it->getName());
				ProfileCommandExecSelector->insertItem(accountIdx, it->getName());
				
				ProfileGeneralSelector->model()->sort(0);
				ProfileAuthenticationSelector->model()->sort(0);
				ProfileUserSelector->model()->sort(0);
				ProfileCertSelector->model()->sort(0);
				ProfileSmartcardSelector->model()->sort(0);
				ProfilePskSelector->model()->sort(0);
				ProfileNetworkGeneralSelector->model()->sort(0);
				ProfileNetworkRouteSelector->model()->sort(0);
				ProfileNetworkNatSelector->model()->sort(0);
				ProfileNetworkHttpProxySelector->model()->sort(0);
				ProfileNetworkVirtualIpSelector->model()->sort(0);
				ProfileSpecificSelector->model()->sort(0);
				ProfileCiscoSelector->model()->sort(0);
				ProfileRacoonSelector->model()->sort(0);
				ProfileIpsecSelector->model()->sort(0);
				ProfileOpenvpnSelector->model()->sort(0);
				ProfilePptpSelector->model()->sort(0);
				ProfileVtunSelector->model()->sort(0);
				ProfileSshSelector->model()->sort(0);
				ProfileCommandExecSelector->model()->sort(0);
				ProfileCmdExecBeforeConnectSelector->model()->sort(0);
				ProfileCmdExecAfterConnectSelector->model()->sort(0);
				ProfileCmdExecBeforeDisconnectSelector->model()->sort(0);
				ProfileCmdExecAfterDisconnectSelector->model()->sort(0);
				

                if (vpnclient_profile_in_list == false) {
                    if (it->getConnectionType() == VpnAccountData::ciscoorig) {
                        vpnclient_profile_in_list = true;
                    }
                }
            }
            int ProfileNameIndex = ProfileGeneralSelector->findText(GlobalConfig->currentProfile->getName());
			if (ProfileNameIndex == -1)
				ProfileNameIndex = 0;
			
			ProfileGeneralSelector->setCurrentIndex(ProfileNameIndex);
			ProfileNetworkRouteSelector->setCurrentIndex(ProfileNameIndex);
			ProfileNetworkGeneralSelector->setCurrentIndex(ProfileNameIndex);
			ProfileNetworkNatSelector->setCurrentIndex(ProfileNameIndex);
			ProfileNetworkHttpProxySelector->setCurrentIndex(ProfileNameIndex);
			ProfileNetworkVirtualIpSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCertSelector->setCurrentIndex(ProfileNameIndex);
			ProfileSmartcardSelector->setCurrentIndex(ProfileNameIndex);
			ProfilePskSelector->setCurrentIndex(ProfileNameIndex);
			ProfileAuthenticationSelector->setCurrentIndex(ProfileNameIndex);
			ProfileUserSelector->setCurrentIndex(ProfileNameIndex);
			ProfileOpenvpnSelector->setCurrentIndex(ProfileNameIndex);
			ProfilePptpSelector->setCurrentIndex(ProfileNameIndex);
			ProfileVtunSelector->setCurrentIndex(ProfileNameIndex);
			ProfileSshSelector->setCurrentIndex(ProfileNameIndex);
			ProfileRacoonSelector->setCurrentIndex(ProfileNameIndex);
			ProfileIpsecSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCiscoSelector->setCurrentIndex(ProfileNameIndex);
			ProfileSpecificSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCmdExecBeforeConnectSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCmdExecBeforeDisconnectSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCmdExecAfterConnectSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCmdExecAfterDisconnectSelector->setCurrentIndex(ProfileNameIndex);
			ProfileCommandExecSelector->setCurrentIndex(ProfileNameIndex);
        }

        if (Utils(GlobalConfig).getToolInfo("vpnclient")->found == true && vpnclient_profile_in_list == true) {
            slotStatusMsg(i18n("Collecting cisco certs from Cisco certificate store..."), ID_STATUS_MSG);
            CiscoCerts.clear();
            if (GlobalConfig->KvpncDebugLevel > 2) {
                GlobalConfig->appendLogEntry(i18n("Looking for certs in Cisco certificate store..."),
                                             KVpncEnum::debug);
            }
            CiscoCerts  = Utils(GlobalConfig).getCertsFromCiscoCertStore();

			slotStatusMsg ( i18n("Collecting cisco CA certs from Cisco certificate store..."), ID_STATUS_MSG );
			CiscoCaCerts.clear();
			if (GlobalConfig->KvpncDebugLevel > 2)
				GlobalConfig->appendLogEntry(i18n("Looking for CA certs in Cisco certificate store..."),KVpncEnum::debug);
			CiscoCaCerts  = Utils(GlobalConfig).getCertsFromCiscoCertStore("ca");
			
            if (GlobalConfig->KvpncDebugLevel > 2) {
                GlobalConfig->appendLogEntry(i18n("Done."), KVpncEnum::debug);
            }

            slotStatusMsg(i18n("Ready."), ID_STATUS_MSG);
        }

        if (GlobalConfig->currentProfile != 0L) {
            // set only if in list of current ciphers
            // if ( ciphers.contains(QString(GlobalConfig->currentProfile->getUserdefiniedCipher()), Qt::CaseInsensitive)) {
            if (!GlobalConfig->currentProfile->getUserdefiniedCipher().isEmpty()) {
				int CipherIndex =  ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->findText(GlobalConfig->currentProfile->getUserdefiniedCipher());
				if (CipherIndex == -1)
					CipherIndex = 0;
                ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->setCurrentIndex(CipherIndex);
            } else {
                QString Chipher = "";
                if (ciphers.count() > 0)
                    Chipher = ciphers.first();
				int CipherIndex =  ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->findText(Chipher);
				if (CipherIndex == -1)
					CipherIndex = 0;
				ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->setCurrentIndex(CipherIndex);
            }
            // } else {
            //     ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);
            // }

            ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked(GlobalConfig->currentProfile->getUseTlsAuth());
            ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setUrl(GlobalConfig->currentProfile->getTlsAuthFile());

            ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked(GlobalConfig->currentProfile->getUseTlsRemoteHost());
            ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setText(GlobalConfig->currentProfile->getTlsRemoteHost());
            ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->insertItem(0, i18n("None"));
            ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->insertItem(1, i18n("0"));
            ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->insertItem(2, i18n("1"));

            ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setChecked(GlobalConfig->currentProfile->getUseHttpProxy());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->setText(GlobalConfig->currentProfile->getHttpProxy());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->setValue(GlobalConfig->currentProfile->getHttpProxyTimeout());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->setValue(GlobalConfig->currentProfile->getHttpProxyPort());
            ProfileNetworkHttpProxyOptionsWidget->useHttpProxyToggeled(GlobalConfig->currentProfile->getUseHttpProxy());

            if (GlobalConfig->currentProfile->getHttpProxyAuthType() == "basic") {
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentIndex(KVpncEnum::basic);
            } else if (GlobalConfig->currentProfile->getHttpProxyAuthType() == "ntlm") {
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentIndex(KVpncEnum::ntlm);
            } else {
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentIndex(KVpncEnum::basic);
            }

            ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setText(GlobalConfig->currentProfile->getHttpProxyUser());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setText(GlobalConfig->currentProfile->getHttpProxyPass());

            ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->setChecked(GlobalConfig->currentProfile->getUseHttpProxyAuth());
			

            ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked(GlobalConfig->currentProfile->getUseMtu());
            ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue(GlobalConfig->currentProfile->getMtu());
            ProfileNetworkGeneralOptionsWidget->MruCheckbox->setChecked(GlobalConfig->currentProfile->getUseMru());
            ProfileNetworkGeneralOptionsWidget->MruSpinbox->setValue(GlobalConfig->currentProfile->getMru());

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco ||
                    GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp ||
                    GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
                    GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
                    GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn) {
                ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled(true);
                ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled(true);

                if (GlobalConfig->currentProfile->getUseMtu()) {
                    ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(true);
                } else {
                    ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(false);
                }

                if (GlobalConfig->currentProfile->getUseMru()) {
                    ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(true);
                } else {
                    ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(false);
                }
            } else {
                ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled(false);
                ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled(false);
            }
        } else {
#if 0
            ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileUserOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfilePptpOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentIndex(0);
            ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentIndex(0);
#endif
            ProfileGeneralOptionsWidget->setEnabled(false);
            ProfileNetworkRouteOptionsWidget->setEnabled(false);
            ProfileNetworkNatOptionsWidget->setEnabled(false);
            ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);
            ProfileCertOptionsWidget->setEnabled(false);
            ProfilePskOptionsWidget->setEnabled(false);
            ProfileUserOptionsWidget->setEnabled(false);
            ProfileOpenvpnOptionsWidget->setEnabled(false);
            ProfilePptpOptionsWidget->setEnabled(false);
            ProfileRacoonOptionsWidget->setEnabled(false);
            ProfileIpsecOptionsWidget->setEnabled(false);
            ProfileCiscoOptionsWidget->setEnabled(false);
            ProfileCmdExecBeforeConnectOptionsWidget->setEnabled(false);
            ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled(false);
            ProfileCmdExecAfterConnectOptionsWidget->setEnabled(false);
            ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled(false);
            ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled(true);
        }
    } else {
        ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled(false);
        ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled(false);
        ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled(false);
    }

    // pppd settings
    ProfilePptpOptionsWidget->DnsServerLineedit->setEnabled(false);

    // disabled for now
    ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->hide();

    ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);

#if 0
    ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
    ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
    ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setEnabled(true);
    ProfileNetworkVirtualIpOptionsWidget->LabelLocalVirtualIp->setEnabled(true);
#endif

    NetworkInterface iface(GlobalConfig, GlobalConfig->appPointer);
    QStringList list = iface.getAllNetworkInterfaces();
    int networkdeviceIdx = 0;
    ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem(networkdeviceIdx, "default");
    networkdeviceIdx++;

    for (QStringList::Iterator it = list.begin(); it != list.end(); ++it) {
        ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem(networkdeviceIdx, QString(*it));
        networkdeviceIdx++;
    }
    ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled(true);
    ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled(true);

    if (GlobalConfig->currentProfile != 0) {
        if (GlobalConfig->KvpncDebugLevel > 2) {
            GlobalConfig->appendLogEntry(i18n("Profile changed (startup): %1", GlobalConfig->currentProfile->getName()),
                                         KVpncEnum::debug);
        }
        connectionTypeChanged(GlobalConfig->currentProfile->getConnectionType());
        profileChanged(GlobalConfig->currentProfile->getName());
        authTypeChanged(GlobalConfig->currentProfile->getAuthType());
    }

    configChanged = false;
    canAccept = true;

	slotStatusMsg(i18n("Ready."), ID_STATUS_MSG);
    GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::setupGui()
{
    // setShowIconsInTreeList(true);

    QStringList path;
    path.clear();
    path << i18n("KVpnc");
    // setFolderIcon(path, SmallIcon("application", KIconLoader::SizeSmall));

    path.clear();

    // QVBoxLayout *lo;

    // KPageWidgetItem *page = 0;

    if (!showOnlyProfiles) {
        /* called as preferences dialog */
        // General
        GeneralOptionsWidget = new ConfigGeneralOptions((QWidget *)0);
        GeneralOptionsFrame = new KPageWidgetItem((QWidget *)GeneralOptionsWidget,
                i18n("General"));
        GeneralOptionsFrame->setHeader(i18n("General"));
        GeneralOptionsFrame->setIcon(KIcon("system-run"));
        addPage(GeneralOptionsFrame);
        connect(GeneralOptionsWidget->useKwalletCheckBox, SIGNAL(toggled(bool)),
                this, SLOT(useKwalletToggled(bool)));

#if 0
        QList<QWidget *> GeneralOptionsWidgetList = GeneralOptionsWidget->findChildren<QWidget *>("QCheckBox");
        for (int i = 0; i < GeneralOptionsWidgetList.size(); ++i) {
            connect(GeneralOptionsWidgetList.at(i), SIGNAL(stateChanged(int)),
                    this, SLOT(checkboxStateChanged(int)));
        }
#endif

        // Debug
        DebugOptionsWidget = new ConfigDebugOptions((QWidget *)0);
        DebugOptionsFrame = new KPageWidgetItem((QWidget *)DebugOptionsWidget, i18n("Debug"));
        DebugOptionsFrame->setHeader(i18n("Debug"));
        DebugOptionsFrame->setIcon(KIcon("tools-report-bug"));
        addSubPage(GeneralOptionsFrame, DebugOptionsFrame);

        ConnectOptionsWidget = new ConfigConnectOptions((QWidget *)0);
        ConnectOptionsFrame = new KPageWidgetItem((QWidget *)ConnectOptionsWidget, i18n("Connect"));
        ConnectOptionsFrame->setHeader(i18n("Connect"));
        ConnectOptionsFrame->setIcon(KIcon("connecting"));
        addSubPage(GeneralOptionsFrame, ConnectOptionsFrame);
		
        LogOptionsWidget = new ConfigLogOptions((QWidget *)0);
        LogOptionsFrame = new KPageWidgetItem((QWidget *)LogOptionsWidget, i18n("Log"));
        LogOptionsFrame->setHeader(i18n("Log"));
        LogOptionsFrame->setIcon(KIcon("format-list-ordered"));
        addSubPage(GeneralOptionsFrame, LogOptionsFrame);

		DaemonScrollView = new QScrollArea();
		ConfigDaemonOptionsWidget = new ConfigDaemonOptions(DaemonScrollView->widget());
		DaemonScrollView->setWidget(ConfigDaemonOptionsWidget);
        ConfigDaemonOptionsFrame = new KPageWidgetItem((QWidget *)DaemonScrollView, i18n("Daemons"));
        ConfigDaemonOptionsFrame->setHeader(i18n("Daemons"));
        ConfigDaemonOptionsFrame->setIcon(KIcon("fork"));

        DaemonScrollView->adjustSize();

        QSize daemonSize = ConfigDaemonOptionsWidget->sizeHint();
        ConfigDaemonOptionsWidget->resize(QSize(daemonSize.width() - 4, daemonSize.height()));
        ConfigDaemonOptionsWidget->setFixedSize(QSize(daemonSize.width() - 4, daemonSize.height()));

        // lo->addWidget(DaemonScrollView);
        addSubPage(GeneralOptionsFrame, ConfigDaemonOptionsFrame);

        connect(ConfigDaemonOptionsWidget->OpenvpnPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(OpenvpnPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->FreeswanPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(FreeswanPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->PppdPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(PppdPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->PptpPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(PptpPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->RacoonPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(RacoonPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->VpncPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(VpncPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->L2tpdPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(L2tpdPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->Xl2tpdPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(Xl2tpdPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->VtundPathInput, SIGNAL(urlSelected(const KUrl &)),
                this, SLOT(VtundPathChanged(const KUrl &)));
        connect(ConfigDaemonOptionsWidget->SshPathInput, SIGNAL(urlSelected(const KUrl&)),
                this, SLOT(SshPathChanged(const KUrl&)));

		
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->insertItem(0, i18n("none"));
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->insertItem(1, i18n("general"));
		ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->insertItem(2, i18n("general + packets"));
		
		ConfigDaemonOptionsWidget->PptpLogLevelComboBox->insertItem(0, i18n("default"));
		ConfigDaemonOptionsWidget->PptpLogLevelComboBox->insertItem(1, i18n("low"));
		ConfigDaemonOptionsWidget->PptpLogLevelComboBox->insertItem(2, i18n("high"));
		
        HelperProgramOptionsWidget = new ConfigHelperProgramOptions((QWidget *)0);
        HelperProgramOptionsFrame = new KPageWidgetItem((QWidget *)HelperProgramOptionsWidget,
                i18n("Helper Programs"));
        HelperProgramOptionsFrame->setHeader(i18n("Helper Programs"));
        HelperProgramOptionsFrame->setIcon(KIcon("fork"));
        addSubPage(GeneralOptionsFrame, HelperProgramOptionsFrame);
    }

    QWidget *ProfileGeneralSelectorWidget = new QWidget();
    QVBoxLayout *ProfileGeneralSelectorLayout = new QVBoxLayout(ProfileGeneralSelectorWidget);
    QLabel *ProfileGeneralSelectorLabel = new QLabel(ProfileGeneralSelectorWidget);
    ProfileGeneralSelectorLabel->setText(i18n("Profile:"));
    ProfileGeneralOptionsWidget = new ProfileGeneralOptions(ProfileGeneralSelectorWidget,
            GlobalConfig);
    ProfileGeneralSelector = new KComboBox(ProfileGeneralSelectorWidget);
    ProfileGeneralSelectorLayout->addWidget(ProfileGeneralSelectorLabel);
    ProfileGeneralSelectorLayout->addWidget(ProfileGeneralSelector);
    ProfileGeneralSelectorLayout->addWidget(ProfileGeneralOptionsWidget);
    ProfileGeneralSelector->setEnabled(true);
    ProfileGeneralOptionsFrame = new KPageWidgetItem((QWidget *)ProfileGeneralSelectorWidget,
            i18n("Profile"));
    ProfileGeneralOptionsFrame->setHeader(i18n("Profile :: General"));
    ProfileGeneralOptionsFrame->setIcon(KIcon("system-run"));
    addPage(ProfileGeneralOptionsFrame);

    QWidget *ProfileAuthenticationSelectorWidget = new QWidget();
    QVBoxLayout *ProfileAuthenticationSelectorLayout = new QVBoxLayout(ProfileAuthenticationSelectorWidget);
    QLabel *ProfileAuthenticationSelectorLabel = new QLabel(ProfileAuthenticationSelectorWidget);
    ProfileAuthenticationSelectorLabel->setText(i18n("Profile:"));
    ProfileAuthenticationOptionsWidget = new QWidget(ProfileAuthenticationSelectorWidget);
    ProfileAuthenticationSelector = new KComboBox(ProfileAuthenticationSelectorWidget);
    ProfileAuthenticationSelectorLayout->addWidget(ProfileAuthenticationSelectorLabel);
    ProfileAuthenticationSelectorLayout->addWidget(ProfileAuthenticationSelector);
    ProfileAuthenticationSelectorLayout->addWidget(ProfileAuthenticationOptionsWidget);
    ProfileAuthenticationSelector->setEnabled(true);
    ProfileAuthenticationOptionsFrame = new KPageWidgetItem((QWidget *)ProfileAuthenticationSelectorWidget,
            i18n("Authentication"));
    ProfileAuthenticationOptionsFrame->setHeader(i18n("Profile :: Authentication"));
    ProfileAuthenticationOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileGeneralOptionsFrame, ProfileAuthenticationOptionsFrame);

    QWidget *ProfileUserSelectorWidget = new QWidget();
    QVBoxLayout *ProfileUserSelectorLayout = new QVBoxLayout(ProfileUserSelectorWidget);
    QLabel *ProfileUserSelectorLabel = new QLabel(ProfileUserSelectorWidget);
    ProfileUserSelectorLabel->setText(i18n("Profile:"));
    ProfileUserOptionsWidget = new ProfileUserOptions(ProfileUserSelectorWidget);
    ProfileUserSelector = new KComboBox(ProfileUserSelectorWidget);
    ProfileUserSelectorLayout->addWidget(ProfileUserSelectorLabel);
    ProfileUserSelectorLayout->addWidget(ProfileUserSelector);
    ProfileUserSelectorLayout->addWidget(ProfileUserOptionsWidget);

    ProfileUserSelector->setEnabled(true);
    ProfileUserOptionsFrame = new KPageWidgetItem((QWidget *)ProfileUserSelectorWidget,
            i18n("Authenticate"));
    ProfileUserOptionsFrame->setHeader(i18n("Profile :: User"));
    ProfileUserOptionsFrame->setIcon(KIcon("user"));
    addSubPage(ProfileAuthenticationOptionsFrame, ProfileUserOptionsFrame);

    QWidget *ProfileCertSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCertSelectorLayout = new QVBoxLayout(ProfileCertSelectorWidget);
    QLabel *ProfileCertSelectorLabel = new QLabel(ProfileCertSelectorWidget);
    ProfileCertSelectorLabel->setText(i18n("Profile:"));
    ProfileCertOptionsWidget = new ProfileCertOptions(ProfileCertSelectorWidget);
    ProfileCertSelector = new KComboBox(ProfileCertSelectorWidget);
    ProfileCertSelectorLayout->addWidget(ProfileCertSelectorLabel);
    ProfileCertSelectorLayout->addWidget(ProfileCertSelector);
    ProfileCertSelectorLayout->addWidget(ProfileCertOptionsWidget);

    ProfileCertSelector->setEnabled(true);
	connect(ProfileCertOptionsWidget->ImportCertificatePushButton, SIGNAL(clicked()), this, SLOT(importCertificate()));
	connect(ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox, SIGNAL(toggled(bool)), this, SLOT(useCiscoCertStoreToggled(bool)));
	
	
    ProfileCertOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCertSelectorWidget,
            i18n("Certificate"));
    ProfileCertOptionsFrame->setHeader(i18n("Profile :: Certificate"));
    ProfileCertOptionsFrame->setIcon(KIcon("certimport"));
    addSubPage(ProfileAuthenticationOptionsFrame,  ProfileCertOptionsFrame);


    QWidget *ProfileSmartcardSelectorWidget = new QWidget();
    QVBoxLayout *ProfileSmartcardSelectorLayout = new QVBoxLayout(ProfileSmartcardSelectorWidget);
    QLabel *ProfileSmartcardSelectorLabel = new QLabel(ProfileSmartcardSelectorWidget);
    ProfileSmartcardSelectorLabel->setText(i18n("Profile:"));
    ProfileSmartcardOptionsWidget = new ProfileSmartcardOptions(ProfileSmartcardSelectorWidget);
    ProfileSmartcardSelector = new KComboBox(ProfileSmartcardSelectorWidget);
    ProfileSmartcardSelectorLayout->addWidget(ProfileSmartcardSelectorLabel);
    ProfileSmartcardSelectorLayout->addWidget(ProfileSmartcardSelector);
    ProfileSmartcardSelectorLayout->addWidget(ProfileSmartcardOptionsWidget);
	
	ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->insertItem(0, i18n("auto"));
	ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->insertItem(1, i18n("sign"));
	ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->insertItem(2, i18n("recover"));
	ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->insertItem(3, i18n("any"));
	
	ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->insertItem(0, i18n("ID"));
	ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->insertItem(1, i18n("Name"));
	ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->insertItem(2, i18n("Label"));
	
	ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->insertItem(0, i18n("ID"));
	ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->insertItem(1, i18n("Label"));
	ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->insertItem(2, i18n("Subject"));

    ProfileSmartcardSelector->setEnabled(true);
    connect(ProfileSmartcardOptionsWidget->DetectPkcs11SlotsPushButton, SIGNAL(clicked()),
            this, SLOT(detectPkcs11Slots()));
    connect(ProfileSmartcardOptionsWidget->DetectPkcs11IdPushButton, SIGNAL(clicked()),
            this, SLOT(detectPkcs11Ids()));
    ProfileSmartcardOptionsFrame = new KPageWidgetItem((QWidget *)ProfileSmartcardSelectorWidget,
            i18n("Smartcard"));
    ProfileSmartcardOptionsFrame->setHeader(i18n("Profile :: Smartcard"));
    ProfileSmartcardOptionsFrame->setIcon(KIcon("certimport"));
    addSubPage(ProfileAuthenticationOptionsFrame,  ProfileSmartcardOptionsFrame);

    QWidget *ProfilePskSelectorWidget = new QWidget();
    QVBoxLayout *ProfilePskSelectorLayout = new QVBoxLayout(ProfilePskSelectorWidget);
    QLabel *ProfilePskSelectorLabel = new QLabel(ProfilePskSelectorWidget);
    ProfilePskSelectorLabel->setText(i18n("Profile:"));
    ProfilePskOptionsWidget = new ProfilePskOptions(ProfilePskSelectorWidget);
    ProfilePskSelector = new KComboBox(ProfilePskSelectorWidget);
    ProfilePskSelectorLayout->addWidget(ProfilePskSelectorLabel);
    ProfilePskSelectorLayout->addWidget(ProfilePskSelector);
    ProfilePskSelectorLayout->addWidget(ProfilePskOptionsWidget);

    ProfilePskSelector->setEnabled(true);
    ProfilePskOptionsFrame = new KPageWidgetItem((QWidget *)ProfilePskSelectorWidget,
            i18n("PSK"));
    ProfilePskOptionsFrame->setHeader(i18n("Profile :: PSK"));
    ProfilePskOptionsFrame->setIcon(KIcon("dialog-password"));
    addSubPage(ProfileAuthenticationOptionsFrame,  ProfilePskOptionsFrame);

    QWidget *ProfileNetworkGeneralSelectorWidget = new QWidget();
    QVBoxLayout *ProfileNetworkGeneralSelectorLayout = new QVBoxLayout(ProfileNetworkGeneralSelectorWidget);
    QLabel *ProfileNetworkGeneralSelectorLabel = new QLabel(ProfileNetworkGeneralSelectorWidget);
    ProfileNetworkGeneralSelectorLabel->setText(i18n("Profile:"));
    ProfileNetworkGeneralOptionsWidget = new ProfileNetworkGeneralOptions(ProfileNetworkGeneralSelectorWidget);
    ProfileNetworkGeneralSelector = new KComboBox(ProfileNetworkGeneralSelectorWidget);
    ProfileNetworkGeneralSelectorLayout->addWidget(ProfileNetworkGeneralSelectorLabel);
    ProfileNetworkGeneralSelectorLayout->addWidget(ProfileNetworkGeneralSelector);
    ProfileNetworkGeneralSelectorLayout->addWidget(ProfileNetworkGeneralOptionsWidget);
	
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(0, i18n("8"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(1, i18n("9"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(2, i18n("10"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(3, i18n("11"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(4, i18n("12"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(5, i18n("13"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(6, i18n("14"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(7, i18n("15"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(8, i18n("16"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(9, i18n("17"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(10, i18n("18"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(11, i18n("19"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(12, i18n("20"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(13, i18n("21"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(14, i18n("22"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(15, i18n("23"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(16, i18n("24"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(17, i18n("25"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(18, i18n("26"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(19, i18n("27"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(20, i18n("28"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(21, i18n("29"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(22, i18n("30"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(23, i18n("31"));
	ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->insertItem(24, i18n("32"));

    ProfileNetworkGeneralSelector->setEnabled(true);
    ProfileNetworkGeneralOptionsFrame = new KPageWidgetItem((QWidget *)ProfileNetworkGeneralSelectorWidget,
            i18n("Network - General"));
    ProfileNetworkGeneralOptionsFrame->setHeader(i18n("Network :: General"));
    ProfileNetworkGeneralOptionsFrame->setIcon(KIcon("network-wired"));
    addSubPage(ProfileGeneralOptionsFrame, ProfileNetworkGeneralOptionsFrame);

    QWidget *ProfileNetworkRouteSelectorWidget = new QWidget();
    QVBoxLayout *ProfileNetworkRouteSelectorLayout = new QVBoxLayout(ProfileNetworkRouteSelectorWidget);
    QLabel *ProfileNetworkRouteSelectorLabel = new QLabel(ProfileNetworkRouteSelectorWidget);
    ProfileNetworkRouteSelectorLabel->setText(i18n("Profile:"));
    ProfileNetworkRouteOptionsWidget = new ProfileNetworkRouteOptions(ProfileNetworkRouteSelectorWidget);
    ProfileNetworkRouteSelector = new KComboBox(ProfileNetworkRouteSelectorWidget);
    ProfileNetworkRouteSelectorLayout->addWidget(ProfileNetworkRouteSelectorLabel);
    ProfileNetworkRouteSelectorLayout->addWidget(ProfileNetworkRouteSelector);
    ProfileNetworkRouteSelectorLayout->addWidget(ProfileNetworkRouteOptionsWidget);
	
	ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->insertItem(0, i18n("Keep default route"));
	ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->insertItem(1, i18n("Replace default route"));

    ProfileNetworkRouteSelector->setEnabled(true);
    ProfileNetworkRouteOptionsFrame = new KPageWidgetItem((QWidget *)ProfileNetworkRouteSelectorWidget,
            i18n("Routes"));
    ProfileNetworkRouteOptionsFrame->setHeader(i18n("Network :: Routes"));
    ProfileNetworkRouteOptionsFrame->setIcon(KIcon("route"));
    addSubPage(ProfileNetworkGeneralOptionsFrame, ProfileNetworkRouteOptionsFrame);

    QWidget *ProfileNetworkNatSelectorWidget = new QWidget();
    QVBoxLayout *ProfileNetworkNatSelectorLayout = new QVBoxLayout(ProfileNetworkNatSelectorWidget);
    QLabel *ProfileNetworkNatSelectorLabel = new QLabel(ProfileNetworkNatSelectorWidget);
    ProfileNetworkNatSelectorLabel->setText(i18n("Profile:"));
    ProfileNetworkNatOptionsWidget = new ProfileNetworkNatOptions(ProfileNetworkNatSelectorWidget);
    ProfileNetworkNatSelector = new KComboBox(ProfileNetworkNatSelectorWidget);
    ProfileNetworkNatSelectorLayout->addWidget(ProfileNetworkNatSelectorLabel);
    ProfileNetworkNatSelectorLayout->addWidget(ProfileNetworkNatSelector);
    ProfileNetworkNatSelectorLayout->addWidget(ProfileNetworkNatOptionsWidget);

    ProfileNetworkNatSelector->setEnabled(true);
    ProfileNetworkNatOptionsFrame = new KPageWidgetItem((QWidget *)ProfileNetworkNatSelectorWidget,
            i18n("NAT"));
    ProfileNetworkNatOptionsFrame->setHeader(i18n("Network :: NAT"));
    ProfileNetworkNatOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileNetworkGeneralOptionsFrame,  ProfileNetworkNatOptionsFrame);

    QWidget *ProfileNetworkHttpProxySelectorWidget = new QWidget();
    QVBoxLayout *ProfileNetworkHttpProxySelectorLayout = new QVBoxLayout(ProfileNetworkHttpProxySelectorWidget);
    QLabel *ProfileNetworkHttpProxySelectorLabel = new QLabel(ProfileNetworkHttpProxySelectorWidget);
    ProfileNetworkHttpProxyOptionsWidget = new ProfileNetworkHttpProxyOptions(ProfileNetworkHttpProxySelectorWidget);
    ProfileNetworkHttpProxySelectorLabel->setText(i18n("Profile:"));
    ProfileNetworkHttpProxySelector = new KComboBox(ProfileNetworkHttpProxySelectorWidget);
    ProfileNetworkHttpProxySelectorLayout->addWidget(ProfileNetworkHttpProxySelectorLabel);
    ProfileNetworkHttpProxySelectorLayout->addWidget(ProfileNetworkHttpProxySelector);
    ProfileNetworkHttpProxySelectorLayout->addWidget(ProfileNetworkHttpProxyOptionsWidget);
    ProfileNetworkHttpProxySelector->setEnabled(true);
    ProfileNetworkHttpProxyOptionsFrame = new KPageWidgetItem((QWidget *)ProfileNetworkHttpProxySelectorWidget,
            i18n("HTTP proxy"));
    ProfileNetworkHttpProxyOptionsFrame->setHeader(i18n("Network :: HTTP proxy"));
    ProfileNetworkHttpProxyOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileNetworkGeneralOptionsFrame, ProfileNetworkHttpProxyOptionsFrame);

    QWidget *ProfileNetworkVirtualIpSelectorWidget = new QWidget();
    QVBoxLayout *ProfileNetworkVirtualIpSelectorLayout = new QVBoxLayout(ProfileNetworkVirtualIpSelectorWidget);
    QLabel *ProfileNetworkVirtualIpSelectorLabel = new QLabel(ProfileNetworkVirtualIpSelectorWidget);
    ProfileNetworkVirtualIpOptionsWidget = new ProfileNetworkVirtualIpOptions(ProfileNetworkVirtualIpSelectorWidget);
    ProfileNetworkVirtualIpSelectorLabel->setText(i18n("Profile:"));
    ProfileNetworkVirtualIpSelector = new KComboBox(ProfileNetworkVirtualIpSelectorWidget);
    ProfileNetworkVirtualIpSelectorLayout->addWidget(ProfileNetworkVirtualIpSelectorLabel);
    ProfileNetworkVirtualIpSelectorLayout->addWidget(ProfileNetworkVirtualIpSelector);
    ProfileNetworkVirtualIpSelectorLayout->addWidget(ProfileNetworkVirtualIpOptionsWidget);

    ProfileNetworkVirtualIpSelector->setEnabled(true);
    connect(ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox, SIGNAL(activated(const QString &)), this, SLOT(tunnelDeviceTypeChanged(const QString&)));
    ProfileNetworkVirtualIpOptionsFrame = new KPageWidgetItem((QWidget *)ProfileNetworkVirtualIpSelectorWidget,
            i18n("Virtual IP"));
    ProfileNetworkVirtualIpOptionsFrame->setHeader(i18n("Network :: Virtual IP"));
    ProfileNetworkVirtualIpOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileNetworkGeneralOptionsFrame, ProfileNetworkVirtualIpOptionsFrame);

    QWidget *ProfileSpecificSelectorWidget = new QWidget();
    QVBoxLayout *ProfileSpecificSelectorLayout = new QVBoxLayout(ProfileSpecificSelectorWidget);
    QLabel *ProfileSpecificSelectorLabel = new QLabel(ProfileSpecificSelectorWidget);
    ProfileSpecificSelectorLabel->setText(i18n("Profile:"));
    ProfileSpecificOptionsWidget = new QWidget(ProfileSpecificSelectorWidget);
    ProfileSpecificSelector = new KComboBox(ProfileSpecificSelectorWidget);
    ProfileSpecificSelectorLayout->addWidget(ProfileSpecificSelectorLabel);
    ProfileSpecificSelectorLayout->addWidget(ProfileSpecificSelector);
    ProfileSpecificSelectorLayout->addWidget(ProfileSpecificOptionsWidget);
    ProfileSpecificSelector->setEnabled(true);
    ProfileSpecificOptionsFrame = new KPageWidgetItem((QWidget *)ProfileSpecificSelectorWidget,
            i18n("Connection specific"));
    ProfileSpecificOptionsFrame->setHeader(i18n("Profile :: Connection specific"));
    ProfileSpecificOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileGeneralOptionsFrame, ProfileSpecificOptionsFrame);

    QWidget *ProfileCiscoSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCiscoSelectorLayout = new QVBoxLayout(ProfileCiscoSelectorWidget);
    QLabel *ProfileCiscoSelectorLabel = new QLabel(ProfileCiscoSelectorWidget);
    ProfileCiscoSelectorLabel->setText(i18n("Profile:"));
    ProfileCiscoOptionsWidget = new ProfileCiscoOptions(ProfileCiscoSelectorWidget);
    ProfileCiscoSelector = new KComboBox(ProfileCiscoSelectorWidget);
    ProfileCiscoSelectorLayout->addWidget(ProfileCiscoSelectorLabel);
    ProfileCiscoSelectorLayout->addWidget(ProfileCiscoSelector);
    ProfileCiscoSelectorLayout->addWidget(ProfileCiscoOptionsWidget);

    ProfileCiscoSelector->setEnabled(true);
    connect(ProfileCiscoOptionsWidget->LocalPortCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(localPortToggled(bool)));
    connect(ProfileCiscoOptionsWidget->ApplicationVersionCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(applicationVersionToggled(bool)));
    connect(ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(perfectForwardSecurityToggled(bool)));
    connect(ProfileCiscoOptionsWidget->IkeGroupCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(IkeGroupToggled(bool)));
    connect(ProfileCiscoOptionsWidget->SingleDesCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(singleDesToggled(bool)));
    connect(ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(dpdToggled(bool)));
    //ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->clear();
    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(0, "server");
    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(1, "nopfs");
    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(2, "dh1");
    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(3, "dh2");
    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(4, "dh5");

    //ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled( false );
    ProfileCiscoOptionsWidget->IkeGroupCombobox->clear();
    ProfileCiscoOptionsWidget->IkeGroupCombobox->insertItem(0, "dh1");
    ProfileCiscoOptionsWidget->IkeGroupCombobox->insertItem(1, "dh2");
    ProfileCiscoOptionsWidget->IkeGroupCombobox->insertItem(2, "dh5");

    ProfileCiscoOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCiscoSelectorWidget,
            i18n("Cisco"));
    ProfileCiscoOptionsFrame->setHeader(i18n("Connection specific :: Cisco"));
    ProfileCiscoOptionsFrame->setIcon(KIcon("cisco"));
    addSubPage(ProfileSpecificOptionsFrame, ProfileCiscoOptionsFrame);

    QWidget *ProfileRacoonSelectorWidget = new QWidget();
    QVBoxLayout *ProfileRacoonSelectorLayout = new QVBoxLayout(ProfileRacoonSelectorWidget);
    QLabel *ProfileRacoonSelectorLabel = new QLabel(ProfileRacoonSelectorWidget);
    ProfileRacoonSelectorLabel->setText(i18n("Profile:"));
    ProfileRacoonOptionsWidget = new ProfileRacoonOptions(ProfileRacoonSelectorWidget);
    ProfileRacoonSelector = new KComboBox(ProfileRacoonSelectorWidget);
    ProfileRacoonSelectorLayout->addWidget(ProfileRacoonSelectorLabel);
    ProfileRacoonSelectorLayout->addWidget(ProfileRacoonSelector);
    ProfileRacoonSelectorLayout->addWidget(ProfileRacoonOptionsWidget);

    ProfileRacoonSelector->setEnabled(true);
    ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem(0, "main");
    ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem(1, "aggressive");
    ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem(2, "base");
    ProfileRacoonOptionsWidget->ExchangeModeComboBox->setCurrentIndex(0);  // main
    connect(ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(perfectForwardSecurityToggled(bool)));
    connect(ProfileRacoonOptionsWidget->IkeGroupCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(IkeGroupToggled(bool)));

    //ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->clear();
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(0, "modp768");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(1, "modp1024");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(2, "modp1536");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(3, "modp2048");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(4, "modp3072");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(5, "modp4096");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(6, "modp6144");
    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(7, "modp8192");

    ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled(false);
    ProfileRacoonOptionsWidget->DHGroupComboBox->clear();
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(0, "modp768");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(1, "modp1024");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(2, "modp1536");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(3, "modp2048");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(4, "modp3072");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(5, "modp4096");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(6, "modp6144");
    ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem(7, "modp8192");

    ProfileRacoonOptionsFrame = new KPageWidgetItem((QWidget *)ProfileRacoonSelectorWidget,
            i18n("Racoon"));
    ProfileRacoonOptionsFrame->setHeader(i18n("Connection specific :: Racoon"));
    ProfileRacoonOptionsFrame->setIcon(KIcon("kame"));
    addSubPage(ProfileSpecificOptionsFrame, ProfileRacoonOptionsFrame);

    QWidget *ProfileIpsecSelectorWidget = new QWidget();
    QVBoxLayout *ProfileIpsecSelectorLayout = new QVBoxLayout(ProfileIpsecSelectorWidget);
    QLabel *ProfileIpsecSelectorLabel = new QLabel(ProfileIpsecSelectorWidget);
    ProfileIpsecSelectorLabel->setText(i18n("Profile:"));
    ProfileIpsecOptionsWidget = new ProfileIpsecOptions(ProfileIpsecSelectorWidget);
    ProfileIpsecSelector = new KComboBox(ProfileIpsecSelectorWidget);
    ProfileIpsecSelectorLayout->addWidget(ProfileIpsecSelectorLabel);
    ProfileIpsecSelectorLayout->addWidget(ProfileIpsecSelector);
    ProfileIpsecSelectorLayout->addWidget(ProfileIpsecOptionsWidget);
    ProfileIpsecSelector->setEnabled(true);
    connect(ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox, SIGNAL(toggled(bool)),
            this, SLOT(perfectForwardSecurityToggled(bool)));
    connect(ProfileIpsecOptionsWidget->UseXauthCheckBox, SIGNAL(toggled(bool)),
            this, SLOT(useXauthToggled(bool)));
    ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->insertItem(0, "transport");
    ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->insertItem(1, "tunnel");

    ProfileIpsecOptionsWidget->ExchangeModeComboBox->insertItem(0, "main");
    ProfileIpsecOptionsWidget->ExchangeModeComboBox->insertItem(1, "aggressive");
    ProfileIpsecOptionsWidget->ExchangeModeComboBox->insertItem(2, "base");
	
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled( false );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->clear();
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(0, "modp768" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(1, "modp1024" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(2, "modp1536" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(3, "modp2048" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(4, "modp3072" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(5, "modp4096" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(6, "modp6144" );
	ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->insertItem(7, "modp8192" );
	
	
    ProfileIpsecOptionsFrame = new KPageWidgetItem((QWidget *)ProfileIpsecSelectorWidget,
            i18n("Openswan/strongSwan"));
    ProfileIpsecOptionsFrame->setHeader(i18n("Connection specific :: IPSec"));
    ProfileIpsecOptionsFrame->setIcon(KIcon("openswan"));
    addSubPage(ProfileSpecificOptionsFrame, ProfileIpsecOptionsFrame);

    QWidget *ProfileOpenvpnSelectorWidget = new QWidget();
    QVBoxLayout *ProfileOpenvpnSelectorLayout = new QVBoxLayout(ProfileOpenvpnSelectorWidget);
    QLabel *ProfileOpenvpnSelectorLabel = new QLabel(ProfileOpenvpnSelectorWidget);
    ProfileOpenvpnSelectorLabel->setText(i18n("Profile:"));
    ProfileOpenvpnOptionsWidget = new ProfileOpenvpnOptions(ProfileOpenvpnSelectorWidget);
    ProfileOpenvpnSelector = new KComboBox(ProfileOpenvpnSelectorWidget);
    ProfileOpenvpnSelectorLayout->addWidget(ProfileOpenvpnSelectorLabel);
    ProfileOpenvpnSelectorLayout->addWidget(ProfileOpenvpnSelector);
    ProfileOpenvpnSelectorLayout->addWidget(ProfileOpenvpnOptionsWidget);
    ProfileOpenvpnSelector->setEnabled(true);
	
	ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->insertItem(0, "client");
	ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->insertItem(1, "server");

    ProfileOpenvpnOptionsFrame = new KPageWidgetItem((QWidget *)ProfileOpenvpnSelectorWidget,
            i18n("OpenVPN"));
    ProfileOpenvpnOptionsFrame->setHeader(i18n("Connection specific :: OpenVPN"));
    ProfileOpenvpnOptionsFrame->setIcon(KIcon("openvpn"));
    addSubPage(ProfileSpecificOptionsFrame, ProfileOpenvpnOptionsFrame);

    QWidget *ProfilePptpSelectorWidget = new QWidget();
    QVBoxLayout *ProfilePptpSelectorLayout = new QVBoxLayout(ProfilePptpSelectorWidget);
    QLabel *ProfilePptpSelectorLabel = new QLabel(ProfilePptpSelectorWidget);
    ProfilePptpSelectorLabel->setText(i18n("Profile:"));
    ProfilePptpOptionsWidget = new ProfilePptpOptions(ProfilePptpSelectorWidget);
    ProfilePptpSelector = new KComboBox(ProfilePptpSelectorWidget);
    ProfilePptpSelectorLayout->addWidget(ProfilePptpSelectorLabel);
    ProfilePptpSelectorLayout->addWidget(ProfilePptpSelector);
    ProfilePptpSelectorLayout->addWidget(ProfilePptpOptionsWidget);

    ProfilePptpSelector->setEnabled(true);

    ProfilePptpOptionsFrame = new KPageWidgetItem((QWidget *)ProfilePptpSelectorWidget,
            i18n("PPTP/L2TP"));
    ProfilePptpOptionsFrame->setHeader(i18n("Connection specific :: PPTP/L2TP"));
    ProfilePptpOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileSpecificOptionsFrame, ProfilePptpOptionsFrame);

    QWidget *ProfileVtunSelectorWidget = new QWidget();
    QVBoxLayout *ProfileVtunSelectorLayout = new QVBoxLayout(ProfileVtunSelectorWidget);
    QLabel *ProfileVtunSelectorLabel = new QLabel(ProfileVtunSelectorWidget);
    ProfileVtunSelectorLabel->setText(i18n("Profile:"));
    ProfileVtunOptionsWidget = new ProfileVtunOptions(ProfileVtunSelectorWidget);
    ProfileVtunSelector = new KComboBox(ProfileVtunSelectorWidget);
    ProfileVtunSelectorLayout->addWidget(ProfileVtunSelectorLabel);
    ProfileVtunSelectorLayout->addWidget(ProfileVtunSelector);
    ProfileVtunSelectorLayout->addWidget(ProfileVtunOptionsWidget);

    ProfileVtunSelector->setEnabled(true);

    ProfileVtunOptionsFrame = new KPageWidgetItem((QWidget *)ProfileVtunSelectorWidget,
            i18n("Vtun"));
    ProfileVtunOptionsFrame->setHeader(i18n("Connection specific :: Vtun"));
    ProfileVtunOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileSpecificOptionsFrame, ProfileVtunOptionsFrame);

    QWidget *ProfileSshSelectorWidget = new QWidget();
    QVBoxLayout *ProfileSshSelectorLayout = new QVBoxLayout(ProfileSshSelectorWidget);
    QLabel *ProfileSshSelectorLabel = new QLabel(ProfileSshSelectorWidget);
    ProfileSshSelectorLabel->setText(i18n("Profile:"));
    ProfileSshOptionsWidget = new ProfileSshOptions(ProfileSshSelectorWidget);
    ProfileSshSelector = new KComboBox(ProfileSshSelectorWidget);
    ProfileSshSelectorLayout->addWidget(ProfileSshSelectorLabel);
    ProfileSshSelectorLayout->addWidget(ProfileSshSelector);
    ProfileSshSelectorLayout->addWidget(ProfileSshOptionsWidget);

    ProfileSshSelector->setEnabled(true);

    ProfileSshOptionsFrame = new KPageWidgetItem((QWidget *)ProfileSshSelectorWidget,
            i18n("SSH"));
    ProfileSshOptionsFrame->setHeader(i18n("Connection specific :: SSH"));
    ProfileSshOptionsFrame->setIcon(KIcon("openssh"));
    addSubPage(ProfileSpecificOptionsFrame, ProfileSshOptionsFrame);

    ProfileSshOptionsWidget->SshKeyComboBox->clear();
    QByteArray Home = qgetenv("HOME");
    if (!Home.isEmpty()) {
        QDir dir(Home + "/.ssh");
        QStringList KeyFiles = dir.entryList(QStringList("*"));

#if 0
        if (GlobalConfig->KvpncDebugLevel > 2) {
            GlobalConfig->appendLogEntry(i18n("SSH files: %1", KeyFiles.join(",")),
                                         KVpncEnum::debug);
        }
#endif

        if (KeyFiles.size() > 1) {
            int keyfilesIdx = 0;
            for (QStringList::Iterator it = KeyFiles.begin(); it != KeyFiles.end(); ++it) {
                QString item = QString(*it);
                if (GlobalConfig->KvpncDebugLevel > 2) {
                    GlobalConfig->appendLogEntry(i18n("Processing entry: %1", item),
                                                 KVpncEnum::debug);
                }
				if (!(item.contains(QString(".pub"), Qt::CaseInsensitive)) &&
					!item.contains(QString("authorized_keys"), Qt::CaseInsensitive) &&
					!item.contains(QString("known_hosts"), Qt::CaseInsensitive) &&
					!item.contains(QString("."), Qt::CaseInsensitive) &&
					!item.contains(QString(".."), Qt::CaseInsensitive) &&
					!item.contains(QString("config"), Qt::CaseInsensitive)
                   ) {
                    if (GlobalConfig->KvpncDebugLevel > 2) {
                        GlobalConfig->appendLogEntry(i18n("SSH key found: %1", *it),
                                                     KVpncEnum::debug);
                    }
                    ProfileSshOptionsWidget->SshKeyComboBox->insertItem(keyfilesIdx, *it);
                    keyfilesIdx++;
                }
            }
        }
    }
    QWidget *ProfileCommandExecSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCommandExecSelectorLayout = new QVBoxLayout(ProfileCommandExecSelectorWidget);
    QLabel *ProfileCommandExecSelectorLabel = new QLabel(ProfileCommandExecSelectorWidget);
    ProfileCommandExecSelectorLabel->setText(i18n("Profile:"));
    ProfileCommandExecOptionsWidget = new QWidget(ProfileCommandExecSelectorWidget);
    ProfileCommandExecSelector = new KComboBox(ProfileCommandExecSelectorWidget);
    ProfileCommandExecSelectorLayout->addWidget(ProfileCommandExecSelectorLabel);
    ProfileCommandExecSelectorLayout->addWidget(ProfileCommandExecSelector);
    ProfileCommandExecSelectorLayout->addWidget(ProfileCommandExecOptionsWidget);
    ProfileCommandExecSelector->setEnabled(true);
    ProfileCommandExecOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCommandExecSelectorWidget,
            i18n("Command execution"));
    ProfileCommandExecOptionsFrame->setHeader(i18n("Profile :: Command execution"));
    ProfileCommandExecOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileGeneralOptionsFrame, ProfileCommandExecOptionsFrame);

    QWidget *ProfileCmdExecBeforeConnectSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCmdExecBeforeConnectSelectorLayout = new QVBoxLayout(ProfileCmdExecBeforeConnectSelectorWidget);
    QLabel *ProfileCmdExecBeforeConnectSelectorLabel = new QLabel(ProfileCmdExecBeforeConnectSelectorWidget);
    ProfileCmdExecBeforeConnectSelectorLabel->setText(i18n("Profile:"));
    ProfileCmdExecBeforeConnectOptionsWidget = new ProfileCmdExecBeforeConnectOptions(ProfileCmdExecBeforeConnectSelectorWidget);
    ProfileCmdExecBeforeConnectSelector = new KComboBox(ProfileCmdExecBeforeConnectSelectorWidget);
    ProfileCmdExecBeforeConnectSelectorLayout->addWidget(ProfileCmdExecBeforeConnectSelectorLabel);
    ProfileCmdExecBeforeConnectSelectorLayout->addWidget(ProfileCmdExecBeforeConnectSelector);
    ProfileCmdExecBeforeConnectSelectorLayout->addWidget(ProfileCmdExecBeforeConnectOptionsWidget);

    ProfileCmdExecBeforeConnectSelector->setEnabled(true);

    ProfileCmdExecBeforeConnectOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCmdExecBeforeConnectSelectorWidget,
            i18n("Before Connect"));
    ProfileCmdExecBeforeConnectOptionsFrame->setHeader(i18n("Command Execution :: Before Connect"));
    ProfileCmdExecBeforeConnectOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileCommandExecOptionsFrame, ProfileCmdExecBeforeConnectOptionsFrame);

    QWidget *ProfileCmdExecAfterConnectSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCmdExecAfterConnectSelectorLayout = new QVBoxLayout(ProfileCmdExecAfterConnectSelectorWidget);
    QLabel *ProfileCmdExecAfterConnectSelectorLabel = new QLabel(ProfileCmdExecAfterConnectSelectorWidget);
    ProfileCmdExecAfterConnectSelectorLabel->setText(i18n("Profile:"));
    ProfileCmdExecAfterConnectOptionsWidget = new ProfileCmdExecAfterConnectOptions(ProfileCmdExecAfterConnectSelectorWidget);
    ProfileCmdExecAfterConnectSelector = new KComboBox(ProfileCmdExecAfterConnectSelectorWidget);
    ProfileCmdExecAfterConnectSelectorLayout->addWidget(ProfileCmdExecAfterConnectSelectorLabel);
    ProfileCmdExecAfterConnectSelectorLayout->addWidget(ProfileCmdExecAfterConnectSelector);
    ProfileCmdExecAfterConnectSelectorLayout->addWidget(ProfileCmdExecAfterConnectOptionsWidget);

    ProfileCmdExecAfterConnectSelector->setEnabled(true);

    ProfileCmdExecAfterConnectOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCmdExecAfterConnectSelectorWidget,
            i18n("After Connect"));
    ProfileCmdExecAfterConnectOptionsFrame->setHeader(i18n("Command Execution :: After Connect"));
    ProfileCmdExecAfterConnectOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileCommandExecOptionsFrame, ProfileCmdExecAfterConnectOptionsFrame);

    QWidget *ProfileCmdExecBeforeDisconnectSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCmdExecBeforeDisconnectSelectorLayout = new QVBoxLayout(ProfileCmdExecBeforeDisconnectSelectorWidget);
    QLabel *ProfileCmdExecBeforeDisconnectSelectorLabel = new QLabel(ProfileCmdExecBeforeDisconnectSelectorWidget);
    ProfileCmdExecBeforeDisconnectSelectorLabel->setText(i18n("Profile:"));
    ProfileCmdExecBeforeDisconnectOptionsWidget = new ProfileCmdExecBeforeDisconnectOptions(ProfileCmdExecBeforeDisconnectSelectorWidget);
    ProfileCmdExecBeforeDisconnectSelector = new KComboBox(ProfileCmdExecBeforeDisconnectSelectorWidget);
    ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget(ProfileCmdExecBeforeDisconnectSelectorLabel);
    ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget(ProfileCmdExecBeforeDisconnectSelector);
    ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget(ProfileCmdExecBeforeDisconnectOptionsWidget);
    ProfileCmdExecBeforeDisconnectSelector->setEnabled(true);

    ProfileCmdExecBeforeDisconnectOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCmdExecBeforeDisconnectSelectorWidget,
            i18n("Before Disconnect"));
    ProfileCmdExecBeforeDisconnectOptionsFrame->setHeader(i18n("Command Execution :: Before Disconnect"));
    ProfileCmdExecBeforeDisconnectOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileCommandExecOptionsFrame, ProfileCmdExecBeforeDisconnectOptionsFrame);


    QWidget *ProfileCmdExecAfterDisconnectSelectorWidget = new QWidget();
    QVBoxLayout *ProfileCmdExecAfterDisconnectSelectorLayout = new QVBoxLayout(ProfileCmdExecAfterDisconnectSelectorWidget);
    QLabel *ProfileCmdExecAfterDisconnectSelectorLabel = new QLabel(ProfileCmdExecAfterDisconnectSelectorWidget);
    ProfileCmdExecAfterDisconnectSelectorLabel->setText(i18n("Profile:"));
    ProfileCmdExecAfterDisconnectOptionsWidget = new ProfileCmdExecAfterDisconnectOptions(ProfileCmdExecAfterDisconnectSelectorWidget);
    ProfileCmdExecAfterDisconnectSelector = new KComboBox(ProfileCmdExecAfterDisconnectSelectorWidget);
    ProfileCmdExecAfterDisconnectSelectorLayout->addWidget(ProfileCmdExecAfterDisconnectSelectorLabel);
    ProfileCmdExecAfterDisconnectSelectorLayout->addWidget(ProfileCmdExecAfterDisconnectSelector);
    ProfileCmdExecAfterDisconnectSelectorLayout->addWidget(ProfileCmdExecAfterDisconnectOptionsWidget);

    ProfileCmdExecAfterDisconnectSelector->setEnabled(true);

    ProfileCmdExecAfterDisconnectOptionsFrame = new KPageWidgetItem((QWidget *)ProfileCmdExecAfterDisconnectSelectorWidget,
            i18n("After Disconnect"));
    ProfileCmdExecAfterDisconnectOptionsFrame->setHeader(i18n("Command Execution :: After Disconnect"));
    ProfileCmdExecAfterDisconnectOptionsFrame->setIcon(KIcon("system-run"));
    addSubPage(ProfileCommandExecOptionsFrame, ProfileCmdExecAfterDisconnectOptionsFrame);

    // resize(QSize(800,600));
    // setFixedSize(QSize(800,600));
    // adjustSize();

    if (!showOnlyProfiles) {
        // DaemonScrollView->adjustSize();
        // DaemonScrollView->updateContents();
        ConfigDaemonOptionsWidget->resize(ConfigDaemonOptionsWidget->height(),
                                          DaemonScrollView->widget()->width() - 100);

        // ConfigDaemonOptionsWidget->sizeHint();
    }
#if 0
    CertScrollView->adjustSize();
    CertScrollView->updateContents();
    ProfileCertOptionsWidget->adjustSize();
    adjustSize();
    ConfigDaemonOptionsWidget->adjustSize();

    adjustSize();
    enableButtonApply(false);
#endif

    /* connect profile combobox of each profile widget */
    connect(ProfileGeneralSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
	connect(ProfileSpecificSelector, SIGNAL(activated(const QString&)),
			this, SLOT(profileChanged(const QString&)));
    connect(ProfileNetworkRouteSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileNetworkGeneralSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileCommandExecSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileSpecificSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileAuthenticationSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileNetworkNatSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileNetworkHttpProxySelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileNetworkVirtualIpSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileCertSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileSmartcardSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfilePskSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileAuthenticationSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileUserSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileOpenvpnSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfilePptpSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileRacoonSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileIpsecSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileCiscoSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileVtunSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileSshSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
	connect(ProfileCommandExecSelector , SIGNAL(activated(const QString&)),
			this, SLOT(profileChanged(const QString&)));
    connect(ProfileCmdExecBeforeConnectSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileCmdExecBeforeDisconnectSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
    connect(ProfileCmdExecAfterConnectSelector, SIGNAL(activated(const QString&)),
            this, SLOT(profileChanged(const QString&)));
	connect(ProfileCmdExecAfterDisconnectSelector, SIGNAL(activated(const QString&)),
			this, SLOT(profileChanged(const QString&)));
	connect(ProfileCommandExecSelector, SIGNAL(activated(const QString&)),
			this, SLOT(profileChanged(const QString&)));
    connect(ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox, SIGNAL(toggled(bool)),
            this, SLOT(userAuthToggled(bool)));

    // connect(ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox, SIGNAL(toggled(bool)), SLOT(useSpecialServerSmartcardificateToggled(bool)));
    connect(ProfileCertOptionsWidget->AuthTypeComboBox, SIGNAL(activated(int)),
            this, SLOT(authTypeChanged(int)));
    // connect(ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox, SIGNAL(toggled(bool)), SLOT(useSpecialServerSmartcardificateToggled(bool)));
    connect(ProfilePskOptionsWidget->AuthTypeComboBox, SIGNAL(activated(int)),
            this, SLOT(authTypeChanged(int)));

    // connect(ProfileGeneralOptionsWidget->NewSessionPushButton, SIGNAL(clicked()),
    // this, SLOT(newSessionClicked()));
    connect(ProfileGeneralOptionsWidget->SaveSessionPushButton, SIGNAL(clicked()),
            this, SLOT(saveSessionClicked()));
    connect(ProfileGeneralOptionsWidget->RenameSessionPushButton, SIGNAL(clicked()),
            this, SLOT(renameSessionClicked()));
    connect(ProfileGeneralOptionsWidget->DeleteSessionPushButton, SIGNAL(clicked()),
            this, SLOT(deleteSessionClicked()));
    connect(this, SIGNAL(currentPageChanged(KPageWidgetItem *, KPageWidgetItem *)),
            this , SLOT(pageChanged(KPageWidgetItem *, KPageWidgetItem *)));

    connect(this, SIGNAL(applyClicked()), this, SLOT(saveSessionClicked()));
}

void PreferencesDialog::accept()
{
    // MyprofileWidget->saveSessionClicked();
    if (!showOnlyProfiles) {
        GlobalConfig->pathToVpnc = ConfigDaemonOptionsWidget->VpncPathInput->url().path();
        GlobalConfig->pathToRacoon = ConfigDaemonOptionsWidget->RacoonPathInput->url().path();
        GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url().path();
        GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url().path();
        GlobalConfig->pathToPppd = ConfigDaemonOptionsWidget->PppdPathInput->url().path();
        GlobalConfig->pathToPptp = ConfigDaemonOptionsWidget->PptpPathInput->url().path();
        GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url().path();
        GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url().path();
        GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url().path();
        GlobalConfig->pathToOpenvpn = ConfigDaemonOptionsWidget->OpenvpnPathInput->url().path();
        GlobalConfig->pathToIpsec = ConfigDaemonOptionsWidget->FreeswanPathInput->url().path();
        GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url().path();
        GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url().path();
        GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url().path();
        GlobalConfig->pathToPkcs11Tool = HelperProgramOptionsWidget->Pkcs11ToolPathInput->url().path();
        GlobalConfig->pathToSsh = ConfigDaemonOptionsWidget->SshPathInput->url().path();
        GlobalConfig->pathToTail = HelperProgramOptionsWidget->TailPathInput->url().path();
        GlobalConfig->pathToKsshAskpass = HelperProgramOptionsWidget->KsshaskpassPathInput->url().path();
        GlobalConfig->pathToGnomeSshAskpass = HelperProgramOptionsWidget->GnomeaskpassPathInput->url().path();
        GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
        GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
        GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
        GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
        GlobalConfig->useKwallet = GeneralOptionsWidget->useKwalletCheckBox->isChecked();
        GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
        GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value();
        GlobalConfig->RacoonDebugLevel = ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->currentText();
        GlobalConfig->VpncDebugLevel = ConfigDaemonOptionsWidget->spinVpncDebugLevel->value();
        GlobalConfig->OpenvpnDebugLevel = ConfigDaemonOptionsWidget->spinOpenvpnDebugLevel->value() + 1;
        GlobalConfig->SshDebugLevel = ConfigDaemonOptionsWidget->spinSshDebugLevel->value();

        if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == i18n("low")) {
            GlobalConfig->PptpLogLevel = 0;
        } else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == i18n("default")) {
            GlobalConfig->PptpLogLevel = 1;
        } else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == i18n("high")) {
            GlobalConfig->PptpLogLevel = 2;
        }

        GlobalConfig->enableDebugPppd = ConfigDaemonOptionsWidget->DebugPppdcheckBox->isChecked();
        GlobalConfig->enableDebugPptpd = ConfigDaemonOptionsWidget->DebugPptpdcheckBox->isChecked();
        GlobalConfig->enableDebugL2tpd = ConfigDaemonOptionsWidget->DebugL2tpdCheckBox->isChecked();
        GlobalConfig->enableDebugXl2tpd = ConfigDaemonOptionsWidget->DebugXl2tpdCheckBox->isChecked();
        GlobalConfig->enableDebugXl2tpdtunnel = ConfigDaemonOptionsWidget->EnableDebugXl2tpdtunnelCheckBox->isChecked();
        GlobalConfig->enableDebugXl2tpdstate = ConfigDaemonOptionsWidget->EnableDebugXl2tpdstateCheckBox ->isChecked();
        GlobalConfig->enableDebugXl2tpdpacket = ConfigDaemonOptionsWidget->EnableDebugXl2tpdpacketCheckBox->isChecked();
        GlobalConfig->enableDebugXl2tpdNetwork  = ConfigDaemonOptionsWidget->EnableDebugXl2tpdNetworkCheckBox->isChecked();
        GlobalConfig->tryConnectTimeout = ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value();
        GlobalConfig->programsInPath = ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
        GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();

        GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->palette().color(QPalette::Background);
        GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->palette().color(QPalette::Background);
        GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->palette().color(QPalette::Background);
        GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->palette().color(QPalette::Background);
        GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->palette().color(QPalette::Background);
        GlobalConfig->DebugBackgroundcolor = LogOptionsWidget->BackgroundLogLabel->palette().color(QPalette::Background);

        GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
        GlobalConfig->showInterfaceIPinTooltip = ConfigDaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
        GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
        GlobalConfig->AutoConnectProfile = ConnectOptionsWidget->AutoConnectProfileComboBox->currentText();
        GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
    }

    if (!GlobalConfig->AccountList->isEmpty()) {
        if (GlobalConfig->currentProfile == 0) {
            GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
        }
    }

    saveSessionClicked();

    if (canAccept) {
        KDialog::accept();
    }
}

void PreferencesDialog::reject()
{
    if (configChanged) {
        saveSessionClicked();
    }

    KDialog::reject();
}

void PreferencesDialog::slotApply()
{
    saveSessionClicked();
}

PreferencesDialog::~PreferencesDialog()
{
    delete ProfileGeneralSelector;
    delete ProfileNetworkRouteSelector;
    delete ProfileNetworkNatSelector;
    delete ProfileNetworkHttpProxySelector;
    delete ProfileNetworkVirtualIpSelector;
    delete ProfileCertSelector;
    delete ProfileSmartcardSelector;
    delete ProfilePskSelector;
    delete ProfileUserSelector;
    delete ProfileAuthenticationSelector;
    delete ProfileOpenvpnSelector;
    delete ProfilePptpSelector;
    delete ProfileRacoonSelector;
    delete ProfileIpsecSelector;
    delete ProfileCiscoSelector;
	delete ProfileSpecificSelector;
    delete ProfileCmdExecBeforeConnectSelector;
    delete ProfileCmdExecBeforeDisconnectSelector;
    delete ProfileCmdExecAfterConnectSelector;
    delete ProfileCmdExecAfterDisconnectSelector;
	delete ProfileCommandExecSelector;
	GlobalConfig->prefDlgOpen = false;
}

void PreferencesDialog::connectionTypeChanged(int type)
{
    if (GlobalConfig->KvpncDebugLevel > 1) {
        GlobalConfig->appendLogEntry(i18n("Connection type changed: %1", QString().setNum(type)),
                                     KVpncEnum::debug);
    }

    // KMessageBox::information(0,
    //                          "connection type changed: " + QString().setNum(type),
    //                          QString("type set"));
    if (GlobalConfig->currentProfile == 0) {
        return;
    }

    ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled(true);
    ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled(true);
    ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled(true);

    // First we should set a type
    // parent->buttonCancel->setEnabled(false);
    // parent->buttonOk->setEnabled(false);

	if (GlobalConfig->currentProfile->getUseNat()) {
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
	} else {
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
	}
	if ( GlobalConfig->currentProfile->getUseNat() )
		ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked( true );
	else
		ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked( false );

    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: cisco"),
                                         KVpncEnum::debug);
        }

        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(true);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(true);

        ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled(true);
        ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled(true);
        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);

		int NatModeIndex = ProfileCiscoOptionsWidget->CiscoNatModeComboBox->findText(GlobalConfig->currentProfile->getCiscoNatMode());
		if (NatModeIndex == -1)
			NatModeIndex = 0;
        ProfileCiscoOptionsWidget->CiscoNatModeComboBox->setCurrentIndex(NatModeIndex);

        emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: cisco (proprietary)"),
                                         KVpncEnum::debug);
        }

        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(true);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(true);

        ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled(true);
        ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled(true);
        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseUdp()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
        }
        ProfileCiscoOptionsWidget->CiscoNatModeComboBox->setEnabled(false);
		
		int NatModeIndex = ProfileCiscoOptionsWidget->CiscoNatModeComboBox->findText(GlobalConfig->currentProfile->getCiscoNatMode());
		if (NatModeIndex == -1)
			NatModeIndex = 0;
        ProfileCiscoOptionsWidget->CiscoNatModeComboBox->setCurrentIndex(NatModeIndex);
		
        emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: racoon"),
                                         KVpncEnum::debug);
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: l2tpd (racoon)"),
                                         KVpncEnum::debug);
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: ipsec (openswan/strongswan)"),
                                         KVpncEnum::debug);
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: l2tpd (openswan/strongswan)"),
                                         KVpncEnum::debug);
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: pptp"),
                                         KVpncEnum::debug);
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: openvpn"),
                                         KVpncEnum::debug);
        }

        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);
        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(false);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(false);
        // buttonCancel->setEnabled(true);
        // buttonOk->setEnabled(true);

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseUdp())
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        else
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

        emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: vtun"),
                                         KVpncEnum::debug);
        }

        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);
        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(false);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(false);
#if 0
        buttonCancel->setEnabled(true);
        buttonOk->setEnabled(true);

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseUdp()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
        }
#endif
        emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: SSH"),
                                         KVpncEnum::debug);
        }

        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);
        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(false);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(false);
#if 0
        buttonCancel->setEnabled(true);
        buttonOk->setEnabled(true);

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseUdp()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
        }
#endif
        emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::other) {
        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New type: none specified"),
                                         KVpncEnum::debug);
        }
    } else {
        GlobalConfig->appendLogEntry(i18n("Unknown type"),
                                     KVpncEnum::debug);
    }

    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon ||
            GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon ||
            GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
            GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
        if (GlobalConfig->currentProfile != 0) {
            ProfileCertOptionsWidget->privkeypathURLRequester->setUrl(GlobalConfig->currentProfile->getPrivateKey());
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
            ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
        }

        ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled(true);
        ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled(true);

        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(false);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(false);

        // buttonCancel->setEnabled(true);
        // buttonOk->setEnabled(true);
		
        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseUdp()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
        }

        
    }
    if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
		ProfilePptpOptionsWidget->MppeTab->setEnabled(false);
		ProfilePptpOptionsWidget->PppTab->setEnabled(false);
	} else {
		ProfilePptpOptionsWidget->MppeTab->setEnabled(true);
		ProfilePptpOptionsWidget->PppTab->setEnabled(true);
	}   
	emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
}

void PreferencesDialog::authTypeChanged(int authtype)
{
    if (GlobalConfig->currentProfile == 0) {
        return;
    }
    
    VpnAccountData::ConnectionType connectiontype = GlobalConfig->currentProfile->getConnectionType();
	GlobalConfig->appendLogEntry(i18n("currect connection type: \"%1\"." , connectiontype), KVpncEnum::debug);

	QComboBox *signalsender = (QComboBox *) QObject::sender ();
	if (signalsender == ProfileCertOptionsWidget->AuthTypeComboBox)
	{
		int CurrentIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
		QString CurrentText = ProfileCertOptionsWidget->AuthTypeComboBox->currentText();
		if ( connectiontype == VpnAccountData::cisco) {
			// we need a fix here
			if (CurrentIndex == 0) {
				CurrentIndex = VpnAccountData::psk;
				authtype = VpnAccountData::psk;
			} else {
				CurrentIndex = VpnAccountData::hybrid;
				authtype = VpnAccountData::hybrid;
			}
		}
		GlobalConfig->appendLogEntry( i18n( "authtype changed by %1.", QString("ProfileCertOptionsWidget") ) , KVpncEnum::debug );
		if ( CurrentIndex == VpnAccountData::cert)
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::cert);
		else if ( CurrentIndex == VpnAccountData::psk)
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::psk);
		else if ( CurrentIndex == VpnAccountData::hybrid)
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::hybrid);
		ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex());
	}
	if (signalsender == ProfilePskOptionsWidget->AuthTypeComboBox)
	{
		int CurrentIndex = ProfilePskOptionsWidget->AuthTypeComboBox->currentIndex();
		QString CurrentText = ProfilePskOptionsWidget->AuthTypeComboBox->currentText();
		if ( connectiontype == VpnAccountData::cisco) {
			// we need a fix here
			if (CurrentIndex == 0) {
				CurrentIndex = VpnAccountData::psk;
				authtype = VpnAccountData::psk;
			} else {
				CurrentIndex = VpnAccountData::hybrid;
				authtype = VpnAccountData::hybrid;
			}
		}
			
		GlobalConfig->appendLogEntry( i18n( "authtype changed by %1.", QString("ProfilePskOptionsWidget") ) , KVpncEnum::debug );
		if ( CurrentIndex == VpnAccountData::cert)
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::cert);
		else if ( CurrentIndex == VpnAccountData::psk)
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::psk);
		else if ( CurrentIndex == VpnAccountData::hybrid)
			GlobalConfig->currentProfile->setAuthType(VpnAccountData::hybrid);
		ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(ProfilePskOptionsWidget->AuthTypeComboBox->currentIndex());
	}

    ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled(true);

    if (GlobalConfig->KvpncDebugLevel > 0) {
        QString type = "unknown";
        if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
            type = "cert";
        } else if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk) {
            type = "psk";
        } else if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
            type = "hybrid";
        } else {
            type = "unknown auth";
        }

        GlobalConfig->appendLogEntry(i18n("New authtype: \"%1\"." , type), KVpncEnum::debug);
    }

    ProfilePskOptionsWidget->PskGroupBox->setEnabled(false);
    ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(false);
    ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(false);
    ProfileCertOptionsWidget->LabelAuthType->setEnabled(false);
    ProfilePskOptionsWidget->LabelAuthType->setEnabled(false);
    ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);

    

    if (connectiontype == VpnAccountData::cisco ||
            connectiontype == VpnAccountData::ciscoorig  ||
            connectiontype == VpnAccountData::pptp) {
		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco )
		{
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );
			ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( false );
			ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfilePskOptionsWidget->LabelPskFile->setEnabled( false );
			
			
			bool hasHybridSupport = getVpncHasHybridSupport();
			if (hasHybridSupport) {
				ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
				ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
				ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
				ProfilePskOptionsWidget->LabelAuthType->setEnabled ( true );
				
				GlobalConfig->appendLogEntry ( i18n ( "Hybrid support detected, enabling cert options" ),KVpncEnum::debug );
			} else {
				// 				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk) ); // PSK
				ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );
				ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );
				ProfileCertOptionsWidget->LabelAuthType->setEnabled( false );
				ProfilePskOptionsWidget->LabelAuthType->setEnabled ( false ); 
				ProfileCertOptionsWidget->setEnabled (false);
				GlobalConfig->appendLogEntry ( i18n ( "Hybrid support not detected, disabling cert options" ),KVpncEnum::debug );
			}
			if ( authtype == VpnAccountData::cert  ||  authtype == VpnAccountData::hybrid )
			{
				
				// certificate
				ProfileCertOptionsWidget->setEnabled( true );
				if ( authtype == VpnAccountData::cert)
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is cert" ),KVpncEnum::debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( true );
					ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
					ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
					ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
				}
				if ( authtype == VpnAccountData::hybrid)
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is hybrid" ),KVpncEnum::debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( false );
					
				}
				
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( true );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( true );
				
				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			}
			if ( authtype == VpnAccountData::psk )
			{
				GlobalConfig->appendLogEntry ( i18n ( "Auth type is psk" ),KVpncEnum::debug );
				// psk
				ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
				ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
				ProfilePskOptionsWidget->LabelPsk->setEnabled( true );
				ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( false );
				ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( false );
				ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
				ProfilePskOptionsWidget->LabelPskFile->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
				
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
				ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->x509certComboBox->setEnabled( false );
				ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( false );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( false );
				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			}
		}

        if (connectiontype == VpnAccountData::ciscoorig) {
            ProfileCertOptionsWidget->setEnabled(true);
            ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
            ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
            ProfileCertOptionsWidget->LabelAuthType->setEnabled(true);
            ProfilePskOptionsWidget->LabelAuthType->setEnabled(true);

			if ( authtype == VpnAccountData::cert  ||  authtype == VpnAccountData::hybrid )
			{
				// certificate
				ProfileCertOptionsWidget->setEnabled( true );
				if ( authtype == VpnAccountData::cert)
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is cert" ),KVpncEnum::debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( true );
				}
				else
				{
					GlobalConfig->appendLogEntry ( i18n ( "Auth type is hybrid" ),KVpncEnum::debug );
					ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );
					ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
					ProfileCertOptionsWidget->x509certComboBox ->setEnabled( false );
				}
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( true );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( true );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( true );
				
				ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
				
				ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
				ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
			}

            if (authtype == VpnAccountData::psk) {
				GlobalConfig->appendLogEntry ( i18n ( "Auth type is psk" ),KVpncEnum::debug );
                ProfilePskOptionsWidget->PskGroupBox->setEnabled(true);
                ProfilePskOptionsWidget->PSKLineEdit->setEnabled(true);
                ProfilePskOptionsWidget->LabelPsk->setEnabled(true);
                ProfilePskOptionsWidget->PskInFileCheckBox->setChecked(false);
                ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled(false);
                ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled(false);
                ProfilePskOptionsWidget->LabelPskFile->setEnabled(false);
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );

                ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
                ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
				ProfileCertOptionsWidget->x509certComboBox->setEnabled( false );
                ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);

                ProfileCertOptionsWidget->certpathURLRequester->setEnabled(false);
				ProfileCertOptionsWidget->LabelCaCertificatePath->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathComboBox->setEnabled( false );
				ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
                ProfileCertOptionsWidget->LabelCertificatePath->setEnabled(false);
				ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled( false );
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled( false );
                ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(false);
            }
        }
    } else if (connectiontype == VpnAccountData::freeswan ||
               connectiontype == VpnAccountData::l2tpd_freeswan ||
               connectiontype == VpnAccountData::racoon ||
               connectiontype == VpnAccountData::l2tpd_racoon) {
        ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
        ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
        ProfileCertOptionsWidget->LabelAuthType->setEnabled(true);
        ProfilePskOptionsWidget->LabelAuthType->setEnabled(true);

        if (authtype == VpnAccountData::cert) {
            ProfileCertOptionsWidget->setEnabled(true);
            ProfileCertOptionsWidget->x509certURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->LabelCertificate->setEnabled(true);
            ProfileCertOptionsWidget->certpathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->LabelCertificatePath->setEnabled(true);
            ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(true);
            ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
            ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
            ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->x509certComboBox->setEnabled(true);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);

            ProfilePskOptionsWidget->PskGroupBox->setEnabled(false);
            ProfilePskOptionsWidget->PSKLineEdit->setEnabled(false);
            ProfilePskOptionsWidget->LabelPsk->setEnabled(false);
        }

        if (authtype == VpnAccountData::psk) {
            ProfilePskOptionsWidget->PskGroupBox->setEnabled(true);
            ProfilePskOptionsWidget->PSKLineEdit->setEnabled(true);
            ProfilePskOptionsWidget->LabelPsk->setEnabled(true);

            ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);

            ProfileCertOptionsWidget->certpathURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->LabelCertificatePath->setEnabled(false);
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
            ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);

            ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(false);
            ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
            ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
        }

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
                ProfileCertOptionsWidget->setEnabled(true);
                ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
                ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
                ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
                ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl(GlobalConfig->currentProfile->getCaCertificate());
				ProfileCertOptionsWidget->certpathURLRequester->setUrl( GlobalConfig->currentProfile->getCertPath() );
                ProfileCertOptionsWidget->VerifyCaCertCheckBox->setChecked(GlobalConfig->currentProfile->getVerifyCaCert());
				ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
				ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
                ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
                ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
                ProfileCertOptionsWidget->LabelPrivateKeyPassword->setEnabled(false);
                ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
                ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
                ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
                ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setEnabled(false);
                ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
                ProfilePskOptionsWidget->setEnabled(false);
            }
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn) {
        ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
        ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);
        ProfileCertOptionsWidget->LabelAuthType->setEnabled(true);
        ProfilePskOptionsWidget->LabelAuthType->setEnabled(true);

        if (authtype == VpnAccountData::cert) {
            ProfileCertOptionsWidget->x509certURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->LabelCertificate->setEnabled(true);

            ProfileCertOptionsWidget->certpathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->LabelCertificatePath->setEnabled(true);
            ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(true);

            ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(true);

            ProfilePskOptionsWidget->PskGroupBox->setEnabled(false);
            ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(true);
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
            ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
            ProfileCertOptionsWidget->x509certComboBox->setEnabled(true);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
        }

        if (authtype == VpnAccountData::psk) {
            ProfilePskOptionsWidget->PskGroupBox->setEnabled(true);
            ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled(true);
            ProfilePskOptionsWidget->PSKLineEdit->setEnabled(true);
            ProfilePskOptionsWidget->LabelPsk->setEnabled(true);

            ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
            ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);

            ProfileCertOptionsWidget->certpathURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->LabelCertificatePath->setEnabled(false);
            ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(false);
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
            ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
            ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
            ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
        }
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun) {
        // TODO
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
        // TODO
    }
}

void PreferencesDialog::profileChanged(const QString& itemtext)
{
    bool profileFound = false;
    if (!GlobalConfig->AccountList->isEmpty() && !itemtext.isEmpty()) {
        // KMessageBox::information(0, "item clicked", Name);
        // profile data
		
		int ProfileNameIndex = ProfileGeneralSelector->findText(itemtext);
		if (ProfileNameIndex == -1) {
			ProfileNameIndex = 0;
		}
		
		if (!GlobalConfig->AccountList->isEmpty()) {
			for (int accountIdx = 0; accountIdx < GlobalConfig->AccountList->size(); ++accountIdx) {
				VpnAccountData *it = GlobalConfig->AccountList->at(accountIdx);
				if (it->getName() == itemtext) {
					profileFound = true;
					GlobalConfig->currentProfile = it;
					if (GlobalConfig->KvpncDebugLevel > 2) {
						GlobalConfig->appendLogEntry(i18n("Profile found: %1", it->getName()),
						KVpncEnum::debug);
					}
				}
			}
		}
		
        
        ProfileGeneralSelector->setCurrentIndex(ProfileNameIndex);
		ProfileNetworkRouteSelector->setCurrentIndex(ProfileNameIndex);
		ProfileNetworkNatSelector->setCurrentIndex(ProfileNameIndex);
		ProfileNetworkHttpProxySelector->setCurrentIndex(ProfileNameIndex);
		ProfileNetworkVirtualIpSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCertSelector->setCurrentIndex(ProfileNameIndex);
		ProfileSmartcardSelector->setCurrentIndex(ProfileNameIndex);
		ProfilePskSelector->setCurrentIndex(ProfileNameIndex);
		ProfileAuthenticationSelector->setCurrentIndex(ProfileNameIndex);
		ProfileUserSelector->setCurrentIndex(ProfileNameIndex);
		ProfileOpenvpnSelector->setCurrentIndex(ProfileNameIndex);
		ProfilePptpSelector->setCurrentIndex(ProfileNameIndex);
		ProfileVtunSelector->setCurrentIndex(ProfileNameIndex);
		ProfileSshSelector->setCurrentIndex(ProfileNameIndex);
		ProfileRacoonSelector->setCurrentIndex(ProfileNameIndex);
		ProfileIpsecSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCiscoSelector->setCurrentIndex(ProfileNameIndex);
		ProfileSpecificSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCmdExecBeforeConnectSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCmdExecBeforeDisconnectSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCmdExecAfterConnectSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCmdExecAfterDisconnectSelector->setCurrentIndex(ProfileNameIndex);
		ProfileCommandExecSelector->setCurrentIndex(ProfileNameIndex);

        if (GlobalConfig->currentProfile == 0) {
            return;
        }
        if (!profileFound) {
            if (GlobalConfig->KvpncDebugLevel > 2) {
                GlobalConfig->appendLogEntry(i18n("profile \"%1\" not found.", itemtext), KVpncEnum::debug);
            }
            return;
        }

        if (profileFound) {
            ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled(false);
            ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled(false);
            ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled(false);
        } else {
            ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled(true);
            ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled(true);
        }

        QString Name = itemtext;
        lastProfileName = Name;

        ProfileGeneralOptionsWidget->setEnabled(true);
        ProfileNetworkRouteOptionsWidget->setEnabled(true);
        ProfileNetworkNatOptionsWidget->setEnabled(true);
        ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
        ProfileCertOptionsWidget->setEnabled(true);
        ProfilePskOptionsWidget->setEnabled(true);
        ProfileUserOptionsWidget->setEnabled(true);
        ProfileOpenvpnOptionsWidget->setEnabled(true);
        ProfilePptpOptionsWidget->setEnabled(true);
        ProfileRacoonOptionsWidget->setEnabled(true);
        ProfileIpsecOptionsWidget->setEnabled(true);
        ProfileCiscoOptionsWidget->setEnabled(true);
        ProfileCmdExecBeforeConnectOptionsWidget->setEnabled(true);
        ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled(true);
        ProfileCmdExecAfterConnectOptionsWidget->setEnabled(true);
        ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled(true);

        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled(false);
        ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled(false);
        ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();



        if (GlobalConfig->KvpncDebugLevel > 2)
            GlobalConfig->appendLogEntry(i18n("::profileChanged() connectiontype before num: %1", QString().setNum(ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentIndex())),
                                         KVpncEnum::debug);

		
        ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentIndex((int)GlobalConfig->currentProfile->getConnectionType());

        if (GlobalConfig->KvpncDebugLevel > 2)
            GlobalConfig->appendLogEntry(i18n("::profileChanged() connectiontype num: %1", QString().setNum(GlobalConfig->currentProfile->getConnectionType())),
                                         KVpncEnum::debug);
        // KMessageBox::information(0,
        //                          "profilechanged() new conntype: " + QString().setNum(GlobalConfig->currentProfile->getConnectionType()),
        //                          QString("type set"));


        if (GlobalConfig->KvpncDebugLevel > 0) {
            GlobalConfig->appendLogEntry(i18n("New profile: %1", Name),
                                         KVpncEnum::debug);
        }

        profileHasChanged = true;
        NewProfileName = Name;

        ProfileCertOptionsWidget->x509certURLRequester->clear();
        ProfileCertOptionsWidget->certpathURLRequester->clear();
        ProfileUserOptionsWidget->UsernameLineEdit->clear();
        ProfilePskOptionsWidget->PSKLineEdit->clear();
        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->clear();
        ProfileGeneralOptionsWidget->gatewayLineEdit->clear();
        ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
        ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->clear();

        ProfilePskOptionsWidget->CheckSavePsk->setChecked(false);
        ProfileUserOptionsWidget->CheckUserPass->setChecked(false);
        ProfileCiscoOptionsWidget->IDLineEdit->clear();
        ProfileUserOptionsWidget->UsernameLineEdit->clear();
        ProfileUserOptionsWidget->PasswordEdit->clear();
        ProfileCmdExecBeforeConnectOptionsWidget->main->CmdBeforeConnectTextEdit->setEnabled(false);
        ProfileCmdExecAfterConnectOptionsWidget->main->CmdAfterConnectTextEdit->setEnabled(false);
        ProfileCmdExecBeforeDisconnectOptionsWidget->main->CmdBeforeDisconnectTextEdit->setEnabled(false);
        ProfileCmdExecAfterDisconnectOptionsWidget->main->CmdAfterDisconnectTextEdit->setEnabled(false);
        ProfileCmdExecBeforeConnectOptionsWidget->main->ExcuteCmdBeforeConnectCheckBox->setChecked(false);
        ProfileCmdExecAfterConnectOptionsWidget->main->ExcuteCmdAfterConnectCheckBox->setChecked(false);
        ProfileCmdExecBeforeDisconnectOptionsWidget->main->ExcuteCmdBeforeDisconnectCheckBox->setChecked(false);
        ProfileCmdExecAfterDisconnectOptionsWidget->main->ExcuteCmdAfterDisconnectCheckBox->setChecked(false);
        ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(false);
        ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked(false);

        ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->DnsServerLineedit->clear();
        ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked(false);
        ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue(1500);
        ProfileNetworkGeneralOptionsWidget->MruSpinbox->setValue(1500);
        ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked(false);
        ProfileNetworkGeneralOptionsWidget->MruCheckbox->setChecked(false);
        ProfilePptpOptionsWidget->DisableCcpCheckbox->setChecked(false);

        ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);
        ProfileVtunOptionsWidget->setEnabled(false);

        ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled(false);

        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(16); //24
        ProfileGeneralOptionsWidget->DescriptionLineEdit->setText(GlobalConfig->currentProfile->getDescription());
        ProfileGeneralOptionsWidget->gatewayLineEdit->setText(GlobalConfig->currentProfile->getGateway());

        if (GlobalConfig->currentProfile->getTunnelDeviceType() == QString("tap")) {
			// TAP
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setCurrentIndex(1);
        } else {
			// TUN
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setCurrentIndex(0);
        }

        //  AdvancedSettingsPushButton->setEnabled(false);
        if ((GlobalConfig->currentProfile->getNetworkDevice()).isEmpty()) {
            ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentIndex(0); // default
            if (GlobalConfig->KvpncDebugLevel > 2) {
                GlobalConfig->appendLogEntry(i18n("profile \"%1\": no network device defined, using \"default\".",
                                                  GlobalConfig->currentProfile->getName()),
                                             KVpncEnum::debug);
            }
        } else {
			int NetworkDeviceIndex = ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->findText(GlobalConfig->currentProfile->getNetworkDevice());
			if (NetworkDeviceIndex == -1) {
				int NetworkDeviceCount = ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->count();
				ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem(NetworkDeviceCount , GlobalConfig->currentProfile->getNetworkDevice());
				ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentIndex(NetworkDeviceCount);
			} else {
				ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentIndex(NetworkDeviceIndex);
			}
            if (GlobalConfig->KvpncDebugLevel > 2) {
                GlobalConfig->appendLogEntry(i18n("profile \"%1\": network device defined, using \"%2\".",
                                                  GlobalConfig->currentProfile->getName(),
                                                  GlobalConfig->currentProfile->getNetworkDevice()),
                                             KVpncEnum::debug);
            }
        }


        ProfileGeneralOptionsWidget->gatewayLineEdit->setText(GlobalConfig->currentProfile->getGateway());

        ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
        ProfilePskOptionsWidget->PSKFileURLRequester->setUrl(GlobalConfig->currentProfile->getPreSharedKeyFile());

        ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setChecked(GlobalConfig->currentProfile->getUseMailAddressAsIdentifier());

        ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText(GlobalConfig->currentProfile->getPingHostIP());
        ProfileNetworkGeneralOptionsWidget->PingCheckBox ->setChecked(GlobalConfig->currentProfile->getDoPingIP());

        ProfileUserOptionsWidget->UsernameLineEdit->setText(GlobalConfig->currentProfile->getUserName());
        ProfileUserOptionsWidget->PasswordEdit->setText(GlobalConfig->currentProfile->getUserPassword());
        ProfileUserOptionsWidget->CheckUserPass->setChecked(GlobalConfig->currentProfile->getSaveUserPassword());

        if (GlobalConfig->currentProfile->getUseUdp()) {
            ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(true);
        } else {
            ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(false);
        }

		if (GlobalConfig->currentProfile->getUseNat()) {
			ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked(true);
		} else {
			ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked(false);
		}


        ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(GlobalConfig->currentProfile->getUdpPort());
        if (GlobalConfig->currentProfile->getUseUdpPort()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);
        }

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseNat()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
        }
        

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn) {
            connect(ProfileNetworkNatOptionsWidget->UseUdpCheckbox, SIGNAL(toggled(bool)),
                    this, SLOT(useUdpToggled(bool)));
        } else {
            disconnect(ProfileNetworkNatOptionsWidget->UseUdpCheckbox, SIGNAL(toggled(bool)),
                       this, SLOT(useUdpToggled(bool)));
        }

        ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked(GlobalConfig->currentProfile->getUseMtu());
        ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue(GlobalConfig->currentProfile->getMtu());
        ProfileNetworkGeneralOptionsWidget->MruCheckbox->setChecked(GlobalConfig->currentProfile->getUseMru());
        ProfileNetworkGeneralOptionsWidget->MruSpinbox->setValue(GlobalConfig->currentProfile->getMru());
        ProfileNetworkGeneralOptionsWidget->FixPathMtuDiscoveryProblemCheckBox->setChecked(GlobalConfig->currentProfile->getFixPathMtuDiscoveryProblem());

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn) {
            ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled(true);

            if (GlobalConfig->currentProfile->getUseMtu()) {
                ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(true);
            } else {
                ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getUseMru()) {
                ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(true);
            } else {
                ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(false);
            }
        }

        ProfileNetworkGeneralOptionsWidget->UseReconnectDelayCheckBox->setChecked(GlobalConfig->currentProfile->getUseReconnectDelay());
        ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->setEnabled(GlobalConfig->currentProfile->getUseReconnectDelay());
        ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->setValue(GlobalConfig->currentProfile->getReconnectDelay());

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::l2tpd_racoon) ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon) ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan) ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::l2tpd_freeswan) ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn) ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::ciscoorig)) {
            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
                if (GlobalConfig->currentProfile->getUseSmartcard() && ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isEnabled()) {
                    ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
                    ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
                    ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
                    ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
                    ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
                    ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
                    ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
                } else {
                    ProfileCertOptionsWidget->x509certURLRequester->setEnabled(true);
                    ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
                    ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(true);
                    ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
                    ProfileCertOptionsWidget->LabelCertificate->setEnabled(true);
                    ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(true);
                    ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
                }
            }
        }

        ProfileCertOptionsWidget->LabelPrivateKeyPassword->setText(i18n("Private key passphrase:"));
        ProfileCertOptionsWidget->LabelCertificate->setText(i18n("Certificate:"));
        ProfileCertOptionsWidget->x509certURLRequester->show();
        ProfileCertOptionsWidget->x509certURLRequester->sizeHint();
        ProfileCertOptionsWidget->x509certComboBox->hide();
		ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->hide();
        ProfileCertOptionsWidget->VerifyCaCertCheckBox->setEnabled(false);
		ProfileCertOptionsWidget->setEnabled (true);

        ProfileCertOptionsWidget->AuthTypeComboBox->clear();
        ProfilePskOptionsWidget->AuthTypeComboBox->clear();

        ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->setChecked(GlobalConfig->currentProfile->getAskUserPasswordOnEachConnect());
        // FIXME: implement in all types
        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
            ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->setEnabled(true);
        } else
            ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->setEnabled(false);


		if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan  || 
			GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::l2tpd_freeswan ||  
			GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp ||  
			GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn || 
			GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun) {

            ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(0, i18n("X.509 Certificate"));
            ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(1, i18n("Pre Shared Key"));
            ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(0, i18n("X.509 Certificate"));
            ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(1, i18n("Pre Shared Key"));
        }
        
        ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->show();
		ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->show();

        /* connection specific */
        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig) {
			//bool vpncHasHybridSupport = false;
            ProfilePskOptionsWidget->CheckSavePsk->setChecked(GlobalConfig->currentProfile->getSavePsk());
            ProfileUserOptionsWidget->CheckUserPass->setChecked(GlobalConfig->currentProfile->getSaveUserPassword());
            ProfileCiscoOptionsWidget->IDLineEdit->setText(GlobalConfig->currentProfile->getID());
            ProfileUserOptionsWidget->UsernameLineEdit->setText(GlobalConfig->currentProfile->getUserName());
            ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
            ProfileUserOptionsWidget->PasswordEdit->setText(GlobalConfig->currentProfile->getUserPassword());
            ProfileUserOptionsWidget->DontSaveUsernameCheckBox->setChecked(GlobalConfig->currentProfile->getDontSaveUsername());
            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->show();
            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->setChecked(GlobalConfig->currentProfile->getHideGroupPasswordInAccountDataDialog());

            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
#if 0
                ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
                ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
                ProfileCertOptionsWidget->x509certComboBox->setEnabled(true);
                ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
#endif
                ProfileCertOptionsWidget->setEnabled(true);

				ProfileCertOptionsWidget->x509certURLRequester->setUrl( GlobalConfig->currentProfile->getX509Certificate() );
				

            }
            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk || GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
                ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
                ProfilePskOptionsWidget->CheckSavePsk->setChecked(GlobalConfig->currentProfile->getSavePsk());
				ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
                ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(true);
                ProfileCiscoOptionsWidget->LabelID->setEnabled(true);
                ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getAllowEmptyGroupPassword());
#if 0
                ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
                ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
                ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
                ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(false);
#endif
            }

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig) {
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( 0, i18n( "X.509 Certificate" ) );
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( 1, i18n( "Pre Shared Key" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( 0, i18n( "X.509 Certificate" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( 1, i18n( "Pre Shared Key" ) );
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem( 2, i18n( "Hybrid" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem( 2, i18n( "Hybrid" ) );
				
                ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(true);
                ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled(true);

				if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert || GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid )
				{
					ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->hide();
					ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->hide();
					if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
					} else {
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::hybrid);
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::hybrid);
					}
					ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( GlobalConfig->currentProfile->getPrivateKeyPass() );
					ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked( GlobalConfig->currentProfile->getSavePrivateKeyPassword() );
					//emit useCiscoCertStoreToggled(it->getSavePrivateKeyPassword());
					ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->show();
					ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->setChecked(GlobalConfig->currentProfile->getUseCiscoCertStore());
					if (GlobalConfig->currentProfile->getUseCiscoCertStore())
					{
						ProfileCertOptionsWidget->x509certURLRequester->hide();
						ProfileCertOptionsWidget->x509certComboBox->show();
						ProfileCertOptionsWidget->CaCertpathURLRequester->hide();
						ProfileCertOptionsWidget->CaCertpathComboBox->show();
						ProfileCertOptionsWidget->x509certComboBox->sizeHint();
						ProfileCertOptionsWidget->sizeHint();
						ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->setChecked(true);
					}
					else
					{
						ProfileCertOptionsWidget->x509certURLRequester->show();
						ProfileCertOptionsWidget->CaCertpathURLRequester->show();
						ProfileCertOptionsWidget->x509certComboBox->hide();
						ProfileCertOptionsWidget->CaCertpathComboBox->hide();
						ProfileCertOptionsWidget->x509certComboBox->sizeHint();
						ProfileCertOptionsWidget->sizeHint();
						ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->setChecked(false);
					}
					
					ProfileCertOptionsWidget->x509certComboBox->clear();
					int ciscocertsIdx = 0;
					for (QStringList::Iterator ciscoit = CiscoCerts.begin(); ciscoit != CiscoCerts.end(); ++ciscoit) {
						if (GlobalConfig->KvpncDebugLevel > 4) {
							GlobalConfig->appendLogEntry(i18n("Insert cisco cert: %1", *ciscoit), KVpncEnum::debug);
						}
						ProfileCertOptionsWidget->x509certComboBox->insertItem(ciscocertsIdx, QString(*ciscoit));
						ciscocertsIdx++;
					}
					
					if (GlobalConfig->currentProfile->getUseCiscoCertStore()) {
						if (!GlobalConfig->currentProfile->getX509Certificate().isEmpty()) {
							int X509CertIndex = ProfileCertOptionsWidget->x509certComboBox->findText(GlobalConfig->currentProfile->getX509Certificate());
							if (X509CertIndex == -1)
								X509CertIndex = 0;
							ProfileCertOptionsWidget->x509certComboBox->setCurrentIndex( X509CertIndex );
						} else {
							ProfileCertOptionsWidget->x509certComboBox->setCurrentIndex( 0 );
						}
					} else {
						ProfileCertOptionsWidget->x509certURLRequester->setUrl( GlobalConfig->currentProfile->getX509Certificate() );
					}
					
					
					ProfileCertOptionsWidget->CaCertpathComboBox->clear();
					int ciscocacertsIdx = 0;
					for (QStringList::Iterator ciscocait = CiscoCerts.begin(); ciscocait != CiscoCerts.end(); ++ciscocait) {
						if (GlobalConfig->KvpncDebugLevel > 4) {
							GlobalConfig->appendLogEntry(i18n("Insert cisco ca cert: %1", *ciscocait), KVpncEnum::debug);
						}
						ProfileCertOptionsWidget->CaCertpathComboBox->insertItem(ciscocacertsIdx, QString(*ciscocait));
						ciscocacertsIdx++;
					}
					
					
					if (!GlobalConfig->currentProfile->getCaCertificate().isEmpty()) {
						int CaCertIndex = ProfileCertOptionsWidget->CaCertpathComboBox->findText(GlobalConfig->currentProfile->getCaCertificate());
						if (CaCertIndex == -1)
							CaCertIndex = 0;
						ProfileCertOptionsWidget->CaCertpathComboBox->setCurrentIndex( CaCertIndex );
					} else {
						ProfileCertOptionsWidget->CaCertpathComboBox->setCurrentIndex(0);
					}
					ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl( GlobalConfig->currentProfile->getCaCertificate() );
				}
				else
				{
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
				}

                ProfileCertOptionsWidget->LabelPrivateKeyPassword->setText("Certificate password:");
                // ProfileCertOptionsWidget->LabelCertificate->setText(i18n("Certificate (enter name here):"));
                ProfileCertOptionsWidget->x509certURLRequester->hide();
                ProfileCertOptionsWidget->x509certComboBox->show();
                ProfileCertOptionsWidget->x509certComboBox->sizeHint();

                if (!GlobalConfig->currentProfile->getX509Certificate().isEmpty()) {
					int X509CertIndex = ProfileCertOptionsWidget->x509certComboBox->findText(GlobalConfig->currentProfile->getX509Certificate());
					if (X509CertIndex == -1)
						X509CertIndex = 0;
                    ProfileCertOptionsWidget->x509certComboBox->setCurrentIndex(X509CertIndex);
                } else {
					ProfileCertOptionsWidget->x509certComboBox->setCurrentIndex(0);
                }
            }

			if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco) {
				ProfileCertOptionsWidget->x509certComboBox->hide();
				ProfileCertOptionsWidget->CaCertpathComboBox->hide();
				ProfileCertOptionsWidget->x509certComboBox->sizeHint();
				ProfileCertOptionsWidget->sizeHint();
				ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled(false);
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(0,  i18n( "Pre Shared Key" ) );
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(0,  i18n( "Pre Shared Key" ) );
				
				bool hasHybridSupport = getVpncHasHybridSupport();
				if (hasHybridSupport) {
					ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(1, i18n( "Hybrid" ) );
					ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(1, i18n( "Hybrid" ) );
					ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
					ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
					ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl(GlobalConfig->currentProfile->getCaCertificate());
					ProfileCertOptionsWidget->certpathURLRequester->setUrl( GlobalConfig->currentProfile->getCertPath() );
					ProfileCertOptionsWidget->VerifyCaCertCheckBox->setChecked(GlobalConfig->currentProfile->getVerifyCaCert());
					ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
					ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
					if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk) {
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(0); // psk
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(0); // psk
					}
					if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
						ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(1); // hybrid
						ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(1); // hybrid
					}
					GlobalConfig->appendLogEntry ( i18n ( "Hybrid support detected, enabling cert options" ),KVpncEnum::debug );
				} else {
					ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );
					ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );
					ProfileCertOptionsWidget->setEnabled (false);
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(0); // psk
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(0); // psk
					GlobalConfig->appendLogEntry ( i18n ( "Hybrid support not detected, disabling cert options" ),KVpncEnum::debug );
				}
			}
			

            ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->setChecked(GlobalConfig->currentProfile->getUseXauthInteractive());
            ProfileCiscoOptionsWidget->LocalPortCheckbox->setChecked(GlobalConfig->currentProfile->getUseLocalPort());
            ProfileCiscoOptionsWidget->LocalPortSpinbox->setValue(GlobalConfig->currentProfile->getLocalPort());

            int vpnc_version_major = 0;
            int vpnc_version_minor = 2;
            int vpnc_version_subminor = 1;

            ToolInfo *Tool = Utils(GlobalConfig).getToolInfo("vpnc");
            if (!Tool->Version.isEmpty()) {
                vpnc_version_major = (Tool->Version.section('.', 0, 0)).toInt();
                vpnc_version_minor = (Tool->Version.section('.', 1, 1)).toInt();
                vpnc_version_subminor = (Tool->Version.section('.', 2, 2)).toInt();
            }

            if (vpnc_version_major == 0 && vpnc_version_minor < 3) {
                GlobalConfig->appendLogEntry(i18n("vpnc is too old. Minimum requirement is 0.3.x, disabling Xauth interactive option."),
                                             KVpncEnum::error);
                ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco) {
                if ((vpnc_version_major == 0 && vpnc_version_minor >= 5) || (vpnc_version_major > 0)) {
                    ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setEnabled(true);
                    ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setChecked(GlobalConfig->currentProfile->getUseDpdIdleTimeout());
                } else {
                    ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setEnabled(false);
                    ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setChecked(false);
                }

                ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->show();
                ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setWhatsThis(i18n("This enables DPD. Requires vpnc >= 0.5.0."));
            }

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig) {
                ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setChecked(true);
                ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->hide();
                ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->setWhatsThis(i18n("This enables DPD."));
            }

            ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->setValue(GlobalConfig->currentProfile->getDpdIdleTimeout());

            if (GlobalConfig->currentProfile->getUseUdp()) {
                ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(true);
            } else {
                ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(false);
            }

            ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(GlobalConfig->currentProfile->getUdpPort());
            if (GlobalConfig->currentProfile->getUseUdpPort()) {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
            } else {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);
            }

            ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
            if (GlobalConfig->currentProfile->getUseUdp()) {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
            } else {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
            }

            ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);

            ProfilePptpOptionsWidget->setEnabled(false);
            ProfileOpenvpnOptionsWidget->setEnabled(false);
            ProfileCiscoOptionsWidget->setEnabled(true);
            ProfileRacoonOptionsWidget->setEnabled(false);
            ProfileIpsecOptionsWidget->setEnabled(false);
            ProfileSshOptionsWidget->setEnabled(false);

            ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->setValue(GlobalConfig->currentProfile->getPeerTimeout());

            ProfileUserOptionsWidget->NtDomainNameCheckbox->setEnabled(true);
            ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled(false);
            ProfileUserOptionsWidget->NtDomainNameLineedit->setText(GlobalConfig->currentProfile->getNtDomainName());
            if (GlobalConfig->currentProfile->getUseNtDomainName()) {
                ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled(true);
                ProfileUserOptionsWidget->NtDomainNameCheckbox->setChecked(true);
            }

            ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setEnabled(true);
            ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled(false);
            if (GlobalConfig->currentProfile->getUseSearchDomainInResolvConf()) {
                ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled(true);
                ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setChecked(true);
            }
            ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setText(GlobalConfig->currentProfile->getSearchDomainInResolvConf());

            if (GlobalConfig->currentProfile->getUseGlobalIpsecSecret()) {
                ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked(true);
            } else {
                ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked(false);
            }

            ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked(GlobalConfig->currentProfile->getUseGlobalIpsecSecret());

            // FIXME
            // ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("tun0");
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::cisco)) {
                ProfileCiscoOptionsWidget->SingleDesCheckbox->setChecked(false);
                ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled(false);
                ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(false);
                ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(false);
                ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled(false);
				
				int IkeGroupIndex = ProfileCiscoOptionsWidget->IkeGroupCombobox->findText(GlobalConfig->currentProfile->getIkeGroup());
				if (IkeGroupIndex == -1)
					IkeGroupIndex = 0;
                ProfileCiscoOptionsWidget->IkeGroupCombobox->setCurrentIndex(IkeGroupIndex);
                
				int PfsGroupIndex = ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->findText(GlobalConfig->currentProfile->getPerfectForwardSecrety());
				if (PfsGroupIndex == -1)
					PfsGroupIndex = 0;
				ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentIndex(PfsGroupIndex);
                
				
				
				ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setText(GlobalConfig->currentProfile->getApplicationVersion());

                ProfileCiscoOptionsWidget->IkeGroupCheckbox->setEnabled(true);
                ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setEnabled(true);
                ProfileCiscoOptionsWidget->SingleDesCheckbox->setEnabled(true);
                ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->setEnabled(true);

                if (GlobalConfig->currentProfile->getUseSingleDes()) {
                    ProfileCiscoOptionsWidget->SingleDesCheckbox->setChecked(true);
                }

                if (GlobalConfig->currentProfile->getUseIkeGroup()) {
                    ProfileCiscoOptionsWidget->IkeGroupCheckbox->setChecked(true);
                    ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled(true);
                }

                if (GlobalConfig->currentProfile->getUsePerfectForwardSecrety()) {
                    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(true);
                    ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(true);
                } else {
                    ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(false);
                    ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(false);
                }

                if (GlobalConfig->currentProfile->getUseApplicationVersion()) {
                    ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled(true);
                    ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->setChecked(true);
                }
                ProfileCiscoOptionsWidget->DisableDataEncryptionCheckbox->setChecked(GlobalConfig->currentProfile->getDisableDataEncryption());
            } else {
                ProfileCiscoOptionsWidget->SingleDesCheckbox->setEnabled(false);
                ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled(false);
				int IkeGroupIndex = ProfileCiscoOptionsWidget->IkeGroupCombobox->findText(GlobalConfig->currentProfile->getIkeGroup());
				if (IkeGroupIndex == -1)
					IkeGroupIndex = 0;
                ProfileCiscoOptionsWidget->IkeGroupCombobox->setCurrentIndex(IkeGroupIndex);
				
				
                ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(false);
                ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(false);
				
				int PfsGroupIndex = ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->findText(GlobalConfig->currentProfile->getPerfectForwardSecrety());
				if (PfsGroupIndex == -1)
					PfsGroupIndex = 0;
                ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentIndex(PfsGroupIndex);
                
				ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled(false);
                ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setText(GlobalConfig->currentProfile->getApplicationVersion());
            }
        } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon ||
                   GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon ||
                   GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
                   GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::l2tpd_freeswan) {
            ProfileNetworkGeneralOptionsWidget->UseRemoteNetworkCheckBox->setChecked(GlobalConfig->currentProfile->getUseRemoteNetwork());
            ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText(GlobalConfig->currentProfile->getRemoteNetAddr());

            if (!GlobalConfig->currentProfile->getRemoteNetMask().isEmpty()) {
				int RemoteNetmaskIndex = ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->findText(GlobalConfig->currentProfile->getRemoteNetMask());
				if (RemoteNetmaskIndex == -1)
					RemoteNetmaskIndex = 16; // 24
                ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(RemoteNetmaskIndex);
            }

			ProfileCertOptionsWidget->x509certComboBox->hide();
			ProfileCertOptionsWidget->CaCertpathComboBox->hide();

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
                    GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::l2tpd_freeswan) {
                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
                }

                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk) {
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
                }
            }

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon ||
                    GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon) {
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(0, i18n("X.509 Certificate"));
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(1, i18n("Pre Shared Key"));
				ProfileCertOptionsWidget->AuthTypeComboBox->insertItem(2, i18n("Hybrid"));
				
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(0, i18n("X.509 Certificate"));
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(1, i18n("Pre Shared Key"));
				ProfilePskOptionsWidget->AuthTypeComboBox->insertItem(2, i18n("Hybrid"));
				
                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
                }

                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk) {
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
                }

                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
					ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::hybrid);
					ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::hybrid);
                }
                ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText( GlobalConfig->currentProfile->getSpecialRemoteID() );
            }

            ProfileCertOptionsWidget->x509certURLRequester->setUrl(GlobalConfig->currentProfile->getX509Certificate());
            ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl(GlobalConfig->currentProfile->getCaCertificate());
            ProfileCertOptionsWidget->certpathURLRequester->setUrl(GlobalConfig->currentProfile->getCertPath());
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
            ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
            ProfileCertOptionsWidget->privkeypathURLRequester->setUrl(GlobalConfig->currentProfile->getPrivateKey());
            ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(GlobalConfig->currentProfile->getUseSpecialServerCertificate());

            ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked(GlobalConfig->currentProfile->getDoPingIP());
            ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText(GlobalConfig->currentProfile->getPingHostIP());
			
            ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
            ProfilePskOptionsWidget->CheckSavePsk->setChecked(GlobalConfig->currentProfile->getSavePsk());

            ProfileIpsecOptionsWidget->UseRightNextHopCheckBox->setChecked(GlobalConfig->currentProfile->getUseRightNextHop());
            ProfileIpsecOptionsWidget->UseLeftNextHopCheckBox->setChecked(GlobalConfig->currentProfile->getUseLeftNextHop());
            ProfileIpsecOptionsWidget->LeftNextHopLineEdit->setText(GlobalConfig->currentProfile->getLeftNextHop());
            ProfileIpsecOptionsWidget->RightNextHopLineEdit->setText(GlobalConfig->currentProfile->getRightNextHop());
            ProfileIpsecOptionsWidget->DisableOpportunisticEncryptionCheckBox->setChecked(GlobalConfig->currentProfile->getDisableOpportunisticEncryption());
            ProfileRacoonOptionsWidget->LocalIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialLocalID());
            ProfileIpsecOptionsWidget->LocalIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialLocalID());
			ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialRemoteID());
			ProfileIpsecOptionsWidget->RemoteIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialRemoteID());
            // ProfileRacoonOptionsWidget->UseSpecialLocalIDcheckBox->setChecked(GlobalConfig->currentProfile->getUseSpecialLocalID());

            if (GlobalConfig->currentProfile->getIpsecVpnMode() == "transport") {
                ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setCurrentIndex(0); // transport
            } else {
                ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setCurrentIndex(1); // tunnel
            }

            if (GlobalConfig->currentProfile->getLocalIDType() == "") {
                GlobalConfig->currentProfile->setLocalIDType("none");
            }

            if (GlobalConfig->currentProfile->getRemoteIDType() == "")  {
				GlobalConfig->currentProfile->setRemoteIDType("none");
			}

			int LocalIdIndex = ProfileRacoonOptionsWidget->LocalIdTypeCombobox->findText(GlobalConfig->currentProfile->getLocalIDType());
			if (LocalIdIndex == -1)
				LocalIdIndex = 0; // none
			ProfileRacoonOptionsWidget->LocalIdTypeCombobox->setCurrentIndex(LocalIdIndex);
			
			int RemoteIdIndex = ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->findText(GlobalConfig->currentProfile->getRemoteIDType());
			if (RemoteIdIndex == -1)
				RemoteIdIndex = 0; // none
			ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->setCurrentIndex(RemoteIdIndex);
			
			LocalIdIndex = ProfileIpsecOptionsWidget->LocalIdTypeCombobox->findText(GlobalConfig->currentProfile->getLocalIDType());
			if (LocalIdIndex == -1)
				LocalIdIndex = 2; // address
				ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentIndex(LocalIdIndex);
			
			RemoteIdIndex = ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->findText(GlobalConfig->currentProfile->getRemoteIDType());
			if (RemoteIdIndex == -1)
				RemoteIdIndex = 1; // address
				ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->setCurrentIndex(RemoteIdIndex);
			
			ProfileRacoonOptionsWidget->LocalIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialLocalID());
            ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialRemoteID());
			ProfileIpsecOptionsWidget->LocalIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialLocalID());
			ProfileRacoonOptionsWidget->RemoteIDLineEdit->setText(GlobalConfig->currentProfile->getSpecialRemoteID());
			
            ProfileRacoonOptionsWidget->localIDTypeToggled(GlobalConfig->currentProfile->getLocalIDType());
            ProfileRacoonOptionsWidget->remoteIDTypeToggled(GlobalConfig->currentProfile->getRemoteIDType());
            ProfileIpsecOptionsWidget->localIDTypeToggled(GlobalConfig->currentProfile->getLocalIDType());
			ProfileIpsecOptionsWidget->remoteIDTypeToggled(GlobalConfig->currentProfile->getRemoteIDType());

            // TODO made it useable for freeswan
            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
                    GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
                    ProfilePptpOptionsWidget->setEnabled(true);
                } else {
                    ProfilePptpOptionsWidget->setEnabled(false);
                }
                ProfileOpenvpnOptionsWidget->setEnabled(false);
                ProfileCiscoOptionsWidget->setEnabled(false);
                ProfileRacoonOptionsWidget->setEnabled(false);
                ProfileIpsecOptionsWidget->setEnabled(true);
                ProfileSshOptionsWidget->setEnabled(false);

                ProfileIpsecOptionsWidget->UseModeConfigCheckBox->hide();

                ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked(GlobalConfig->currentProfile->getUseSpecialServerCertificate());
                ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setUrl(GlobalConfig->currentProfile->getSpecialServerCertificate());

                if (GlobalConfig->currentProfile->getUseSpecialServerCertificate()) {
                    ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(true);
                } else {
                    ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
                }

                // ike + esp
                if (GlobalConfig->currentProfile->getUseCustomEsp()) {
                    ProfileIpsecOptionsWidget->EspGroupBox->setEnabled(true);
                    ProfileIpsecOptionsWidget->UseCustomEspCheckBox->setChecked(true);
                } else {
                    ProfileIpsecOptionsWidget->EspGroupBox->setEnabled(false);
                    ProfileIpsecOptionsWidget->UseCustomEspCheckBox->setChecked(false);
                }

                if (GlobalConfig->currentProfile->getUseCustomIke()) {
                    ProfileIpsecOptionsWidget->IkeGroupBox->setEnabled(true);
                    ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->setChecked(true);
                } else {
                    ProfileIpsecOptionsWidget->IkeGroupBox->setEnabled(false);
                    ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->setChecked(false);
                }

                QStringList IkeList = GlobalConfig->currentProfile->getIpsecIke().split(",", QString::SkipEmptyParts);
                QStringList EspList = GlobalConfig->currentProfile->getIpsecEsp().split(",", QString::SkipEmptyParts);
                QString IkeOther = "";
                QString EspOther = "";

                for (QStringList::Iterator ikeit = IkeList.begin(); ikeit != IkeList.end(); ++ikeit) {
                    if (*ikeit == "aes256-sha1") {
                        ProfileIpsecOptionsWidget->IkeAes256Sha1CheckBox->setChecked(true);
                    } else if (*ikeit == "aes128-sha1") {
                        ProfileIpsecOptionsWidget->IkeAes128Sha1CheckBox->setChecked(true);
                    } else if (*ikeit == "3des-sha1-modp2048") {
                        ProfileIpsecOptionsWidget->IkeDesSha1Modp2048CheckBox->setChecked(true);
                    } else if (*ikeit == "3des-md5") {
                        ProfileIpsecOptionsWidget->IkeDesMd5CheckBox->setChecked(true);
                    } else if (*ikeit == "3des-sha1") {
                        ProfileIpsecOptionsWidget->IkeDesSha1CheckBox->setChecked(true);
                    } else {
                        if (!IkeOther.isEmpty()) {
                            IkeOther += ",";
                        }

                        IkeOther += *ikeit;
                    }
                }

                if (!IkeOther.isEmpty()) {
                    ProfileIpsecOptionsWidget->OtherIkeLineEdit->setText(IkeOther);
                }

                for (QStringList::Iterator espit = EspList.begin(); espit != EspList.end(); ++espit) {
                    if (*espit == "3des-md5") {
                        ProfileIpsecOptionsWidget->Esp3desMd5CheckBox->setChecked(true);
                    } else if (*espit == "3des-sha1") {
                        ProfileIpsecOptionsWidget->EspDesSha1CheckBox->setChecked(true);
                    } else if (*espit == "aes128-sha1") {
                        ProfileIpsecOptionsWidget->EspAes128Sha1CheckBox->setChecked(true);
                    } else if (*espit == "aes256-sha1") {
                        ProfileIpsecOptionsWidget->EspAes256Sha1CheckBox->setChecked(true);
                    } else {
                        if (!EspOther.isEmpty()) {
                            EspOther += ",";
                        }

                        EspOther += *espit;
                    }
                }

                if (!EspOther.isEmpty()) {
                    ProfileIpsecOptionsWidget->OtherEspLineEdit->setText(EspOther);
                }

#if 0
                IkeAes256Sha1CheckBox->setText(tr2i18n("aes256-sha1"));
                IkeAes128Sha1CheckBox->setText(tr2i18n("aes128-sha1"));
                IkeDesSha1Modp2048CheckBox->setText(tr2i18n("3des-sha1-modp2048"));
                IkeDesMd5CheckBox->setText(tr2i18n("3des-md5"));
                IkeDesSha1CheckBox->setText(tr2i18n("3des-sha1"));

                Esp3desMd5CheckBox->setText(tr2i18n("3des-md5"));
                EspDesSha1CheckBox->setText(tr2i18n("3des-sha1"));
                EspAes128Sha1CheckBox->setText(tr2i18n("aes128-sha1"));
                EspAes256Sha1CheckBox->setText(tr2i18n("aes256-sha1"));
#endif


				int LocalIdIndex = ProfileIpsecOptionsWidget->LocalIdTypeCombobox->findText(GlobalConfig->currentProfile->getLocalIDType());
				if (LocalIdIndex == -1)
					LocalIdIndex = 2; // address
					ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentIndex(LocalIdIndex);

				int RemoteIdIndex = ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->findText(GlobalConfig->currentProfile->getRemoteIDType());
				if (RemoteIdIndex == -1)
					RemoteIdIndex = 1; // address
					ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->setCurrentIndex(RemoteIdIndex);

                ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(true);
                ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(true);
                ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(true);

                ToolInfo *tool = Utils(GlobalConfig).getToolInfo("ipsec");
                QString realversion = tool->Version.section(' ', 1, 1).section('/', 0, 0).right(tool->Version.section(' ', 1, 1).section('/', 0, 0).length() - 1);
                QString realtype = tool->Version.section(' ', 0, 0).toLower();

                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
                    ProfileUserOptionsWidget->setEnabled(true);
                } else {
                    ProfileUserOptionsWidget->setEnabled(false);
                }

                ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled(true);
                ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled(true);

                if (GlobalConfig->currentProfile->getUseMtu()) {
                    ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(true);
                } else {
                    ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(false);
                }

                if (GlobalConfig->currentProfile->getUseMru()) {
                    ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(true);
                } else {
                    ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(false);
                }

                ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled(true);

                ProfileIpsecOptionsWidget->LocalIdentifierGroupBox->setEnabled(true);

                ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox->setText(i18n("Enable Perfect for&ward secrecy (PFS)"));
                ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(GlobalConfig->currentProfile->getUsePerfectForwardSecrety());
				if (GlobalConfig->currentProfile->getPerfectForwardSecrety().isEmpty()) {
					GlobalConfig->currentProfile->setPerfectForwardSecrety("dh1024"); // dh group 2
				}
				int PfsGroupIndex =  ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->findText(GlobalConfig->currentProfile->getPerfectForwardSecrety());
				if (PfsGroupIndex == -1)
					PfsGroupIndex = 1; // 1024 (dh group 2)
				ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentIndex(PfsGroupIndex);

                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
                    ProfilePptpOptionsWidget->setEnabled(true);
                    ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setCurrentIndex(0); // transport
                    ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setEnabled(false);
                } else {
                    ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->setEnabled(true);
                    ProfilePptpOptionsWidget->setEnabled(false);
                    if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
                        ProfileUserOptionsWidget->setEnabled(true);
                    } else {
                        ProfileUserOptionsWidget->setEnabled(false);
                    }

                }

                ToolInfo *IpsecToolInfo = Utils(GlobalConfig).getToolInfo("ipsec");
                QString IpsecType;

                if (IpsecToolInfo->Version.contains(QString("Openswan"), Qt::CaseInsensitive)) {
                    ProfileIpsecOptionsWidget->ExchangeModeComboBox->setEnabled(true);
#if 0
                    if (GlobalConfig->currentProfile->getExchangeMode() == "main") {
                        ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentIndex(0);
                    }
                    if (GlobalConfig->currentProfile->getExchangeMode() == "aggressive") {
                        ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentIndex(1);
                    }
                    if (GlobalConfig->currentProfile->getExchangeMode() == "base") {
                        ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentIndex(2);
                    }
#endif
					int ExchangeModeIndex = ProfileIpsecOptionsWidget->ExchangeModeComboBox->findText(GlobalConfig->currentProfile->getExchangeMode());
					if (ExchangeModeIndex == -1)
						ExchangeModeIndex = 0;
                    ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentIndex(ExchangeModeIndex);
                }
                else if (IpsecToolInfo->Version.contains(QString("strongSwan"), Qt::CaseInsensitive)) {
                    // no aggressive mode :(
                    ProfileIpsecOptionsWidget->ExchangeModeComboBox->setEnabled(false);
                    ProfileIpsecOptionsWidget->ExchangeModeComboBox->setCurrentIndex(0); // main
                }

                // xauth
                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan &&
                        GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk) {
                    if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
                        ProfileIpsecOptionsWidget->UseXauthCheckBox->setChecked(true);
                        // ProfilePskOptionsWidget->setEnabled(true);
                        if (GlobalConfig->currentProfile->getPskIsInFile()) {
                            QFile PskFile(GlobalConfig->currentProfile->getPreSharedKeyFile());
                            QString Psk = "";
                            if (PskFile.exists()) {
                                Psk = QString(PskFile.readAll());
                            }
                            ProfilePskOptionsWidget->PSKLineEdit->setText(Psk);
                        } else {
                            ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
                        }
                        if (GlobalConfig->currentProfile->getSavePsk() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty()) {
                            ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);
                        }  else {
                            ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);
                        }
                    } else {
                        ProfileIpsecOptionsWidget->UseXauthCheckBox->setChecked(false);
                        // ProfilePskOptionsWidget->setEnabled(false);
                    }
                }

                ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);

                // temporary
                ProfileNetworkVirtualIpOptionsWidget->VirtualIpGroupBox->setEnabled(true);
                ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());

                ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();
                ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->setChecked(GlobalConfig->currentProfile->getUseLeftSourceIp());
                ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->setChecked(GlobalConfig->currentProfile->getUseRightSourceIp());
                ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->setText(GlobalConfig->currentProfile->getLeftSourceIp());
                ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->setText(GlobalConfig->currentProfile->getRightSourceIp());

                ProfileNetworkVirtualIpOptionsWidget->UseVirtualSubnetsCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualSubnetworks());
                ProfileNetworkVirtualIpOptionsWidget->VirtualSubnetsLineEdit->setText(GlobalConfig->currentProfile->getVirtualSubnetworks());
            } else {
                // racoon
                ProfileRacoonOptionsWidget->setEnabled(true);
                ProfileIpsecOptionsWidget->setEnabled(false);

                ProfileRacoonOptionsWidget->HashAlgoComboBox->setEnabled(true);
                ProfileRacoonOptionsWidget->HashAlgoTextLabel->setEnabled(true);
                ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setEnabled(true);
                ProfileRacoonOptionsWidget->ExchangeModeComboBox->setEnabled(true);
                ProfileRacoonOptionsWidget->LocalIdentifierGroupBox->setEnabled(true);
                ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setEnabled(false);
                ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setChecked(false);

                ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->setText(i18n("Perfect for&ward secrecy (PFS):"));
                ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->show();
				
				ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();
				ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->setChecked( GlobalConfig->currentProfile->getUseLeftSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->setChecked(GlobalConfig->currentProfile->getUseRightSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->setText(GlobalConfig->currentProfile->getLeftSourceIp());
				ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->setText(GlobalConfig->currentProfile->getRightSourceIp());	

                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon) {
                    ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(true);
                    ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(true);
                    ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(true);
                    ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled(true);
                }

                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
                    ProfileUserOptionsWidget->setEnabled(true);

                    ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
                    ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
                    ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);
                    ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
                    ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled(false);

                    ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled(true);
                    ProfileNetworkGeneralOptionsWidget->MruCheckbox->setEnabled(true);

                    if (GlobalConfig->currentProfile->getUseMtu()) {
                        ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(true);
                    } else {
                        ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled(false);
                    }

                    if (GlobalConfig->currentProfile->getUseMru()) {
                        ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(true);
                    } else {
                        ProfileNetworkGeneralOptionsWidget->MruSpinbox->setEnabled(false);
                    }
                }
#if 0
                else {
                    profilenetworkgeneraloptionswidget->mtucheckbox->setenabled(false);
                    profilenetworkgeneraloptionswidget->mrucheckbox->setenabled(false);
                }
#endif

                ProfileRacoonOptionsWidget->IkeGroupCheckbox->setChecked(false);
                ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(false);
                if (!GlobalConfig->currentProfile->getIkeGroup().isEmpty()) {
					int DhGroupIndex = ProfileRacoonOptionsWidget->DHGroupComboBox->findText(GlobalConfig->currentProfile->getIkeGroup());
					if (DhGroupIndex == -1)
						DhGroupIndex = 0;
                    ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentIndex(DhGroupIndex);
                } else {
                    ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentIndex(0);
                }

                if (!GlobalConfig->currentProfile->getPerfectForwardSecrety().isEmpty()) {
					int PfsGroupIndex = ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->findText(GlobalConfig->currentProfile->getPerfectForwardSecrety());
					if (PfsGroupIndex == -1)
						PfsGroupIndex = 0;
                    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentIndex(PfsGroupIndex);
				} else {
                    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setCurrentIndex(0);
				}

                if (GlobalConfig->currentProfile->getUseIkeGroup()) {
                    ProfileRacoonOptionsWidget->IkeGroupCheckbox->setChecked(true);
                }

                if (GlobalConfig->currentProfile->getUsePerfectForwardSecrety()) {
                    ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(true);
                    ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->setChecked(true);
                }

                if (GlobalConfig->currentProfile->getUseIkeGroup()) {
                    ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled(true);
                }

                // xauth
                if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon &&
                        (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk ||
                         GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid)) {
                    if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
                        ProfileRacoonOptionsWidget->UseXauthCheckBox->setChecked(true);
                        // ProfilePskOptionsWidget->setEnabled(true);
                        if (GlobalConfig->currentProfile->getPskIsInFile()) {
                            QFile PskFile(GlobalConfig->currentProfile->getPreSharedKeyFile());
                            QString Psk = "";
                            if (PskFile.exists()) {
                                Psk = QString(PskFile.readAll());
                            }
                            ProfilePskOptionsWidget->PSKLineEdit->setText(Psk);
                        } else {
                            ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
                        }
                        if (GlobalConfig->currentProfile->getSavePsk() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty()) {
                            ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);
                        } else {
                            ProfilePskOptionsWidget->CheckSavePsk->setChecked(true);
                        }
                    } else {
                        ProfileIpsecOptionsWidget->UseXauthCheckBox->setChecked(false);
                        // ProfilePskOptionsWidget->setEnabled(false);
                    }
                }

                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
                    ProfileCertOptionsWidget->setEnabled(true);
                    ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
                    ProfilePskOptionsWidget->setEnabled(false);
                }

                if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
                    ProfileCertOptionsWidget->x509certURLRequester->setUrl(GlobalConfig->currentProfile->getX509Certificate());
                }
            } // racoon

            // FIXME
            // ProfileNetworkRouteOptionsWidget->main->InterfaceComboBox->insertItem("ppp0");

            // FIXME
            // ProfileNetworkRouteOptionsWidget->main->InterfaceComboBox->insertItem("tun0");
            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();
        }

			if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon ||
					GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
				if (GlobalConfig->currentProfile->getAuthMethod() == "chap") {
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::chap);
					if (GlobalConfig->KvpncDebugLevel > 5)
						GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::chap), KVpncEnum::debug);
				}
				if (GlobalConfig->currentProfile->getAuthMethod() == "pap") {
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::pap);
					if (GlobalConfig->KvpncDebugLevel > 5)
						GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::pap), KVpncEnum::debug);
				}
				if (GlobalConfig->currentProfile->getAuthMethod() == "mschap") {
					ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::mschap);
					if (GlobalConfig->KvpncDebugLevel > 5)
						GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::mschap), KVpncEnum::debug);
			}
			if (GlobalConfig->currentProfile->getAuthMethod() == "mschap_v2") {
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::mschap_v2);
				if (GlobalConfig->KvpncDebugLevel > 5)
					GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::mschap_v2), KVpncEnum::debug);
			}
        }

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
            ProfilePptpOptionsWidget->setEnabled(false);
            ProfileOpenvpnOptionsWidget->setEnabled(false);
            ProfileCiscoOptionsWidget->setEnabled(false);
            ProfileRacoonOptionsWidget->setEnabled(true);
            ProfileSshOptionsWidget->setEnabled(false);
			ProfileNetworkHttpProxyOptionsWidget->setEnabled( false );
			

		if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
			ProfilePptpOptionsWidget->setEnabled( true );
			ProfileUserOptionsWidget->setEnabled( true );
		} else {
			if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
				ProfilePptpOptionsWidget->setEnabled( true );
				ProfileUserOptionsWidget->setEnabled( true );
			} else {
				ProfilePptpOptionsWidget->setEnabled( false );
				ProfileUserOptionsWidget->setEnabled( false );
			}
		}
		
#if 0
            ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->clear();
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->clear();

            QStringList KernelCrypto = Utils(GlobalConfig).getKernelCrypto();
            int kernelCryptoIdx = 0;
            for (QStringList::Iterator it = KernelCrypto.begin(); it != KernelCrypto.end(); ++it) {
                ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(kernelCryptoIdx, String(*it));
                kernelCryptoIdx++;
            }

            // FIXME why this is not in kernel crypto list???
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(0, "3des");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(1, "des");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(2, "des_iv64");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(3, "des_iv32");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(4, "rc5");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(5, "rc4");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(6, "idea");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(7, "3idea");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(8, "cast128");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(9, "blowfish");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(10, "null_enc");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(11, "twofish");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(12, "rijndael");
            // ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->insertItem(13, "aes");

            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(0, "des");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(1, "3des");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(2, "des_iv64");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(3, "des_iv32");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(4, "hmac_md5");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(5, "hmac_sha1");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(6, "hmac_sha256");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(7, "hmac_sha384");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(8, "hmac_sha512");
            ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->insertItem(9, "non_auth");

            if (it->getHashAlgo() == "sha1") {
                ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentIndex(1); // sha1
            }
            if (it->getHashAlgo() == "md5") {
                ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentIndex(0); // md5
            }
#endif
			int HashAlgoIndex = ProfileRacoonOptionsWidget->HashAlgoComboBox->findText(GlobalConfig->currentProfile->getHashAlgo());
			if (HashAlgoIndex == -1)
				HashAlgoIndex = 0;

            ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentIndex(0);

			
			int DhGroupIndex = ProfileRacoonOptionsWidget->DHGroupComboBox->findText(GlobalConfig->currentProfile->getIkeGroup());
			if (DhGroupIndex == -1)
				DhGroupIndex = 0;
            ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentIndex(DhGroupIndex);
			
            if (!GlobalConfig->currentProfile->getEncryptionAlgorithm().isEmpty()) {
				int EncryptionAlgo2Index = ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->findText(GlobalConfig->currentProfile->getEncryptionAlgorithm());
				if (EncryptionAlgo2Index == -1)
					EncryptionAlgo2Index = 0;
                ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->setCurrentIndex(EncryptionAlgo2Index);
			} else {
				ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->setCurrentIndex(0); // FIXME set useful algo
			}
			
			if (!GlobalConfig->currentProfile->getAuthenticationAlgorithm().isEmpty()) {
				int AuthenticationAlgo2Index = ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->findText(GlobalConfig->currentProfile->getAuthenticationAlgorithm());
				if (AuthenticationAlgo2Index == -1)
					AuthenticationAlgo2Index = 0;
				ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->setCurrentIndex(AuthenticationAlgo2Index);
			} else {
				ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->setCurrentIndex(0); // FIXME set useful algo
			}

            if (!GlobalConfig->currentProfile->getIpsecIke().isEmpty()) {
				int EncryptionAlgoIndex = ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->findText(GlobalConfig->currentProfile->getIpsecIke());
				if (EncryptionAlgoIndex == -1)
					EncryptionAlgoIndex = 0;
				ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->setCurrentIndex(EncryptionAlgoIndex);
            } else {
				ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->setCurrentIndex(0); // FIXME set useful algo
			}

			int ExchangeModeIndex = ProfileRacoonOptionsWidget->ExchangeModeComboBox->findText(GlobalConfig->currentProfile->getExchangeMode());
			if (ExchangeModeIndex == -1)
				ExchangeModeIndex = 0;
            ProfileRacoonOptionsWidget->ExchangeModeComboBox->setCurrentIndex(ExchangeModeIndex);
			
            ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setChecked(GlobalConfig->currentProfile->getUseModeConfig());

            ProfileCertOptionsWidget->VerifyCaCertCheckBox->setEnabled(true);
            ProfileCertOptionsWidget->VerifyCaCertCheckBox->setChecked(GlobalConfig->currentProfile->getVerifyCaCert());
			
			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->show();
			ProfileNetworkVirtualIpOptionsWidget->VirtualIpGroupBox->setEnabled(false);
			// 			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );
			// 
			// 			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );
			// 			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );
			// 			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(it->getUseVirtualIP());
			// 
			// 			if (it->getUseVirtualIP())
			// 			{
			// 				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
			// 				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
			// 			}
			// 			else
			// 			{
			// 				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
			// 				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
			// 			}
			
			
			
            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
                ProfileCertOptionsWidget->setEnabled(true);
                ProfileCertOptionsWidget->x509certComboBox->setEnabled(false);
                ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
                ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled(true);
                ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl(GlobalConfig->currentProfile->getCaCertificate());
				ProfileCertOptionsWidget->certpathURLRequester->setUrl( GlobalConfig->currentProfile->getCertPath() );
                ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
                ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
                ProfileCertOptionsWidget->LabelPrivateKeyPassword->setEnabled(false);
                ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
                ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
                ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
                ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setEnabled(false);
                ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
                ProfilePskOptionsWidget->setEnabled(false);
            }
        } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp)) {
            ProfilePskOptionsWidget->CheckSavePsk->setChecked(GlobalConfig->currentProfile->getSavePsk());
            ProfileUserOptionsWidget->CheckUserPass->setChecked(GlobalConfig->currentProfile->getSaveUserPassword());
            ProfileUserOptionsWidget->UsernameLineEdit->setText(GlobalConfig->currentProfile->getUserName());
            ProfileUserOptionsWidget->PasswordEdit->setText(GlobalConfig->currentProfile->getUserPassword());
            ProfileUserOptionsWidget->DontSaveUsernameCheckBox->setChecked(GlobalConfig->currentProfile->getDontSaveUsername());


            if (!GlobalConfig->currentProfile->getRemoteNetAddr().isEmpty() && !GlobalConfig->currentProfile->getRemoteNetMask().isEmpty()) {
                ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText(GlobalConfig->currentProfile->getRemoteNetAddr());
                if (!GlobalConfig->currentProfile->getRemoteNetMask().isEmpty()) {
					int RemoteNetmaskIndex = ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->findText(GlobalConfig->currentProfile->getRemoteNetMask());
					if (RemoteNetmaskIndex == -1)
						RemoteNetmaskIndex = 16; //24
                    ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(RemoteNetmaskIndex);
                } else {
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(16); // 24 
				}
            }

            ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked(GlobalConfig->currentProfile->getRequireMppe());
            ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked(GlobalConfig->currentProfile->getRefuse128BitEncryption());
            ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked(GlobalConfig->currentProfile->getRefuse40BitEncryption());
            ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked(GlobalConfig->currentProfile->getDisableMPPEComp());
            ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked(GlobalConfig->currentProfile->getUseDnsServer());
            ProfilePptpOptionsWidget->DnsServerLineedit->setText(GlobalConfig->currentProfile->getDnsServer());
            ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked(GlobalConfig->currentProfile->getUseNoBsdComp());
            ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked(GlobalConfig->currentProfile->getUseNoDeflate());
            ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked(GlobalConfig->currentProfile->getAllowStatefulMode());
            ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->setChecked(GlobalConfig->currentProfile->getUseNoIpDefault());
            ProfilePptpOptionsWidget->DisableCcpCheckbox->setChecked(GlobalConfig->currentProfile->getDisableCcp());
            ProfilePptpOptionsWidget->DisableHeaderCompressionCheckbox->setChecked(GlobalConfig->currentProfile->getDisableHeaderCompression());
            ProfilePptpOptionsWidget->DisableMagicNumberNegotiationCheckbox->setChecked(GlobalConfig->currentProfile->getDisableMagicNumberNegotiation());
            ProfilePptpOptionsWidget->DisableIpxCheckbox->setChecked(GlobalConfig->currentProfile->getDisableIpx());
            ProfilePptpOptionsWidget->DisableAddressControlCompressionCheckbox->setChecked(GlobalConfig->currentProfile->getDisableAddressControlCompression());
            ProfilePptpOptionsWidget->DisableProtocolFieldCompressionCheckbox->setChecked(GlobalConfig->currentProfile->getDisableProtocolFieldCompression());
            ProfilePptpOptionsWidget->RequireEapCheckbox->setChecked(GlobalConfig->currentProfile->getRequireEap());

            ProfileUserOptionsWidget->NtDomainNameCheckbox->setEnabled(true);
            ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled(false);
            ProfileUserOptionsWidget->NtDomainNameLineedit->setText(GlobalConfig->currentProfile->getNtDomainName());
            if (GlobalConfig->currentProfile->getUseNtDomainName()) {
                ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled(true);
                ProfileUserOptionsWidget->NtDomainNameCheckbox->setChecked(true);
            }

            ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setEnabled(true);
            ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled(false);
            ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setText(GlobalConfig->currentProfile->getSearchDomainInResolvConf());
            if (GlobalConfig->currentProfile->getUseSearchDomainInResolvConf()) {
                ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->setEnabled(true);
                ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->setChecked(true);
            }

            ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(false);
            ProfileCiscoOptionsWidget->LabelID->setEnabled(false);

            ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);
            ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled(false);
            ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled(false);

            ProfilePptpOptionsWidget->setEnabled(true);
            ProfileOpenvpnOptionsWidget->setEnabled(false);
            ProfileCiscoOptionsWidget->setEnabled(false);
            ProfileRacoonOptionsWidget->setEnabled(false);
            ProfileIpsecOptionsWidget->setEnabled(false);
            ProfileSshOptionsWidget->setEnabled(false);
			
			
            if (GlobalConfig->currentProfile->getAuthMethod() == "chap") {
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::chap);
				if (GlobalConfig->KvpncDebugLevel > 5)
					GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::chap), KVpncEnum::debug);
            }
            if (GlobalConfig->currentProfile->getAuthMethod() == "pap") {
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::pap);
				if (GlobalConfig->KvpncDebugLevel > 5)
					GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::pap), KVpncEnum::debug);
            }
            if (GlobalConfig->currentProfile->getAuthMethod() == "mschap") {
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::mschap);
				if (GlobalConfig->KvpncDebugLevel > 5)
					GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::mschap), KVpncEnum::debug);
            }
            if (GlobalConfig->currentProfile->getAuthMethod() == "mschap_v2") {
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentIndex(VpnAccountData::mschap_v2);
				if (GlobalConfig->KvpncDebugLevel > 5)
					GlobalConfig->appendLogEntry("PreferencesDialog::profileChanged() authMethodIndex: "+QString().setNum(VpnAccountData::mschap_v2), KVpncEnum::debug);
            }

            // FIXME
            // ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("ppp0");

            ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);

            ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());

            if (GlobalConfig->currentProfile->getUseVirtualIP()) {
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
            } else {
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
            }
            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();

        } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn)) {
			if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk)
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::psk);
			else
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentIndex(VpnAccountData::cert);
			
			ProfileCertOptionsWidget->x509certComboBox->hide();
			ProfileCertOptionsWidget->CaCertpathComboBox->hide();
			
            ProfileCertOptionsWidget->x509certURLRequester->setUrl(GlobalConfig->currentProfile->getX509Certificate());
            ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl(GlobalConfig->currentProfile->getCaCertificate());
            ProfileCertOptionsWidget->certpathURLRequester->setUrl(GlobalConfig->currentProfile->getCertPath());
            ProfileCertOptionsWidget->x509certURLRequester->setUrl(GlobalConfig->currentProfile->getX509Certificate());
            ProfileCertOptionsWidget->CaCertpathURLRequester->setUrl(GlobalConfig->currentProfile->getCaCertificate());
            ProfileCertOptionsWidget->certpathURLRequester->setUrl(GlobalConfig->currentProfile->getCertPath());
            ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText(GlobalConfig->currentProfile->getPrivateKeyPass());
            ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getSavePrivateKeyPassword());
            ProfileCertOptionsWidget->privkeypathURLRequester->setUrl(GlobalConfig->currentProfile->getPrivateKey());
            ProfilePskOptionsWidget->PSKLineEdit->setText(GlobalConfig->currentProfile->getPreSharedKey());
            ProfilePskOptionsWidget->PskInFileCheckBox->setChecked(GlobalConfig->currentProfile->getPskIsInFile());
            ProfilePskOptionsWidget->CheckSavePsk->setChecked(GlobalConfig->currentProfile->getSavePsk());

            ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());

            if (GlobalConfig->currentProfile->getUseVirtualIP()) {
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
                tunnelDeviceTypeChanged(GlobalConfig->currentProfile->getTunnelDeviceType());
            } else {
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
            }
            // ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText(GlobalConfig->currentProfile->getRemoteNetAddr());

// if (!GlobalConfig->currentProfile->getRemoteNetMask().isEmpty()) {
// 				if (!GlobalConfig->currentProfile->getRemoteNetMask().isEmpty()) {
// 					int RemoteNetmaskIndex = ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->findText(GlobalConfig->currentProfile->getRemoteNetMask());
// 					if (RemoteNetmaskIndex == -1)
// 						RemoteNetmaskIndex = 16; //24
// 						ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(RemoteNetmaskIndex);
// 				} else {
// 					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(16); // 24 
// 				}
            // }

            if (GlobalConfig->currentProfile->getUseUdp()) {
                ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(true);
            } else {
                ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(false);
            }

            ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(GlobalConfig->currentProfile->getUdpPort());
            if (GlobalConfig->currentProfile->getUseUdpPort()) {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
            } else {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);
            }

            ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
            if (GlobalConfig->currentProfile->getUseUdp()) {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
            } else {
                ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
            }

            ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
            ProfilePptpOptionsWidget->setEnabled(false);
            ProfileOpenvpnOptionsWidget->setEnabled(true);
            ProfileCiscoOptionsWidget->setEnabled(false);
            ProfileRacoonOptionsWidget->setEnabled(false);
            ProfileIpsecOptionsWidget->setEnabled(false);
            ProfileSshOptionsWidget->setEnabled(false);
			ProfileNetworkHttpProxyOptionsWidget->setEnabled( true );

            if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
                ProfileUserOptionsWidget->setEnabled(true);
            } else {
                ProfileUserOptionsWidget->setEnabled(false);
            }

            // ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
            // ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);

            if (GlobalConfig->currentProfile->getUseUserdefinedPort()) {
                ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(true);
                ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(true);
            } else {
                ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);
                ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert) {
                ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled(true);
                ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setEnabled(true);
            } else {
                ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled(false);
                ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getUseNsCertType()) {
                ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(true);
                ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(true);

                if (GlobalConfig->currentProfile->getNsCertType() == "client") {
                    ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentIndex(0); // client
                } else {
                    ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentIndex(1); // server
                }
            } else {
                ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(false);
                ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(false);
            }
            ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());

            if (GlobalConfig->currentProfile->getDisableLzoCompression()) {
                ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(true);
            } else {
                ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(false);
            }

            ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());

            if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
                ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked(true);
            } else {
                ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked(false);
            }

            if (GlobalConfig->currentProfile->getUseTlsRemoteHost()) {
                ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked(true);
                ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setEnabled(true);
            } else {
                ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked(false);
                ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getUseTlsAuth()) {
                ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked(true);
                ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setEnabled(true);
            } else {
                ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked(false);
                ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setEnabled(false);
            }

            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);

            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());

            if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn) {
                ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
            } else {
                ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);

                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());
            }

            ProfilePskOptionsWidget->CheckSavePsk->setChecked(GlobalConfig->currentProfile->getSavePsk());
            ProfileUserOptionsWidget->CheckUserPass->setChecked(GlobalConfig->currentProfile->getSaveUserPassword());
            ProfileUserOptionsWidget->UsernameLineEdit->setText(GlobalConfig->currentProfile->getUserName());
            ProfileUserOptionsWidget->PasswordEdit->setText(GlobalConfig->currentProfile->getUserPassword());
            ProfileUserOptionsWidget->DontSaveUsernameCheckBox->setChecked(GlobalConfig->currentProfile->getDontSaveUsername());

            ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setUrl(GlobalConfig->currentProfile->getTlsAuthFile());
            ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setText(GlobalConfig->currentProfile->getTlsRemoteHost());

            ProfileOpenvpnOptionsWidget->UseUserdefinedRemotePortCheckBox->setChecked(GlobalConfig->currentProfile->getUseRemotePort());
            ProfileOpenvpnOptionsWidget->UserdefinedRemotePortSpinBox->setValue(GlobalConfig->currentProfile->getRemotePort());

            ProfileOpenvpnOptionsWidget->UserdefinedFragmentSizeSpinBox->setValue(GlobalConfig->currentProfile->getFragment());

            ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->setChecked(GlobalConfig->currentProfile->getUseFragment());

            ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setChecked(GlobalConfig->currentProfile->getUseHttpProxy());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->setText(GlobalConfig->currentProfile->getHttpProxy());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->setValue(GlobalConfig->currentProfile->getHttpProxyTimeout());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->setValue(GlobalConfig->currentProfile->getHttpProxyPort());

            if (GlobalConfig->currentProfile->getHttpProxyAuthType() == "basic") {
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentIndex(KVpncEnum::basic);
            } else if (GlobalConfig->currentProfile->getHttpProxyAuthType() == "ntlm") {
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentIndex(KVpncEnum::ntlm);
            } else {
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentIndex(KVpncEnum::basic);
            }

            ProfileNetworkHttpProxyOptionsWidget->useHttpProxyToggeled(GlobalConfig->currentProfile->getUseHttpProxy());

            ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setText(GlobalConfig->currentProfile->getHttpProxyUser());
            ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setText(GlobalConfig->currentProfile->getHttpProxyPass());

            ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->setChecked(GlobalConfig->currentProfile->getUseHttpProxyAuth());

            if (GlobalConfig->currentProfile->getUseHttpProxyAuth()) {
                ProfileNetworkHttpProxyOptionsWidget->HttpProxyGroupBox->setEnabled(true);
            } else {
                ProfileNetworkHttpProxyOptionsWidget->HttpProxyGroupBox->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getUseOnlyCaCertAndUserAuth()) {
                ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->setChecked(true);
            } else {
                ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->setChecked(false);
            }

			int AuthAlgoIndex = ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->findText(GlobalConfig->currentProfile->getAuthenticationAlgorithm());
			if (AuthAlgoIndex == -1)
				AuthAlgoIndex = 0;
            ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->setCurrentIndex(AuthAlgoIndex);
            ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->setEnabled(GlobalConfig->currentProfile->getUseAuthenticationAlgorithm());
            ProfileOpenvpnOptionsWidget->UseAuthenticationAlgorithmCheckBox->setChecked(GlobalConfig->currentProfile->getUseAuthenticationAlgorithm());

            ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled(true);

            // FIXME
            // ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("tun0");
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);

            if (GlobalConfig->currentProfile->getAuthenticationDirection() == QString("none")) {
                ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->setCurrentIndex(0); // none
            }
            if (GlobalConfig->currentProfile->getAuthenticationDirection() == QString("0")) {
                ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->setCurrentIndex(1); // 0
            }
            if (GlobalConfig->currentProfile->getAuthenticationDirection() == QString("1")) {
                ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->setCurrentIndex(2); // 1
            }

            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();

            if (GlobalConfig->currentProfile->getUseRenegSec()) {
                ProfileOpenvpnOptionsWidget->RenegSecCheckBox->setChecked(true);
            } else {
                ProfileOpenvpnOptionsWidget->RenegSecCheckBox->setChecked(false);
            }

            ProfileOpenvpnOptionsWidget->RenegSecSpinBox->setValue(GlobalConfig->currentProfile->getRenegSec());

            if (GlobalConfig->currentProfile->getUseTunnelPing()) {
                ProfileOpenvpnOptionsWidget->TunnelPingCheckBox->setChecked(true);
                ProfileOpenvpnOptionsWidget->TunnelPingSpinBox->setValue(GlobalConfig->currentProfile->getTunnelPing());
            }

            if (GlobalConfig->currentProfile->getUseTunnelPingRestart()) {
                ProfileOpenvpnOptionsWidget->TunnelPingRestartCheckBox->setChecked(true);
            } else {
                ProfileOpenvpnOptionsWidget->TunnelPingRestartCheckBox->setChecked(false);
            }

            ProfileOpenvpnOptionsWidget->TunnelPingRestartSpinBox->setValue(GlobalConfig->currentProfile->getTunnelPingRestart());

            ProfileOpenvpnOptionsWidget->DisableSocketBindCheckBox->setChecked(GlobalConfig->currentProfile->getDisableBind());
        } // openvpn

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun) {
            ProfileVtunOptionsWidget->setEnabled(true);

            ProfileVtunOptionsWidget->PortCheckbox->setChecked(GlobalConfig->currentProfile->getUseLocalPort());
            ProfileVtunOptionsWidget->PortSpinbox->setValue(GlobalConfig->currentProfile->getLocalPort());

            ProfileVtunOptionsWidget->VtunProfileLineEdit->setText(GlobalConfig->currentProfile->getVtunProfile());

            ProfileUserOptionsWidget->UsernameLineEdit->setEnabled(false);

            ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());

            ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());

            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();
        } // vtun
        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
            ProfileVtunOptionsWidget->setEnabled(true);

            ProfileVtunOptionsWidget->PortCheckbox->setChecked(GlobalConfig->currentProfile->getUseLocalPort());
            ProfileVtunOptionsWidget->PortSpinbox->setValue(GlobalConfig->currentProfile->getLocalPort());
            ProfileUserOptionsWidget->UsernameLineEdit->setEnabled(true);
            ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
			ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());

            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
            ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);

            ProfileCertOptionsWidget->setEnabled(false);
            ProfileCiscoOptionsWidget->setEnabled(false);
            ProfileIpsecOptionsWidget->setEnabled(false);
            ProfileRacoonOptionsWidget->setEnabled(false);
            ProfileOpenvpnOptionsWidget->setEnabled(false);
            ProfilePptpOptionsWidget->setEnabled(false);
            ProfileVtunOptionsWidget->setEnabled(false);
            ProfileSshOptionsWidget->setEnabled(true);

            ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->hide();

            ProfileSshOptionsWidget->UseUserdefinedRemotePortCheckBox->setChecked(GlobalConfig->currentProfile->getUseRemotePort());
            ProfileSshOptionsWidget->UserdefinedRemotePortSpinBox->setValue(GlobalConfig->currentProfile->getRemotePort());

            ProfileNetworkVirtualIpOptionsWidget->SourceIpgroupBox->hide();

            ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->hide();
            ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->hide();
            ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->hide();
            ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->hide();
            ProfileNetworkGeneralOptionsWidget->UseRemoteNetworkCheckBox->hide();

            if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword()) {
                // KMessageBox::information(0, "auth pass", Name);
                ProfileSshOptionsWidget->AuthPassRadioButton->setChecked(true);
                ProfileSshOptionsWidget->AuthKeyRadioButton->setChecked(false);
                // ProfileSshOptionsWidget->SshkeyButtonGroup->setEnabled(false);
                ProfileUserOptionsWidget->PasswordEdit->setEnabled(true);
            } else {
                // KMessageBox::information(0, "auth key", Name);
                ProfileSshOptionsWidget->SshKeyComboBox->setEnabled(true);
                ProfileSshOptionsWidget->AuthPassRadioButton->setChecked(false);
                ProfileSshOptionsWidget->AuthKeyRadioButton->setChecked(true);
                // ProfileSshOptionsWidget->SshkeyButtonGroup->setEnabled(true);
                ProfileUserOptionsWidget->PasswordEdit->setEnabled(false);

                if (GlobalConfig->currentProfile->getPskIsInFile()) {
                    ProfileSshOptionsWidget->CostumkeyURLRequester->setUrl(GlobalConfig->currentProfile->getPreSharedKeyFile());
                    ProfileSshOptionsWidget->CostumKeyRadioButton->setChecked(true);
                    ProfileSshOptionsWidget->AutoKeyRadioButton->setChecked(false);
                } else {
                    ProfileSshOptionsWidget->CostumKeyRadioButton->setChecked(false);
                    ProfileSshOptionsWidget->AutoKeyRadioButton->setChecked(true);
                    if (!GlobalConfig->currentProfile->getPreSharedKey().isEmpty()) {
						int SshKeyIndex = ProfileSshOptionsWidget->SshKeyComboBox->findText(GlobalConfig->currentProfile->getPreSharedKey());
						if (SshKeyIndex == -1)
							SshKeyIndex = 0;
						ProfileSshOptionsWidget->SshKeyComboBox->setCurrentIndex(SshKeyIndex);
                    }
                }
                ProfileSshOptionsWidget->sshAuthToggled(true);
            }

            ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
            ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());

            if (GlobalConfig->currentProfile->getUseVirtualIP()) {
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
                tunnelDeviceTypeChanged(GlobalConfig->currentProfile->getTunnelDeviceType());
            } else {
                ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(false);
                ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(false);
            }

            if (GlobalConfig->currentProfile->getUseSshConfigRemoteScript() && !GlobalConfig->currentProfile->getSshConfigRemoteScript().isEmpty()) {
                ProfileSshOptionsWidget->UseSshConfigRemoteScriptCheckBox->setChecked(true);
                ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->setText(GlobalConfig->currentProfile->getSshConfigRemoteScript());
            }

        } // ssh

        /* all types */
        ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());
        ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);

#if 0
        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(GlobalConfig->currentProfile->getUseUdp());
        ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(GlobalConfig->currentProfile->getUdpPort());
        if (GlobalConfig->currentProfile->getUseUdpPort()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);
        }
#endif

        ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled(true);
        ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        if (GlobalConfig->currentProfile->getUseUdp()) {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
        } else {
            ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
        }

        ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled(true);

        ProfileCiscoOptionsWidget->IDLineEdit->setEnabled(false);
        ProfileCiscoOptionsWidget->LabelID->setEnabled(false);
        ProfileUserOptionsWidget->UsernameLineEdit->setEnabled(true);

        if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
                GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
            ProfilePptpOptionsWidget->L2tpDaemonComboBox->setEnabled(true);
            if (GlobalConfig->currentProfile->getL2tpDaemon() == VpnAccountData::l2tpd) {
                ProfilePptpOptionsWidget->L2tpDaemonComboBox->setCurrentIndex(0); // l2tpd
            } else {
                ProfilePptpOptionsWidget->L2tpDaemonComboBox->setCurrentIndex(1); //openl2tp
            }
        } else {
            ProfilePptpOptionsWidget->L2tpDaemonComboBox->setEnabled(false);
        }

        if (GlobalConfig->currentProfile->getReplaceDefaultRoute() == false) {
			// keep default route
            ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->setCurrentIndex(0);
		} else {
			// replace default route
            ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->setCurrentIndex(1);
		}
        ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setChecked(GlobalConfig->currentProfile->getUseSmartcard());

        ProfileCmdExecBeforeConnectOptionsWidget->main->ExcuteCmdBeforeConnectCheckBox->setChecked(GlobalConfig->currentProfile->getExecuteCmdBeforeConnect());
        ProfileCmdExecAfterConnectOptionsWidget->main->ExcuteCmdAfterConnectCheckBox->setChecked(GlobalConfig->currentProfile->getExecuteCmdAfterConnect());
        ProfileCmdExecBeforeDisconnectOptionsWidget->main->ExcuteCmdBeforeDisconnectCheckBox->setChecked(GlobalConfig->currentProfile->getExecuteCmdBeforeDisconnect());
        ProfileCmdExecAfterDisconnectOptionsWidget->main->ExcuteCmdAfterDisconnectCheckBox->setChecked(GlobalConfig->currentProfile->getExecuteCmdAfterDisconnect());
        ProfileCmdExecBeforeConnectOptionsWidget->main->CmdBeforeConnectTextEdit->setText(GlobalConfig->currentProfile->getCommandBeforeConnect());
        ProfileCmdExecAfterConnectOptionsWidget->main->CmdAfterConnectTextEdit->setText(GlobalConfig->currentProfile->getCommandAfterConnect());
        ProfileCmdExecBeforeDisconnectOptionsWidget->main->CmdBeforeDisconnectTextEdit->setText(GlobalConfig->currentProfile->getCommandBeforeDisconnect());
        ProfileCmdExecAfterDisconnectOptionsWidget->main->CmdAfterDisconnectTextEdit->setText(GlobalConfig->currentProfile->getCommandAfterDisconnect());
        ProfileCmdExecBeforeConnectOptionsWidget->main->CmdBeforeConnectTextEdit->setEnabled(GlobalConfig->currentProfile->getExecuteCmdBeforeConnect());
        ProfileCmdExecAfterConnectOptionsWidget->main->CmdAfterConnectTextEdit->setEnabled(GlobalConfig->currentProfile->getExecuteCmdAfterConnect());
        ProfileCmdExecBeforeDisconnectOptionsWidget->main->CmdBeforeDisconnectTextEdit->setEnabled(GlobalConfig->currentProfile->getExecuteCmdBeforeDisconnect());
        ProfileCmdExecAfterDisconnectOptionsWidget->main->CmdAfterDisconnectTextEdit->setEnabled(GlobalConfig->currentProfile->getExecuteCmdAfterDisconnect());
        ProfileCmdExecAfterConnectOptionsWidget->main->CommandAfterConnectDelayTimeNumInput->setValue(GlobalConfig->currentProfile->getCommandAfterConnectDelayTime());

        if (GlobalConfig->currentProfile->getDoPingIP())
            ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setEnabled(true);
        else
            ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setEnabled(false);

        ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->setChecked(GlobalConfig->currentProfile->getAllowEmptyPrivateKeyPassword());
        ProfileOpenvpnOptionsWidget->AllowIpAddressChangeOfPeerCheckBox->setChecked(GlobalConfig->currentProfile->getAllowIpAddressChangeOfPeer());

        ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText(GlobalConfig->currentProfile->getPingHostIP());
		ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked(GlobalConfig->currentProfile->getDoPingIP());
        ProfileNetworkGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked(GlobalConfig->currentProfile->getUseConnectionStatusCheck());
        ProfileNetworkGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount());
        ProfileNetworkGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusInterval());
        ProfileNetworkGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked(GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost());
        ProfileNetworkGeneralOptionsWidget->UseDnsUpdateCheckBox->setChecked(GlobalConfig->currentProfile->getUseDnsUpdate());

        ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked(GlobalConfig->currentProfile->getUseAdditionalNetworkRoutes());
        QStringList AdditionalNetworkRoutes = GlobalConfig->currentProfile->getAdditionalNetworkRoutes();
        // example entry:
        // <network>/<netmask>#<gateway>

        QList<QTreeWidgetItem *> items;
        for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2) {
            QString networkstring = *it2;
            QString Network = networkstring.section('#', 0, 0).section('/', 0, 0);
            QString Netmask = networkstring.section('#', 0, 0).section('/', 1, 1);
            QString Gateway = networkstring.section('#', 1, 1).section('/', 0, 0);
            QString Interface = networkstring.section('#', 2, 2);
            QStringList values;
            values << Network << Netmask << Gateway << Interface;
            items.append(new QTreeWidgetItem((QTreeWidget*)0, values));
        }
        ProfileNetworkRouteOptionsWidget->NetworkListView->insertTopLevelItems(0, items);
        ProfileNetworkRouteOptionsWidget->checkList();

        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText(GlobalConfig->currentProfile->getRemoteNetAddr());
        
		if (!GlobalConfig->currentProfile->getRemoteNetMask().isEmpty()) {
			int RemoteNetmaskIndex = ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->findText(GlobalConfig->currentProfile->getRemoteNetMask());
			if (RemoteNetmaskIndex == -1)
				RemoteNetmaskIndex = 16; //24
				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(RemoteNetmaskIndex);
		} else {
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentIndex(16); // 24 
		}
		

        connectionTypeChanged(ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentIndex());
        
		ProfileCertOptionsWidget->x509certURLRequester->setFilter("*.pem *.crt *.der");
        ProfileCertOptionsWidget->certpathURLRequester->setMode(KFile::Directory);


        ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->setChecked(GlobalConfig->currentProfile->getUsePkcs11Providers());


        if (!GlobalConfig->currentProfile->getPkcs11Id().isEmpty()) {
            int pkcs11IdIdx = ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->count();
            ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->insertItem(pkcs11IdIdx, GlobalConfig->currentProfile->getPkcs11Id());
        }
        if (!GlobalConfig->currentProfile->getPkcs11Slot().isEmpty()) {
            int pkcs11SlotIdx = ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->count();
            ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->insertItem(pkcs11SlotIdx, GlobalConfig->currentProfile->getPkcs11Slot());
        }

//   QString Pkcs11SlotType = GlobalConfig->currentProfile->getPkcs11SlotType();
        //   if (Pkcs11SlotType == "id") {
		// 		// id
        //    ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentIndex(0);
        //   } else if (Pkcs11SlotType == "name") {
		//		// name
        //    ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentIndex(1);
        //   } else {
        //    ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentIndex(2);
		//	 }
        ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentIndex(0);
        ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setEnabled(false);
        ProfileSmartcardOptionsWidget->Pkcs11SlotTypeLabel->setEnabled(false);

        QString Pkcs11IdType = GlobalConfig->currentProfile->getPkcs11IdType();
        if (Pkcs11IdType == "id") {
			// id
            ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentIndex(0);
		} else if (Pkcs11IdType == "label") {
			// label
            ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentIndex(1);
		} else {
			// subject
            ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentIndex(2);
		}

        //   ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentIndex(0);
        //   ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setEnabled(false);

        QString Pkcs11SignMode = GlobalConfig->currentProfile->getPkcs11SignMode();
        if (Pkcs11SignMode == "auto") {
			// auto
            ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentIndex(0);
		} else if (Pkcs11SignMode == "sign") {
			// sign
            ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentIndex(1);
		} else if (Pkcs11SignMode == "recover") {
			// recover
            ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentIndex(2);
		} else {
			// any
            ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentIndex(3);
		}

        ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->setUrl(GlobalConfig->currentProfile->getPkcs11Providers());

        //   authTypeChanged(it->getAuthType());

    } else {
        //   ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileUserOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfilePptpOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentIndex( 0 );
        //   ProfileCmdExecBeforeConnectOptionsWidget->setCurrentIndex( 0 );
        //   ProfileCmdExecBeforeDisconnectOptionsWidget->setCurrentIndex( 0 );
        //   ProfileCmdExecAfterConnectOptionsWidget->setCurrentIndex( 0 );
        //   ProfileCmdExecAfterDisconnectOptionsWidget->setCurrentIndex( 0 );

        ProfileGeneralOptionsWidget->setEnabled(false);
        ProfileNetworkRouteOptionsWidget->setEnabled(false);
        ProfileNetworkNatOptionsWidget->setEnabled(false);
        ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);
        ProfileCertOptionsWidget->setEnabled(false);
        ProfilePskOptionsWidget->setEnabled(false);
        ProfileUserOptionsWidget->setEnabled(false);
        ProfileOpenvpnOptionsWidget->setEnabled(false);
        ProfilePptpOptionsWidget->setEnabled(false);
        ProfileRacoonOptionsWidget->setEnabled(false);
        ProfileCiscoOptionsWidget->setEnabled(false);
        ProfileSshOptionsWidget->setEnabled(false);
        ProfileCmdExecBeforeConnectOptionsWidget->setEnabled(false);
        ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled(false);
        ProfileCmdExecAfterConnectOptionsWidget->setEnabled(false);
        ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled(false);
        ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled(true);

    }
}

void PreferencesDialog::saveSessionClicked()
{
    if (GlobalConfig->KvpncDebugLevel > 5) {
        GlobalConfig->appendLogEntry("PreferencesDialog::save()", KVpncEnum::debug);
    }
    if (!showOnlyProfiles) {
        GlobalConfig->pathToVpnc = ConfigDaemonOptionsWidget->VpncPathInput->url().path();
        GlobalConfig->pathToIpsec = ConfigDaemonOptionsWidget->FreeswanPathInput->url().path();
        GlobalConfig->pathToRacoon = ConfigDaemonOptionsWidget->RacoonPathInput->url().path();

        if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == "low")
            GlobalConfig->PptpLogLevel = 0;
        else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == "default")
            GlobalConfig->PptpLogLevel = 1;
        else if (ConfigDaemonOptionsWidget->PptpLogLevelComboBox->currentText() == "high")
            GlobalConfig->PptpLogLevel = 2;

        if (ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->currentText() == i18n("none"))
            GlobalConfig->PppdKernelLogLevel = 0;
        if (ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->currentText() == i18n("general"))
            GlobalConfig->PppdKernelLogLevel = 1;
        if (ConfigDaemonOptionsWidget->PppdKernelLogLevelComboBox->currentText() == i18n("general + packets"))
            GlobalConfig->PppdKernelLogLevel = 4;

        GlobalConfig->pathToPppd = ConfigDaemonOptionsWidget->PppdPathInput->url().path();
        GlobalConfig->pathToPptp = ConfigDaemonOptionsWidget->PptpPathInput->url().path();
        GlobalConfig->pathToOpenvpn = ConfigDaemonOptionsWidget->OpenvpnPathInput->url().path();
        GlobalConfig->pathToVtund = ConfigDaemonOptionsWidget->VtundPathInput->url().path();
        GlobalConfig->pathToSsh = ConfigDaemonOptionsWidget->SshPathInput->url().path();


        GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url().path();
        GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url().path();
        GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url().path();
        GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url().path();
        GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url().path();
        GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url().path();
        GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url().path();
        GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url().path();
        GlobalConfig->pathToPkcs11Tool = HelperProgramOptionsWidget->Pkcs11ToolPathInput->url().path();
        GlobalConfig->pathToKsshAskpass = HelperProgramOptionsWidget->KsshaskpassPathInput->url().path();
        GlobalConfig->pathToGnomeSshAskpass = HelperProgramOptionsWidget->GnomeaskpassPathInput->url().path();
        GlobalConfig->pathToCiscoCertMgr = HelperProgramOptionsWidget->CiscoCertMgrPathInput->url().path();
        GlobalConfig->pathToTail = HelperProgramOptionsWidget->TailPathInput->url().path();


        GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
        GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
        GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
        GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value();
        GlobalConfig->RacoonDebugLevel = ConfigDaemonOptionsWidget->RacoonDebugLevelComboBox->currentText();
        GlobalConfig->VpncDebugLevel = ConfigDaemonOptionsWidget->spinVpncDebugLevel->value();
        GlobalConfig->OpenvpnDebugLevel = ConfigDaemonOptionsWidget->spinOpenvpnDebugLevel->value() + 1;
        GlobalConfig->SshDebugLevel = ConfigDaemonOptionsWidget->spinSshDebugLevel->value();
        GlobalConfig->enableDebugPppd = ConfigDaemonOptionsWidget->DebugPppdcheckBox->isChecked();
        GlobalConfig->enableDebugPptpd = ConfigDaemonOptionsWidget->DebugPptpdcheckBox->isChecked();

        GlobalConfig->enableDebugXl2tpdtunnel = ConfigDaemonOptionsWidget->EnableDebugXl2tpdtunnelCheckBox->isChecked();
        GlobalConfig->enableDebugXl2tpdstate = ConfigDaemonOptionsWidget->EnableDebugXl2tpdstateCheckBox ->isChecked();
        GlobalConfig->enableDebugXl2tpdpacket = ConfigDaemonOptionsWidget->EnableDebugXl2tpdpacketCheckBox->isChecked();
        GlobalConfig->enableDebugXl2tpdNetwork  = ConfigDaemonOptionsWidget->EnableDebugXl2tpdNetworkCheckBox->isChecked();

        GlobalConfig->enableDebugOpenl2tp  = ConfigDaemonOptionsWidget->DebugOpenl2tpCheckBox->isChecked();

		GlobalConfig->PlutoDebug.clear();
		if (ConfigDaemonOptionsWidget->IpsecRawDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("raw");
		if (ConfigDaemonOptionsWidget->IpsecCryptDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("crypt");
		if (ConfigDaemonOptionsWidget->IpsecParsingDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("parsing");
		if (ConfigDaemonOptionsWidget->IpsecEmittingDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("emitting");
		if (ConfigDaemonOptionsWidget->IpsecControlDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("control");
		if (ConfigDaemonOptionsWidget->IpsecKlipsDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("klips");
		if (ConfigDaemonOptionsWidget->IpsecPrivateDebugCheckBox->isChecked())
			GlobalConfig->PlutoDebug.append("private");
		
		GlobalConfig->KlipsDebug.clear();
		if (ConfigDaemonOptionsWidget->KlipsDebugTunnel_xmitCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("tunnel-xmit");
		if (ConfigDaemonOptionsWidget->KlipsDebugPfkeyCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("pfkey");
		if (ConfigDaemonOptionsWidget->KlipsDebugXformCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("xform");
		if (ConfigDaemonOptionsWidget->KlipsDebugErouteCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("eroute");
		if (ConfigDaemonOptionsWidget->KlipsDebugSpiCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("spi");
		if (ConfigDaemonOptionsWidget->KlipsDebugRadijCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("radij");
		if (ConfigDaemonOptionsWidget->KlipsDebugEspCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("esp");
		if (ConfigDaemonOptionsWidget->KlipsDebugAhCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("ah");
		if (ConfigDaemonOptionsWidget->KlipsDebugIpcompCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("ipcomp");
		if (ConfigDaemonOptionsWidget->KlipsDebugVerboseCheckBox->isChecked())
			GlobalConfig->KlipsDebug.append("verbose");
		
        GlobalConfig->tryConnectTimeout = ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value();
        GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
        GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
        GlobalConfig->hideMainWindow = GeneralOptionsWidget->HideOnStartupCheckBox->isChecked();
        GlobalConfig->useKwallet = GeneralOptionsWidget->useKwalletCheckBox->isChecked();
        GlobalConfig->programsInPath = ConfigDaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
        GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
        GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->palette().color(QPalette::Background);
        GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->palette().color(QPalette::Background);
        GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->palette().color(QPalette::Background);
        GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->palette().color(QPalette::Background);
        GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->palette().color(QPalette::Background);
        GlobalConfig->DebugBackgroundcolor = LogOptionsWidget->BackgroundLogLabel->palette().color(QPalette::Background);
        GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
        GlobalConfig->showInterfaceIPinTooltip = ConfigDaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
        GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
        GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
        GlobalConfig->doKillL2tpdIfStillRunning = ConfigDaemonOptionsWidget->DoKillL2tpdIfStillRunningCheckBox->isChecked();
        GlobalConfig->doKillXl2tpdIfStillRunning = ConfigDaemonOptionsWidget->DoKillXl2tpdIfStillRunningCheckBox->isChecked();
        GlobalConfig->doKillRacoonIfStillRunning = ConfigDaemonOptionsWidget->DoKillRacoonIfStillRunningCheckBox->isChecked();
    }


    canAccept = true;
    configChanged = true;


    if (GlobalConfig->currentProfile == 0 || GlobalConfig->AccountList->isEmpty())
        return ;

    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));

    VpnAccountData *profile = GlobalConfig->currentProfile;

    //QString itemString=ConnectionTypeComboBox->currentText();
    int connectionTypeIndex = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentIndex() ;
	profile->setConnectionType((VpnAccountData::ConnectionType)(connectionTypeIndex));

    // KMessageBox::information(0, "connection type changed: " + QString().setNum(connectionTypeIndex), QString("type set"));

    profile->setDescription(ProfileGeneralOptionsWidget->DescriptionLineEdit->text());

    // cisco
    if (connectionTypeIndex == VpnAccountData::cisco ||
            connectionTypeIndex == VpnAccountData::ciscoorig) {
        int authTypeIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
	
		if ( connectionTypeIndex == VpnAccountData::cisco) {
			// we need a fix here
			if (authTypeIndex == 0) {
				authTypeIndex = VpnAccountData::psk;
			} else {
				authTypeIndex = VpnAccountData::hybrid;
			}
		}
	
        switch (authTypeIndex) {
			case VpnAccountData::cert:
				profile->setAuthType(VpnAccountData::cert);
				break;
			case VpnAccountData::psk:
				profile->setAuthType(VpnAccountData::psk);
				break;
			case VpnAccountData::hybrid:
				profile->setAuthType(VpnAccountData::hybrid);
				break;
        }
			
        if (ProfileUserOptionsWidget->CheckUserPass->isChecked() && ! ProfileUserOptionsWidget->UsernameLineEdit->text().isEmpty()) {
            profile->setSaveUserPassword(true);
            profile->setUserPassword(ProfileUserOptionsWidget->UsernameLineEdit->text());
        } else {
            profile->setSaveUserPassword(false);
        }

        if (ProfilePskOptionsWidget->CheckSavePsk->isChecked() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty()) {
            profile->setSavePsk(true);
            profile->setPreSharedKey(ProfilePskOptionsWidget->PSKLineEdit->text());
        } else {
            profile->setSavePsk(false);
        }
        profile->setAllowEmptyGroupPassword(ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->isChecked());
        profile->setUseXauthInteractive(ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->isChecked());
        profile->setUseGlobalIpsecSecret(ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->isChecked());
        profile->setID(ProfileCiscoOptionsWidget->IDLineEdit->text());
        profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text());

        if (ProfileUserOptionsWidget->NtDomainNameCheckbox->isChecked()) {
            profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text());
            profile->setUseNtDomainName(true);
        } else {
            profile->setUseNtDomainName(false);
        }

        profile->setUseSearchDomainInResolvConf(ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->isChecked());
        profile->setSearchDomainInResolvConf(ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->text());

        profile->setUseLocalPort(ProfileCiscoOptionsWidget->LocalPortCheckbox->isChecked());
        profile->setLocalPort(ProfileCiscoOptionsWidget->LocalPortSpinbox->value());

        profile->setPeerTimeout(ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value());


        if (connectionTypeIndex == VpnAccountData::cisco) {
            profile->setDisableDataEncryption(ProfileCiscoOptionsWidget->DisableDataEncryptionCheckbox->isChecked());
            profile->setUseDpdIdleTimeout(ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->isChecked());
			if ( profile->getAuthType() == VpnAccountData::hybrid)
			{
				profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url().path());
				profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url().path());
				profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
				profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());
			}
        }

        if (connectionTypeIndex == VpnAccountData::ciscoorig) {
			if (profile->getAuthType() == VpnAccountData::cert || profile->getAuthType() == VpnAccountData::hybrid)
			{
				profile->setUseCiscoCertStore(ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->isChecked());
				if (ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->isChecked())
				{
					profile->setX509Certificate( ProfileCertOptionsWidget->x509certComboBox->currentText());
					profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathComboBox->currentText());
				}
				else
				{
					profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url().path());
					profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url().path());
					profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url().path());
				}
				profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
				profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());
			}
			
            profile->setUseDpdIdleTimeout(true);
        }
        profile->setDpdIdleTimeout(ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->value());
		profile->setCiscoNatMode(ProfileCiscoOptionsWidget->CiscoNatModeComboBox->currentText());

        // if (connectionTypeIndex == VpnAccountData::cisco)
        {
            if (ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->isChecked()) {
                profile->setApplicationVersion(ProfileCiscoOptionsWidget->ApplicationVersionLineedit->text());
                profile->setUseApplicationVersion(true);
            } else {
                profile->setUseApplicationVersion(false);
            }

            if (ProfileCiscoOptionsWidget->IkeGroupCheckbox->isChecked()) {
                profile->setIkeGroup(ProfileCiscoOptionsWidget->IkeGroupCombobox->currentText());
                profile->setUseIkeGroup(true);
            } else {
                profile->setUseIkeGroup(false);
            }

            if (ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->isChecked()) {
                profile->setPerfectForwardSecrety(ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->currentText());
                profile->setUsePerfectForwardSecrety(true);
            } else {
                profile->setUsePerfectForwardSecrety(false);
            }

            if (ProfileCiscoOptionsWidget->SingleDesCheckbox->isChecked()) {
                profile->setUseSingleDes(true);
            } else {
                profile->setUseSingleDes(false);
            }
        }

        profile->setHideGroupPasswordInAccountDataDialog(ProfileUserOptionsWidget->HideGroupPasswordInAccountDataDialogCheckBox->isChecked());
    } else if (connectionTypeIndex == VpnAccountData::racoon ||
               connectionTypeIndex == VpnAccountData::l2tpd_racoon ||
               connectionTypeIndex == VpnAccountData::freeswan ||
               connectionTypeIndex == VpnAccountData::l2tpd_freeswan) {

        bool validAddr = true;

        if (ProfileNetworkGeneralOptionsWidget->UseRemoteNetworkCheckBox->isChecked()) {
            if (ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains(QChar('.'), Qt::CaseInsensitive) != 3) {
                KMessageBox::error(this,
                                   i18n("No remote network entered."),
                                   i18n("No remote network"));
                GlobalConfig->appendLogEntry(i18n("No remote network entered."),
                                             KVpncEnum::error);
                validAddr = false;
            } else {
                QString addr = ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
                int part0 = addr.section('.', 0, 0).toInt();
                int part1 = addr.section('.', 1, 1).toInt();
                int part2 = addr.section('.', 2, 2).toInt();
                int part3 = addr.section('.', 3, 3).toInt();

                /*
                   LogOutput->append ("part0: "+QString().setNum(part0));
                   LogOutput->append ("part1: "+QString().setNum(part1));
                   LogOutput->append ("part2: "+QString().setNum(part2));
                   LogOutput->append ("part3: "+QString().setNum(part3));
                */
                if ((part0 < 1 || part0 > 254) ||
                        (part1 < 0 || part1 > 254) ||
                        (part2 < 0 || part2 > 254) ||
                        (part3 < 0 || part3 > 254)) {
                    KMessageBox::error(this,
                                       i18n("IP address (remote net) is not valid."),
                                       i18n("Invalid IP Address"));
                    // GlobalConfig->appendLogEntry(i18n("IP address (remote net) is not valid."),
                    //                              KVpncEnum::error);
                    canAccept = false;
                    validAddr = false;
                }
                if (validAddr == true) {
                    profile->setUseRemoteNetwork(true);
                    profile->setRemoteNetAddr(addr);
                    profile->setRemoteNetMask(ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->currentText());
                }
            }
        } else {
            profile->setUseRemoteNetwork(false);
        }

        if (connectionTypeIndex == VpnAccountData::racoon ||
                connectionTypeIndex == VpnAccountData::l2tpd_racoon) {
			
			if (ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialRemoteID( true );
			else
				profile->setUseSpecialRemoteID( false );
			
			if (ProfileRacoonOptionsWidget->LocalIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialLocalID( true );
			else
				profile->setUseSpecialLocalID( false );
			
			
            int authTypeIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
            switch (authTypeIndex) {
            case VpnAccountData::cert:
                profile->setAuthType(VpnAccountData::cert);
                break;
            case VpnAccountData::psk:
                profile->setAuthType(VpnAccountData::psk);
                break;
            case VpnAccountData::hybrid:
                profile->setAuthType(VpnAccountData::hybrid);
                break;
            }

            profile->setLocalIDType(ProfileRacoonOptionsWidget->LocalIdTypeCombobox->currentText());
            profile->setSpecialLocalID(ProfileRacoonOptionsWidget->LocalIDLineEdit->text());

            profile->setRemoteIDType(ProfileRacoonOptionsWidget->RemoteIdTypeCombobox->currentText());
            profile->setSpecialRemoteID(ProfileRacoonOptionsWidget->RemoteIDLineEdit->text());

            if (connectionTypeIndex == VpnAccountData::l2tpd_racoon) {
                int authMethodIndex = ProfilePptpOptionsWidget->AuthMethodComboBox->currentIndex();
                switch (authMethodIndex) {
                case VpnAccountData::chap:
                    profile->setAuthMethod("chap");
                    break;
                case VpnAccountData::pap:
                    profile->setAuthMethod("pap");
                    break;
                case VpnAccountData::mschap:
                    profile->setAuthMethod("mschap");
                    break;
                case VpnAccountData::mschap_v2:
                    profile->setAuthMethod("mschap_v2");
                    break;
                }
            }

            // xauth
            if (profile->getConnectionType() == VpnAccountData::racoon && ProfileRacoonOptionsWidget->UseXauthCheckBox->isChecked()) {
                if (ProfilePskOptionsWidget->CheckSavePsk->isChecked()) {
                    QString Psk = ProfilePskOptionsWidget->PSKLineEdit->text();
                    if (ProfilePskOptionsWidget->PskInFileCheckBox->isChecked()) {
                        QString PskFileName = ProfilePskOptionsWidget->PSKFileURLRequester->url().path();
                        QFile PskFile(PskFileName);
                        if (PskFile.open(QIODevice::WriteOnly)) {
                            QTextStream stream(&PskFile);
                            stream << Psk;
                            profile->setPskIsInFile(true);
                            profile->setSavePsk(true);
                            PskFile.close();
                        } else {
                            profile->setSavePsk(false);
                        }
                    } else {
                        if (!Psk.isEmpty()) {
                            profile->setPreSharedKey(Psk);
                            profile->setSavePsk(true);
                        }
                    }
                }
                profile->setAuthWithUsernameAndPassword(true);
                profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
                if (ProfileUserOptionsWidget->CheckUserPass->isChecked()) {
                    QString UserPassword = ProfileUserOptionsWidget->PasswordEdit->text();
                    if (!UserPassword.isEmpty()) {
                        profile->setUserPassword(UserPassword);
                        profile->setSaveUserPassword(true);
                    } else
                        profile->setSaveUserPassword(false);
                }

#if 0
                if (ProfileIpsecOptionsWidget->LocalIDLineEdit->text().isEmpty()) {
                    KMessageBox::error(this,
                                       i18n("Local ID (Group ID) is empty."),
                                       i18n("Local ID (Group ID) is empty"));
                    GlobalConfig->appendLogEntry(i18n("Local ID (Group ID) is empty."),
                                                 KVpncEnum::error);
                    canAccept = false;
                }
#endif
            } else {
                profile->setAuthWithUsernameAndPassword(false);
            }

            if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::hybrid) {
                profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url().path());
                profile->setVerifyCaCert(ProfileCertOptionsWidget->VerifyCaCertCheckBox->isChecked());
                profile->setAuthWithUsernameAndPassword(true);
                profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
                if (ProfileUserOptionsWidget->CheckUserPass->isChecked()) {
                    QString UserPassword = ProfileUserOptionsWidget->PasswordEdit->text();
                    if (!UserPassword.isEmpty()) {
                        profile->setUserPassword(UserPassword);
                        profile->setSaveUserPassword(true);
                    } else
                        profile->setSaveUserPassword(false);
                }
            }

            profile->setUseModeConfig(ProfileRacoonOptionsWidget->UseModeConfigCheckBox->isChecked());
			
			profile->setUseLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked( ));
			profile->setUseRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked());
			
			if (ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked( ) &&ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Local Source IP address is empty!" ), i18n( "Local Source IP empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Local Source IP address is empty!" ) , KVpncEnum::error );
				canAccept = false;
			}
			else
				profile->setLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text());
			
			if (ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked( ) && ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Remote Source IP address is empty!" ), i18n( "Remote Source IP empty" ) );
				GlobalConfig->appendLogEntry( i18n( "Remote Source IP address is empty!" ) , KVpncEnum::error );
				canAccept = false;
			}
			else
				profile->setRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text());
			
			

        }
        if (connectionTypeIndex == VpnAccountData::freeswan ||
                connectionTypeIndex == VpnAccountData::l2tpd_freeswan) {
			
			if (ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialRemoteID( true );
			else
				profile->setUseSpecialRemoteID( false );
			
			if (ProfileIpsecOptionsWidget->LocalIdTypeCombobox->currentText() != "none")
				profile->setUseSpecialLocalID( true );
			else
				profile->setUseSpecialLocalID( false );
			
			
			
            int authTypeIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
            switch (authTypeIndex) {
            case VpnAccountData::cert:
                profile->setAuthType(VpnAccountData::cert);
                break;
            case VpnAccountData::psk:
                profile->setAuthType(VpnAccountData::psk);
                break;
            }


            profile->setDisableOpportunisticEncryption(ProfileIpsecOptionsWidget->DisableOpportunisticEncryptionCheckBox->isChecked());
            if (ProfileIpsecOptionsWidget->IpsecVpnModeCombobox->currentText() == "transport")
                profile->setIpsecVpnMode("transport");
            else
                profile->setIpsecVpnMode("tunnel");

            profile->setPrivateKey(ProfileCertOptionsWidget->privkeypathURLRequester->url().path());
            profile->setPrivateKeyPass(ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
            profile->setSaveUserPassword(ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());

            // ike + esp
            QStringList IkeList;
            QStringList EspList;

            if (ProfileIpsecOptionsWidget->IkeAes256Sha1CheckBox->isChecked())
                IkeList.append("aes256-sha1");
            if (ProfileIpsecOptionsWidget->IkeAes128Sha1CheckBox->isChecked())
                IkeList.append("aes128-sha1");
            if (ProfileIpsecOptionsWidget->IkeDesSha1Modp2048CheckBox->isChecked())
                IkeList.append("3des-sha1-modp2048");
            if (ProfileIpsecOptionsWidget->IkeDesMd5CheckBox->isChecked())
                IkeList.append("3des-md5");
            if (ProfileIpsecOptionsWidget->IkeDesSha1CheckBox->isChecked())
                IkeList.append("3des-sha1");

            if (!ProfileIpsecOptionsWidget->OtherIkeLineEdit->text().isEmpty())
                IkeList.append(ProfileIpsecOptionsWidget->OtherIkeLineEdit->text());

            if (ProfileIpsecOptionsWidget->Esp3desMd5CheckBox->isChecked())
                EspList.append("3des-md5");
            if (ProfileIpsecOptionsWidget->EspDesSha1CheckBox->isChecked())
                EspList.append("3des-sha1");
            if (ProfileIpsecOptionsWidget->EspAes128Sha1CheckBox->isChecked())
                EspList.append("aes128-sha1");
            if (ProfileIpsecOptionsWidget->EspAes256Sha1CheckBox->isChecked())
                EspList.append("aes256-sha1");

            if (!ProfileIpsecOptionsWidget->OtherEspLineEdit->text().isEmpty())
                EspList.append(ProfileIpsecOptionsWidget->OtherEspLineEdit->text());

            if (ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->isChecked() && IkeList.isEmpty()) {
                KMessageBox::error(this, i18n("Use custom IKE checked but none selected."), i18n("No custom IKE"));
                canAccept = false;
            }

            if (ProfileIpsecOptionsWidget->UseCustomEspCheckBox->isChecked() && EspList.isEmpty()) {
                KMessageBox::error(this, i18n("Use custom ESP checked but none selected."), i18n("No custom ESP"));
                canAccept = false;
            }



            profile->setIpsecEsp(EspList.join(","));
            profile->setIpsecIke(IkeList.join(","));

            if (ProfileIpsecOptionsWidget->UseCustomEspCheckBox->isChecked() && !EspList.isEmpty())
                profile->setUseCustomEsp(true);
            else
                profile->setUseCustomEsp(false);

            if (ProfileIpsecOptionsWidget->UseCustomIkeCheckBox->isChecked() && !IkeList.isEmpty())
                profile->setUseCustomIke(true);
            else
                profile->setUseCustomIke(false);

            if (connectionTypeIndex == VpnAccountData::l2tpd_freeswan) {
                int authMethodIndex = ProfilePptpOptionsWidget->AuthMethodComboBox->currentIndex();
                switch (authMethodIndex) {
                case VpnAccountData::chap:
                    profile->setAuthMethod("chap");
                    break;
                case VpnAccountData::pap:
                    profile->setAuthMethod("pap");
                    break;
                case VpnAccountData::mschap:
                    profile->setAuthMethod("mschap");
                    break;
                case VpnAccountData::mschap_v2:
                    profile->setAuthMethod("mschap-v2");
                    break;
                }
            } else {
                profile->setAuthWithUsernameAndPassword(ProfileIpsecOptionsWidget->UseXauthCheckBox->isChecked());
                profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());

                if (!ProfileUserOptionsWidget->PasswordEdit->text().isEmpty())
                    profile->setUserPassword(ProfileUserOptionsWidget->PasswordEdit->text());
            }

            //    if (ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentIndex() == 0)
            //     profile->setExchangeMode("main");
            //
            //    if (ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentIndex() == 1)
            //     profile->setExchangeMode("aggressive");
            //
            //    if (ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentIndex() == 2)
            //     profile->setExchangeMode("base");
            profile->setExchangeMode(ProfileIpsecOptionsWidget->ExchangeModeComboBox->currentText());

            // xauth
            if (profile->getConnectionType() == VpnAccountData::freeswan && ProfileIpsecOptionsWidget->UseXauthCheckBox->isChecked()) {
                if (ProfilePskOptionsWidget->CheckSavePsk->isChecked()) {
                    QString Psk = ProfilePskOptionsWidget->PSKLineEdit->text();
                    if (ProfilePskOptionsWidget->PskInFileCheckBox->isChecked()) {
                        QString PskFileName = ProfilePskOptionsWidget->PSKFileURLRequester->url().path();
                        QFile PskFile(PskFileName);
                        if (PskFile.open(QIODevice::WriteOnly)) {
                            QTextStream stream(&PskFile);
                            stream << Psk;
                            profile->setPskIsInFile(true);
                            profile->setSavePsk(true);
                            PskFile.close();
                        } else {
                            profile->setSavePsk(false);
                        }
                    } else {
                        if (!Psk.isEmpty()) {
                            profile->setPreSharedKey(Psk);
                            profile->setSavePsk(true);
                        }
                    }
                }
                profile->setAuthWithUsernameAndPassword(true);
                profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
                if (ProfileUserOptionsWidget->CheckUserPass->isChecked()) {
                    QString UserPassword = ProfileUserOptionsWidget->PasswordEdit->text();
                    if (!UserPassword.isEmpty()) {
                        profile->setUserPassword(UserPassword);
                        profile->setSaveUserPassword(true);
                    } else {
                        profile->setSaveUserPassword(false);
                    }
                }

                if (ProfileIpsecOptionsWidget->LocalIDLineEdit->text().isEmpty()) {
                    KMessageBox::error(this,
                                       i18n("Local ID (Group ID) is empty."),
                                       i18n("Local ID (Group ID) is empty"));
                    GlobalConfig->appendLogEntry(i18n("Local ID (Group ID) is empty."),
                                                 KVpncEnum::error);
                    canAccept = false;
                }
            } else {
                profile->setAuthWithUsernameAndPassword(false);
            }

            profile->setUseLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked());
            profile->setUseRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked());

            if (ProfileNetworkVirtualIpOptionsWidget->UseLeftSourceIpCheckBox->isChecked() &&
                    ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text().isEmpty()) {
                KMessageBox::error(this,
                                   i18n("Local Source IP address is empty."),
                                   i18n("Local Source IP empty"));
                GlobalConfig->appendLogEntry(i18n("Local Source IP address is empty."),
                                             KVpncEnum::error);
                canAccept = false;
            } else {
                profile->setLeftSourceIp(ProfileNetworkVirtualIpOptionsWidget->LeftSourceIpLineEdit->text());
            }

            profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
            profile->setLocalVirtualIP(ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text());
            profile->setRemoteVirtualIP(ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text());

            if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() &&
                    ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text().isEmpty()) {
                KMessageBox::error(this,
                                   i18n("Remote virtual IP address is empty."),
                                   i18n("Remote virtual IP empty"));
                GlobalConfig->appendLogEntry(i18n("Remote virtual IP address is empty."),
                                             KVpncEnum::error);
                canAccept = false;
            }
        } // freeswan

        profile->setX509Certificate(ProfileCertOptionsWidget->x509certURLRequester->url().path());
		profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url().path());
		profile->setCaCertificate( ProfileCertOptionsWidget->CaCertpathURLRequester->url().path() );
		profile->setPrivateKey ( ProfileCertOptionsWidget->privkeypathURLRequester->url().path() );
		profile->setPrivateKeyPass ( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
        profile->setPreSharedKey(ProfilePskOptionsWidget->PSKLineEdit->text());


        if (ProfileNetworkVirtualIpOptionsWidget->UseRightSourceIpCheckBox->isChecked() &&
                ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->text().isEmpty()) {
            KMessageBox::error(this,
                               i18n("Remote Source IP address is empty."),
                               i18n("Remote Source IP empty"));
            GlobalConfig->appendLogEntry(i18n("Remote Source IP address is empty."),
                                         KVpncEnum::error);
            canAccept = false;
        } else {
            profile->setRightSourceIp(ProfileNetworkVirtualIpOptionsWidget->RightSourceIpLineEdit->text());
        }

        if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualSubnetsCheckBox->isChecked()) {
            if (ProfileNetworkVirtualIpOptionsWidget->VirtualSubnetsLineEdit->text().isEmpty()) {
                KMessageBox::error(this,
                                   i18n("Virtual subnets are empty."),
                                   i18n("Virtual subnets empty"));
                GlobalConfig->appendLogEntry(i18n("Virtual subnets are empty."),
                                             KVpncEnum::error);
                canAccept = false;
            }
        }

        profile->setVirtualSubnetworks(ProfileNetworkVirtualIpOptionsWidget->VirtualSubnetsLineEdit->text()); // FIXME hacking subnets list from linedit!
        profile->setUseVirtualSubnetworks(ProfileNetworkVirtualIpOptionsWidget->UseVirtualSubnetsCheckBox->isChecked());

        if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() &&
                !ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty()) {
            // check for valid IP
            if (!Utils(GlobalConfig).isValidIPv4Address(ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text())) {
                KMessageBox::error(this,
                                   i18n("No valid IP address entered."),
                                   i18n("No Valid IP Address"));
                GlobalConfig->appendLogEntry(i18n("No valid IP address entered."),
                                             KVpncEnum::error);
                canAccept = false;
            } else {
                profile->setVirtualIP(ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text());
                profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
            }
        } else {
            if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked()) {
                if (ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() &&
                        ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text().isEmpty()) {
                    KMessageBox::error(this,
                                       i18n("No IP address (virtual IP) entered."),
                                       i18n("No IP Address"));
                    // GlobalConfig->appendLogEntry(i18n("No IP address (virtual IP) entered." ),
                    //                              KVpncEnum::error);
                    canAccept = false;
                }
            } else {
                profile->setVirtualIP("");
                profile->setUseVirtualIP(false);
            }
        }

        connectionTypeIndex = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentIndex();
        if (connectionTypeIndex == VpnAccountData::racoon ||
                connectionTypeIndex == VpnAccountData::l2tpd_racoon) {
            // phase 1
            profile->setIpsecIke(ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->currentText());
            profile->setHashAlgo(ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText());
            profile->setUseAuthenticationAlgorithm(true);
            profile->setIkeGroup(ProfileRacoonOptionsWidget->DHGroupComboBox->currentText());

            profile->setEncryptionAlgorithm(ProfileRacoonOptionsWidget->EncryptionAlgorithm2ComboBox->currentText());
            profile->setAuthenticationAlgorithm(ProfileRacoonOptionsWidget->AuthenticationAlgorithm2ComboBox->currentText());

            if (connectionTypeIndex == VpnAccountData::l2tpd_racoon) {
                profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());

                if (ProfileUserOptionsWidget->CheckUserPass->isChecked()) {
                    profile->setSaveUserPassword(true);
                    profile->setUserPassword(ProfileUserOptionsWidget->PasswordEdit->text());
                } else
                    profile->setSaveUserPassword(true);
            }

            if (ProfileRacoonOptionsWidget->IkeGroupCheckbox->isChecked()) {
                profile->setIkeGroup(ProfileRacoonOptionsWidget->DHGroupComboBox->currentText());
                profile->setUseIkeGroup(true);
            } else {
                profile->setUseIkeGroup(false);
            }

            if (ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->isChecked()) {
                profile->setPerfectForwardSecrety(ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->currentText());
                profile->setUsePerfectForwardSecrety(true);
            } else {
                profile->setUsePerfectForwardSecrety(false);
            }


            //    if (ProfileRacoonOptionsWidget->UseSpecialLocalIDcheckBox->isChecked())
            //    {
            //     profile->setSpecialLocalID(ProfileRacoonOptionsWidget->LocalIDLineEdit->text());
            //     profile->setUseSpecialLocalID(true);
            //    }
            //    else
            //    {
            //     profile->setUseSpecialLocalID(false);
            //    }

            profile->setExchangeMode(ProfileRacoonOptionsWidget->ExchangeModeComboBox->currentText());
            profile->setVerifyCaCert(ProfileCertOptionsWidget->VerifyCaCertCheckBox->isChecked());
        }
        if (connectionTypeIndex == VpnAccountData::freeswan ||
                connectionTypeIndex == VpnAccountData::l2tpd_freeswan) {
            if (connectionTypeIndex == VpnAccountData::l2tpd_freeswan) {
                profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());

                if (ProfileUserOptionsWidget->CheckUserPass->isChecked()) {
                    profile->setSaveUserPassword(true);
                    profile->setUserPassword(ProfileUserOptionsWidget->PasswordEdit->text());
                } else {
                    profile->setSaveUserPassword(true);
                }
            }

            if (ProfileIpsecOptionsWidget->PerfectForwardSecurityCheckbox->isChecked()) {
                profile->setUsePerfectForwardSecrety(true);
            } else {
                profile->setUsePerfectForwardSecrety(false);
            }
            profile->setPerfectForwardSecrety( ProfileIpsecOptionsWidget->PerfectForwardSecrecyCombobox->currentText() );

            profile->setUseSpecialLocalID(true);
            profile->setLocalIDType(ProfileIpsecOptionsWidget->LocalIdTypeCombobox->currentText());
            profile->setSpecialLocalID(ProfileIpsecOptionsWidget->LocalIDLineEdit->text());
			profile->setRemoteIDType( ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->currentText());
			profile->setSpecialRemoteID(ProfileIpsecOptionsWidget->RemoteIDLineEdit->text());
			
			if (ProfileIpsecOptionsWidget->RemoteIdTypeCombobox->currentText() != "none" && !ProfileIpsecOptionsWidget->RemoteIDLineEdit->text().isEmpty())
			{
				profile->setUseSpecialRemoteID(true);
				
			}
			else
				profile->setUseSpecialRemoteID(false);
        }

        if (profile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
                profile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
            int l2tpDaemonIndex = ProfilePptpOptionsWidget->L2tpDaemonComboBox->currentIndex();
            switch (l2tpDaemonIndex) {
            case VpnAccountData::l2tpd:
                profile->setL2tpDaemon(VpnAccountData::l2tpd);
                break;
            case VpnAccountData::openl2tp:
                profile->setL2tpDaemon(VpnAccountData::openl2tp);
                break;
            }
        }

    } else if (connectionTypeIndex == VpnAccountData::pptp) {
        bool validAddr = true;
        if (!ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().isEmpty()) {
            if (ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains(QChar('.'), Qt::CaseInsensitive) != 3) {
                //KMessageBox::error ( this, i18n( "No IP address entered." ), i18n( "No IP Address" ) );
                validAddr = false;
            } else {
                QString addr = ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
                int part0 = addr.section('.', 0, 0).toInt();
                int part1 = addr.section('.', 1, 1).toInt();
                int part2 = addr.section('.', 2, 2).toInt();
                int part3 = addr.section('.', 3, 3).toInt();

                /*
                   LogOutput->append ("part0: "+QString().setNum(part0));
                   LogOutput->append ("part1: "+QString().setNum(part1));
                   LogOutput->append ("part2: "+QString().setNum(part2));
                   LogOutput->append ("part3: "+QString().setNum(part3));
                */

                if ((part0 < 1 || part0 > 254) || (part1 < 0 || part1 > 254) || (part2 < 0 || part2 > 254) || (part3 < 0 || part3 > 254)) {
                    KMessageBox::error(this,
                                       i18n("Invalid values in IP address (remote net.)"),
                                       i18n("Invalid Values in IP Address"));
                    GlobalConfig->appendLogEntry(i18n("Invalid values in IP address (remote net.)"),
                                                 KVpncEnum::error);
                    validAddr = false;
                }

                if (validAddr == true) {
                    profile->setRemoteNetAddr(addr);
                    profile->setRemoteNetMask(ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->currentText());
                }
            }
        } else {
            profile->setRemoteNetAddr("");
            profile->setRemoteNetMask("");
        }

        //   if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentText() == i18n("Keep default route"))
        if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentIndex() == 0) {
            profile->setReplaceDefaultRoute(false);
        }

        profile->setAllowStatefulMode(ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->isChecked());
        profile->setUseNoIpDefault(ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->isChecked());
        profile->setDisableMPPEComp(ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked());
        profile->setRequireMppe(ProfilePptpOptionsWidget->RequireMppeCheckbox->isChecked());
        profile->setRefuse128BitEncryption(ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->isChecked());
        profile->setRefuse40BitEncryption(ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->isChecked());
        profile->setDisableMPPEComp(ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked());
        profile->setUseDnsServer(ProfilePptpOptionsWidget->DnsServerCheckbox->isChecked());
        profile->setDnsServer(ProfilePptpOptionsWidget->DnsServerLineedit->text());
        profile->setUseNoBsdComp(ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->isChecked());
        profile->setUseNoDeflate(ProfilePptpOptionsWidget->UseNoDeflateCheckbox->isChecked());
        profile->setDisableHeaderCompression(ProfilePptpOptionsWidget->DisableHeaderCompressionCheckbox->isChecked());
        profile->setDisableMagicNumberNegotiation(ProfilePptpOptionsWidget->DisableMagicNumberNegotiationCheckbox->isChecked());
        profile->setDisableIpx(ProfilePptpOptionsWidget->DisableIpxCheckbox->isChecked());
        profile->setDisableAddressControlCompression(ProfilePptpOptionsWidget->DisableAddressControlCompressionCheckbox->isChecked());
        profile->setDisableProtocolFieldCompression(ProfilePptpOptionsWidget->DisableProtocolFieldCompressionCheckbox->isChecked());
        profile->setRequireEap(ProfilePptpOptionsWidget->RequireEapCheckbox->isChecked());

        //   if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentText() == i18n("Keep default route"))

        profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text());
        profile->setUseSearchDomainInResolvConf(ProfilePptpOptionsWidget->UseSearchDomainInResolvConfCheckbox->isChecked());
        profile->setSearchDomainInResolvConf(ProfilePptpOptionsWidget->SearchDomainInResolvConfLineedit->text());

        if (ProfileUserOptionsWidget->NtDomainNameCheckbox->isChecked() && !ProfileUserOptionsWidget->NtDomainNameLineedit->text().isEmpty()) {
            profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text());
            profile->setUseNtDomainName(true);
        } else {
            profile->setUseNtDomainName(false);
        }

		int authMethodIndex = ProfilePptpOptionsWidget->AuthMethodComboBox->currentIndex();
		switch (authMethodIndex) {
			case VpnAccountData::chap:
				profile->setAuthMethod("chap");
				break;
			case VpnAccountData::pap:
				profile->setAuthMethod("pap");
				break;
			case VpnAccountData::mschap:
				profile->setAuthMethod("mschap");
				break;
			case VpnAccountData::mschap_v2:
				profile->setAuthMethod("mschap_v2");
				break;
		}


        bool IPOk = true;
        if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked()) {
            QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
            if (Utils(GlobalConfig).isValidIPv4Address(LocalVirtualIp) == false) {
                KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No Valid IP Address"));
                IPOk = false;
            } else {
                profile->setLocalVirtualIP(LocalVirtualIp);
            }

            QString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();
            if (Utils(GlobalConfig).isValidIPv4Address(RemoteVirtualIp) == false) {
                KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No Valid IP Address"));
                IPOk = false;
            } else {
                profile->setRemoteVirtualIP(RemoteVirtualIp);
            }
        }
        if (IPOk)
            profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
        else
            profile->setUseVirtualIP(false);

    } else if (connectionTypeIndex == VpnAccountData::openvpn) {
        ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(false);
        ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(false);

        bool validAddr = true;
        if (ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() &&
                ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text().contains(QChar('.'), Qt::CaseInsensitive) != 3) {
            KMessageBox::error(this,
                               i18n("No IP address entered."),
                               i18n("No IP Address"));
            GlobalConfig->appendLogEntry(i18n("No IP address entered."),
                                         KVpncEnum::error);
            validAddr = false;
        } else {
            QString addr = ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text();
        }

        bool IPOk = true;
        if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked()) {
            QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
            if (Utils(GlobalConfig).isValidIPv4Address(LocalVirtualIp) == false) {
                KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No Valid IP Address"));
                IPOk = false;
            } else {
                profile->setLocalVirtualIP(LocalVirtualIp);
            }

            QString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();

            if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().toLower() == "tun") {
                if (Utils(GlobalConfig).isValidIPv4Address(RemoteVirtualIp) == false) {
                    KMessageBox::error(this,
                                       i18n("No valid IP address entered."),
                                       i18n("No valid IP address"));
                    IPOk = false;
                } else {
                    profile->setRemoteVirtualIP(RemoteVirtualIp);
                }
            }
            if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().toLower() == "tap") {
                if (Utils(GlobalConfig).isValidIPv4Netmask(RemoteVirtualIp) == false) {
                    KMessageBox::error(this,
                                       i18n("No valid netmask entered."),
                                       i18n("No valid netmask"));
                    IPOk = false;
                } else {
                    profile->setRemoteVirtualIP(RemoteVirtualIp);
                }
            }
        }

        if (IPOk) {
            profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
        } else {
            profile->setUseVirtualIP(false);
        }

        int authTypeIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
        switch (authTypeIndex) {
        case VpnAccountData::cert:
            profile->setAuthType(VpnAccountData::cert);
            break;
        case VpnAccountData::psk:
            profile->setAuthType(VpnAccountData::psk);
            break;
        }


        profile->setPreSharedKeyFile(ProfilePskOptionsWidget->PSKFileURLRequester->url().path());
        profile->setPskIsInFile(ProfilePskOptionsWidget->PskInFileCheckBox->isChecked());
        profile->setX509Certificate(ProfileCertOptionsWidget->x509certURLRequester->url().path());
        profile->setCaCertificate(ProfileCertOptionsWidget->CaCertpathURLRequester->url().path());
        profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url().path());
        profile->setPrivateKey(ProfileCertOptionsWidget->privkeypathURLRequester->url().path());
        profile->setPrivateKeyPass(ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
        profile->setSavePrivateKeyPassword(ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());

        if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentIndex() == 1)
            profile->setTunnelDeviceType("tap");
        else
            profile->setTunnelDeviceType("tun");

        profile->setUserdefinedPort(ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value());
        profile->setUseUserdefinedPort(ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->isChecked());
        profile->setDisableLzoCompression(ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->isChecked());
        profile->setUserdefinedPort(ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value());
        profile->setAuthWithUsernameAndPassword(ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked());
        profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());
        profile->setUserPassword(ProfileUserOptionsWidget->PasswordEdit->text());


        GlobalConfig->currentProfile->setUserdefiniedCipher(ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->currentText());
        GlobalConfig->currentProfile->setUseUserdefiniedCipher(ProfileOpenvpnOptionsWidget->UseUserdefiniedCipherCheckBox->isChecked());

        profile->setUseTlsAuth(ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->isChecked());
        profile->setTlsAuthFile(ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->url().path());

        profile->setUseTlsRemoteHost(ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->isChecked());
        profile->setTlsRemoteHost(ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->text());

		profile->setMssfix(ProfileOpenvpnOptionsWidget->UserdefinedPacketSizeSpinBox->value());
		profile->setFragment(ProfileOpenvpnOptionsWidget->UserdefinedFragmentSizeSpinBox->value());
		profile->setUseMssfix(ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked());
		profile->setUseFragment(ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked());

		if (ProfilePskOptionsWidget->AuthTypeComboBox->currentText() == i18n("Pre Shared Key") &&
                ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() &&
                ProfilePskOptionsWidget->PSKFileURLRequester->url().path().isEmpty()) {
            KMessageBox::error(this,
                               i18n("PSK file cannot be empty."),
                               i18n("Empty PSK file"));
            // GlobalConfig->appendLogEntry(i18n("PSK file cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }

		if (ProfilePskOptionsWidget->AuthTypeComboBox->currentText() == i18n("Pre Shared Key") &&
                (!ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() &&
                 ProfilePskOptionsWidget->CheckSavePsk->isChecked()) &&
                ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty()) {
            KMessageBox::error(this,
                               i18n("PSK cannot be empty."),
                               i18n("Empty PSK"));
            // GlobalConfig->appendLogEntry(i18n("PSK cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }

        if (ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->isChecked() &&
                ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->url().path().isEmpty()) {
            KMessageBox::error(this,
                               i18n("TLS remote host cannot be empty."),
                               i18n("Empty TLS remote host"));
            // GlobalConfig->appendLogEntry(i18n("TLS remote host cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }

        if (ProfileOpenvpnOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked()) {
            profile->setUseRemotePort(true);
        } else {
            profile->setUseRemotePort(false);
        }
        profile->setRemotePort(ProfileOpenvpnOptionsWidget->UserdefinedRemotePortSpinBox->value());



        profile->setUseOnlyCaCertAndUserAuth(ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->isChecked());

        profile->setAuthenticationAlgorithm(ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->currentText());
        profile->setUseAuthenticationAlgorithm(ProfileOpenvpnOptionsWidget->UseAuthenticationAlgorithmCheckBox->isChecked());

        int authenticationDirectionIndex = ProfileOpenvpnOptionsWidget->AuthenticationDirectionComboBox->currentIndex();
        switch (authenticationDirectionIndex) {
        case 0:
            profile->setAuthenticationDirection("none");
            break;
        case 1:
            profile->setAuthenticationDirection("0");
            break;
        case 2:
            profile->setAuthenticationDirection("1");
            break;
        }

        if (ProfileOpenvpnOptionsWidget->RenegSecCheckBox->isChecked()) {
            profile->setUseRenegSec(true);
        } else {
            profile->setUseRenegSec(false);
        }
        profile->setRenegSec(ProfileOpenvpnOptionsWidget->RenegSecSpinBox->value());


        if (ProfileOpenvpnOptionsWidget->TunnelPingCheckBox->isChecked())
            profile->setUseTunnelPing(true);
        else
            profile->setUseTunnelPing(false);
        profile->setTunnelPing(ProfileOpenvpnOptionsWidget->TunnelPingSpinBox->value());

        if (ProfileOpenvpnOptionsWidget->TunnelPingRestartCheckBox->isChecked())
            profile->setUseTunnelPingRestart(true);
        else
            profile->setUseTunnelPingRestart(false);
        profile->setTunnelPing(ProfileOpenvpnOptionsWidget->TunnelPingSpinBox->value());

        profile->setDisableBind(ProfileOpenvpnOptionsWidget->DisableSocketBindCheckBox->isChecked());

        profile->setUseNsCertType(ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->isChecked());

        if (ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->currentText() == "client")
            profile->setNsCertType("client");
        else
            profile->setNsCertType("server");
    } // openvpn
    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun) {
        int authTypeIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
        switch (authTypeIndex) {
        case VpnAccountData::cert:
            profile->setAuthType(VpnAccountData::cert);
            break;
        case VpnAccountData::psk:
            profile->setAuthType(VpnAccountData::psk);
            break;
        }


        profile->setUseLocalPort(ProfileVtunOptionsWidget->PortCheckbox->isChecked());
        profile->setLocalPort(ProfileVtunOptionsWidget->PortSpinbox->value());

        if (ProfileVtunOptionsWidget->VtunProfileLineEdit->text().isEmpty()) {
            KMessageBox::error(this, i18n("No profile name entered."), i18n("No profile name"));
            canAccept = false;
        } else
            profile->setVtunProfile(ProfileVtunOptionsWidget->VtunProfileLineEdit->text());

        bool IPOk = true;
        if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked()) {
            QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
            if (Utils(GlobalConfig).isValidIPv4Address(LocalVirtualIp) == false) {
                KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No Valid IP Address"));
                IPOk = false;
            } else {
                profile->setLocalVirtualIP(LocalVirtualIp);
            }

            QString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();

            if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().toLower() == "tun") {
                if (Utils(GlobalConfig).isValidIPv4Address(RemoteVirtualIp) == false) {
                    KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No valid IP address"));
                    IPOk = false;
                } else {
                    profile->setRemoteVirtualIP(RemoteVirtualIp);
                }
            }
            if (IPOk)
                profile->setUseVirtualIP(true);
            else
                profile->setUseVirtualIP(false);
        }
    } // vtun
    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
        int authTypeIndex = ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex();
        switch (authTypeIndex) {
        case VpnAccountData::cert:
            profile->setAuthType(VpnAccountData::cert);
            break;
        case VpnAccountData::psk:
            profile->setAuthType(VpnAccountData::psk);
            break;
        }


        profile->setUseLocalPort(ProfileSshOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked());
        profile->setLocalPort(ProfileSshOptionsWidget->UserdefinedRemotePortSpinBox->value());

        bool IPOk = true;

        profile->setUseVirtualIP(ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());

        if (ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked()) {
            QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
            if (Utils(GlobalConfig).isValidIPv4Address(LocalVirtualIp) == false) {
                KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No Valid IP Address"));
                IPOk = false;
            } else {
                profile->setLocalVirtualIP(LocalVirtualIp);
            }


            QString RemoteVirtualIp = ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->text();

            if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentText().toLower() == "tun") {
                if (Utils(GlobalConfig).isValidIPv4Address(RemoteVirtualIp) == false) {
                    KMessageBox::error(this, i18n("No valid IP address entered."), i18n("No valid IP address"));
                    IPOk = false;
                } else {
                    profile->setRemoteVirtualIP(RemoteVirtualIp);
                }
            }
            if (IPOk)
                profile->setUseVirtualIP(true);
            else
                profile->setUseVirtualIP(false);
        } else {
            KMessageBox::error(this, i18n("Virtual IP address must be enabled."), i18n("Virtual IP address disabled"));
            IPOk = false;
        }
        profile->setUseRemotePort(ProfileSshOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked());
        profile->setRemotePort(ProfileSshOptionsWidget->UserdefinedRemotePortSpinBox->value());

        // password or key auth
        if (ProfileSshOptionsWidget->AuthPassRadioButton->isChecked()) {
            profile->setAuthWithUsernameAndPassword(true);
            //    KMessageBox::error ( this,"save: pass", "pass" );
        } else {
            profile->setAuthWithUsernameAndPassword(false);
            //    KMessageBox::error ( this,"save: key", "key" );
        }
        profile->setPreSharedKey(ProfileSshOptionsWidget->SshKeyComboBox->currentText());
        profile->setPreSharedKeyFile(ProfileSshOptionsWidget->CostumkeyURLRequester->url().path());

        if (ProfileSshOptionsWidget->CostumKeyRadioButton->isChecked()) {
            profile->setPskIsInFile(true);
        } else {
            profile->setPskIsInFile(false);
        }

        if (ProfileSshOptionsWidget->UseSshConfigRemoteScriptCheckBox->isChecked() && !ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->text().isEmpty()) {
            profile->setUseSshConfigRemoteScript(true);
            profile->setSshConfigRemoteScript(ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->text());
        } else
            profile->setUseSshConfigRemoteScript(false);

        if (ProfileSshOptionsWidget->UseSshConfigRemoteScriptCheckBox->isChecked() && ProfileSshOptionsWidget->SshConfigRemoteScriptLineEdit->text().isEmpty()) {
            KMessageBox::error(this, i18n("%1 cannot be empty." , QString(i18n("ssh config remote script")), i18n("%1 empty" , QString(i18n("ssh config remote script")))));
            IPOk = false;
        }

    } // ssh

    if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentIndex() == 1) {
        profile->setReplaceDefaultRoute(true);
    } else {
        profile->setReplaceDefaultRoute(false);
    }

    profile->setUseSmartcard(ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isChecked());

    profile->setAllowEmptyPrivateKeyPassword(ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->isChecked());
    profile->setAllowIpAddressChangeOfPeer(ProfileOpenvpnOptionsWidget->AllowIpAddressChangeOfPeerCheckBox->isChecked());

    profile->setUseConnectionStatusCheck(ProfileNetworkGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->isChecked());
    profile->setConnectionStatusCheckSuccessCount(ProfileNetworkGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->value());
    profile->setConnectionStatusInterval(ProfileNetworkGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->value());
    profile->setDoReconnectAfterConnectionLost(ProfileNetworkGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->isChecked());
    profile->setUseReconnectDelay(ProfileNetworkGeneralOptionsWidget->UseReconnectDelayCheckBox->isChecked());
    profile->setReconnectDelay(ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->value());
    profile->setUseDnsUpdate(ProfileNetworkGeneralOptionsWidget->UseDnsUpdateCheckBox->isChecked());

    profile->setLeftNextHop(ProfileIpsecOptionsWidget->LeftNextHopLineEdit->text());   //TODO check valid IP
    profile->setRightNextHop(ProfileIpsecOptionsWidget->RightNextHopLineEdit->text());    //TODO check valid IP
    profile->setUseRightNextHop(ProfileIpsecOptionsWidget->UseRightNextHopCheckBox->isChecked());
    profile->setUseLeftNextHop(ProfileIpsecOptionsWidget->UseLeftNextHopCheckBox->isChecked());

    profile->setSavePsk(ProfilePskOptionsWidget->CheckSavePsk->isChecked());
    profile->setSaveUserPassword(ProfileUserOptionsWidget->CheckUserPass->isChecked());
    profile->setUserName(ProfileUserOptionsWidget->UsernameLineEdit->text());

    if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
        profile->setUserPassword(ProfileUserOptionsWidget->PasswordEdit->text());
    else
        profile->setUserPassword("");

    if (ProfilePskOptionsWidget->CheckSavePsk->isChecked())
        profile->setPreSharedKey(ProfilePskOptionsWidget->PSKLineEdit->text());
    else
        profile->setPreSharedKey("");

    profile->setUseMailAddressAsIdentifier(ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->isChecked());

    profile->setGateway(ProfileGeneralOptionsWidget->gatewayLineEdit->text());
    profile->setPreSharedKey(ProfilePskOptionsWidget->PSKLineEdit->text());
    profile->setX509Certificate(ProfileCertOptionsWidget->x509certURLRequester->url().path());
    profile->setCertPath(ProfileCertOptionsWidget->certpathURLRequester->url().path());
    profile->setPrivateKeyPass(ProfileCertOptionsWidget->PrivkeyPasswordEdit->text());
    profile->setSavePrivateKeyPassword(ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked());
    profile->setNetworkDevice(ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->currentText());

	profile->setPingHostIP(ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text());
	if (ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked()) {
		if ( !ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text().isEmpty()) {
			profile->setDoPingIP(true);
		} else {
			KMessageBox::error(this,
							   i18n("No hostname/IP address (ping host) entered."),
									i18n("No hostname/IP address"));
									GlobalConfig->appendLogEntry(i18n("No hostname/IP address (ping host) entered."),
																	  KVpncEnum::error);
																	  canAccept = false;
		}
	} else {
		profile->setDoPingIP(false);
	}
	

	if ( ProfileNetworkNatOptionsWidget->UseNatCheckbox->isChecked() )
		profile->setUseNat( true );
	else
		profile->setUseNat( false );
	
    if (ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked())
        profile->setUseUdp(true);
    else
        profile->setUseUdp(false);

    if (ProfileNetworkNatOptionsWidget->UdpPortCheckbox->isChecked()) {
        profile->setUdpPort(ProfileNetworkNatOptionsWidget->UdpPortSpinbox->value());
        profile->setUseUdpPort(true);
    } else {
        profile->setUdpPort(0);
        profile->setUseUdpPort(false);
    }

    profile->setUseMtu(ProfileNetworkGeneralOptionsWidget->MtuCheckbox->isChecked());
    profile->setMtu(ProfileNetworkGeneralOptionsWidget->MtuSpinbox->value());
    profile->setUseMru(ProfileNetworkGeneralOptionsWidget->MruCheckbox->isChecked());
    profile->setMru(ProfileNetworkGeneralOptionsWidget->MruSpinbox->value());
    profile->setFixPathMtuDiscoveryProblem(ProfileNetworkGeneralOptionsWidget->FixPathMtuDiscoveryProblemCheckBox->isChecked());

    profile->setExecuteCmdBeforeConnect((ProfileCmdExecBeforeConnectOptionsWidget->main->ExcuteCmdBeforeConnectCheckBox->isChecked()));
    profile->setExecuteCmdAfterConnect((ProfileCmdExecAfterConnectOptionsWidget->main->ExcuteCmdAfterConnectCheckBox->isChecked()));
    profile->setExecuteCmdBeforeDisconnect((ProfileCmdExecBeforeDisconnectOptionsWidget->main->ExcuteCmdBeforeDisconnectCheckBox->isChecked()));
    profile->setExecuteCmdAfterDisconnect((ProfileCmdExecAfterDisconnectOptionsWidget->main->ExcuteCmdAfterDisconnectCheckBox->isChecked()));

    profile->setCommandBeforeConnect(ProfileCmdExecBeforeConnectOptionsWidget->main->CmdBeforeConnectTextEdit->toPlainText());
    profile->setCommandAfterConnect(ProfileCmdExecAfterConnectOptionsWidget->main->CmdAfterConnectTextEdit->toPlainText());
    profile->setCommandBeforeDisconnect(ProfileCmdExecBeforeDisconnectOptionsWidget->main->CmdBeforeDisconnectTextEdit->toPlainText());
    profile->setCommandAfterDisconnect(ProfileCmdExecAfterDisconnectOptionsWidget->main->CmdAfterDisconnectTextEdit->toPlainText());
    profile->setCommandAfterConnectDelayTime(ProfileCmdExecAfterConnectOptionsWidget->main->CommandAfterConnectDelayTimeNumInput->value());
	if (ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->currentIndex() == KVpncEnum::basic)
        profile->setHttpProxyAuthType("basic");
	if (ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->currentIndex() == KVpncEnum::ntlm)
        profile->setHttpProxyAuthType("ntlm");


    profile->setUseHttpProxy(ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked());
    profile->setHttpProxy(ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->text());
    profile->setHttpProxyPort(ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->value());
    profile->setHttpProxyTimeout(ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->value());
    profile->setHttpProxyPass(ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->text());
    profile->setHttpProxyUser(ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->text());

    if (ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked()) {
        if (ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->text().isEmpty()) {
            KMessageBox::error(this,
                               i18n("HTTP proxy server cannot be empty."),
                               i18n("Empty HTTP proxy server"));
            // GlobalConfig->appendLogEntry(i18n("HTTP proxy server cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
            profile->setUseHttpProxy(false);
        } else {
            profile->setUseHttpProxy(ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked());
        }

        if (ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->isChecked()) {
            if (ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->text().isEmpty()) {
                KMessageBox::error(this,
                                   i18n("Password for HTTP proxy authentication cannot be empty."),
                                   i18n("Empty HTTP proxy password for authentication"));
                // GlobalConfig->appendLogEntry(i18n("Password for HTTP proxy authentication cannot be empty."),
                //                              KVpncEnum::error);
                canAccept = false;
                profile->setUseHttpProxyAuth(false);
            }

            if (ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->text().isEmpty()) {
                KMessageBox::error(this,
                                   i18n("Username for HTTP proxy authentication cannot be empty."),
                                   i18n("Empty HTTP proxy username for authentication"));
                // GlobalConfig->appendLogEntry(i18n("Username for HTTP proxy authentication cannot be empty."),
                //                              KVpncEnum::error);
                canAccept = false;
                profile->setUseHttpProxyAuth(false);
            }
            if (canAccept == true)
                profile->setUseHttpProxyAuth(ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->isChecked());
        }


    }

    QStringList AdditionalNetworkRoutes;
    if (ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked())
        profile->setUseAdditionalNetworkRoutes(true);
    else
        profile->setUseAdditionalNetworkRoutes(false);

    if (ProfileNetworkRouteOptionsWidget->NetworkListView->topLevelItemCount() > 0) {
        QTreeWidgetItemIterator it(ProfileNetworkRouteOptionsWidget->NetworkListView);
        while (*it) {
            // example entry:
            // <network>/<netmask>#<gateway>
            QString network = QString((*it)->text(0) + "/" + (*it)->text(1));
            network.append("#");
            network.append((*it)->text(2));     // gateway
            network.append("#");
            network.append((*it)->text(3));     // interface
            AdditionalNetworkRoutes.append(network);
            ++it;
        }
    }

    profile->setAdditionalNetworkRoutes(AdditionalNetworkRoutes);

    profile->setUseSpecialServerCertificate(ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked());

    if (ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked()) {
        if (!ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->url().path().isEmpty()) {
            profile->setSpecialServerCertificate(ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->url().path());
        } else {
            KMessageBox::error(this,
                               i18n("Special server certificate cannot be empty."),
                               i18n("No Server Certificate"));
            // GlobalConfig->appendLogEntry(i18n("Special server certificate cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }
    }

    if (GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert &&
            ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isEnabled() &&
            ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isChecked()) {
        if (!ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText().isEmpty())
            profile->setPkcs11Slot(ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText());
        else {
            KMessageBox::error(this,
                               i18n("Slot at smartcard cannot be empty."),
                               i18n("No smartcard slot"));
            // GlobalConfig->appendLogEntry(i18n("Slot at smartcard cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }
        if (!ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->currentText().isEmpty()) {
            profile->setPkcs11Id(ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->currentText());
        } else {
            KMessageBox::error(this,
                               i18n("ID for certificate at smartcard cannot be empty."),
                               i18n("No certificate ID"));
            // GlobalConfig->appendLogEntry(i18n("ID for certificate at smartcard cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }
        QString Pkcs11SlotType = ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->currentText();
        if (Pkcs11SlotType == i18n("ID")) {
            profile->setPkcs11SlotType("id");
        } else if (Pkcs11SlotType == i18n("Name")) {
            profile->setPkcs11SlotType("name");
        } else {
            profile->setPkcs11SlotType("label");
        }

        QString Pkcs11IdType = ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->currentText();
        if (Pkcs11IdType == i18n("ID")) {
            profile->setPkcs11IdType("id");
        } else if (Pkcs11IdType == i18n("Label")) {
            profile->setPkcs11IdType("label");
        } else {
            profile->setPkcs11IdType("subject");
        }

        QString Pkcs11SignMode = ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->currentText();
        if (Pkcs11SignMode == i18n("auto")) {
            profile->setPkcs11SignMode("auto");
        } else if (Pkcs11SignMode == i18n("sign")) {
            profile->setPkcs11SignMode("sign");
        } else if (Pkcs11SignMode == i18n("recover")) {
            profile->setPkcs11SignMode("recover");
        } else {
            profile->setPkcs11SignMode("any");
        }
    }

    if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked()) {
        if (!ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().path().isEmpty()) {
            profile->setPkcs11Providers(ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().path());
        } else {
            KMessageBox::error(this,
                               i18n("Library path to lib for use with smartcard cannot be empty."),
                               i18n("No providers lib"));
            // GlobalConfig->appendLogEntry(i18n("Library path to lib for use with smartcard cannot be empty."),
            //                              KVpncEnum::error);
            canAccept = false;
        }
    }

    profile->setUsePkcs11Providers(ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked());
    profile->setDontSaveUsername(ProfileUserOptionsWidget->DontSaveUsernameCheckBox->isChecked());
    profile->setDisableCcp(ProfilePptpOptionsWidget->DisableCcpCheckbox->isChecked());

    if (!GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
        profile->setPskIsInFile(ProfilePskOptionsWidget->PskInFileCheckBox->isChecked());
    }

    if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentIndex() == 1) {
		profile->setTunnelDeviceType("tap");
    } else {
		profile->setTunnelDeviceType("tun");
    }

    profile->setAskUserPasswordOnEachConnect(ProfileUserOptionsWidget->AskUserPasswordOnEachConnectCheckBox->isChecked());

	GlobalConfig->saveOptions(true, profile->getName());
    GlobalConfig->appPointer->restoreOverrideCursor();

    // GlobalConfig->appendLogEntry(i18n("Profile \"%1\" saved.", QString(newName)),
    //                              KVpncEnum::debug);
    // enableButtonApply(false);
}

void PreferencesDialog::deleteSessionClicked()
{
    QString Name = ProfileGeneralSelector->currentText();

    ToolInfo *IpsecToolInfo = Utils(GlobalConfig).getToolInfo("ipsec") ;
    QString IpsecType;

    QString TypeString = i18n("unknown");
    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco)
        TypeString =  i18n("Cisco");
    else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ciscoorig)
        TypeString =  i18n("Cisco (proprietary)");
    else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp)
        TypeString =  i18n("PPTP");
    else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan) {
        if (IpsecToolInfo->Version.contains(QString("Openswan"), Qt::CaseInsensitive))
            IpsecType = TypeString =  i18n("Openswan");
        else if (IpsecToolInfo->Version.contains(QString("strongSwan"), Qt::CaseInsensitive))
            IpsecType = TypeString =  i18n("strongSwan");
        else
            IpsecType = TypeString =  i18n("FreeS/WAN");
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon)
        TypeString = "racoon";
    else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn)
        TypeString = "OpenVPN";
    else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
        TypeString = "L2TP (racoon)";
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan) {
        if (IpsecToolInfo->Version.contains(QString("Openswan"), Qt::CaseInsensitive))
            IpsecType = TypeString = "L2TP (Openswan)";
        else if (IpsecToolInfo->Version.contains(QString("strongSwan"), Qt::CaseInsensitive))
            IpsecType = TypeString = "L2TP (strongSwan)";
        else
            IpsecType = TypeString = "L2TP (FreeS/WAN)";
    } else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::vtun)
        TypeString = "Vtun";
    else if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh)
        TypeString = "SSH";

    if (!ProfileGeneralSelector->currentText().isEmpty()) {
        int result = KMessageBox::questionYesNo(this, i18n("Really delete \"%1\"?" ,  Name), i18n("Delete?"), KStandardGuiItem::del(), KStandardGuiItem::cancel());
        //LogOutput->append( "Result: "+ QString().setNum(result) ) ;
        if (result == 3) {        // Yes
            if (!GlobalConfig->AccountList->isEmpty()) {
                for (int accountIdx = 0; accountIdx < GlobalConfig->AccountList->size(); ++accountIdx) {
                    VpnAccountData *it = GlobalConfig->AccountList->at(accountIdx);
                    if (ProfileGeneralSelector->currentText().isEmpty()) {
                        // this->deleteSessionAction->setEnabled(false);
                        // this->advancedSessionAction->setEnabled(false);
                        // this->saveSessionAction->setEnabled(false);
                    } else {
                        if (it->getName() == Name) {
                            profileAddedOrDeleted = true;
                            GlobalConfig->removeEntry(GlobalConfig->currentProfile->getName());
                            ProfileGeneralSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileNetworkRouteSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileNetworkNatSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileNetworkHttpProxySelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileNetworkVirtualIpSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileCertSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileSmartcardSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfilePskSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileAuthenticationSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileUserSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileOpenvpnSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfilePptpSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileVtunSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileSshSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileRacoonSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileIpsecSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileCiscoSelector->removeItem(ProfileGeneralSelector->currentIndex());
							ProfileSpecificSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileCmdExecBeforeConnectSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileCmdExecBeforeDisconnectSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileCmdExecAfterConnectSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            ProfileCmdExecAfterDisconnectSelector->removeItem(ProfileGeneralSelector->currentIndex());
							ProfileCommandExecSelector->removeItem(ProfileGeneralSelector->currentIndex());
                            break;
                        }
                    }
                }
            }

            if (!GlobalConfig->AccountList->isEmpty()) {
                GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
				GlobalConfig->lastProfile = GlobalConfig->AccountList->first()->getName();
                ProfileGeneralSelector->setCurrentIndex(0);
                //ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setSelected(0, true);
                profileChanged(GlobalConfig->AccountList->first()->getName());
                connectionTypeChanged(GlobalConfig->AccountList->first() ->getConnectionType());
                authTypeChanged(GlobalConfig->AccountList->first()->getAuthType());
                //     buttonCancel->setEnabled( true );
                //     buttonOk->setEnabled( true );
            } else {
                ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled(false);
                ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled(false);
                ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled(false);
                GlobalConfig->lastProfile = "";
                GlobalConfig->currentProfile = 0L;
                //     CiscoPptpGroupBox->setEnabled( false );
                //    FreeswanRacoonGroupBox->setEnabled( false );
                //     OpenvpnGroupBox->setEnabled( false );
                //     GeneralGroupbox->setEnabled( false );
                //    CommandExecutionGroupBox->setEnabled( false );
            }

            //  slotStatusMsg ( i18n( "Profile \"%1\" deleted.", Name ), ID_FLASH_MSG );

            profileAddedOrDeleted = true;
            saveSessionClicked();
            GlobalConfig->removeEntry(Name);
            GlobalConfig->appendLogEntry(i18n("Profile \"%1\" deleted.", Name),
                                         KVpncEnum::debug);

#if 0
            saveOptions(); // TODO save, currently after closing dialog
            sessionToggled();
            if (ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty()) {
                ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setEnabled(false);
            }
#endif
        }
    }
}

void PreferencesDialog::newSessionClicked()
{
    // call new profile dialog...
    NewProfileDialog newdlg(GlobalConfig->appPointer, this, i18n("New profile"), GlobalConfig);
    newdlg.exec();
    if (newdlg.newProfileCreated) {
		VpnAccountData * it=0L;
		bool nameOk = false;
		bool ok;
		QString newName=newdlg.getName();
		QString Oldname =  newdlg.getName();
		while ( nameOk == false )
		{
			for (int accountIdx = 0; accountIdx < GlobalConfig->AccountList->size(); ++accountIdx) {
				VpnAccountData *it = GlobalConfig->AccountList->at(accountIdx);
				accountIdx = GlobalConfig->AccountList->count() - 1;
				if (it->getName() == newName) {
					//account->setName( QString( account->getName() + "_2" ) );
					// 				KMessageBox::information ( this, i18n( "Profile name exists.\n It will be renamed to \"%1\"." , account->getName() ), i18n( "Name exist, renamed" ) );
					KMessageBox::error ( this, i18n ( "Profile name exists." ), i18n ( "Name Exists" ) );
					
					newName = KInputDialog::getText ( i18n ( "New Name" ), i18n ( "New name for profile:" ), QString ( Oldname + "_2" ), &ok );
					if ( ok == false )
					{
						KMessageBox::information ( 0, i18n ( "Renaming the newly created profile was canceled." ) );
						GlobalConfig->appendLogEntry ( i18n ( "Renaming the newly created profile was canceled." ), KVpncEnum::info );
						return ;
					}
				}
				if ( newName.isEmpty() )
					nameOk=false;
				else
					nameOk = true;
			}
			if ( newName.isEmpty() )
				nameOk=false;
			else
				nameOk = true;
		}
		
		if (nameOk)
		{
			if (GlobalConfig->KvpncDebugLevel > 3)
				GlobalConfig->appendLogEntry ( i18n( "New created profile \"%1\" found in profile list.", newName ), KVpncEnum::debug );
			
			profileAddedOrDeleted = true;
			ProfileGeneralSelector->addItem( newName);
			ProfileNetworkRouteSelector->addItem( newName);
			ProfileNetworkNatSelector->addItem( newName);
			ProfileNetworkHttpProxySelector->addItem( newName);
			ProfileNetworkVirtualIpSelector->addItem( newName);
			ProfileCertSelector->addItem( newName);
			ProfileSmartcardSelector->addItem( newName);
			ProfilePskSelector->addItem( newName);
			ProfileAuthenticationSelector->addItem( newName);
			ProfileUserSelector->addItem( newName);
			ProfileOpenvpnSelector->addItem( newName);
			ProfilePptpSelector->addItem( newName);
			ProfileVtunSelector->addItem( newName);
			ProfileSshSelector->addItem( newName);
			ProfileRacoonSelector->addItem( newName);
			ProfileIpsecSelector->addItem( newName);
			ProfileCiscoSelector->addItem( newName);
			ProfileSpecificSelector->addItem( newName);
			ProfileCmdExecBeforeConnectSelector->addItem( newName);
			ProfileCmdExecBeforeDisconnectSelector->addItem( newName);
			ProfileCmdExecAfterConnectSelector->addItem( newName);
			ProfileCmdExecAfterDisconnectSelector->addItem( newName);
			ProfileCommandExecSelector->addItem( newName);

			slotProfileCreated(newName);
			
			GlobalConfig->currentProfile = it;

			ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled(true);
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled(true);
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled(true);

			// CiscoPptpGroupBox->setEnabled(true);
			// FreeswanRacoonGroupBox->setEnabled(true);
			// OpenvpnGroupBox->setEnabled(true);
			// GeneralGroupbox->setEnabled(true);
			// CommandExecutionGroupBox->setEnabled(true);

			KMessageBox::information(this,
									i18n("Profile \"%1\" added.\n"
										"Now set the right type,\n"
										"fill in the fields\n"
										"and press \"Save\" to complete the profile.", newName),
									i18n("Complete Profile"));
			// slotStatusMsg(i18n("Profile \"%1\" added.", Name), ID_FLASH_MSG);

			GlobalConfig->appendLogEntry(i18n("Profile \"%1\" added.", newName),
										KVpncEnum::debug);
			profileAddedOrDeleted = true;
			configChanged = true;
			NewProfileName = newName;
			profileChanged(newName);
			connectionTypeChanged(ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentIndex());
			authTypeChanged(ProfileCertOptionsWidget->AuthTypeComboBox->currentIndex());
			authTypeChanged(ProfilePskOptionsWidget->AuthTypeComboBox->currentIndex());
			saveSessionClicked();
		}
		else
		{
			GlobalConfig->appendLogEntry ( i18n ( "Renaming the newly created profile was canceled." ), KVpncEnum::info );
			slotStatusMsg ( i18n ( "Creating new profile canceled." ), ID_FLASH_MSG );
			GlobalConfig->appendLogEntry ( i18n ( "Creating new profile canceled." ), KVpncEnum::info );
		}
	}
    else {
        GlobalConfig->appendLogEntry(i18n("Creation of the new profile canceled."),
                                     KVpncEnum::debug);
    }
}

void PreferencesDialog::renameSessionClicked()
{
    bool ok = true;
    bool nameOk = false;
    QString oldName = GlobalConfig->currentProfile->getName();
    QString *newName;

    while (nameOk == false) {
        newName = new QString(KInputDialog::getText(i18n("New Name"),
                              i18n("Enter new name for profile:"),
                              oldName,
                              &ok,
                              this));
        if (newName->contains(QChar(' '), Qt::CaseInsensitive)) {
            KMessageBox::error(this,
                               i18n("Blanks are not allowed in profile names."),
                               i18n("Illegal Character in Name"));
            GlobalConfig->appendLogEntry(i18n("Blanks are not allowed in profile names."),
                                         KVpncEnum::error);
            ok = false;
        }
        if (*newName == oldName) {
#if 0
            KMessageBox::error(this,
                               i18n("Profile name cannot be the same."),
                               i18n("Same name"));
            GlobalConfig->appendLogEntry(i18n("Profile name cannot be the same."),
                                         KVpncEnum::error);
#endif
            ok = false;
            nameOk = true;
        } else {
            nameOk = true;
        }
    }
    if (ok) {
        profileAddedOrDeleted = true;
        GlobalConfig->currentProfile->setName(*newName);
        ProfileGeneralSelector->clear();
        ProfileNetworkRouteSelector->clear();
        ProfileNetworkNatSelector->clear();
        ProfileNetworkHttpProxySelector->clear();
        ProfileNetworkVirtualIpSelector->clear();
        ProfileCertSelector->clear();
        ProfileSmartcardSelector->clear();
        ProfilePskSelector->clear();
        ProfileAuthenticationSelector->clear();
        ProfileUserSelector->clear();
        ProfileOpenvpnSelector->clear();
        ProfilePptpSelector->clear();
        ProfileVtunSelector->clear();
        ProfileSshSelector->clear();
        ProfileRacoonSelector->clear();
        ProfileIpsecSelector->clear();
        ProfileCiscoSelector->clear();
		ProfileSpecificSelector->clear();
        ProfileCmdExecBeforeConnectSelector->clear();
        ProfileCmdExecBeforeDisconnectSelector->clear();
        ProfileCmdExecAfterConnectSelector->clear();
        ProfileCmdExecAfterDisconnectSelector->clear();
		ProfileCommandExecSelector->clear();

        if (!GlobalConfig->AccountList->isEmpty()) {
            for (int accountIdx = 0; accountIdx < GlobalConfig->AccountList->size(); ++accountIdx) {
                VpnAccountData *it = GlobalConfig->AccountList->at(accountIdx);
                if (it != 0) {
                    ProfileGeneralSelector->addItem(it->getName());
                    ProfileSpecificSelector->addItem(it->getName());
                    ProfileCommandExecSelector->addItem(it->getName());
                    ProfileAuthenticationSelector->addItem(it->getName());
                    ProfileNetworkRouteSelector->addItem(it->getName());
                    ProfileNetworkNatSelector->addItem(it->getName());
                    ProfileNetworkHttpProxySelector->addItem(it->getName());
                    ProfileNetworkVirtualIpSelector->addItem(it->getName());
                    ProfileCertSelector->addItem(it->getName());
                    ProfileSmartcardSelector->addItem(it->getName());
                    ProfilePskSelector->addItem(it->getName());
                    ProfileAuthenticationSelector->addItem(it->getName());
                    ProfileUserSelector->addItem(it->getName());
                    ProfileOpenvpnSelector->addItem(it->getName());
                    ProfilePptpSelector->addItem(it->getName());
                    ProfileVtunSelector->addItem(it->getName());
                    ProfileRacoonSelector->addItem(it->getName());
                    ProfileIpsecSelector->addItem(it->getName());
                    ProfileCiscoSelector->addItem(it->getName());
					ProfileSpecificSelector->addItem(it->getName());
                    ProfileCmdExecBeforeConnectSelector->addItem(it->getName());
                    ProfileCmdExecBeforeDisconnectSelector->addItem(it->getName());
                    ProfileCmdExecAfterConnectSelector->addItem(it->getName());
                    ProfileCmdExecAfterDisconnectSelector->addItem(it->getName());
					ProfileCommandExecSelector->addItem(it->getName());
					slotProfileCreated(it->getName());
					
					ProfileGeneralSelector->model()->sort(0);
					ProfileAuthenticationSelector->model()->sort(0);
					ProfileUserSelector->model()->sort(0);
					ProfileCertSelector->model()->sort(0);
					ProfileSmartcardSelector->model()->sort(0);
					ProfilePskSelector->model()->sort(0);
					ProfileNetworkGeneralSelector->model()->sort(0);
					ProfileNetworkRouteSelector->model()->sort(0);
					ProfileNetworkNatSelector->model()->sort(0);
					ProfileNetworkHttpProxySelector->model()->sort(0);
					ProfileNetworkVirtualIpSelector->model()->sort(0);
					ProfileSpecificSelector->model()->sort(0);
					ProfileCiscoSelector->model()->sort(0);
					ProfileRacoonSelector->model()->sort(0);
					ProfileIpsecSelector->model()->sort(0);
					ProfileOpenvpnSelector->model()->sort(0);
					ProfilePptpSelector->model()->sort(0);
					ProfileVtunSelector->model()->sort(0);
					ProfileSshSelector->model()->sort(0);
					ProfileCommandExecSelector->model()->sort(0);
					ProfileCmdExecBeforeConnectSelector->model()->sort(0);
					ProfileCmdExecAfterConnectSelector->model()->sort(0);
					ProfileCmdExecBeforeDisconnectSelector->model()->sort(0);
					ProfileCmdExecAfterDisconnectSelector->model()->sort(0);
					
					
                }
            }
            ProfileGeneralSelector->model()->sort(0);
			ProfileAuthenticationSelector->model()->sort(0);
			ProfileUserSelector->model()->sort(0);
			ProfileCertSelector->model()->sort(0);
			ProfileSmartcardSelector->model()->sort(0);
			ProfilePskSelector->model()->sort(0);
			ProfileNetworkGeneralSelector->model()->sort(0);
			ProfileNetworkRouteSelector->model()->sort(0);
			ProfileNetworkNatSelector->model()->sort(0);
			ProfileNetworkHttpProxySelector->model()->sort(0);
			ProfileNetworkVirtualIpSelector->model()->sort(0);
			ProfileSpecificSelector->model()->sort(0);
			ProfileCiscoSelector->model()->sort(0);
			ProfileRacoonSelector->model()->sort(0);
			ProfileIpsecSelector->model()->sort(0);
			ProfileOpenvpnSelector->model()->sort(0);
			ProfilePptpSelector->model()->sort(0);
			ProfileVtunSelector->model()->sort(0);
			ProfileSshSelector->model()->sort(0);
			ProfileCommandExecSelector->model()->sort(0);
			ProfileCmdExecBeforeConnectSelector->model()->sort(0);
			ProfileCmdExecAfterConnectSelector->model()->sort(0);
			ProfileCmdExecBeforeDisconnectSelector->model()->sort(0);
			ProfileCmdExecAfterDisconnectSelector->model()->sort(0);
        }

        if (!showOnlyProfiles) {
            ConnectOptionsWidget->AutoConnectProfileComboBox->clear();
            for (int autoConnectProfileIdx = 1; autoConnectProfileIdx < GlobalConfig->AccountList->count();autoConnectProfileIdx++) {
                ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem(autoConnectProfileIdx, GlobalConfig->AccountList->at(autoConnectProfileIdx)->getName());
            }
        }
        profileAddedOrDeleted = true;
        configChanged = true;

        GlobalConfig->lastProfile = QString(*newName);

        saveSessionClicked();
        GlobalConfig->removeEntry(oldName);

        KMessageBox::information(0,
                                 i18n("Rename of \"%1\" to \"%2\" was successful.",
                                      oldName,
                                      GlobalConfig->currentProfile->getName()));
        GlobalConfig->appendLogEntry(i18n("Profile \"%1\" renamed to \"%2\"." ,
                                          oldName ,
                                          *newName),
                                     KVpncEnum::debug);
    }
}

void PreferencesDialog::importCertificate()
{
    ImportCertificateDialog dlg(this, i18n("Import certificate...").toAscii(), GlobalConfig);
    //int result =
    dlg.exec();
}

void PreferencesDialog::pageChanged(KPageWidgetItem *page, KPageWidgetItem *before)
{
    prev_page = before;
    current_page = page;

    if (KvpncDebugLevel > 5) {
        GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged()", KVpncEnum::debug);
    }
    bool page_data_changed = false;

    if (!showOnlyProfiles) {
        if (prev_page == ConfigConnectOptionsFrame && ConnectOptionsWidget->dialogModified) {
            page_data_changed = true;
            ConnectOptionsWidget->dialogModified = false;
            if (GlobalConfig->KvpncDebugLevel > 5) {
                GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ConnectOptionsWidget modified", KVpncEnum::debug);
            }
        } else if (prev_page == ConfigDaemonOptionsFrame && ConfigDaemonOptionsWidget->dialogModified) {
            page_data_changed = true;
            ConfigDaemonOptionsWidget->dialogModified = false;
            if (GlobalConfig->KvpncDebugLevel > 5) {
                GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ConfigDaemonOptionsWidget modified", KVpncEnum::debug);
            }
        } else if (prev_page == DebugOptionsFrame && DebugOptionsWidget->dialogModified) {
            page_data_changed = true;
            DebugOptionsWidget->dialogModified = false;
            if (GlobalConfig->KvpncDebugLevel > 5) {
                GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() DebugOptionsWidget modified", KVpncEnum::debug);
            }
        } else if (prev_page == LogOptionsFrame && LogOptionsWidget->dialogModified) {
            page_data_changed = true;
            LogOptionsWidget->dialogModified = false;
            if (GlobalConfig->KvpncDebugLevel > 5) {
                GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() LogOptionsWidget modified", KVpncEnum::debug);
            }
        } else if (prev_page == HelperProgramOptionsFrame && HelperProgramOptionsWidget->dialogModified) {
            page_data_changed = true;
            HelperProgramOptionsWidget->dialogModified = false;
            if (GlobalConfig->KvpncDebugLevel > 5) {
                GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() HelperProgramOptionsWidget modified", KVpncEnum::debug);
            }
        }
    }

    if (prev_page == ProfileNetworkRouteOptionsFrame && ProfileNetworkRouteOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileNetworkRouteOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileNetworkRouteOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileGeneralOptionsFrame && ProfileGeneralOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileGeneralOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileGeneralOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileCertOptionsFrame && ProfileCertOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileCertOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileCertOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileCiscoOptionsFrame && ProfileCiscoOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileCiscoOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileCiscoOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileNetworkHttpProxyOptionsFrame && ProfileNetworkHttpProxyOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileNetworkHttpProxyOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileNetworkHttpProxyOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileCmdExecAfterConnectOptionsFrame && ProfileCmdExecAfterConnectOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileCmdExecAfterConnectOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileCmdExecAfterConnectOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileCmdExecAfterDisconnectOptionsFrame && ProfileCmdExecAfterDisconnectOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileCmdExecAfterDisconnectOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileCmdExecAfterDisconnectOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileCmdExecBeforeConnectOptionsFrame && ProfileCmdExecBeforeConnectOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileCmdExecBeforeConnectOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileCmdExecBeforeConnectOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileCmdExecBeforeDisconnectOptionsFrame && ProfileCmdExecBeforeDisconnectOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileCmdExecBeforeDisconnectOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileCmdExecBeforeDisconnectOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileNetworkNatOptionsFrame && ProfileNetworkNatOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileNetworkNatOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileNetworkNatOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileNetworkRouteOptionsFrame && ProfileNetworkRouteOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileNetworkRouteOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileNetworkRouteOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileNetworkVirtualIpOptionsFrame && ProfileNetworkVirtualIpOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileNetworkVirtualIpOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileNetworkVirtualIpOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileOpenvpnOptionsFrame && ProfileOpenvpnOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileOpenvpnOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileOpenvpnOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfilePptpOptionsFrame && ProfilePptpOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfilePptpOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfilePptpOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfilePskOptionsFrame && ProfilePskOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfilePskOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfilePskOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileIpsecOptionsFrame && ProfileIpsecOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileIpsecOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileIpsecOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileSshOptionsFrame && ProfileSshOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileSshOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileSshOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileSmartcardOptionsFrame && ProfileSmartcardOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileSmartcardOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ConnectOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileVtunOptionsFrame && ProfileVtunOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileVtunOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileVtunOptionsWidget modified", KVpncEnum::debug);
        }
    } else if (prev_page == ProfileNetworkGeneralOptionsFrame && ProfileNetworkGeneralOptionsWidget->dialogModified) {
        page_data_changed = true;
        ProfileNetworkGeneralOptionsWidget->dialogModified = false;
        if (GlobalConfig->KvpncDebugLevel > 5) {
            GlobalConfig->appendLogEntry("PreferencesDialog::pageChanged() ProfileNetworkGeneralOptionsWidget modified", KVpncEnum::debug);
        }
    }




    if (page_data_changed) {
        saveSessionClicked();
    }

    profileChanged(lastProfileName);
}

void PreferencesDialog::userAuthToggled(bool)
{
    if (ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked())
        ProfileUserOptionsWidget->setEnabled(true);
    else
        ProfileUserOptionsWidget->setEnabled(false);
}

void PreferencesDialog::useUdpToggled(bool)
{
    if (ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked()) {
        ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->setEnabled(true);
        ProfileOpenvpnOptionsWidget->userdefiniedPacketSizeToggled(ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked());
        ProfileOpenvpnOptionsWidget->userdefiniedFragmentationSizeToggled(ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked());
    } else {
        ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->setEnabled(false);
        ProfileOpenvpnOptionsWidget->userdefiniedPacketSizeToggled(ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked());
        ProfileOpenvpnOptionsWidget->userdefiniedFragmentationSizeToggled(ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked());
    }
}

void PreferencesDialog::OpenvpnPathChanged(const KUrl &)
{
    ToolInfo * OpenvpnInfo = Utils(GlobalConfig).getToolInfo("openvpn");
    //  OpenvpnInfo->PathToExec = ConfigDaemonOptionsWidget->OpenvpnPathInput->url().path();
    //  GlobalConfig->pathToOpenvpn = ConfigDaemonOptionsWidget->OpenvpnPathInput->url().path();
    //  OpenvpnInfo->addSearchPath(ConfigDaemonOptionsWidget->OpenvpnPathInput->url().path());
    OpenvpnInfo->TryPath_first = ConfigDaemonOptionsWidget->OpenvpnPathInput->url().path();
    OpenvpnInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->OpenvpnVersionLineEdit->setText(OpenvpnInfo->Version);

    if (OpenvpnInfo->found)
        ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::FreeswanPathChanged(const KUrl &)
{
    //  KMessageBox::information(0,"path changed","Freeswan");

    ToolInfo * IpsecInfo = Utils(GlobalConfig).getToolInfo("ipsec");
    //  IpsecInfo->removeSearchPath( IpsecInfo->PathToExec );
    //  IpsecInfo->PathToExec = ConfigDaemonOptionsWidget->FreeswanPathInput->url().path();
    //  GlobalConfig->pathToIpsec = ConfigDaemonOptionsWidget->FreeswanPathInput->url().path();
    //  IpsecInfo->addSearchPath(ConfigDaemonOptionsWidget->FreeswanPathInput->url().path());
    IpsecInfo->TryPath_first = ConfigDaemonOptionsWidget->FreeswanPathInput->url().path();
    IpsecInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->IpsecVersionLineEdit->setText(IpsecInfo->Version);

    if (IpsecInfo->found)
        ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::PppdPathChanged(const KUrl &)
{
    //  KMessageBox::information(0,"path changed","Pppd");

    ToolInfo * PppdInfo = Utils(GlobalConfig).getToolInfo("pppd");
    //  PppdInfo->removeSearchPath( PppdInfo->PathToExec );
    //  PppdInfo->PathToExec = ConfigDaemonOptionsWidget->PppdPathInput->url().path();
    //  GlobalConfig->pathToPppd = ConfigDaemonOptionsWidget->PppdPathInput->url().path();
    //  PppdInfo->addSearchPath(ConfigDaemonOptionsWidget->PppdPathInput->url().path());
    PppdInfo->TryPath_first = ConfigDaemonOptionsWidget->PppdPathInput->url().path();
    PppdInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->PppdVersionLineEdit->setText(PppdInfo->Version);

    if (PppdInfo->found)
        ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->PppdStatePixmapLabel->setPixmap(wrong_icon);
}


void PreferencesDialog::PptpPathChanged(const KUrl &)
{
    //  KMessageBox::information(0,"path changed","Pptp");

    ToolInfo * PptpInfo = Utils(GlobalConfig).getToolInfo("pptp");
    //  PptpInfo->PathToExec = ConfigDaemonOptionsWidget->PptpPathInput->url().path();
    //  GlobalConfig->pathToPptp = ConfigDaemonOptionsWidget->PptpPathInput->url().path();
    //  PptpInfo->removeSearchPath( PptpInfo->PathToExec );
    //  PptpInfo->addSearchPath(ConfigDaemonOptionsWidget->PptpPathInput->url().path());
    PptpInfo->TryPath_first = ConfigDaemonOptionsWidget->PptpPathInput->url().path();
    PptpInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->PptpVersionLineEdit->setText(PptpInfo->Version);

    if (PptpInfo->found)
        ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->PptpStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::RacoonPathChanged(const KUrl &)
{
    //  KMessageBox::information(0,"path changed","Racoon");

    ToolInfo * RacoonInfo = Utils(GlobalConfig).getToolInfo("racoon");
    //  RacoonInfo->removeSearchPath( RacoonInfo->PathToExec );
    //  RacoonInfo->PathToExec = ConfigDaemonOptionsWidget->RacoonPathInput->url().path();
    //  GlobalConfig->pathToRacoon = ConfigDaemonOptionsWidget->RacoonPathInput->url().path();
    //  RacoonInfo->addSearchPath(ConfigDaemonOptionsWidget->RacoonPathInput->url().path());
    RacoonInfo->TryPath_first = ConfigDaemonOptionsWidget->RacoonPathInput->url().path();
    RacoonInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->RacoonVersionLineEdit->setText(RacoonInfo->Version);

    QPixmap ok_icon = KIconLoader::global() ->loadIcon("dialog-ok", KIconLoader::NoGroup);
    QPixmap wrong_icon = KIconLoader::global() ->loadIcon("dialog-cancel", KIconLoader::NoGroup);

    if (RacoonInfo->found)
        ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::VpncPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","Vpnc");

    ToolInfo * VpncInfo = Utils(GlobalConfig).getToolInfo("vpnc");

    //  VpncInfo->removeSearchPath( VpncInfo->PathToExec );

    //  VpncInfo->PathToExec = ConfigDaemonOptionsWidget->VpncPathInput->url().path();
    //  GlobalConfig->pathToVpnc = ConfigDaemonOptionsWidget->VpncPathInput->url().path();
    //  KMessageBox::information(0,VpncInfo->PathToExec,"vpnc path");
    //  VpncInfo->addSearchPath(ConfigDaemonOptionsWidget->VpncPathInput->url().path());
    VpncInfo->TryPath_first = ConfigDaemonOptionsWidget->VpncPathInput->url().path();
    VpncInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->VpncVersionLineEdit->setText(VpncInfo->Version);
    //  KMessageBox::information(0,VpncInfo->Version,"vpnc version");

    if (VpncInfo->found)
        ConfigDaemonOptionsWidget->VpncStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->VpncStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::CiscoVpncPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","Vpnc");

    ToolInfo * CiscoVpncInfo = Utils(GlobalConfig).getToolInfo("vpnclient");

    //  CiscoVpncInfo->removeSearchPath( CiscoVpncInfo->PathToExec );

    //  CiscoVpncInfo->PathToExec = ConfigDaemonOptionsWidget->CiscoVpncPathInput->url().path();
    //  GlobalConfig->pathToCiscoVpnc = ConfigDaemonOptionsWidget->CiscoVpncPathInput->url().path();
    //  KMessageBox::information(0,VpncInfo->PathToExec,"vpnclient (proprietary) path");
    //  CiscoVpncInfo->addSearchPath(ConfigDaemonOptionsWidget->CiscoVpncPathInput->url().path());
    CiscoVpncInfo->TryPath_first = ConfigDaemonOptionsWidget->CiscoVpncPathInput->url().path();
    CiscoVpncInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->CiscoVpncVersionLineEdit->setText(CiscoVpncInfo->Version);
    //  KMessageBox::information(0,CiscoVpncInfo->Version,"vpnclient version");

    if (CiscoVpncInfo->found)
        ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->CiscoVpncStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::L2tpdPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","L2tpd");

    ToolInfo * L2tpdInfo = Utils(GlobalConfig).getToolInfo("l2tpd");

    //  L2tpdInfo->removeSearchPath( L2tpdInfo->PathToExec );

    //  L2tpdInfo->PathToExec = ConfigDaemonOptionsWidget->L2tpdPathInput->url().path();
    //  GlobalConfig->pathToL2tpd = ConfigDaemonOptionsWidget->L2tpdPathInput->url().path();
    //  KMessageBox::information(0,L2tpdInfo->PathToExec,"l2tpd path");
    //  L2tpdInfo->addSearchPath(ConfigDaemonOptionsWidget->L2tpdPathInput->url().path());
    L2tpdInfo->TryPath_first = ConfigDaemonOptionsWidget->L2tpdPathInput->url().path();

    L2tpdInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->L2tpdVersionLineEdit->setText(L2tpdInfo->Version);
    //  KMessageBox::information(0,L2tpdInfo->Version,"l2tpd version");

    if (L2tpdInfo->found)
        ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::Xl2tpdPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","Xl2tpd");

    ToolInfo * Xl2tpdInfo = Utils(GlobalConfig).getToolInfo("l2tpd");

    //  Xl2tpdInfo->removeSearchPath( Xl2tpdInfo->PathToExec );

    //  Xl2tpdInfo->PathToExec = ConfigDaemonOptionsWidget->Xl2tpdPathInput->url().path();
    //  GlobalConfig->pathToXl2tpd = ConfigDaemonOptionsWidget->Xl2tpdPathInput->url().path();
    //  KMessageBox::information(0,Xl2tpdInfo->PathToExec,"l2tpd path");
    //  Xl2tpdInfo->addSearchPath(ConfigDaemonOptionsWidget->Xl2tpdPathInput->url().path());
    Xl2tpdInfo->TryPath_first = ConfigDaemonOptionsWidget->Xl2tpdPathInput->url().path();

    Xl2tpdInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->Xl2tpdVersionLineEdit->setText(Xl2tpdInfo->Version);
    //  KMessageBox::information(0,Xl2tpdInfo->Version,"l2tpd version");

    if (Xl2tpdInfo->found)
        ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->Xl2tpdStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::Openl2tpPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","Openl2tp");

    ToolInfo * Openl2tpInfo = Utils(GlobalConfig).getToolInfo("openl2tpd");

    //  Openl2tpInfo->removeSearchPath( Openl2tpInfo->PathToExec );

    //  Openl2tpInfo->PathToExec = ConfigDaemonOptionsWidget->Openl2tpPathInput->url().path();
    //  GlobalConfig->pathToOpenl2tp = ConfigDaemonOptionsWidget->Openl2tpPathInput->url().path();
    //  KMessageBox::information(0,Openl2tpInfo->PathToExec,"l2tpd path");
    //  Openl2tpInfo->addSearchPath(ConfigDaemonOptionsWidget->Openl2tpPathInput->url().path());
    Openl2tpInfo->TryPath_first = ConfigDaemonOptionsWidget->Openl2tpPathInput->url().path();

    Openl2tpInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->Openl2tpVersionLineEdit->setText(Openl2tpInfo->Version);
    //  KMessageBox::information(0,Openl2tpInfo->Version,"openl2tp version");

    if (Openl2tpInfo->found)
        ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->Openl2tpStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::VtundPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","vtund");

    ToolInfo * VtunInfo = Utils(GlobalConfig).getToolInfo("vtund");

    //  VtunInfo->removeSearchPath( Xl2tpdInfo->PathToExec );

    //  VtunInfo->PathToExec = ConfigDaemonOptionsWidget->VtunddPathInput->url().path();
    //  GlobalConfig->pathToXl2tpd = ConfigDaemonOptionsWidget->VtunddPathInput->url().path();
    //  KMessageBox::information(0,Xl2tpdInfo->PathToExec,"vtund path");
    //  VtunInfo->addSearchPath(ConfigDaemonOptionsWidget->VtunddPathInput->url().path());
    VtunInfo->TryPath_first = ConfigDaemonOptionsWidget->VtundPathInput->url().path();

    VtunInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->Xl2tpdVersionLineEdit->setText(VtunInfo->Version);
    //  KMessageBox::information(0,Xl2tpdInfo->Version,"vtun version");

    if (VtunInfo->found)
        ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->VtundStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::SshPathChanged(const KUrl &)
{
    //   KMessageBox::information(0,"path changed","ssh");

    ToolInfo * SshInfo = Utils(GlobalConfig).getToolInfo("ssh");

    //  SshInfo->removeSearchPath( SshInfo->PathToExec );

    //  SshInfo->PathToExec = ConfigDaemonOptionsWidget->SshdPathInput->url().path();
    //  GlobalConfig->pathToXl2tpd = ConfigDaemonOptionsWidget->SshdPathInput->url().path();
    //  KMessageBox::information(0,Xl2tpdInfo->PathToExec,"ssh path");
    //  SshInfo->addSearchPath(ConfigDaemonOptionsWidget->SshdPathInput->url().path());
    SshInfo->TryPath_first = ConfigDaemonOptionsWidget->SshPathInput->url().path();

    SshInfo->collectToolInfo();

    ConfigDaemonOptionsWidget->SshVersionLineEdit->setText(SshInfo->Version);
    //  KMessageBox::information(0,SshInfo->Version,"ssh version");

    if (SshInfo->found)
        ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap(ok_icon);
    else
        ConfigDaemonOptionsWidget->SshStatePixmapLabel->setPixmap(wrong_icon);
}

void PreferencesDialog::showEvent(QShowEvent* e)
{
    Q_UNUSED(e);
    // KDialogBase::showEvent(e);

//     QSplitter* splitter = findChild<QSplitter *>();
//     K3ListView* listView = findChild<K3ListView *>();
// 
//     if (splitter && listView) {
//         int visible = listView->visibleWidth();
//         int content = listView->contentsWidth();
// 
//         if (visible < content) {
//             int shiftSplitterBy = content - visible;
//             resize(width() + shiftSplitterBy, height());
//             QList<int> oldSizes = splitter->sizes();
//             QList<int> newSizes;
//             newSizes << oldSizes[0] + shiftSplitterBy << oldSizes[1] - shiftSplitterBy;
//             splitter->setSizes(newSizes);
//         }
//     }
}

void PreferencesDialog::detectPkcs11Ids()
{
    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));
    ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->clear();

    int pkcs11IdTypeIndex = ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->currentIndex();
    QString Pkcs11IdTypeTmp;
    switch (pkcs11IdTypeIndex) {
    case 0:
        Pkcs11IdTypeTmp = "id";
        if (KvpncDebugLevel > 1) {
            GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1", Pkcs11IdTypeTmp),
                                         KVpncEnum::debug);
        }
        break;
    case 1:
        Pkcs11IdTypeTmp = "label";
        if (KvpncDebugLevel > 1) {
            GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1", Pkcs11IdTypeTmp),
                                         KVpncEnum::debug);
        }
        break;
    default:
        Pkcs11IdTypeTmp = "subject";
        if (KvpncDebugLevel > 1) {
            GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1", Pkcs11IdTypeTmp),
                                         KVpncEnum::debug);
        }
        break;
    }

    QString ProviderLib = "";
    if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked() &&
            !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().path().isEmpty()) {
        ProviderLib = ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().path();
    }

    // we have to split slot id and name ("0 : foobar") => 0
    QString Pkcs11Slot = ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText().section(':', 0, 0).trimmed();

    QStringList Pkcs11Ids = Utils(GlobalConfig).getSmartcardCertsFromSlot(Pkcs11Slot, Pkcs11IdTypeTmp, ProviderLib);
    int pkcs11IdIdx = 0;
    for (QStringList::Iterator it = Pkcs11Ids.begin(); it != Pkcs11Ids.end(); ++it) {
        ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->insertItem(pkcs11IdIdx, QString(*it));
        pkcs11IdIdx++;
    }

    GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::detectPkcs11Slots()
{
    GlobalConfig->appPointer->setOverrideCursor(QCursor(Qt::WaitCursor));
    ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->clear();
    QString ProviderLib = "";
    if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked() && !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().path().isEmpty())
        ProviderLib = ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().path();
    QStringList Pkcs11Slots = Utils(GlobalConfig).getSmartcardSlots(ProviderLib);
    int pkcs11SlotsIdx = 0;
    for (QStringList::Iterator it = Pkcs11Slots.begin(); it != Pkcs11Slots.end(); ++it) {
        ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->insertItem(pkcs11SlotsIdx, QString(*it));
        pkcs11SlotsIdx++;
    }
    GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::localPortToggled(bool)
{
    if (ProfileCiscoOptionsWidget->LocalPortCheckbox->isChecked())
        ProfileCiscoOptionsWidget->LocalPortSpinbox->setEnabled(true);
    else
        ProfileCiscoOptionsWidget->LocalPortSpinbox->setEnabled(false);
}

void PreferencesDialog::useSpecialServerSmartcardificateToggled(bool)
{
#if 0
    if (ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox->isChecked()) {
        ProfileSmartcardOptionsWidget->SpecialServerSmartcardificateURLRequester->setEnabled(true);
    } else {
        ProfileSmartcardOptionsWidget->SpecialServerSmartcardificateURLRequester->setEnabled(false);
    }
#endif
}

void PreferencesDialog::applicationVersionToggled(bool)
{
    if (ProfileCiscoOptionsWidget->ApplicationVersionCheckbox->isChecked())
        ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled(true);
    else
        ProfileCiscoOptionsWidget->ApplicationVersionLineedit->setEnabled(false);
}

void PreferencesDialog::IkeGroupToggled(bool)
{
    if (GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::cisco) {
        if (ProfileCiscoOptionsWidget->IkeGroupCheckbox->isChecked())
            ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled(true);
        else
            ProfileCiscoOptionsWidget->IkeGroupCombobox->setEnabled(false);
    }
    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::l2tpd_racoon) {
        if (ProfileRacoonOptionsWidget->IkeGroupCheckbox->isChecked())
            ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled(true);
        else
            ProfileRacoonOptionsWidget->DHGroupComboBox->setEnabled(false);

    }
}

void PreferencesDialog::perfectForwardSecurityToggled(bool)
{
    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco) {
        if (ProfileCiscoOptionsWidget->PerfectForwardSecurityCheckbox->isChecked())
            ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(true);
        else
            ProfileCiscoOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(false);
    }
    if (GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon) {
        if (ProfileRacoonOptionsWidget->PerfectForwardSecurityCheckbox->isChecked())
            ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(true);
        else
            ProfileRacoonOptionsWidget->PerfectForwardSecrecyCombobox->setEnabled(false);

    }
}

void PreferencesDialog::singleDesToggled(bool)
{}

void PreferencesDialog::tunnelDeviceTypeChanged(const QString & string)
{
    if (GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::ssh) {
        if (string.toLower() == "tun") {
            ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setText(i18n("Remote IP (virtual):"));
        }
        if (string.toLower() == "tap") {
            ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setText(i18n("Netmask for local IP address:"));
        }
    }
}

void PreferencesDialog::useKwalletToggled(bool)
{
    if (!GeneralOptionsWidget->useKwalletCheckBox->isChecked()) {

        int result = KMessageBox::questionYesNo(this, i18n("Do you really want disable the use of KWallet? KVpnc will save passwords and psk in config file if requested."), i18n("Disable KWallet?"));
        //LogOutput->append( "Result: "+ QString().setNum(result) ) ;
        if (result == 2 || result == 4) {  // No or Cancel
            GeneralOptionsWidget->useKwalletCheckBox->setChecked(true);
            GlobalConfig->useKwallet = true;
        }
        if (result == 3) //Yes
            GlobalConfig->useKwallet = false;

    }
}

void PreferencesDialog::dpdToggled(bool)
{
    if (ProfileCiscoOptionsWidget->EnableDpdIdleTimeoutCheckbox->isChecked())
        ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->setEnabled(true);
    else
        ProfileCiscoOptionsWidget->DpdIdleTimeoutSpinbox->setEnabled(false);
}

void PreferencesDialog::useXauthToggled(bool)
{
    if (ProfileIpsecOptionsWidget->UseXauthCheckBox->isChecked()) {
        ProfileUserOptionsWidget->setEnabled(true);
        ProfilePskOptionsWidget->setEnabled(true);
        ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setEnabled(true);
        ProfileIpsecOptionsWidget->LocalIDLineEdit->setEnabled(true);
        ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentIndex(4); // keyid
    } else {
        ProfileUserOptionsWidget->setEnabled(false);
        ProfilePskOptionsWidget->setEnabled(false);
        ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setEnabled(true);
        ProfileIpsecOptionsWidget->LocalIDLineEdit->setEnabled(false);
		ProfileIpsecOptionsWidget->LocalIdTypeCombobox->setCurrentIndex(1); // asn1dn
    }
}

void PreferencesDialog::natModeToggled( const QString &)
{
	if (ProfileCiscoOptionsWidget->CiscoNatModeComboBox->currentText() == "none")
	{
		ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked(false);
	}
	else
	{
		ProfileNetworkNatOptionsWidget->UseNatCheckbox->setChecked(true);
	}
}

void PreferencesDialog::useCiscoCertStoreToggled(bool)
{
	if (ProfileCertOptionsWidget->UseCiscoCertStoreCheckBox->isChecked())	
	{
		ProfileCertOptionsWidget->x509certComboBox->show();
		ProfileCertOptionsWidget->x509certURLRequester->hide();
		ProfileCertOptionsWidget->CaCertpathComboBox->show();
		ProfileCertOptionsWidget->CaCertpathURLRequester->hide();
		ProfileCertOptionsWidget->certpathURLRequester->hide();
		ProfileCertOptionsWidget->sizeHint();
	}
	else
	{
		ProfileCertOptionsWidget->x509certComboBox->hide();
		ProfileCertOptionsWidget->x509certURLRequester->show();
		ProfileCertOptionsWidget->CaCertpathComboBox->hide();
		ProfileCertOptionsWidget->CaCertpathURLRequester->show();
		ProfileCertOptionsWidget->certpathURLRequester->show();
		ProfileCertOptionsWidget->sizeHint();
	}
}

bool PreferencesDialog::getVpncHasHybridSupport()
{
	bool hasHybridSupport = false;
	ToolInfo *tool;
	for (int i = 0; i < GlobalConfig->ToolList->size(); ++i) {
		tool = GlobalConfig->ToolList->at(i);
		if (tool->Name == "vpnc") {
			GlobalConfig->appendLogEntry ( i18n ( "vpnc capabilities: %1", tool->Capabilities), KVpncEnum::debug );
			if (tool->Capabilities.indexOf(i18n("openssl (certificate) support"),0, Qt::CaseInsensitive) > -1 ) {
				hasHybridSupport = true;
				return hasHybridSupport;
			}
			
		}
	}
	return hasHybridSupport;
}

void PreferencesDialog::slotStatusMsg(const QString &text, int id)
{
    if (!GlobalConfig->statusbar != 0) {
        if (id != ID_FLASH_MSG) {
            GlobalConfig->statusbar->clearMessage();
            GlobalConfig->statusbar->changeItem(text, id);
        } else {
            GlobalConfig->statusbar->showMessage(text, 2000);
        }
    }
}

void PreferencesDialog::slotProfileCreated(QString Name)
{
	ProfileGeneralSelector->addItem( Name );
	ProfileNetworkRouteSelector->addItem( Name );
	ProfileNetworkNatSelector->addItem( Name );
	ProfileNetworkHttpProxySelector->addItem( Name );
	ProfileNetworkVirtualIpSelector->addItem( Name );
	ProfileCertSelector->addItem( Name );
	ProfileSmartcardSelector->addItem( Name );
	ProfilePskSelector->addItem( Name );
	ProfileUserSelector->addItem( Name );
	ProfileOpenvpnSelector->addItem( Name );
	ProfilePptpSelector->addItem( Name );
	ProfileVtunSelector->addItem( Name );
	ProfileSshSelector->addItem( Name );
	ProfileRacoonSelector->addItem( Name );
	ProfileIpsecSelector->addItem( Name );
	ProfileCiscoSelector->addItem( Name );
	ProfileCmdExecBeforeConnectSelector->addItem( Name );
	ProfileCmdExecBeforeDisconnectSelector->addItem( Name );
	ProfileCmdExecAfterConnectSelector->addItem( Name );
	ProfileCmdExecAfterDisconnectSelector->addItem( Name );
	
	ProfileGeneralSelector->model()->sort(0);
	ProfileAuthenticationSelector->model()->sort(0);
	ProfileUserSelector->model()->sort(0);
	ProfileCertSelector->model()->sort(0);
	ProfileSmartcardSelector->model()->sort(0);
	ProfilePskSelector->model()->sort(0);
	ProfileNetworkGeneralSelector->model()->sort(0);
	ProfileNetworkRouteSelector->model()->sort(0);
	ProfileNetworkNatSelector->model()->sort(0);
	ProfileNetworkHttpProxySelector->model()->sort(0);
	ProfileNetworkVirtualIpSelector->model()->sort(0);
	ProfileSpecificSelector->model()->sort(0);
	ProfileCiscoSelector->model()->sort(0);
	ProfileRacoonSelector->model()->sort(0);
	ProfileIpsecSelector->model()->sort(0);
	ProfileOpenvpnSelector->model()->sort(0);
	ProfilePptpSelector->model()->sort(0);
	ProfileVtunSelector->model()->sort(0);
	ProfileSshSelector->model()->sort(0);
	ProfileCommandExecSelector->model()->sort(0);
	ProfileCmdExecBeforeConnectSelector->model()->sort(0);
	ProfileCmdExecAfterConnectSelector->model()->sort(0);
	ProfileCmdExecBeforeDisconnectSelector->model()->sort(0);
	ProfileCmdExecAfterDisconnectSelector->model()->sort(0);
	
	
	profileChanged( Name );
}

