/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_PREDEFINED_ACTION
#define UBUNTU_HUD_PREDEFINED_ACTION

#include "action.h"

namespace Ubuntu {
namespace HUD {
    class PredefinedAction;
}
}

class Ubuntu::HUD::PredefinedAction : public Ubuntu::HUD::Action
{
    Q_OBJECT
    Q_DISABLE_COPY(PredefinedAction)

    class Private;

protected:
    PredefinedAction(QObject *parent = 0);

public:
    virtual void setIdentifier(const QString &identifier);
    virtual void setLabel(const QString &label);
    virtual void setDescription(const QString &description);
    virtual void setKeywords(QString keywords);
    virtual void setIsBackgroundAction(bool value);
    virtual void setEnabled(bool value);
    virtual void setCommitLabel(const QString &label);
    virtual void setHasLivePreview(bool value);
    virtual void setHasNoPreview(bool value);
    virtual void setRequiresPreview(bool value);
    virtual void addParameter(Parameter *parameter);
    virtual void removeParameter(Parameter *parameter);

private:
    Private *d;
};

#endif // UBUNTU_HUD_PREDEFINED_ACTION
