package Tk::MhColorChooser;

use 5.008008;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

use Tk;
use Tk::Balloon;
use Tk::Pane;

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

our @EXPORT_OK = qw(color_chooser);

our $VERSION = '0.01';

##############################################################
# color_chooser - open a window and offer some colors to select
##############################################################
sub color_chooser {

my $w = shift;  # parent Tk widget (e.g. main window)
my $additional_colors = shift; # list reference (optional)

my @all_colors = qw/black gray10 gray20 gray30 gray40 gray50 gray60 gray70 gray80 gray85 gray90
gray95 white snow2 snow3 snow4 seashell1 seashell2 seashell3 seashell4
AntiqueWhite1 AntiqueWhite2 AntiqueWhite3 AntiqueWhite4 bisque1
bisque2 bisque3 bisque4 PeachPuff1 PeachPuff2 PeachPuff3 PeachPuff4
NavajoWhite1 NavajoWhite2 NavajoWhite3 NavajoWhite4 LemonChiffon1
LemonChiffon2 LemonChiffon3 LemonChiffon4 cornsilk1 cornsilk2
cornsilk3 cornsilk4 ivory1 ivory2 ivory3 ivory4 honeydew1 honeydew2
honeydew3 honeydew4 LavenderBlush1 LavenderBlush2 LavenderBlush3
LavenderBlush4 MistyRose1 MistyRose2 MistyRose3 MistyRose4 azure1
azure2 azure3 azure4 SlateBlue1 SlateBlue2 SlateBlue3 SlateBlue4
RoyalBlue1 RoyalBlue2 RoyalBlue3 RoyalBlue4 blue1 blue2 blue3 blue4
DodgerBlue1 DodgerBlue2 DodgerBlue3 DodgerBlue4 SteelBlue1 SteelBlue2
SteelBlue3 SteelBlue4 DeepSkyBlue1 DeepSkyBlue2 DeepSkyBlue3
DeepSkyBlue4 SkyBlue1 SkyBlue2 SkyBlue3 SkyBlue4 LightSkyBlue1
LightSkyBlue2 LightSkyBlue3 LightSkyBlue4 SlateGray1 SlateGray2
SlateGray3 SlateGray4 LightSteelBlue1 LightSteelBlue2 LightSteelBlue3
LightSteelBlue4 LightBlue1 LightBlue2 LightBlue3 LightBlue4 LightCyan1
LightCyan2 LightCyan3 LightCyan4 PaleTurquoise1 PaleTurquoise2
PaleTurquoise3 PaleTurquoise4 CadetBlue1 CadetBlue2 CadetBlue3
CadetBlue4 turquoise1 turquoise2 turquoise3 turquoise4 cyan1 cyan2
cyan3 cyan4 DarkSlateGray1 DarkSlateGray2 DarkSlateGray3
DarkSlateGray4 aquamarine1 aquamarine2 aquamarine3 aquamarine4
DarkSeaGreen1 DarkSeaGreen2 DarkSeaGreen3 DarkSeaGreen4 SeaGreen1
SeaGreen2 SeaGreen3 SeaGreen4 PaleGreen1 PaleGreen2 PaleGreen3
PaleGreen4 SpringGreen1 SpringGreen2 SpringGreen3 SpringGreen4 green1
green2 green3 green4 chartreuse1 chartreuse2 chartreuse3 chartreuse4
OliveDrab1 OliveDrab2 OliveDrab3 OliveDrab4 DarkOliveGreen1
DarkOliveGreen2 DarkOliveGreen3 DarkOliveGreen4 khaki1 khaki2 khaki3
khaki4 LightGoldenrod1 LightGoldenrod2 LightGoldenrod3 LightGoldenrod4
LightYellow1 LightYellow2 LightYellow3 LightYellow4 yellow1 yellow2
yellow3 yellow4 gold1 gold2 gold3 gold4 goldenrod1 goldenrod2
goldenrod3 goldenrod4 DarkGoldenrod1 DarkGoldenrod2 DarkGoldenrod3
DarkGoldenrod4 RosyBrown1 RosyBrown2 RosyBrown3 RosyBrown4 IndianRed1
IndianRed2 IndianRed3 IndianRed4 sienna1 sienna2 sienna3 sienna4
burlywood1 burlywood2 burlywood3 burlywood4 wheat1 wheat2 wheat3
wheat4 tan1 tan2 tan3 tan4 chocolate1 chocolate2 chocolate3 chocolate4
firebrick1 firebrick2 firebrick3 firebrick4 brown1 brown2 brown3
brown4 salmon1 salmon2 salmon3 salmon4 LightSalmon1 LightSalmon2
LightSalmon3 LightSalmon4 orange1 orange2 orange3 orange4 DarkOrange1
DarkOrange2 DarkOrange3 DarkOrange4 coral1 coral2 coral3 coral4
tomato1 tomato2 tomato3 tomato4 OrangeRed1 OrangeRed2 OrangeRed3
OrangeRed4 red1 red2 red3 red4 DeepPink1 DeepPink2 DeepPink3 DeepPink4
HotPink1 HotPink2 HotPink3 HotPink4 pink1 pink2 pink3 pink4 LightPink1
LightPink2 LightPink3 LightPink4 PaleVioletRed1 PaleVioletRed2
PaleVioletRed3 PaleVioletRed4 maroon1 maroon2 maroon3 maroon4
VioletRed1 VioletRed2 VioletRed3 VioletRed4 magenta1 magenta2 magenta3
magenta4 orchid1 orchid2 orchid3 orchid4 plum1 plum2 plum3 plum4
MediumOrchid1 MediumOrchid2 MediumOrchid3 MediumOrchid4 DarkOrchid1
DarkOrchid2 DarkOrchid3 DarkOrchid4 purple1 purple2 purple3 purple4
MediumPurple1 MediumPurple2 MediumPurple3 MediumPurple4 thistle1
thistle2 thistle3 thistle4/;

  my $title = 'Please select a color';

  # open window
  my $win = $w->Toplevel();
  # we need a fixed font for a nice layout in the balloon tooltips
  my $font = $win->Font(-family => 'Courier', -size => 8);
  my $balloon = $win->Balloon(-bg => 'gray90', -initwait => 1000, -font => $font);
  $balloon->Subwidget('message')->configure(-justify => 'left');
  $win->{balloon} = $balloon;
  $win->withdraw;
  $win->title($title);
  #$win->iconimage($icon) if $icon;
  $win->iconname($title);
  my $return_color = 0;
  if ((defined $additional_colors) and  @{$additional_colors}) {
    $win->Label(-text => 'Preselected colors')->pack(-padx => 0, -pady => 0);
    add_color_buttons($win, $additional_colors, \$return_color, 27, 'left');
    # my $colorFB = $win->Frame()->pack(-fill => 'both', -expand => 1);
    # foreach (@{$additional_colors}) {
      # my $but;
      # $but =
        # $colorFB->Button(
             # -text       => ' ',
             # -height     => 0,
             # -width      => 0,
             # -padx       => 0,
             # -pady       => 0,
             # -relief     => 'groove',
             # -background => $_,
             # -command    => sub {
               # my $col = $but->cget(-bg);
                 # $return_color = $col;
             # }
            # )->pack(-padx => 0, -pady => 0, -side => 'left');
      # $balloon->attach($but, -msg => $_);
    # }
    # label only needed when additional colors are defined
    $win->Label(-text => 'Other colors')->pack(-padx => 0, -pady => 0);
  }
  
  add_color_buttons($win, \@all_colors, \$return_color, 12, 'top');
  # my $colorF = $win->Frame()->pack(-fill => 'both', -expand => 1);
  # my $i = 0;
  # foreach (@all_colors) {
	  # $i++;
	  # if ($i == 1 or $i % 12 == 1) { # a frame for the first and every 12th button (modulo)
	    # $frame = $colorF->Frame()->pack(-side => 'left', -anchor => 'n');
	  # }
	  # my $but;
	  # $but =
	    # $frame->Button(
					 # -text       => ' ',
					 # -height     => 0,
					 # -width      => 0,
					 # -padx       => 0,
					 # -pady       => 0,
					 # -relief     => 'groove',
					 # -background => $_,
					 # -command    => sub {
					   # my $col = $but->cget(-bg);
				       # $return_color = $col;
					 # }
					# )->pack(-padx => 0, -pady => 0);
	  # $balloon->attach($but, -msg => $_);
  # }

  my $xBut = $win->Button(-text => 'Close',
                          -command => sub {
                                      print "returning: undef\n";
                                      $return_color = undef;
                                     },)->pack(-fill => 'x');

  # 50 ways to leave your window ;)
  $win->bind('<Key-Escape>'          , sub {$xBut->invoke;});
  $win->bind('<Key-q>'               , sub {$xBut->invoke;});
  $win->protocol("WM_DELETE_WINDOW" => sub {$xBut->invoke;} );


  $xBut->focus;
  $win->Popup;
  #repositionWindow($win);
  $win->waitVariable(\$return_color);
  $win->withdraw;
  $win->destroy;
  return $return_color;
}

##############################################################
##############################################################
sub add_color_buttons {
  my $w = shift; # parent widget
  my $colors = shift; # list reference
  my $return_color = shift; # scalar reference
  my $modulo = shift; # number of buttons in a row or column
  my $top_or_left = shift; # string: color buttons in rows ('left') or in columns ('top')
  my $side = 'top';
  $side = 'left' if ($top_or_left eq 'top');
  my $frame;
  my $colorF = $w->Frame()->pack(-fill => 'both', -expand => 1);
  my $i = 0;
  foreach (@{$colors}) {
	  $i++;
	  if ($i == 1 or $i % $modulo == 1) { # a frame for the first and every 12th button (modulo)
	    $frame = $colorF->Frame()->pack(-side => $side, -anchor => 'n');
	  }
	  my $but;
	  $but =
	    $frame->Button(
					 -text       => ' ',
					 -height     => 0,
					 -width      => 0,
					 -padx       => 0,
					 -pady       => 0,
					 -relief     => 'groove',
					 -background => $_,
					 -command    => sub {
					   my $col = $but->cget(-bg);
				       $$return_color = $col;
					 }
					)->pack(-side => $top_or_left, -padx => 0, -pady => 0);
	  $w->{balloon}->attach($but, -msg => $_);
  }
}

##############################################################
##############################################################

# Preloaded methods go here.

1;
__END__

=head1 NAME

Tk::MhColorChooser - Perl/Tk user interface (dialog window)
to choose a color from a given set of colors

=head1 SYNOPSIS

  # simple usage
  use Tk::MhColorChooser qw(color_chooser);
  my $color = color_chooser($top);
  if (defined $color) {
    print "Color $color selected\n";
  }
  else {
    print "Nothing selected\n";
  }

  # advanced usage
  use Tk::MhColorChooser qw(color_chooser);
  my @more_colors = ('#707070', '#808080',  '#909090');
  my $color = color_chooser($top, \@more_colors);
  if (defined $color) {
    print "Color $color selected\n";
  }
  else {
    print "Nothing selected\n";
  }
  

=head1 DESCRIPTION

Tk::MhColorChooser provides a simple methode to choose a color.
The only methode color_chooser() opens a window and presents 324 different
colors to choose from. The first argument is used as parent widget for the
window. The optional second argument has to be a
list reference to additional colors (see SYNOPSIS above). These colors are shown
as additional buttons above the default colors.

=head2 EXPORT

None by default.

=head1 SEE ALSO

Tk::ColorEditor from Slaven Rezic

=head1 AUTHOR

Martin Herrmann

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by Martin Herrmann

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.


=cut
