/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.h2;

import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.h2.AxisRange;
import com.carrotsearch.junitbenchmarks.h2.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.h2.GeneratorUtils;
import com.carrotsearch.junitbenchmarks.h2.H2Consumer;
import com.carrotsearch.junitbenchmarks.h2.HistoryChartGenerator;
import com.carrotsearch.junitbenchmarks.h2.IChartAnnotationVisitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HistoryChartVisitor
implements IChartAnnotationVisitor {
    private HashMap<Class<?>, List<Method>> types = new HashMap();

    HistoryChartVisitor() {
    }

    @Override
    public void visit(Class<?> clazz, Method method, Result result) {
        boolean onMethod = method.isAnnotationPresent(BenchmarkHistoryChart.class);
        boolean onClass = clazz.isAnnotationPresent(BenchmarkHistoryChart.class);
        if (onMethod || onClass) {
            if (!this.types.containsKey(clazz)) {
                this.types.put(clazz, new ArrayList());
            }
            if (onMethod) {
                this.types.get(clazz).add(method);
            }
        }
    }

    @Override
    public void generate(H2Consumer c) throws Exception {
        for (Map.Entry<Class<?>, List<Method>> e : this.types.entrySet()) {
            Class<?> clazz = e.getKey();
            List<Method> methods = e.getValue();
            BenchmarkHistoryChart ann = clazz.getAnnotation(BenchmarkHistoryChart.class);
            if (ann != null) {
                HistoryChartGenerator gen = new HistoryChartGenerator(c.getConnection(), GeneratorUtils.getFilePrefix(clazz, ann.filePrefix(), c.chartsDir), clazz.getName(), ann.labelWith());
                gen.updateMaxRuns(ann.maxRuns());
                this.updateMinMax(clazz.getAnnotation(AxisRange.class), gen);
                gen.generate();
            }
            HashMap byPrefix = new HashMap();
            for (Method method : methods) {
                BenchmarkHistoryChart methodAnn = method.getAnnotation(BenchmarkHistoryChart.class);
                String prefix = GeneratorUtils.getFilePrefix(clazz, methodAnn.filePrefix(), c.chartsDir);
                if (!byPrefix.containsKey(prefix)) {
                    byPrefix.put(prefix, new ArrayList());
                }
                ((List)byPrefix.get(prefix)).add(method);
            }
            if (ann != null) {
                byPrefix.remove(GeneratorUtils.getFilePrefix(clazz, ann.filePrefix(), c.chartsDir));
            }
            for (Map.Entry entry : byPrefix.entrySet()) {
                HistoryChartGenerator gen = new HistoryChartGenerator(c.getConnection(), (String)entry.getKey(), clazz.getName(), ((Method)((List)entry.getValue()).get(0)).getAnnotation(BenchmarkHistoryChart.class).labelWith());
                for (Method m : (List)entry.getValue()) {
                    gen.updateMaxRuns(m.getAnnotation(BenchmarkHistoryChart.class).maxRuns());
                    this.updateMinMax(m.getAnnotation(AxisRange.class), gen);
                    gen.includeMethod(m.getName());
                }
                gen.generate();
            }
        }
    }

    private void updateMinMax(AxisRange ann, HistoryChartGenerator gen) {
        if (ann != null) {
            gen.updateMinMax(ann);
        }
    }
}

