####################################################################################################################################
# Base IO Module
####################################################################################################################################
package pgBackRestTest::Common::Io::Base;

use strict;
use warnings FATAL => qw(all);
use Carp qw(confess);
use English '-no_match_vars';

use Exporter qw(import);
    our @EXPORT = qw();
use Scalar::Util qw(blessed);

use pgBackRestDoc::Common::Log;

####################################################################################################################################
# Package name constant
####################################################################################################################################
use constant COMMON_IO_BASE                                         => __PACKAGE__;
    push @EXPORT, qw(COMMON_IO_BASE);

####################################################################################################################################
# Default buffer max
####################################################################################################################################
use constant COMMON_IO_BUFFER_MAX                                   => 4194304;
    push @EXPORT, qw(COMMON_IO_BUFFER_MAX);

####################################################################################################################################
# new
####################################################################################################################################
sub new
{
    my $class = shift;

    # Create the class hash
    my $self = {};
    bless $self, $class;

    # Assign function parameters, defaults, and log debug info
    (
        my $strOperation,
        $self->{strId},
    ) =
        logDebugParam
        (
            __PACKAGE__ . '->new', \@_,
            {name => 'strId', trace => true},
        );

    # Return from function and log return values if any
    return logDebugReturn
    (
        $strOperation,
        {name => 'self', value => $self}
    );
}

####################################################################################################################################
# error - throw errors
####################################################################################################################################
sub error
{
    my $self = shift;
    my $iCode = shift;
    my $strMessage = shift;
    my $strDetail = shift;

    logErrorResult($iCode, $strMessage, $strDetail);
}

####################################################################################################################################
# result - retrieve a result from io or a filter
####################################################################################################################################
sub result
{
    my $self = shift;
    my $strModule = shift;

    if (!defined($strModule))
    {
        return $self->{rhResult};
    }

    return $self->{rhResult}{$strModule};
}

####################################################################################################################################
# resultAll - get all results
####################################################################################################################################
sub resultAll
{
    shift->{rhResult};
}

####################################################################################################################################
# resultSet - set a result from io or a filter
####################################################################################################################################
sub resultSet
{
    my $self = shift;
    my $strModule = shift;
    my $xResult = shift;

    $self->{rhResult}{$strModule} = $xResult;
}

####################################################################################################################################
# Getters
####################################################################################################################################
sub className {blessed(shift)}
sub id {shift->{strId}}

1;
