% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_firstobs_lastobs.R
\name{firstlastobs}
\alias{firstlastobs}
\alias{lastobs}
\alias{firstobs}
\alias{firstobs.default}
\alias{lastobs.default}
\alias{firstobs.formula}
\alias{lastobs.formula}
\title{Locate the index of the first/last unique value}
\usage{
lastobs(x, ...)

firstobs(x, ...)

\method{lastobs}{default}(x, ...)

\method{firstobs}{default}(x, ...)

\method{lastobs}{formula}(formula, data = parent.frame(), ...)

\method{firstobs}{formula}(formula, data = parent.frame(), ...)
}
\arguments{
\item{x}{A vector}

\item{\dots}{Currently not used}

\item{formula}{A formula (only the first term is used, see 'details').}

\item{data}{A data frame}
}
\value{
A vector.
}
\description{
Locate the index of the first/last unique value in i) a vector
or of a variable in a data frame.
}
\details{
If writing ~a + b + c as formula, then only a is considered.
}
\examples{
x <- c(rep(1, 5), rep(2, 3), rep(3, 7), rep(1, 4))
firstobs(x)
lastobs(x)
data(dietox)
firstobs(~Pig, data=dietox)
lastobs(~Pig, data=dietox)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{data_handling}
\keyword{utilities}
