/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.HexNumberFormat;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;

public class RegDWordValue
extends RegistryValue {
    int data;
    int dataLen;

    public RegDWordValue(RegistryKey registryKey, String string) {
        super(registryKey, string, 4);
        this.data = 0;
        this.dataLen = 0;
    }

    public RegDWordValue(RegistryKey registryKey, String string, int n) {
        super(registryKey, string, n);
        this.data = 0;
        this.dataLen = 0;
    }

    public RegDWordValue(RegistryKey registryKey, String string, int n, int n2) {
        super(registryKey, string, 4);
        this.setData(n2);
    }

    public int getData() {
        return this.data;
    }

    public int getLength() {
        return this.dataLen;
    }

    public void setData(int n) {
        this.data = n;
        this.dataLen = 1;
    }

    @Override
    public byte[] getByteData() {
        byte[] byArray = new byte[]{(byte)(this.data >> 24 & 0xFF), (byte)(this.data >> 16 & 0xFF), (byte)(this.data >> 8 & 0xFF), (byte)(this.data & 0xFF)};
        return byArray;
    }

    @Override
    public int getByteLength() {
        return 4;
    }

    @Override
    public void setByteData(byte[] byArray) {
        int n = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
        this.setData(n);
    }

    @Override
    public void export(PrintWriter printWriter) {
        printWriter.print("\"" + this.getName() + "\"=");
        HexNumberFormat hexNumberFormat = new HexNumberFormat("xxxxxxxx");
        printWriter.println("dword:" + hexNumberFormat.format(this.getData()));
    }
}

