/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.videolan.BDJUtil;
import org.videolan.Logger;
import org.videolan.MountException;

public class MountManager {
    private static Map mountPoints = new HashMap();
    private static final Logger logger = Logger.getLogger(MountManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mount(int jarId) throws MountException {
        String jarStr = MountManager.jarIdToString(jarId);
        logger.info("Mounting JAR: " + jarStr);
        if (jarStr == null) {
            throw new IllegalArgumentException();
        }
        Map map = mountPoints;
        synchronized (map) {
            String oldPath = MountManager.getMount(jarId);
            if (oldPath != null) {
                logger.error("JAR " + jarId + " already mounted");
                return oldPath;
            }
            String path = System.getProperty("bluray.vfs.root") + "/BDMV/JAR/" + jarStr + ".jar";
            JarFile jar = null;
            File tmpDir = null;
            try {
                jar = new JarFile(path);
                tmpDir = File.createTempFile("bdj-", "");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MountException();
            }
            tmpDir.delete();
            tmpDir.mkdir();
            try {
                byte[] buffer = new byte[32768];
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    int length;
                    JarEntry entry = entries.nextElement();
                    File out = new File(tmpDir + File.separator + entry.getName());
                    logger.info("   mount: " + entry.getName());
                    if (entry.isDirectory()) {
                        out.mkdirs();
                        continue;
                    }
                    out.getParentFile().mkdirs();
                    InputStream inStream = jar.getInputStream(entry);
                    FileOutputStream outStream = new FileOutputStream(out);
                    while ((length = inStream.read(buffer)) > 0) {
                        ((OutputStream)outStream).write(buffer, 0, length);
                    }
                    inStream.close();
                    ((OutputStream)outStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                MountManager.recursiveDelete(tmpDir);
                throw new MountException();
            }
            logger.info("Mounting JAR " + jarId + " complete.");
            mountPoints.put(new Integer(jarId), tmpDir);
            return tmpDir.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmount(int jarId) {
        File mountPoint;
        logger.info("Unmounting JAR: " + jarId);
        Integer id = new Integer(jarId);
        Map map = mountPoints;
        synchronized (map) {
            mountPoint = (File)mountPoints.remove(id);
        }
        if (mountPoint != null) {
            MountManager.recursiveDelete(mountPoint);
        } else {
            logger.info("JAR " + jarId + " not mounted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmountAll() {
        Object[] dirs;
        logger.info("Unmounting all JARs");
        Map map = mountPoints;
        synchronized (map) {
            dirs = mountPoints.values().toArray();
            mountPoints.clear();
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                MountManager.recursiveDelete((File)dirs[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMount(int jarId) {
        File mountPoint;
        Integer id = new Integer(jarId);
        Map map = mountPoints;
        synchronized (map) {
            mountPoint = (File)mountPoints.get(id);
        }
        if (mountPoint != null) {
            return mountPoint.getAbsolutePath();
        }
        logger.info("JAR " + jarId + " not mounted");
        return null;
    }

    private static String jarIdToString(int jarId) {
        if (jarId < 0 || jarId > 99999) {
            return null;
        }
        return BDJUtil.makeFiveDigitStr(jarId);
    }

    private static void recursiveDelete(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                MountManager.recursiveDelete(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }
}

