/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.dvb.ui.FontNotAvailableException;
import org.videolan.BDJUtil;
import org.videolan.FontIndex;
import org.videolan.FontIndexData;
import org.videolan.Logger;

public class FontFactory {
    private Font urlFont = null;
    private Map fonts = null;
    private static final Logger logger = Logger.getLogger(FontFactory.class.getName());

    public static void loadDiscFonts() {
        FontFactory.unloadDiscFonts();
    }

    public static void unloadDiscFonts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontFactory() throws FontFormatException, IOException {
        String path = BDJUtil.discRootToFilesystem("/BDMV/AUXDATA/dvb.fontindex");
        FontIndexData[] fontIndexData = FontIndex.parseIndex(path);
        this.fonts = new HashMap(fontIndexData.length);
        for (int i = 0; i < fontIndexData.length; ++i) {
            FontIndexData data = fontIndexData[i];
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(BDJUtil.discRootToFilesystem("/BDMV/AUXDATA/" + data.getFileName()));
                Font font = Font.createFont(0, inStream);
                font = font.deriveFont(data.getStyle(), data.getMaxSize());
                this.fonts.put(data.getName(), font);
                continue;
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontFactory(URL u) throws IOException, FontFormatException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(u.getPath());
            this.urlFont = Font.createFont(0, inStream);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public Font createFont(String name, int style, int size) throws FontNotAvailableException, FontFormatException, IOException {
        logger.info("Creating font: " + name + " " + style + " " + size);
        if (this.urlFont != null && name.equals(this.urlFont.getName())) {
            return this.urlFont.deriveFont(style, size);
        }
        Font font = (Font)this.fonts.get(name);
        if (font == null) {
            logger.info("Failed creating font: " + name + " " + style + " " + size);
            throw new FontNotAvailableException();
        }
        return font.deriveFont(style, size);
    }
}

