/* display.c, X11 interface                                                 */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */


#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>                        /* on BSD, uio.h needs types.h */
#include <sys/uio.h>
#include <X11/Xlib.h>

#include "threads.h"
#include "config.h"
#include "common.h"
#include "mtime.h"
#include "plugins.h"

#include "intf_msg.h"
#include "debug.h"
#include "input.h"
#include "input_netlist.h"
#include "decoder_fifo.h"
#include "video.h"
#include "video_output.h"
#include "video_decoder.h"
#include "main.h"
#include "interface.h"
#include "global.h"

void Initialize_Display_Process(name)
char *name;
{
}

void Terminate_Display_Process()
{
}

void Display_First_Field(void) { /* nothing */ }
void Display_Second_Field(void) { /* nothing */ }

void do_display(unsigned char *src[])
{
    /* Temporary kludge to send calculated pictures to video output thread */
    vout_thread_t *     p_vout = p_main->p_intf->p_vout;
    picture_t *         p_pic;
    int                 i_type;

    /* Create picture */
    switch( chroma_format )
    {
    case CHROMA420:
        i_type = YUV_420_PICTURE;
        break;
    case CHROMA422:
        i_type = YUV_422_PICTURE;
        break;
    case CHROMA444:
    default:
        i_type = YUV_444_PICTURE;
        break;
    }
    do
    {
        p_pic = vout_CreatePicture( p_vout, i_type,
                                    Coded_Picture_Width,
                                    Coded_Picture_Height );
        if( p_pic == NULL )
        {
            msleep( 100000 );
        }
    }while( p_pic == NULL );

    /* Fill picture informations */
    p_pic->i_matrix_coefficients = matrix_coefficients;
    p_pic->i_display_horizontal_offset = frame_center_horizontal_offset[0];
    p_pic->i_display_vertical_offset = frame_center_vertical_offset[0];
    p_pic->i_display_width = display_horizontal_size;
    p_pic->i_display_height = display_vertical_size;
    p_pic->i_aspect_ratio = aspect_ratio_information;

    memcpy( p_pic->p_y, src[0],
            Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) );
    switch( chroma_format )
    {
    case CHROMA420:
        memcpy( p_pic->p_u, src[1],
                Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) / 4 );
        memcpy( p_pic->p_v, src[2],
                Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) / 4 );
        break;
    case CHROMA422:
        memcpy( p_pic->p_u, src[1],
                Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) / 2 );
        memcpy( p_pic->p_v, src[2],
                Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) / 2 );
        break;
    case CHROMA444:
        memcpy( p_pic->p_u, src[1],
                Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) );
        memcpy( p_pic->p_v, src[2],
                Coded_Picture_Width * Coded_Picture_Height * sizeof( yuv_data_t ) );
        break;
    }

    /* Send display order */
    vout_DisplayPicture( p_vout, p_pic );
    vout_DatePicture( p_vout, p_pic, mdate() + 30000 );

    /* Synchronisation */
    if (picture_coding_type == I_TYPE)
    {
        s64 show_date;
        int temp = kludge_level;

        kludge_nbp = kludge_p ? kludge_p : 5;
        kludge_nbb = kludge_b ? kludge_b : 6;
        show_date = kludge_date + (kludge_nbframes*1000000*frame_rate) - mdate();
        kludge_p = 0;
        kludge_b = 0;

        if (show_date < -SYNC_TOLERATE && show_date <= kludge_prevdate)
        {
            kludge_level--;
            if (kludge_level < 0)
                kludge_level = 0;
            else if (kludge_level > kludge_nbp + kludge_nbb)
                kludge_level = kludge_nbp + kludge_nbb;
#ifdef DEBUG
            if (temp != kludge_level)
                intf_DbgMsg("vdec debug: Level changed from %d to %d (%Ld)\n",
                            temp, kludge_level, show_date );
#endif
        }
        else if (show_date > SYNC_TOLERATE && show_date >= kludge_prevdate)
        {
            kludge_level++;
            if (kludge_level > kludge_nbp + kludge_nbb)
                kludge_level = kludge_nbp + kludge_nbb;
#ifdef DEBUG
            if (temp != kludge_level)
                intf_DbgMsg("vdec debug: Level changed from %d to %d (%Ld)\n",
                            temp, kludge_level, show_date );
#endif
        }

        kludge_prevdate = show_date;
        if ((kludge_level - kludge_nbp) > kludge_nbb)
            kludge_level = kludge_nbb + kludge_nbp;
    }
}

