/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
/*!
        \file
        \version \$Id: mkxPrioFrame.h,v 1.2 2003/06/21 08:32:27 robux4 Exp $
        \author Steve Lhomme     <robux4 @ users.sf.net>
*/

#ifndef MKXDS_MKX_PRIO_FRAME_H
#define MKXDS_MKX_PRIO_FRAME_H

#include "KaxBlock.h"
#include "KaxBlockData.h"

#include <map>

using namespace LIBMATROSKA_NAMESPACE;

/*!
	\class MkxPrioBuffer
*/
class MkxPrioBuffer {
public:
	MkxPrioBuffer(KaxBlockGroup & aBlock)
		:Block(&aBlock)
		,Displayed(false)
	{
		KaxReferencePriority & RefPrio = GetChild<KaxReferencePriority>(aBlock);
		Priority = uint8(RefPrio);
		Timecode = aBlock.GlobalTimecode();
	}

	MkxPrioBuffer & operator=(const MkxPrioBuffer & aBuffer)
	{
		Block     = aBuffer.Block;
		Priority  = aBuffer.Priority;
		Timecode  = aBuffer.Timecode;
		Displayed = aBuffer.Displayed;
		return *this;
	}

	KaxBlockGroup * Block;
	uint8           Priority; ///< used to speed access to this value
	uint64          Timecode; ///< used to speed access to this value
	bool            Displayed;
};

class MkxPrioKey {
public:
	MkxPrioKey(MkxPrioBuffer & aBuf)
		:Elt(aBuf)
	{}

	bool operator<(const MkxPrioKey &aKey) const
	{
		return (Elt.Timecode < aKey.Elt.Timecode);
	}
	
	MkxPrioBuffer & Elt;
};

/*!
	\class MkxPrioCache
*/
class MkxPrioCache : public CCritSec {
public:
	MkxPrioCache(unsigned int MinCache);
	~MkxPrioCache();

	void PushBlock(KaxBlockGroup & aBlock);

	KaxBlockGroup * GetElementInTimeOrder();

	KaxBlockGroup * GetNextInTimeOrder(KaxBlockGroup & aBlock);

	void UsedBlock(KaxBlockGroup & aBlock);

	void Flush() {
		Lock();
		NOTE("MkxPrioCache::Flush");
		BufferList.clear();
		Unlock();
	}

protected:
	std::map<MkxPrioKey, MkxPrioBuffer> BufferList;
	HANDLE                              PopEnabled;
	unsigned int                        MinCache;
};

#endif // MKXDS_MKX_PRIO_FRAME_H

