/* 
 * file : linux/glibfunc.c
 * author : JC Hoelt <jeko@free.fr>
 *
 * birth : 2001-03-03 13:42
 * version : 2001-03-03 14:10
 *
 * content : the function to manipulate the time, etc.
 */

#include "gmtimer.h"
#ifndef WIN32
#include <glib.h>
#else
#include <windows.h>
#include <stdlib.h>
#endif

/************** functions **************/

/* initialize the timer. do nothing if the timer has ever been initialized */
GMTimer *
gmtimer_new ()
{
#ifndef WIN32
	GTimer *goom_timer = g_timer_new ();

	g_timer_start (goom_timer);
#else
  LARGE_INTEGER tvstart,tvfreq;
  GMTimer *goom_timer = (GMTimer *)malloc(sizeof(GMTimer));
  QueryPerformanceFrequency(&tvfreq);
  QueryPerformanceCounter(&tvstart);
  goom_timer->fStart=(double)tvstart.QuadPart;
  if (tvfreq.QuadPart != 0) {
	goom_timer->fFreq=(double)tvfreq.QuadPart;
  } else {
	  goom_timer->fFreq = -1.0;
  }
#endif
	return (GMTimer *) goom_timer;
}

/* close the timer. do nothing if the timer hasn't been initialized */
void
gmtimer_delete (GMTimer ** t)
{
#ifndef WIN32
	GTimer *goom_timer = *(GTimer **) t;

	g_timer_stop (goom_timer);
	g_free (goom_timer);
#else
  free(*t);
#endif
	*t = 0;
}

/* return the number of seconds since the initialization of the timer */
float
gmtimer_getvalue (GMTimer * t)
{
#ifndef WIN32
	return g_timer_elapsed ((GTimer *) t, NULL);
#else
	GMTimer *goom_timer = (GMTimer *)t;
	if (goom_timer->fFreq > 0.0f) {
		LARGE_INTEGER tvnow;
		QueryPerformanceCounter(&tvnow);
		return (float)(((double)tvnow.QuadPart - goom_timer->fStart)/goom_timer->fFreq);
	} else {
		return 0.0f;
	}
#endif
}
